<?php
/**
 * All actions and filters
 */

// Prepare purchase code for Install and Notify Box
function datebook_prepare_purchase_code() {

	if(isset($_GET['page']) && $_GET['page'] != 'datebook-options-install' && $_GET['page'] != 'datebook-countries-installer') {

   	?>

	<div class='notice notice-warning' style="">
		<h1><?php echo esc_html__( 'Attention! Prepare your purchase code before activating the plugin!', 'datebook' ); ?></h1>
		<p><?php echo esc_html__( 'DateBook requires a purchase code in order to be fully functional. You can find your purchase code in the Download section in your account on ThemeForest.', 'datebook' ); ?></p>
		
		<p><?php $line_to_purchase_code_themeforest_help = sprintf('<a target="_blank" href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-">%s</a>', esc_html__('where you can find your purchase code', 'datebook'));
		echo ' '. sprintf( esc_html__( 'Read here %s.' ), $line_to_purchase_code_themeforest_help ); ?></p>

		<p><?php echo esc_html__( 'If you activate the DateBook plugin but do not enter the purchase code, the main functions of the theme will stop working.', 'datebook' ); ?></p>

		</div>

	<?php
	
	}

}
if(get_option('datebook_activation_code') != true) {
	add_action('admin_notices', 'datebook_prepare_purchase_code');
}
		
// Get current user ID
function datebook_get_current_user() {

	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);

	define('DATEBOOK_CURRENT_USER_ID', $current_user_id);

}
if( !defined('DATEBOOK_POST_TYPE') && class_exists( 'DateBook' ) ) {
	add_action( 'init', 'datebook_get_current_user' );
}


// Our hooked in function - $fields is passed via the filter!
function custom_override_checkout_fields( $fields ) {
     unset($fields['billing']['billing_company']);
	 unset($fields['billing']['billing_phone']);
	 unset($fields['billing']['billing_email']);

     return $fields;
}
//add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );


function remove_continue_shoppping_button($message, $products) {
    if (strpos($message, 'Continue shopping') !== false) {
        return preg_replace('/<a.*<\/a>/m','', $message);
    } else {
        return $message;
    }
}
add_filter('wc_add_to_cart_message_html', 'remove_continue_shoppping_button', 10, 2);


/**
 * @desc Remove in all product type
 */
function wc_remove_all_quantity_fields( $return, $product ) {
    return true;
}
add_filter( 'woocommerce_is_sold_individually', 'wc_remove_all_quantity_fields', 10, 2 );


function datebook_woocommerce_form_field( $key, $args, $value = null ) {

	$defaults = array(
		'type'              => 'text',
		'label'             => '',
		'description'       => '',
		'placeholder'       => '',
		'maxlength'         => false,
		'required'          => false,
		'autocomplete'      => false,
		'id'                => $key,
		'class'             => array(),
		'label_class'       => array(),
		'input_class'       => array(),
		'return'            => false,
		'options'           => array(),
		'custom_attributes' => array(),
		'validate'          => array(),
		'default'           => '',
		'autofocus'         => '',
		'priority'          => ''
	);
	$args = wp_parse_args( $args, $defaults );
	$args = apply_filters( 'custom_woocommerce_form_field_args', $args, $key, $value );

	if ( $args['required'] ) {
		$args['class'][] = 'validate-required';
		$required        = '&nbsp;<abbr class="required" title="' . esc_attr__( 'required', 'datebook' ) . '">*</abbr>';
	} else {
		$required = '&nbsp;<span class="optional">(' . esc_html__( 'optional', 'datebook' ) . ')</span>';
	}

	if ( is_string( $args['label_class'] ) ) {
		$args['label_class'] = array( $args['label_class'] );
	}
	if ( is_null( $value ) ) {
		$value = $args['default'];
	}

	// Custom attribute handling.
	$custom_attributes = array();
	$args['custom_attributes'] = array_filter( (array) $args['custom_attributes'], 'strlen' );
	if ( $args['maxlength'] ) {
		$args['custom_attributes']['maxlength'] = absint( $args['maxlength'] );
	}
	if ( ! empty( $args['autocomplete'] ) ) {
		$args['custom_attributes']['autocomplete'] = $args['autocomplete'];
	}
	if ( true === $args['autofocus'] ) {
		$args['custom_attributes']['autofocus'] = 'autofocus';
	}
	if ( $args['description'] ) {
		$args['custom_attributes']['aria-describedby'] = $args['id'] . '-description';
	}
	if ( ! empty( $args['custom_attributes'] ) && is_array( $args['custom_attributes'] ) ) {
		foreach ( $args['custom_attributes'] as $attribute => $attribute_value ) {
			$custom_attributes[] = esc_attr( $attribute ) . '="' . esc_attr( $attribute_value ) . '"';
		}
	}
	if ( ! empty( $args['validate'] ) ) {
		foreach ( $args['validate'] as $validate ) {
			$args['class'][] = 'validate-' . $validate;
		}
	}

	$field           = '';
	$label_id        = $args['id'];
	$sort            = $args['priority'] ? $args['priority'] : '';
	$field_container = '<p class="form-row %1$s" id="%2$s" data-priority="' . esc_attr( $sort ) . '">%3$s</p>';

	switch ( $args['type'] ) {

		case 'country':
			$countries = 'shipping_country' === $key ? WC()->countries->get_shipping_countries() : WC()->countries->get_allowed_countries();
			if ( 1 === count( $countries ) ) {
				$field .= '<strong>' . current( array_values( $countries ) ) . '</strong>';
				$field .= '<input type="hidden" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" value="' . current( array_keys( $countries ) ) . '" ' . implode( ' ', $custom_attributes ) . ' class="country_to_state" readonly="readonly" />';
			} else {
				$field = '<select name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" class="country_to_state country_select form-control' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" ' . implode( ' ', $custom_attributes ) . '><option value="">' . esc_html__( 'Select a country', 'datebook' ) . '&hellip;</option>';
				foreach ( $countries as $ckey => $cvalue ) {
					$field .= '<option value="' . esc_attr( $ckey ) . '" ' . selected( $value, $ckey, false ) . '>' . $cvalue . '</option>';
				}
				$field .= '</select>';
				$field .= '<noscript><button type="submit" name="woocommerce_checkout_update_totals" value="' . esc_attr__( 'Update country', 'datebook' ) . '">' . esc_html__( 'Update country', 'datebook' ) . '</button></noscript>';
			}
			break;

		case 'state':
			/* Get country this state field is representing */
			$for_country = isset( $args['country'] ) ? $args['country'] : WC()->checkout->get_value( 'billing_state' === $key ? 'billing_country' : 'shipping_country' );
			$states      = WC()->countries->get_states( $for_country );
			if ( is_array( $states ) && empty( $states ) ) {
				$field_container = '<p class="form-row %1$s" id="%2$s" style="display: none">%3$s</p>';
				$field .= '<input type="hidden" class="hidden" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" value="" ' . implode( ' ', $custom_attributes ) . ' placeholder="' . esc_attr( $args['placeholder'] ) . '" readonly="readonly" />';
			} elseif ( ! is_null( $for_country ) && is_array( $states ) ) {
				$field .= '<select name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" class="state_select form-control' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" ' . implode( ' ', $custom_attributes ) . ' data-placeholder="' . esc_attr( $args['placeholder'] ) . '">
						<option value="">' . esc_html__( 'Select a state', 'datebook' ) . '&hellip;</option>';
				foreach ( $states as $ckey => $cvalue ) {
					$field .= '<option value="' . esc_attr( $ckey ) . '" ' . selected( $value, $ckey, false ) . '>' . $cvalue . '</option>';
				}
				$field .= '</select>';
			} else {
				$field .= '<input type="text" class="input-text form-control ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" value="' . esc_attr( $value ) . '"  placeholder="' . esc_attr( $args['placeholder'] ) . '" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" ' . implode( ' ', $custom_attributes ) . ' />';
			}
			break;

		case 'textarea':
			$field .= '<textarea name="' . esc_attr( $key ) . '" class="input-text ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" id="' . esc_attr( $args['id'] ) . '" placeholder="' . esc_attr( $args['placeholder'] ) . '" ' . ( empty( $args['custom_attributes']['rows'] ) ? ' rows="2"' : '' ) . ( empty( $args['custom_attributes']['cols'] ) ? ' cols="5"' : '' ) . implode( ' ', $custom_attributes ) . '>' . esc_textarea( $value ) . '</textarea>';
			break;

		case 'checkbox':
			$field = '<label class="checkbox ' . implode( ' ', $args['label_class'] ) . '" ' . implode( ' ', $custom_attributes ) . '>
						<input type="' . esc_attr( $args['type'] ) . '" class="input-checkbox ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" value="1" ' . checked( $value, 1, false ) . ' /> ' . $args['label'] . $required . '</label>';
			break;

		case 'hidden':
		case 'text':
		case 'password':
		case 'datetime':
		case 'datetime-local':
		case 'date':
		case 'month':
		case 'time':
		case 'week':
		case 'number':
		case 'email':
		case 'url':
		case 'tel':
			$field .= '<input type="' . esc_attr( $args['type'] ) . '" class="input-text form-control' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" placeholder="' . esc_attr( $args['placeholder'] ) . '"  value="' . esc_attr( $value ) . '" ' . implode( ' ', $custom_attributes ) . ' />';
			break;

		case 'select':
			$field   = '';
			$options = '';
			if ( ! empty( $args['options'] ) ) {
				foreach ( $args['options'] as $option_key => $option_text ) {
					if ( '' === $option_key ) {
						// If we have a blank option, select2 needs a placeholder.
						if ( empty( $args['placeholder'] ) ) {
							$args['placeholder'] = $option_text ? $option_text : esc_html__( 'Choose an option', 'datebook' );
						}
						$custom_attributes[] = 'data-allow_clear="true"';
					}
					$options .= '<option value="' . esc_attr( $option_key ) . '" ' . selected( $value, $option_key, false ) . '>' . esc_attr( $option_text ) . '</option>';
				}
				$field .= '<select name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" class="select form-control' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" ' . implode( ' ', $custom_attributes ) . ' data-placeholder="' . esc_attr( $args['placeholder'] ) . '">
							' . $options . '
						</select>';
			}
			break;

		case 'radio':
			$label_id = current( array_keys( $args['options'] ) );
			if ( ! empty( $args['options'] ) ) {
				foreach ( $args['options'] as $option_key => $option_text ) {
					$field .= '<input type="radio" class="input-radio form-control' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" value="' . esc_attr( $option_key ) . '" name="' . esc_attr( $key ) . '" ' . implode( ' ', $custom_attributes ) . ' id="' . esc_attr( $args['id'] ) . '_' . esc_attr( $option_key ) . '"' . checked( $value, $option_key, false ) . ' />';
					$field .= '<label for="' . esc_attr( $args['id'] ) . '_' . esc_attr( $option_key ) . '" class="radio ' . implode( ' ', $args['label_class'] ) . '">' . $option_text . '</label>';
				}
			}
			break;
	}

	if ( ! empty( $field ) ) {
		$field_html = '';
		if ($args['label'] && $args['type'] !== 'checkbox' && $args['type'] !== 'hidden') {
			$field_html .= '<label for="' . esc_attr( $label_id ) . '" class="' . esc_attr( implode( ' ', $args['label_class'] ) ) . '">' . $args['label'] . $required . '</label>';
		}
		$field_html .= $field;
		if ( $args['description'] ) {
			$field_html .= '<span class="description" id="' . esc_attr( $args['id'] ) . '-description" aria-hidden="true">' . wp_kses_post( $args['description'] ) . '</span>';
		}
		//$field_html .= '</span>';
		$container_class = esc_attr( implode( ' ', $args['class'] ) );
		$container_id    = esc_attr( $args['id'] ) . '_field';
		$field           = sprintf( $field_container, $container_class, $container_id, $field_html );
	}

	/**
		 * Filter by type.
		 */
	$field = apply_filters( 'custom_woocommerce_form_field_' . $args['type'], $field, $key, $args, $value );
	/**
		 * General filter on form fields.
		 *
		 * @since 3.4.0
		 */
	$field = apply_filters( 'custom_woocommerce_form_field', $field, $key, $args, $value );

	if ( $args['return'] ) {
		return $field;
	} else {
		echo wp_specialchars_decode(esc_html($field), ENT_QUOTES); // WPCS: XSS ok.
	}
}

// Sets up add_theme_support() To add support for post thumbnails, and post formats. And set_post_thumbnail_size() To set a custom post thumbnail size.
function datebook_after_theme_setup() {

	// Makes this theme available for translation. Translations can be added to the /languages/ directory.
	$domain = 'datebook';
	// wp-content/languages/theme-name/de_DE.mo
	load_theme_textdomain( $domain, trailingslashit( WP_LANG_DIR ) . $domain );
	// wp-content/themes/child-theme-name/languages/de_DE.mo
	load_theme_textdomain( $domain, get_stylesheet_directory() . '/languages' );
	// wp-content/themes/theme-name/languages/de_DE.mo
	load_theme_textdomain( $domain, get_template_directory() . '/languages' );
	
	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	// This theme supports a variety of post formats.
	add_theme_support( 'post-formats', array('aside', 'image', 'quote') );

	// This theme uses a custom image size for featured images, displayed on "standard" posts.
	add_theme_support( 'post-thumbnails' );

	/*if(!isset( $_POST['datebook_image_upload'])) {
		set_post_thumbnail_size( 787, 600, true ); // Unlimited height, soft crop 
	}*/

	add_image_size( 'datebook-featured', 680, 400, true ); //300 pixels wide (and unlimited height)


	$header_args = array(
		'default-image' => get_template_directory_uri() . '/assets/images/welcome-city.jpg',
		'uploads'       => true,
	);
	add_theme_support( 'custom-header', $header_args );

	add_theme_support( 'custom-background' );
	add_theme_support( 'automatic-feed-links' );

	add_theme_support( 'woocommerce' );

	add_editor_style();

	if ( ! isset( $content_width ) ) { $content_width = 600; }

}
add_action( 'after_setup_theme', 'datebook_after_theme_setup' );


function posts_link_attributes() {
    return 'class="btn btn-default"';
}
add_filter('next_posts_link_attributes', 'posts_link_attributes');
add_filter('previous_posts_link_attributes', 'posts_link_attributes');


// Limit excerpt to a number of characters
function datebook_short_excerpt($excerpt){
	return substr($excerpt, 0, 100);
}
//add_filter('the_excerpt', 'datebook_short_excerpt');
add_action( 'get_the_excerpt', 'datebook_short_excerpt' );


// Replaces "[...]" (appended to automatically generated excerpts) with ... and a 'Continue reading' link.
if ( ! function_exists( 'datebook_excerpt_more' ) && ! is_admin() ) :
function datebook_excerpt_more() {

	$link = ' <span class="screen-reader-text">[&hellip;]</span>';

	return $link;

}
add_filter( 'excerpt_more', 'datebook_excerpt_more' );
endif;


function replace_text_wps($text){
	$text = str_replace('<cite>', '<footer class="blockquote-footer"><cite>', $text);
	$text = str_replace('</cite>', '</cite></footer>', $text);
	$text = str_replace('wp-block-quote', 'blockquote wp-block-quote', $text);
	//$text = str_replace('<blockquote class="', '<blockquote class="blockquote ', $text);
	//$text = str_replace('<blockquote', '<blockquote class="blockquote blockquote wp-block-quote"', $text);
	return $text;
}
add_filter('the_content', 'replace_text_wps');

function add_quotes_to_quote( $content ) {
    if( get_post_format() == "quote" ) {
		return '<blockquote class="blockquote">' . $content . '</blockquote>';
    } else {
		return $content;
	}
}
//add_action( 'the_content', 'add_quotes_to_quote' );
add_action( 'get_the_content', 'add_quotes_to_quote' );

// Template for comments and pingbacks.
function datebook_comment( $comment, $args, $depth ) {

	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case 'pingback' :
		case 'trackback' :
		// Display trackbacks differently than normal comments.
	?>

		<li <?php comment_class('media'); ?> id="comment-<?php comment_ID(); ?>"><?php esc_html_e( 'Pingback', 'datebook' ); ?>:&nbsp; <?php comment_author_link(); ?> <?php edit_comment_link( esc_html__( 'Edit', 'datebook' ) ); ?></li>
	<?php
			break;

		default :

		// Proceed with normal comments.
		global $post;
	?>
	
	<li <?php comment_class('media'); ?> id="comment-<?php comment_ID(); ?>">
	
	<?php $class = array('class' => 'media-object img-rounded'); ?>
	
	<a class="mr-3" href="#comment-<?php comment_ID(); ?>"><?php echo get_avatar( $comment, 50, null, null, $class );?></a>

	<div class="media-body border border-light">
	
		<div class="media-header">

		<?php if ( '0' == $comment->comment_approved ) : ?>

			<p class="comment-awaiting-moderation alert alert-warning"><?php esc_html_e( 'Your comment is awaiting moderation.', 'datebook' ); ?></p>

		<?php endif; ?>

		<?php echo '<h5 class="mt-0 mb-1">'.get_comment_author_link().'</h5>'; ?>

		<?php echo '<p class="date small">'.sprintf( esc_html__( '%1$s at %2$s', 'datebook' ), get_comment_date(), get_comment_time() ).'</p>'; ?>
		
		</div>
		
		<div class="media-comment-body">

		<?php comment_text(); ?>
		
			<?php comment_reply_link( array_merge( $args, array( 'reply_text' => esc_html__( 'Reply', 'datebook' ), 'before' => ' <div class="reply">', 'after' => ' <span>&darr;</span></div>', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			<!-- .reply -->
		
			<?php edit_comment_link( esc_html__( 'Edit', 'datebook' ), '<div class="edit-link">', '</div>' ); ?>
		
		</div>
		
	</div>

	</li>
		
	<?php
		break;
	endswitch; // end comment_type check

}


// Customize comment reply form 
function datebook_comment_field_changes($arg) {

    $commenter = wp_get_current_commenter();
    $user = wp_get_current_user();
    $user_identity = $user->exists() ? $user->display_name : '';

    $req = get_option( 'require_name_email' );
    $aria_req = ( $req ? " aria-required='true'" : '' );
	
    $arg['author'] = '<div class="row"><div class="col-lg-6 col-md-6 col-sm-6"><div class="form-group">' . '<label for="author">' . esc_html__( 'Name', 'datebook' ) . ( $req ? ' <span class="required"> ('.esc_html__( 'required', 'datebook').')</span>' : '' ) . '</label> ' .
                    '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . ( $req ? ' required' : '' ) . ' class="form-control" ></div></div>';

    $arg['email']  = '<div class="col-lg-6 col-md-6 col-sm-6"><div class="form-group"><label for="email">' . esc_html__( 'Email', 'datebook' ) . ( $req ? ' <span class="required"> ('.esc_html__( 'required', 'datebook').')</span>' : '' ) . '</label> ' .
                    '<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . ( $req ? ' required' : '' ) . ' class="form-control" ></div></div></div>';
    $arg['url'] = '';

    return $arg;

}
add_filter('comment_form_default_fields', 'datebook_comment_field_changes');


function datebook_comment_changes($arg) {

    $arg['label_submit'] =  esc_html__( 'Post Comment', 'datebook' );
    $arg['comment_notes_before'] = '';
    $arg['comment_notes_after'] = '';
    $arg['comment_field'] = '<div class="row"><div class="col-lg-12 col-md-12 col-sm-12"><div class="form-group"><label for="comment">' . _x( 'Comment', 'noun', 'datebook' ) . ' ('.esc_html__( 'required', 'datebook').')</label><textarea id="comment" name="comment" cols="45" rows="5" required class="form-control" aria-required="true"></textarea></div></div></div>';

    return $arg;

}
add_filter('comment_form_defaults', 'datebook_comment_changes');


// Outputs a complete commenting form for use within a template. Most strings and form fields may be controlled through the $args array
function datebook_comment_form( $args = array(), $post_id = null ) {

	global $id;

	if ( null === $post_id ){
		$post_id = $id;
	} else {
		$id = $post_id;
	}

	$commenter = wp_get_current_commenter();
	$user = wp_get_current_user();
	$user_identity = $user->exists() ? $user->display_name : '';

	$req = get_option( 'require_name_email' );
	$aria_req = ( $req ? " aria-required='true'" : '' );
	$fields =  array(
		'author' => '<p class="comment-form-author">' . '<label for="author">' . esc_html__( 'Name', 'datebook' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
		            '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' class="form-control" /></p>',
		'email'  => '<p class="comment-form-email"><label for="email">' . esc_html__( 'Email', 'datebook' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
		            '<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' class="form-control" /></p>',
		'url'    => '<p class="comment-form-url"><label for="url">' . esc_html__( 'Website', 'datebook' ) . '</label>' .
		            '<input id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" class="form-control" /></p>',
	);

	$required_text = sprintf( ' ' . esc_html__( 'Required fields are marked %s', 'datebook'), '<span class="required">*</span>' );
	
	if( class_exists( 'DateBook' ) ) {
		$login_page = get_permalink(of_get_option('login_page'));
	} else {
		$login_page = wp_login_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) );
	}


	$defaults = array(
		'fields'               => apply_filters( 'comment_form_default_fields', $fields ),
		'comment_field'        => '<p class="comment-form-comment"><label for="comment">' . _x( 'Comment', 'noun', 'datebook' ) . '</label><textarea id="comment" name="comment" cols="45" rows="8" class="form-control" aria-required="true"></textarea></p>',
		'must_log_in'          => '<p class="must-log-in">' . sprintf( esc_html__( 'You must be <a href="%s">logged in</a> to post a comment.', 'datebook' ), $login_page ) . '</p>',
		'logged_in_as'         => '<p class="logged-in-as">' . sprintf( esc_html__( 'Logged in as %1$s.', 'datebook' ), $user_identity ) . '</p>',
		'comment_notes_before' => '<p class="comment-notes">' . esc_html__( 'Your email address will not be published.', 'datebook' ) . ( $req ? $required_text : '' ) . '</p>',
		'comment_notes_after'  => '<p class="form-allowed-tags">' . sprintf( esc_html__( 'You may use these <abbr title="HyperText Markup Language">HTML</abbr> tags and attributes: %s', 'datebook' ), ' <code>' . allowed_tags() . '</code>' ) . '</p>',
		'id_form'              => 'commentform',
		'id_submit'            => 'submit',
		'title_reply'          => esc_html__( 'Leave a Reply', 'datebook' ),
		'title_reply_to'       => esc_html__( 'Leave a Reply to %s', 'datebook' ),
		'cancel_reply_link'    => esc_html__( 'Cancel reply', 'datebook' ),
		'label_submit'         => esc_html__( 'Post Comment', 'datebook' ),
	);

	$args = wp_parse_args( $args, apply_filters( 'comment_form_defaults', $defaults ) );

	if ( comments_open( $post_id ) ) :

		do_action( 'comment_form_before' );

		?>

		<div class="card-footer">
			<div id="respond" class="comment-panel mb-4">

				<h4 id="reply-title"><?php comment_form_title( $args['title_reply'], $args['title_reply_to'] ); ?></h4>

				<?php

				if ( get_option( 'comment_registration' ) && !is_user_logged_in() ) :

					echo wp_specialchars_decode(esc_html($args['must_log_in']));

					do_action( 'comment_form_must_log_in_after' );

				else :

				?>

					<form action="<?php echo site_url( '/wp-comments-post.php' ); ?>" method="post" id="<?php echo esc_attr( $args['id_form'] ); ?>">

					<?php

						do_action( 'comment_form_top' );

						if ( is_user_logged_in() ) :

							echo apply_filters( 'comment_form_logged_in', $args['logged_in_as'], $commenter, $user_identity );

							do_action( 'comment_form_logged_in_after', $commenter, $user_identity );

						else :

							echo wp_specialchars_decode(esc_html($args['comment_notes_before']));

							do_action( 'comment_form_before_fields' );

							foreach ( (array) $args['fields'] as $name => $field ) {

								echo apply_filters( "comment_form_field_{$name}", $field ) . "\n";

							}

							do_action( 'comment_form_after_fields' );

						endif;

						echo apply_filters( 'comment_form_field_comment', $args['comment_field'] );

						echo wp_specialchars_decode(esc_html($args['comment_notes_after'])); ?>

						<button type="submit" class="btn btn-primary" name="submit" id="<?php echo esc_attr( $args['id_submit'] ); ?>"><?php echo esc_attr( $args['label_submit'] ); ?></button> &nbsp; <?php cancel_comment_reply_link( $args['cancel_reply_link'] ); ?>

						<?php comment_id_fields( $post_id ); ?>
						
						<?php do_action( 'comment_form', $post_id ); ?>

					</form>

				<?php endif; ?>

			</div>
		</div><!-- #respond -->

		<?php

		do_action( 'comment_form_after' );

	else :

		do_action( 'comment_form_comments_closed' );

	endif;
}


// Enqueues scripts and styles for front-end.
function datebook_scripts_styles() {

	$file_version = '4.5.6';

	// JavaScript files
	wp_enqueue_script('jquery-form');

	wp_enqueue_script('tether', get_template_directory_uri() . '/assets/js/popper.min.js', array(), $file_version, true );
	wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array(), '4.6.0', true );


	// CSS files
	$enable_mdbootstrap = 1;
	$color_brend = 'mdbootstrap';
	$color_folder = '';

	$color_scheme_style_sheet = get_theme_mod('datebook_color_schemes');
	if (isset($color_scheme_style_sheet) && $color_scheme_style_sheet != '') {

		if($color_scheme_style_sheet == 'none'){

			$enable_mdbootstrap = 0; $color_brend = 'none'; $color_folder = '';

		} else if($color_scheme_style_sheet == 'mdbootstrap'){

			$enable_mdbootstrap = 1; $color_brend = 'mdbootstrap'; $color_folder = '';

		} else if(strpos($color_scheme_style_sheet, 'bootswatch') !== false){
			
			$color_scheme_style_sheet = str_replace('bootswatch_', '', $color_scheme_style_sheet);

			$enable_mdbootstrap = 0; $color_brend = 'bootswatch'; $color_folder = 'colors/bootswatch/' . $color_scheme_style_sheet . '/';

		} else {

			$enable_mdbootstrap = 0; $color_brend = 'simple'; $color_folder = '';

		}
	}

	if (($enable_mdbootstrap == 1 && $color_brend == 'mdbootstrap') || ($enable_mdbootstrap == 0 && ($color_brend == 'bootswatch' || $color_brend == 'none' || $color_brend == 'simple'))) {
		
		// Get language locale
		$datebook_get_locale = get_locale();
		$datebook_rtl_support = $datebook_get_locale == 'ar' ? 'bootstrap-rtl.min.css' : 'bootstrap.min.css';

		//$datebook_rtl_support = get_theme_mod( 'datebook_rtl_support' ) == '1' ? 'bootstrap-rtl.min.css' : 'bootstrap.min.css';

		wp_enqueue_style('bootstrap', esc_url( get_template_directory_uri() ) . '/assets/css/' . $color_folder . $datebook_rtl_support, false, $file_version);

	}

	if ($enable_mdbootstrap == 1 && $color_brend == 'mdbootstrap') {
		wp_enqueue_style('mdb', esc_url( get_template_directory_uri()) . '/assets/css/mdb.min.css', false, '4.8.10' );
		wp_enqueue_script('MDB', get_template_directory_uri() . '/assets/js/mdb.min.js', array(), '4.8.1', true );
		wp_enqueue_script('MDB-forms', get_template_directory_uri() . '/assets/js/mdb-forms.js', array(), '4.8.1', true );
	}

	if ($enable_mdbootstrap == 0 && $color_brend == 'simple') {
		wp_enqueue_style('datebook-color-style', esc_url( get_template_directory_uri() ) . '/assets/css/colors/' . esc_attr($color_scheme_style_sheet) . '.css', false, $file_version);
	}


	// Force loading Font Awesome from our theme folder. Some third-party plugins may load old version of Font Awesome CSS file. In this case, you can load the required version here. Notice: In this case two different Font Awesome CSS files will be loaded on your website.
	$datebook_load_fontawesome = '';
	if (get_theme_mod( 'datebook_load_fontawesome' ) == 1) {
		$datebook_load_fontawesome = 'datebook-';
	}

	wp_enqueue_style($datebook_load_fontawesome . 'font-awesome', esc_url( get_template_directory_uri() ) . '/assets/css/font-awesome.css', false, '5.3.1');

	wp_enqueue_style('datebook-style-theme', esc_url( get_stylesheet_uri() ), false, $file_version);


	// Internet Explorer 6, 7, 8 style
	wp_enqueue_style( 'datebook-ie-theme', esc_url( get_template_directory_uri() ) . '/assets/css/datebook-ie-theme.css', false, $file_version);
	wp_style_add_data( 'datebook-ie-theme', 'conditional', 'lt IE 9' );

	// Load blog columns
	if (get_theme_mod('datebook_blog_style') == 4) {

		$datebook_blog_columns = get_theme_mod('datebook_blog_columns') ? get_theme_mod('datebook_blog_columns') : 2;
		
		$datebook_blog_columns_css = '
			/* 2 columns for sm */
			@media (min-width: 576px) {
				.card-columns {
					-webkit-column-count: ' . $datebook_blog_columns . ';
					column-count: ' . $datebook_blog_columns . '
				}
			}
			/* columns for */
			@media (min-width: 768px) {
				.card-columns {
					-webkit-column-count: ' . $datebook_blog_columns . ';
					column-count: ' . $datebook_blog_columns . '
				}
			}
			/* columns for lg и xl */
			@media (min-width: 992px) {
				.card-columns {
					-webkit-column-count: ' . $datebook_blog_columns . ';
					column-count: ' . $datebook_blog_columns . '
				}
			}';

		wp_add_inline_style('datebook-style-theme', $datebook_blog_columns_css);
		
	} else if (get_theme_mod('datebook_blog_style') == 5) {

		// Load masonry blog javascript
		wp_enqueue_script('masonry.pkgd.min', get_template_directory_uri() . '/assets/js/masonry.pkgd.min.js', array(), $file_version, true );
		wp_add_inline_script('masonry.pkgd.min', "jQuery(document).ready(function($) {'use strict';$('.masonry').masonry({itemSelector: '.datebook-blogs-item', columnWidth: '.grid-sizer', percentPosition: true});});" );

	}


	// JavaScript files
	wp_enqueue_script('datebook-script-theme', get_template_directory_uri() . '/assets/js/datebook-script-theme.js', array(), $file_version, true );

	// Comment Reply support 
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// Internet Explorer HTML5 support 
	wp_enqueue_script( 'html5shiv', esc_url( get_template_directory_uri() ).'/assets/js/html5shiv.min.js', array( 'jquery' ), $file_version, false );
	wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 9' );
	
	// Internet Explorer CSS3 Media Queries support
	wp_enqueue_script( 'respond', esc_url( get_template_directory_uri() ).'/assets/js/respond.min.js', array( 'jquery' ), $file_version, false );
	wp_script_add_data( 'respond', 'conditional', 'lt IE 9' );



}
add_action( 'wp_enqueue_scripts', 'datebook_scripts_styles' );