<?php
/**
 * Theme Customizations
 *
 * @package DateBook
 * @author Pagick Themes
 * @param $wp_customize
 * @return void
 */


function datebook_customizations( $wp_customize ) {

	$wp_customize->add_section( 'datebook_general', array( 'title' => esc_html__( 'DateBook', 'datebook' ), 'priority' => 0 ) );


	// Add settings for Pass all control to plugin
	$wp_customize->add_setting( 'datebook_advanced_control', array(
        'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
    ) );
	// Add control and output for Pass all control to plugin
	$wp_customize->add_control( 'datebook_advanced_control', array(
		'label'      => esc_html__( 'How to control theme items', 'datebook' ),
		'section'  => 'datebook_general',
		'settings' => 'datebook_advanced_control',
		'type'     => 'radio',
		'choices'  => array(
			1  => 'Plugin (recommended). Most theme items will be controled via DateBook Options',
			2 => 'Theme. All theme items will be control via this Customizer',
		),
	));


    // Logo
	$wp_customize->add_setting( 'datebook_logo', array( 'sanitize_callback' => 'sanitize_text_field' ) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'header_logo', array(
		'label'         => esc_html__( 'Logo', 'datebook' ),
		'section'       => 'datebook_general',
		'settings'      => 'datebook_logo',
		'description'   => esc_html__( 'Logo displayed in header.', 'datebook' ),
	) ) );


    // Favicon
	$wp_customize->add_setting( 'datebook_favicon', array( 'sanitize_callback' => 'sanitize_text_field' ) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'header_favicon', array(
		'label'         => esc_html__( 'Favicon', 'datebook' ),
		'section'       => 'datebook_general',
		'settings'      => 'datebook_favicon',
		'description'   => esc_html__( 'Favicon displayed in address bar of browser.', 'datebook' ),
	) ) );


    // Add settings for Color Schemes
    $wp_customize->add_setting( 'datebook_color_schemes', array( 'sanitize_callback' => 'sanitize_text_field' ) );
	// Add control and output for Color Schemes
    $wp_customize->add_control( 'datebook_color_schemes', array(
        'label'         => esc_html__( 'Color Schemes', 'datebook' ),
        'type'          => 'select',
        'section'       => 'datebook_general',
        'settings'      => 'datebook_color_schemes',
		'choices'       => datebook_get_color_schemes_theme(),
        'description'   => esc_html__( 'Theme Color', 'datebook' ),
    ) );


	// Add settings for Top menu
	$wp_customize->add_setting( 'datebook_show_top_menu', array(
        'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
    ) );
	// Add control and output for Top menu
	$wp_customize->add_control( 'datebook_show_top_menu', array(
        'label'      => esc_html__( 'Show Top Menu', 'datebook' ),
        'section'    => 'datebook_general',
        'settings'   => 'datebook_show_top_menu',
        'type'       => 'checkbox'
    ) );


	// Add settings for Multilingual widgets
	$wp_customize->add_setting( 'datebook_multilingual_enable', array(
        'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
    ) );
	// Add control and output for Top menu
	$wp_customize->add_control( 'datebook_multilingual_enable', array(
        'label'      => esc_html__( 'Enable Multilingual widgets', 'datebook' ),
		'description'   => esc_html__( 'You can display different widgets for different languages. After enabling, go here and create new widgets for other languages: Appearance -> Widgets.', 'datebook' ),
        'section'    => 'datebook_general',
        'settings'   => 'datebook_multilingual_enable',
        'type'       => 'checkbox'
    ) );


    // Add settings for Sidebar
    $wp_customize->add_setting( 'datebook_sidebar_layout', array( 'sanitize_callback' => 'sanitize_text_field' ) );
	// Add control and output for Sidebar
    $wp_customize->add_control( 'datebook_sidebar_layout', array(
        'label'         => esc_html__( 'Sidebar layout', 'datebook' ),
        'type'          => 'select',
        'section'       => 'datebook_general',
        'settings'      => 'datebook_sidebar_layout',
		'choices'       => array ( 0 => esc_html__( 'on the left side', 'datebook' ), 1 => esc_html__( 'on the right side', 'datebook' ) ),
        'description'   => esc_html__( 'On what side should Sidebar be shown?', 'datebook' ),
    ) );


	// Add settings for Font Awesome Free
	$wp_customize->add_setting( 'datebook_load_fontawesome', array(
        'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
    ) );
	// Add control and output for Font Awesome Free
	$wp_customize->add_control( 'datebook_load_fontawesome', array(
        'label'      => esc_html__( 'Force the latest version of Font Awesome from the theme folder', 'datebook' ),
        'section'    => 'datebook_general',
        'settings'   => 'datebook_load_fontawesome',
        'type'       => 'checkbox'
    ) );


    // Add settings for Blog styling
    $wp_customize->add_setting( 'datebook_blog_style', array( 'sanitize_callback' => 'sanitize_text_field' ) );
	// Add control and output for Blog styling
    $wp_customize->add_control( 'datebook_blog_style', array(
        'label'         => esc_html__('Blog styling', 'datebook'),
        'type'          => 'select',
        'section'       => 'datebook_general',
        'settings'      => 'datebook_blog_style',
		'choices'       => array (1 => esc_html__('Card Horizontal by Bootstrap (no image placeholder)', 'datebook'), 2 => esc_html__('Card Classic by Bootstrap (with image placeholder)', 'datebook'), 3 => esc_html__('Card Overlap by Bootstrap (with image placeholder)', 'datebook'), 4 => esc_html__('Masonry by Bootstrap', 'datebook'), 5 => esc_html__('Masonry by MDB Framework', 'datebook')),
        'description'   => esc_html__('How list of articles will be displayed on Blog page', 'datebook'),
    ) );


    // Add settings for quantity of columns in blog
    $wp_customize->add_setting( 'datebook_blog_columns', array( 'sanitize_callback' => 'sanitize_text_field' ) );
	// Add control and output for quantity of columns in blog
    $wp_customize->add_control( 'datebook_blog_columns', array(
        'label'         => esc_html__('quantity of columns on blog page', 'datebook'),
        'type'          => 'select',
        'section'       => 'datebook_general',
        'settings'      => 'datebook_blog_columns',
		'choices'       => array (1 => '1 ' . esc_html__('column', 'datebook'), 2 => '2 ' . esc_html__('columns', 'datebook'), 3 => '3 ' . esc_html__('columns', 'datebook'), 4 => '4 ' . esc_html__('columns', 'datebook'))
    ) );


    // Add RTL support
	/*$wp_customize->add_setting( 'datebook_rtl_support', array(
        'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
    ) );
	// Add control and output for language locale
	$wp_customize->add_control( 'datebook_rtl_support', array(
        'label'      => esc_html__( 'Enable RTL support', 'datebook' ),
        'section'    => 'datebook_general',
        'settings'   => 'datebook_rtl_support',
        'type'       => 'checkbox',
		'description'   => esc_html__( 'Use RTL for languages written from right to left (like Hebrew or Arabic).', 'datebook' )
    ) );*/


	// Language code
	$wp_customize->add_setting('datebook_lang_code', array('sanitize_callback' => 'sanitize_text_field'));
	$wp_customize->add_control( 'datebook_lang_code', array(
        'label'      => esc_html__( 'Language code', 'datebook' ),
		'description' => esc_html__( 'You can enter your ISO Language (and Country) Code for the lang attribute inside the <html> tag, to declare the language of the Web page. This is meant to assist search engines and browsers. Country codes can be used as an addition to the language code in the lang attribute. The first two characters of a language code defines the language of the Web page. The last two characters define the country. For example, for English pages you can enter "en" or "en-US", for Chineese pages you can enter "zh" or "zh-CN". If left empty then "en" used by default.', 'datebook' ),
        'section'    => 'datebook_general',
        'settings'   => 'datebook_lang_code',
        'type'       => 'text'
    ) );


}
add_action( 'customize_register', 'datebook_customizations' );