<?php
/**
 * The default template for displaying content as "Aside". Used in page-blog.php.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 1.0
 */

$datebook_blog_columns = '';

if(get_theme_mod('datebook_blog_style', 4) == 4) {

	$datebook_blog_class = 'w-100';
	$datebook_blog_subclass = 'mb-0 datebook-article-aside shadow-none';

} else if(get_theme_mod('datebook_blog_style') == 5) {

	switch(get_theme_mod('datebook_blog_columns', 3)){
		case '1' : $datebook_blog_columns = 'col-md-12'; break;
		case '2' : $datebook_blog_columns = 'col-md-6'; break;
		case '3' : $datebook_blog_columns = 'col-md-4'; break;
		case '4' : $datebook_blog_columns = 'col-md-3'; break;
		default: $datebook_blog_columns = 'col-md-4'; break;
	}

	$datebook_blog_class = '';
	$datebook_blog_subclass = 'mb-0 datebook-article-aside shadow-none';

} else {
	
	$datebook_blog_class = 'w-100';
	$datebook_blog_subclass = 'mb-0 datebook-article-aside shadow-none';

}

?>

<!-- Begin Article -->
<div id="datebook-post-<?php the_ID(); ?>" class="<?php echo esc_attr($datebook_blog_columns . $datebook_blog_class); ?> mb-3 white datebook-blogs-item">
	<div <?php post_class($datebook_blog_subclass); ?>>
		<div class="card-body">

		<?php

		if ( !is_single() ) : // Only display Excerpts for Search

			if (has_excerpt()):

				echo '<p class="card-text">' . wp_strip_all_tags(do_shortcode(get_the_excerpt())) . '</p>';

			else:

				$datebook_get_content = substr(wp_strip_all_tags(do_shortcode(get_the_content())), 0, 200);

				if(strlen($datebook_get_content) > 0 && $datebook_get_content != '&nbsp;'){
					echo '<p class="card-text">' . esc_attr($datebook_get_content) . '</p>';
				}

			endif;

		else :

			the_content();

			wp_link_pages( array( 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'datebook' ), 'after' => '</div>' ) );

		endif;

		?>
		
		<?php edit_post_link(esc_html__( 'Edit', 'datebook' )); ?>

		</div>
	</div>
	
</div>
<!-- End  Article -->