<?php
/**
 * The default template for displaying content as "Quote". Used in page-blog.php.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 1.0
 */

$datebook_blog_class = 'w-100 mb-4';
$datebook_blog_subclass = 'w-100 datebook-custom-card card shadow';

?>

<!-- Begin Article -->
<div id="datebook-post-<?php the_ID(); ?>" class="<?php echo esc_attr($datebook_blog_class); ?> datebook-blogs-item border-0">
	<div <?php post_class('w-100 datebook-article-quote'); ?>>
		<blockquote class="blockquote m-0 shadow">

		<?php

		if (has_excerpt()):

			echo '<p class="card-text">' . wp_strip_all_tags(do_shortcode(get_the_excerpt())) . '</p>';

		else:

			$get_content = str_replace('<blockquote>', '', get_the_content());
			$get_content = str_replace('</blockquote>', '', $get_content);
			$get_content = str_replace('<cite>', '<footer class="blockquote-footer"><cite>', $get_content);

			$datebook_get_content = str_replace('</cite>', '</cite></footer>', $get_content);

			if(strlen($datebook_get_content) > 0 && $datebook_get_content != '&nbsp;'){
				echo wp_specialchars_decode(esc_html(do_shortcode(wpautop($datebook_get_content))), ENT_QUOTES);
			}

		endif;

		edit_post_link(esc_html__( 'Edit', 'datebook' ));

		?>

		</blockquote>
	</div>
</div>
<!-- End  Article -->