<?php
/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$customer_id = get_current_user_id();

$get_addresses = apply_filters( 'woocommerce_my_account_get_addresses', array(
	'billing' => esc_html__( 'Billing address', 'datebook' ),
), $customer_id );

?>

<p>
	<?php echo apply_filters( 'woocommerce_my_account_my_address_description', esc_html__( 'The following addresses will be used on the checkout page by default.', 'datebook' ) ); ?>
</p>

<?php foreach ( $get_addresses as $name => $title ) : ?>

	<div class="u-column woocommerce-Address">
		<header class="woocommerce-Address-title title">
			<h4><?php echo esc_attr($title); ?> <a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address', $name ) ); ?>" class="btn btn-sm btn-light"><?php esc_html_e( 'Edit', 'datebook' ); ?></a></h4>
		</header>
		<address><?php
			$address = wc_get_account_formatted_address( $name );
			$address_out = $address ? $address : esc_html_e( 'You have not set up this type of address yet.', 'datebook' );
			echo wp_kses_post($address_out);
		?></address>
	</div>

<?php endforeach;