<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Blog
 *
 * @class DateBook_Blog
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Blog {


	/**
	 * Hook actions and filters.
	 * 
	 * @since 4.0
	 * @access public
	 */
	public static function init() {

		add_shortcode( 'datebook_posts', array( __CLASS__, 'get_posts' ) );
		add_shortcode( 'datebook_single_post', array( __CLASS__, 'get_single_post' ) );
		add_shortcode( 'datebook_post_category', array( __CLASS__, 'get_category' ) );
		add_shortcode( 'datebook_post_tag', array( __CLASS__, 'get_tag' ) );

	}



	/**
	 * Function to handle the `get_posts` shortcode
	 *
	 * @access public
	 * @since 4.0
	 */
	public static function get_posts($atts = array()) {

		$is_shortcode = !empty($atts) && is_array($atts) ? 1 : 0;

		$options = array();
		
	    // display the Edit Profile form
		return DateBook_Template_Loader::load( 'blog/blog', $options );

	}


	/**
	 * Function to handle the `get_single_post` shortcode
	 *
	 * @access public
	 * @since 4.0
	 */
	public static function get_single_post($atts = array()) {

		$is_shortcode = !empty($atts) && is_array($atts) ? 1 : 0;

		$options = array();

	    // display the Post template
		return DateBook_Template_Loader::load( 'blog/single', $options );

	}


	/**
	 * Function to handle the `get_category` shortcode
	 *
	 * @access public
	 * @since 4.0
	 */
	public static function get_category($atts = array()) {

		$is_shortcode = !empty($atts) && is_array($atts) ? 1 : 0;

		$options = array();
		
	    // display the Edit Profile form
		return DateBook_Template_Loader::load( 'blog/category', $options );

	}

	/**
	 * Function to handle the `get_tag` shortcode
	 *
	 * @access public
	 * @since 4.0
	 */
	public static function get_tag($atts = array()) {

		$is_shortcode = !empty($atts) && is_array($atts) ? 1 : 0;

		$options = array();
		
	    // display the Edit Profile form
		return DateBook_Template_Loader::load( 'blog/tag', $options );

	}


}

DateBook_Blog::init();