<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Featured_Profiles
 *
 * @class DateBook_Featured_Profiles
 * @package DateBook/Classes/Profiles
 * @author Pagick Themes
 */
class DateBook_Featured_Profiles {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}

	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_featured_profiles', array( __CLASS__, 'process_featured_profiles' ) );
		add_shortcode('datebook_featured_profiles', array( __CLASS__, 'pre_process_featured_profiles' ) );

		add_action( 'template_redirect', array( __CLASS__, 'process_featured_body_class' ) );

		add_action( 'datebook_featured_images_panel', array( __CLASS__, 'process_featured_images_panel' ) );
		
	}


	/**
	 * Get options of featured profiles
	 *
	 * @access private
	 * @return void
	 */
	private static function get_featured_profiles_options() {

		$show_feat_profiles = 0;
		$profile_quantity = 12;
		$how_many_columns_on_mobile = 2;
		$how_many_columns_on_tablet = 2;
		$how_many_columns_on_normal = 4;
		$how_many_columns_on_large = 5;
		
		$featured_enabled_sections = self::$datebook_options['featured_enabled'];

		$shown_featured_to_loggedin_users_only = DateBook_Utilities::datebook_show_to_logged_in_users($featured_enabled_sections['show_to_loggedin_users']);

		if ($shown_featured_to_loggedin_users_only == 1) {

			// Display featured profiles on profile page
			if (isset(self::$datebook_options['featured_on_profiles']) && self::$datebook_options['featured_on_profiles'] == 1 && get_post_type() == DATEBOOK_POST_TYPE) {
				$show_feat_profiles = 1;
				$profile_quantity = isset(self::$datebook_options['featured_quantity_on_profile']) ? self::$datebook_options['featured_quantity_on_profile'] : 12;

				$how_many_columns_on_mobile = isset(self::$datebook_options['how_many_columns_featured_mobile_on_profile']) ? self::$datebook_options['how_many_columns_featured_mobile_on_profile'] : 2;
				$how_many_columns_on_tablet = isset(self::$datebook_options['how_many_columns_featured_tablet_on_profile']) ? self::$datebook_options['how_many_columns_featured_tablet_on_profile'] : 2;
				$how_many_columns_on_normal = isset(self::$datebook_options['how_many_columns_featured_normal_on_profile']) ? self::$datebook_options['how_many_columns_featured_normal_on_profile'] : 4;
				$how_many_columns_on_large = isset(self::$datebook_options['how_many_columns_featured_large_on_profile']) ? self::$datebook_options['how_many_columns_featured_large_on_profile'] : 5;

			}

			// Display featured profiles on search page
			if (isset(self::$datebook_options['featured_on_search']) == 1 && self::$datebook_options['featured_on_search'] == 1 && is_page(self::$datebook_options['search_results_page'])) {
				$show_feat_profiles = 1;
				$profile_quantity = isset(self::$datebook_options['featured_quantity_on_search']) ? self::$datebook_options['featured_quantity_on_search'] : 12;

				$how_many_columns_on_mobile = isset(self::$datebook_options['how_many_columns_featured_mobile_on_search']) ? self::$datebook_options['how_many_columns_featured_mobile_on_search'] : 2;
				$how_many_columns_on_tablet = isset(self::$datebook_options['how_many_columns_featured_tablet_on_search']) ? self::$datebook_options['how_many_columns_featured_tablet_on_search'] : 2;
				$how_many_columns_on_normal = isset(self::$datebook_options['how_many_columns_featured_normal_on_search']) ? self::$datebook_options['how_many_columns_featured_normal_on_search'] : 4;
				$how_many_columns_on_large = isset(self::$datebook_options['how_many_columns_featured_large_on_search']) ? self::$datebook_options['how_many_columns_featured_large_on_search'] : 5;

			}

			// Display featured profiles on classifieds page
			if (isset(self::$datebook_options['featured_on_classifieds']) && self::$datebook_options['featured_on_classifieds'] == 1 && (get_post_type() == DATEBOOK_CLASSIFIEDS_TYPE || is_page(self::$datebook_options['all_classifieds_page']))) {
				$show_feat_profiles = 1;
				$profile_quantity = isset(self::$datebook_options['featured_quantity_on_classifieds']) ? self::$datebook_options['featured_quantity_on_classifieds'] : 12;

				$how_many_columns_on_mobile = isset(self::$datebook_options['how_many_columns_featured_mobile_on_classifieds']) ? self::$datebook_options['how_many_columns_featured_mobile_on_classifieds'] : 2;
				$how_many_columns_on_tablet = isset(self::$datebook_options['how_many_columns_featured_tablet_on_classifieds']) ? self::$datebook_options['how_many_columns_featured_tablet_on_classifieds'] : 2;
				$how_many_columns_on_normal = isset(self::$datebook_options['how_many_columns_featured_normal_on_classifieds']) ? self::$datebook_options['how_many_columns_featured_normal_on_classifieds'] : 4;
				$how_many_columns_on_large = isset(self::$datebook_options['how_many_columns_featured_large_on_classifieds']) ? self::$datebook_options['how_many_columns_featured_large_on_classifieds'] : 5;

			}

			// Display featured profiles on tours page
			if (isset(self::$datebook_options['featured_on_tours']) && self::$datebook_options['featured_on_tours'] == 1 && (get_post_type() == DATEBOOK_TOUR_TYPE || is_page(self::$datebook_options['all_tours_page']))) {
				$show_feat_profiles = 1;
				$profile_quantity = isset(self::$datebook_options['featured_quantity_on_tours']) ? self::$datebook_options['featured_quantity_on_tours'] : 12;

				$how_many_columns_on_mobile = isset(self::$datebook_options['how_many_columns_featured_mobile_on_tours']) ? self::$datebook_options['how_many_columns_featured_mobile_on_tours'] : 2;
				$how_many_columns_on_tablet = isset(self::$datebook_options['how_many_columns_featured_tablet_on_tours']) ? self::$datebook_options['how_many_columns_featured_tablet_on_tours'] : 2;
				$how_many_columns_on_normal = isset(self::$datebook_options['how_many_columns_featured_normal_on_tours']) ? self::$datebook_options['how_many_columns_featured_normal_on_tours'] : 4;
				$how_many_columns_on_large = isset(self::$datebook_options['how_many_columns_featured_large_on_tours']) ? self::$datebook_options['how_many_columns_featured_large_on_tours'] : 5;

			}

			// Display featured profiles on blog category page
			if (isset(self::$datebook_options['featured_on_cats']) && self::$datebook_options['featured_on_cats'] == 1 && is_category()) {
				$show_feat_profiles = 1;
				$profile_quantity = isset(self::$datebook_options['featured_quantity_on_cats']) ? self::$datebook_options['featured_quantity_on_cats'] : 12;

				$how_many_columns_on_mobile = isset(self::$datebook_options['how_many_columns_featured_mobile_on_cats']) ? self::$datebook_options['how_many_columns_featured_mobile_on_cats'] : 2;
				$how_many_columns_on_tablet = isset(self::$datebook_options['how_many_columns_featured_tablet_on_cats']) ? self::$datebook_options['how_many_columns_featured_tablet_on_cats'] : 2;
				$how_many_columns_on_normal = isset(self::$datebook_options['how_many_columns_featured_normal_on_cats']) ? self::$datebook_options['how_many_columns_featured_normal_on_cats'] : 4;
				$how_many_columns_on_large = isset(self::$datebook_options['how_many_columns_featured_large_on_cats']) ? self::$datebook_options['how_many_columns_featured_large_on_cats'] : 5;

			}

			// Display featured profiles on front page
			$featured_on_front_sections = self::$datebook_options['featured_on_front'];
			if (isset($featured_on_front_sections['show']) && $featured_on_front_sections['show'] == 1 && is_front_page()) {
				$show_feat_profiles = 1;
				$profile_quantity = isset(self::$datebook_options['featured_quantity_on_tours']) ? self::$datebook_options['featured_quantity_on_tours'] : 12;

				$how_many_columns_on_mobile = isset(self::$datebook_options['how_many_columns_featured_mobile_front']) ? self::$datebook_options['how_many_columns_featured_mobile_front'] : 2;
				$how_many_columns_on_tablet = isset(self::$datebook_options['how_many_columns_featured_tablet_front']) ? self::$datebook_options['how_many_columns_featured_tablet_front'] : 2;
				$how_many_columns_on_normal = isset(self::$datebook_options['how_many_columns_featured_normal_front']) ? self::$datebook_options['how_many_columns_featured_normal_front'] : 4;
				$how_many_columns_on_large = isset(self::$datebook_options['how_many_columns_featured_large_front']) ? self::$datebook_options['how_many_columns_featured_large_front'] : 5;

			}

		} else {

			$show_feat_profiles = 0;

		}

		$options = array(
			'show_feat_profiles' => $show_feat_profiles,
			'profile_quantity' => $profile_quantity,

			'how_many_columns_on_mobile' => $how_many_columns_on_mobile,
			'how_many_columns_on_tablet' => $how_many_columns_on_tablet,
			'how_many_columns_on_normal' => $how_many_columns_on_normal,
			'how_many_columns_on_large' => $how_many_columns_on_large

		);

		return $options;

	}


	/**
	 * Return featured profiles
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_process_featured_profiles($atts = array(), $options = array()) {
		
		if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
			exit();
		}

		$get_featured_profiles_options = self::get_featured_profiles_options();
		
		$show_feat_profiles = $get_featured_profiles_options['show_feat_profiles'];
		
		if($show_feat_profiles == 1){

			global $datebook_field_titles;
			set_query_var( 'datebook_field_titles', $datebook_field_titles );
			
			$get_day_from_code = DATEBOOK_PURCHASE_CODE;
			$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

			$is_front_page = is_front_page() ? 1 : 0;

			$is_shortcode = !empty($options) && is_array($options) && $options['featured_enabled'] == 1 ? 0 : (!empty($atts) && is_array($atts) ? 1 : 0);

			$profile_quantity = $get_featured_profiles_options['profile_quantity'];

			$how_many_columns_on_mobile = $get_featured_profiles_options['how_many_columns_on_mobile'];
			$how_many_columns_on_tablet = $get_featured_profiles_options['how_many_columns_on_tablet'];
			$how_many_columns_on_normal = $get_featured_profiles_options['how_many_columns_on_normal'];
			$how_many_columns_on_large = $get_featured_profiles_options['how_many_columns_on_large'];

			if(isset($atts['style'])){
				$shortcode_style = $atts['style'];
			} else if($is_front_page == 1 && self::$datebook_options['featured_profiles_style_front']){
				$shortcode_style = self::$datebook_options['featured_profiles_style_front'];
			} else if ($is_front_page == 0 && self::$datebook_options['featured_profiles_style_other']){
				$shortcode_style = self::$datebook_options['featured_profiles_style_other'];
			} else {
				$shortcode_style = '';
			}

			if(isset($atts['text_align'])){
				$shortcode_text_align = $atts['text_align'];
			} else if($is_front_page == 1 && self::$datebook_options['featured_text_align_front']){
				$shortcode_text_align = self::$datebook_options['featured_text_align_front'];
			} else if ($is_front_page == 0 && self::$datebook_options['featured_text_align_other']){
				$shortcode_text_align = self::$datebook_options['featured_text_align_other'];
			} else {
				$shortcode_text_align = '';
			}

			if(isset($atts['border_width'])){
				$shortcode_border_width = $atts['border_width'];
			} else if($is_front_page == 1 && self::$datebook_options['featured_border_width_front']){
				$shortcode_border_width = self::$datebook_options['featured_border_width_front'];
			} else if ($is_front_page == 0 && self::$datebook_options['featured_border_width_other']){
				$shortcode_border_width = self::$datebook_options['featured_border_width_other'];
			} else {
				$shortcode_border_width = '';
			}

			if(isset($atts['border_style'])){
				$shortcode_border_style = $atts['border_style'];
			} else if($is_front_page == 1 && self::$datebook_options['featured_border_style_front']){
				$shortcode_border_style =  self::$datebook_options['featured_border_style_front'];
			} else if($is_front_page == 0 && self::$datebook_options['featured_border_style_other']){
				$shortcode_border_style = self::$datebook_options['featured_border_style_other'];
			} else {
				$shortcode_border_style = '';
			}

			if(isset($atts['border_color'])){
				$shortcode_border_color = $atts['border_color'];
			} else if($is_front_page == 1 && self::$datebook_options['featured_border_color_front']){
				$shortcode_border_color = self::$datebook_options['featured_border_color_front'];
			} else if($is_front_page == 0 && self::$datebook_options['featured_border_color_other']){
				$shortcode_border_color = self::$datebook_options['featured_border_color_other'];
			} else {
				$shortcode_border_color = '';
			}

			if(isset($atts['round'])){
				$shortcode_round = $atts['round'];
			} else if($is_front_page == 1 && self::$datebook_options['featured_round_front']){
				$shortcode_round = self::$datebook_options['featured_round_front'];
			} else if($is_front_page == 0 && self::$datebook_options['featured_round_other']){
				$shortcode_round = self::$datebook_options['featured_round_other'];
			} else {
				$shortcode_round = '';
			}

			if(isset($atts['color_gamma'])){
				$shortcode_color_gamma = $atts['color_gamma'];
			} else if($is_front_page == 1 && self::$datebook_options['featured_color_gamma_front']){
				$shortcode_color_gamma = self::$datebook_options['featured_color_gamma_front'];
			} else if($is_front_page == 0 && self::$datebook_options['featured_color_gamma_other']){
				$shortcode_color_gamma = self::$datebook_options['featured_color_gamma_other'];
			} else {
				$shortcode_color_gamma = '';
			}

			/*if(isset($atts['shadow'])){
				$shortcode_shadow = $atts['shadow'];
			} else if($is_front_page == 1 && self::$datebook_options['featured_shadow_front']){
				$shortcode_shadow = self::$datebook_options['featured_shadow_front'];
			} else if($is_front_page == 0 && self::$datebook_options['featured_shadow_other']){
				$shortcode_shadow = self::$datebook_options['featured_shadow_other'];
			} else {
				$shortcode_shadow = '';
			}*/

			if(isset($atts['margin'])){
				$shortcode_margin = $atts['margin'];
			} else if($is_front_page == 1 && self::$datebook_options['featured_margin_front']){
				$shortcode_margin = self::$datebook_options['featured_margin_front'];
			} else if($is_front_page == 0 && self::$datebook_options['featured_margin_other']){
				$shortcode_margin = self::$datebook_options['featured_margin_other'];
			} else {
				$shortcode_margin = '';
			}

			if(isset($atts['padding'])){
				$shortcode_padding = $atts['padding'];
			} else if($is_front_page == 1 && self::$datebook_options['featured_padding_front']){
				$shortcode_padding = self::$datebook_options['featured_padding_front'];
			} else if($is_front_page == 0 && self::$datebook_options['featured_padding_other']){
				$shortcode_padding = self::$datebook_options['featured_padding_other'];
			} else {
				$shortcode_padding = '';
			}


			$featured_on_front_with_images = 0;
			if ($is_shortcode == 0) {
				$featured_on_front_sections = self::$datebook_options['featured_on_front'];
				if ($is_front_page == 1 && isset($featured_on_front_sections['with_images_only']) && $featured_on_front_sections['with_images_only'] == 1) {
					$featured_on_front_with_images = 1;
				}
			}
			$shortcode_with_images = isset($atts['with_images']) ? $atts['with_images'] : $featured_on_front_with_images;

			$featured_panel_color = isset(self::$datebook_options['featured_panel_color']) ? self::$datebook_options['featured_panel_color'] : 'transparent';
			$featured_panel_margin = isset(self::$datebook_options['featured_panel_topmargin']) ? self::$datebook_options['featured_panel_topmargin'] : '';
			// Check if Retina enabled in Theme Options
			$enable_retina_images = isset(self::$datebook_options['enable_retina_images']) && self::$datebook_options['enable_retina_images'] == 1 ? 1 : 0;
			$enable_profile_comments = isset(self::$datebook_options['enable_profile_comments']) && self::$datebook_options['enable_profile_comments'] == '1' ? 1 : 0;
			$featured_info_front = isset(self::$datebook_options['featured_info_front']) ? self::$datebook_options['featured_info_front'] : '';

			$featured_info_comments = 0;
			$featured_info_images = 0;
			$featured_info_travel = 0;
			$featured_info_sexorientation = 0;
			$featured_info_city = 0;
			$featured_info_country = 0;

			if ($is_shortcode == 0) {

				if($is_front_page == 1 && self::$datebook_options['featured_info_front']){
					$featured_info_sections = self::$datebook_options['featured_info_front'];
				} else if($is_front_page == 0 && self::$datebook_options['featured_info_other']){
					$featured_info_sections = self::$datebook_options['featured_info_other'];
				} else {
					$featured_info_sections = '';
				}

				if (isset($featured_info_sections['comments']) && $featured_info_sections['comments'] == 1) {
					$featured_info_comments = 1;
				}
				if (isset($featured_info_sections['images']) && $featured_info_sections['images'] == 1) {
					$featured_info_images = 1;
				}
				if (isset($featured_info_sections['travel']) && $featured_info_sections['travel'] == 1) {
					$featured_info_travel = 1;
				}
				if (isset($featured_info_sections['sexorientation']) && $featured_info_sections['sexorientation'] == 1) {
					$featured_info_sexorientation = 1;
				}
				if (isset($featured_info_sections['city']) && $featured_info_sections['city'] == 1) {
					$featured_info_city = 1;
				}
				if (isset($featured_info_sections['country']) && $featured_info_sections['country'] == 1) {
					$featured_info_country = 1;
				}

			}
		

			$shortcode_comments = isset($atts['comments']) ? $atts['comments'] : $featured_info_comments; // 0, 1
			$shortcode_moreimages = isset($atts['moreimages']) ? $atts['moreimages'] : $featured_info_images; // 0, 1
			$shortcode_travel = isset($atts['travel']) ? $atts['travel'] : $featured_info_travel; // 0, 1
			$shortcode_sexorientation = isset($atts['sexorientation']) ? $atts['sexorientation'] : $featured_info_sexorientation; // 0, 1
			$shortcode_city = isset($atts['city']) ? $atts['city'] : $featured_info_city; // 0, 1
			$shortcode_country = isset($atts['country']) ? $atts['country'] : $featured_info_country; // 0, 1

			$shortcode_direction = isset($atts['direction']) ? $atts['direction'] : 'horizontal'; // horizontal, vertical
			$shortcode_slide = isset($atts['slide']) ? 1 : 0; // 0, 1

			$options = array(
				'shortcode' => $is_shortcode,
				'is_front_page' => $is_front_page,
				'style' => $shortcode_style,
				'quantity' => $profile_quantity,
				'text_align' => $shortcode_text_align,
				'round' => $shortcode_round,
				'with_images' => $shortcode_with_images,
				'featured_panel_color' => $featured_panel_color,
				'featured_panel_margin' => $featured_panel_margin,
				'enable_retina_images' => $enable_retina_images,
				'enable_profile_comments' => $enable_profile_comments,
				'featured_info_front' => $featured_info_front,
				'margin' => $shortcode_margin,
				'padding' => $shortcode_padding,
				'border_width' => $shortcode_border_width,
				'border_style' => $shortcode_border_style,
				'border_color' => $shortcode_border_color,
				'color_gamma' => $shortcode_color_gamma,
				//'shadow' => $shortcode_shadow,
				'comments_show' => $shortcode_comments,
				'moreimages_show' => $shortcode_moreimages,
				'travel_show' => $shortcode_travel,
				'sexorientation_show' => $shortcode_sexorientation,
				'city_show' => $shortcode_city,
				'country_show' => $shortcode_country,
				'direction' => $shortcode_direction,
				'slide' => $shortcode_slide,

				'how_many_columns_on_mobile' => $how_many_columns_on_mobile,
				'how_many_columns_on_tablet' => $how_many_columns_on_tablet,
				'how_many_columns_on_normal' => $how_many_columns_on_normal,
				'how_many_columns_on_large' => $how_many_columns_on_large

			);
			
			if($get_day_from_code != DateBook_Utilities::get_current_day()){
				exit();
			}

		    // display the Edit Profile form
			return DateBook_Template_Loader::load( 'featured/featured-profiles', $options );
			
		}
	}


	/**
	 * Show featured profiles
	 *
	 * @access public
	 * @return void
	 */
	public static function process_featured_profiles() {

		$featured_enabled_sections = self::$datebook_options['featured_enabled'];

		if (isset($featured_enabled_sections['show']) && $featured_enabled_sections['show'] == 1) {

			$options = array(
				'featured_enabled' => 1
			);

			echo self::pre_process_featured_profiles('', $options);	

		}
	}


	/**
	 * Add featured class to body html
	 * 
	 * @access public
	 */
	public static function process_featured_body_class() {
		
		global $post;
		$profile_id = isset($post->ID) ? $post->ID : 0;

		if ($profile_id > 1) {

			$get_day_from_code = DATEBOOK_PURCHASE_CODE;
			$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

			if($get_day_from_code != DateBook_Utilities::get_current_day()){
				exit();
			}

			$featured = get_post_meta($profile_id, 'featured', true);
			if ($featured == '1') {
				add_filter( 'body_class', array( __CLASS__, 'featured_body_class') );
				add_action( 'wp_enqueue_scripts', array( __CLASS__, 'featured_body_css' ), 10000 );
			}
		}
	}


	public static function featured_body_class( $classes ) {

		$classes[] = 'datebook-featured-style';
		return $classes;

	}


	public static function featured_body_css() {

		if (isset(self::$datebook_options['enable_default_images_for_featured_profiles']) && self::$datebook_options['enable_default_images_for_featured_profiles'] == 1) {

			global $post;
			$profile_id = isset($post->ID) ? $post->ID : 0;

			if ($profile_id > 1) {

				// Get Profile personal data
				$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);

				$random_pattern = rand(1, 9);

				$featured_pattern_url = isset($get_profile_data['featured_pattern']) ? $get_profile_data['featured_pattern'] : DATEBOOK_URL . 'assets/images/patterns/bg-featured-0' . $random_pattern . '.jpg'; //bg-featured-snow.jpg

				$datebook_featured_css = '
					.datebook-featured-style {
						background-image: url("' . esc_url($featured_pattern_url) . '");
						background-repeat: repeat;
					}';

				wp_add_inline_style( 'datebook-style-plugin', $datebook_featured_css );
			}
		}
	}


	/**
	 * Return Featured images panel on Single Profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_process_featured_images_panel() {
		
		if (is_user_logged_in()) {

			$featured_background_images = isset(self::$datebook_options['featured_background_images']) && is_array(self::$datebook_options['featured_background_images']) && !empty(self::$datebook_options['featured_background_images']) ? self::$datebook_options['featured_background_images'] : '';

			if(isset($featured_background_images) && is_array($featured_background_images) && !empty($featured_background_images)){

				if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
					$current_user_id = DATEBOOK_CURRENT_USER_ID;
				} else {
					global $current_user;
					wp_get_current_user();
					$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
				}

				// If profile ID is not set in post_meta table then let's insert it
				$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

				$featured = get_post_meta($profile_id, 'featured', true);
				if ($featured == '1') {
					
					$get_day_from_code = DATEBOOK_PURCHASE_CODE;
					$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

					if($get_day_from_code != DateBook_Utilities::get_current_day()){
						exit();
					}

					// Get personal data of sender user
					$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
					$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

					$featured_pattern = isset($datebook_get_data['featured_pattern']) ? $datebook_get_data['featured_pattern'] : '';

					$options = array('profile_id' => $profile_id, 'featured_pattern' => $featured_pattern, 'featured_background_images' => $featured_background_images);

					// display the Featured image panel on Single Profile page above
					return DateBook_Template_Loader::load( 'featured/featured-images-panel', $options );

				}
			}
		}
	}


	/**
	 * Show Featured images panel on Single Profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_featured_images_panel() {

		echo self::pre_process_featured_images_panel();

	}


}

//DateBook_Featured_Profiles::init();
$dateBook_featured_profiles = new DateBook_Featured_Profiles($datebook_options_array);