<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Contact_Page
 *
 * @class DateBook_Contact_Page
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Contact_Page {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_contact_form', array( __CLASS__, 'datebook_show_contact_page' ) );
		add_shortcode( 'datebook_contact_form', array( __CLASS__, 'datebook_return_contact_form' ) );

	}
	

	/**
	 * Send message to Administrator
	 *
	 * @access private
	 * @return void
	 */
	private static function datebook_send_message() {

		if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
			exit();
		}

		global $datebook_form_error, $datebook_alert_error, $datebook_alert_text, $datebook_contact_text;

		if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
			$current_user_id = DATEBOOK_CURRENT_USER_ID;
		} else {
			global $current_user;
			wp_get_current_user();
			$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
		}

		// Someone sends a message to another user
		if (isset($_POST['action']) && $_POST['action'] == 'contactus' && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {
			
			// instantiate the class
			$datebook_form_error = new WP_Error;
			
			$datebook_alert_error = array();
			$datebook_alert_text = array();
			$datebook_contact_text = array();
		
			if (isset($_POST['emails']) && $_POST['emails']) {
				$datebook_form_error->add( 'fake_email', esc_html__( 'Are you spammer?', 'datebook' ), 'has-error' );
			}


			$datebook_contact_text['contacting_name'] = sanitize_text_field(wp_strip_all_tags($_POST['contacting_name']));
			if (!$datebook_contact_text['contacting_name']) {
				$datebook_form_error->add( 'your_name', esc_html__( 'Your name is missing', 'datebook' ), 'has-error' );
			}


			$datebook_contact_text['contacting_email'] = sanitize_email($_POST['contacting_email']);
			if (!empty($datebook_contact_text['contacting_email'])) {
				if ( !is_email($datebook_contact_text['contacting_email']) ) {
					$datebook_form_error->add( 'your_email', esc_html__( 'Your email address seems to be wrong', 'datebook' ), 'has-error' );
				}
			} else {
				$datebook_form_error->add( 'your_email', esc_html__( 'Your email address seems to be wrong', 'datebook' ), 'has-error' );
			}


			$datebook_contact_text['contacting_text'] = sanitize_text_field(wp_strip_all_tags($_POST['contacting_text']));
			if (!$datebook_contact_text['contacting_text']) {
				$datebook_form_error->add( 'your_text', esc_html__( 'You need to write a message', 'datebook' ), 'has-error' );
			}
			

			if ( 1 > count( $datebook_form_error->get_error_messages() ) ) {

				$to_email = of_get_option('email_website') ? of_get_option('email_website') : get_bloginfo('admin_email');

				$select_email_template = 'message_from_contactus_page';
				include DateBook_Template_Loader::locate( 'misc/email-templates' );

				$datebook_mail = DateBook_Utilities::datebook_email_send($datebook_contact_text['contacting_name'], $datebook_contact_text['contacting_email'], $to_email, esc_html__( 'Contact message from', 'datebook' )." ".of_get_option('email_sitename'), $body);

				unset($datebook_contact_text['contacting_name'], $datebook_contact_text['contacting_email'], $datebook_contact_text['contacting_text'], $body);
				
				$datebook_alert_text['success_text'] = esc_html__( 'Your message has been sent', 'datebook' );
				
			} else {

				$datebook_alert_text['error_required_fields'] = esc_html__( 'Please, fill in all required fields colored red', 'datebook' );

				foreach($datebook_form_error->get_error_codes() as $code){

					$datebook_alert_error[$code] = $datebook_form_error->get_error_data($code);
					$datebook_alert_text[$code] = $datebook_form_error->get_error_message($code);

				}

			}

		}
	}


	/**
	 * Show contact form and process all data
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_return_contact_form() {

		if (isset($_POST['action']) && $_POST['action'] == 'contactus' && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			self::datebook_send_message();

		}

		if(of_get_option('email_website')){

			// display the Contact form
			return DateBook_Template_Loader::load( 'contact/contact-form' );

		} else {

			// display the Contact form is not set yet
			return DateBook_Template_Loader::load( 'contact/page-contact-not-ready' );

		}

	}


	/**
	 * Show contact form and process all data
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_show_contact_page() {

		echo DateBook_Template_Loader::load( 'contact/page-contact' );

	}

}

//DateBook_Contact_Page::init();
$dateBook_contact_page_class = new DateBook_Contact_Page($datebook_options_array);