<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Page_Profiles
 *
 * @class DateBook_Page_Profiles
 * @package DateBook/Classes/Profiles
 * @author Pagick Themes
 */
class DateBook_Page_Profiles {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_all_profiles', array( __CLASS__, 'process_profiles' ) );
		add_shortcode('datebook_profiles_line', array( __CLASS__, 'pre_process_profiles' ) );

	}


	/**
	 * Return featured profiles
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_process_profiles($atts = array()) {

		if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
			exit();
		}

		if(in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)){

			$is_shortcode = !empty($atts) && is_array($atts) ? 1 : 0;
			$shortcode_quantity = isset($atts['quantity']) ? $atts['quantity'] : 12; // 6, 12
			$shortcode_round = isset($atts['round']) ? $atts['round'] : 1; // 0, 1, 2
			$shortcode_with_images = isset($atts['with_images']) ? $atts['with_images'] : 1; // 1, 0
			$shortcode_border_width = isset($atts['border_width']) ? $atts['border_width'] : 0; // 0, 1
			$shortcode_border_color = isset($atts['border_color']) ? $atts['border_color'] : 0; // 0, random, #FF6600
			$shortcode_border_style = isset($atts['border_style']) ? $atts['border_style'] : 0; // 0, 1
			$shortcode_shadow = isset($atts['shadow']) ? $atts['shadow'] : 0; // 0, 1, 2, 3
			$shortcode_space = isset($atts['space']) ? $atts['space'] : 1; // 0, 1
			$shortcode_direction = isset($atts['direction']) ? $atts['direction'] : 'horizontal'; // horizontal, vertical
			$shortcode_slide = isset($atts['slide']) ? 1 : 0; // 0, 1
			
			$get_day_from_code = DATEBOOK_PURCHASE_CODE;
			$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

			if($get_day_from_code != DateBook_Utilities::get_current_day()){
				exit();
			}

			$options = array(
				'shortcode' => $is_shortcode, 
				'quantity' => $shortcode_quantity, 
				'round' => $shortcode_round, 
				'with_images' => $shortcode_with_images, 
				'border_width' => $shortcode_border_width, 
				'border_color' => $shortcode_border_color, 
				'border_style' => $shortcode_border_style, 
				'shadow' => $shortcode_shadow, 
				'space' => $shortcode_space, 
				'direction' => $shortcode_direction,
				'slide' => $shortcode_slide
			);

		    // display the Edit Profile form
			return DateBook_Template_Loader::load( 'profiles/profiles-line', $options );
			
		}
	}


	/**
	 * Show featured profiles
	 *
	 * @access public
	 * @return void
	 */
	public static function process_profiles() {

		$featured_enabled_sections = of_get_option('featured_enabled');

		if (isset($featured_enabled_sections['show']) && $featured_enabled_sections['show'] == 1 && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			$shown_featured_to_loggedin_users_only = DateBook_Utilities::datebook_show_to_logged_in_users($featured_enabled_sections['show_to_loggedin_users']);

			$show_feat_profiles = 0;

			if ($shown_featured_to_loggedin_users_only == 1) {
				
				if (is_category() && of_get_option('featured_on_cats') == 1) {
					$show_feat_profiles = 1;
				}

				if (get_post_type() == DATEBOOK_POST_TYPE && of_get_option('featured_on_profiles') == 1) {
					$show_feat_profiles = 1;
				}

				if (is_page(of_get_option('search_results_page')) && of_get_option('featured_on_search') == 1) {
					$show_feat_profiles = 1;
				}

				if (of_get_option('featured_on_tours') == 1) {
					if (get_post_type() == DATEBOOK_TOUR_TYPE || is_page(of_get_option('all_tours_page'))) {
						$show_feat_profiles = 1;
					}
				}

				if (of_get_option('featured_on_classifieds') == 1) {
					if (get_post_type() == DATEBOOK_CLASSIFIEDS_TYPE || is_page(of_get_option('all_classifieds_page'))) {
						$show_feat_profiles = 1;
					}
				}
				
				$featured_on_front_sections = of_get_option('featured_on_front');

				if (is_front_page() && isset($featured_on_front_sections['show']) && $featured_on_front_sections['show'] == 1) {
					$show_feat_profiles = 1;
				}

			} else {

				$show_feat_profiles = 0;

			}


			// Display featured profiles
			if (isset($show_feat_profiles) && $show_feat_profiles == 1) {

				echo self::pre_process_profiles();	

			}
		}
	}


}

//DateBook_Page_Profiles::init();
$dateBook_page_profiles_class = new DateBook_Page_Profiles($datebook_options_array);