<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Profile_Verification
 *
 * @class DateBook_Profile_Verification
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Profile_Verification {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_edit_verification', array( __CLASS__, 'datebook_process_edit_verification' ) );
		add_action( 'datebook_ajax_verification', array( __CLASS__, 'datebook_process_ajax_photos' ) );

	}


	/**
	 * Upload photo
	 *
	 * @access private
	 * @return void
	 */
	private static function datebook_upload_photo() {

		if( isset( $_POST['datebook_image_upload'] ) && !empty( $_FILES['images'] ) && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			// Make global
			global $profile_id;

			if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
				$current_user_id = DATEBOOK_CURRENT_USER_ID;
			} else {
				global $current_user;
				wp_get_current_user();
				$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
			}
			
			if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
				exit();
			}

			$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

			if ($profile_id) {

				$datebook_post_image_upload = $_POST['datebook_image_upload'];

				$datebook_files_images = $_FILES['images'];

				// Mark this action as Verification
				$datebook_photo_type = DATEBOOK_VERIFICATION_IMAGE_TYPE;

				// Define which image formats to be created
				$datebook_photo_formats = array(
					'image_big'		=> array('crop' => false, 'watermark' => false), 
					'image_profile'	=> array('crop' => false, 'watermark' => false)
				);

				// Set up Default image to show after upload
				$default_thumbnail_show = array('format' => 'image_profile', 'crop' => false, 'watermark' => false);

				$image_result_array = DateBook_Utilities::process_upload_photo($datebook_post_image_upload, $datebook_files_images, $datebook_photo_type, $datebook_photo_formats, $profile_id, $default_thumbnail_show, $current_user_id);

				if(isset($image_result_array['imgid'])){
					update_post_meta($image_result_array['imgid'], 'new', '1');
				}

				echo wp_send_json($image_result_array);

			}
		}
	}


	/**
	 * Delete Verification photo
	 *
	 * @access private
	 * @return void
	 */
	private static function datebook_delete_photo() { 

		if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
			$current_user_id = DATEBOOK_CURRENT_USER_ID;
		} else {
			global $current_user;
			wp_get_current_user();
			$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
		}

		// Catch Verification Photo ID
		$attachment_id = (int)$_GET['id'];
		if ($attachment_id == 0) { die(); }

		$profile_type = get_user_meta( $current_user_id, 'profile_type', true);

		if (($profile_type == DATEBOOK_POST_TYPE || is_super_admin()) && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {
			
			if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
				exit();
			}

			$post = get_post($attachment_id);

			$profile_id = get_user_meta( $current_user_id, 'profile_postid', true);

			$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
			$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

			$realphotos_photo = isset($datebook_get_data[DATEBOOK_VERIFICATION_CONFIRM_PHOTO]) ? $datebook_get_data[DATEBOOK_VERIFICATION_CONFIRM_PHOTO] : 0;

			if ($post->ID == $realphotos_photo) {

				$upload_folder = isset($datebook_get_data['upload_folder']) ? $datebook_get_data['upload_folder'] : '';

				wp_delete_attachment( $post->ID, $force_delete = true );

				// Delete all selected images
				DateBook_Utilities::datebook_delete_all_photos($upload_folder, $post->post_title);

				unset($datebook_get_data[DATEBOOK_VERIFICATION_CONFIRM_PHOTO]);

				// Update the post meta
				update_post_meta($profile_id, 'profile_personal_data', $datebook_get_data);

				echo '<div class="alert alert-success">'. esc_html__( 'Your image has been deleted', 'datebook' ).'</div>';
			}			
		}
	}


	/**
	 * Send message to Administrator
	 *
	 * @access private
	 * @return void
	 */
	public static function datebook_send_message_to_admin($profile_id) {

		if (isset($profile_id) && of_get_option('email_when_verification') == '1' && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
				exit();
			}

			$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
			$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

			//check when was the last time we sent an email to the admin
			$when = isset($datebook_get_data['verification_confirm_photo_emailsent_when']) ? $datebook_get_data['verification_confirm_photo_emailsent_when'] + 30 : 0; //we add 30 seconds to the time
			
			if ($when < time()) {

				//send email to admin and notify him of the uploaded files
				$body = esc_html__( 'Hello admin', 'datebook' ).',<br />
				'.esc_html__( 'Someone has uploaded images to the "Verification" section and is awaiting for your verification', 'datebook' ).':<br /><br />
				'.esc_html__( 'Go to this page and check the image', 'datebook' ).':<br />
				<a href="' . esc_url(get_permalink($profile_id)) . '">' . esc_url(get_permalink($profile_id)) . '</a><br /><br />';
				
				$to_email = of_get_option('email_website') ? of_get_option('email_website') : get_bloginfo('admin_email');
				$subject_in_email = esc_html__( 'Verification image uploaded on', 'datebook' ) . ' ' . of_get_option('email_sitename');

				$datebook_mail = DateBook_Utilities::datebook_email_send('', '', $to_email, $subject_in_email, $body);

				// Save the post meta for verification
				$datebook_get_data['verification_confirm_photo_emailsent_when'] = time();

				// Update the post meta
				update_post_meta($profile_id, 'profile_personal_data', $datebook_get_data);

			}
			
		}

	}


	/**
	 * Ajax functions
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_ajax_functions() {

		if( isset( $_GET['action'] ) ) {
			
			//Catch the whatisit - cities, logincheck, defaultimage, realphotodelete, activateprofile, logodelete, favoriteset, tourdelete, touredit
			$whatisit = isset( $_GET['whatisit'] ) ? esc_attr($_GET['whatisit']) : '';

			if ($whatisit == 'realphotodelete') {
				
				// Delete profile account
				self::datebook_delete_photo();
				
			}
			
		}
		
		if ( isset( $_POST['datebook_image_upload'] ) && !empty( $_FILES['images'] )) {
			
			// update all the input data
			self::datebook_upload_photo();
			
		}
		
		if (isset( $_SERVER['HTTP_X_REQUESTED_WITH'] )) {
				
			die();
				
		}
		
	}


	/**
	 * Process ajax upload function
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_process_ajax_photos() {


		if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
				
			// update all the input data
			add_action( 'wp_loaded', self::datebook_ajax_functions() );
				
		} else {
				
			// update all the input data
			self::datebook_upload_photo();
				
		}
	
	}


	/**
	 * Show photo form and process all data
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_process_edit_verification() {

		self::datebook_process_ajax_photos();
     
	    // display the Edit Profile form
		echo DateBook_Template_Loader::load( 'profile/profile-verification' );

	}


}

//DateBook_Profile_Verification::init();
$dateBook_profile_verification_class = new DateBook_Profile_Verification($datebook_options_array);