<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class DateBook_Payment_Gateway_Free
 *
 * @class DateBook_Payment_Gateway_Free
 * @package DateBook/Classes
 * @author Pagick Themes
 */


/**
 * Extends the payment gateway base class for Free Payment
 *
 */
class DateBook_Payment_Gateway_Free extends DateBook_Payment_Gateway {

    /**
     * The features supported by the payment gateway
     *
     * @access public
     * @var array
     *
     */
    public $supports;


    /**
     * Constructor
     *
     */
    public function __construct( $data = array() ) {

		$this->supports = array('change_subscription_payment_method_admin');

	}


    /*
     * Redirect after payment made to Subscription page
     *
	 * Third step of processing Subscription data
	 *
     */
    public function process_redirect_to_payment_gateway($payment_data) {
		
        // Do nothing if the payment id wasn't sent
        if( ! $payment_data['payment_id'] )
            return;

		$query_page_link = add_query_arg( array(
            'subscription_id'	=> $payment_data['subscription_plan_id'],
			'plan'				=> $payment_data['plan'],
			'payment_id'		=> $payment_data['payment_id'],
            'price'				=> $payment_data['amount'],
			'recurring'			=> $payment_data['recurring'],
			'payment_page'		=> $payment_data['payment_page'],
			'payment_gateway'	=> $payment_data['payment_gateway'],
			'datebooktkn'		=> $payment_data['datebooktkn']
		), get_permalink(of_get_option('my_upgrade_page')) );


		// Redirect only if tkn is set
		if( isset( $_POST['datebooktkn'] ) ) {
			wp_redirect($query_page_link);
			exit;
		}

    }


	/**
	 * Get response from Subscription form and process it
	 * 
	 * Fourth step of processing Subscription data
	 *
	 * @access public
	 */
	public static function datebook_process_payment_response() {

		if (isset($_GET['payment_page']) && $_GET['payment_page'] == '3' && isset($_GET['payment_id']) && isset($_GET['payment_gateway']) && $_GET['payment_gateway'] == 'free' && ( isset( $_REQUEST['datebooktkn'] ) || wp_verify_nonce( $_REQUEST['datebooktkn'], 'datebook_new_subscription_form_nonce' ) )) {

			$post_data = $_GET;

			// Get payment id from custom variable sent by IPN
			$payment_id = isset( $post_data['payment_id'] ) ? $post_data['payment_id'] : 0;
			
			// Get the payment
			$payment = datebook_get_payment( $payment_id );
			
			// If the payment has already been completed do nothing
			if( $payment->status == 'completed' ) return;

			$profile_id = isset($payment->profile_id) ? $payment->profile_id : 0;
			
			// If the status is completed update the payment and also activate the member subscriptions
			if( $payment->id == $payment_id ) {

				$get_subscription_plans = get_option('datebook_subscription_plans');

				$subscription_plan_id = isset($payment->subscription_plan_id) ? $payment->subscription_plan_id : 0;
				$subscription_plan_user_id = isset($payment->user_id) ? $payment->user_id : 0;
				$subscription_plan_price_period = $payment->plan_price_period ? $payment->plan_price_period : 0;

				$subscription_plan_start_date = isset($payment->start_date) ? $payment->start_date : date('Y-m-d H:i:s');
				$subscription_plan_expiration_date = $payment->expiration_date ? $payment->expiration_date : '0000-00-00 00:00:00';

				$payment_data = array(
					'subscription_plan_id'   => $post_data['subscription_id'],
					'plan'              => $post_data['plan'],
					'payment_id'		=> $payment_id,
					'plan_price_period' => 0,
					'profile_id'		=> $profile_id,
					'user_id'		    => $subscription_plan_user_id,
					'start_date'		=> $subscription_plan_start_date,
					'expiration_date'	=> $subscription_plan_expiration_date,
					'transaction_id'	=> '',
					'status'			=> 'active',
					'date'			    => $subscription_plan_start_date,
					'price'			    => 0, 
					'recurring'		    => 0,
					'starts'			=> strtotime($subscription_plan_start_date),
					'ends'			    => $subscription_plan_expiration_date
				);
					
				$payment_data['payment_gateway'] = 'free';

				// Let's activate Subscription for member after payment is made. Place this action at the end of payment process
				do_action('datebook_activate_subscription_after_payment', $payment_data);

			} else {

				// If payment status is not complete, something happened, so log it in the payment
				$log_data = array(
					'date'           => $post_data['subscr_date'],
					'payer_id'       => $post_data['payer_id'],
					'payer_email'    => $post_data['payer_email'],
					'payer_status'   => $post_data['payer_status']
				);

				$payment->add_log_entry( 'failure', esc_html__( 'The payment could not be completed successfully', 'datebook' ), $log_data );

			}
		}
	}


}