<?php
/*
 * @package DateBook WooCommerce Subscription
 * @since   3.0
 *
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

function datebook_add_woocommerce_extension() {

	// Woocommerce installation check
	if (!function_exists( 'WC' ) ) {

		if (is_super_admin()) {

			function sample_admin_notice__success() {

				echo '<div class="notice notice-success is-dismissible"><p>';

				echo esc_html__( 'WooCommerce Subscription is selected in Theme Options. But the WooCommerce plugin is not installed yet. You must install WooCommerce in order to accept payments. Otherwise, the integrated functions of the DateBook Subscription will be used. You will still be able to accept payments.', 'datebook' );
				
				echo '</p></div>';

			}

			add_action( 'admin_notices', 'sample_admin_notice__success' );

		}

	} else {

		if( ! class_exists( 'WP_List_Table' ) ) {
			require( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
		}

		require( DATEBOOK_DIR . 'includes/payment/woocommerce/includes/class-datebook-functions.php' );
		require( DATEBOOK_DIR . 'includes/payment/woocommerce/includes/class-datebook-wc-compatibility.php' );
		require( DATEBOOK_DIR . 'includes/payment/woocommerce/includes/class-datebook-wc-start.php' );
		require( DATEBOOK_DIR . 'includes/payment/woocommerce/includes/class-datebook-wc-susbscription-post-type.php' );
		require( DATEBOOK_DIR . 'includes/payment/woocommerce/includes/class-datebook-wc-subscription.php' );
		require( DATEBOOK_DIR . 'includes/payment/woocommerce/includes/class-datebook-wc-subscription-order.php' );
		require( DATEBOOK_DIR . 'includes/payment/woocommerce/includes/class-datebook-wc-subscription-cart.php' );
		require( DATEBOOK_DIR . 'includes/payment/woocommerce/includes/class-datebook-wc-subscription-admin.php' );
		require( DATEBOOK_DIR . 'includes/payment/woocommerce/includes/class-datebook-wc-subscriptions-list-table.php' );

		DateBook_WC_Start();

	}
}

if (of_get_option('activate_woocommerce_subscription') == '2') {

	add_action( 'plugins_loaded', 'datebook_add_woocommerce_extension', 11 );

}