<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Implements DateBook_WC_Subscription_Post_Type Class
 *
 * @class   DateBook_WC_Subscription_Post_Type
 * @package DateBook WooCommerce Subscription
 * @since   3.0
 */
if ( ! class_exists( 'DateBook_WC_Subscription_Post_Type' ) ) {

	/**
	 * Class DateBook_WC_Subscription_Post_Type
	 */
	class DateBook_WC_Subscription_Post_Type {

		/**
		 * Single instance of the class
		 *
		 */
		protected static $instance;


		/**
		 * Returns single instance of the class
		 *
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Constructor
		 *
		 */
		public function __construct() {

			add_action( 'init', array( $this, 'register_subscription_post_type' ) );

		}


		/**
		 * Register datebook_subscribe post type
		 *
		 */
		public function register_subscription_post_type() {

			$labels = array(
				'name'               => _x( 'Subscriptions', 'Post Type General Name', 'datebook' ),
				'singular_name'      => _x( 'Subscription', 'Post Type Singular Name', 'datebook' ),
				'menu_name'          => esc_html__( 'Subscription', 'datebook' ),
				'parent_item_colon'  => esc_html__( 'Parent Item:', 'datebook' ),
				'all_items'          => esc_html__( 'All Subscriptions', 'datebook' ),
				'view_item'          => esc_html__( 'View Subscriptions', 'datebook' ),
				'add_new_item'       => esc_html__( 'Add New Subscription', 'datebook' ),
				'add_new'            => esc_html__( 'Add New Subscription', 'datebook' ),
				'edit_item'          => esc_html__( 'Subscription', 'datebook' ),
				'update_item'        => esc_html__( 'Update Subscription', 'datebook' ),
				'search_items'       => esc_html__( 'Search Subscription', 'datebook' ),
				'not_found'          => esc_html__( 'Not found', 'datebook' ),
				'not_found_in_trash' => esc_html__( 'Not found in Trash', 'datebook' ),
			);

			$args = array(
				'label'               => esc_html__( 'DateBook Subscription', 'datebook' ),
				'labels'              => $labels,
				'supports'            => false,
				'hierarchical'        => false,
				'public'              => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'capabilities'        => array(
					'create_posts' => false, // Removes support for the "Add New" function ( use 'do_not_allow' instead of false for multisite set ups )
					'edit_post'    => 'edit_subscription',
					'delete_post'  => 'delete_subscription',

				),
				'map_meta_cap'        => false
			);


			register_post_type( 'datebook_subscribe', $args );
			flush_rewrite_rules();
		}




		/**
		 * Get all subscriptions of a user
		 *
		 */
		public function get_subscriptions_by_user( $user_id ) {
			$subscriptions = get_posts(
				array(
					'post_type'      => DateBook_WC_Start()->post_name,
					'posts_per_page' => - 1,
					'meta_key'       => 'user_id',
					'meta_value'     => $user_id,
				)
			);

			return $subscriptions;
		}



	}

}


/**
 * Unique access to instance of DateBook_WC_Subscription class
 *
 */
function DateBook_WC_Subscription_Post_Type() {
	return DateBook_WC_Subscription_Post_Type::get_instance();
}