<?php
/**
 * The default template for displaying random Profiles on front page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

$show_gender = $show_age = $show_location = 0;

$normal_on_front_sections = of_get_option('normal_on_front');

$normal_on_front_with_images = (isset($normal_on_front_sections['with_images_only']) && $normal_on_front_sections['with_images_only'] == 1) ? 1 : 0;

if ($normal_on_front_with_images == 1) {

	$show_normal_profiles_args = array(
		'key' => 'profile_photo_id',
		'value' => '',
		'compare' => '!=',
	);

} else {

	$show_normal_profiles_args = '';

}

$front_quantity_normal_profiles = of_get_option('normal_quantity_front') ? of_get_option('normal_quantity_front') : 15;

$args = array(
	'no_found_rows' => true, 
	'post_type' => DATEBOOK_POST_TYPE,
	'post_status' => 'publish',
	'orderby' => 'rand',
	'posts_per_page' => $front_quantity_normal_profiles,
	'meta_query' => array(
		$show_normal_profiles_args
	)
);

$the_query = new WP_Query( $args );

if ( $the_query->have_posts() &&  $the_query->post_count >= $front_quantity_normal_profiles ) : 

	$datebook_field_titles = get_query_var( 'datebook_field_titles' );
	if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

	$normal_profiles_round = $normal_profiles_padding = $border_mode = $normal_border_bootstrap = $normal_profiles_border = $normal_border_color = $normal_color_gamma = '';

	if(of_get_option('datebook_custom_profiles')){
	
		$normal_round_front = absint(of_get_option('normal_round_front'));
		switch ($normal_round_front) {
			case '1' : $normal_profiles_round = ''; break;
			case '2' : $normal_profiles_round = ' rounded'; break;
			case '3' : $normal_profiles_round = ' rounded-circle'; break;
			default: $normal_profiles_round = ''; break;
		}

		$normal_padding_front = absint(of_get_option('normal_padding_front'));
		switch ($normal_padding_front) {
			case '1' : $normal_profiles_padding = ''; break;
			case '2' : $normal_profiles_padding = ' m-1'; $padding_value = '.25'; break;
			case '3' : $normal_profiles_padding = ' m-2'; $padding_value = '.5'; break;
			case '4' : $normal_profiles_padding = ' m-3'; $padding_value = '1'; break;
			case '5' : $normal_profiles_padding = ' m-4'; $padding_value = '1.5'; break;
			case '6' : $normal_profiles_padding = ' m-5'; $padding_value = '3'; break;
			default: $normal_profiles_padding = ''; $padding_value = ''; break;
		}
		
		$margin_left_right = !empty($normal_padding_front) ? 'margin-left: -' . $padding_value . 'rem; margin-right: -' . $padding_value . 'rem;' : '';

		$normal_border_front = of_get_option('normal_border_front');
		$border_mode = '';
		if($normal_border_front == '0' && is_numeric($normal_border_front)) {
			$normal_border_bootstrap = '';
			$normal_profiles_border = ' border-width: 0px !important;';
		} else if ( preg_match('/^\d+(?:,\d+)*$/', $normal_border_front) ){
			$normal_border_bootstrap = ' border';
			$get_border_number = explode(',', $normal_border_front);
			$border_mode = 'random';
		} else if($normal_border_front > 0 && is_numeric($normal_border_front)) {
			$normal_border_bootstrap = ' border';
			$normal_profiles_border = ' border-width: ' . $normal_border_front . 'px !important;';
		} else {
			$normal_border_bootstrap = '';
			$normal_profiles_border = '';
		}
		
		$normal_border_color = of_get_option('normal_border_color');
		$normal_color_gamma = of_get_option('normal_color_gamma');

	}

	if (DateBook_Utilities::datebook_show_field('gender', 1) && (of_get_option('gender_allowed') != '' || of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '')) {

		$show_gender = 1;

	}

	if (DateBook_Utilities::datebook_show_field('birthdate', 1)) {

		$show_age = 1;

	}

	$show_sexual_orientation = (DateBook_Utilities::datebook_show_field('sexualorientation', 1) && (of_get_option('sexual_orientation_allowed') != '' || of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '')) ? 1 : 0;

	if (DateBook_Utilities::datebook_show_field('countrycity', 1)) {

		$show_location = 1;

	}

	// Check if Retina enabled in Theme Options
	$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

	$search_default_thumbnail = of_get_option('search_default_thumbnail') ? 1 : 0;

	$i = 0;
	$width_container = '';
	$width_block = '';

	$datebook_show_birthdate = DateBook_Utilities::datebook_show_field('birthdate', 1);
	$datebook_show_gender = DateBook_Utilities::datebook_show_field('gender', 1);
	$datebook_show_city = DateBook_Utilities::datebook_show_field('countrycity', 1);

	// set up cache folder
	$upload_dir = wp_upload_dir();
	$cache_url  = trailingslashit( $upload_dir['baseurl'] . '/' . DATEBOOK_OPTIONS_FOLDER . '/images');

?>

<div class="mb-3 shadow-none datebook-front-random-profiles">
	<div class="row" style=" <?php echo esc_attr($margin_left_right);?>">

		<?php

		while ( $the_query->have_posts() ) : $the_query->the_post();

			$profile_id = absint(get_the_ID());

			$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
			$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

			$profile_name = get_the_title();

			$country = $region = $city = '';

			if(isset($datebook_get_data['city'])){

				$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
				$city = isset($term_data->city) ? $term_data->city : '';
				$country = isset($term_data->country) ? $term_data->country : '';

			}

			$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) : '';
			$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;
			$sexualorientation = isset($datebook_get_data['sexualorientation']) ? $datebook_get_data['sexualorientation'] : '';


			// if some data do not exist then do not show this profile
			if (!$profile_name || $datebook_show_birthdate == 1 && isset($age) && $age < 1 || $datebook_show_gender == 1 && isset($gender) && $gender < 1 || $datebook_show_city == 1 && isset($city) && strlen($city) < 1 && isset($country) && strlen($country) < 1) continue;

			$i++;

			if ($gender == 1) {
				$gender_icon = 'fa fa-venus fa-lg';
			} else if ($gender == 2) {
				$gender_icon = 'fa fa-mars fa-lg';
			} else {
				$gender_icon = 'fa fa-user fa-lg';
			}


			$title_for_alt = $profile_name . ', ' . $age;

			if ($show_sexual_orientation == 1 && isset($datebook_sexualorientation_titles[$sexualorientation])){

				$sexualorientation = $sexualorientation == 2 && isset($gender) && $gender > 0 ? $gender.$sexualorientation . '00' : $sexualorientation;

				$title_for_alt .= ', ';
				$title_for_alt .= esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' );
			}


			if (isset($city)) {
				$title_for_alt .= esc_attr($city);
			}
			if (!empty($city) && !empty($country)) {
				$title_for_alt .= ', ';
			}
			if (isset($country)) {
				$title_for_alt .= esc_attr($country);
			}

			$all_photos_args = array(
				'post_parent' => $profile_id, 
				'post_status' => 'inherit', 
				'post_type' => 'attachment', 
				'post_mime_type' => 'image', 
				'order' => 'ASC', 
				'orderby' => 'menu_order ID',
				'posts_per_page' => -1,
				'meta_query' => array(
					array('key' => DATEBOOK_IMAGE_TYPE, 'value' => DATEBOOK_PROFILE_IMAGE_TYPE, 'compare' => '=' )
				)
			);

			$all_photos = new WP_Query( $all_photos_args );

			$all_photos_count = $all_photos->found_posts - 1;

			$all_photos_count = ($all_photos_count > 0) ? $all_photos_count : 0;

			$links = get_permalink($profile_id);

			// Big image
			$which_big_column = array(1, 6, 11, 20, 25, 30, 31, 36, 41, 50, 55, 60, 61, 66, 71, 80, 85, 90, 91, 96, 101, 110, 115, 120);
			if (in_array($i, $which_big_column)) {
				$columns_image_format = 'image_front_medium';
				$width_block .= '<div class="col-lg-2 col-md-4 col-sm-4 col-4">';
				$width_block .= '<div class="row">';
				$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, $columns_image_format, $gender, true, $datebook_get_data, $search_default_thumbnail);
			}

			// Small image
			$which_small_column = array(2, 7, 12, 16, 21, 26, 32, 37, 42, 46, 51, 56, 62, 67, 72, 76, 81, 86, 92, 97, 102, 106, 111, 116);
			if (in_array($i, $which_small_column)) {
				$columns_image_format = 'image_front_medium';
				$width_block .= '<div class="col-lg-2 col-md-4 col-sm-4 col-4">';
				$width_block .= '<div class="row">';
				$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, $columns_image_format, $gender, true, $datebook_get_data, $search_default_thumbnail);
			}

			$which_lastbig_column = array(10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110);
			if (in_array($i, $which_lastbig_column)) {
				$columns_image_format = 'image_front_medium';
				$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, $columns_image_format, $gender, true, $datebook_get_data, $search_default_thumbnail);
			}

			// Small images
			$all_small_column = array(2, 3, 4, 5,  7, 8, 9, 10,  12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 26, 27, 28, 29, 32, 33, 34, 35, 37, 38, 39, 40, 42, 43, 44, 45, 46, 47, 48, 49, 51, 52, 53, 54, 56, 57, 58, 59, 62, 63, 64, 65, 67, 68, 69, 70, 72, 73, 74, 75, 76, 77, 78, 79, 81, 82, 83, 84, 86, 87, 88, 89, 92, 93, 94, 95, 97, 98, 99, 100, 102, 103, 104, 105, 106, 107, 108, 109, 111, 112, 113, 114, 116, 117, 118, 119);
			if (in_array($i, $all_small_column)) {
				$columns_image_format = 'image_front_small';
				$width_block .= '<div class="col-6 smallphoto">';
				$width_block .= '<div class="row">';
				$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, $columns_image_format, $gender, true, $datebook_get_data, $search_default_thumbnail);
			}

			if($thumbnail_url['image_exists'] == 'yes'){

				$profile_image_url = $thumbnail_url['img_full_url'];

			} else {

				$profile_image_url = $cache_url . $columns_image_format . '.png';

			}

			// Profile link and thubmnail
			$width_block .= '<a class="thumbnail bg-white' . esc_attr($normal_profiles_round . $normal_profiles_padding) . ' datebook-normal-profile" href="'.esc_url($links).'" title="'.esc_attr($profile_name).'" style="background-image: url(' . esc_url($thumbnail_url['img_full_url']) . '); background-repeat: no-repeat; background-position: center; background-size: 75%;" data-html="true" data-toggle="popover" data-trigger="hover" data-placement="top" data-content="';

			if($show_age == 1){
				$width_block .= esc_attr($age);
			}

			if ($show_sexual_orientation == 1 && isset($datebook_sexualorientation_titles[$sexualorientation])){

				$sexualorientation = $sexualorientation == 2 && isset($gender) && $gender > 0 ? $gender.$sexualorientation . '00' : $sexualorientation;

				$width_block .= ', ';
				$width_block .= esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' );
			}

			if ($show_gender == 1 && $gender > 0){
				$width_block .= "<i class='" . esc_attr($gender_icon) . "'></i>";
			}					

			if ($show_location == 1) {
				$width_block .= '<br />';
				if (isset($city)) {
					$width_block .= esc_attr($city);
				}
				if (!empty($city) && !empty($country)) {
					$width_block .= ", ";
				}
				if (isset($country)) {
					$width_block .= esc_attr($country);
				}
			}

			if($border_mode == 'random'){
				$first_border = (isset($get_border_number[0]) && is_numeric($get_border_number[0])) ? $get_border_number[0] > 0 ? $get_border_number[0] : 1 : 1;
				$last_border = (isset($get_border_number[1]) && is_numeric($get_border_number[1])) ? $get_border_number[1] > 0 ? $get_border_number[1] : 12 : 12;
				$normal_profiles_border = ' border-width: ' . mt_rand($first_border, $last_border) . 'px !important;';
			}

			if(!empty($normal_border_color)){
				$border_color = 'border-color: ' . $normal_border_color . ' !important;';
			} else if(isset($normal_color_gamma)){
				$border_color = 'border-color: ' . DateBook_Utilities::create_random_color($normal_border_color, $normal_color_gamma) . ' !important;';
			} else {
				$border_color = '';
			}

			$width_block .= '">';
			
			$width_block .= '<img class="img-fluid w-100 ' . esc_attr($normal_border_bootstrap . $normal_profiles_round) . '" style="' . esc_attr($normal_profiles_border . $border_color) . '" width="' . esc_attr( $thumbnail_url['width'] ) . '" height="' . esc_attr( $thumbnail_url['height'] ) . '" src="' . esc_url($profile_image_url) . '" alt="'.esc_attr($title_for_alt).'"';

			if($enable_retina_images == 1) {
				$width_block .= ' data-rjs="2"';
			}

			$width_block .= ' />';

			$width_block .= '</a>';


			// Close DIV for single profile
			if (in_array($i, $all_small_column)) {
				$width_block .= '</div>';
				$width_block .= '</div>';
			}

			// Close DIV for section
			$close_column = array(1, 5, 6, 10, 11, 15, 19, 20, 24, 25, 29, 30, 31, 35, 36, 40, 41, 45, 49, 50, 54, 55, 59, 60, 61, 65, 66, 70, 71, 75, 79, 80, 84, 85, 89, 90, 91, 95, 96, 100, 101, 105, 109, 110, 114, 115, 119, 120);
			if (in_array($i, $close_column)) {
				$width_block .= '</div>';
				$width_block .= '</div>';
			}

			// Close DIV for section
			if ($i % 2 || $i % 6 || $i % 7 || $i % 11 || $i % 12 || $i % 16 || $i % 20 || $i % 21 || $i % 25 || $i % 26 || $i % 30) {
				$width_container .= '<div class="col-lg-4 col-md-4 col-sm-4">'.$width_block.'</div>';
			}

			endwhile;

			echo $width_block;

			?>

		</div>
</div>

<?php

endif;

wp_reset_postdata();