<?php 
/*
 * Social links
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

$login_url = add_query_arg( array(
	'action' => 'logout'
), get_permalink(of_get_option('login_page')) );

?>

<ul class="list-inline mb-0 text-center datebook-footer-pages">
						
	<?php if ( get_option( 'users_can_register' ) && !is_user_logged_in() && !is_super_admin()) { ?>
		
		<?php if (of_get_option( 'enable_profile_registration' ) == '1') { ?>

			<li class="list-inline-item"><a href="<?php echo esc_url(get_permalink(of_get_option('registration_page'))); ?>"><?php esc_html_e( 'Register', 'datebook' ); ?></a></li>
			
		<?php } ?>

			<li class="list-inline-item"><a href="<?php echo esc_url(get_permalink(of_get_option('login_page'))); ?>"><?php esc_html_e( 'Login', 'datebook' ); ?></a></li>
			
	<?php } else { ?>	
			
			<li class="list-inline-item"><a href="<?php echo esc_url(get_permalink(of_get_option('my_edit_profile_page'))); ?>"><?php esc_html_e( 'My account', 'datebook' ); ?></a></li>
			
			<li class="list-inline-item"><a href="<?php echo esc_url($login_url); ?>"><?php esc_html_e( 'Logout', 'datebook' ); ?></a></li>
		
	<?php } ?>	

</ul>