<?php
/*
 * Profile Comments
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $wp_query;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$profile_id = get_the_ID();

$comment_args = array(
	'orderby' => 'comment_date_gmt',
	'order' => 'DESC',
	'status'  => 'approve',
	'user_id' => $current_user_id,
	'no_found_rows' => false,
	'update_comment_meta_cache' => false
);

$comment_args = apply_filters( 'comments_template_query_args', $comment_args );
$comment_query = new WP_Comment_Query( $comment_args );
$comments_flat = $comment_query->comments;
$wp_query->comments = apply_filters( 'comments_array', $comments_flat, $current_user_id );
$comments = &$wp_query->comments;
$wp_query->comment_count = count($wp_query->comments);

?>

<div class="datebook-custom-card card mb-3">
	<div class="card-body">

		<h2><?php esc_html_e( 'My comments', 'datebook' ); ?></h2>

		<div class="card border datebook-transparent">
			<div class="card-header">

				<?php esc_html_e( 'Comments you left on other profiles', 'datebook' ); ?>

			</div>
			<div class="card-body">
				<div class="datebook-profile-comments">

				<?php

				if ( $wp_query->comment_count > 0 ) {

					// Check if Retina enabled in Theme Options
					$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

					foreach ( $comments as $comment ) {

						$commenter_data = get_post($comment->comment_post_ID);

						$get_profile_data = get_post_meta($commenter_data->ID, 'profile_personal_data', true);
						$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

						$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

						$comment_post_time = DateBook_Utilities::datebook_date_i18n(2, $comment->comment_date);

						$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($commenter_data->ID, 'image_avatar', $gender, true);

						?>

						<div class="media">
							<div class="media-left">

								<a id="commentid_<?php echo absint($commenter_data->ID); ?>" href="<?php echo esc_url(get_permalink($commenter_data->ID)); ?>?show=comments" title="<?php echo esc_attr($commenter_data->post_title); ?>"><img class="rounded-circle" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>

							</div>
							<div class="media-body">

							<?php 

							if ($current_user_id == $comment->user_id || is_super_admin()) {

								$delete_comment_url = add_query_arg( array(
									'action' => 'deletecomment',
									'sid' => $commenter_data->ID
								), get_permalink($profile_id) );

								?>

								<a class="btn btn-sm btn-grey float-right" href="<?php echo esc_url($delete_comment_url); ?>" title="<?php esc_html_e( 'Delete this comment', 'datebook' ); ?>"><i class="fa fa-trash"></i></a>

							<?php } ?>

								<h5 class="datebook-profile-heading datebook-ellipsis small"><a href="<?php echo esc_url(get_permalink($commenter_data->ID)); ?>?show=comments" title="<?php echo esc_attr($commenter_data->post_title); ?>"><?php echo esc_attr($commenter_data->post_title); ?></a> <span class="small text-grey">(<?php echo esc_attr($comment_post_time); ?>)</span></h5>
						
								<p class="mb-1"><?php echo wp_kses_post($comment->comment_content); ?></p>

							</div>
						</div>

					<?php } ?>

				<?php } else { ?>

					<div class="card border-0 shadow-none datebook-transparent">
						<div class="card-body text-center">

							<h4 class="card-title"><?php esc_html_e( 'No comments', 'datebook' ); ?></h4>

						</div>

						<img class="card-img-top" src="<?php echo esc_url(DATEBOOK_URL . 'assets/images/icon-profile-no-comments.png');?>" alt="" />
                    
					</div>

				<?php } ?>
			
				</div>
			</div>
		</div>
	</div>
</div>