<?php
/*
 * Profile Conatct form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */
?>
<div id="datebook-profilecontact" class="datebook-profilecontact">

	<form action="<?php echo esc_url(get_permalink($profile_id)); ?>" method="post">

		<input type="hidden" name="action" value="contacting" />
		<input type="text" name="emails" value="" style="display:none;" />

		<?php if (!is_user_logged_in()) { ?>

		<div class="form-group">

			<label class="sr-only" for="name"><?php esc_html_e( 'Your name', 'datebook' ); ?></label>
			<input type="text" name="contacting_name" value="<?php if(isset($contacting_name)){ echo esc_attr($contacting_name); } ?>" class="form-control" id="datebook-name" placeholder="<?php esc_html_e( 'Your name', 'datebook' ); ?>" />

		</div>

		<div class="form-group">

			<label class="sr-only" for="datebook-contacting-email"><?php esc_html_e( 'Your email', 'datebook' ); ?></label>
			<input type="text" name="contacting_email" value="<?php if(isset($contacting_email)){ echo sanitize_email($contacting_email); } ?>" id="datebook-contacting-email" class="form-control" placeholder="<?php esc_html_e( 'Your email', 'datebook' ); ?>" />

		</div>

		<?php } ?>

		<div class="form-group">

			<label class="sr-only" for="datebook-contacting-text"><?php esc_html_e( 'Your message', 'datebook' ); ?></label>
			<textarea name="contacting_text" id="datebook-contacting-text" class="form-control" rows="4" placeholder="<?php esc_html_e( 'Your message', 'datebook' ); ?>"><?php if(isset($contacting_text)){ echo esc_textarea($contacting_text); } ?>
</textarea>

		</div>

		<button type="submit" name="submit" class="btn btn-block btn-primary m-0"><?php esc_html_e( 'Send', 'datebook' ); ?></button>

	</form>

</div>