<?php
/*
 * Profile Edit form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $datebook_form_error, $datebook_alert_error, $datebook_alert_text;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

if(isset($profile_id) && $profile_id > 0){

	$terms = wp_get_object_terms( $profile_id, DATEBOOK_PROFILES_TAX, array( 'fields' => 'ids' ) );

	if(isset($terms[0])){
		$term_category = get_term_meta( $terms[0], 'profile_formname', true );
	}
}

$profile_form = isset($term_category) && !empty($term_category) ? $term_category : 'profile_form';


if (isset($datebook_alert_text['success_profile_updated'])) {

	echo '<div class="alert alert-success">' . esc_attr($datebook_alert_text['success_profile_updated']) . '</div>';

}

if (isset($datebook_alert_error) && is_array($datebook_alert_error) && !empty($datebook_alert_error)){
	
	echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_text['error_required_fields']) . '</div>';
	
}

?>

<div class="datebook-custom-card card">
	<div class="card-body">

		<h2><?php esc_html_e( 'Edit my profile', 'datebook' ); ?></h2>

		<form action="<?php the_permalink(); ?>" method="post">

			<input type="hidden" name="change_profile_form" value="1" />
			<input type="hidden" name="action" value="change" />
			<input id="datebook-alllocations" name="alllocations" type="hidden" value="1" />

			<fieldset>

				<div class="card border mb-3 datebook-transparent">
					<div class="card-body">

					<?php

					// Display form
					DateBook_Forms::render_form($profile_form, $current_user_id);

					?>

					</div>
					<div class="card-footer">

						<button type="submit" name="submit" class="btn btn-primary"><?php esc_html_e( 'Save', 'datebook' ); ?></button>

					</div>
				</div>
				
			</fieldset>
		</form>
	</div>
</div>