<?php
/*
 * Notifications page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

?>

<div class="datebook-custom-card card datebook-profilepage">
	<div class="card-body">

		<h2><?php esc_html_e( 'Notifications', 'datebook' ); ?></h2>

		<hr />

		<?php

		// Get notifications for profile
		$get_found_notifications = array();

		$get_data_notification = get_post_meta($profile_id, 'notification', true);

		if(is_array($get_data_notification) && !empty($get_data_notification)){

			usort($get_data_notification, 'DateBook_Profile_Notifications::sort_notification_by_time');
			
			echo '<ul class="list-group">';

			foreach($get_data_notification as $key => $value){

				$class_unread = ($value['status'] == 'unread') ? ' list-group-item-success' : '';

				$notification_time = DateBook_Utilities::datebook_date_i18n(2, $value['time'] , false);
				
				$notification_page_link = isset($value['url']) ? $value['url'] : '';
				$referrer = isset($value['referrer']) ? $value['referrer'] : '';
				$show = isset($value['show']) ? $value['show'] : '';
				$time = isset($value['time']) ? $value['time'] : '';

				if(isset($value['profile_id']) && isset($value['profile_id']) > 0){
					$profile_id_notification = isset($value['profile_id']) ? $value['profile_id'] : '';
					$current_profile_data = get_post($profile_id_notification);
					$post_title = $current_profile_data->post_title;

					$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id_notification, 'image_notifications', '', true);

					$value['text'] = $post_title . ' ' . $value['text'];
				}

				$query_page_link = add_query_arg( array(
        		    'referrer' => $referrer,
		            'show' => $show,
					'id' => $time
				), $notification_page_link );

				switch ($show) {
					case 'friends' : $add_anchor_url = '#datebook-friends-list-anchor'; break;
					case 'likes' : $add_anchor_url = ''; break;
					case 'favorites' : $add_anchor_url = ''; break;
					default: $add_anchor_url = ''; break;
				}

				?>

				<a class="list-group-item list-group-item-action<?php echo esc_attr($class_unread); ?>" href="<?php echo esc_url($query_page_link . $add_anchor_url); ?>">

				<?php if(isset($thumbnail_url['img_full_url']) && $thumbnail_url['img_full_url'] != ''){ ?>
					<img class="thumbnail mr-2" src="<?php echo esc_url($thumbnail_url['img_full_url']); ?>" alt="" />
				<?php } ?>

				<?php echo esc_html__($value['text'], 'datebook'); ?> <span class="float-right font-weight-light small"><?php echo esc_attr($notification_time); ?></span></a>

			<?php

			}

			echo '</ul>';

		} else {

?>

			<div class="jumbotron shadow-none datebook-transparent">
				<div class="jumbotron-contents">

					<h3><?php esc_html_e( 'No notifications yet', 'datebook' ); ?></h3>

					<hr class="my-4">

					<p class="lead"><?php esc_html_e( 'You have not received any notifications yet', 'datebook' ); ?></p>

				</div>
			</div>

		<?php } ?>

		</div>
	</div>