<?php
/*
 * Profile Registration form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $datebook_alert_text;

$profiletypereserved = 0;

if(isset($_POST['action']) && ($_POST['action'] == 'profiletype' || $_POST['action'] == 'change') && isset($_POST['profiletypereserved']) && $_POST['profiletypereserved'] > 0) {
	$profiletypereserved = $_POST['profiletypereserved'];
	$term_category = get_term_meta( $profiletypereserved, 'registration_formname', true );
}

$profile_form = isset($term_category) && !empty($term_category) ? $term_category : 'registration_form';

?>

<section class="form-light">
	<div class="datebook-custom-card card">
		<div class="card-body">
			<div class="row justify-content-md-center datebook-login-form-container"> 
				
				<!--Grid column-->
				<div class="col-md-5 mb-4 mt-4">

					<!--Header-->
					<div class="header mb-4">
						<div class="text-center">
							<h2><?php esc_html_e( 'Create profile', 'datebook' ); ?></h2>
						</div>
					</div>
					<!--Header-->

					<?php if (isset($datebook_alert_text) && is_array($datebook_alert_text) && !empty($datebook_alert_text)){ ?>

						<div class="alert alert-danger text-center mb-4">

							<?php echo $datebook_alert_text['error_required_fields']; ?>

						</div>

					<?php } ?>


					<div class="mb-4">

						<form action="<?php echo esc_url(get_permalink(of_get_option('registration_page'))); ?>" method="post" id="datebook-registration-form">

							<input type="hidden" name="change_profile_form" value="1" />
							<input type="hidden" name="action" value="change" />
							<input type="hidden" name="alllocations" value="1" id="datebook-alllocations" />
							<input type="hidden" name="profiletypereserved" value="<?php echo esc_attr($profiletypereserved); ?>" />

							<?php

							// Display form
							DateBook_Forms::render_form($profile_form);

							?>

						</form>

					</div>

					

				</div>
			</div>
		</div>
	</div>
</section>