<?php
/*
 * Profile Settings form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

if(isset($profile_id) && $profile_id > 0){

	$terms = wp_get_object_terms( $profile_id, DATEBOOK_PROFILES_TAX, array( 'fields' => 'ids' ) );

	if(isset($terms[0])){
		$term_category = get_term_meta( $terms[0], 'settings_formname', true );
	}
}

$profile_form = isset($term_category) && !empty($term_category) ? $term_category : 'settings_form';

?>

<div class="mb-4"> 

<form action="<?php echo esc_url(get_permalink(of_get_option('my_settings_page'))); ?>" method="post" id="datebook-registration-form">

	<input type="hidden" name="change_profile_form" value="1" />
	<input type="hidden" name="action" value="change" />
	<input id="datebook-alllocations" name="alllocations" type="hidden" value="1" />

	<?php
	
	// Display form
	DateBook_Forms::render_form($profile_form, $current_user_id);

	?>

	<div class="md-form text-center">

		<button type="submit" name="submit" class="btn btn-primary btn-lg"><?php echo esc_html__( 'Save', 'datebook' ); ?></button>

	</div>

</form>

</div>