<?php
/**
 * The default template for displaying Add Tour on Tours page. Used in page-tours.php.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */
 
$my_tours_page_url = add_query_arg( array(
	'action' => 'newtour'
), get_permalink(of_get_option('my_tours_page')) );
	
?>
<div class="datebook-custom-card card mb-3">
	<div class="card-body">

		<h3><?php esc_html_e( 'Start your tour!', 'datebook' ); ?></h3>

		<p><?php esc_html_e( 'If you wish to find fellow travelers to journey together with you then place your offer here.', 'datebook' ); ?></p>

		<a href="<?php echo esc_url($my_tours_page_url);?>" class="btn btn-secondary"><?php esc_html_e( 'Add Tour', 'datebook' ); ?></a>
	
	</div>
</div>