<?php
/**
 * The default template for displaying Featured profiles in sidebar
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


$profile_id = absint(get_the_ID());

$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

if (isset($datebook_get_data['city']) && $datebook_get_data['city'] > 0) {
	
	$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
	$country_id = isset($term_data->country_id) && $term_data->country_id > 0 ? $term_data->country_id : '';

	$meta_country_array = array( 'key' => 'country', 'value' => $country_id, 'compare' => '=', 'type' => 'NUMERIC' );
	$country_array = '';

} else {

	$country_array = $meta_country_array = '';

}

$args = array(
	'post_type' => DATEBOOK_POST_TYPE,
	'post_status' => 'publish',
	'orderby' => 'rand',
	'meta_query' => array(
		array(
			'key' => 'featured',
			'value' => '1',
			'compare' => '=',
			'type' => 'NUMERIC'
		),
		$meta_country_array
	),
	'posts_per_page' => $posts_per_page
);

$the_query = new WP_Query( $args );


if ( $the_query->have_posts()) :

	global $datebook_gender_titles;
	
	// Check if Retina enabled in Theme Options
	$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;
	
?>

	<div class="datebook-profiles-list">

<?php

	/* Before widget (defined by themes). */
	//echo $before_widget;

	while ( $the_query->have_posts() ) : $the_query->the_post();

		$profile_id = absint(get_the_ID());
		
		$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
		$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

		if(isset($datebook_get_data['city'])){

			$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
			$country = isset($term_data->country) ? $term_data->country : '';
			$city = isset($term_data->city) ? $term_data->city : '';

		}

		$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) . ', ' : '';
		$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

		$all_photos_args = array(
			'post_parent' => $profile_id, 
			'post_status' => 'inherit', 
			'post_type' => 'attachment', 
			'post_mime_type' => 'image', 
			'order' => 'ASC', 
			'orderby' => 'menu_order ID',
			'posts_per_page' => -1,
			'meta_query' => array(
				array('key' => DATEBOOK_IMAGE_TYPE, 'value' => DATEBOOK_PROFILE_IMAGE_TYPE, 'compare' => '=' )
			)
		);

		$all_photos = new WP_Query( $all_photos_args );

		$all_photos_count = $all_photos->found_posts - 1;

		$all_photos_count = ($all_photos_count > 0) ? $all_photos_count : 0;
	
		if ($gender == 1) {
			$gender_icon = 'fa fa-venus fa-lg';
		} else if ($gender == 2) {
			$gender_icon = 'fa fa-mars fa-lg';
		} else {
			$gender_icon = 'fa fa-user fa-lg';
		}

		$get_the_title = get_the_title();
		
		$title_for_alt = $get_the_title . ', ' . $age;

		if (isset($city)) {
			$title_for_alt .= esc_attr($city);
		}
		if (!empty($city) && !empty($country)) {
			$title_for_alt .= ', ';
		}
		if (isset($country)) {
			$title_for_alt .= esc_attr($country);
		}
		
		$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_feature_single_sidebar', $gender, true);

?>

		<div class="datebook-custom-card card mb-3">
		
			<!--Card image-->
			<div class="view overlay datebook-profile-caption">
				<img class="card-img-top" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="photo" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> />
				<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr($get_the_title);?>">
					<div class="mask rgba-white-slight"></div>
				</a>

				<?php if (of_get_option('enable_profile_comments') == '1') {
					
				$count_profile_comments = DateBook_Utilities::datebook_count_profile_comments($profile_id);

				?>
				<span class="datebook-profile-comment-caption" title="<?php echo esc_attr($count_profile_comments); ?> <?php esc_html_e( 'Comments', 'datebook' );?>"><i class="fa fa-comments"></i> <?php echo esc_attr($count_profile_comments); ?></span>
				<?php } ?>
				
				<span class="datebook-profile-pictures-caption" title="<?php echo esc_attr($all_photos_count); ?> <?php echo esc_html__( 'more photos', 'datebook' ); ?>"><i class="fa fa-camera"></i> <?php echo esc_attr($all_photos_count); ?> </span>

			</div>

			<!--Card content-->
			<div class="card-body text-center">
			
				<!--Title-->
				<h5 class="card-title datebook-profile-heading datebook-ellipsis"><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr($get_the_title);?>"><?php echo esc_html($get_the_title);?></a></h5>
				<!--Text-->
				
				<p class="card-text mb-1"><?php echo esc_attr($age); ?> <span title="<?php if(isset($datebook_gender_titles[$gender])) { echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); } ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span></p>
				
				<p class="card-text mb-0">
				
				<?php 
				
				if (isset($city)) {
					echo esc_attr($city);
				}
				if (!empty($city) && !empty($country)) {
					echo ", ";
				}
				if (isset($country)) {
					echo esc_attr($country);
				}
				
				?>
				
				</p>
				
			</div>
		</div>

	<?php 
	
	endwhile;

?>

	</div>

<?php

	wp_reset_postdata();
	
	/* After widget (defined by themes). */
	//echo $after_widget;

endif;