( function ( $ ) {

	// ready event
	$( document ).ready( function () {
		var notice = $( '#datebook-cookies' ),
			cookie = $.fn.getCookieNotice();

		// handle set-cookie button click
		$( document ).on( 'click', '.datebook-cookies-set-cookie', function ( e ) {
			e.preventDefault();

			$( this ).setCookieNotice( $( this ).data( 'cookie-set' ) );
		} );

		// handle revoke button click
		$( document ).on( 'click', '.datebook-cookies-revoke-cookie', function ( e ) {
			e.preventDefault();

			if ( DateBookCookiesArgs.refuse === 'yes' ) {
				var revoke = $( this );

				if ( DateBookCookiesArgs.onScroll === 'yes' ) {
					// enable cookie acceptance by scrolling again
					$( window ).on( 'scroll', handleScroll );
				}

				if ( DateBookCookiesArgs.revoke_cookies === '1' ) {
					// clicked shortcode button?
					if ( revoke.hasClass( 'datebook-cookies-revoke-inline' ) ) {
						var body = $( 'body' );

						// is cookie notice hidden?
						if ( ! ( body.hasClass( 'cookies-revoke' ) || body.hasClass( 'cookies-not-set' ) ) ) {
							// display automatic revoke button?
							if ( DateBookCookiesArgs.revoke_cookies_opt === 'automatic' ) {
								notice.showCookieNotice( 3 );
							} else {
								notice.showCookieNotice( 2 );
							}
						}
					} else {
						notice.showCookieNotice( 1 );
					}

					// update cookie value
					cookie = $.fn.getCookieNotice();

					// add body class
					$.fn.setCookieNoticeBodyClass( 'cookies-set cookies-revoke ' + ( cookie === 'true' ? 'cookies-accepted' : 'cookies-refused' ) );
				}
			}
		} );

		// cookie is not set
		if ( typeof cookie === 'undefined' ) {
			// handle on scroll
			if ( DateBookCookiesArgs.onScroll === 'yes' ) {
				$( window ).on( 'scroll', handleScroll );
			}

			notice.showCookieNotice( 0 );

			//$.fn.setCookieNoticeBodyClass( 'cookies-not-set' );
		// active refuse button?
		} else if ( DateBookCookiesArgs.refuse === 'yes' ) {
			if ( DateBookCookiesArgs.revoke_cookies === '1' ) {
				if ( DateBookCookiesArgs.revoke_cookies_opt === 'automatic' ) {
					notice.hideCookieNotice( 1 );
				}

				$.fn.setCookieNoticeBodyClass( 'cookies-set ' + ( cookie === 'true' ? 'cookies-accepted' : 'cookies-refused' ) );
			}
		// remove cookie notice
		} else {
			// add body class
			$.fn.setCookieNoticeBodyClass( 'cookies-set ' + ( cookie === 'true' ? 'cookies-accepted' : 'cookies-refused' ) );
		}
	} );

	// handle mouse scrolling
	function handleScroll( event ) {
		var win = $( this );

		if ( win.scrollTop() > parseInt( DateBookCookiesArgs.onScrollOffset ) ) {
			// accept cookie
			win.setCookieNotice( 'accept' );

			// remove itself after cookie accept
			win.off( 'scroll', handleScroll );
		}
	};

	// set Cookie Notice
	$.fn.setCookieNotice = function ( cookie_value ) {
		if ( DateBookCookiesArgs.onScroll === 'yes' ) {
			$( window ).off( 'scroll', handleScroll );
		}

		var date = new Date(),
			later_date = new Date(),
			notice = $( '#datebook-cookies' );

		// set expiry time in seconds
		later_date.setTime( parseInt( date.getTime() ) + parseInt( DateBookCookiesArgs.cookieTime ) * 1000 );

		// set cookie
		cookie_value = cookie_value === 'accept' ? 'true' : 'false';
		document.cookie = DateBookCookiesArgs.cookieName + '=' + cookie_value + ';expires=' + later_date.toUTCString() + ';' + ( DateBookCookiesArgs.cookieDomain !== undefined && DateBookCookiesArgs.cookieDomain !== '' ? 'domain=' + DateBookCookiesArgs.cookieDomain + ';' : '' ) + ( DateBookCookiesArgs.cookiePath !== undefined && DateBookCookiesArgs.cookiePath !== '' ? 'path=' + DateBookCookiesArgs.cookiePath + ';' : '' ) + ( DateBookCookiesArgs.secure === '1' ? 'secure;' : '' );

		// trigger custom event
		$.event.trigger( {
			type: 'setCookieNotice',
			value: cookie_value,
			time: date,
			expires: later_date
		} );

		// add body class
		$.fn.setCookieNoticeBodyClass( 'cookies-set ' + ( cookie_value === 'true' ? 'cookies-accepted' : 'cookies-refused' ) );

		if ( DateBookCookiesArgs.refuse === 'yes' && DateBookCookiesArgs.revoke_cookies === '1' && DateBookCookiesArgs.revoke_cookies_opt === 'automatic' ) {
			notice.hideCookieNotice( 2 );
		} else {
			notice.hideCookieNotice( 0 );
		}

		if ( cookie_value && DateBookCookiesArgs.redirection === '1' ) {
			var url = window.location.protocol + '//',
				hostname = window.location.host + '/' + window.location.pathname;

			if ( DateBookCookiesArgs.cache === '1' ) {
				url = url + hostname.replace( '//', '/' ) + ( window.location.search === '' ? '?' : window.location.search + '&' ) + 'datebook-cookies-reloaded=1' + window.location.hash;

				window.location.href = url;
			} else {
				url = url + hostname.replace( '//', '/' ) + window.location.search + window.location.hash;

				window.location.reload( true );
			}

			return;
		}
	};

	// add class(es) to body
	$.fn.setCookieNoticeBodyClass = function( classes ) {
		$( 'body' ).removeClass( 'cookies-revoke cookies-accepted cookies-refused cookies-set cookies-not-set' ).addClass( classes );
	}

	// get cookie value
	$.fn.getCookieNotice = function () {
		var value = "; " + document.cookie, parts = value.split( '; datebook_cookies_accepted=' );

		if ( parts.length === 2 )
			return parts.pop().split( ';' ).shift();
		else
			return;
	}

	// display cookie notice
	$.fn.showCookieNotice = function( type ) {
		// trigger custom event
		$.event.trigger( {
			type: 'showCookieNotice',
			value: type,
			data: DateBookCookiesArgs
		} );

		var notice = this;

		switch ( type ) {
			case 0:
				if ( DateBookCookiesArgs.hideEffect === 'fade' ) {
					// show cookie notice
					notice.css( { 'visibility': 'visible', 'display': 'none' } ).fadeIn( 400 );
				} else if ( DateBookCookiesArgs.hideEffect === 'slide' ) {
					// show cookie notice
					notice.css( { 'visibility': 'visible', 'display': 'none' } ).slideDown( 400 );
				} else {
					// show cookie notice
					notice.css( { 'visibility': 'visible' } ).show();
				}
				break;

			case 1:
				if ( DateBookCookiesArgs.hideEffect === 'fade' ) {
					// hide revoke button
					notice.find( '.datebook-cookies-revoke-container' ).fadeOut( 400, function () {
						// show cookie notice
						notice.css( { 'visibility': 'visible', 'display': 'none' } ).fadeIn( 400 );
					} );
				} else if ( DateBookCookiesArgs.hideEffect === 'slide' ) {
					// hide revoke button
					notice.find( '.datebook-cookies-revoke-container' ).slideUp( 400, function () {
						// show cookie notice
						notice.css( { 'visibility': 'visible', 'display': 'none' } ).slideDown( 400 );
					} );
				} else {
					// hide revoke button
					notice.css( { 'visibility': 'visible' } ).find( '.cookie-notice-revoke-container' ).hide();
				}
				break;

			case 2:
				if ( DateBookCookiesArgs.hideEffect === 'fade' ) {
					// show cookie notice
					notice.css( { 'visibility': 'visible', 'display': 'none' } ).fadeIn( 400 );
				} else if ( DateBookCookiesArgs.hideEffect === 'slide' ) {
					// show cookie notice
					notice.css( { 'visibility': 'visible', 'display': 'none' } ).slideDown( 400 );
				} else {
					// show cookie notice
					notice.css( { 'visibility': 'visible' } );
				}
				break;

			case 3:
				if ( DateBookCookiesArgs.hideEffect === 'fade' ) {
					// hide revoke button
					notice.find( '.datebook-cookies-revoke-container' ).fadeOut( 400, function () {
						// show cookie notice
						notice.css( { 'visibility': 'visible', 'display': 'none' } ).fadeIn( 400 );
					} );
				} else if ( DateBookCookiesArgs.hideEffect === 'slide' ) {
					// hide revoke button
					notice.find( '.datebook-cookies-revoke-container' ).slideUp( 400, function () {
						// show cookie notice
						notice.css( { 'visibility': 'visible', 'display': 'none' } ).slideDown( 400 );
					} );
				} else {
					// hide revoke button
					notice.css( { 'visibility': 'visible' } ).find( '.datebook-cookies-revoke-container' ).hide();
				}
				break;
		}
	}

	// hide cookie notice
	$.fn.hideCookieNotice = function ( type ) {
		// trigger custom event
		$.event.trigger( {
			type: 'hideCookieNotice',
			value: type,
			data: DateBookCookiesArgs
		} );
		
		var notice = this,
			display = this.css( 'display' );

		switch ( type ) {
			case 0:
				if ( DateBookCookiesArgs.hideEffect === 'fade' ) {
					notice.fadeOut( 400 );
				} else if ( DateBookCookiesArgs.hideEffect === 'slide' ) {
					notice.slideUp( 400 );
				} else {
					notice.css( { 'visibility': 'hidden' } );
				}
				break;

			case 1:
				if ( DateBookCookiesArgs.hideEffect === 'fade' ) {
					notice.find( '.datebook-cookies-revoke-container' ).hide().fadeIn( 400 ).css( { 'visibility': 'visible', 'display': 'block' } );
				} else if ( DateBookCookiesArgs.hideEffect === 'slide' ) {
					notice.find( '.datebook-cookies-revoke-container' ).hide().slideDown( 400 ).css( { 'visibility': 'visible', 'display': 'block' } );
				} else {
					notice.find( '.datebook-cookies-revoke-container' ).css( { 'visibility': 'visible', 'display': 'block' } );
				}
				break;

			case 2:
				if ( DateBookCookiesArgs.hideEffect === 'fade' ) {
					notice.fadeOut( 400, function () {
						// show revoke button
						notice.css( { 'visibility': 'hidden', 'display': display } ).find( '.datebook-cookies-revoke-container' ).hide().fadeIn( 400 ).css( { 'visibility': 'visible', 'display': 'block' } );
					} );
				} else if ( DateBookCookiesArgs.hideEffect === 'slide' ) {
					notice.slideUp( 400, function () {
						// show revoke button
						notice.css( { 'visibility': 'hidden', 'display': display } ).find( '.datebook-cookies-revoke-container' ).hide().slideDown( 400 ).css( { 'visibility': 'visible', 'display': 'block' } );
					} );
				} else {
					// show revoke button
					notice.css( { 'visibility': 'hidden' } ).find( '.datebook-cookies-revoke-container' ).css( { 'visibility': 'visible', 'display': 'block' } );
				}
				break;
		}
	}

} )( jQuery );