jQuery(document).ready(function($) {

	"use strict";

	// Check for new messages every X seconds
	function datebook_check_for_messages(){

		$.ajax({
			type: 'GET',
			url: datebookajaxlocal.ajax_my_messages_url,
			data: {
				action : 'datebook_message_actions',
				whatisit : 'checknewmessages',
			},
			success: function(data) {

				if (data) {

					if (data.status === 200) {
						
						$('.datebook-count-messages').html(data.countmessages);

						if (data.countmessages > 0) {
							$('.datebook-new-messages-indicator').show();
						} else {
							$('.datebook-new-messages-indicator').hide();
						}

						$.each(data.profile_data, function(index, value) {

							var htmlpanel = '';

							$('#datebook-messages-profile-box-' + value.profile_id + ' .datebook-online-caption').html(value.online_status_sender);
							
							if (value.countnewmsgsender > 0) {

								$('#datebook-messages-profile-box-' + value.profile_id + ' .datebook-open-chat-button').removeClass('btn-light');
								$('#datebook-messages-profile-box-' + value.profile_id + ' .datebook-open-chat-button').addClass('btn-success');
								$('#datebook-messages-profile-box-' + value.profile_id + ' .datebook-open-chat-button .datebook-chat-open-btn-text').hide();
								$('#datebook-messages-profile-box-' + value.profile_id + ' .datebook-open-chat-button .datebook-chat-new-btn-text').show();
								$('#datebook-messages-profile-box-' + value.profile_id + ' .datebook-chat-button-count').html(value.countnewmsgsender);

							} else {

								$('#datebook-messages-profile-box-' + value.profile_id + ' .datebook-open-chat-button').addClass('btn-light');
								$('#datebook-messages-profile-box-' + value.profile_id + ' .datebook-open-chat-button').removeClass('btn-success');
								$('#datebook-messages-profile-box-' + value.profile_id + ' .datebook-open-chat-button .datebook-chat-open-btn-text').show();
								$('#datebook-messages-profile-box-' + value.profile_id + ' .datebook-open-chat-button .datebook-chat-new-btn-text').hide();

								$('.datebook-popup-container .datebook-profile-id-' + value.profile_id).remove();

							}

							if (data.countnotified > 0 && value.notify > 0 && value.countnewmsgsender > 0) {
								
								$('.datebook-popup-container').children('.datebook-profile-id-' + value.profile_id).each(function(){
									$('.datebook-profile-id-' + value.profile_id).remove();
								});

								htmlpanel += '<div id="datebook-chatpopup datebook-profile-id-' + value.profile_id + '" onclick="return false;" class="datebook-popup datebook-popup-animate fadeInDown m-2 shadow-lg rounded datebook-popup-design datebook-profile-id-' + value.profile_id + '" href="' + value.profile_get_permalink + '">';

								if(value.thumbnail_url){
									htmlpanel += '<div class="d-block p-2 datebook-popup-image-wrapper"><div class="d-block datebook-popup-image"><img class="d-block rounded" src="' + value.thumbnail_url + '"></div></div>';
								}

								if(value.title || value.message){

									htmlpanel += '<div class="datebook-popup-body">';

									if(value.title){
										htmlpanel += '<div class="datebook-popup-title">' + value.title + '</div>';
									}

									if(value.message){
										htmlpanel += '<div class="datebook-popup-text">' + value.message + '</div>';
									}

									htmlpanel += '</div>';

								}

								htmlpanel += '</div>';

								DateBook.popup({
									position: 'bottom right',
									displayDelay: true,
									closeOnClick: true,
									onClickUrl: value.profile_get_permalink,
									closeButton: true,
									sound: true,
									img: value.thumbnail_url,
									title: '',
									msg: '',
									divpanel: htmlpanel
								});
							}
						});

						return false;

					}
				}
			}
		});
	}
	
	// Pre check functionn
	function datebook_pre_check_for_messages(){

		// Set interval
		setInterval(function(){

			datebook_check_for_messages();

		},5000); // 5000 = 5 seconds
		
	}

	// Load checking for new messages functions
	//datebook_pre_check_for_messages();
	window.onload = datebook_pre_check_for_messages();
	//window.onresize = datebook_pre_check_for_messages();
	//window.addEventListener('load', datebook_pre_check_for_messages(), false);

});