// Show Calendar in Tour Form. Pikaday.js Settings.

var datebook_date_arr = {
		previousMonth : datebook_date_translation.datebook_previous_month,
		nextMonth     : datebook_date_translation.datebook_next_month,
		months        : [
			datebook_date_translation.datebook_january,
			datebook_date_translation.datebook_february,
			datebook_date_translation.datebook_march,
			datebook_date_translation.datebook_april,
			datebook_date_translation.datebook_may,
			datebook_date_translation.datebook_june,
			datebook_date_translation.datebook_july,
			datebook_date_translation.datebook_august,
			datebook_date_translation.datebook_september,
			datebook_date_translation.datebook_october,
			datebook_date_translation.datebook_november,
			datebook_date_translation.datebook_december],
		weekdays      : [
			datebook_date_translation.datebook_monday,
			datebook_date_translation.datebook_tuesday,
			datebook_date_translation.datebook_wednesday,
			datebook_date_translation.datebook_thursday,
			datebook_date_translation.datebook_friday,
			datebook_date_translation.datebook_saturday,
			datebook_date_translation.datebook_sunday
			],
		weekdaysShort : [
			datebook_date_translation.datebook_mon,
			datebook_date_translation.datebook_tue,
			datebook_date_translation.datebook_wed,
			datebook_date_translation.datebook_thu,
			datebook_date_translation.datebook_fri,
			datebook_date_translation.datebook_sat,
			datebook_date_translation.datebook_sun
			]
}

var startDate,
endDate,
updateStartDate = function() {
	startPicker.setStartRange(startDate);
	endPicker.setStartRange(startDate);
	endPicker.setMinDate(startDate);
},
updateEndDate = function() {
	startPicker.setEndRange(endDate);
	startPicker.setMaxDate(endDate);
	endPicker.setEndRange(endDate);
},
startPicker = new Pikaday({
	field: document.getElementById('datebook-start'),
	format: 'DD/MM/YYYY',
	firstDay: 1,
	minDate: new Date(),
	maxDate: new Date(2023, 12, 31),
	onSelect: function() {
		startDate = this.getDate();
		updateStartDate();
	},
	i18n: datebook_date_arr
}),
endPicker = new Pikaday({
	field: document.getElementById('datebook-end'),
	format: 'DD/MM/YYYY',
	firstDay: 1,
	minDate: new Date(),
	maxDate: new Date(2023, 12, 31),
	onSelect: function() {
		endDate = this.getDate();
		updateEndDate();
	},
	i18n: datebook_date_arr
}),
_startDate = startPicker.getDate(),
_endDate = endPicker.getDate();

if (_startDate) {
	startDate = _startDate;
	updateStartDate();
}

if (_endDate) {
	endDate = _endDate;
	updateEndDate();
}

var featuredpicker = new Pikaday({
	field: document.getElementById('featureddate'),
	format: 'DD/MM/YYYY',
	firstDay: 1,
	minDate: new Date() });
var toppicker = new Pikaday({ field: document.getElementById('topdate'),
	format: 'DD/MM/YYYY',
	firstDay: 1,
	minDate: new Date()
	});