<?php
/**
 * Plugin Name: DateBook
 * Version: 4.6.0
 * Description: Complete dating agency in WordPress plugin. DateBook covers all needs of matchmaking agencies or portals. No problem for DateBook to turn your website into social network with payment options. It allows you to create and customize website in just few clicks by using setting manager in customizer. For full list of plugin features visit <a href="https://www.pagickthemes.com">PagickThemes.com</a>.
 * Author: Pagick Themes
 * Author URI: https://www.pagickthemes.com
 * Text Domain: datebook
 * Domain Path: /languages/
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 * @package DateBook
 */

if ( ! class_exists( 'DateBook' ) ) {

	/**
	 * Class DateBook
	 *
	 * @class DateBook
	 * @package DateBook
	 * @author Pagick Themes
	 */
	final class DateBook {
		
		/**
		 * Initialize DateBook plugin
		 */
		public function __construct() {

			add_action( 'plugins_loaded', array( __CLASS__, 'datebook_plugins_loaded' ));

		}


		/**
		 * Load all functions via plugins_loaded
		 *
		 * @access public
		 * @return void
		 */
		public static function datebook_plugins_loaded() {
			
			self::datebook_constants();
			self::datebook_includes();
			self::datebook_load_plugin_textdomain();

			add_action( 'activated_plugin', array( __CLASS__, 'datebook_plugin_order' ) );

		}


		/**
		 * Defines constastants. All defiitions, data, currency title, payment period, menus and sidebars
		 *
		 * @access public
		 * @return void
		 */
		public static function datebook_constants() {

			global $wp_locale_all;

			define( 'DATEBOOK_URL', plugin_dir_url( __FILE__ ) );

			define( 'DATEBOOK_DIR', plugin_dir_path( __FILE__ ) );

        	define( 'DATEBOOK_BASENAME', plugin_basename( __FILE__ ) );


			if (!defined('DATEBOOK_POST_TYPE')) {
				define('DATEBOOK_POST_TYPE', 'profile');
			}
			if (!defined('DATEBOOK_PROFILES_TAX')) {
				define('DATEBOOK_PROFILES_TAX', 'profiletype');
			}

			if (!defined('DATEBOOK_CLASSIFIEDS_TYPE')) {
				define('DATEBOOK_CLASSIFIEDS_TYPE', 'classifieds');
			}
			if (!defined('DATEBOOK_CLASSIFIEDS_TAX')) {
				define('DATEBOOK_CLASSIFIEDS_TAX', 'classifiedcats');
			}
			if (!defined('DATEBOOK_TOUR_TYPE')) {
				define('DATEBOOK_TOUR_TYPE', 'tour');
			}
			if (!defined('DATEBOOK_COMMENT_TYPE')) {
				define('DATEBOOK_COMMENT_TYPE', 'profile_comment');
			}
			if (!defined('DATEBOOK_REVIEW_TYPE')) {
				define('DATEBOOK_REVIEW_TYPE', 'profile_review');
			}

			// Notification
			if (!defined('DATEBOOK_NOTIFICATION_TYPE')) {
				define('DATEBOOK_NOTIFICATION_TYPE', 'datebook_notice');
			}
			if (!defined('DATEBOOK_ANIMATION_TYPE')) {
				define('DATEBOOK_ANIMATION_TYPE', 'datebook_animations');
			}
			if (!defined('DATEBOOK_ANIMATION_OUT_TYPE')) {
				define('DATEBOOK_ANIMATION_OUT_TYPE', 'datebook_animouts');
			}
			if (!defined('DATEBOOK_DESIGN_TYPE')) {
				define('DATEBOOK_DESIGN_TYPE', 'datebook_designs');
			}
			if (!defined('DATEBOOK_LOCATION_TYPE')) {
				define('DATEBOOK_LOCATION_TYPE', 'datebook_locations');
			}


			if (!defined('DATEBOOK_IMAGE_TYPE')) {
				define('DATEBOOK_IMAGE_TYPE', 'photo_type');
			}

			if (!defined('DATEBOOK_PROFILE_IMAGE_TYPE')) {
				define('DATEBOOK_PROFILE_IMAGE_TYPE', 'profile_photo');
			}

			if (!defined('DATEBOOK_VERIFICATION_IMAGE_TYPE')) {
				define('DATEBOOK_VERIFICATION_IMAGE_TYPE', 'verification');
			}

			if (!defined('DATEBOOK_VERIFICATION_CONFIRM_PHOTO')) {
				define('DATEBOOK_VERIFICATION_CONFIRM_PHOTO', 'verification_confirm_photo');
			}

			if (!defined('DATEBOOK_IMAGE_CHAT')) {
				define('DATEBOOK_IMAGE_CHAT', 'chat_photo');
			}

			if (!defined('DATEBOOK_OPTIONS_FOLDER')) {
				define('DATEBOOK_OPTIONS_FOLDER', 'datebook-options');
			}
			if (!defined('DATEBOOK_CUSTOM_STYLE')) {
				define('DATEBOOK_CUSTOM_STYLE', 'datebook-custom-style');
			}

		}


		/**
		 * Include all classes
		 *
		 * @access public
		 * @return void
		 */
		public static function datebook_includes() {

			global $datebook_get_locale;

			// Load plugin options framework
			define( 'OPTIONS_FRAMEWORK_DIRECTORY', plugin_dir_url( __FILE__ ) . 'framework/' );
			require_once( DATEBOOK_DIR . 'framework/options-framework.php' );

			// Loads settings
			require_once( DATEBOOK_DIR . 'framework/options.php' );

			// Loads the encrypted codes
			require_once( DATEBOOK_DIR . 'framework/encrypt/codes.php' );
			define('DATEBOOK_ENCRYPTED_CODE', $encrypted_codes);

			// Load languages for frontend
			require_once( DATEBOOK_DIR . 'framework/gettext/Entries.php' );
			require_once( DATEBOOK_DIR . 'framework/gettext/Translation.php' );
			require_once( DATEBOOK_DIR . 'framework/gettext/Extractor.php' );
			require_once( DATEBOOK_DIR . 'framework/gettext/Po.php' );
			require_once( DATEBOOK_DIR . 'framework/theme-localization.php' );

			// Set language on the whole website
			if (!defined('DATEBOOK_WPLANG')) {
				define('DATEBOOK_WPLANG', get_locale());
			}

			// Load Mobile Devices Library
			require_once DATEBOOK_DIR . 'definitions/mobile_detect/Mobile_Detect.php';

			// Defines variables
			require_once DATEBOOK_DIR . 'definitions/datebook-variables.php';

			// Load all the rest files
			require_once DATEBOOK_DIR . 'includes/class-datebook-template-loader.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-utilities.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-post-types.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-filter.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-scripts.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-login.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-page-front.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-page-classifieds.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-page-tours.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-page-contact.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-page-profiles.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-search.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-matching.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-featured-profiles.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-menu.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-social.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-edit.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-photos.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-verification.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-settings.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-privacy.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-messages.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-classifieds.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-tours.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-comments.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-reviews.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-views.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-friends.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-profile-notifications.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-administrator-panel.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-widgets.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-sidebars.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-pages.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-blog.php';

			require_once DATEBOOK_DIR . 'includes/class-datebook-notifications.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-cookies.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-ip-location.php';

			require_once DATEBOOK_DIR . 'includes/class-datebook-cron.php';
			require_once DATEBOOK_DIR . 'includes/class-datebook-footer.php';

			// Library for detecting Emoji symbols in a string
			include DATEBOOK_DIR . 'definitions/emoji_detect/Emoji.php';


			// Subscription and Payment Gateway systems
			require_once DATEBOOK_DIR . 'includes/payment/class-datebook-subscription.php';

			// Load forms
			require_once DATEBOOK_DIR . 'includes/class-datebook-forms.php';

			require_once DATEBOOK_DIR . 'includes/class-datebook-header.php';

		}


	    /**
	     * Loads localization files
		 *
		 * @access public
		 * @return void
	     */
	     public static function datebook_load_plugin_textdomain() {

			load_plugin_textdomain( 'datebook', false, plugin_basename( dirname( __FILE__ ) ) . '/languages/' );

	    }


	    /**
	     * Loads this plugin first
	     *
	     * @access public
	     * @return void
	     */
	    public static function datebook_plugin_order() {

		    $wp_path_to_this_file = preg_replace( '/(.*)plugins\/(.*)$/', WP_PLUGIN_DIR.'/$2', __FILE__ );
		    $this_plugin = plugin_basename( trim( $wp_path_to_this_file ) );
		    $active_plugins = get_option( 'active_plugins' );
		    $this_plugin_key = array_search( $this_plugin, $active_plugins );

			if ( $this_plugin_key ) {

				array_splice( $active_plugins, $this_plugin_key, 1 );
				array_unshift( $active_plugins, $this_plugin );
			    update_option( 'active_plugins', $active_plugins );

		    }

	    }


	}

	new DateBook();
}