<?php
/**
 * Variables
 *
 * @package DateBook
 */

global $datebook_field_titles, $datebook_reserved_fields, $datebook_zodiac_titles, $datebook_gender_titles, $datebook_user_menu_items, $datebook_paymentperiod_titles, $datebook_currency_titles, $paid_features_subscriptions, $time_in_seconds_array, $period_list_array, $datebook_hourly_period, $datebook_minutely_period, $datebook_image_sizes, $datebook_month_titles, $datebook_payment_gateways;


$datebook_currency_titles = array(
	'1' => array(
		esc_html__( 'United States dollar', 'datebook' ), 
		'USD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )),
	'2' => array(
		esc_html__( 'European euro', 'datebook' ), 
		'EUR', 
		'€', 
		esc_html__( 'euro', 'datebook' ), 
		esc_html__( 'euros', 'datebook' )),
	'3' => array(
		esc_html__( 'Pound sterling', 'datebook' ), 
		'GBP', 
		'&#163;', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )),
	'4' => array(
		esc_html__( 'Australian dollar', 'datebook' ), 
		'AUD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )),

	'5' => array(
		esc_html__( 'Afghan afghani', 'datebook' ), 
		'AFN', 
		'&#1547;', 
		esc_html__( 'afghani', 'datebook' ), 
		esc_html__( 'afghanis', 'datebook' )),
	'6' => array(
		esc_html__( 'Albanian lek', 'datebook' ), 
		'ALL', 
		'', 
		esc_html__( 'lek', 'datebook' ), 
		esc_html__( 'leks', 'datebook' )),
	'7' => array(
		esc_html__( 'Algerian dinar', 'datebook' ), 
		'DZD', 
		'', 
		esc_html__( 'dinar', 'datebook' ), 
		esc_html__( 'dinars', 'datebook' )), 
	'8' => array(
		esc_html__( 'Angolan kwanza', 'datebook' ), 
		'AOA', 
		'', 
		esc_html__( 'kwanza', 'datebook' ), 
		esc_html__( 'kwanzas', 'datebook' )), 
	'9' => array(
		esc_html__( 'Argentine peso', 'datebook' ), 
		'ARS', 
		'$', 
		esc_html__( 'peso', 'datebook' ), 
		esc_html__( 'pesos', 'datebook' )), 
	'10' => array(
		esc_html__( 'Armenian dram', 'datebook' ), 
		'AMD', 
		'', 
		esc_html__( 'dram', 'datebook' ), 
		esc_html__( 'drams', 'datebook' )), 
	'11' => array(
		esc_html__( 'Aruban florin', 'datebook' ), 
		'AWG', 
		'ƒ', 
		esc_html__( 'florin', 'datebook' ), 
		esc_html__( 'florins', 'datebook' )), 
	'12' => array(
		esc_html__( 'Azerbaijan manat', 'datebook' ), 
		'AZ', 
		'', 
		esc_html__( 'manat', 'datebook' ), 
		esc_html__( 'manats', 'datebook' )), 
	'13' => array(
		esc_html__( 'Bahamian dollar', 'datebook' ), 
		'BSD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'14' => array(
		esc_html__( 'Bahraini dinar', 'datebook' ), 
		'BHD', 
		'', 
		esc_html__( 'dinar', 'datebook' ), 
		esc_html__( 'dinars', 'datebook' )), 
	'15' => array(
		esc_html__( 'Bangladeshi taka', 'datebook' ), 
		'BDT', 
		'', 
		esc_html__( 'taka', 'datebook' ), 
		esc_html__( 'takas', 'datebook' )), 
	'16' => array(
		esc_html__( 'Barbadian dollar', 'datebook' ), 
		'BBD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'17' => array(
		esc_html__( 'Belarusian ruble', 'datebook' ), 
		'BYR', 
		'', 
		esc_html__( 'ruble', 'datebook' ), 
		esc_html__( 'rubles', 'datebook' )), 
	'18' => array(
		esc_html__( 'Belize dollar', 'datebook' ), 
		'BZD', 
		'BZ$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'19' => array(
		esc_html__( 'Bermudian dollar', 'datebook' ), 
		'BMD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'20' => array(
		esc_html__( 'Bhutanese ngultrum', 'datebook' ), 
		'BTN', 
		'', 
		esc_html__( 'ngultrum', 'datebook' ), 
		esc_html__( 'ngultrums', 'datebook' )), 
	'21' => array(
		esc_html__( 'Bolivian boliviano', 'datebook' ), 
		'BOB', 
		'\$b', 
		esc_html__( 'boliviano', 'datebook' ), 
		esc_html__( 'bolivianos', 'datebook' )), 
	'22' => array(
		esc_html__( 'Bosnia and Herzegovina convertible mark', 'datebook' ), 
		'BAM', 
		'KM', 
		esc_html__( 'mark', 'datebook' ), 
		esc_html__( 'marks', 'datebook' )), 
	'23' => array(
		esc_html__( 'Botswana pula', 'datebook' ), 
		'BWP', 
		'P', 
		esc_html__( 'pula', 'datebook' ), 
		esc_html__( 'pulas', 'datebook' )), 
	'24' => array(
		esc_html__( 'Brazilian real', 'datebook' ), 
		'BRL', 
		'R$', 
		esc_html__( 'real', 'datebook' ), 
		esc_html__( 'reals', 'datebook' )), 
	'25' => array(
		esc_html__( 'Brunei dollar', 'datebook' ), 
		'BND', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'26' => array(
		esc_html__( 'Bulgarian lev', 'datebook' ), 
		'BGN', 
		'', 
		esc_html__( 'lev', 'datebook' ), 
		esc_html__( 'levs', 'datebook' )), 
	'27' => array(
		esc_html__( 'Burundi franc', 'datebook' ), 
		'BIF', 
		'', 
		esc_html__( 'franc', 'datebook' ), 
		esc_html__( 'francs', 'datebook' )), 
	'28' => array(
		esc_html__( 'CFP franc', 'datebook' ), 
		'XPF', 
		'', 
		esc_html__( 'franc', 'datebook' ), 
		esc_html__( 'francs', 'datebook' )), 
	'29' => array(
		esc_html__( 'Cambodian riel', 'datebook' ), 
		'KHR', 
		'&#6107;', 
		esc_html__( 'riel', 'datebook' ), 
		esc_html__( 'riels', 'datebook' )), 
	'30' => array(
		esc_html__( 'Canadian dollar', 'datebook' ), 
		'CAD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'31' => array(
		esc_html__( 'Cape Verdean escudo', 'datebook' ), 
		'CVE', 
		'', 
		esc_html__( 'escudo', 'datebook' ), 
		esc_html__( 'escudos', 'datebook' )), 
	'32' => array(
		esc_html__( 'Caribbean dollar', 'datebook' ), 
		'XCD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'33' => array(
		esc_html__( 'Cayman Islands dollar', 'datebook' ), 
		'KYD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'34' => array(
		esc_html__( 'Central African CFA franc', 'datebook' ), 
		'XAF', 
		'', 
		esc_html__( 'franc', 'datebook' ), 
		esc_html__( 'francs', 'datebook' )), 
	'35' => array(
		esc_html__( 'Chilean peso', 'datebook' ), 
		'CLP', 
		'$', 
		esc_html__( 'peso', 'datebook' ), 
		esc_html__( 'pesos', 'datebook' )), 
	'36' => array(
		esc_html__( 'Chinese Yuan Renminbi', 'datebook' ), 
		'CNY', 
		'&#165;', 
		esc_html__( 'yuan', 'datebook' ), 
		esc_html__( 'yuans', 'datebook' )), 
	'37' => array(
		esc_html__( 'Colombian peso', 'datebook' ), 
		'COP', 
		'$', 
		esc_html__( 'peso', 'datebook' ), 
		esc_html__( 'pesos', 'datebook' )), 
	'38' => array(
		esc_html__( 'Comorian franc', 'datebook' ), 
		'KMF', 
		'', 
		esc_html__( 'franc', 'datebook' ), 
		esc_html__( 'francs', 'datebook' )), 
	'39' => array(
		esc_html__( 'Congolese franc', 'datebook' ), 
		'CDF', 
		'', 
		esc_html__( 'franc', 'datebook' ), 
		esc_html__( 'francs', 'datebook' )), 
	'40' => array(
		esc_html__( 'Costa Rican colon', 'datebook' ), 
		'CRC', 
		'&#8353;', 
		esc_html__( 'colon', 'datebook' ), 
		esc_html__( 'colons', 'datebook' )), 
	'41' => array(
		esc_html__( 'Croatian kuna', 'datebook' ), 
		'HRK', 
		'kn', 
		esc_html__( 'kuna', 'datebook' ), 
		esc_html__( 'kunas', 'datebook' )), 
	'42' => array(
		esc_html__( 'Cuban peso', 'datebook' ), 
		'CUP', 
		'&#8369;', 
		esc_html__( 'peso', 'datebook' ), 
		esc_html__( 'pesos', 'datebook' )), 
	'43' => array(
		esc_html__( 'Czech koruna', 'datebook' ), 
		'CZK', 
		'Kč', 
		esc_html__( 'koruna', 'datebook' ), 
		esc_html__( 'korunas', 'datebook' )), 
	'44' => array(
		esc_html__( 'Danish krone', 'datebook' ), 
		'DKK', 
		'kr', 
		esc_html__( 'krone', 'datebook' ), 
		esc_html__( 'krones', 'datebook' )), 
	'45' => array(
		esc_html__( 'Djiboutian franc', 'datebook' ), 
		'DJF', 
		'', 
		esc_html__( 'franc', 'datebook' ), 
		esc_html__( 'francs', 'datebook' )), 
	'46' => array(
		esc_html__( 'Dominican peso', 'datebook' ), 
		'DOP', 
		'RD$', 
		esc_html__( 'peso', 'datebook' ), 
		esc_html__( 'pesos', 'datebook' )), 
	'47' => array(
		esc_html__( 'East Caribbean dollar', 'datebook' ), 
		'XCD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'48' => array(
		esc_html__( 'Egyptian pound', 'datebook' ), 
		'EGP', 
		'&#163;', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'49' => array(
		esc_html__( 'El Salvador colones', 'datebook' ), 
		'SVC', 
		'$', 
		esc_html__( 'colone', 'datebook' ), 
		esc_html__( 'colones', 'datebook' )), 
	'50' => array(
		esc_html__( 'Eritrean nakfa', 'datebook' ), 
		'ERN', 
		'', 
		esc_html__( 'nakfa', 'datebook' ), 
		esc_html__( 'nakfas', 'datebook' )), 
	'51' => array(
		esc_html__( 'Estonia Kroon', 'datebook' ), 
		'EEK', 
		'', 
		esc_html__( 'kroon', 'datebook' ), 
		esc_html__( 'kroons', 'datebook' )), 
	'52' => array(
		esc_html__( 'Ethiopian birr', 'datebook' ), 
		'ETB', 
		'', 
		esc_html__( 'birr', 'datebook' ), 
		esc_html__( 'birrs', 'datebook' )), 
	'53' => array(
		esc_html__( 'Falkland Islands pound', 'datebook' ), 
		'FKP', 
		'&#163;', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'54' => array(
		esc_html__( 'Fijian dollar', 'datebook' ), 
		'FJD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'55' => array(
		esc_html__( 'Gambian dalasi', 'datebook' ), 
		'GMD', 
		'', 
		esc_html__( 'dalasi', 'datebook' ), 
		esc_html__( 'dalasis', 'datebook' )), 
	'56' => array(
		esc_html__( 'Georgian lari', 'datebook' ), 
		'GEL', 
		'', 
		esc_html__( 'lari', 'datebook' ), 
		esc_html__( 'laris', 'datebook' )), 
	'57' => array(
		esc_html__( 'Ghanaian cedi', 'datebook' ), 
		'GHS', 
		'&#162;', 
		esc_html__( 'cedi', 'datebook' ), 
		esc_html__( 'cedis', 'datebook' )), 
	'58' => array(
		esc_html__( 'Gibraltar pound', 'datebook' ), 
		'GIP', 
		'&#163;', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'59' => array(
		esc_html__( 'Guatemalan quetzal', 'datebook' ), 
		'GTQ', 
		'Q', 
		esc_html__( 'quetzal', 'datebook' ), 
		esc_html__( 'quetzales', 'datebook' )), 
	'60' => array(
		esc_html__( 'Guernsey Pound', 'datebook' ), 
		'GGP', 
		'&#163;', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'61' => array(
		esc_html__( 'Guinean franc', 'datebook' ), 
		'GNF', 
		'', 
		esc_html__( 'franc', 'datebook' ), 
		esc_html__( 'francs', 'datebook' )), 
	'62' => array(
		esc_html__( 'Guyanese dollar', 'datebook' ), 
		'GYD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'63' => array(
		esc_html__( 'Haitian gourde', 'datebook' ), 
		'HTG', 
		'', 
		esc_html__( 'gourde', 'datebook' ), 
		esc_html__( 'gourdes', 'datebook' )), 
	'64' => array(
		esc_html__( 'Honduran lempira', 'datebook' ), 
		'HNL', 
		'L', 
		esc_html__( 'lempira', 'datebook' ), 
		esc_html__( 'lempiras', 'datebook' )), 
	'65' => array(
		esc_html__( 'Hong Kong dollar', 'datebook' ), 
		'HKD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'66' => array(
		esc_html__( 'Hungarian forint', 'datebook' ), 
		'HUF', 
		'Ft', 
		esc_html__( 'forint', 'datebook' ), 
		esc_html__( 'forints', 'datebook' )), 
	'67' => array(
		esc_html__( 'Icelandic krona', 'datebook' ), 
		'ISK', 
		'kr', 
		esc_html__( 'krona', 'datebook' ), 
		esc_html__( 'kronas', 'datebook' )), 
	'68' => array(
		esc_html__( 'Indian rupee', 'datebook' ), 
		'INR', 
		'&#8377;', // ₹
		esc_html__( 'rupee', 'datebook' ), 
		esc_html__( 'rupees', 'datebook' )), 
	'69' => array(
		esc_html__( 'Indonesian rupiah', 'datebook' ), 
		'IDR', 
		'Rp', 
		esc_html__( 'rupiah', 'datebook' ), 
		esc_html__( 'rupiahs', 'datebook' )), 
	'70' => array(
		esc_html__( 'Iranian rial', 'datebook' ), 
		'IRR', 
		'&#65020;', 
		esc_html__( 'rial', 'datebook' ), 
		esc_html__( 'rials', 'datebook' )), 
	'71' => array(
		esc_html__( 'Iraqi dinar', 'datebook' ), 
		'IQD', 
		'', 
		esc_html__( 'dinar', 'datebook' ), 
		esc_html__( 'dinars', 'datebook' )), 
	'72' => array(
		esc_html__( 'Israeli new shekel', 'datebook' ), 
		'ILS', 
		'&#8362;', 
		esc_html__( 'shekel', 'datebook' ), 
		esc_html__( 'shekels', 'datebook' )), 
	'73' => array(
		esc_html__( 'Jamaican dollar', 'datebook' ), 
		'JMD', 
		'J$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'74' => array(
		esc_html__( 'Japanese yen', 'datebook' ), 
		'JPY', 
		'&#165;', 
		esc_html__( 'yen', 'datebook' ), 
		esc_html__( 'yens', 'datebook' )), 
	'75' => array(
		esc_html__( 'Jersey pound', 'datebook' ), 
		'JEP', 
		'&#163;', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'76' => array(
		esc_html__( 'Jordanian dinar', 'datebook' ), 
		'JOD', 
		'', 
		esc_html__( 'dinar', 'datebook' ), 
		esc_html__( 'dinars', 'datebook' )), 
	'77' => array(
		esc_html__( 'Kazakhstani tenge', 'datebook' ), 
		'KZT', 
		'', 
		esc_html__( 'tenge', 'datebook' ), 
		esc_html__( 'tenges', 'datebook' )), 
	'78' => array(
		esc_html__( 'Kenyan shilling', 'datebook' ), 
		'KES', 
		'', 
		esc_html__( 'shilling', 'datebook' ), 
		esc_html__( 'shillings', 'datebook' )), 
	'79' => array(
		esc_html__( 'Kuwaiti dinar', 'datebook' ), 
		'KWD', 
		'', 
		esc_html__( 'dinar', 'datebook' ), 
		esc_html__( 'dinars', 'datebook' )), 
	'80' => array(
		esc_html__( 'Kyrgyzstani som', 'datebook' ), 
		'KGS', 
		'', 
		esc_html__( 'som', 'datebook' ), 
		esc_html__( 'soms', 'datebook' )), 
	'81' => array(
		esc_html__( 'Lao kip', 'datebook' ), 
		'LAK', 
		'&#8365;', 
		esc_html__( 'kip', 'datebook' ), 
		esc_html__( 'kips', 'datebook' )), 
	'82' => array(
		esc_html__( 'Latvian lat', 'datebook' ), 
		'LVL', 
		'Ls', 
		esc_html__( 'lat', 'datebook' ), 
		esc_html__( 'lats', 'datebook' )), 
	'83' => array(
		esc_html__( 'Lebanese pound', 'datebook' ), 
		'LBP', 
		'&#163;', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'84' => array(
		esc_html__( 'Lesotho loti', 'datebook' ), 
		'LSL', 
		'', 
		esc_html__( 'loti', 'datebook' ), 
		esc_html__( 'lotis', 'datebook' )), 
	'85' => array(
		esc_html__( 'Liberian dollar', 'datebook' ), 
		'LRD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'86' => array(
		esc_html__( 'Libyan dinar', 'datebook' ), 
		'LYD', 
		'', 
		esc_html__( 'dinar', 'datebook' ), 
		esc_html__( 'dinars', 'datebook' )), 
	'87' => array(
		esc_html__( 'Lithuanian Litas', 'datebook' ), 
		'LTL', 
		'Lt', 
		esc_html__( 'litas', 'datebook' ), 
		esc_html__( 'litases', 'datebook' )), 
	'88' => array(
		esc_html__( 'Macanese pataca', 'datebook' ), 
		'MOP', 
		'', 
		esc_html__( 'pataca', 'datebook' ), 
		esc_html__( 'patacas', 'datebook' )), 
	'89' => array(
		esc_html__( 'Macedonian denar', 'datebook' ), 
		'MKD', 
		'', 
		esc_html__( 'denar', 'datebook' ), 
		esc_html__( 'denars', 'datebook' )), 
	'90' => array(
		esc_html__( 'Malagasy ariary', 'datebook' ), 
		'MGA', 
		'', 
		esc_html__( 'ariary', 'datebook' ), 
		esc_html__( 'ariarys', 'datebook' )), 
	'91' => array(
		esc_html__( 'Malawian kwacha', 'datebook' ), 
		'MWK', 
		'', 
		esc_html__( 'kwacha', 'datebook' ), 
		esc_html__( 'kwachas', 'datebook' )), 
	'92' => array(
		esc_html__( 'Malaysian ringgit', 'datebook' ), 
		'MYR', 
		'RM', 
		esc_html__( 'ringgit', 'datebook' ), 
		esc_html__( 'ringgits', 'datebook' )), 
	'93' => array(
		esc_html__( 'Maldivian rufiyaa', 'datebook' ), 
		'MVR', 
		'', 
		esc_html__( 'rufiyaa', 'datebook' ), 
		esc_html__( 'rufiyaas', 'datebook' )), 
	'94' => array(
		esc_html__( 'Manx pound', 'datebook' ), 
		'IMP', 
		'&#163;', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'95' => array(
		esc_html__( 'Mauritanian ouguiya', 'datebook' ), 
		'MRO', 
		'', 
		esc_html__( 'ouguiya', 'datebook' ), 
		esc_html__( 'ouguiyas', 'datebook' )), 
	'96' => array(
		esc_html__( 'Mauritian rupee', 'datebook' ), 
		'MUR', 
		'&#8360;', 
		esc_html__( 'rupee', 'datebook' ), 
		esc_html__( 'rupees', 'datebook' )), 
	'97' => array(
		esc_html__( 'Mexican peso', 'datebook' ), 
		'MXN', 
		'$', 
		esc_html__( 'peso', 'datebook' ), 
		esc_html__( 'pesos', 'datebook' )), 
	'98' => array(
		esc_html__( 'Moldovan leu', 'datebook' ), 
		'MDL', 
		'', 
		esc_html__( 'leu', 'datebook' ), 
		esc_html__( 'leus', 'datebook' )), 
	'99' => array(
		esc_html__( 'Mongolian tugrik', 'datebook' ), 
		'MNT', 
		'&#8366;', 
		esc_html__( 'tugrik', 'datebook' ), 
		esc_html__( 'tugriks', 'datebook' )), 
	'100' => array(
		esc_html__( 'Moroccan dirham', 'datebook' ), 
		'MAD', 
		'', 
		esc_html__( 'dirham', 'datebook' ), 
		esc_html__( 'dirhams', 'datebook' )), 
	'101' => array(
		esc_html__( 'Mozambican metical', 'datebook' ), 
		'MZN', 
		'MT', 
		esc_html__( 'metical', 'datebook' ), 
		esc_html__( 'meticals', 'datebook' )), 
	'102' => array(
		esc_html__( 'Myanmar kyat', 'datebook' ), 
		'MMK', 
		'', 
		esc_html__( 'kyat', 'datebook' ), 
		esc_html__( 'kyats', 'datebook' )), 
	'103' => array(
		esc_html__( 'Namibian dollar', 'datebook' ), 
		'NAD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'104' => array(
		esc_html__( 'Nepalese rupee', 'datebook' ), 
		'NPR', 
		'&#8360;', 
		esc_html__( 'rupee', 'datebook' ), 
		esc_html__( 'rupees', 'datebook' )), 
	'105' => array(
		esc_html__( 'Netherlands Antillean guilder', 'datebook' ), 
		'ANG', 
		'ƒ', 
		esc_html__( 'guilder', 'datebook' ), 
		esc_html__( 'guilders', 'datebook' )), 
	'106' => array(
		esc_html__( 'New Taiwan dollar', 'datebook' ), 
		'TWD', 
		'NT$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'107' => array(
		esc_html__( 'New Zealand dollar', 'datebook' ), 
		'NZD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'108' => array(
		esc_html__( 'Nicaraguan cordoba', 'datebook' ), 
		'NIO', 
		'C$', 
		esc_html__( 'cordoba', 'datebook' ), 
		esc_html__( 'cordobas', 'datebook' )), 
	'109' => array(
		esc_html__( 'Nigerian naira', 'datebook' ), 
		'NGN', 
		'&#8358;', 
		esc_html__( 'naira', 'datebook' ), 
		esc_html__( 'nairas', 'datebook' )), 
	'110' => array(
		esc_html__( 'North Korean won', 'datebook' ), 
		'KPW', 
		'&#8361;', 
		esc_html__( 'won', 'datebook' ), 
		esc_html__( 'wons', 'datebook' )), 
	'111' => array(
		esc_html__( 'Norwegian krone', 'datebook' ), 
		'NOK', 
		'kr', 
		esc_html__( 'krone', 'datebook' ), 
		esc_html__( 'krones', 'datebook' )), 
	'112' => array(
		esc_html__( 'Omani rial', 'datebook' ), 
		'OMR', 
		'&#65020;', 
		esc_html__( 'rial', 'datebook' ), 
		esc_html__( 'rials', 'datebook' )), 
	'113' => array(
		esc_html__( 'Pakistani rupee', 'datebook' ), 
		'PKR', 
		'&#8360;', 
		esc_html__( 'rupee', 'datebook' ), 
		esc_html__( 'rupees', 'datebook' )), 
	'114' => array(
		esc_html__( 'Panama balboa', 'datebook' ), 
		'PAB', 
		'B/.', 
		esc_html__( 'balboa', 'datebook' ), 
		esc_html__( 'balboas', 'datebook' )), 
	'115' => array(
		esc_html__( 'Papua New Guinean kina', 'datebook' ), 
		'PGK', 
		'', 
		esc_html__( 'kina', 'datebook' ), 
		esc_html__( 'kinas', 'datebook' )), 
	'116' => array(
		esc_html__( 'Paraguayan guarani', 'datebook' ), 
		'PYG', 
		'Gs', 
		esc_html__( 'guarani', 'datebook' ), 
		esc_html__( 'guaranis', 'datebook' )), 
	'117' => array(
		esc_html__( 'Peruvian sol', 'datebook' ), 
		'PE', 
		'S/.', 
		esc_html__( 'sol', 'datebook' ), 
		esc_html__( 'sols', 'datebook' )), 
	'118' => array(
		esc_html__( 'Philippine peso', 'datebook' ), 
		'PHP', 
		'Php', 
		esc_html__( 'peso', 'datebook' ), 
		esc_html__( 'pesos', 'datebook' )), 
	'119' => array(
		esc_html__( 'Polish zloty', 'datebook' ), 
		'PLN', 
		'zł', 
		esc_html__( 'zloty', 'datebook' ), 
		esc_html__( 'zlotys', 'datebook' )), 
	'120' => array(
		esc_html__( 'Qatari riyal', 'datebook' ), 
		'QAR', 
		'&#65020;', 
		esc_html__( 'riyal', 'datebook' ), 
		esc_html__( 'riyals', 'datebook' )), 
	'121' => array(
		esc_html__( 'Romanian leu', 'datebook' ), 
		'RON', 
		'lei', 
		esc_html__( 'leu', 'datebook' ), 
		esc_html__( 'leus', 'datebook' )), 
	'122' => array(
		esc_html__( 'Russian ruble', 'datebook' ), 
		'RUB', 
		'', 
		esc_html__( 'ruble', 'datebook' ), 
		esc_html__( 'rubles', 'datebook' )), 
	'123' => array(
		esc_html__( 'Rwandan franc', 'datebook' ), 
		'RWF', 
		'', 
		esc_html__( 'franc', 'datebook' ), 
		esc_html__( 'francs', 'datebook' )), 
	'124' => array(
		esc_html__( 'SDR (Special Drawing Right)', 'datebook' ), 
		'XDR', 
		'', 
		esc_html__( 'SDR', 'datebook' ), 
		esc_html__( 'SDRs', 'datebook' )), 
	'125' => array(
		esc_html__( 'Saint Helena pound', 'datebook' ), 
		'SHP', 
		'&#163;', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'126' => array(
		esc_html__( 'Samoan tala', 'datebook' ), 
		'WST', 
		'', 
		esc_html__( 'tala', 'datebook' ), 
		esc_html__( 'talas', 'datebook' )), 
	'127' => array(
		esc_html__( 'Sao Tome and Principe dobra', 'datebook' ), 
		'STD', 
		'', 
		esc_html__( 'dobra', 'datebook' ), 
		esc_html__( 'dobras', 'datebook' )), 
	'128' => array(
		esc_html__( 'Saudi Arabian riyal', 'datebook' ), 
		'SAR', 
		'&#65020;', 
		esc_html__( 'riyal', 'datebook' ), 
		esc_html__( 'riyals', 'datebook' )), 
	'129' => array(
		esc_html__( 'Serbian dinar', 'datebook' ), 
		'RSD', 
		'', 
		esc_html__( 'dinar', 'datebook' ), 
		esc_html__( 'dinars', 'datebook' )), 
	'130' => array(
		esc_html__( 'Seychellois rupee', 'datebook' ), 
		'SCR', 
		'&#8360;', 
		esc_html__( 'rupee', 'datebook' ), 
		esc_html__( 'rupees', 'datebook' )), 
	'131' => array(
		esc_html__( 'Sierra Leonean leone', 'datebook' ), 
		'SLL', 
		'', 
		esc_html__( 'leone', 'datebook' ), 
		esc_html__( 'leones', 'datebook' )), 
	'132' => array(
		esc_html__( 'Singapore dollar', 'datebook' ), 
		'SGD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'133' => array(
		esc_html__( 'Solomon Islands dollar', 'datebook' ), 
		'SBD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'134' => array(
		esc_html__( 'Somali shilling', 'datebook' ), 
		'SOS', 
		'S', 
		esc_html__( 'shilling', 'datebook' ), 
		esc_html__( 'shillings', 'datebook' )), 
	'135' => array(
		esc_html__( 'South African rand', 'datebook' ), 
		'ZAR', 
		'R', 
		esc_html__( 'rand', 'datebook' ), 
		esc_html__( 'rands', 'datebook' )), 
	'136' => array(
		esc_html__( 'South Korean won', 'datebook' ), 
		'KRW', 
		'&#8361;', 
		esc_html__( 'won', 'datebook' ), 
		esc_html__( 'wons', 'datebook' )), 
	'137' => array(
		esc_html__( 'South Sudanese pound', 'datebook' ), 
		'SSP', 
		'', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'138' => array(
		esc_html__( 'Sri Lankan rupee', 'datebook' ), 
		'LKR', 
		'&#8360;', 
		esc_html__( 'rupee', 'datebook' ), 
		esc_html__( 'rupees', 'datebook' )), 
	'139' => array(
		esc_html__( 'Sudanese pound', 'datebook' ), 
		'SDG', 
		'', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'140' => array(
		esc_html__( 'Surinamese dollar', 'datebook' ), 
		'SRD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'141' => array(
		esc_html__( 'Swazi lilangeni', 'datebook' ), 
		'SZL', 
		'', 
		esc_html__( 'lilangeni', 'datebook' ), 
		esc_html__( 'lilangenis', 'datebook' )), 
	'142' => array(
		esc_html__( 'Swedish krona', 'datebook' ), 
		'SEK', 
		'kr', 
		esc_html__( 'krona', 'datebook' ), 
		esc_html__( 'kronas', 'datebook' )), 
	'143' => array(
		esc_html__( 'Swiss franc', 'datebook' ), 
		'CHF', 
		'CHF', 
		esc_html__( 'franc', 'datebook' ), 
		esc_html__( 'francs', 'datebook' )), 
	'144' => array(
		esc_html__( 'Syrian pound', 'datebook' ), 
		'SYP', 
		'&#163;', 
		esc_html__( 'pound', 'datebook' ), 
		esc_html__( 'pounds', 'datebook' )), 
	'145' => array(
		esc_html__( 'Tajikistani somoni', 'datebook' ), 
		'TJS', 
		'', 
		esc_html__( 'somoni', 'datebook' ), 
		esc_html__( 'somonis', 'datebook' )), 
	'146' => array(
		esc_html__( 'Tanzanian shilling', 'datebook' ), 
		'TZS', 
		'', 
		esc_html__( 'shilling', 'datebook' ), 
		esc_html__( 'shillings', 'datebook' )), 
	'147' => array(
		esc_html__( 'Thai baht', 'datebook' ), 
		'THB', 
		'&#3647;', 
		esc_html__( 'baht', 'datebook' ), 
		esc_html__( 'bahts', 'datebook' )), 
	'148' => array(
		esc_html__( 'Tongan paanga', 'datebook' ), 
		'TOP', 
		'', 
		esc_html__( 'paanga', 'datebook' ), 
		esc_html__( 'paangas', 'datebook' )), 
	'149' => array(
		esc_html__( 'Trinidad and Tobago dollar', 'datebook' ), 
		'TTD', 
		'TT$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'150' => array(
		esc_html__( 'Tunisian dinar', 'datebook' ), 
		'TND', 
		'&#1583;.&#1578;', 
		esc_html__( 'dinar', 'datebook' ), 
		esc_html__( 'dinars', 'datebook' )), 
	'151' => array(
		esc_html__( 'Turkish lira', 'datebook' ), 
		'TRL', 
		'&#163;', 
		esc_html__( 'lira', 'datebook' ), 
		esc_html__( 'liras', 'datebook' )), 
	'152' => array(
		esc_html__( 'Turkmen manat', 'datebook' ), 
		'TMT', 
		'', 
		esc_html__( 'manat', 'datebook' ), 
		esc_html__( 'manats', 'datebook' )), 
	'153' => array(
		esc_html__( 'Tuvalu dollar', 'datebook' ), 
		'TVD', 
		'$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' )), 
	'154' => array(
		esc_html__( 'UAE dirham', 'datebook' ), 
		'AED', 
		'', 
		esc_html__( 'dirham', 'datebook' ), 
		esc_html__( 'dirhams', 'datebook' )), 
	'155' => array(
		esc_html__( 'Ugandan shilling', 'datebook' ), 
		'UGX', 
		'', 
		esc_html__( 'shilling', 'datebook' ), 
		esc_html__( 'shillings', 'datebook' )), 
	'156' => array(
		esc_html__( 'Ukrainian hryvnia', 'datebook' ), 
		'UAH', 
		'&#8372;', 
		esc_html__( 'hryvnia', 'datebook' ), 
		esc_html__( 'hryvnias', 'datebook' )), 
	'157' => array(
		esc_html__( 'Uruguayan peso', 'datebook' ), 
		'UYU', 
		'\$U', 
		esc_html__( 'peso', 'datebook' ), 
		esc_html__( 'pesos', 'datebook' )), 
	'158' => array(
		esc_html__( 'Uzbekistani som', 'datebook' ), 
		'UZS', 
		'', 
		esc_html__( 'som', 'datebook' ), 
		esc_html__( 'soms', 'datebook' )), 
	'159' => array(
		esc_html__( 'Vanuatu vatu', 'datebook' ), 
		'VUV', 
		'', 
		esc_html__( 'vatu', 'datebook' ), 
		esc_html__( 'vatus', 'datebook' )), 
	'160' => array(
		esc_html__( 'Venezuelan bolivar', 'datebook' ), 
		'VEF', 
		'Bs', 
		esc_html__( 'bolivar', 'datebook' ), 
		esc_html__( 'bolivars', 'datebook' )), 
	'161' => array(
		esc_html__( 'Vietnamese dong', 'datebook' ), 
		'VND', 
		'&#8363;', 
		esc_html__( 'dong', 'datebook' ), 
		esc_html__( 'dongs', 'datebook' )), 
	'162' => array(
		esc_html__( 'West African CFA franc', 'datebook' ), 
		'XOF', 
		'', 
		esc_html__( 'franc', 'datebook' ), 
		esc_html__( 'francs', 'datebook' )), 
	'163' => array(
		esc_html__( 'Yemeni rial', 'datebook' ), 
		'YER', 
		'&#65020;', 
		esc_html__( 'rial', 'datebook' ), 
		esc_html__( 'rials', 'datebook' )), 
	'164' => array(
		esc_html__( 'Zambian kwacha', 'datebook' ), 
		'ZMW', 
		'', 
		esc_html__( 'kwacha', 'datebook' ), 
		esc_html__( 'kwachas', 'datebook' )),
	'165' => array(
		esc_html__( 'Zimbabwe dollar', 'datebook' ), 
		'ZWD', 
		'Z$', 
		esc_html__( 'dollar', 'datebook' ), 
		esc_html__( 'dollars', 'datebook' ))
);


// Genders
$datebook_gender_options = $datebook_gender_titles = array(
	'1' => esc_html__( 'Woman', 'datebook' ), // fa fa-venus
	'2' => esc_html__( 'Man', 'datebook' ), // fa fa-mars
	'3' => esc_html__( 'Transexual', 'datebook' ),
	'4' => esc_html__( 'Transgender', 'datebook' ), // fa fa-transgender
	'5' => esc_html__( 'Transvestite', 'datebook' ),
	'6' => esc_html__( 'Ladyboy', 'datebook' ),
	'7' => esc_html__( 'Shemale', 'datebook' ),
	'8' => esc_html__( 'Tranny', 'datebook' ),
	'9' => esc_html__( 'Hermaphrodite', 'datebook' ),
	'10' => esc_html__( 'Neuter', 'datebook' ),
);

// Add custom Genders
if (of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '') {

	$allowed_gender_other_array = explode('<br />', strtr(of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG), array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

	foreach ($allowed_gender_other_array as $key => $value ){
		$datebook_gender_titles[] = esc_html__($value, 'datebook');
	}

}

$datebook_gender_string = implode("\r\n", $datebook_gender_titles);


// Sexual Orientations
$datebook_sexualorientation_options = $datebook_sexualorientation_titles = array(
	'1' => esc_html__( 'Straight', 'datebook' ), // fa fa-venus-mars
	'2' => esc_html__( 'Lesbian / Gay', 'datebook' ), // fa fa-venus-double / fa fa-mars-double
	'3' => esc_html__( 'Bisexual', 'datebook' ), // fa fa-transgender
	'4' => esc_html__( 'Transexual', 'datebook' ),
	'5' => esc_html__( 'Transgender', 'datebook' ), // fa fa-transgender
	'6' => esc_html__( 'Transvestite', 'datebook' ),
	'7' => esc_html__( 'Ladyboy', 'datebook' ),
	'8' => esc_html__( 'Shemale', 'datebook' ),
	'9' => esc_html__( 'Tranny', 'datebook' ),
	'10' => esc_html__( 'Pansexual', 'datebook' ),
	'11' => esc_html__( 'Bicurious', 'datebook' ),
	'12' => esc_html__( 'Polysexual', 'datebook' ),
	'13' => esc_html__( 'Monosexual', 'datebook' ),
	'14' => esc_html__( 'Allosexual', 'datebook' ),
	'15' => esc_html__( 'Androsexual', 'datebook' ),
	'16' => esc_html__( 'Gynosexual', 'datebook' ),
	'17' => esc_html__( 'Asexual', 'datebook' ),
	'18' => esc_html__( 'Demisexual', 'datebook' ),
	'19' => esc_html__( 'Grey Asexual', 'datebook' ),
	'20' => esc_html__( 'Perioriented', 'datebook' ),
	'21' => esc_html__( 'Varioriented', 'datebook' ),
	'22' => esc_html__( 'Heteronormative', 'datebook' ),
	'23' => esc_html__( 'Erasure', 'datebook' ),
	'24' => esc_html__( 'Cishet', 'datebook' ),
	'25' => esc_html__( 'Polyamorous', 'datebook' ),
	'26' => esc_html__( 'Monoamorous', 'datebook' ),
	'27' => esc_html__( 'Queer', 'datebook' ),
	'28' => esc_html__( 'Ally', 'datebook' ),
	'29' => esc_html__( 'Omnisexual', 'datebook' ),
	'30' => esc_html__( 'Intersex', 'datebook' ),
	'31' => esc_html__( 'Agender', 'datebook' ),
	'32' => esc_html__( 'Genderfluid', 'datebook' ),
	'33' => esc_html__( 'Bigender', 'datebook' ),
	'34' => esc_html__( 'Trigender', 'datebook' ),
	'35' => esc_html__( 'Genderqueer', 'datebook' ),
	'36' => esc_html__( 'Gynesexual', 'datebook' ),
	'37' => esc_html__( 'Skoliosexual', 'datebook' ),
	'38' => esc_html__( 'Object sexuality', 'datebook' ),
);

$datebook_sexualorientation_titles['1200'] = esc_html__( 'Lesbian', 'datebook' );
$datebook_sexualorientation_titles['2200'] = esc_html__( 'Gay', 'datebook' );


// Add custom Sexual Orientations
if (of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '') {

	$sexual_orientation_allowed_other_array = explode('<br />', strtr(of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG), array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

	foreach ($sexual_orientation_allowed_other_array as $key => $value ){

		$datebook_sexualorientation_titles[] = esc_html__($value, 'datebook');

	}
}

$datebook_sexualorientation_string = implode("\r\n", $datebook_sexualorientation_titles);


/* 

Definitions for sexual orientation:

--	Heterosexual		- The attraction to a gender different from their own (commonly used to describe someone who is gender binary [female or male] attracted to the other binary gender).
--	Homosexual			- The attraction to a gender the same as their own (commonly used to describe someone who is gender binary [female or male] attracted to the same binary gender).  Sometimess referred to as gay.
--	Lesbian				- Women who are attracted only to other women
--	Bisexual			- When you are attracted to two or more genders.  This term is generally used to describe being attracted to men and women, but can apply to being attracted to any two or more genders. Note that you do not have to be equally attracted to each gender.
--	Pansexual			- When you are attracted to all genders and/or do not concern gender when you are attracted towards someone
--	Bicurious			- People who are open to experiment with genders that are not only their own, but do not know if they are open to forming any sort of relationship with multiple genders.
--	Polysexual			- When you are attracted to many genders
--	Monosexual			- Being attracted to only one gender
--	Allosexual			- When you are not asexual (attracted to at least one gender)
--	Androsexual			- Being attracted to masculine gender presentation
--	Gynosexual			- Being attracted to feminine gender presentation
--	Questioning			- People who are debating their own sexuality/gender
--	Asexual				- Not experiencing sexual attraction (note that you can also be aromantic and you do not necessarily have to be asexual and aromantic at the same time).  Sometimes the term, ace, is used to describe asexuals.
--	Demisexual			- When you only experience sexual attraction after forming a strong emotional bond first or a romantic bond
--	Grey Asexual		- When you only experience attraction rarely, on a very low scale, or only under certain circumstances
--	Perioriented		- When your sexual and romantic orientation targets the same gender (for example being heteromantic and heterosexual or being biromantic and bisexual)
--	Varioriented		- When your sexual and romantic orientations do not target the same set of genders (for example being heteromantic and bisexual or being homoromantic and pansexual)
--	Heteronormative		- The belief that hetersexuality is the norm and that sex, gender, sexuality, and gender roles all align
--	Erasure				- Ignoring the existance of genders and sexualities in the middle of the spectrum
--	Cishet				- Someone who is both cisgendered and heterosexual.  This is sometimes used as a slur.
--	Polyamorous			- An umbrella term referring to people who have or are open to have consensually have relationships with multiple people at the same time
--	Monoamorous			- People who have or or open to have relationships with only one other person at a time.  The term, monogamous, is also sometimes used.
--	Queer				- A reclaimed slur for anybody in the LGBT+ community or who do not identify as cisgender and/or hetersexual/heteromantic
--	Ally				- A supporter of the LGBT+ community that does not identify as LGBT+
--	Omnisexual			- Another word used to describe pansexuals.
--	Intersex			- Intersex people are born with sexual anatomy that does not match the typical definition of either male or female.
--	Agender				- Agender people either have no gender, or consider themselves gender neutral.
--	Genderfluid			- Being genderfluid means you experience more than one gender identity at different times or in different situations.
--	Bigender			- Bigender people experience two gender identities, either at the same time or at different times, or in different situations. For example, some bigender people may have a male and a female identity for which they may use two different names and wear different styles of clothing.
--	Trigender			- Trigender people experience three gender identities.
--	Genderqueer			- This is an umbrella term that can refer to anyone who does not identify as a male or female.
--	Gynesexual			- Someone sexually attracted to females.
--	Skoliosexual		- Someone attracted to non-binary people or those who aren't cis-gendered.
--	Object sexuality	- When a person feels sexual attraction and/or strong feelings of love and commitment to inanimate objects.
*/

// Reserved custom fields
$datebook_reserved_fields = array(
	'profiletypereserved' => array('slug' => 'profiletypereserved', 'name_en_US' => esc_html__('Profile Type', 'datebook'), 'type' => 'select', 'field_items_en_US' => '', 'searchable' => 1, 'required' => 1, 'active' => 0, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 1, 'type' => 1, 'field_items' => 0, 'characters_limit' => 0, 'searchable' => 1, 'required' => 0, 'visible_to_admin_only' => 1)),
	'profilename' => array('slug' => 'profilename', 'name_en_US' => esc_html__('Name', 'datebook'), 'type' => 'text', 'field_items_en_US' => '', 'searchable' => 1, 'required' => 1, 'active' => 1, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 1, 'type' => 0, 'field_items' => 0, 'characters_limit' => 1, 'searchable' => 1, 'required' => 0, 'visible_to_admin_only' => 1)),
	'aboutyou' => array('slug' => 'aboutyou', 'name_en_US' => esc_html__('About Me', 'datebook'), 'type' => 'textarea', 'field_items_en_US' => '', 'searchable' => 1, 'required' => 1, 'active' => 1, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 1, 'type' => 0, 'field_items' => 0, 'characters_limit' => 1, 'searchable' => 1, 'required' => 1, 'visible_to_admin_only' => 1)),
	'countrycity' => array('slug' => 'countrycity', 'name_en_US' => esc_html__('Location', 'datebook'), 'type' => 'select', 'field_items_en_US' => '', 'countrycity_hierarchy' => 3, 'countrycity_hierarchy_search' => 3, 'searchable' => 1, 'required' => 1, 'active' => 1, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 1, 'type' => 0, 'field_items' => 0, 'characters_limit' => 0, 'searchable' => 1, 'required' => 1, 'visible_to_admin_only' => 1)),
	'birthdate' => array('slug' => 'birthdate', 'name_en_US' => esc_html__('Date of Birth', 'datebook'), 'type' => 'text', 'field_items_en_US' => '', 'searchable' => 1, 'required' => 1, 'active' => 1, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 1, 'type' => 0, 'field_items' => 0, 'characters_limit' => 0, 'searchable' => 1, 'required' => 1, 'visible_to_admin_only' => 1)),
	'gender' => array('slug' => 'gender', 'name_en_US' => esc_html__('Gender', 'datebook'), 'type' => 'radio', 'field_items_en_US' => $datebook_gender_string, 'searchable' => 1, 'required' => 1, 'active' => 1, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 1, 'type' => 1, 'field_items' => 1, 'characters_limit' => 0, 'searchable' => 1, 'required' => 1, 'visible_to_admin_only' => 1)),
	'sexualorientation' => array('slug' => 'sexualorientation', 'name_en_US' => esc_html__('Sexual Orientation', 'datebook'), 'type' => 'select', 'field_items_en_US' => $datebook_sexualorientation_string, 'searchable' => 1, 'required' => 1, 'active' => 1, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 1, 'type' => 1, 'field_items' => 1, 'characters_limit' => 0, 'searchable' => 1, 'required' => 1, 'visible_to_admin_only' => 1)),
	'phone' => array('slug' => 'phone', 'name_en_US' => esc_html__('Phone', 'datebook'), 'type' => 'text', 'field_items_en_US' => '', 'searchable' => 0, 'required' => 0, 'active' => 0, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 1, 'type' => 0, 'field_items' => 0, 'characters_limit' => 1, 'searchable' => 1, 'required' => 1, 'visible_to_admin_only' => 1)),
	'website' => array('slug' => 'website', 'name_en_US' => esc_html__('Website', 'datebook'), 'type' => 'text', 'field_items_en_US' => '', 'searchable' => 0, 'required' => 0, 'active' => 0, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 1, 'type' => 0, 'field_items' => 0, 'characters_limit' => 1, 'searchable' => 1, 'required' => 1, 'visible_to_admin_only' => 1)),
	'user' => array('slug' => 'user', 'name_en_US' => esc_html__('Username', 'datebook'), 'type' => 'text', 'field_items_en_US' => '', 'searchable' => 1, 'required' => 1, 'active' => 1, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 1, 'type' => 0, 'field_items' => 0, 'characters_limit' => 1, 'searchable' => 1, 'required' => 1, 'visible_to_admin_only' => 1)),
	'email' => array('slug' => 'email', 'name_en_US' => esc_html__('Email', 'datebook'), 'type' => 'text', 'field_items_en_US' => '', 'searchable' => 1, 'required' => 1, 'active' => 1, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 0, 'type' => 0, 'field_items' => 0, 'characters_limit' => 1, 'searchable' => 1, 'required' => 0, 'visible_to_admin_only' => 1)),
	'newpass' => array('slug' => 'newpass', 'name_en_US' => esc_html__('Password', 'datebook'), 'type' => 'text', 'field_items_en_US' => '', 'searchable' => 1, 'required' => 1, 'active' => 1, 'visible_to_admin_only' => 0, 'active_fields' => array('enable' => 0, 'type' => 0, 'field_items' => 0, 'characters_limit' => 1, 'searchable' => 1, 'required' => 1, 'visible_to_admin_only' => 1)),
	'onlinestatus' => array('slug' => 'onlinestatus', 'name_en_US' => esc_html__('Online', 'datebook'), 'type' => 'checkbox', 'field_items_en_US' => '', 'searchable' => 1, 'required' => 0, 'active' => 1, 'active_fields' => array('enable' => 1, 'type' => 0, 'field_items' => 0, 'characters_limit' => 0, 'searchable' => 0, 'required' => 1)),
	'searchbyname' => array('slug' => 'searchbyname', 'name_en_US' => esc_html__('Search by name, ID, username', 'datebook'), 'type' => 'text', 'field_items_en_US' => '', 'searchable' => 1, 'required' => 0, 'active' => 1, 'active_fields' => array('enable' => 1, 'type' => 0, 'field_items' => 0, 'characters_limit' => 1, 'searchable' => 0, 'required' => 1)),
);


// Phrases used for Tours
$datebook_tours_happening_titles = array(
	'1' => esc_html__( 'Happening now', 'datebook' ),
	'2' => esc_html__( 'Starting soon', 'datebook' )
);

// Zodiac signs
$datebook_zodiac_titles = array(
	'0' => array('', '', '', ''),
	'1' => array(esc_html__( 'Capricorn', 'datebook' ), '♑', '&#9809;', 'U+2651'),
	'2' => array(esc_html__( 'Aquarius', 'datebook' ), '♒', '&#9810;', 'U+2652'),
	'3' => array(esc_html__( 'Pisces', 'datebook' ), '♓', '&#9811;', 'U+2653'),
	'4' => array(esc_html__( 'Aries', 'datebook' ), '♈', '&#9800;', 'U+2648'),
	'5' => array(esc_html__( 'Taurus', 'datebook' ), '♉', '&#9801;', 'U+2649'),
	'6' => array(esc_html__( 'Gemini', 'datebook' ), '♊', '&#9802;', 'U+264A'),
	'7' => array(esc_html__( 'Cancer', 'datebook' ), '♋', '&#9803;', 'U+264B'),
	'8' => array(esc_html__( 'Leo', 'datebook' ), '♌', '&#9804;', 'U+264C'),
	'9' => array(esc_html__( 'Virgo', 'datebook' ), '♍', '&#9805;', 'U+264D'),
	'10' => array(esc_html__( 'Libra', 'datebook' ), '♎', '&#9806;', 'U+264E'),
	'11' => array(esc_html__( 'Scorpio', 'datebook' ), '♏', '&#9807;', 'U+264F'),
	'12' => array(esc_html__( 'Sagittarius', 'datebook' ), '♐', '&#9808;', 'U+2650')
);

// Months and days
$datebook_month_titles = array(
	// Months
	'1' => esc_html__( 'January', 'datebook' ),
	'2' => esc_html__( 'February', 'datebook' ),
	'3' => esc_html__( 'March', 'datebook' ),
	'4' => esc_html__( 'April', 'datebook' ),
	'5' => esc_html__( 'May', 'datebook' ),
	'6' => esc_html__( 'June', 'datebook' ),
	'7' => esc_html__( 'July', 'datebook' ),
	'8' => esc_html__( 'August', 'datebook' ),
	'9' => esc_html__( 'September', 'datebook' ),
	'10' => esc_html__( 'October', 'datebook' ),
	'11' => esc_html__( 'November', 'datebook' ),
	'12' => esc_html__( 'December', 'datebook' ),

	// Days
	'13' => esc_html__( 'Monday', 'datebook' ),
	'14' => esc_html__( 'Tuesday', 'datebook' ),
	'15' => esc_html__( 'Wednesday', 'datebook' ),
	'16' => esc_html__( 'Thursday', 'datebook' ),
	'17' => esc_html__( 'Friday', 'datebook' ),
	'18' => esc_html__( 'Saturday', 'datebook' ),
	'19' => esc_html__( 'Sunday', 'datebook' ),

	// Days Short
	'20' => esc_html__( 'Mon', 'datebook' ),
	'21' => esc_html__( 'Tue', 'datebook' ),
	'22' => esc_html__( 'Wed', 'datebook' ),
	'23' => esc_html__( 'Thu', 'datebook' ),
	'24' => esc_html__( 'Fri', 'datebook' ),
	'25' => esc_html__( 'Sat', 'datebook' ),
	'26' => esc_html__( 'Sun', 'datebook' )

);


// Period variables. 1 - one minute; 2 - one hour; 3 - one day; 4 - one month; 5 - one year;
$time_in_seconds_array = array('0' => 0, '1' => 60, '2' => 3600, '3' => 86400, '4' => 2629743, '5' => 31556926);
$period_list_array = array('1' => 'minutes', '2' => 'hours', '3' => 'days', '4' => 'weeks', '5' => 'months', '6' => 'years');


$datebook_paymentperiod_titles = array(
	// 0 - Name, 1 - PayPal t3
	1 => array('Minute', 'I'),
	2 => array('Hour', 'H'),
	3 => array('Day', 'D'),
	4 => array('Week', 'W'),
	5 => array('Month', 'M'),
	6 => array('Year', 'Y'),
);

// Default time for Chat in Theme Options
$hourly_time_array_1 = array(
	'0' => esc_html__('Unlimited', 'datebook' ),
	'1' => '1 ' . esc_html__('hour', 'datebook' )
);
$hourly_time_array_2 = array();
for ($i = 2; $i <= 48; $i++) {
	$hourly_time_array_2[] = $i . ' '. esc_html__('hours', 'datebook' );
}
$datebook_hourly_period = array_merge($hourly_time_array_1, $hourly_time_array_2);

$minutely_time_array_1 = array(
	'0' => esc_html__('Do not send', 'datebook' ),
	'3' => '3 ' . esc_html__('minutes', 'datebook' )
);
$minutely_time_array_2 = array();
for ($i = 2; $i <= 360; $i++) {
	if($i % 5 == 0){
		$minutely_time_array_2[$i] = $i . ' ' . esc_html__('minutes', 'datebook' );
	}
}
$datebook_minutely_period = $minutely_time_array_1 + $minutely_time_array_2;

// List of all available gateways
$datebook_payment_gateways = array(
	//'2checkout' => '2checkout',
	//'authorized' => 'Authorized.net',
	//'bluepay' => 'BluePay',
	//'bluesnap' => 'BlueSnap',
	//'braintree' => 'Braintree',
	//'cardcom' => 'Cardcom',
	//'Cashfree' => 'Cashfree',
	//'CCAvenue' => 'CCAvenue',
	//'ccbill' => 'CCBill',
	//'chronopay' => 'ChronoPay',
	//'conekta' => 'Conekta',
	//'ipay' => 'iPay',
	//'instamojo' => 'Instamojo',
	//'fastcharge' => 'Fast Charge',
	//'firstdata' => 'Payeezy (First Data)',
	//'fortumo' => 'Fortumo',
	//'payfast' => 'PayFast',
	//'payfort' => 'PayFort',
	//'paykings' => 'PayKings',
	//'paymaster' => 'PayMaster',
	//'paynova' => 'Paynova',
	'paypal_standard' => 'PayPal Standard',
	//'paysimple' => 'PaySimple',
	'paystack' => 'Paystack',
	//'paytm' => 'Paytm',
	//'payu' => 'PayU',
	//'quickpay' => 'QuickPay',
	//'rave' => 'Rave',
	//'razorpay' => 'Razorpay',
	//'securionpay' => 'SecurionPay',
	//'skrill' => 'Skrill',
	//'stripe' => 'Stripe',
	//'yandex' => 'Yandex',
	//'worldline' => 'Worldline',
	//'cod' => 'Cash on delivery',
	//'cheque' => 'Cheque',
	'bank' => 'Bank'
);

// Set width and height of images
$enable_image_dimensions = of_get_option('datebook_custom_images') ? 1 : 0;

$datebook_image_dimensions = array();
$datebook_image_dimensions['image_avatar'] = $enable_image_dimensions == 1 && of_get_option('image_avatar') ? explode(',', of_get_option('image_avatar')) : array('57','57');
$datebook_image_dimensions['image_big'] = $enable_image_dimensions == 1 && of_get_option('image_big') ? explode(',', of_get_option('image_big')) : array('800','600');
$datebook_image_dimensions['image_classifieds_other_page'] = $enable_image_dimensions == 1 && of_get_option('image_classifieds_other_page') ? explode(',', of_get_option('image_classifieds_other_page')) : array('57','57');
$datebook_image_dimensions['image_classifieds_sidebar'] = $enable_image_dimensions == 1 && of_get_option('image_classifieds_sidebar') ? explode(',', of_get_option('image_classifieds_sidebar')) : array('57','57');
$datebook_image_dimensions['image_comments_sidebar'] = $enable_image_dimensions == 1 && of_get_option('image_comments_sidebar') ? explode(',', of_get_option('image_comments_sidebar')) : array('44','44');
$datebook_image_dimensions['image_feature_front'] = $enable_image_dimensions == 1 && of_get_option('image_feature_front') ? explode(',', of_get_option('image_feature_front')) : array('85','85');
$datebook_image_dimensions['image_feature_other'] = $enable_image_dimensions == 1 && of_get_option('image_feature_other') ? explode(',', of_get_option('image_feature_other')) : array('85','85');
$datebook_image_dimensions['image_feature_single_sidebar'] = $enable_image_dimensions == 1 && of_get_option('image_feature_single_sidebar') ? explode(',', of_get_option('image_feature_single_sidebar')) : array('321','265');
$datebook_image_dimensions['image_front_medium'] = $enable_image_dimensions == 1 && of_get_option('image_front_medium') ? explode(',', of_get_option('image_front_medium')) : array('178','178');
$datebook_image_dimensions['image_front_small'] = $enable_image_dimensions == 1 && of_get_option('image_front_small') ? explode(',', of_get_option('image_front_small')) : array('85','85');
$datebook_image_dimensions['image_gallery'] = $enable_image_dimensions == 1 && of_get_option('image_gallery') ? explode(',', of_get_option('image_gallery')) : array('112','112');
$datebook_image_dimensions['image_latest_profiles_images_sidebar'] = $enable_image_dimensions == 1 && of_get_option('image_latest_profiles_images_sidebar') ? explode(',', of_get_option('image_latest_profiles_images_sidebar')) : array('78','78');
$datebook_image_dimensions['image_latest_profiles_sidebar'] = $enable_image_dimensions == 1 && of_get_option('image_latest_profiles_sidebar') ? explode(',', of_get_option('image_latest_profiles_sidebar')) : array('57','57');
$datebook_image_dimensions['image_notifications'] = $enable_image_dimensions == 1 && of_get_option('image_notifications') ? explode(',', of_get_option('image_notifications')) : array('44','44');
$datebook_image_dimensions['image_photos_upload_form'] = $enable_image_dimensions == 1 && of_get_option('image_photos_upload_form') ? explode(',', of_get_option('image_photos_upload_form')) : array('138','138');
$datebook_image_dimensions['image_popup_notification'] = $enable_image_dimensions == 1 && of_get_option('image_popup_notification') ? explode(',', of_get_option('image_popup_notification')) : array('44','44');
$datebook_image_dimensions['image_profile'] = $enable_image_dimensions == 1 && of_get_option('image_profile') ? explode(',', of_get_option('image_profile')) : array('258','348');
$datebook_image_dimensions['image_profile_chat_main'] = $enable_image_dimensions == 1 && of_get_option('image_profile_chat_main') ? explode(',', of_get_option('image_profile_chat_main')) : array('44','44');
$datebook_image_dimensions['image_profile_chat_sidebar'] = $enable_image_dimensions == 1 && of_get_option('image_profile_chat_sidebar') ? explode(',', of_get_option('image_profile_chat_sidebar')) : array('44','44');
$datebook_image_dimensions['image_profile_user_menu'] = $enable_image_dimensions == 1 && of_get_option('image_profile_user_menu') ? explode(',', of_get_option('image_profile_user_menu')) : array('44','44');
$datebook_image_dimensions['image_related_profiles_by_city_sidebar'] = $enable_image_dimensions == 1 && of_get_option('image_related_profiles_by_city_sidebar') ? explode(',', of_get_option('image_related_profiles_by_city_sidebar')) : array('67','67');
$datebook_image_dimensions['image_related_profiles_by_country_sidebar'] = $enable_image_dimensions == 1 && of_get_option('image_related_profiles_by_country_sidebar') ? explode(',', of_get_option('image_related_profiles_by_country_sidebar')) : array('138','138');
$datebook_image_dimensions['image_search'] = $enable_image_dimensions == 1 && of_get_option('image_search') ? explode(',', of_get_option('image_search')) : array('264','193');
$datebook_image_dimensions['image_top_front'] = $enable_image_dimensions == 1 && of_get_option('image_top_front') ? explode(',', of_get_option('image_top_front')) : array('178','140');
$datebook_image_dimensions['image_tours_sidebar'] = $enable_image_dimensions == 1 && of_get_option('image_tours_sidebar') ? explode(',', of_get_option('image_tours_sidebar')) : array('44','44');
$datebook_image_dimensions['image_friend_request'] = $enable_image_dimensions == 1 && of_get_option('image_friend_request') ? explode(',', of_get_option('image_friend_request')) : array('173','173');


$datebook_image_sizes = array();

foreach($datebook_image_dimensions as $key => $value){
	$datebook_image_sizes[$key] = array('width' => $value[0], 'height' => $value[1]);
}


$datebook_user_menu_items = array(
	'my_messages_page' => array('title' => esc_html__('Messages', 'datebook'), 'icon' => 'fas fa-envelope'),
	'my_edit_profile_page' => array('title' => esc_html__('Edit profile', 'datebook'), 'icon' => 'fas fa-edit'),
	'my_photos_page' => array('title' => esc_html__('Photos', 'datebook'), 'icon' => 'fas fa-image'),
	'my_verification_page' => array('title' => esc_html__('Verification', 'datebook'), 'icon' => 'far fa-check-square'),
	'my_friends_page' => array('title' => esc_html__('Friends', 'datebook'), 'icon' => 'fas fa-user-friends'),
	'my_favorites_page' => array('title' => esc_html__('Favorites', 'datebook'), 'icon' => 'fas fa-bookmark'),
	'my_blacklist_page' => array('title' => esc_html__('Blacklist', 'datebook'), 'icon' => 'fas fa-user-secret'),
	'my_comments_page' => array('title' => esc_html__('Comments', 'datebook'), 'icon' => 'fas fa-comments'),
	'my_classifieds_page' => array('title' => esc_html__('Classifieds', 'datebook'), 'icon' => 'fas fa-bullhorn'),
	'my_tours_page' => array('title' => esc_html__('Tours', 'datebook'), 'icon' => 'fas fa-map-marker'),
	'my_views_page' => array('title' => esc_html__('Views', 'datebook'), 'icon' => 'fas fa-eye'),
	'my_settings_page' => array('title' => esc_html__('Settings', 'datebook'), 'icon' => 'fas fa-sliders-h'),
	'my_privacy_page' => array('title' => esc_html__('Privacy', 'datebook'), 'icon' => 'fas fa-lock'),
	'my_upgrade_page' => array('title' => esc_html__('Subscriptions', 'datebook'), 'icon' => 'fas fa-certificate')
);

$datebook_who_can_see_array = array(
	'everyone' => esc_html__('Everyone', 'datebook'),
	'noone' => esc_html__('No one', 'datebook'),
	'friends' => esc_html__('Friends only', 'datebook'),
	'loggedinusers' => esc_html__('Registered users only','datebook'),
	'subscribedusers' => esc_html__('Subscribed users only', 'datebook'),
	//'askforpermission' => esc_html__('Ask for my permission', 'datebook')
);


// Put all fields to variable	
$datebook_field_titles = array( 
	'datebook_sexualorientation_options' => $datebook_sexualorientation_options,
	'datebook_gender_options' => $datebook_gender_options,
	'datebook_gender_titles' => $datebook_gender_titles,
	'datebook_sexualorientation_titles' => $datebook_sexualorientation_titles, 
	'datebook_tours_happening_titles' => $datebook_tours_happening_titles, 
	'datebook_month_titles' => $datebook_month_titles,
	'datebook_currency_titles' => $datebook_currency_titles, 
	'datebook_paymentperiod_titles' => $datebook_paymentperiod_titles,
	'datebook_user_menu_items' => $datebook_user_menu_items,
	'datebook_who_can_see_array' => $datebook_who_can_see_array
);


// Locked sections requiring the payment
$paid_features_subscriptions = array(
	'top_position' => esc_html__('Top position', 'datebook' ),
	'featured_position' => esc_html__('Featured position', 'datebook' ),
	'simultaneous_chatters' => esc_html__('Send messages', 'datebook' ),
	//'allow_messages_from_paid_members_only' => esc_html__('Allow incoming messages from paid members only', 'datebook' ),
	//'allow_free_members_read_messages' => esc_html__('Allow to read messages from free and paid members', 'datebook' ),
	'upload_images' => esc_html__('Upload photos', 'datebook' ),
	'enter_phone' => esc_html__('Add phone', 'datebook' ),
	'enter_website' => esc_html__('Add Website URL', 'datebook' ),
	//'who_viewed_me' => esc_html__('View statistics about who visited my profile', 'datebook' ),

	//'hide_online' => esc_html__('Hide online status', 'datebook' ),
	//'hide_dateofbirth' => esc_html__('Hide date of birth', 'datebook' ),
	//'hide_zodiac' => esc_html__('Hide zodiac sign', 'datebook' ),
	//'become_invisible' => esc_html__('Hide visiting other profiles', 'datebook' ),
	//'post_comments' => esc_html__('Post comments on other profiles', 'datebook' ),

	//'access_profile_images' => esc_html__('See all images of other profiles', 'datebook' ),
	//'search_by_profile_fields' => esc_html__('Search by all profile fields', 'datebook' ),
	//'search_by_images_only' => esc_html__('Search for profiles with images only', 'datebook' ),
	//'search_by_orientation' => esc_html__('Search for profiles by sexual orientation', 'datebook' ),
	//'search_by_zodiac' => esc_html__('Search for Profiles by zodiac sign', 'datebook' ),

	//'style_profile' => esc_html__('Change style of your profile (colors, background images)', 'datebook' ),
	//'stickers_chat' => esc_html__('Add colorful and unique stickers to correspondence', 'datebook' ),

);