<?php
/**
 * Create Cookie Notice.
 *
 * @class Class_DateBook_Cookies_Admin
 * @author Pagick Themes
 * @since 3.3
 */
	 


/**
 * Cookie Notice class.
 */
class Class_DateBook_Cookies_Admin {


	/**
	 * Load scripts and styles - admin.
	 */
	public static function admin_enqueue_scripts() {

		// Add the color picker css file       
        wp_enqueue_style( 'wp-color-picker' ); 

        // Include our custom jQuery file with WordPress Color Picker dependency
		wp_enqueue_script( 'datebook-cookies-admin', OPTIONS_FRAMEWORK_DIRECTORY . 'js/datebook-cookies-admin.js', array( 'wp-color-picker' ), false, true ); 

		wp_localize_script(
			'datebook-cookies-admin', 'DateBookCookiesArgs', array(
				'resetToDefaults'	=> esc_html__( 'Are you sure you want to reset these settings to defaults?', 'datebook' )
			)
		);

		wp_enqueue_style( 'datebook-cookies-admin', OPTIONS_FRAMEWORK_DIRECTORY . 'css/datebook-cookies-admin.css' );
	}


	/**
	 * List page handler
	 *
	 * This function renders our custom table
	 * Notice how we display message about successfull deletion
	 * Actualy this is very easy, and you can add as many features
	 * as you want.
	 *
	 * Look into /wp-admin/includes/class-wp-*-list-table.php for examples
	 */
	public static function cookies_page_handler() {

		// Add the color picker css file       
        wp_enqueue_style( 'wp-color-picker' ); 

        // Include our custom jQuery file with WordPress Color Picker dependency
        wp_enqueue_script( 'datebook-cookies-admin', OPTIONS_FRAMEWORK_DIRECTORY . 'js/datebook-cookies-admin.js', array( 'wp-color-picker' ), false, true ); 

		wp_localize_script(
			'datebook-cookies-admin', 'DateBookCookiesArgs', array(
				'resetToDefaults'	=> esc_html__( 'Are you sure you want to reset these settings to defaults?', 'datebook' )
			)
		);

		wp_enqueue_style( 'datebook-cookies-admin', OPTIONS_FRAMEWORK_DIRECTORY . 'css/datebook-cookies-admin.css' );

		
		self::settings_page_content();

	}



	/**
	 * Default options
	 */
	private static function defaults_settings() {

		$defaults = array(
			'general' => array(
				'position'						=> 'bottom',
				'message_text'					=> 'This site uses cookies. By continuing to browse the site you are agreeing to our use of cookies.',
				'button_size'						=> 'btn-sm',
				'button_position'				=> 'bottom',
				'accept_text'					=> 'Accept',
				'refuse_text'					=> 'No',
				'refuse_opt'					=> 'no',
				'refuse_code'					=> '',
				'refuse_code_head'				=> '',
				'redirection'					=> false,
				'see_more'						=> 'no',
				'link_target'					=> '_blank',
				'time'							=> 'month',
				'hide_effect'					=> 'fade',
				'on_scroll'						=> false,
				'on_scroll_offset'				=> 100,
				'colors' => array(
					'text'						=> '#fff',
					'bar'						=> '#000'
				),
				'button_colors' => array(
					'text'						=> '#000',
					'bar'						=> '#fff'
				),
				'see_more_opt' => array(
					'text'						=> 'Read more',
					'link_type'					=> 'page',
					'id'						=> 'empty',
					'link'						=> '',
					'sync'						=> false
				)
			)
		);
	
		return $defaults;
	
	}


	/**
	 * Options page output.
	 */
	public static function settings_page_content() {
		

		// here we are verifying does this request is post back and have correct nonce
		if (isset($_POST['save_datebook_cookies_options'])) {
			
			// validate data, and if all ok save item to database
			// if id is zero insert otherwise update
			$item_data = self::validate_data($_POST);

			if ($item_data['success'] === true) {
				
				$options = $item_data;
				
				//print_r($options);
				
				//Update entire array
				$result = update_option( 'datebook_cookies_options', $options );
				
				if( $result === FALSE){
					$notice = esc_html__('Data has not been saved', 'datebook');
				} else {
					$message = esc_html__('Options have been successfully saved', 'datebook');
				}

			}
		}
			
		
		
		$defaults = self::defaults_settings();

		// settings
		$options = array(
			'general' => array_merge( $defaults['general'], get_option( 'datebook_cookies_options', $defaults['general'] ) )
		);

		if ( ! isset( $options['general']['see_more_opt']['sync'] ) ){
			$options['general']['see_more_opt']['sync'] = $defaults['general']['see_more_opt']['sync'];
		}
		
		echo '
		<div class="wrap">
			<h2>' . esc_html__( 'DateBook Cookies Settings', 'datebook' ) . '</h2>
			<div class="datebook-cookies-settings">';
			
			
		if (!empty($notice)): ?>

			<div id="notice" class="error">
					<p><?php echo esc_attr($notice); ?></p>
				</div>

			<?php endif;?>

			<?php if (!empty($message)): ?>

				<div id="message" class="updated">
					<p><?php echo esc_attr($message) ?></p>
				</div>

			<?php endif;

			
			
			
		echo '<form action="" method="post">';

		
		echo '<h2>' . esc_html__( 'Configuration', 'datebook' ) . '</h2>';
		
		echo '<p>' . esc_html__( 'Cookies must be enabled in the Theme Options. Go to DateBook -> Dashboard -> Common tab -> check the Enable Cookies Bar box', 'datebook' ) . '</p2>';
		
		
		echo '<table class="form-table"><tbody>';

		echo '<tr><th scope="row">'.esc_html__( 'Message', 'datebook' ).'</th><td>
		<fieldset>
			<div id="datebook_cookies_message_text">
				<textarea name="datebook_cookies_options[message_text]" class="large-text" cols="50" rows="5">' . esc_textarea( $options['general']['message_text'] ) . '</textarea>
				<p class="description">' . esc_html__( 'Enter the cookie notice message.', 'datebook' ) . '</p>
			</div>
		</fieldset>
		
		</td></tr>';
		
		
		echo '
		<tr><th scope="row">'.esc_html__( 'Button text', 'datebook' ).'</th><td>
		<fieldset>
			<div id="datebook_cookies_accept_text">
				<input type="text" class="regular-text" name="datebook_cookies_options[accept_text]" value="' . esc_attr( $options['general']['accept_text'] ) . '" />
			<p class="description">' . esc_html__( 'The text of the option to accept the usage of the cookies and make the notification disappear.', 'datebook' ) . '</p>
			</div>
		</fieldset></td></tr>';

		echo '
		<tr><th scope="row">'.esc_html__( 'Refuse cookies', 'datebook' ).'</th><td>
		<fieldset>
			<label><input id="datebook_cookies_refuse_opt" type="checkbox" name="datebook_cookies_options[refuse_opt]" value="1" ' . checked( 'yes', $options['general']['refuse_opt'], false ) . ' /> ' . esc_html__( 'Enable to give to the user the possibility to refuse third party non functional cookies.', 'datebook' ) . '</label>
			<div id="datebook_cookies_refuse_opt_container"' . ( $options['general']['refuse_opt'] === 'no' ? ' style="display: none;"' : '' ) . '>
				<div id="datebook_cookies_refuse_text">
					<input type="text" class="regular-text" name="datebook_cookies_options[refuse_text]" value="' . esc_attr( $options['general']['refuse_text'] ) . '" />
					<p class="description">' . esc_html__( 'The text of the button to refuse the usage of the cookies.', 'datebook' ) . '</p>
				</div>
			</div>
		</fieldset></td></tr>';



		echo '
		<tr><th scope="row">'.esc_html__( 'Reloading', 'datebook' ).'</th><td>
		<fieldset>
			<label><input id="datebook_cookies_redirection" type="checkbox" name="datebook_cookies_options[redirection]" value="1" ' . checked( true, $options['general']['redirection'], false ) . ' /> ' . esc_html__( 'Enable to reload the page after cookies are accepted.', 'datebook' ) . '</label>
		</fieldset></td></tr>';


		$pages = get_pages(
			array(
				'sort_order'	=> 'ASC',
				'sort_column'	=> 'post_title',
				'hierarchical'	=> 0,
				'child_of'		=> 0,
				'parent'		=> -1,
				'offset'		=> 0,
				'post_type'		=> 'page',
				'post_status'	=> 'publish'
			)
		);

		echo '
		<tr><th scope="row">'.esc_html__( 'Privacy policy', 'datebook' ).'</th><td>
		<fieldset>
			<label><input id="datebook_cookies_see_more" type="checkbox" name="datebook_cookies_options[see_more]" value="1" ' . checked( 'yes', $options['general']['see_more'], false ) . ' /> ' . esc_html__( 'Enable privacy policy link.', 'datebook' ) . '</label>
			<div id="datebook_cookies_see_more_opt"' . ($options['general']['see_more'] === 'no' ? ' style="display: none;"' : '') . '>
				<input type="text" class="regular-text" name="datebook_cookies_options[see_more_opt][text]" value="' . esc_attr( $options['general']['see_more_opt']['text'] ) . '" />
				<p class="description">' . esc_html__( 'The text of the privacy policy button.', 'datebook' ) . '</p>
				<div id="datebook_cookies_see_more_opt_custom_link">';
				
				$links = array(
			'page'	 			=> esc_html__( 'Page link', 'datebook' ),
			'custom' 			=> esc_html__( 'Custom link', 'datebook' )
		);

		foreach ( $links as $value => $label ) {
			$value = esc_attr( $value );

			echo '
					<label><input id="datebook_cookies_see_more_link-' . $value . '" type="radio" name="datebook_cookies_options[see_more_opt][link_type]" value="' . $value . '" ' . checked( $value, $options['general']['see_more_opt']['link_type'], false ) . ' />' . esc_html( $label ) . '</label> ';
		}

		echo '
				</div>
				<p class="description">' . esc_html__( 'Select where to redirect user for more information about cookies.', 'datebook' ) . '</p>
				<div id="datebook_cookies_see_more_opt_page"' . ($options['general']['see_more_opt']['link_type'] === 'custom' ? ' style="display: none;"' : '') . '>
					<select name="datebook_cookies_options[see_more_opt][id]">
						<option value="empty" ' . selected( 'empty', $options['general']['see_more_opt']['id'], false ) . '>' . esc_html__( '- select page -', 'datebook' ) . '</option>';

		if ( $pages ) {
			foreach ( $pages as $page ) {
				echo '
						<option value="' . $page->ID . '" ' . selected( $page->ID, $options['general']['see_more_opt']['id'], false ) . '>' . esc_html( $page->post_title ) . '</option>';
			}
		}

		echo '
					</select>
					<p class="description">' . esc_html__( 'Select from one of your site\'s pages.', 'datebook' ) . '</p>';

		echo '
				</div>
				<div id="datebook_cookies_see_more_opt_link"' . ($options['general']['see_more_opt']['link_type'] === 'page' ? ' style="display: none;"' : '') . '>
					<input type="text" class="regular-text" name="datebook_cookies_options[see_more_opt][link]" value="' . ($options['general']['see_more_opt']['link'] ? esc_attr( $options['general']['see_more_opt']['link'] ) : '') . '" />
					<p class="description">' . esc_html__( 'Enter the full URL to a custom page', 'datebook' ) . '</p>
				</div>
			</div>
		</fieldset</td></tr>';
		
		
		echo '
		<tr><th scope="row">'.esc_html__( 'Link target', 'datebook' ).'</th><td>
		<fieldset>
			<div id="datebook_cookies_link_target">
				<select name="datebook_cookies_options[link_target]">';
				
				$link_target = array(
			'_blank',
			'_self'
		);


		foreach ( $link_target as $target ) {
			echo '
					<option value="' . $target . '" ' . selected( $target, $options['general']['link_target'] ) . '>' . esc_html( $target ) . '</option>';
		}

		echo '
				</select>
				<p class="description">' . esc_html__( 'Select the privacy policy link target.', 'datebook' ) . '</p>
			</div>
		</fieldset></td></tr>';


		echo '
		<tr><th scope="row">'.esc_html__( 'Cookie expiry', 'datebook' ).'</th><td>
		<fieldset>
			<div id="datebook_cookies_time">
				<select name="datebook_cookies_options[time]">';
				
				$times = array(
					'hour'				=> array( esc_html__( '1 hour', 'datebook' ), 3600 ),
					'day'		 		=> array( esc_html__( '1 day', 'datebook' ), 86400 ),
					'week'		 		=> array( esc_html__( '1 week', 'datebook' ), 604800 ),
					'month'		 		=> array( esc_html__( '1 month', 'datebook' ), 2592000 ),
					'3months'	 		=> array( esc_html__( '3 months', 'datebook' ), 7862400 ),
					'6months'	 		=> array( esc_html__( '6 months', 'datebook' ), 15811200 ),
					'year'		 		=> array( esc_html__( '1 year', 'datebook' ), 31536000 ),
					'infinity'	 		=> array( esc_html__( 'Very long time', 'datebook' ), 2147483647 )
				);

				foreach ( $times as $time => $arr ) {
					$time = esc_attr( $time );

					echo '<option value="' . $time . '" ' . selected( $time, $options['general']['time'] ) . '>' . esc_html( $arr[0] ) . '</option>';
				}
				
				echo '</select>
				<p class="description">' . esc_html__( 'The amount of time that cookie should be stored for.', 'datebook' ) . '</p>
			</div>
		</fieldset></td></tr>';

		echo '<tr><th scope="row">'.esc_html__( 'Position', 'datebook' ).'</th><td>
		<fieldset>
			<div id="datebook_cookies_position">';
			
			$positions = array(
			'top'	 			=> esc_html__( 'Top', 'datebook' ),
			'bottom' 			=> esc_html__( 'Bottom', 'datebook' )
		);

		foreach ( $positions as $value => $label ) {
			$value = esc_attr( $value );

			echo '<label><input id="datebook_cookies_position-' . $value . '" type="radio" name="datebook_cookies_options[position]" value="' . $value . '" ' . checked( $value, $options['general']['position'], false ) . ' />' . esc_html( $label ) . '</label> ';
		}

		echo '<p class="description">' . esc_html__( 'Select location for your cookie notice.', 'datebook' ) . '</p>
			</div>
		</fieldset></td></tr>';


		echo '<tr><th scope="row">'.esc_html__( 'Animation', 'datebook' ).'</th><td>
		<fieldset>
			<div id="datebook_cookies_hide_effect">';
			
			$effects = array(
				'none'	 			=> esc_html__( 'None', 'datebook' ),
				'fade'	 			=> esc_html__( 'Fade', 'datebook' ),
				'slide'	 			=> esc_html__( 'Slide', 'datebook' )
			);

			foreach ( $effects as $value => $label ) {
				$value = esc_attr( $value );

				echo '<label><input id="datebook_cookies_hide_effect-' . $value . '" type="radio" name="datebook_cookies_options[hide_effect]" value="' . $value . '" ' . checked( $value, $options['general']['hide_effect'], false ) . ' />' . esc_html( $label ) . '</label> ';
			}

			echo '<p class="description">' . esc_html__( 'Cookie notice acceptance animation.', 'datebook' ) . '</p>
			</div>
		</fieldset></td></tr>';

		echo '<tr><th scope="row">'.esc_html__( 'On scroll', 'datebook' ).'</th><td>
		<fieldset>
			<label><input id="datebook_cookies_on_scroll" type="checkbox" name="datebook_cookies_options[on_scroll]" value="1" ' . checked( 'yes', $options['general']['on_scroll'], false ) . ' />' . esc_html__( 'Enable cookie notice acceptance when users scroll.', 'datebook' ) . '</label>
			<div id="datebook_cookies_on_scroll_offset"' . ( $options['general']['on_scroll'] === 'no' || $options['general']['on_scroll'] == false ? ' style="display: none;"' : '' ) . '>
				<input type="text" class="text" name="datebook_cookies_options[on_scroll_offset]" value="' . esc_attr( $options['general']['on_scroll_offset'] ) . '" /> <span>px</span>
				<p class="description">' . esc_html__( 'Number of pixels user has to scroll to accept the usage of the cookies and make the notification disappear.', 'datebook' ) . '</p>
			</div>
		</fieldset></td></tr>';

		echo '<tr><th scope="row"><h2>'.esc_html__( 'Design', 'datebook' ).'</h2></th><td></td></tr>';

		echo '<tr><th scope="row">'.esc_html__( 'Button size', 'datebook' ).'</th><td>
		<fieldset>
			<div id="datebook_cookies_button_size">';
			
			$styles = array(
				'btn-sm' => esc_html__( 'Small', 'datebook' ),
				'btn-md' => esc_html__( 'Medium', 'datebook' ),
				'btn-lg' => esc_html__( 'Large', 'datebook' )
			);

			foreach ( $styles as $value => $label ) {
				$value = esc_attr( $value );

				echo '<label><input id="datebook_cookies_button_size-' . $value . '" type="radio" name="datebook_cookies_options[button_size]" value="' . $value . '" ' . checked( $value, $options['general']['button_size'], false ) . ' />' . esc_html( $label ) . '</label> ';
			}

			echo '</div></fieldset></td></tr>';


			echo '<tr><th scope="row">'.esc_html__( 'Button position', 'datebook' ).'</th><td>
		<fieldset>
			<div id="datebook_cookies_button_position">';
			
			$button_position = array(
				'bottom' => esc_html__( 'Under the text', 'datebook' ),
				'top' => esc_html__( 'Above the text', 'datebook' ),
				'right' => esc_html__( 'On the right', 'datebook' ),
				'left' => esc_html__( 'On the left', 'datebook' )
			);

			foreach ( $button_position as $value => $label ) {
				$value = esc_attr( $value );

				echo '<label><input id="datebook_cookies_button_position-' . $value . '" type="radio" name="datebook_cookies_options[button_position]" value="' . $value . '" ' . checked( $value, $options['general']['button_position'], false ) . ' />' . esc_html( $label ) . '</label> ';
			}

			echo '</div></fieldset></td></tr>';

			echo '<tr><th scope="row">'.esc_html__( 'Button colors', 'datebook' ).'</th><td>
		<fieldset>';
		
			$button_colors = array(
				'text'	 			=> esc_html__( 'Text color', 'datebook' ),
				'bar'	 			=> esc_html__( 'Background color', 'datebook' ),
			);
		
			foreach ( $button_colors as $value => $label ) {
				$value = esc_attr( $value );

				echo '<div id="datebook_cookies_button_colors-' . $value . '"><label>' . esc_html( $label ) . '</label><br />
				<input class="datebook_cookies_color" type="text" name="datebook_cookies_options[button_colors][' . $value . ']" value="' . esc_attr( $options['general']['button_colors'][$value] ) . '" /></div>';
			}
		
			echo '</fieldset></td></tr>';

			echo '<tr><th scope="row">'.esc_html__( 'Colors', 'datebook' ).'</th><td><fieldset>';
		
			$colors = array(
				'text'	 			=> esc_html__( 'Text color', 'datebook' ),
				'bar'	 			=> esc_html__( 'Bar color', 'datebook' ),
			);
		
			foreach ( $colors as $value => $label ) {
				$value = esc_attr( $value );

				echo '<div id="datebook_cookies_colors-' . $value . '"><label>' . esc_html( $label ) . '</label><br />
				<input class="datebook_cookies_color" type="text" name="datebook_cookies_options[colors][' . $value . ']" value="' . esc_attr( $options['general']['colors'][$value] ) . '" /></div>';
			}
		
			echo '</fieldset></td></tr>';

			echo '</tbody></table>';
		
		
			echo '<p class="submit">';
			submit_button( '', 'primary', 'save_datebook_cookies_options', false );
			echo ' ';
			submit_button( esc_html__( 'Reset to defaults', 'datebook' ), 'secondary', 'reset_datebook_cookies_options', false );
			echo '</p>
			</form>
			</div>
		</div>';
	}




	/**
	 * Load plugin defaults
	 */
	private static function load_defaults() {
		
		$defaults = array(

		'positions' => array(
			'top'	 			=> esc_html__( 'Top', 'datebook' ),
			'bottom' 			=> esc_html__( 'Bottom', 'datebook' )
		),

		'styles' => array(
			'btn-sm' => esc_html__( 'Small', 'datebook' ),
			'btn-md' => esc_html__( 'Medium', 'datebook' ),
			'btn-lg' => esc_html__( 'Large', 'datebook' )
		),
		
		'links' => array(
			'page'	 			=> esc_html__( 'Page link', 'datebook' ),
			'custom' 			=> esc_html__( 'Custom link', 'datebook' )
		),

		'link_target' => array(
			'_blank',
			'_self'
		),

		'colors' => array(
			'text'	 			=> esc_html__( 'Text color', 'datebook' ),
			'bar'	 			=> esc_html__( 'Bar color', 'datebook' ),
		),

		'button_colors' => array(
			'text'	 			=> esc_html__( 'Text color', 'datebook' ),
			'bar'	 			=> esc_html__( 'Background color', 'datebook' ),
		),

		'times' => array(
			'hour'				=> array( esc_html__( 'An hour', 'datebook' ), 3600 ),
			'day'		 		=> array( esc_html__( '1 day', 'datebook' ), 86400 ),
			'week'		 		=> array( esc_html__( '1 week', 'datebook' ), 604800 ),
			'month'		 		=> array( esc_html__( '1 month', 'datebook' ), 2592000 ),
			'3months'	 		=> array( esc_html__( '3 months', 'datebook' ), 7862400 ),
			'6months'	 		=> array( esc_html__( '6 months', 'datebook' ), 15811200 ),
			'year'		 		=> array( esc_html__( '1 year', 'datebook' ), 31536000 ),
			'infinity'	 		=> array( esc_html__( 'infinity', 'datebook' ), 2147483647 )
		),

		'effects' => array(
			'none'	 			=> esc_html__( 'None', 'datebook' ),
			'fade'	 			=> esc_html__( 'Fade', 'datebook' ),
			'slide'	 			=> esc_html__( 'Slide', 'datebook' )
		)
		);
		
		return $defaults;

	}



	/**
	 * Validate options.
	 */
	private static function validate_data( $input ) {
		
		$data = array();

		if(is_array($input)) {
			
			$defaults = self::defaults_settings();
			
			$load_defaults = self::load_defaults();
			
			$input = $input['datebook_cookies_options'];
			

			// position
			$input['position'] = sanitize_text_field( isset( $input['position'] ) && in_array( $input['position'], array_keys( $load_defaults['positions'] ) ) ? $input['position'] : $defaults['general']['position'] );

			// Button colors
			$input['button_colors']['text'] = sanitize_text_field( isset( $input['button_colors']['text'] ) && $input['button_colors']['text'] !== '' && preg_match( '/^#[a-f0-9]{6}$/', $input['button_colors']['text'] ) === 1 ? $input['button_colors']['text'] : $defaults['general']['button_colors']['text'] );
			$input['button_colors']['bar'] = sanitize_text_field( isset( $input['button_colors']['bar'] ) && $input['button_colors']['bar'] !== '' && preg_match( '/^#[a-f0-9]{6}$/', $input['button_colors']['bar'] ) === 1 ? $input['button_colors']['bar'] : $defaults['general']['button_colors']['bar'] );

			// colors
			$input['colors']['text'] = sanitize_text_field( isset( $input['colors']['text'] ) && $input['colors']['text'] !== '' && preg_match( '/^#[a-f0-9]{6}$/', $input['colors']['text'] ) === 1 ? $input['colors']['text'] : $defaults['general']['colors']['text'] );
			$input['colors']['bar'] = sanitize_text_field( isset( $input['colors']['bar'] ) && $input['colors']['bar'] !== '' && preg_match( '/^#[a-f0-9]{6}$/', $input['colors']['bar'] ) === 1 ? $input['colors']['bar'] : $defaults['general']['colors']['bar'] );

			// texts
			$input['message_text'] = wp_kses_post( isset( $input['message_text'] ) && $input['message_text'] !== '' ? $input['message_text'] : $defaults['general']['message_text'] );
			
			$input['accept_text'] = sanitize_text_field( isset( $input['accept_text'] ) && $input['accept_text'] !== '' ? $input['accept_text'] : $defaults['general']['accept_text'] );
			$input['refuse_text'] = sanitize_text_field( isset( $input['refuse_text'] ) && $input['refuse_text'] !== '' ? $input['refuse_text'] : $defaults['general']['refuse_text'] );
			$input['refuse_opt'] = isset( $input['refuse_opt'] ) ? 'yes' : 'no';


			// get allowed HTML
			$allowed_html = self::get_allowed_html();

			// body refuse code
			$input['refuse_code'] = wp_kses( isset( $input['refuse_code'] ) && $input['refuse_code'] !== '' ? $input['refuse_code'] : $defaults['general']['refuse_code'], $allowed_html );

			// head refuse code
			$input['refuse_code_head'] = wp_kses( isset( $input['refuse_code_head'] ) && $input['refuse_code_head'] !== '' ? $input['refuse_code_head'] : $defaults['general']['refuse_code_head'], $allowed_html );

			// css button style
			$input['button_size'] = sanitize_text_field( isset( $input['button_size'] ) && in_array( $input['button_size'], array_keys( $load_defaults['styles'] ) ) ? $input['button_size'] : $defaults['general']['button_size'] );

			// css button class
			$input['button_position'] = sanitize_text_field( isset( $input['button_position'] ) ? $input['button_position'] : $defaults['general']['button_position'] );

			// link target
			$input['link_target'] = sanitize_text_field( isset( $input['link_target'] ) && in_array( $input['link_target'], array_keys( $load_defaults['link_target'] ) ) ? $input['link_target'] : $defaults['general']['link_target'] );

			// time
			$input['time'] = sanitize_text_field( isset( $input['time'] ) && in_array( $input['time'], array_keys( $load_defaults['times'] ) ) ? $input['time'] : $defaults['general']['time'] );

			// hide effect
			$input['hide_effect'] = sanitize_text_field( isset( $input['hide_effect'] ) && in_array( $input['hide_effect'], array_keys( $load_defaults['effects'] ) ) ? $input['hide_effect'] : $defaults['general']['hide_effect'] );
			
			// on scroll
			$input['on_scroll'] = (bool) isset( $input['on_scroll'] ) ? 'yes' : 'no';

			// on scroll
			$input['redirection'] = isset( $input['redirection'] );

			// on scroll offset
			$input['on_scroll_offset'] = absint( isset( $input['on_scroll_offset'] ) && $input['on_scroll_offset'] !== '' ? $input['on_scroll_offset'] : $defaults['general']['on_scroll_offset'] );

			// privacy policy
			$input['see_more'] = (bool) isset( $input['see_more'] ) ? 'yes' : 'no';
			$input['see_more_opt']['text'] = sanitize_text_field( isset( $input['see_more_opt']['text'] ) && $input['see_more_opt']['text'] !== '' ? $input['see_more_opt']['text'] : $defaults['general']['see_more_opt']['text'] );
			$input['see_more_opt']['link_type'] = sanitize_text_field( isset( $input['see_more_opt']['link_type'] ) && in_array( $input['see_more_opt']['link_type'], array_keys( $load_defaults['links'] ) ) ? $input['see_more_opt']['link_type'] : $defaults['general']['see_more_opt']['link_type'] );

			if ( $input['see_more_opt']['link_type'] === 'custom' )
				$input['see_more_opt']['link'] = esc_url( $input['see_more'] === 'yes' ? $input['see_more_opt']['link'] : 'empty' );
			elseif ( $input['see_more_opt']['link_type'] === 'page' ) {
				$input['see_more_opt']['id'] = ( $input['see_more'] === 'yes' ? (int) $input['see_more_opt']['id'] : 'empty' );
				$input['see_more_opt']['sync'] = isset( $input['see_more_opt']['sync'] );

				if ( $input['see_more_opt']['sync'] )
					update_option( 'wp_page_for_privacy_policy', $input['see_more_opt']['id'] );
			}


			$data = $input;

			if (is_array($data)) {

				$data['success'] = true;
				
			} else {

				$data['success'] = false;
				$data['error_message'] = esc_html__( 'Oops! Something went wrong.', 'datebook' );

			}

		} else {

			$data['success'] = false;
			$data['error_message'] = esc_html__( 'Oops! Something went wrong.', 'datebook' );

		}

		return $data;

	}



	/**
	 * Get allowed script blocking HTML.
	 *
	 * @return array
	 */
	public static function get_allowed_html() {
		return apply_filters(
			'datebook_cookies_refuse_code_allowed_html',
			array_merge(
				wp_kses_allowed_html( 'post' ),
				array(
					'script' => array(
						'type' => array(),
						'src' => array(),
						'charset' => array(),
						'async' => array()
					),
					'noscript' => array(),
					'style' => array(
						'type' => array()
					),
					'iframe' => array(
						'src' => array(),
						'height' => array(),
						'width' => array(),
						'frameborder' => array(),
						'allowfullscreen' => array()
					)
				)
			)
		);
	}


}