<?php
/**
 * @package   Options_Framework
 * @author    Devin Price <devin@wptheming.com>
 * @license   GPL-2.0+
 * @link      http://wptheming.com
 * @copyright 2010-2014 WP Theming
 */

class Options_Framework_Interface {

	/**
	 * Generates the tabs that are used in the options menu
	 */
	static function optionsframework_tabs($framework_section) {
		$counter = 0;

		if(isset($framework_section) && $framework_section == 'design') {
			$options = & Options_Framework::_optionsframework_designs();
		} else {
			$options = & Options_Framework::_optionsframework_options();
		}

		$menu = '';
		
		foreach ( $options as $value ) {
			
			$value_type = !empty( $value['type'] ) ? $value['type'] : null;
			
			// Heading for Navigation
			if ( $value_type == 'heading' ) {
				$counter++;
				$class = '';
				$class = ! empty( $value['id'] ) ? $value['id'] : $value['name'];
				$class = preg_replace( '/[^a-zA-Z0-9._\-]/', '', strtolower($class) ) . '-tab';
				$menu .= '<li><a id="options-group-'.  $counter . '-tab" class="nav-tab ' . $class .'" title="' . esc_attr( $value['name'] ) . '" href="' . esc_attr( '#options-group-'.  $counter ) . '">' . esc_html( $value['name'] ) . '</a></li>';
			}
		}

		return $menu;
	}

	/**
	 * Generates the options fields that are used in the form.
	 */
	static function optionsframework_fields($framework_section) {

		global $allowedtags;

		$options_framework = new Options_Framework;
		
		if(isset($framework_section) && $framework_section == 'design') {
			$option_name = $options_framework->get_design_name();
			$options = & Options_Framework::_optionsframework_designs();
		} else {
			$option_name = $options_framework->get_option_name();
			$options = & Options_Framework::_optionsframework_options();
		}

		$settings = get_option( $option_name );
		
		
		$counter = 0;
		$menu = '';

		foreach ( $options as $value ) {

			$val = '';
			$select_value = '';
			$output = '';
			
			// If there is a description save it for labels
			$explain_value = '';
			if ( isset( $value['desc'] ) ) {
				$explain_value = $value['desc'];
			}

			$value_type = !empty( $value['type'] ) ? $value['type'] : null;
			
			// Wrap all options
			if ( ( $value_type != 'heading' ) && ( $value_type != 'info' ) ) {

				// Keep all ids lowercase with no spaces
				$value_id = !empty( $value['id'] ) ? $value['id'] : null;
				$value['id'] = preg_replace('/[^a-zA-Z0-9._\-]/', '', strtolower($value_id) );

				$id = 'section-' . $value['id'];

				$class = 'section';
				if ( isset( $value['type'] ) ) {
					$class .= ' section-' . $value['type'];
					if ( $value['type'] == 'background' ) {
						$class .= ' section-upload';
					}
				}
				if ( isset( $value['class'] ) ) {
					$class .= ' ' . $value['class'];
				}

				if ($value_type == 'container_in') {
					$output .= '<div class="' . esc_attr( $class ) . '" style="width:auto; background-color: #fbfbfb; padding: 20px 30px 0">'."\n";
				} else if (($value_type != 'container_in') && ($value_type != 'container_out')){
					$output .= '<div id="' . esc_attr( $id ) .'" class="' . esc_attr( $class ) . '">'."\n";
				}
					
				if ( isset( $value['name'] )) {
					$output .= '<div class="section_heading">';
					$output .= '<h4 class="heading">' . esc_html( $value['name'] );

					if ( isset( $value['tooltip'] )) {
						$output .= ' <span id="button" class="datebook-screenshot-tooltip tooltip-hover ' . $value['id'] . '" tooltip-id="' . $value['id'] . '" aria-describedby="tooltip">&#8505;</span>';
					}
					
					$output .= '</h4>' . "\n";

					if ( isset( $value['tooltip'] )) {
						$output .= '<div id="tooltip" class="tooltip-window-' . $value['id'] . '" role="tooltip">';
						$output .= '<img src="' . $value['tooltip'] . '" alt="photo">';
						$output .= '<div id="arrow" data-popper-arrow></div>';
						$output .= '</div>';
					}

					$value_class = isset( $value['class'] ) && $value['class'] == 'mini' ? 1 : 0;
				
					if ($value_class == 0 && $explain_value != '' && ( ($value_type != 'checkbox') && ($value_type != 'editor') && ($value_type != 'hr') && ($value_type != 'container_in') && ($value_type != 'container_out') )) {
						$output .= '<div class="explain">' . wp_kses( $explain_value, $allowedtags) . '</div>'."\n";
					}

					$output .= '</div>' . "\n";

				}

				if (($value_type != 'container_in') && ($value_type != 'container_out')){
					if ($value_type != 'hr'){
						$output .= '<div class="option">' . "\n" . '<div class="controls">' . "\n";
					} else {
						$output .= '<div class="option">' . "\n" . '<div>' . "\n";
					}
				}
				
			}

			// Set default value to $val
			if ( isset( $value['std'] ) ) {
				$val = $value['std'];
			}

			// If the option is already saved, override $val
			if ( $value_type != 'heading' && $value_type != 'info' ) {
				if ( isset( $settings[($value['id'])]) ) {
					$val = $settings[($value['id'])];
					// Striping slashes of non-array options
					if ( !is_array($val) ) {
						$val = stripslashes( $val );
					}
				}
			}

			// Set the placeholder if one exists
			$placeholder = '';
			if ( isset( $value['placeholder'] ) ) {
				$placeholder = ' placeholder="' . esc_attr( $value['placeholder'] ) . '"';
			}

			if ( has_filter( 'optionsframework_' . $value_type ) ) {
				$output .= apply_filters( 'optionsframework_' . $value_type, $option_name, $value, $val );
			}


			switch ( $value_type ) {

			// HR line
			case 'hr':
				$output .= '<hr/>';
				break;

			// Basic text input
			case 'text':
				$output .= '<input id="' . esc_attr( $value['id'] ) . '" class="of-input" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" type="text" value="' . esc_attr( $val ) . '"' . $placeholder . ' />';

				if ($value_class == 1 && $explain_value != '') {
					$output .= ' <span class="explain">' . wp_kses( $explain_value, $allowedtags) . '</span>';
				}

				break;

			// Password input
			case 'password':
				$output .= '<input id="' . esc_attr( $value['id'] ) . '" class="of-input" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" type="password" value="' . esc_attr( $val ) . '" />';
				break;

			// Textarea
			case 'textarea':
				$rows = '4';

				if ( isset( $value['settings']['rows'] ) ) {
					$custom_rows = $value['settings']['rows'];
					if ( is_numeric( $custom_rows ) ) {
						$rows = $custom_rows;
					}
				}

				$val = stripslashes( $val );
				$output .= '<textarea id="' . esc_attr( $value['id'] ) . '" class="of-input" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" rows="' . $rows . '"' . $placeholder . '>' . esc_textarea( $val ) . '</textarea>';
				break;

			// Textarea for Emoji
			case 'textarea_emoji':
				$rows = '4';

				if ( isset( $value['settings']['rows'] ) ) {
					$custom_rows = $value['settings']['rows'];
					if ( is_numeric( $custom_rows ) ) {
						$rows = $custom_rows;
					}
				}

				$val = json_decode(base64_decode($val));
				$val = stripslashes($val);
				$output .= '<textarea id="' . esc_attr( $value['id'] ) . '" class="of-input" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" rows="' . $rows . '"' . $placeholder . '>' . esc_textarea( $val ) . '</textarea>';
				break;

			// Textarea
			case 'customcode':
				$rows = '5';

				if ( isset( $value['settings']['rows'] ) ) {
					$custom_rows = $value['settings']['rows'];
					if ( is_numeric( $custom_rows ) ) {
						$rows = $custom_rows;
					}
				}

				$val = stripslashes( $val );
				$output .= '<textarea id="' . esc_attr( $value['id'] ) . '" class="of-input" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" rows="' . $rows . '"' . $placeholder . '>' . esc_textarea( $val ) . '</textarea>';
				break;

			// Select Box
			case 'select':
				$output .= '<select class="of-input" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" id="' . esc_attr( $value['id'] ) . '">';

				foreach ($value['options'] as $key => $option ) {
					$output .= '<option'. selected( $val, $key, false ) .' value="' . esc_attr( $key ) . '">' . esc_html( $option ) . '</option>';
				}
				$output .= '</select>';

				if ($value_class == 1 && $explain_value != '') {
					$output .= ' <span class="explain">' . wp_kses( $explain_value, $allowedtags) . '</span>';
				}

				break;


			// Radio Box
			case 'radio':
				$name = $option_name .'['. $value['id'] .']';
				foreach ($value['options'] as $key => $option) {
					$id = $option_name . '-' . $value['id'] .'-'. $key;
					$output .= '<input class="of-input of-radio" type="radio" name="' . esc_attr( $name ) . '" id="' . esc_attr( $id ) . '" value="'. esc_attr( $key ) . '" '. checked( $val, $key, false) .' /><label for="' . esc_attr( $id ) . '">' . esc_html( $option ) . '</label>';
				}
				break;

			// Image Selectors
			case 'images':
				$name = $option_name .'['. $value['id'] .']';
				foreach ( $value['options'] as $key => $option ) {
					$selected = '';
					if ( $val != '' && ($val == $key) ) {
						$selected = ' of-radio-img-selected';
					}
					$output .= '<input type="radio" id="' . esc_attr( $value['id'] .'_'. $key) . '" class="of-radio-img-radio" value="' . esc_attr( $key ) . '" name="' . esc_attr( $name ) . '" '. checked( $val, $key, false ) .' />';
					$output .= '<div class="of-radio-img-label">' . esc_html( $key ) . '</div>';
					$output .= '<img src="' . esc_url( $option ) . '" alt="' . $option .'" class="of-radio-img-img' . $selected .'" onclick="document.getElementById(\''. esc_attr($value['id'] .'_'. $key) .'\').checked=true;" />';
				}
				break;

			// Checkbox
			case 'checkbox':
				$output .= '<input id="' . esc_attr( $value['id'] ) . '" class="checkbox of-input" type="checkbox" name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" '. checked( $val, 1, false) .' />';
				$output .= '<label class="explain" for="' . esc_attr( $value['id'] ) . '">' . wp_kses( $explain_value, $allowedtags) . '</label>';
				break;

			// Multicheck
			case 'multicheck':

				$count_multicheck = 0;
				foreach ($value['options'] as $key => $option) {
					
					$checked = '';
					$label = $option;
					$option = preg_replace('/[^a-zA-Z0-9._\-]/', '', $key);

					$id = $option_name . '-' . $value['id'] . '-'. $option;
					$name = $option_name . '[' . $value['id'] . '][' . $option .']';

					/*$pluginname = get_option( $option_name );

					if ( $pluginname != '' ) {
						$key = $key;
					} else {
						$key = $count_multicheck;
					}*/

					if ( isset($value['method']) && $value['method'] == 'multinumber' ) {
						if(!is_array($val)){
							$checked = explode(',', $val);
							if(isset($val) && is_array($checked)){
								if(isset($checked[$key]) && !empty($checked[$key])){
									$checked = $checked[$key];
								} else if(in_array($key, $checked)){
									$checked = 1;
								} else {
									$checked = 0;
								}
							} else {
								$checked = 0;
							}
						} else {
							$checked = isset($key) && isset($val[$key]) ? $val[$key] : '';
						}

						$checked = checked($checked, 1, false);
					} else if ( isset($val[$option]) ) {
						$checked = checked($val[$option], 1, false);
					} else {
							$checked = explode(',', $val);
							if(isset($val) && is_array($checked)){
								if(in_array($key, $checked)){
									$checked = 1;
								} else {
									$checked = 0;
								}
							} else {
								$checked = 0;
							}
							$checked = checked($checked, 1, false);
					}


					$output .= '<input id="' . esc_attr( $id ) . '" class="checkbox of-input" type="checkbox" name="' . esc_attr( $name ) . '" ' . $checked . ' /><label for="' . esc_attr( $id ) . '">' . html_entity_decode(esc_html( $label )) . '</label>';
				
				$count_multicheck++;
				}
				break;

			// Color picker
			case 'color':
				$default_color = '';
				if ( isset($value['std']) ) {
					if ( $val !=  $value['std'] )
						$default_color = ' data-default-color="' .$value['std'] . '" ';
				}
				$output .= '<input name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" id="' . esc_attr( $value['id'] ) . '" class="of-color"  type="text" value="' . esc_attr( $val ) . '"' . $default_color .' />';

				break;
				
			// Transparent color
			case 'transparentcolor':
			
				$color_out = $val != '' ? $val : 'rgba(0,0,0,0)';

				$output .= '<div id="datebook-gradient-box-' . $value['id'] . '" class="datebook-transparent-box" data-id="' . $value['id'] . '" style="background-image:' . esc_attr($color_out) . '">';
				$output .= '<ul id="datebook-color-basic-' . $value['id'] . '" class="datebook-color-shared">
					<li id="datebook-color-picker-' . $value['id'] . '" style="background-color:' . esc_attr($color_out) . ';"></li>
				</ul>';
				$output .= '<input name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" id="' . esc_attr( $value['id'] ) . '" class="datebook_theme_options_gradient" data-mode="gradient" type="text" value="' . esc_attr($val) . '" placeholder="select color" />';

				$output .= '</div>';

				break;

			// Gradient Color picker
			case 'gradientcolor':

				if (strpos($val, 'linear-gradient') !== false) {
					$val = $val;
				} else {
					$val = 'linear-gradient(to right, rgba(0, 0, 0, 0) 0%, rgba(0, 0, 0, 0) 100%)';
				}

				$linear_gradient_array = datebook_parse_gradient($val);
				$output .= '<input name="' . esc_attr( $option_name . '[' . $value['id'] . ']' ) . '" id="' . esc_attr( $value['id'] ) . '" class="datebook_theme_options_gradient" data-mode="gradient" type="text" value="' . esc_attr( $val ) . '" />';

				$output .= '<div class="datebook-gradient-bg">';
				$output .= '<div id="datebook-gradient-box-' . $value['id'] . '" class="datebook-gradient-box" data-id="' . $value['id'] . '" style="background-image:' . esc_attr( $val ) . '">';
				$output .= '<div id="datebook-angle-box-' . $value['id'] . '" class="datebook-angle-radio">';
				$datebook_gradient_direction = (isset($linear_gradient_array[3]->angle)) ? $linear_gradient_array[3]->angle : '';
				$datebook_gradient_angle_array = array('&#8599;' => 'to right top', '&#8594;' => 'to right', '&#8600;' => 'to right bottom', '&#8595;' => 'to bottom', '&#8601;' => 'to left bottom', '&#8592;' => 'to left', '&#8598;' => 'to left top', '&#8593;' => 'to top');
				$count_key = 0;
				foreach($datebook_gradient_angle_array as $key => $gradient_angle){
					$count_key++;
					if($datebook_gradient_direction == $gradient_angle){$gradient_orientation = 'checked';}else{$gradient_orientation = '';}
					$output .= '<input type="radio" name="datebook_angle_gradient_[' . $value['id'] . ']" value="' . $gradient_angle . '" id="datebook-radio-' . $count_key . '-' . $value['id'] . '" ' . $gradient_orientation . ' />
				<label class="datebook-gradient-label" for="datebook-radio-' . $count_key . '-' . $value['id'] . '" databook-angle-word="' . $gradient_angle . '" onClick="datebook_angle_buttons()">' . $key . '</label>';
				}

				$output .= '</div>';
				
				$red_0 = (isset($linear_gradient_array[0]->color->red)) ? $linear_gradient_array[0]->color->red : 0;
				$green_0 = (isset($linear_gradient_array[0]->color->green)) ? $linear_gradient_array[0]->color->green : 0;
				$blue_0 = (isset($linear_gradient_array[0]->color->blue)) ? $linear_gradient_array[0]->color->blue : 0;
				$alpha_0 = (isset($linear_gradient_array[0]->color->alpha)) ? $linear_gradient_array[0]->color->alpha : 0;

				$red_1 = (isset($linear_gradient_array[1]->color->red)) ? $linear_gradient_array[1]->color->red : 0;
				$green_1 = (isset($linear_gradient_array[1]->color->green)) ? $linear_gradient_array[1]->color->green : 0;
				$blue_1 = (isset($linear_gradient_array[1]->color->blue)) ? $linear_gradient_array[1]->color->blue : 0;
				$alpha_1 = (isset($linear_gradient_array[1]->color->alpha)) ? $linear_gradient_array[1]->color->alpha : 0;

			
				$output .= '<ul id="datebook-color-shared-' . $value['id'] . '" class="datebook-color-shared">
					<li id="datebook-color-picker-1-' . $value['id'] . '" style="background-color:rgba('.$red_0.', '.$green_0.', '.$blue_0.', '.$alpha_0.');"></li>
					<li id="datebook-color-picker-2-' . $value['id'] . '" style="background-color:rgba('.$red_1.', '.$green_1.', '.$blue_1.', '.$alpha_1.');"></li>
				</ul>';

				$output .= '</div>';
				$output .= '</div>';

				break;

			// Uploader
			case 'upload':
				$output .= Options_Framework_Media_Uploader::optionsframework_uploader( $value['id'], $val, null, $option_name . '[' . $value['id'] . ']', 'single'  );

				break;

			// Uploader
			case 'multiupload':
				$output .= Options_Framework_Media_Uploader::optionsframework_uploader( $value['id'], $val, null, $option_name . '[' . $value['id'] . ']', 'multi'  );

				break;

			// Typography
			case 'typography':

				unset( $font_size, $font_style, $font_face, $font_color );

				$typography_defaults = array(
					'size' => '',
					'measure' => '',
					'face' => '',
					'style' => '',
					'color' => ''
				);

				$typography_stored = wp_parse_args( $val, $typography_defaults );

				$typography_options = array(
					'sizes' => of_recognized_font_sizes(),
					'measurements' => array('rem', 'px', 'em'),
					'faces' => of_recognized_font_faces(),
					'styles' => of_recognized_font_styles(),
					'color' => true
				);

				if ( isset( $value['options'] ) ) {
					$typography_options = wp_parse_args( $value['options'], $typography_options );
				}

				// Font Size
				if ( $typography_options['sizes'] ) {
					$typography_stored_size = preg_replace('/[^0-9\.,]/', '',  $typography_stored['size']  );
					$font_size = '<input name="' . esc_attr( $option_name . '[' . $value['id'] . '][size]' ) . '" id="' . esc_attr( $value['id'] . '_size' ) . '" class="of-typography of-typography-size" type="text" value="' . esc_attr( $typography_stored_size ) . '" />';
					
					

					// Measurement
					$font_size .= '<select class="of-typography of-typography-measure" name="' . esc_attr( $option_name . '[' . $value['id'] . '][measure]' ) . '" id="' . esc_attr( $value['id'] . '_size' ) . '">';
					$measurements = $typography_options['measurements'];
					foreach ( $measurements as $measure ) {
						$font_size .= '<option value="' . 
						esc_attr( $measure ) . '" ' . 
						selected( $typography_stored['measure'], $measure, false ) . '>' . 
						esc_html( $measure ) . '</option>';
					}
					$font_size .= '</select>';
				}

				// Font Face
				if ( $typography_options['faces'] ) {
					$font_face = '<select class="of-typography of-typography-face" name="' . esc_attr( $option_name . '[' . $value['id'] . '][face]' ) . '" id="' . esc_attr( $value['id'] . '_face' ) . '">';
					$faces = $typography_options['faces'];
					foreach ( $faces as $key => $face ) {
						$font_face .= '<option value="' . esc_attr( $key ) . '" ' . selected( $typography_stored['face'], $key, false ) . '>' . esc_html( $face ) . '</option>';
					}
					$font_face .= '</select>';
				}

				// Font Styles
				if ( $typography_options['styles'] ) {
					$font_style = '<select class="of-typography of-typography-style" name="'.$option_name.'['.$value['id'].'][style]" id="'. $value['id'].'_style">';
					$styles = $typography_options['styles'];
					foreach ( $styles as $key => $style ) {
						$font_style .= '<option value="' . esc_attr( $key ) . '" ' . selected( $typography_stored['style'], $key, false ) . '>'. $style .'</option>';
					}
					$font_style .= '</select>';
				}

				// Font Color
				if ( $typography_options['color'] ) {
					$default_color = '';
					if ( isset($value['std']['color']) ) {
						if ( $val !=  $value['std']['color'] )
							$default_color = ' data-default-color="' .$value['std']['color'] . '" ';
					}
					$font_color = '<input name="' . esc_attr( $option_name . '[' . $value['id'] . '][color]' ) . '" id="' . esc_attr( $value['id'] . '_color' ) . '" class="of-color of-typography-color" type="text" value="' . esc_attr( $typography_stored['color'] ) . '"' . $default_color .' />';
				}

				// Allow modification/injection of typography fields
				$typography_fields = compact( 'font_size', 'font_face', 'font_style', 'font_color' );
				$typography_fields = apply_filters( 'of_typography_fields', $typography_fields, $typography_stored, $option_name, $value );
				$output .= implode( '', $typography_fields );

				break;

			// Margin
			case 'margin':

				unset( $margin_top_size, $margin_right_size, $margin_bottom_size, $margin_left_size );

				$margin_defaults = array(
					'margin_top' => '',
					'margin_right' => '',
					'margin_bottom' => '',
					'margin_left' => '',
				);

				$margin_stored = wp_parse_args( $val, $margin_defaults );

				$margin_options = array(
					'margin_top' => of_recognized_margin_sizes(),
					'margin_right' => of_recognized_margin_sizes(),
					'margin_bottom' => of_recognized_margin_sizes(),
					'margin_left' => of_recognized_margin_sizes(),
				);

				if ( isset( $value['options'] ) ) {
					$margin_options = wp_parse_args( $value['options'], $margin_options );
				}
				
				// Margin Top Size
				if ( $margin_options['margin_top'] ) {
					$margin_top_size = '<select class="of-typography of-typography-size" name="' . esc_attr( $option_name . '[' . $value['id'] . '][margin_top]' ) . '" id="' . esc_attr( $value['id'] . '_margin_top' ) . '">';
					$margin_top_size .= '<option value="" ' . selected( $margin_stored['margin_top'], 'default', false ) . '>' . esc_html__( 'Default', 'datebook' ) . '</option>';
					$margin_top_size .= '<option value="auto" ' . selected( $margin_stored['margin_top'], 'auto', false ) . '>' . esc_html__( 'auto', 'datebook' ) . '</option>';
					$margin_top = $margin_options['margin_top'];
					foreach ( $margin_top as $i ) {
						$size = $i . 'px';
						$margin_top_size .= '<option value="' . esc_attr( $size ) . '" ' . selected( $margin_stored['margin_top'], $size, false ) . '>' . esc_html( $size ) . '</option>';
					}
					$margin_top_size .= '</select>';
				}

				// Margin Right Size
				if ( $margin_options['margin_right'] ) {
					$margin_right_size = '<select class="of-typography of-typography-size" name="' . esc_attr( $option_name . '[' . $value['id'] . '][margin_right]' ) . '" id="' . esc_attr( $value['id'] . '_margin_right' ) . '">';
					$margin_right_size .= '<option value="" ' . selected( $margin_stored['margin_right'], 'default', false ) . '>' . esc_html__( 'Default', 'datebook' ) . '</option>';
					$margin_right_size .= '<option value="auto" ' . selected( $margin_stored['margin_right'], 'auto', false ) . '>' . esc_html__( 'auto', 'datebook' ) . '</option>';
					$margin_right = $margin_options['margin_right'];
					foreach ( $margin_right as $i ) {
						$size = $i . 'px';
						$margin_right_size .= '<option value="' . esc_attr( $size ) . '" ' . selected( $margin_stored['margin_right'], $size, false ) . '>' . esc_html( $size ) . '</option>';
					}
					$margin_right_size .= '</select>';
				}

				// Margin Bottom Size
				if ( $margin_options['margin_bottom'] ) {
					$margin_bottom_size = '<select class="of-typography of-typography-size" name="' . esc_attr( $option_name . '[' . $value['id'] . '][margin_bottom]' ) . '" id="' . esc_attr( $value['id'] . '_margin_bottom' ) . '">';
					$margin_bottom_size .= '<option value="" ' . selected( $margin_stored['margin_bottom'], 'default', false ) . '>' . esc_html__( 'Default', 'datebook' ) . '</option>';
					$margin_bottom_size .= '<option value="auto" ' . selected( $margin_stored['margin_bottom'], 'auto', false ) . '>' . esc_html__( 'auto', 'datebook' ) . '</option>';
					$margin_bottom = $margin_options['margin_bottom'];
					foreach ( $margin_bottom as $i ) {
						$size = $i . 'px';
						$margin_bottom_size .= '<option value="' . esc_attr( $size ) . '" ' . selected( $margin_stored['margin_bottom'], $size, false ) . '>' . esc_html( $size ) . '</option>';
					}
					$margin_bottom_size .= '</select>';
				}

				// Margin Left Size
				if ( $margin_options['margin_left'] ) {
					$margin_left_size = '<select class="of-typography of-typography-size" name="' . esc_attr( $option_name . '[' . $value['id'] . '][margin_left]' ) . '" id="' . esc_attr( $value['id'] . '_margin_left' ) . '">';
					$margin_left_size .= '<option value="" ' . selected( $margin_stored['margin_left'], 'default', false ) . '>' . esc_html__( 'Default', 'datebook' ) . '</option>';
					$margin_left_size .= '<option value="auto" ' . selected( $margin_stored['margin_left'], 'auto', false ) . '>' . esc_html__( 'auto', 'datebook' ) . '</option>';
					$margin_left = $margin_options['margin_left'];
					foreach ( $margin_left as $i ) {
						$size = $i . 'px';
						$margin_left_size .= '<option value="' . esc_attr( $size ) . '" ' . selected( $margin_stored['margin_left'], $size, false ) . '>' . esc_html( $size ) . '</option>';
					}
					$margin_left_size .= '</select>';
				}

				// Allow modification/injection of typography fields
				$margin_fields = compact( 'margin_top_size', 'margin_right_size', 'margin_bottom_size', 'margin_left_size' );
				$margin_fields = apply_filters( 'of_margin_fields', $margin_fields, $margin_stored, $option_name, $value );
				$output .= implode( '', $margin_fields );
				
				$output .= '<div class="suboption_text clear">top, right, bottom, left</div>';

				break;

			// Padding
			case 'padding':

				unset( $padding_top_size, $padding_right_size, $padding_bottom_size, $padding_left_size );

				$padding_defaults = array(
					'padding_top' => '',
					'padding_right' => '',
					'padding_bottom' => '',
					'padding_left' => '',
				);

				$padding_stored = wp_parse_args( $val, $padding_defaults );

				$padding_options = array(
					'padding_top' => of_recognized_margin_sizes(),
					'padding_right' => of_recognized_margin_sizes(),
					'padding_bottom' => of_recognized_margin_sizes(),
					'padding_left' => of_recognized_margin_sizes(),
				);

				if ( isset( $value['options'] ) ) {
					$padding_options = wp_parse_args( $value['options'], $padding_options );
				}
				
				// Margin Top Size
				if ( $padding_options['padding_top'] ) {
					$padding_top_size = '<select class="of-typography of-typography-size" name="' . esc_attr( $option_name . '[' . $value['id'] . '][padding_top]' ) . '" id="' . esc_attr( $value['id'] . '_padding_top' ) . '">';
					$padding_top_size .= '<option value="" ' . selected( $padding_stored['padding_top'], 'default', false ) . '>' . esc_html__( 'Default', 'datebook' ) . '</option>';
					$padding_top_size .= '<option value="auto" ' . selected( $padding_stored['padding_top'], 'auto', false ) . '>' . esc_html__( 'auto', 'datebook' ) . '</option>';
					$padding_top = $padding_options['padding_top'];
					foreach ( $padding_top as $i ) {
						$size = $i . 'px';
						$padding_top_size .= '<option value="' . esc_attr( $size ) . '" ' . selected( $padding_stored['padding_top'], $size, false ) . '>' . esc_html( $size ) . '</option>';
					}
					$padding_top_size .= '</select>';
				}

				// Margin Right Size
				if ( $padding_options['padding_right'] ) {
					$padding_right_size = '<select class="of-typography of-typography-size" name="' . esc_attr( $option_name . '[' . $value['id'] . '][padding_right]' ) . '" id="' . esc_attr( $value['id'] . '_padding_right' ) . '">';
					$padding_right_size .= '<option value="" ' . selected( $padding_stored['padding_right'], 'default', false ) . '>' . esc_html__( 'Default', 'datebook' ) . '</option>';
					$padding_right_size .= '<option value="auto" ' . selected( $padding_stored['padding_right'], 'auto', false ) . '>' . esc_html__( 'auto', 'datebook' ) . '</option>';
					$padding_right = $padding_options['padding_right'];
					foreach ( $padding_right as $i ) {
						$size = $i . 'px';
						$padding_right_size .= '<option value="' . esc_attr( $size ) . '" ' . selected( $padding_stored['padding_right'], $size, false ) . '>' . esc_html( $size ) . '</option>';
					}
					$padding_right_size .= '</select>';
				}

				// Margin Bottom Size
				if ( $padding_options['padding_bottom'] ) {
					$padding_bottom_size = '<select class="of-typography of-typography-size" name="' . esc_attr( $option_name . '[' . $value['id'] . '][padding_bottom]' ) . '" id="' . esc_attr( $value['id'] . '_padding_bottom' ) . '">';
					$padding_bottom_size .= '<option value="" ' . selected( $padding_stored['padding_bottom'], 'default', false ) . '>' . esc_html__( 'Default', 'datebook' ) . '</option>';
					$padding_bottom_size .= '<option value="auto" ' . selected( $padding_stored['padding_bottom'], 'auto', false ) . '>' . esc_html__( 'auto', 'datebook' ) . '</option>';
					$padding_bottom = $padding_options['padding_bottom'];
					foreach ( $padding_bottom as $i ) {
						$size = $i . 'px';
						$padding_bottom_size .= '<option value="' . esc_attr( $size ) . '" ' . selected( $padding_stored['padding_bottom'], $size, false ) . '>' . esc_html( $size ) . '</option>';
					}
					$padding_bottom_size .= '</select>';
				}

				// Margin Left Size
				if ( $padding_options['padding_left'] ) {
					$padding_left_size = '<select class="of-typography of-typography-size" name="' . esc_attr( $option_name . '[' . $value['id'] . '][padding_left]' ) . '" id="' . esc_attr( $value['id'] . '_padding_left' ) . '">';
					$padding_left_size .= '<option value="" ' . selected( $padding_stored['padding_left'], 'default', false ) . '>' . esc_html__( 'Default', 'datebook' ) . '</option>';
					$padding_left_size .= '<option value="auto" ' . selected( $padding_stored['padding_left'], 'auto', false ) . '>' . esc_html__( 'auto', 'datebook' ) . '</option>';
					$padding_left = $padding_options['padding_left'];
					foreach ( $padding_left as $i ) {
						$size = $i . 'px';
						$padding_left_size .= '<option value="' . esc_attr( $size ) . '" ' . selected( $padding_stored['padding_left'], $size, false ) . '>' . esc_html( $size ) . '</option>';
					}
					$padding_left_size .= '</select>';
				}

				// Allow modification/injection of typography fields
				$padding_fields = compact( 'padding_top_size', 'padding_right_size', 'padding_bottom_size', 'padding_left_size' );
				$padding_fields = apply_filters( 'of_padding_fields', $padding_fields, $padding_stored, $option_name, $value );
				$output .= implode( '', $padding_fields );
				
				$output .= '<div class="suboption_text clear">top, right, bottom, left</div>';

				break;

			// Background
			case 'background':

				$background = $val;

				// Background Color
				$default_color = '';
				if ( isset( $value['std']['color'] ) ) {
					if ( $val !=  $value['std']['color'] )
						$default_color = ' data-default-color="' .$value['std']['color'] . '" ';
				}
				$output .= '<input name="' . esc_attr( $option_name . '[' . $value['id'] . '][color]' ) . '" id="' . esc_attr( $value['id'] . '_color' ) . '" class="of-color of-background-color"  type="text" value="' . esc_attr( $background['color'] ) . '"' . $default_color .' />';

				// Background Image
				if ( !isset($background['image']) ) {
					$background['image'] = '';
				}

				$output .= Options_Framework_Media_Uploader::optionsframework_uploader( $value['id'], $background['image'], null, esc_attr( $option_name . '[' . $value['id'] . '][image]' ) );

				$class = 'of-background-properties';
				if ( '' == $background['image'] ) {
					$class .= ' hide';
				}
				$output .= '<div class="' . esc_attr( $class ) . '">';

				// Background Repeat
				$output .= '<select class="of-background of-background-repeat" name="' . esc_attr( $option_name . '[' . $value['id'] . '][repeat]'  ) . '" id="' . esc_attr( $value['id'] . '_repeat' ) . '">';
				$repeats = of_recognized_background_repeat();

				foreach ($repeats as $key => $repeat) {
					$output .= '<option value="' . esc_attr( $key ) . '" ' . selected( $background['repeat'], $key, false ) . '>'. esc_html( $repeat ) . '</option>';
				}
				$output .= '</select>';

				// Background Position
				$output .= '<select class="of-background of-background-position" name="' . esc_attr( $option_name . '[' . $value['id'] . '][position]' ) . '" id="' . esc_attr( $value['id'] . '_position' ) . '">';
				$positions = of_recognized_background_position();

				foreach ($positions as $key=>$position) {
					$output .= '<option value="' . esc_attr( $key ) . '" ' . selected( $background['position'], $key, false ) . '>'. esc_html( $position ) . '</option>';
				}
				$output .= '</select>';

				// Background Attachment
				$output .= '<select class="of-background of-background-attachment" name="' . esc_attr( $option_name . '[' . $value['id'] . '][attachment]' ) . '" id="' . esc_attr( $value['id'] . '_attachment' ) . '">';
				$attachments = of_recognized_background_attachment();

				foreach ($attachments as $key => $attachment) {
					$output .= '<option value="' . esc_attr( $key ) . '" ' . selected( $background['attachment'], $key, false ) . '>' . esc_html( $attachment ) . '</option>';
				}
				$output .= '</select>';
				$output .= '</div>';

				break;

			// Editor
			case 'editor':
				
				$textarea_name = esc_attr( $option_name . '[' . $value['id'] . ']' );
				$default_editor_settings = array(
					'textarea_name' => $textarea_name,
					'media_buttons' => false,
					'tinymce' => array( 'plugins' => 'wordpress,wplink' )
				);
				$editor_settings = array();
				if ( isset( $value['settings'] ) ) {
					$editor_settings = $value['settings'];
				}
				$editor_settings = array_merge( $default_editor_settings, $editor_settings );

				echo '<h4 class="heading">' . wp_kses($output, $allowedtags) . '</h4>' . "\n";
				echo '<div class="explain">' . wp_kses( $explain_value, $allowedtags ) . '</div>'."\n";
				wp_editor( $val, $value['id'], $editor_settings );
				//$output .= '';
				break;

			// Info
			case 'info':
				$id = '';
				$class = 'section';
				if ( isset( $value['id'] ) ) {
					$id = 'id="' . esc_attr( $value['id'] ) . '" ';
				}
				if ( isset( $value['type'] ) ) {
					$class .= ' section-' . $value['type'];
				}
				if ( isset( $value['class'] ) ) {
					$class .= ' ' . $value['class'];
				}

				$output .= '<div ' . $id . 'class="' . esc_attr( $class ) . '">' . "\n";
				if ( isset($value['name']) ) {
					$output .= '<h3 class="heading">' . esc_html( $value['name'] ) . '</h3>' . "\n";
				}
				if ( isset( $value['desc'] ) ) {
					$output .= $value['desc'] . "\n";
				}
				$output .= '</div>' . "\n";
				break;

			// Heading for Navigation
			case 'heading':
				$counter++;
				if ( $counter >= 2 ) {
					$output .= '</div>'."\n";
				}
				$class = '';
				$class = ! empty( $value['id'] ) ? $value['id'] : $value['name'];
				$class = preg_replace('/[^a-zA-Z0-9._\-]/', '', strtolower($class) );
				$output .= '<div id="options-group-' . $counter . '" class="group ' . $class . '">';
				$output .= '<h2>' . esc_html( $value['name'] ) . '</h2>' . "\n";
				break;
			}

			if (($value_type != 'container_in') && ($value_type != 'container_out')){
				if ( ($value_type != 'heading') && ($value_type != 'info') ) {
					$output .= '</div>';
					/*if ( ( $value_type != "checkbox" ) && ( $value_type != "editor" ) && ( $value_type != "hr" ) ) {
						$output .= '<div class="explain">' . wp_kses( $explain_value, $allowedtags) . '</div>'."\n";
					}*/
					$output .= '</div></div>'."\n";
				}
			}

			if ($value_type == 'container_out') {
				$output .= '</div>';
			}

			if($value_type != 'editor'){
				echo $output;
			}

		}

		// Outputs closing div if there tabs
		if ( Options_Framework_Interface::optionsframework_tabs($framework_section) != '' ) {
			echo '</div>';
		}
	}


}