<?php
/**
 * DateBook Mtching
 * Connection all fields to make matching functions
 *
 * @class DateBook_Matching_Options
 * @author Pagick Themes
 * @since 4.5.9
 */

class DateBook_Matching_Options {


	/**
	 * Simple function that validates data and retrieve bool on success
	 * and error message(s) on error
	 *
	 * @param $item
	 * @return bool|string
	 */
	static function datebook_validate($item) {

		$data = array();
		$messages = array();

		if(is_array($item)) {
			
			$data['form_fields'] = $item;

			if (is_array($data)) {

				$data['success'] = true;
				
			} else {

				$data['success'] = false;
				$data['error_message'] = esc_html__( 'Oops! Something went wrong.', 'datebook' );

			}

		} else {

			$data['success'] = false;
			$data['error_message'] = esc_html__( 'Oops! Something went wrong.', 'datebook' );

		}

		return $data;

	}


	/**
	 * The user interface
	 *
	 * @access public
	 */
	public static function datebook_interface() {
		
		global $wp_locale_all, $datebook_reserved_fields;

		?>

		<div id="message" class="updated fade" style="display:none"></div>
		
		<div class="wrap">

			<h1><?php echo esc_html__('Match Making Tool', 'datebook'); ?></h1>
			
			<p><?php echo esc_html__('You can match all profile fields', 'datebook'); ?>.</p>
			
			<hr class="wp-header-end">

            <div class="welcome-panel datebook-dummy-notify-box">
				<div class="welcome-panel-content">

					<h2><?php echo esc_html__('Profile Fields', 'datebook'); ?></h2>

					<?php
					
					// If the button was clicked
					$message = '';
					$notice = '';

					// here we are verifying does this request is post back and have correct nonce
					if (isset($_POST['datebook_matching_options']) && wp_verify_nonce($_POST['nonce'], basename(__FILE__))) {

						// validate data, and if all ok save item to database
						// if id is zero insert otherwise update
						$item_data = self::datebook_validate($_POST);

						if ($item_data['success'] === true) {

							$matching_options = get_option('datebook_matching');

							$item = $item_data['form_fields'];
							
							//Update entire array
							$matching_options['datebook_matching_connected'] = $item;

							$result = update_option( 'datebook_matching', $matching_options );

							if( $result === FALSE){
								$notice = esc_html__('Data has NOT been saved. Perhaps, you did not change the fields.', 'datebook');
							} else {
								$message = esc_html__('Fields have been saved successfully', 'datebook');
							}

						} else {

							// if $item_data not true it contains error message(s)
							$notice = $item_data['error_message'];

						}
			
					} else {

						// if this is not post back we load item to edit or give new one to create
						$item = array();

						//Get entire array
						$item = get_option('datebook_matching');
						$item = isset($item['datebook_matching_connected']) ? $item['datebook_matching_connected'] : '';
						
						if (!$item) {

							$notice = esc_html__('Matching fields have not been saved yet. The Matching functionality is not available yet.', 'datebook');

						}
					
					}

					if (!empty($notice)):

					?>

					<div id="notice" class="datebook-error" style="margin: 15px 0;box-shadow: 0 1px 1px rgba(0,0,0,.04); padding: 1px 12px; border: 2px solid #fb0707">
						<p><?php echo esc_attr($notice); ?></p>
					</div>

				<?php

				endif;


				if (!empty($message)):

				?>

					<div id="message" class="datebook-updated" style="margin: 15px 0;box-shadow: 0 1px 1px rgba(0,0,0,.04); padding: 1px 12px; border: 2px solid #46b450">
						<p><?php echo esc_attr($message) ?></p>
					</div>

				<?php

				endif;


				// get languages
				$languages_array = array();

				$languages_array['en_US'] = esc_html__( 'English', 'datebook' );

				$languages = DateBook_Localization::datebook_all_available_language_files();

				foreach($languages as $language) {
					if($language['checked'] == 1){
						$languages_array[$language['locale']] = $wp_locale_all[$language['locale']];
					}
				}

				
				// Get custom fields
				$all_custom_fields = get_option('datebook_profile_custom_fields') ? get_option('datebook_profile_custom_fields') : array();

				// Get taxonomy
				$datebook_profiletypes = array();
				$profiletypes_array = get_terms(array('orderby' => 'term_id', 'order' => 'ASC','taxonomy' => DATEBOOK_PROFILES_TAX, 'hide_empty' => false));
				foreach ($profiletypes_array as $key => $value ){
					$datebook_profiletypes[] = isset($value->name) ? $value->name : '';
				}
				$profiletypes = implode("\r\n", $datebook_profiletypes);

				foreach ($all_custom_fields as $key => $value) {
					if(isset($datebook_reserved_fields[$key])){
						$datebook_reserved_fields[$key] = array(
							'slug' => $key, 
							'type' => $datebook_reserved_fields[$key]['type'], 
							'searchable' => isset($value['searchable']) && $value['searchable'] > 0 ? 1 : 0, 
							'required' => isset($value['required']) && $value['required'] > 0 ? 1 : 0, 
							'active' => isset($value['active']) && $value['active'] > 0 ? 1 : 0, 
							'limittext' => $value['limittext']
						);

						foreach ( $languages_array as $language_key => $language_name ) {

							if (isset($value['name_' . $language_key])) {
								$datebook_reserved_fields[$key]['name_' . $language_key] =  $value['name_' . $language_key];
							}
							if (isset($value['field_items_' . $language_key])) {
								if($key == 'profiletypereserved'){
									$datebook_reserved_fields[$key]['field_items_' . $language_key] =  $profiletypes;
								} else {
									$datebook_reserved_fields[$key]['field_items_' . $language_key] =  $value['field_items_' . $language_key];
								}
							}
						}
					}
				}

				// Merge custom and reserved fields
				$get_profile_custom_fields = array_merge($all_custom_fields, $datebook_reserved_fields);

				if($get_profile_custom_fields){

					?>

					<p><?php echo esc_html__('The fields in the left column are the main fields. They match (search for) fields in the right column.', 'datebook'); ?></p>
					<p><?php echo esc_html__('For example', 'datebook'); ?>: <?php echo esc_html__('The field in the left column "I am looking for" has options "Woman", "Man". Then you should select the Gender field in the right column. Because, the field on the left searches for profiles who are Woman or Man.', 'datebook'); ?></p>
					<p><?php echo esc_html__('One more example', 'datebook'); ?>: <?php echo esc_html__('You have a field in the left column "I want to invest" that has options "10 000", "100 000". Then you should select the field "I am looking for an investor" in the right column. Because, the field on the left searches for profiles who are investors.', 'datebook'); ?></p>
					<p><?php echo esc_html__('Wrong', 'datebook'); ?>: <?php echo esc_html__('The field "Gender" in the left column must not match the field "Gender" in the right column. Otherwise, a woman profile will always seach for (try to match) women profiles only.', 'datebook'); ?></p>

					<form method="post" action="">

						<?php wp_nonce_field('datebook_matching_options'); ?>

						<input type="hidden" name="nonce" value="<?php echo wp_create_nonce(basename(__FILE__))?>"/>

						<input type="hidden" name="datebook_matching_options" value="1" />

						<table class="widefat striped" width="100%" cellpadding="20" cellspacing="4">
							<thead>
								<tr>
									<th><?php echo esc_html__( 'This field should look for a field in the right column', 'datebook' ); ?> </th>
									<th><?php echo esc_html__( 'This field will be searched by the field on the left, or leave it blank to not search', 'datebook' ); ?> </th>
								</tr>
							</thead>

							<tbody>

							<?php

							foreach ($get_profile_custom_fields as $key => $value) {

								//if (isset($value['active']) && $value['active'] != 1) continue;
								if (isset($value['type']) && $value['type'] == 'title') continue;
								
								// if foreign language do not exist, then show title in English
								$value['name'] = isset($value['name_' . DATEBOOK_WPLANG]) && !empty($value['name_' . DATEBOOK_WPLANG]) ? $value['name_' . DATEBOOK_WPLANG] : $value['name_en_US'];

								echo '<tr>';

								//echo '<td>' . esc_attr($value_title) . '</td>';

								echo '<td>';

								$from = 'from';
								
								echo '<input name="datebook_matching_field_connecting[' . $from . '][' . esc_attr($key) . ']" type="hidden" value="1" />';

								echo '<label>' . esc_attr($value['name']) . '</label> ';
								
								//echo '<select name="datebook_matching_field_connecting[' . $from . '][' . esc_attr($key) . ']">';
								
								// Render field
								// if foreign language do not exist, then show title in English
								/*$value['field_items'] = isset($value['field_items_' . DATEBOOK_WPLANG]) ? $value['field_items_' . DATEBOOK_WPLANG] : $value['field_items_en_US'];
								
								if(!empty($value['field_items'])){
									$value['field_items'] = explode('<br />', strtr($value['field_items'], array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

									echo '<select name="">';

									foreach ($value['field_items'] as $key => $val) {

										echo '<option value="' . esc_attr($key) . '">' . ucfirst(esc_attr($val)) . '</option>';

									}

									echo '</select>';
									
								}*/

								echo '</td>';

								echo '<td>';

								$to = 'to';

								echo '<select name="datebook_matching_field_connecting[' . $to . '][' . esc_attr($key) . ']">';

								echo '<option value="">' . esc_html__( 'Select', 'datebook' ) . '</option>';

								foreach ($get_profile_custom_fields as $subkey => $subvalue) {

									//if (isset($subvalue['active']) && $subvalue['active'] != 1) continue;
									if (isset($subvalue['type']) && $subvalue['type'] == 'title') continue;
									
									$selected = isset($item['datebook_matching_field_connecting']['to'][$key]) && $item['datebook_matching_field_connecting']['to'][$key] == $subkey ? ' selected' : '';
								
									// if foreign language do not exist, then show title in English
									$subvalue['name'] = isset($subvalue['name_' . DATEBOOK_WPLANG]) && !empty($subvalue['name_' . DATEBOOK_WPLANG]) ? $subvalue['name_' . DATEBOOK_WPLANG] : $subvalue['name_en_US'];

									echo '<option value="' . esc_attr($subkey) . '"' . esc_attr($selected) . '>' . esc_attr($subvalue['name']) . '</option>';
								
								}

								echo '</select>';

								echo '</td>';

								echo '</tr>';

							}

							?>

							</tbody>
						</table>

						<p><input id="datebook" type="submit" class="button button-primary button-hero hide-if-no-js" value="<?php echo esc_html__( 'Save', 'datebook' ); ?>" /></p>

					</form>

				<?php } ?>

				</div>
			</div>
		</div>

	<?php

	}

}