<?php
/**
 * Create Notifications
 *
 * @class Options_Framework_Notifications
 * @author Pagick Themes
 * @since 3.3
 */


class Options_Framework_Notifications {

    /*
     * Constructor function
     *
     */
    public function __construct() {

		add_action( 'add_meta_boxes', array( __CLASS__, 'datebook_notice_create_meta_boxes' ));

		add_filter( 'views_edit-datebook_notice', array( __CLASS__,'add_all_buttons_to_views' ));
		add_filter( 'views_edit-datebook_animations', array( __CLASS__,'add_all_buttons_to_views' ));
		add_filter( 'views_edit-datebook_animouts', array( __CLASS__,'add_all_buttons_to_views' ));
		add_filter( 'views_edit-datebook_designs', array( __CLASS__,'add_all_buttons_to_views' ));
		add_filter( 'views_edit-datebook_locations', array( __CLASS__,'add_all_buttons_to_views' ));

    }

	public static function add_all_buttons_to_views( $views ){

		$views['datebook_notice'] = '<a style="color:green" href="edit.php?post_type=datebook_notice" title="' . esc_html__( 'Notifications', 'datebook' ) . '">' . esc_html__( 'Notifications', 'datebook' ) . '</a>';
		$views['datebook_animations'] = '<a style="color:green" href="edit.php?post_type=datebook_animations" title="' . esc_html__( 'Animations In', 'datebook' ) . '">' . esc_html__( 'Animations In', 'datebook' ) . '</a>';
		$views['datebook_animouts'] = '<a style="color:green" href="edit.php?post_type=datebook_animouts" title="' . esc_html__( 'Animations Out', 'datebook' ) . '">' . esc_html__( 'Animations Out', 'datebook' ) . '</a>';
		$views['datebook_designs'] = '<a style="color:green" href="edit.php?post_type=datebook_designs" title="' . esc_html__( 'Designs', 'datebook' ) . '">' . esc_html__( 'Designs', 'datebook' ) . '</a>';
		$views['datebook_locations'] = '<a style="color:green" href="edit.php?post_type=datebook_locations" title="' . esc_html__( 'Locations', 'datebook' ) . '">' . esc_html__( 'Locations', 'datebook' ) . '</a>';

		return $views;

	}
	


	public static function datebook_notice_item_meta_box() {

		global $wpdb;

		$table_name = strtolower($wpdb->prefix) . 'datebook_notifications';
		$check_notifications = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_name));

		if($check_notifications == $table_name) {

			$post = get_post();

			$notification_box = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table_name WHERE post_ID = %d", $post->ID) );

			if ($notification_box == null) {

				$datebook_notice_exists = false;

			} else {

				$datebook_notice_exists = true;

			}

			$post_id = false;
			$display_in_value = false;

			if ($notification_box == true) {

				$post_id = $notification_box->post_ID;
				$display_in_value = $notification_box->display_in;

			}

 ?>

<form id="formdatebook-notice" method="POST">
	<input type="hidden" name="prevent_delete_meta_movetotrash" id="prevent-delete-meta-movetotrash" value="<?php echo wp_create_nonce(DATEBOOK_URL.$post->ID); ?>" />
	<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
		<tbody>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="menu_icon">
						<?php echo esc_html__('On / Off', 'datebook')?>
					</label>
				</th>
				<td>
					<?php
				
				if ( $datebook_notice_exists ) {
					
					$enabled_value = $notification_box->enabled;
					$check_enabled_value  = strpos($enabled_value, 'enabled');

					if ($check_enabled_value !== false) {

				?>
					<input name="enabled" id="enabled" type="checkbox" value="enabled" checked>
					<label for="enabled">
						<?php echo esc_html__('Enabled', 'datebook')?>
					</label>
					<?php } else { ?>
					<input name="enabled" id="enabled" type="checkbox" value="enabled">
					<label for="enabled">
						<?php echo esc_html__('Enabled', 'datebook')?>
					</label>
					<?php } ?>
					<?php } else { ?>
					<input name="enabled" id="enabled" type="checkbox" value="enabled" checked>
					<label for="enabled">
						<?php echo esc_html__('Enabled', 'datebook')?>
					</label>
					<?php } ?>
					<p> <?php echo esc_html__('If the check box is enabled the message will be active by your chosen settings', 'datebook')?> </p>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="menu_icon">
						<?php echo esc_html__('Only for logged users', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="user_types">
						<?php
							$user_types_value = (isset($notification_box->user_types)) ? $notification_box->user_types : null;
							$user_types_values = array(
								'All users' => 'all-users',
								'Only logged users' => 'only-logged-users',
								'Only guests' => 'only-guests',
							);
							foreach($user_types_values as $key => $value) 								{
								if ( $value == $user_types_value ) {
									?>
						<option selected value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
								} else {
									?>
						<option value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
								}
							}
							?>
					</select>
					<p> <?php echo esc_html__('If the check box is checked, the message will be appear for only logged users', 'datebook')?> </p>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="devices">
						<?php echo esc_html__('Devices', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="devices">
						<?php
									if (isset($notification_box->device_class)) {
										$device_class = $notification_box->device_class;
									} else {
										$device_class = '';
									}
									$devices_values = array(
										'All devices' => 'all-devices',
										'Only Desktop & Wide screen' => 'datebook-notice-desktop-widescreen',
										'Only Desktop & Tablet' => 'datebook-notice-desktop-tablet',
										'Only Tablet & Mobile' => 'datebook-notice-tablet-mobile',
										'Only Tablet' => 'datebook-notice-tablet',
										'Only Mobile' => 'datebook-notice-mobile',
									);

									foreach($devices_values as $key => $value)
									{
										if ( $value == $device_class ) {
											?>
						<option selected value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
										} else {
											?>
						<option value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
										}
									}
								?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="location">
						<?php echo esc_html__('Location', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="location">
						<?php
									if (isset($notification_box->location_id)) {
										$location_id = $notification_box->location_id;
									} else {
										$location_id = '';
									}
									$location_values = array(
										'Default' => 'default',
									);

									$datebook_locations = get_posts(array(
										'posts_per_page'=> -1,
										'post_type' => 'datebook_locations',
									));

									foreach ( $datebook_locations as $location ) {
										$location_values[get_the_title( $location->ID )] = $location->ID;
									}

									foreach($location_values as $key => $value)
									{
										if ( $value == $location_id ) {
											?>
						<option selected value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
										} else {
											?>
						<option value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
										}
									}
								?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="design">
						<?php echo esc_html__('Design', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="design">
						<?php
									if (isset($notification_box->design_id)) {
										$design_id = $notification_box->design_id;
									} else {
										$design_id = '';
									}
									$design_values = array(
										'success' => 'success',
										'info' => 'info',
										'warning' => 'warning',
										'danger' => 'danger',
									);

									$datebook_designs = get_posts(array(
										'posts_per_page'=> -1,
										'post_type' => 'datebook_designs',
									));

									foreach ( $datebook_designs as $design ) {
										$design_values[get_the_title( $design->ID )] = $design->ID;
									}

									foreach($design_values as $key => $value)
									{
										if( $value == $design_id ) {
											?>
						<option selected value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
										} else {
											?>
						<option value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
										}
									}
								?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="animation">
						<?php echo esc_html__('Animation In', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="animation">
						<?php
									if (isset($notification_box->animation_id)) {
										$animation_id = $notification_box->animation_id;
									} else {
										$animation_id = '';
									}
									$animation_values = array(
										'default' => 'Default',
									);

									$datebook_animations = get_posts(array(
										'posts_per_page'=> -1,
										'post_type' => 'datebook_animations',
									));

									foreach ( $datebook_animations as $animation ) {
										$animation_values[$animation->ID] = get_the_title( $animation->ID );
									}

									foreach($animation_values as $key => $value)
									{
										if( $key == $animation_id ) {
											?>
						<option selected value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
						<?php
										} else {
											?>
						<option value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
						<?php
										}
									}
								?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="animation_out">
						<?php echo esc_html__('Animation Out', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="animation_out">
						<?php
									if (isset($notification_box->animation_out_id)) {
										$animation_out_id = $notification_box->animation_out_id;
									} else {
										$animation_out_id = '';
									}
									$animation_out_values = array(
										'default' => 'Default',
									);

									$datebook_notice_out_animations = get_posts(array(
										'posts_per_page'=> -1,
										'post_type' => 'datebook_animouts',
									));

									foreach ( $datebook_notice_out_animations as $animation_out ) {
										$animation_out_values[$animation_out->ID] = get_the_title( $animation_out->ID );
									}

									foreach($animation_out_values as $key => $value)
									{
										if( $key == $animation_out_id ) {
											?>
						<option selected value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
						<?php
										} else {
											?>
						<option value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
						<?php
										}
									}
								?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="delay">
						<?php echo esc_html__('Delay', 'datebook')?>
					</label>
				</th>
				<td>
					<?php
						if ( $datebook_notice_exists ) {
							$delay_value = $notification_box->delay;
							?>
					<input class="datebook-post-option-side-value" name="delay" type="number" step="any"  value="<?php echo esc_attr($delay_value); ?>">
					<?php
						} else {
							?>
					<input class="datebook-post-option-side-value" name="delay" type="number" step="any" value="2">
					<?php
						} ?>
					<p> <?php echo esc_html__('The time it takes the notice to appear in milliseconds', 'datebook')?> </p>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="show_time">
						<?php echo esc_html__('Show Time', 'datebook')?>
					</label>
				</th>
				<td>
					<?php
						if ( $datebook_notice_exists ) {
							$show_time_value = $notification_box->show_time;
							?>
					<input class="datebook-post-option-side-value" name="show_time" type="number" value="<?php echo esc_attr($show_time_value); ?>" min="0" >
					<?php
						} else {
							?>
					<input class="datebook-post-option-side-value" name="show_time" type="number" value="8" min="0" >
					<?php
						} ?>
					<p> <?php echo esc_html__('The duration of the notice will appear in seconds', 'datebook')?> </p>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="display_in">
						<?php echo esc_html__('Published in', 'datebook')?>
					</label>
				</th>
				<td>
					<p> <?php echo esc_html__('Choose where you want to display the notification', 'datebook')?> </p>
					<?php

					$post_types = get_post_types( array( 'public' => true ) );

					// print_r($post_types);
					foreach ( $post_types as $post_type => $post_type_name ) {
						$check_post_type = strpos($display_in_value, $post_type);
						if ($check_post_type !== false) {
							?>
					<input name="<?php echo esc_attr( $post_type ); ?>" type="checkbox" id="datebook-notice-<?php echo esc_attr( $post_type ); ?>" value="<?php echo esc_attr( $post_type ); ?>" checked>
					<label for="post_types_<?php echo esc_attr( $post_type ); ?>">
						<?php echo esc_html( ucfirst( $post_type_name ) ); ?>
					</label>
					<br>
					<?php
						} else {
							?>
					<input name="<?php echo esc_attr( $post_type ); ?>" type="checkbox" id="datebook-notice-<?php echo esc_attr( $post_type ); ?>" value="<?php echo esc_attr( $post_type ); ?>">
					<label for="post_types_<?php echo esc_attr( $post_type ); ?>">
						<?php echo esc_html( ucfirst( $post_type_name ) ); ?>
					</label>
					<br>
					<?php
						}
					}
				?>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="close_button">
						<?php echo esc_html__('Close Button', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="click_on_close_button_datebook_notice_option" data-hide-close-options>
						<?php
								$click_on_close_button = get_post_meta( $post->ID, "click_on_close_button_datebook_notice_option", true );
								$click_on_close_button_values = array(
									'Do nothing' => 'do-nothing',
									'Cancel for' => 'cancel-for',
								);

								foreach($click_on_close_button_values as $key => $value)
								{
									if ( $value == $click_on_close_button ) {
										?>
						<option selected value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
									} else {
										?>
						<option value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
									}
								}
							?>
					</select>
					<p id="form-field-cancel-for" <?php if(get_post_meta( $post->ID, "click_on_close_button_datebook_notice_option", true )!= 'cancel-for') {echo 'style="display: none;"';} ?>>
						<?php
							$days_click_on_close_button_datebook_notice_option = get_post_meta( $post->ID, "days_click_on_close_button_datebook_notice_option", true );
							if ( $days_click_on_close_button_datebook_notice_option != '' ) {
								?>
						<input name="days_click_on_close_button_datebook_notice_option" class="datebook-notice-small-input" type="number" value="<?php echo esc_attr($days_click_on_close_button_datebook_notice_option); ?>" min="1" >
						<span> <?php echo esc_html__('Days', 'datebook')?> </span><br>
						<?php
							} else {
								?>
						<input name="days_click_on_close_button_datebook_notice_option" class="datebook-notice-small-input" type="number" value="10" min="1" >
						<span> <?php echo esc_html__('Days', 'datebook')?> </span><br>
						<?php
							}
							?>
					</p>
					<p> <?php echo esc_html__('Select how many days will be canceled the message when click on button close', 'datebook')?> </p>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="limitations">
						<?php echo esc_html__('Limitations', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="limitations_datebook_notice_option" data-hide-limitations-options>
						<?php
								$limitations = get_post_meta( $post->ID, "limitations_datebook_notice_option", true );
								$limitations_values = array(
									'No limitations' => 'no-limitations',
									'Custom limitations' => 'custom-limitations',
								);

								foreach($limitations_values as $key => $value)
								{
									if ( $value == $limitations ) {
										?>
						<option selected value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
									} else {
										?>
						<option value="<?php echo esc_attr($value); ?>"><?php echo esc_attr($key); ?></option>
						<?php
									}
								}
							?>
					</select>
					<p id="form-field-custom-limitations" <?php if(get_post_meta( $post->ID, "limitations_datebook_notice_option", true )!= 'custom-limitations') {echo 'style="display: none;"';} ?>> <?php echo esc_html__('Choose how many times the message will appear, in a number of selected days', 'datebook')?> :<br>
						<?php
							$times_custom_limitations_value = get_post_meta( $post->ID, "times_custom_limitations_datebook_notice_option", true );
							if ( $times_custom_limitations_value != '' ) {
								?>
						<input name="times_custom_limitations_datebook_notice_option" class="datebook-notice-small-input" type="number" value="<?php echo esc_attr($times_custom_limitations_value); ?>" min="1" >
						<span> <?php echo esc_html__('Times', 'datebook')?> </span><br>
						<?php
							} else {
								?>
						<input name="times_custom_limitations_datebook_notice_option" class="datebook-notice-small-input" type="number" value="10" min="1" >
						<span> <?php echo esc_html__('Times', 'datebook')?> </span><br>
						<?php
							}
							$days_custom_limitations_value = get_post_meta( $post->ID, "days_custom_limitations_datebook_notice_option", true );
							if ( $days_custom_limitations_value != '' ) {
								?>
						<input name="days_custom_limitations_datebook_notice_option" class="datebook-notice-small-input" type="number" value="<?php echo esc_attr($days_custom_limitations_value); ?>" min="1" >
						<span> <?php echo esc_html__('Days', 'datebook')?> </span>
						<?php
							} else {
								?>
						<input name="days_custom_limitations_datebook_notice_option" class="datebook-notice-small-input" type="number" value="10" min="1" >
						<span> <?php echo esc_html__('Days', 'datebook')?> </span>
						<?php
							}
							?>
					</p>
					<p> <?php echo esc_html__('Limit the number of shows at selected time range', 'datebook')?> </p>
				</td>
			</tr>
		</tbody>
	</table>
</form>
<?php
		}
	}


	public static function datebook_notice_create_meta_boxes() {
    	add_meta_box("datebook-notifications-item-meta-box", esc_html__( 'Notification settings', 'datebook' ), array( __CLASS__ ,'datebook_notice_item_meta_box'), "datebook_notice", "normal", "core", null);
	}


	public static function datebook_notice_set_limitations($notification_notice_id,$datebook_notice_post_id,$datebook_notice_enabled) {

		$datebook_notice_limitations = get_post_meta( $datebook_notice_post_id, "limitations_datebook_notice_option", true );
		$datebook_notice_limitations_times = get_post_meta( $datebook_notice_post_id, "times_custom_limitations_datebook_notice_option", true );
		$datebook_notice_limitations_days = get_post_meta( $datebook_notice_post_id, "days_custom_limitations_datebook_notice_option", true );
		$datebook_notice_cookie_limitation_name = 'limitation_datebook_notice_' . $notification_notice_id;
		$click_on_close_button = get_post_meta( $datebook_notice_post_id, "click_on_close_button_datebook_notice_option", true );

		if ( $datebook_notice_enabled == 'enabled' && get_post_status ( $datebook_notice_post_id ) == 'publish' && $click_on_close_button != 'cancel-for') {
			setcookie("close_datebook_notice_" . $notification_notice_id, '', time() - 3600);
		}

		if ( $datebook_notice_limitations == 'custom-limitations' ) {
			if(!isset($_COOKIE[$datebook_notice_cookie_limitation_name])) {
				setcookie("limitation_datebook_notice_" . $notification_notice_id, "1", time() + (86400 * $datebook_notice_limitations_days));
			} else {
				$datebook_notice_cookie_limitation_count = $_COOKIE[$datebook_notice_cookie_limitation_name] + 1;
				setcookie("limitation_datebook_notice_" . $notification_notice_id, $datebook_notice_cookie_limitation_count, time() + (86400 * $datebook_notice_limitations_days));
			}
		} else {
			if ( $datebook_notice_enabled == 'enabled' && get_post_status ( $datebook_notice_post_id ) == 'publish' ) {
				setcookie("limitation_datebook_notice_" . $notification_notice_id, '', time() - 3600);
			}
		}
	}


	public static function create_datebook_notice_css_stylesheet() {

		$datebook_notice_css_file = fopen( DATEBOOK_DIR . "framework/css/notification/datebook-notice-dynamic.css", "w") or die("Unable to open file!");
		$css_code = '';
		foreach (glob( DATEBOOK_DIR . "framework/css/notification/parts/*.css") as $css) {
			$file = basename($css);
			$css_code .= file_get_contents( DATEBOOK_DIR . 'framework/css/notification/parts/' . $file );
			$css_code .= "\n";
		}
		fwrite($datebook_notice_css_file, $css_code);
		fclose($datebook_notice_css_file);
	}


	public static function add_to_datebook_gps_js($js_url) {

		echo "<script src='";
		echo esc_url($js_url);
		echo "' defer></script>";

	}

	public static function add_to_datebook_gps_css($css_url) {

		echo "<link rel='preload' href='";
		echo esc_url($css_url);
		echo "' media='all' />";

	}


}


$Options_Framework_Notifications = new Options_Framework_Notifications;


/*
 *  Animations: creat animations to boxs
 */

class Class_DateBook_Notification_Animations {

function __construct() {

	add_action( 'datebook_notice_admin_menu', array($this, 'add_menus_to_datebook_notice' ) );
	add_action( 'add_meta_boxes', array($this, 'datebook_animations_create_meta_boxes' ) );
	add_action( 'save_post', array( $this, 'save_datebook_animations_item_meta_box' ), 10, 3);
	// filter
	add_filter( 'hidden_meta_boxes', array( $this, 'datebook_animations_remove_post_meta_boxes' ), 10, 3 );
	add_filter( 'parent_file', array( $this, 'datebook_animations_cpt_parent_file' ) );
	add_filter( 'submenu_file', array( $this, 'datebook_animations_cpt_submenu_file' ) );
	
}


function add_menus_to_datebook_notice() {
	add_submenu_page( 'edit.php?post_type=datebook_notice', esc_html__( 'Animations In', 'datebook' ), esc_html__( 'Animations In', 'datebook' ), 'edit_datebook_animations', '/edit.php?post_type=datebook_animations', null);
}

function datebook_animations_cpt_parent_file( $parent_file ){
    global $current_screen, $self;
    if ( in_array( $current_screen->base, array( 'post', 'edit' ) ) && 'datebook_animations' == $current_screen->post_type ) {
        $parent_file = 'edit.php?post_type=datebook_notice';
    }
    return $parent_file;
}

function datebook_animations_cpt_submenu_file( $submenu_file ){
    global $current_screen, $self;
    if ( in_array( $current_screen->base, array( 'post', 'edit' ) ) && 'datebook_animations' == $current_screen->post_type ) {
        $submenu_file = 'edit.php?post_type=datebook_animations';
    }
    return $submenu_file;
}


function datebook_animations_remove_post_meta_boxes( $hidden, $screen, $use_defaults ) {
	global $wp_meta_boxes;
	$cpt = 'datebook_animations'; // Modify this to your needs!

	if( $cpt === $screen->id && isset( $wp_meta_boxes[$cpt] ) ) {
		$tmp = array();
		foreach( (array) $wp_meta_boxes[$cpt] as $context_key => $context_item ) {
			foreach( $context_item as $priority_key => $priority_item ) {
				foreach( $priority_item as $metabox_key => $metabox_item ) {
					if ( $metabox_key != 'submitdiv' && $metabox_key != 'animations-boxes-item-meta-box' ) {
						$tmp[] = $metabox_key;
					}
				}
			}
		}
		$hidden = $tmp;  // Override the current user option here.
	}
	return $hidden;
}

function datebook_animations_create_meta_boxes() {
    add_meta_box("animations-boxes-item-meta-box", esc_html__( 'Notification settings', 'datebook' ), array($this, 'datebook_animations_item_meta_box'), "datebook_animations", "normal", "core", null);
}

function datebook_animations_item_meta_box() {

	 wp_nonce_field(basename(__FILE__), "meta-box-nonce");

	 $post = get_post();
	 $post->ID

	 ?>
<form id="formdatebook-notice" method="POST">
	<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
		<input type="hidden" name="prevent_delete_meta_movetotrash" id="prevent-delete-meta-movetotrash" value="<?php echo wp_create_nonce(DATEBOOK_URL.$post->ID); ?>" />
		<tbody>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="datebook_animation_post_option_animation_effect">
						<?php echo esc_html__('Animation in effect', 'datebook'); ?>
					</label>
				</th>
				<td>
					<select name="datebook_animation_post_option_animation_effect" class="datebook-animation-post-option-animation-effect">
						<?php
							$get_animation_effects_value = get_post_meta( $post->ID, "datebook_animation_post_option_animation_effect", true );
							$animation_effects_values = array(
								'default' => esc_html__('Default', 'datebook'),
								'bounce-side' => esc_html__('Bounce From Side', 'datebook'),
								'fade-in' => esc_html__('Fade In', 'datebook'),
								'fade-in-shake' => esc_html__('Fade In Shake', 'datebook'),
								'fade-in-rotate-shake' => esc_html__('Fade In Rotate Shake', 'datebook'),
								'scale-in' => esc_html__('Scale In', 'datebook'),
								'shake' => esc_html__('Shake', 'datebook'),
							);

							foreach($animation_effects_values as $key => $value) {
								if($key == $get_animation_effects_value) {
									?>
						<option value="<?php echo esc_attr($key); ?>" selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="position">
						<?php echo esc_html__('Position', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="datebook_animation_post_option_side" class="datebook-animation-post-option-side">
						<?php
							$side = get_post_meta( $post->ID, "datebook_animation_post_option_side", true );
							$side_values = array('right', 'left');

							foreach($side_values as $key => $value) {
								if($value == $side) {
									?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
					<?php
						if ( get_post_meta( $post->ID, "datebook_animation_post_option_side_value", true ) == '' ) {
						?>
					<input name="datebook_animation_post_option_side_value" type="number" class="datebook-animation-post-option-side-value" value="0" >
					<?php
						} else {
						?>
					<input name="datebook_animation_post_option_side_value" type="number" class="datebook-animation-post-option-side-value" value="<?php echo get_post_meta( $post->ID, "datebook_animation_post_option_side_value", true ); ?>" >
					<?php
						}
						?>
					<select name="datebook_animation_post_option_side_unit" class="datebook-animation-post-option-side-unit">
						<?php
							$side_unit = get_post_meta( $post->ID, "datebook_animation_post_option_side_unit", true );
							$side_units_values = array('px', '%');

							foreach($side_units_values as $key => $value) {
								if($value == $side_unit) {
									?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
					<br>
					<select name="datebook_animation_post_option_height" class="datebook-animation-post-option-height">
						<?php
							$height = get_post_meta( $post->ID, "datebook_animation_post_option_height", true );
							$height_values = array('top', 'bottom');

							foreach($height_values as $key => $value) {
								if($value == $height) {
									?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
					<?php
						if ( get_post_meta( $post->ID, "datebook_animation_post_option_height_value", true ) == '' ) {
						?>
					<input name="datebook_animation_post_option_height_value" type="number" class="datebook-animation-post-option-height-value" value="100" >
					<?php
						} else {
						?>
					<input name="datebook_animation_post_option_height_value" type="number" class="datebook-animation-post-option-height-value" value="<?php echo get_post_meta( $post->ID, "datebook_animation_post_option_height_value", true ); ?>" >
					<?php
						}
						?>
					<select name="datebook_animation_post_option_height_unit" class="datebook-animation-post-option-height-unit">
						<?php
							$height_unit = get_post_meta( $post->ID, "datebook_animation_post_option_height_unit", true );
							$height_units_values = array('px', '%');

							foreach($height_units_values as $key => $value) {
								if($value == $height_unit) {
									?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="animation_speed">
						<?php echo esc_html__('Animation in speed', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_animation_post_option_animation_speed" type="number" step="any" class="datebook-animation-post-option-animation-speed" value="<?php echo get_post_meta( $post->ID, "datebook_animation_post_option_animation_speed", true ); ?>" min="0" >
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="animation_timing">
						<?php echo esc_html__('Animation in timing', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="datebook_animation_post_option_animation_timing" class="datebook-animation-post-option-animation-timing">
						<?php
							$animation_timing_unit = get_post_meta( $post->ID, "datebook_animation_post_option_animation_timing", true );
							$animation_timing_units_values = array('linear', 'ease-in', 'ease-out', 'ease-in-out');

							foreach($animation_timing_units_values as $key => $value) {
								if($value == $animation_timing_unit) {
									?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
				</td>
			</tr>
		</tbody>
	</table>
</form>
<?php

}

function save_datebook_animations_item_meta_box( $post_id, $post) {

	if (!isset($_POST["meta-box-nonce"]) || !wp_verify_nonce($_POST["meta-box-nonce"], basename(__FILE__)))
		return $post_id;

	$slug = "datebook_animations";

	if($slug != $post->post_type)
		return $post_id;

	$datebook_animation_post_option_side = isset($_POST["datebook_animation_post_option_side"]) ? $_POST["datebook_animation_post_option_side"] : '';
	update_post_meta($post_id, "datebook_animation_post_option_side", sanitize_text_field($datebook_animation_post_option_side));
	$datebook_animation_post_option_side_value = isset($_POST["datebook_animation_post_option_side_value"]) ? $_POST["datebook_animation_post_option_side_value"] : '';
	update_post_meta($post_id, "datebook_animation_post_option_side_value", sanitize_text_field($datebook_animation_post_option_side_value));
	$datebook_animation_post_option_side_unit = isset($_POST["datebook_animation_post_option_side_unit"]) ? $_POST["datebook_animation_post_option_side_unit"] : '';
	update_post_meta($post_id, "datebook_animation_post_option_side_unit", sanitize_text_field($datebook_animation_post_option_side_unit));
	$datebook_animation_post_option_height = isset($_POST["datebook_animation_post_option_height"]) ? $_POST["datebook_animation_post_option_height"] : '';
	update_post_meta($post_id, "datebook_animation_post_option_height", sanitize_text_field($datebook_animation_post_option_height));
	$datebook_animation_post_option_height_value = isset($_POST["datebook_animation_post_option_height_value"]) ? $_POST["datebook_animation_post_option_height_value"] : '';
	update_post_meta($post_id, "datebook_animation_post_option_height_value", sanitize_text_field($datebook_animation_post_option_height_value));
	$datebook_animation_post_option_height_unit = isset($_POST["datebook_animation_post_option_height_unit"]) ? $_POST["datebook_animation_post_option_height_unit"] : '';
	update_post_meta($post_id, "datebook_animation_post_option_height_unit", sanitize_text_field($datebook_animation_post_option_height_unit));
	$datebook_animation_post_option_animation_speed = isset($_POST["datebook_animation_post_option_animation_speed"]) ? $_POST["datebook_animation_post_option_animation_speed"] : '';
	update_post_meta($post_id, "datebook_animation_post_option_animation_speed", sanitize_text_field($datebook_animation_post_option_animation_speed));
	$datebook_animation_post_option_animation_timing = isset($_POST["datebook_animation_post_option_animation_timing"]) ? $_POST["datebook_animation_post_option_animation_timing"] : '';
	update_post_meta($post_id, "datebook_animation_post_option_animation_timing", sanitize_text_field($datebook_animation_post_option_animation_timing));
	$datebook_animation_post_option_animation_effect = isset($_POST["datebook_animation_post_option_animation_effect"]) ? $_POST["datebook_animation_post_option_animation_effect"] : '';
	update_post_meta($post_id, "datebook_animation_post_option_animation_effect", sanitize_text_field($datebook_animation_post_option_animation_effect));



	$animations_style_css_file = fopen( DATEBOOK_DIR . "framework/css/notification/parts/animations_style.css", "w") or die("Unable to open file!");
	$posts_datebook_animations = get_posts(array(
		'posts_per_page'=> -1,
		'post_type' => 'datebook_animations',
	));

	$css_code = "\n";
	$css_code .= "\n";

	foreach ( $posts_datebook_animations as $post_datebook_animation ) {

		$post_datebook_animation_id = $post_datebook_animation->ID;
		$animation_effect = get_post_meta( $post_datebook_animation_id, "datebook_animation_post_option_animation_effect", true );
		$animation_speed = get_post_meta( $post_datebook_animation_id, "datebook_animation_post_option_animation_speed", true );
		$animation_side = get_post_meta( $post_datebook_animation_id, "datebook_animation_post_option_side", true );
		$animation_side_value = get_post_meta( $post_datebook_animation_id, "datebook_animation_post_option_side_value", true );
		$animation_side_unit = get_post_meta( $post_datebook_animation_id, "datebook_animation_post_option_side_unit", true );
		$animation_height = get_post_meta( $post_datebook_animation_id, "datebook_animation_post_option_height", true );
		$animation_height_value = get_post_meta( $post_datebook_animation_id, "datebook_animation_post_option_height_value", true );
		$animation_height_unit = get_post_meta( $post_datebook_animation_id, "datebook_animation_post_option_height_unit", true );
		$animation_timing = get_post_meta( $post_datebook_animation_id, "datebook_animation_post_option_animation_timing", true );
		if ($animation_speed == '' || $animation_speed == null) {
			$animation_speed = 1;
		} elseif ($animation_speed < 0) {
			$animation_speed = 0;
		}
		if ($animation_side == 'left') {
			$side_direction = '-';
			$side_direction_inverse = '';
		} else {
			$side_direction = '';
			$side_direction_inverse = '-';
		}
		if ($animation_height == 'top') {
			$height_direction = '-';
		} else {
			$height_direction = '';
		}
		if ($animation_effect == 'default') {
			$css_code .= '.datebook-notice-animation-id-' . $post_datebook_animation_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "-webkit-animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-" . $post_datebook_animation_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: translate(" . $side_direction . $animation_side_value . $animation_side_unit . "," . $height_direction . $animation_height_value . $animation_height_unit . ");\n" ;
			$css_code .= "	}\n";
			$css_code .= "	100% {\n";
			$css_code .= "		transform: translate(0px,0px);\n";
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		} elseif ($animation_effect == 'bounce-side') {
			$css_code .= '.datebook-notice-animation-id-' . $post_datebook_animation_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "-webkit-animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-" . $post_datebook_animation_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: translate(" . $side_direction . $animation_side_value . $animation_side_unit . "," . $height_direction . $animation_height_value . $animation_height_unit . ");\n" ;
			$css_code .= "	}\n";
			$css_code .= "	60% {\n";
			$css_code .= "		transform: translateX(" . $side_direction_inverse . "30px);\n";
			$css_code .= "	}\n";
			$css_code .= "	80% {\n";
			$css_code .= "		transform: translateX(" . $side_direction . "10px);\n";
			$css_code .= "	}\n";
			$css_code .= "	90% {\n";
			$css_code .= "		transform: translateX(" . $side_direction_inverse . "5px);\n";
			$css_code .= "	}\n";
			$css_code .= "	95% {\n";
			$css_code .= "		transform: translateX(" . $side_direction . "2px);\n";
			$css_code .= "	}\n";
			$css_code .= "	100% {\n";
			$css_code .= "		transform: translate(0px,0px);\n";
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		} elseif ($animation_effect == 'fade-in') {
			$css_code .= '.datebook-notice-animation-id-' . $post_datebook_animation_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "-webkit-animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-" . $post_datebook_animation_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: translate(" . $side_direction . $animation_side_value . $animation_side_unit . "," . $height_direction . $animation_height_value . $animation_height_unit . ");\n" ;
			$css_code .= "		opacity: 0;\n" ;
			$css_code .= "	}\n";
			$css_code .= "	100% {\n";
			$css_code .= "		transform: translate(0px,0px);\n";
			$css_code .= "		opacity: 1;\n" ;
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		} elseif ($animation_effect == 'scale-in') {
			$css_code .= '.datebook-notice-animation-id-' . $post_datebook_animation_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-" . $post_datebook_animation_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: scale(0) translate(" . $side_direction . $animation_side_value . $animation_side_unit . "," . $height_direction . $animation_height_value . $animation_height_unit . ");\n" ;
			$css_code .= "	}\n";
			$css_code .= "	60% {\n";
			$css_code .= "		transform: scale(1.2) translate(0px,0px);\n";
			$css_code .= "	}\n" ;
			$css_code .= "	70% {\n";
			$css_code .= "		transform: scale(0.9) translate(0px,0px);\n";
			$css_code .= "	}\n" ;
			$css_code .= "	80% {\n";
			$css_code .= "		transform: scale(1.1) translate(0px,0px);\n";
			$css_code .= "	}\n" ;
			$css_code .= "	90% {\n";
			$css_code .= "		transform: scale(0.95) translate(0px,0px);\n";
			$css_code .= "	}\n" ;
			$css_code .= "	100% {\n";
			$css_code .= "		transform: scale(1) translate(0px,0px);\n";
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		} elseif ($animation_effect == 'shake') {
			$css_code .= '.datebook-notice-animation-id-' . $post_datebook_animation_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "-webkit-animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-" . $post_datebook_animation_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: translate(" . $side_direction . $animation_side_value . $animation_side_unit . "," . $height_direction . $animation_height_value . $animation_height_unit . ");\n" ;
			$css_code .= "	}\n";
			$css_code .= "	10, 90% {\n" ;
			$css_code .= "		transform: translate3d(-1px, 0, 0)\n" ;
			$css_code .= "	}\n";
			$css_code .= "	20, 80% {\n" ;
			$css_code .= "		transform: translate3d(2px, 0, 0)\n" ;
			$css_code .= "	}\n";
			$css_code .= "	30%, 50%, 70% {\n" ;
			$css_code .= "		transform: translate3d(-4px, 0, 0)\n" ;
			$css_code .= "	}\n";
			$css_code .= "	40%, 60% {\n" ;
			$css_code .= "		transform: translate3d(4px, 0, 0)\n" ;
			$css_code .= "	}\n";
			$css_code .= "	100% {\n";
			$css_code .= "		transform: translate(0px,0px);\n";
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		} elseif ($animation_effect == 'fade-in-shake') {
			$css_code .= '.datebook-notice-animation-id-' . $post_datebook_animation_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "-webkit-animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-" . $post_datebook_animation_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: translate(" . $side_direction . $animation_side_value . $animation_side_unit . "," . $height_direction . $animation_height_value . $animation_height_unit . ");\n" ;
			$css_code .= "		opacity: 0;\n" ;
			$css_code .= "	}\n";
			$css_code .= "	10%, 90% {\n" ;
			$css_code .= "		transform: translate3d(-1px, 0, 0);\n" ;
			$css_code .= "	}\n";
			$css_code .= "	20%, 80% {\n" ;
			$css_code .= "		transform: translate3d(2px, 0, 0);\n" ;
			$css_code .= "	}\n";
			$css_code .= "	30% {\n" ;
			$css_code .= "		transform: translate3d(-4px, 0, 0);\n" ;
			$css_code .= "		opacity: 1;\n" ;
			$css_code .= "	}\n";
			$css_code .= "	50%, 70% {\n" ;
			$css_code .= "		transform: translate3d(-4px, 0, 0);\n" ;
			$css_code .= "	}\n";
			$css_code .= "	40%, 60% {\n" ;
			$css_code .= "		transform: translate3d(4px, 0, 0);\n" ;
			$css_code .= "	}\n";
			$css_code .= "	100% {\n";
			$css_code .= "		transform: translate(0px,0px);\n";
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		} elseif ($animation_effect == 'fade-in-rotate-shake') {
			$css_code .= '.datebook-notice-animation-id-' . $post_datebook_animation_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "-webkit-animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-" . $post_datebook_animation_id . ' ' . $animation_speed . 's ' . $animation_timing . " both;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-" . $post_datebook_animation_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: translate(" . $side_direction . $animation_side_value . $animation_side_unit . "," . $height_direction . $animation_height_value . $animation_height_unit . ");\n" ;
			$css_code .= "		opacity: 0;\n" ;
			$css_code .= "	}\n";
			$css_code .= "	10%, 90% {\n" ;
			$css_code .= "		transform: rotate(5deg);\n" ;
			$css_code .= "	}\n";
			$css_code .= "	20%, 80% {\n" ;
			$css_code .= "		transform: rotate(-5deg);\n" ;
			$css_code .= "	}\n";
			$css_code .= "	30% {\n" ;
			$css_code .= "		transform: rotate(5deg);\n" ;
			$css_code .= "		opacity: 1;\n" ;
			$css_code .= "	}\n";
			$css_code .= "	50%, 70% {\n" ;
			$css_code .= "		transform: rotate(5deg);\n" ;
			$css_code .= "	}\n";
			$css_code .= "	40%, 60% {\n" ;
			$css_code .= "		transform: rotate(-5deg);\n" ;
			$css_code .= "	}\n";
			$css_code .= "	100% {\n";
			$css_code .= "		transform: translate(0px,0px);\n";
			$css_code .= "		transform: rotate(0deg);\n";
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		}
	}
	fwrite($animations_style_css_file, $css_code);
	fclose($animations_style_css_file);

	Options_Framework_Notifications::create_datebook_notice_css_stylesheet();
}

}

$Class_DateBook_Notification_Animations = new Class_DateBook_Notification_Animations;

/*
*  Animations
*
*  @description: creat animations to boxs
*  @since: 1.2.6
*  @created: 24/09/16
*/

class Class_DateBook_Notification_Animations_Out {

function __construct() {

	add_action( 'datebook_notice_admin_menu', array($this, 'add_menus_to_datebook_notice' ) );
	add_action( 'add_meta_boxes', array($this, 'datebook_animouts_create_meta_boxes' ) );
	add_action( 'save_post', array( $this, 'save_datebook_animouts_item_meta_box' ), 10, 3);
	// filter
	add_filter( 'hidden_meta_boxes', array( $this, 'datebook_animouts_remove_post_meta_boxes' ), 10, 3 );
	add_filter( 'parent_file', array( $this, 'datebook_animouts_cpt_parent_file' ) );
	add_filter( 'submenu_file', array( $this, 'datebook_animouts_cpt_submenu_file' ) );

}


function add_menus_to_datebook_notice() {

	add_submenu_page( 'edit.php?post_type=datebook_notice', esc_html__( 'Animations Out', 'datebook' ), esc_html__( 'Animations Out', 'datebook' ), 'edit_datebook_animouts', '/edit.php?post_type=datebook_animouts', null);

}

function datebook_animouts_cpt_parent_file( $parent_file ){

    global $current_screen, $self;

    if ( in_array( $current_screen->base, array( 'post', 'edit' ) ) && 'datebook_animouts' == $current_screen->post_type ) {
        $parent_file = 'edit.php?post_type=datebook_notice';
    }

    return $parent_file;

}

function datebook_animouts_cpt_submenu_file( $submenu_file ){

    global $current_screen, $self;

    if ( in_array( $current_screen->base, array( 'post', 'edit' ) ) && 'datebook_animouts' == $current_screen->post_type ) {
        $submenu_file = 'edit.php?post_type=datebook_animouts';
    }

    return $submenu_file;

}

function datebook_animouts_remove_post_meta_boxes( $hidden, $screen, $use_defaults ) {

	global $wp_meta_boxes;

	$cpt = 'datebook_animouts'; // Modify this to your needs!

	if( $cpt === $screen->id && isset( $wp_meta_boxes[$cpt] ) ) {
		$tmp = array();
		foreach( (array) $wp_meta_boxes[$cpt] as $context_key => $context_item ) {
			foreach( $context_item as $priority_key => $priority_item ) {
				foreach( $priority_item as $metabox_key => $metabox_item ) {
					if ( $metabox_key != 'submitdiv' && $metabox_key != 'animations-boxes-item-meta-box' ) {
						$tmp[] = $metabox_key;
					}
				}
			}
		}
		$hidden = $tmp;  // Override the current user option here.
	}

	return $hidden;

}

function datebook_animouts_create_meta_boxes() {

    add_meta_box("animations-boxes-item-meta-box", esc_html__( 'Notification settings', 'datebook' ), array($this, 'datebook_animouts_item_meta_box'), "datebook_animouts", "normal", "core", null);

}

function datebook_animouts_item_meta_box() {

	 wp_nonce_field(basename(__FILE__), "meta-box-nonce");
	 $post = get_post();
	 $post->ID

	 ?>
<form id="formdatebook-notice" method="POST">
	<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
		<input type="hidden" name="prevent_delete_meta_movetotrash" id="prevent-delete-meta-movetotrash" value="<?php echo wp_create_nonce(DATEBOOK_URL.$post->ID); ?>" />
		<tbody>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="datebook_animout_post_option_animation_effect">
						<?php echo esc_html__('Animation Out Effect', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="datebook_animout_post_option_animation_effect" class="datebook-animout-post-option-animation-effect">
						<?php
							$get_animation_effects_value = get_post_meta( $post->ID, "datebook_animout_post_option_animation_effect", true );
							$animation_effects_values = array(
								'default' => esc_html__('Default', 'datebook'),
								'fade-out' => esc_html__('Fade Out', 'datebook'),
								'scale-out' => esc_html__('Scale Out', 'datebook'),
								'bounce-side' => esc_html__('Bounce Left Or Right', 'datebook'),
								'bounce-up-down' => esc_html__('Bounce Up Or Down', 'datebook'),
							);

							foreach($animation_effects_values as $key => $value) {
								if($key == $get_animation_effects_value) {
									?>
						<option value="<?php echo esc_attr($key); ?>" selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option value="<?php echo esc_attr($key); ?>"><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="position">
						<?php echo esc_html__('Position', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="datebook_animout_post_option_side" class="datebook-animout-post-option-side">
						<?php
							$side = get_post_meta( $post->ID, "datebook_animout_post_option_side", true );
							$side_values = array('right', 'left');

							foreach($side_values as $key => $value) {
								if($value == $side) {
									?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
					<?php
						if ( get_post_meta( $post->ID, "datebook_animout_post_option_side_value", true ) == '' ) {
						?>
					<input name="datebook_animout_post_option_side_value" type="number" class="datebook-animout-post-option-side-value" value="0" >
					<?php
						} else {
						?>
					<input name="datebook_animout_post_option_side_value" type="number" class="datebook-animout-post-option-side-value" value="<?php echo get_post_meta( $post->ID, "datebook_animout_post_option_side_value", true ); ?>" >
					<?php
						}
						?>
					<select name="datebook_animout_post_option_side_unit" class="datebook-animout-post-option-side-unit">
						<?php
							$side_unit = get_post_meta( $post->ID, "datebook_animout_post_option_side_unit", true );
							$side_units_values = array('px', '%');

							foreach($side_units_values as $key => $value) {
								if($value == $side_unit) {
									?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
					<br>
					<select name="datebook_animout_post_option_height" class="datebook-animout-post-option-height">
						<?php
							$height = get_post_meta( $post->ID, "datebook_animout_post_option_height", true );
							$height_values = array('top', 'bottom');

							foreach($height_values as $key => $value) {
								if($value == $height) {
									?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
					<?php
						if ( get_post_meta( $post->ID, "datebook_animout_post_option_height_value", true ) == '' ) {
						?>
					<input name="datebook_animout_post_option_height_value" type="number" class="datebook-animout-post-option-height-value" value="100" >
					<?php
						} else {
						?>
					<input name="datebook_animout_post_option_height_value" type="number" class="datebook-animout-post-option-height-value" value="<?php echo get_post_meta( $post->ID, "datebook_animout_post_option_height_value", true ); ?>" >
					<?php
						}
						?>
					<select name="datebook_animout_post_option_height_unit" class="datebook-animout-post-option-height-unit">
						<?php
							$height_unit = get_post_meta( $post->ID, "datebook_animout_post_option_height_unit", true );
							$height_units_values = array('px', '%');

							foreach($height_units_values as $key => $value) {
								if($value == $height_unit) {
									?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="animation_speed">
						<?php echo esc_html__('Animation Out speed', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_animout_post_option_animation_speed" type="number" step="any" class="datebook-animout-post-option-animation-speed" value="<?php echo get_post_meta( $post->ID, "datebook_animout_post_option_animation_speed", true ); ?>" min="0" >
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="animation_timing">
						<?php echo esc_html__('Animation Out timing', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="datebook_animout_post_option_animation_timing" class="datebook-animout-post-option-animation-timing">
						<?php
							$animation_timing_unit = get_post_meta( $post->ID, "datebook_animout_post_option_animation_timing", true );
							$animation_timing_units_values = array('linear', 'ease-in', 'ease-out', 'ease-in-out');

							foreach($animation_timing_units_values as $key => $value) {
								if($value == $animation_timing_unit) {
									?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
								} else {
									?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
								}
							}
							?>
					</select>
				</td>
			</tr>
		</tbody>
	</table>
</form>
<?php
}

function save_datebook_animouts_item_meta_box( $post_id, $post) {

	if (!isset($_POST["meta-box-nonce"]) || !wp_verify_nonce($_POST["meta-box-nonce"], basename(__FILE__)))
		return $post_id;

	$slug = "datebook_animouts";
	if($slug != $post->post_type)
		return $post_id;

	$datebook_animout_post_option_side = isset($_POST["datebook_animout_post_option_side"]) ? $_POST["datebook_animout_post_option_side"] : '';
	update_post_meta($post_id, "datebook_animout_post_option_side", sanitize_text_field($datebook_animout_post_option_side));
	$datebook_animout_post_option_side_value = isset($_POST["datebook_animout_post_option_side_value"]) ? $_POST["datebook_animout_post_option_side_value"] : '';
	update_post_meta($post_id, "datebook_animout_post_option_side_value", sanitize_text_field($datebook_animout_post_option_side_value));
	$datebook_animout_post_option_side_unit = isset($_POST["datebook_animout_post_option_side_unit"]) ? $_POST["datebook_animout_post_option_side_unit"] : '';
	update_post_meta($post_id, "datebook_animout_post_option_side_unit", sanitize_text_field($datebook_animout_post_option_side_unit));
	$datebook_animout_post_option_height = isset($_POST["datebook_animout_post_option_height"]) ? $_POST["datebook_animout_post_option_height"] : '';
	update_post_meta($post_id, "datebook_animout_post_option_height", sanitize_text_field($datebook_animout_post_option_height));
	$datebook_animout_post_option_height_value = isset($_POST["datebook_animout_post_option_height_value"]) ? $_POST["datebook_animout_post_option_height_value"] : '';
	update_post_meta($post_id, "datebook_animout_post_option_height_value", sanitize_text_field($datebook_animout_post_option_height_value));
	$datebook_animout_post_option_height_unit = isset($_POST["datebook_animout_post_option_height_unit"]) ? $_POST["datebook_animout_post_option_height_unit"] : '';
	update_post_meta($post_id, "datebook_animout_post_option_height_unit", sanitize_text_field($datebook_animout_post_option_height_unit));
	$datebook_animout_post_option_animation_speed = isset($_POST["datebook_animout_post_option_animation_speed"]) ? $_POST["datebook_animout_post_option_animation_speed"] : '';
	update_post_meta($post_id, "datebook_animout_post_option_animation_speed", sanitize_text_field($datebook_animout_post_option_animation_speed));
	$datebook_animout_post_option_animation_timing = isset($_POST["datebook_animout_post_option_animation_timing"]) ? $_POST["datebook_animout_post_option_animation_timing"] : '';
	update_post_meta($post_id, "datebook_animout_post_option_animation_timing", sanitize_text_field($datebook_animout_post_option_animation_timing));
	$datebook_animout_post_option_animation_effect = isset($_POST["datebook_animout_post_option_animation_effect"]) ? $_POST["datebook_animout_post_option_animation_effect"] : '';
	update_post_meta($post_id, "datebook_animout_post_option_animation_effect", sanitize_text_field($datebook_animout_post_option_animation_effect));



	$animations_style_css_file = fopen( DATEBOOK_DIR . "framework/css/notification/parts/animations_out_style.css", "w") or die("Unable to open file!");
	$posts_datebook_animouts = get_posts(array(
		'posts_per_page'=> -1,
		'post_type' => 'datebook_animouts',
	));

	$css_code = "\n";
	$css_code .= "\n";

	foreach ( $posts_datebook_animouts as $post_datebook_animout ) {
		$post_datebook_animout_id = $post_datebook_animout->ID;
		$animation_out_effect = get_post_meta( $post_datebook_animout_id, "datebook_animout_post_option_animation_effect", true );
		$animation_out_speed = get_post_meta( $post_datebook_animout_id, "datebook_animout_post_option_animation_speed", true );
		$animation_out_side = get_post_meta( $post_datebook_animout_id, "datebook_animout_post_option_side", true );
		$animation_out_side_value = get_post_meta( $post_datebook_animout_id, "datebook_animout_post_option_side_value", true );
		$animation_out_side_unit = get_post_meta( $post_datebook_animout_id, "datebook_animout_post_option_side_unit", true );
		$animation_out_height = get_post_meta( $post_datebook_animout_id, "datebook_animout_post_option_height", true );
		$animation_out_height_value = get_post_meta( $post_datebook_animout_id, "datebook_animout_post_option_height_value", true );
		$animation_out_height_unit = get_post_meta( $post_datebook_animout_id, "datebook_animout_post_option_height_unit", true );
		$animation_out_timing = get_post_meta( $post_datebook_animout_id, "datebook_animout_post_option_animation_timing", true );
		if ($animation_out_speed == '' || $animation_out_speed == null || $animation_out_speed < 0) {
			$animation_out_speed = 0;
		}
		if ($animation_out_side == 'left') {
			$side_direction = '-';
			$side_direction_inverse = '';
		} else {
			$side_direction = '';
			$side_direction_inverse = '-';
		}
		if ($animation_out_height == 'top') {
			$height_direction = '-';
			$height_direction_inverse = '';
		} else {
			$height_direction = '';
			$height_direction_inverse = '-';
		}
		if ($animation_out_effect == 'default') {
			$css_code .= '.datebook-notice-animation-out-id-' . $post_datebook_animout_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "-webkit-animation: animation-out-" . $post_datebook_animout_id . ' ' . $animation_out_speed . 's ' . $animation_out_timing . " both!important;\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-out-" . $post_datebook_animout_id . ' ' . $animation_out_speed . 's ' . $animation_out_timing . " both!important;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-out-" . $post_datebook_animout_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: translate(0px,0px);\n";
			$css_code .= "	}\n";
			$css_code .= "	100% {\n";
			$css_code .= "		transform: translate(" . $side_direction . $animation_out_side_value . $animation_out_side_unit . "," . $height_direction . $animation_out_height_value . $animation_out_height_unit . ");\n" ;
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		} elseif ($animation_out_effect == 'fade-out') {
			$css_code .= '.datebook-notice-animation-out-id-' . $post_datebook_animout_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "-webkit-animation: animation-out-" . $post_datebook_animout_id . ' ' . $animation_out_speed . 's ' . $animation_out_timing . " both!important;\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-out-" . $post_datebook_animout_id . ' ' . $animation_out_speed . 's ' . $animation_out_timing . " both!important;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-out-" . $post_datebook_animout_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: translate(0px,0px);\n";
			$css_code .= "		opacity: 1;\n" ;
			$css_code .= "	}\n";
			$css_code .= "	100% {\n";
			$css_code .= "		transform: translate(" . $side_direction . $animation_out_side_value . $animation_out_side_unit . "," . $height_direction . $animation_out_height_value . $animation_out_height_unit . ");\n" ;
			$css_code .= "		opacity: 0;\n" ;
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		} elseif ($animation_out_effect == 'scale-out') {
			$css_code .= '.datebook-notice-animation-out-id-' . $post_datebook_animout_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-out-" . $post_datebook_animout_id . ' ' . $animation_out_speed . 's ' . $animation_out_timing . " both!important;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-out-" . $post_datebook_animout_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: scale(1) translate(0px,0px);\n";
			$css_code .= "	}\n";
			$css_code .= "	40% {\n";
			$css_code .= "		transform: scale(1.2) translate(0px,0px);\n";
			$css_code .= "	}\n" ;
			$css_code .= "	100% {\n";
			$css_code .= "		transform: scale(0) translate(" . $side_direction . $animation_out_side_value . $animation_out_side_unit . "," . $height_direction . $animation_out_height_value . $animation_out_height_unit . ");\n" ;
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		} elseif ($animation_out_effect == 'bounce-side') {
			$css_code .= '.datebook-notice-animation-out-id-' . $post_datebook_animout_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "-webkit-animation: animation-out-" . $post_datebook_animout_id . ' ' . $animation_out_speed . 's ' . $animation_out_timing . " both!important;\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-out-" . $post_datebook_animout_id . ' ' . $animation_out_speed . 's ' . $animation_out_timing . " both!important;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-out-" . $post_datebook_animout_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: translate(0px,0px);\n";
			$css_code .= "	}\n";
			$css_code .= "	20% {\n";
			$css_code .= "		transform: translateX(" . $side_direction_inverse . "30px);\n";
			$css_code .= "	}\n";
			$css_code .= "	100% {\n";
			$css_code .= "		transform: translate(" . $side_direction . $animation_out_side_value . $animation_out_side_unit . "," . $height_direction . $animation_out_height_value . $animation_out_height_unit . ");\n" ;
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		} elseif ($animation_out_effect == 'bounce-up-down') {
			$css_code .= '.datebook-notice-animation-out-id-' . $post_datebook_animout_id . " {\n" ;
			$css_code .= "\t";
			$css_code .= "-webkit-animation: animation-out-" . $post_datebook_animout_id . ' ' . $animation_out_speed . 's ' . $animation_out_timing . " both!important;\n" ;
			$css_code .= "\t";
			$css_code .= "animation: animation-out-" . $post_datebook_animout_id . ' ' . $animation_out_speed . 's ' . $animation_out_timing . " both!important;\n" ;
			$css_code .= "}\n";
			$css_code .= "@keyframes animation-out-" . $post_datebook_animout_id . " {\n" ;
			$css_code .= "	0% {\n" ;
			$css_code .= "		transform: translate(0px,0px);\n";
			$css_code .= "	}\n";
			$css_code .= "	20% {\n";
			$css_code .= "		transform: translateY(" . $height_direction_inverse . "30px);\n";
			$css_code .= "	}\n";
			$css_code .= "	100% {\n";
			$css_code .= "		transform: translate(" . $height_direction . $animation_out_side_value . $animation_out_side_unit . "," . $height_direction . $animation_out_height_value . $animation_out_height_unit . ");\n" ;
			$css_code .= "	}\n" ;
			$css_code .= "}\n";
		}
	}
	fwrite($animations_style_css_file, $css_code);
	fclose($animations_style_css_file);

	Options_Framework_Notifications::create_datebook_notice_css_stylesheet();

}

}

$Class_DateBook_Notification_Animations_Out = new Class_DateBook_Notification_Animations_Out;

/*
*  Designs
*/

class Class_DateBook_Notification_Designs {

function __construct() {

	add_action( 'datebook_notice_admin_menu', array($this, 'add_menus_to_datebook_notice' ) );
	add_action( 'add_meta_boxes', array($this, 'datebook_designs_create_meta_boxes' ) );
	add_action( 'save_post', array( $this, 'save_datebook_designs_item_meta_box' ), 10, 3);
	// filter
	add_filter( 'hidden_meta_boxes', array( $this, 'datebook_designs_remove_post_meta_boxes' ), 10, 3 );
	add_filter( 'parent_file', array( $this, 'datebook_designs_cpt_parent_file' ) );
	add_filter( 'submenu_file', array( $this, 'datebook_designs_cpt_submenu_file' ) );

}


function add_menus_to_datebook_notice() {

    add_submenu_page( 'edit.php?post_type=datebook_notice', esc_html__( 'Designs', 'datebook' ), esc_html__( 'Designs', 'datebook' ), 'edit_datebook_designs', 'edit.php?post_type=datebook_designs' );

}

function datebook_designs_cpt_parent_file( $parent_file ){

    global $current_screen, $self;

    if ( in_array( $current_screen->base, array( 'post', 'edit' ) ) && 'datebook_designs' == $current_screen->post_type ) {
        $parent_file = 'edit.php?post_type=datebook_notice';
    }

    return $parent_file;

}

function datebook_designs_cpt_submenu_file( $submenu_file ){

    global $current_screen, $self;

    if ( in_array( $current_screen->base, array( 'post', 'edit' ) ) && 'datebook_designs' == $current_screen->post_type ) {
        $submenu_file = 'edit.php?post_type=datebook_designs';
    }

    return $submenu_file;

}

function datebook_designs_remove_post_meta_boxes( $hidden, $screen, $use_defaults ) {

	global $wp_meta_boxes;

	$cpt = 'datebook_designs'; // Modify this to your needs!

	if( $cpt === $screen->id && isset( $wp_meta_boxes[$cpt] ) ) {

		$tmp = array();

		foreach( (array) $wp_meta_boxes[$cpt] as $context_key => $context_item ) {
			foreach( $context_item as $priority_key => $priority_item ) {
				foreach( $priority_item as $metabox_key => $metabox_item ) {
					if ( $metabox_key != 'submitdiv' && $metabox_key != 'designs-boxes-item-meta-box' ) {
						$tmp[] = $metabox_key;
					}
				}
			}
		}
		$hidden = $tmp;  // Override the current user option here.
	}

	return $hidden;

}

function datebook_designs_create_meta_boxes() {

    add_meta_box("designs-boxes-item-meta-box", esc_html__( 'Notification settings', 'datebook' ), array($this, 'datebook_designs_item_meta_box'), "datebook_designs", "normal", "core", null);

}

function datebook_designs_item_meta_box() {

	 wp_nonce_field(basename(__FILE__), "meta-box-nonce");
	 $post = get_post();
	 $post->ID

	 ?>
<form id="formdatebook-notice" method="POST">
	<input type="hidden" name="prevent_delete_meta_movetotrash" id="prevent-delete-meta-movetotrash" value="<?php echo wp_create_nonce(DATEBOOK_URL.$post->ID); ?>" />
	<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
		<tbody>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="text-color">
						<?php echo esc_html__('Text color', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_design_post_option_text_color" type="text" class="datebook-design-post-option-text-color" value="<?php echo get_post_meta( $post->ID, "datebook_design_post_option_text_color", true ); ?>">
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="link-color">
						<?php echo esc_html__('Link color', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_design_post_option_link_color" type="text" class="datebook-design-post-option-link-color" value="<?php echo get_post_meta( $post->ID, "datebook_design_post_option_link_color", true ); ?>">
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="font-size">
						<?php echo esc_html__('Font size', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_design_post_option_font_size" type="number" class="datebook-design-post-option-font-size" value="<?php echo get_post_meta( $post->ID, "datebook_design_post_option_font_size", true ); ?>">
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="background-color">
						<?php echo esc_html__('Background color', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_design_post_option_background_color" type="text" class="datebook-design-post-option-background-color" value="<?php echo get_post_meta( $post->ID, "datebook_design_post_option_background_color", true ); ?>">
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="background-image">
						<?php echo esc_html__('Background image', 'datebook'); ?>
					</label>
				</th>
				<td>
					<input id="datebook-design-post-option-background-image" name="datebook_design_post_option_background_image" type="text" value="<?php echo get_post_meta( $post->ID, "datebook_design_post_option_background_image", true ); ?>" hidden />
					<img id="datebook-design-background-image" src="<?php echo get_post_meta( $post->ID, "datebook_design_post_option_background_image", true ); ?>" alt="<?php echo esc_html__('Background image', 'datebook'); ?>" target="_blank" rel="external" style="max-width: 200px;"><br>
					<input id="upload-button" type="button" class="button" value="<?php echo esc_html__('Upload Image', 'datebook')?>" />
					<span class="button remove-image" id="reset-logo-upload" rel="logo_upload"> <?php echo esc_html__('Remove', 'datebook')?> </span>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="background-size">
						<?php echo esc_html__('Background size', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="datebook_design_post_option_background_size" class="datebook-design-post-option-background-size">
						<?php
								$background_size_option = get_post_meta( $post->ID, "datebook_design_post_option_background_size", true );
								$background_size_options_values = array('', 'auto', 'cover', 'contain');

								foreach($background_size_options_values as $key => $value) {
									if($value == $background_size_option) {
										?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
									} else {
										?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
									}
								}
								?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="background-repeat">
						<?php echo esc_html__('Background repeat', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="datebook_design_post_option_background_repeat" class="datebook-design-post-option-background-repeat">
						<?php
								$background_repeat_option = get_post_meta( $post->ID, "datebook_design_post_option_background_repeat", true );
								$background_repeat_options_values = array('', 'no-repeat', 'repeat');

								foreach($background_repeat_options_values as $key => $value) {
									if($value == $background_repeat_option) {
										?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
									} else {
										?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
									}
								}
								?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="border-radius">
						<?php echo esc_html__('Border radius', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_design_post_option_border_top_left_radius" type="number" class="datebook-design-post-option-border-radius" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_border_top_left_radius", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_border_top_left_radius", true ); } else { echo '5'; } ?>" min="0" >
					↖
					<input name="datebook_design_post_option_border_top_right_radius" type="number" class="datebook-design-post-option-border-radius" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_border_top_right_radius", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_border_top_right_radius", true ); } else { echo '5'; } ?>" min="0" >
					↗
					<input name="datebook_design_post_option_border_bottom_right_radius" type="number" class="datebook-design-post-option-border-radius" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_border_bottom_right_radius", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_border_bottom_right_radius", true ); } else { echo '5'; } ?>" min="0" >
					↘
					<input name="datebook_design_post_option_border_bottom_left_radius" type="number" class="datebook-design-post-option-border-radius" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_border_bottom_left_radius", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_border_bottom_left_radius", true ); } else { echo '5'; } ?>" min="0" >
					↙
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="padding">
						<?php echo esc_html__('Padding', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_design_post_option_padding_top" type="number" class="datebook-design-post-option-padding" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_padding_top", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_padding_top", true ); } else { echo '20'; } ?>" min="0" >
					↑
					<input name="datebook_design_post_option_padding_right" type="number" class="datebook-design-post-option-padding" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_padding_right", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_padding_right", true ); } else { echo '15'; } ?>" min="0" >
					→
					<input name="datebook_design_post_option_padding_bottom" type="number" class="datebook-design-post-option-padding" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_padding_bottom", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_padding_bottom", true ); } else { echo '15'; } ?>" min="0" >
					↓
					<input name="datebook_design_post_option_padding_left" type="number" class="datebook-design-post-option-padding" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_padding_left", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_padding_left", true ); } else { echo '15'; } ?>" min="0" >
					←
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="margin">
						<?php echo esc_html__('Margin', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_design_post_option_margin_top" type="number" class="datebook-design-post-option-margin" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_margin_top", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_margin_top", true ); } else { echo '10'; } ?>" >
					↑
					<input name="datebook_design_post_option_margin_right" type="number" class="datebook-design-post-option-margin" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_margin_right", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_margin_right", true ); } else { echo '0'; } ?>" >
					→
					<input name="datebook_design_post_option_margin_bottom" type="number" class="datebook-design-post-option-margin" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_margin_bottom", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_margin_bottom", true ); } else { echo '0'; } ?>" >
					↓
					<input name="datebook_design_post_option_margin_left" type="number" class="datebook-design-post-option-margin" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_margin_left", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_margin_left", true ); } else { echo '0'; } ?>" >
					←
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="opacity">
						<?php echo esc_html__('Opacity', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_design_post_option_opacity" type="range" class="datebook-design-post-option-opacity" step="0.01" value="<?php if ( get_post_meta( $post->ID, "datebook_design_post_option_opacity", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_design_post_option_opacity", true ); } else { echo '1'; } ?>" min="0" max="1">
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="disable_close">
						<?php echo esc_html__('Disable Close Button', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_notice_close_button_position_option_disable" type="checkbox" value="yes" <?php  if ( get_post_meta( $post->ID, "datebook_notice_close_button_position_option_disable", true ) == 'yes' ) {echo 'checked="checked"';} ?>>
					<label for="datebook_notice_close_button_position_option_disable">
						<?php echo esc_html__('Disable', 'datebook') ?>
					</label>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="button-position">
						<?php echo esc_html__('Button Position', 'datebook')?>
					</label>
				</th>
				<td>
					<select name="datebook_notice_close_button_position_option_side" class="close-button-position-field">
						<?php
								$side = get_post_meta( $post->ID, "datebook_notice_close_button_position_option_side", true );
								$side_values = array('right', 'left');

								foreach($side_values as $key => $value) {
									if($value == $side) {
										?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
									} else {
										?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
									}
								}
								?>
					</select>
					<?php
							if ( get_post_meta( $post->ID, "datebook_notice_close_button_position_option_side_value", true ) == '' ) {
							?>
					<input name="datebook_notice_close_button_position_option_side_value" type="number" class="close-button-position-field" value="5" >
					<?php
							} else {
							?>
					<input name="datebook_notice_close_button_position_option_side_value" type="number" class="close-button-position-field" value="<?php echo get_post_meta( $post->ID, "datebook_notice_close_button_position_option_side_value", true ); ?>" >
					<?php
							}
							?>
					<select name="datebook_notice_close_button_position_option_side_unit" class="close-button-position-field">
						<?php
								$side_unit = get_post_meta( $post->ID, "datebook_notice_close_button_position_option_side_unit", true );
								$side_units_values = array('px', '%');

								foreach($side_units_values as $key => $value) {
									if($value == $side_unit) {
										?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
									} else {
										?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
									}
								}
								?>
					</select>
					<br>
					<select name="datebook_notice_close_button_position_option_height" class="close-button-position-field">
						<?php
								$height = get_post_meta( $post->ID, "datebook_notice_close_button_position_option_height", true );
								$height_values = array('top', 'bottom');

								foreach($height_values as $key => $value) {
									if($value == $height) {
										?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
									} else {
										?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
									}
								}
								?>
					</select>
					<?php
							if ( get_post_meta( $post->ID, "datebook_notice_close_button_position_option_height_value", true ) == '' ) {
							?>
					<input name="datebook_notice_close_button_position_option_height_value" type="number" class="close-button-position-field" value="5" >
					<?php
							} else {
							?>
					<input name="datebook_notice_close_button_position_option_height_value" type="number" class="close-button-position-field" value="<?php echo get_post_meta( $post->ID, "datebook_notice_close_button_position_option_height_value", true ); ?>" >
					<?php
							}
							?>
					<select name="datebook_notice_close_button_position_option_height_unit" class="close-button-position-field">
						<?php
								$height_unit = get_post_meta( $post->ID, "datebook_notice_close_button_position_option_height_unit", true );
								$height_units_values = array('px', '%');

								foreach($height_units_values as $key => $value) {
									if($value == $height_unit) {
										?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
									} else {
										?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
									}
								}
								?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="ButtonSize">
						<?php echo esc_html__('Button Size', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_notice_close_button_size" type="range" class="datebook-notice-close-button-size" step="1" value="<?php if ( get_post_meta( $post->ID, "datebook_notice_close_button_size", true ) != '' ) { echo get_post_meta( $post->ID, "datebook_notice_close_button_size", true ); } else { echo '15'; } ?>" min="10" max="64">
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="close-button-color">
						<?php echo esc_html__('Button color', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_notice_close_button_color" type="text" class="datebook-close-button-color" value="<?php echo get_post_meta( $post->ID, "datebook_notice_close_button_color", true ); ?>">
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="close-button-background-color">
						<?php echo esc_html__('Button Background color', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_notice_close_button_background_color" type="text" class="datebook-close-button-background-color" value="<?php echo get_post_meta( $post->ID, "datebook_notice_close_button_background_color", true ); ?>">
				</td>
			</tr>
		</tbody>
	</table>
</form>
<?php
}

function save_datebook_designs_item_meta_box( $post_id, $post) {

	if (!isset($_POST["meta-box-nonce"]) || !wp_verify_nonce($_POST["meta-box-nonce"], basename(__FILE__)))
		return $post_id;

	$slug = "datebook_designs";
	if($slug != $post->post_type)
		return $post_id;

	update_post_meta($post_id, "datebook_design_post_option_class_name", sanitize_text_field('datebook-notice-class-' . $post_id));
	$datebook_design_post_option_text_color = isset($_POST["datebook_design_post_option_text_color"]) ? $_POST["datebook_design_post_option_text_color"] : '';
	update_post_meta($post_id, "datebook_design_post_option_text_color", sanitize_text_field($datebook_design_post_option_text_color));
	$datebook_design_post_option_link_color = isset($_POST["datebook_design_post_option_link_color"]) ? $_POST["datebook_design_post_option_link_color"] : '';
	update_post_meta($post_id, "datebook_design_post_option_link_color", sanitize_text_field($datebook_design_post_option_link_color));
	$datebook_design_post_option_font_size = isset($_POST["datebook_design_post_option_font_size"]) ? $_POST["datebook_design_post_option_font_size"] : '';
	update_post_meta($post_id, "datebook_design_post_option_font_size", sanitize_text_field($datebook_design_post_option_font_size));
	$datebook_design_post_option_background_color = isset($_POST["datebook_design_post_option_background_color"]) ? $_POST["datebook_design_post_option_background_color"] : '';
	update_post_meta($post_id, "datebook_design_post_option_background_color", sanitize_text_field($datebook_design_post_option_background_color));
	$datebook_design_post_option_background_image = isset($_POST["datebook_design_post_option_background_image"]) ? $_POST["datebook_design_post_option_background_image"] : '';
	update_post_meta($post_id, "datebook_design_post_option_background_image", sanitize_text_field($datebook_design_post_option_background_image));
	$datebook_design_post_option_background_size = isset($_POST["datebook_design_post_option_background_size"]) ? $_POST["datebook_design_post_option_background_size"] : '';
	update_post_meta($post_id, "datebook_design_post_option_background_size", sanitize_text_field($datebook_design_post_option_background_size));
	$datebook_design_post_option_background_repeat = isset($_POST["datebook_design_post_option_background_repeat"]) ? $_POST["datebook_design_post_option_background_repeat"] : '';
	update_post_meta($post_id, "datebook_design_post_option_background_repeat", sanitize_text_field($datebook_design_post_option_background_repeat));
	$datebook_design_post_option_border_top_left_radius = isset($_POST["datebook_design_post_option_border_top_left_radius"]) ? $_POST["datebook_design_post_option_border_top_left_radius"] : '';
	update_post_meta($post_id, "datebook_design_post_option_border_top_left_radius", sanitize_text_field($datebook_design_post_option_border_top_left_radius));
	$datebook_design_post_option_border_top_right_radius = isset($_POST["datebook_design_post_option_border_top_right_radius"]) ? $_POST["datebook_design_post_option_border_top_right_radius"] : '';
	update_post_meta($post_id, "datebook_design_post_option_border_top_right_radius", sanitize_text_field($datebook_design_post_option_border_top_right_radius));
	$datebook_design_post_option_border_bottom_right_radius = isset($_POST["datebook_design_post_option_border_bottom_right_radius"]) ? $_POST["datebook_design_post_option_border_bottom_right_radius"] : '';
	update_post_meta($post_id, "datebook_design_post_option_border_bottom_right_radius", sanitize_text_field($datebook_design_post_option_border_bottom_right_radius));
	$datebook_design_post_option_border_bottom_left_radius = isset($_POST["datebook_design_post_option_border_bottom_left_radius"]) ? $_POST["datebook_design_post_option_border_bottom_left_radius"] : '';
	update_post_meta($post_id, "datebook_design_post_option_border_bottom_left_radius", sanitize_text_field($datebook_design_post_option_border_bottom_left_radius));
	$datebook_design_post_option_padding_top = isset($_POST["datebook_design_post_option_padding_top"]) ? $_POST["datebook_design_post_option_padding_top"] : '';
	update_post_meta($post_id, "datebook_design_post_option_padding_top", sanitize_text_field($datebook_design_post_option_padding_top));
	$datebook_design_post_option_padding_right = isset($_POST["datebook_design_post_option_padding_right"]) ? $_POST["datebook_design_post_option_padding_right"] : '';
	update_post_meta($post_id, "datebook_design_post_option_padding_right", sanitize_text_field($datebook_design_post_option_padding_right));
	$datebook_design_post_option_padding_bottom = isset($_POST["datebook_design_post_option_padding_bottom"]) ? $_POST["datebook_design_post_option_padding_bottom"] : '';
	update_post_meta($post_id, "datebook_design_post_option_padding_bottom", sanitize_text_field($datebook_design_post_option_padding_bottom));
	$datebook_design_post_option_padding_left = isset($_POST["datebook_design_post_option_padding_left"]) ? $_POST["datebook_design_post_option_padding_left"] : '';
	update_post_meta($post_id, "datebook_design_post_option_padding_left", sanitize_text_field($datebook_design_post_option_padding_left));
	$datebook_design_post_option_margin_top = isset($_POST["datebook_design_post_option_margin_top"]) ? $_POST["datebook_design_post_option_margin_top"] : '';
	update_post_meta($post_id, "datebook_design_post_option_margin_top", sanitize_text_field($datebook_design_post_option_margin_top));
	$datebook_design_post_option_margin_right = isset($_POST["datebook_design_post_option_margin_right"]) ? $_POST["datebook_design_post_option_margin_right"] : '';
	update_post_meta($post_id, "datebook_design_post_option_margin_right", sanitize_text_field($datebook_design_post_option_margin_right));
	$datebook_design_post_option_margin_bottom = isset($_POST["datebook_design_post_option_margin_bottom"]) ? $_POST["datebook_design_post_option_margin_bottom"] : '';
	update_post_meta($post_id, "datebook_design_post_option_margin_bottom", sanitize_text_field($datebook_design_post_option_margin_bottom));
	$datebook_design_post_option_margin_left = isset($_POST["datebook_design_post_option_margin_left"]) ? $_POST["datebook_design_post_option_margin_left"] : '';
	update_post_meta($post_id, "datebook_design_post_option_margin_left", sanitize_text_field($datebook_design_post_option_margin_left));
	$datebook_design_post_option_opacity = isset($_POST["datebook_design_post_option_opacity"]) ? $_POST["datebook_design_post_option_opacity"] : '';
	update_post_meta($post_id, "datebook_design_post_option_opacity", sanitize_text_field($datebook_design_post_option_opacity));
	$datebook_notice_close_button_position_option_side = isset($_POST["datebook_notice_close_button_position_option_side"]) ? $_POST["datebook_notice_close_button_position_option_side"] : '';
	update_post_meta($post_id, "datebook_notice_close_button_position_option_side", sanitize_text_field($datebook_notice_close_button_position_option_side));
	$datebook_notice_close_button_position_option_side_value = isset($_POST["datebook_notice_close_button_position_option_side_value"]) ? $_POST["datebook_notice_close_button_position_option_side_value"] : '';
	update_post_meta($post_id, "datebook_notice_close_button_position_option_side_value", sanitize_text_field($datebook_notice_close_button_position_option_side_value));
	$datebook_notice_close_button_position_option_side_unit = isset($_POST["datebook_notice_close_button_position_option_side_unit"]) ? $_POST["datebook_notice_close_button_position_option_side_unit"] : '';
	update_post_meta($post_id, "datebook_notice_close_button_position_option_side_unit", sanitize_text_field($datebook_notice_close_button_position_option_side_unit));
	$datebook_notice_close_button_position_option_height = isset($_POST["datebook_notice_close_button_position_option_height"]) ? $_POST["datebook_notice_close_button_position_option_height"] : '';
	update_post_meta($post_id, "datebook_notice_close_button_position_option_height", sanitize_text_field($datebook_notice_close_button_position_option_height));
	$datebook_notice_close_button_position_option_height_value = isset($_POST["datebook_notice_close_button_position_option_height_value"]) ? $_POST["datebook_notice_close_button_position_option_height_value"] : '';
	update_post_meta($post_id, "datebook_notice_close_button_position_option_height_value", sanitize_text_field($datebook_notice_close_button_position_option_height_value));
	$datebook_notice_close_button_position_option_height_unit = isset($_POST["datebook_notice_close_button_position_option_height_unit"]) ? $_POST["datebook_notice_close_button_position_option_height_unit"] : '';
	update_post_meta($post_id, "datebook_notice_close_button_position_option_height_unit", $datebook_notice_close_button_position_option_height_unit);
	$datebook_notice_close_button_size = isset($_POST["datebook_notice_close_button_size"]) ? $_POST["datebook_notice_close_button_size"] : '';
	update_post_meta($post_id, "datebook_notice_close_button_size", sanitize_text_field($datebook_notice_close_button_size));
	$datebook_notice_close_button_color = isset($_POST["datebook_notice_close_button_color"]) ? $_POST["datebook_notice_close_button_color"] : '';
	update_post_meta($post_id, "datebook_notice_close_button_color", sanitize_text_field($datebook_notice_close_button_color));
	$datebook_notice_close_button_background_color = isset($_POST["datebook_notice_close_button_background_color"]) ? $_POST["datebook_notice_close_button_background_color"] : '';
	update_post_meta($post_id, "datebook_notice_close_button_background_color", sanitize_text_field($datebook_notice_close_button_background_color));
	$datebook_notice_close_button_position_option_disable = (isset($_POST["datebook_notice_close_button_position_option_disable"])) ? $_POST["datebook_notice_close_button_position_option_disable"] : null;
	update_post_meta($post_id, "datebook_notice_close_button_position_option_disable", sanitize_text_field($datebook_notice_close_button_position_option_disable));

	$designs_style_css_file = fopen( DATEBOOK_DIR . "framework/css/notification/parts/designs_style.css", "w") or die("Unable to open file!");
	$posts_datebook_designs = get_posts(array(
		'posts_per_page'=> -1,
		'post_type' => 'datebook_designs',
	));

	$css_code = "\n";
	$css_code .= "\n";

	foreach ( $posts_datebook_designs as $post_datebook_design ) {
		$css_code .= '.' . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_class_name", true ) . " {\n" ;
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_text_color", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "color: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_text_color", true ) . "!important;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_font_size", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "font-size: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_font_size", true ) . "px!important;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_background_color", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "background-color: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_background_color", true ) . ";\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_background_image", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "background-image: url(" . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_background_image", true ) . ");\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_background_size", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "background-size: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_background_size", true ) . ";\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_background_repeat", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "background-repeat: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_background_repeat", true ) . ";\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_border_top_left_radius", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "border-top-left-radius: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_border_top_left_radius", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_border_top_right_radius", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "border-top-right-radius: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_border_top_right_radius", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_border_bottom_right_radius", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "border-bottom-right-radius: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_border_bottom_right_radius", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_border_bottom_left_radius", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "border-bottom-left-radius: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_border_bottom_left_radius", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_padding_top", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "padding-top: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_padding_top", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_padding_right", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "padding-right: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_padding_right", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_padding_bottom", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "padding-bottom: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_padding_bottom", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_padding_left", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "padding-left: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_padding_left", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_margin_top", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "margin-top: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_margin_top", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_margin_right", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "margin-right: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_margin_right", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_margin_bottom", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "margin-bottom: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_margin_bottom", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_margin_left", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "margin-left: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_margin_left", true ) . "px;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_opacity", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "opacity: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_opacity", true ) . ";\n" ;
		}
		$css_code .= "}\n";

		if ( get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_link_color", true ) != '' ) {
			$css_code .= '.' . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_class_name", true ) . " a {\n" ;
			$css_code .= "\t";
			$css_code .= "color: " . get_post_meta( $post_datebook_design->ID, "datebook_design_post_option_link_color", true ) . "!important;\n" ;
			$css_code .= "}\n";
		}

		$css_code .= '.close-datebook-notice-' . $post_datebook_design->ID . " {\n" ;
		$css_code .= "\t";
		$css_code .= get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_position_option_side", true ) . ': ' . get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_position_option_side_value", true ) . get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_position_option_side_unit", true ) .";\n" ;
		$css_code .= "\t";
		$css_code .= get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_position_option_height", true ) . ': ' . get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_position_option_height_value", true ) . get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_position_option_height_unit", true ) .";\n" ;
		$css_code .= "\t";
		$css_code .= "font-size: " . get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_size", true ) . "px!important;\n" ;
		$css_code .= "\t";
		$css_code .= "line-height: " . get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_size", true ) . "px!important;\n" ;
		$css_code .= "\t";
		$css_code .= "width: " . get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_size", true ) . "px!important;\n" ;
		if ( get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_color", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "color: " . get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_color", true ) . "!important;\n" ;
		}
		if ( get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_background_color", true ) != '' ) {
			$css_code .= "\t";
			$css_code .= "background-color: " . get_post_meta( $post_datebook_design->ID, "datebook_notice_close_button_background_color", true ) . "!important;\n" ;
		}
		$css_code .= "}\n";
	}

	fwrite($designs_style_css_file, $css_code);
	fclose($designs_style_css_file);

	Options_Framework_Notifications::create_datebook_notice_css_stylesheet();

}

}

$Class_DateBook_Notification_Designs = new Class_DateBook_Notification_Designs;

/*
 *  Locations
 */

class Class_DateBook_Notification_Locations {

function __construct() {

	add_action( 'datebook_notice_admin_menu', array($this, 'add_menus_to_datebook_notice' ) );
	add_action( 'add_meta_boxes', array($this, 'datebook_locations_create_meta_boxes' ) );
	add_action( 'save_post', array( $this, 'save_datebook_locations_item_meta_box' ), 10, 3);
	// filter
	add_filter( 'hidden_meta_boxes', array( $this, 'datebook_locations_remove_post_meta_boxes' ), 10, 3 );
	add_filter( 'parent_file', array( $this, 'datebook_locations_cpt_parent_file' ) );
	add_filter( 'submenu_file', array( $this, 'datebook_locations_cpt_submenu_file' ) );

}

function add_menus_to_datebook_notice() {

    add_submenu_page( 'edit.php?post_type=datebook_notice', esc_html__( 'Locations', 'datebook' ), esc_html__( 'Locations', 'datebook' ), 'edit_datebook_locations', 'edit.php?post_type=datebook_locations' );

}


function datebook_locations_remove_post_meta_boxes( $hidden, $screen, $use_defaults ) {

	global $wp_meta_boxes;

	$cpt = 'datebook_locations'; // Modify this to your needs!

	if( $cpt === $screen->id && isset( $wp_meta_boxes[$cpt] ) ) {
		$tmp = array();
		foreach( (array) $wp_meta_boxes[$cpt] as $context_key => $context_item ) {
			foreach( $context_item as $priority_key => $priority_item ) {
				foreach( $priority_item as $metabox_key => $metabox_item ) {
					if ( $metabox_key != 'submitdiv' && $metabox_key != 'locations-boxes-item-meta-box' ) {
						$tmp[] = $metabox_key;
					}
				}
			}
		}
		$hidden = $tmp;  // Override the current user option here.
	}

	return $hidden;

}

function datebook_locations_create_meta_boxes() {

    add_meta_box("locations-boxes-item-meta-box", esc_html__( 'Notification settings', 'datebook' ), array($this, 'datebook_locations_item_meta_box'), "datebook_locations", "normal", "core", null);

}

function datebook_locations_cpt_parent_file( $parent_file ){

    global $current_screen, $self;

    if ( in_array( $current_screen->base, array( 'post', 'edit' ) ) && 'datebook_locations' == $current_screen->post_type ) {
        $parent_file = 'edit.php?post_type=datebook_notice';
    }

    return $parent_file;

}

function datebook_locations_cpt_submenu_file( $submenu_file ){

    global $current_screen, $self;

    if ( in_array( $current_screen->base, array( 'post', 'edit' ) ) && 'datebook_locations' == $current_screen->post_type ) {
        $submenu_file = 'edit.php?post_type=datebook_locations';
    }

    return $submenu_file;

}

function datebook_locations_item_meta_box() {

	 wp_nonce_field(basename(__FILE__), "meta-box-nonce");
	 $post = get_post();
	 $post->ID

	 ?>
<form id="formdatebook-notice" method="POST">
	<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
		<input type="hidden" name="prevent_delete_meta_movetotrash" id="prevent-delete-meta-movetotrash" value="<?php echo wp_create_nonce(DATEBOOK_URL.$post->ID); ?>" />
		<tbody>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="width">
						<?php echo esc_html__('Width', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_location_post_option_width" type="number" class="datebook-location-post-option-width" value="<?php echo get_post_meta( $post->ID, "datebook_location_post_option_width", true ); ?>" min="1" >
					<select name="datebook_location_post_option_width_unit" class="datebook-location-post-option-width-unit">
						<?php
						$width_unit = get_post_meta( $post->ID, "datebook_location_post_option_width_unit", true );
						$width_units_values = array('px', '%');

						foreach($width_units_values as $key => $value) {
							if($value == $width_unit) {
								?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
							} else {
								?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
							}
						}
						?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="position">
						<?php echo esc_html__('Position', 'datebook')?>
					</label>
				</th>
				<td>
					<select id="datebook-location-post-option-side" name="datebook_location_post_option_side" class="datebook-location-post-option-side" data-hide-options>
						<?php
						$side = get_post_meta( $post->ID, "datebook_location_post_option_side", true );
						$side_values = array('right', 'left', 'center');

						foreach($side_values as $key => $value) {
							if($value == $side) {
								?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
							} else {
								?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
							}
						}
						?>
					</select>
					<?php
					if ( get_post_meta( $post->ID, "datebook_location_post_option_side_value", true ) == '' ) {
					?>
					<input id="datebook-location-post-option-side-value" name="datebook_location_post_option_side_value" type="number" class="datebook-location-post-option-side-value hidden-option" value="0" <?php if(get_post_meta( $post->ID, "datebook_location_post_option_side", true )== 'center') {echo 'style="display: none;"';} ?>>
					<?php
					} else {
					?>
					<input id="datebook-location-post-option-side-value" name="datebook_location_post_option_side_value" type="number" class="datebook-location-post-option-side-value hidden-option" value="<?php echo get_post_meta( $post->ID, "datebook_location_post_option_side_value", true ); ?>" <?php if(get_post_meta( $post->ID, "datebook_location_post_option_side", true )== 'center') {echo 'style="display: none;"';} ?>>
					<?php
					}
					?>
					<select id="datebook-location-post-option-side-unit" name="datebook_location_post_option_side_unit" class="datebook-location-post-option-side-unit hidden-option" <?php if(get_post_meta( $post->ID, "datebook_location_post_option_side", true )== 'center') {echo 'style="display: none;"';} ?>>
						<?php
						$side_unit = get_post_meta( $post->ID, "datebook_location_post_option_side_unit", true );
						$side_units_values = array('px', '%');

						foreach($side_units_values as $key => $value) {
							if($value == $side_unit) {
								?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
							} else {
								?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
							}
						}
						?>
					</select>
					<br>
					<select name="datebook_location_post_option_height" class="datebook-location-post-option-height">
						<?php
						$height = get_post_meta( $post->ID, "datebook_location_post_option_height", true );
						$height_values = array('top', 'bottom');

						foreach($height_values as $key => $value) {
							if($value == $height) {
								?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
							} else {
								?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
							}
						}
						?>
					</select>
					<?php
					if ( get_post_meta( $post->ID, "datebook_location_post_option_height_value", true ) == '' ) {
					?>
					<input name="datebook_location_post_option_height_value" type="number" class="datebook-location-post-option-height-value" value="100" >
					<?php
					} else {
					?>
					<input name="datebook_location_post_option_height_value" type="number" class="datebook-location-post-option-height-value" value="<?php echo get_post_meta( $post->ID, "datebook_location_post_option_height_value", true ); ?>" >
					<?php
					}
					?>
					<select name="datebook_location_post_option_height_unit" class="datebook-location-post-option-height-unit">
						<?php
						$height_unit = get_post_meta( $post->ID, "datebook_location_post_option_height_unit", true );
						$height_units_values = array('px', '%');

						foreach($height_units_values as $key => $value) {
							if($value == $height_unit) {
								?>
						<option selected><?php echo esc_attr($value); ?></option>
						<?php
							} else {
								?>
						<option><?php echo esc_attr($value); ?></option>
						<?php
							}
						}
						?>
					</select>
				</td>
			</tr>
			<tr class="form-field">
				<th valign="top" scope="row">
					<label for="z_index">
						<?php echo esc_html__('Front order', 'datebook')?>
					</label>
				</th>
				<td>
					<input name="datebook_location_post_option_z_index" type="number" class="datebook-location-post-option-z-index" value="<?php echo get_post_meta( $post->ID, "datebook_location_post_option_z_index", true ); ?>" min="1" >
				</td>
			</tr>
		</tbody>
	</table>
</form>
<?php
}

function save_datebook_locations_item_meta_box( $post_id, $post) {

	if (!isset($_POST["meta-box-nonce"]) || !wp_verify_nonce($_POST["meta-box-nonce"], basename(__FILE__)))
		return $post_id;

	$slug = "datebook_locations";

	if($slug != $post->post_type)
		return $post_id;

	update_post_meta($post_id, "datebook_location_id", sanitize_text_field($post_id));
	$datebook_location_post_option_width = isset($_POST["datebook_location_post_option_width"]) ? $_POST["datebook_location_post_option_width"] : '';
	update_post_meta($post_id, "datebook_location_post_option_width", sanitize_text_field($datebook_location_post_option_width));
	$datebook_location_post_option_width_unit = isset($_POST["datebook_location_post_option_width_unit"]) ? $_POST["datebook_location_post_option_width_unit"] : '';
	update_post_meta($post_id, "datebook_location_post_option_width_unit", sanitize_text_field($datebook_location_post_option_width_unit));
	$datebook_location_post_option_side = isset($_POST["datebook_location_post_option_side"]) ? $_POST["datebook_location_post_option_side"] : '';
	update_post_meta($post_id, "datebook_location_post_option_side", sanitize_text_field($datebook_location_post_option_side));
	$datebook_location_post_option_side_value = isset($_POST["datebook_location_post_option_side_value"]) ? $_POST["datebook_location_post_option_side_value"] : '';
	update_post_meta($post_id, "datebook_location_post_option_side_value", sanitize_text_field($datebook_location_post_option_side_value));
	$datebook_location_post_option_side_unit = isset($_POST["datebook_location_post_option_side_unit"]) ? $_POST["datebook_location_post_option_side_unit"] : '';
	update_post_meta($post_id, "datebook_location_post_option_side_unit", sanitize_text_field($datebook_location_post_option_side_unit));
	$datebook_location_post_option_height = isset($_POST["datebook_location_post_option_height"]) ? $_POST["datebook_location_post_option_height"] : '';
	update_post_meta($post_id, "datebook_location_post_option_height", sanitize_text_field($datebook_location_post_option_height));
	$datebook_location_post_option_height_value = isset($_POST["datebook_location_post_option_height_value"]) ? $_POST["datebook_location_post_option_height_value"] : '';
	update_post_meta($post_id, "datebook_location_post_option_height_value", sanitize_text_field($datebook_location_post_option_height_value));
	$datebook_location_post_option_height_unit = isset($_POST["datebook_location_post_option_height_unit"]) ? $_POST["datebook_location_post_option_height_unit"] : '';
	update_post_meta($post_id, "datebook_location_post_option_height_unit", sanitize_text_field($datebook_location_post_option_height_unit));
	$datebook_location_post_option_z_index = isset($_POST["datebook_location_post_option_z_index"]) ? $_POST["datebook_location_post_option_z_index"] : '';
	update_post_meta($post_id, "datebook_location_post_option_z_index", sanitize_text_field($datebook_location_post_option_z_index));



	$locations_style_css_file = fopen( DATEBOOK_DIR . "framework/css/notification/parts/locations_style.css", "w") or die("Unable to open file!");
	$posts_datebook_locations = get_posts(array(
		'posts_per_page'=> -1,
		'post_type' => 'datebook_locations',
	));

	$css_code = "\n";
	$css_code .= "\n";

	foreach ( $posts_datebook_locations as $post_datebook_location ) {
		$css_code .= '#datebook-notice-location-id-' . get_post_meta( $post_datebook_location->ID, "datebook_location_id", true ) . " {\n" ;
		$css_code .= "\t";
		$css_code .= "position: fixed;\n";
		$css_code .= "\t";
		$css_code .= "width: " . get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_width", true ) . get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_width_unit", true ) .";\n" ;
		if ( get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_side", true ) == 'center' ) {
			$css_code .= "\t";
			$css_code .= "right: 50%;\n";
			$css_code .= "\t";
			$css_code .= "margin-right: -" . get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_width", true ) / 2 . get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_width_unit", true ) .";\n";
		} else {
			$css_code .= "\t";
			$css_code .= get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_side", true ) . ': ' . get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_side_value", true ) . get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_side_unit", true ) .";\n" ;
		}
		$css_code .= "\t";
		$css_code .= get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_height", true ) . ': ' . get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_height_value", true ) . get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_height_unit", true ) .";\n" ;
		$css_code .= "\t";
		$css_code .= "z-index: 99" . get_post_meta( $post_datebook_location->ID, "datebook_location_post_option_z_index", true ) .";\n" ;
		$css_code .= "}\n";
	}

	fwrite($locations_style_css_file, $css_code);
	fclose($locations_style_css_file);

	Options_Framework_Notifications::create_datebook_notice_css_stylesheet();

}


}

$Class_DateBook_Notification_Locations = new Class_DateBook_Notification_Locations;


/*-------------------class start------------------*/

class Class_DateBook_Notification_Admin {

function __construct() {
	
	add_action( 'admin_menu', array($this, 'datebook_notice_admin_menu' ) );
	add_action( 'save_post', array($this, 'save_post_type_values' ) );
	add_action( 'before_delete_post', array($this, 'delete_post_row' ) );
	add_action( 'manage_pages_custom_column' , array( $this, 'datebook_notice_custom_columns' ), 10, 2 );
	add_filter( 'manage_datebook_notice_posts_columns' , array( $this, 'datebook_notice_columns' ) );
	add_action( 'add_meta_boxes', array( $this, 'add_individual_control_meta_box' ) );
	add_action( 'save_post', array( $this, 'save_individual_control_meta_box' ), 10, 3);
	add_action( 'admin_enqueue_scripts', array($this, 'add_admin_style') );
	// filter
	add_filter( 'post_updated_messages', array($this, 'datebook_notice_update_messages' ) );
	add_filter( 'hidden_meta_boxes', array( $this, 'datebook_notice_remove_post_meta_boxes' ), 10, 3 );

}

function add_admin_style() {

    $screen = get_current_screen();

	if (isset($screen->id)) {

	    if ( $screen->id == 'datebook_notice' || $screen->id == 'datebook_animations' || $screen->id == 'datebook_animouts' || $screen->id == 'datebook_designs' || $screen->id == 'datebook_locations' ) {

			$datebook_notice_css_ver = date("ymd-Gis", filemtime( DATEBOOK_DIR . 'framework/css/notification/admin-datebook-notice.css' ));
			wp_register_style( 'datebook-notice-style', DATEBOOK_URL . 'framework/css/notification/admin-datebook-notice.css', false, $datebook_notice_css_ver );
			wp_enqueue_style( 'datebook-notice-style' );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_media();

			wp_enqueue_script( 'wp-color-picker' );
			$datebook_notice_js_ver  = date("ymd-Gis", filemtime( DATEBOOK_DIR . 'framework/js/notification/admin-datebook-notice.js' ));
			wp_register_script( 'datebook-notice-js', DATEBOOK_URL . 'framework/js/notification/admin-datebook-notice.js', array(), $datebook_notice_js_ver );
			wp_enqueue_script( 'datebook-notice-js' );

	        wp_dequeue_script( 'autosave' );
	    }
    }
}

function save_post_type_values() {

    if( get_post_type() == 'datebook_notice' ) {

		global $wpdb;

		$post = get_post();

		$table_name = strtolower($wpdb->prefix) . 'datebook_notifications'; // do not forget about tables prefix
		$notification_box = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table_name WHERE post_ID = %d", $post->ID) );
		$post_id = (isset($notification_box->post_ID)) ? $notification_box->post_ID : null;
		$post_types = get_post_types( array( 'public' => true ) );

		$notification_box_post_types = '';

		foreach ( $post_types as $post_type => $post_type_name ) {

			$post_type_name_atr = (isset($_POST[$post_type])) ? sanitize_text_field( $_POST[$post_type] ) : null;

			if ($post_type_name_atr != null) {

				$check_post_type = strpos($post_type_name_atr, $post_type);

				if ($check_post_type !== false) {

					$notification_box_post_types .= sanitize_text_field( $post_type_name_atr . ' ,  ' );

				}
			}
		}
		$prevent_delete_meta_movetotrash = (isset($_POST['prevent_delete_meta_movetotrash'])) ? $_POST['prevent_delete_meta_movetotrash'] : null;
		if (!wp_verify_nonce($prevent_delete_meta_movetotrash, DATEBOOK_URL.$post->ID)) { return $post_id; }

		if ( $post_id == $post->ID ) {

			$notification_box_id = $notification_box->id;
			$notification_box_title = sanitize_text_field( isset($_POST['post_title']) ? $_POST['post_title'] : '' );
			$notification_box_display_in = $notification_box_post_types;
			$notification_box_location = sanitize_text_field( isset($_POST['location']) ? $_POST['location'] : '' );
			$notification_box_design = sanitize_text_field( isset($_POST['design']) ? $_POST['design'] : '' );
			$notification_box_animation = sanitize_text_field( isset($_POST['animation']) ? $_POST['animation'] : '' );
			$notification_box_animation_out = sanitize_text_field( isset($_POST['animation_out']) ? $_POST['animation_out'] : '' );
			$notification_box_delay = sanitize_text_field( isset($_POST['delay']) ? $_POST['delay'] : '');
			$notification_box_show_time = sanitize_text_field( isset($_POST['show_time']) ? $_POST['show_time'] : '' );
			$notification_box_enabled = sanitize_text_field( isset($_POST['enabled']) ? $_POST['enabled'] : '' );
			$notification_box_user_types = sanitize_text_field( isset($_POST['user_types']) ? $_POST['user_types'] : '' );
			$notification_box_device_class = sanitize_text_field( isset($_POST['devices']) ? $_POST['devices'] : '' );
			$wpdb->update ( $table_name, array(
			        'title' => $notification_box_title,
			        'display_in' => $notification_box_display_in,
					'location_id' => $notification_box_location,
			        'design_id' => $notification_box_design,
			        'animation_id' => $notification_box_animation,
			        'animation_out_id' => $notification_box_animation_out,
					'delay' => $notification_box_delay,
					'show_time' => $notification_box_show_time,
			        'enabled' => $notification_box_enabled,
			        'user_types' => $notification_box_user_types,
					'device_class' => $notification_box_device_class

			), array('id' => $notification_box_id));

		} else {

			$notification_box_title = sanitize_text_field( isset($_POST['post_title']) ? $_POST['post_title'] : '' );
			$notification_box_display_in = $notification_box_post_types;
			$notification_box_location = sanitize_text_field( isset($_POST['location']) ? $_POST['location'] : '' );
			$notification_box_design = sanitize_text_field( isset($_POST['design']) ? $_POST['design'] : '' );
			$notification_box_animation = sanitize_text_field( isset($_POST['animation']) ? $_POST['animation'] : '' );
			$notification_box_animation_out = sanitize_text_field( isset($_POST['animation_out']) ? $_POST['animation_out'] : '' );
			$notification_box_delay = sanitize_text_field( isset($_POST['delay']) ? $_POST['delay'] : '' );
			$notification_box_show_time = sanitize_text_field( isset($_POST['show_time']) ? $_POST['show_time'] : '' );
			$notification_box_enabled = sanitize_text_field( isset($_POST['enabled']) ? $_POST['enabled'] : '' );
			$notification_box_user_types = sanitize_text_field( isset($_POST['user_types']) ? $_POST['user_types'] : '' );
			$notification_box_device_class = sanitize_text_field( isset($_POST['devices']) ? $_POST['devices'] : '' );
			$wpdb->insert ( $table_name, array(
			        'post_ID' => $post->ID,
			        'title' => $post->post_title,
			        'display_in' => $notification_box_display_in,
					'location_id' => $notification_box_location,
			        'design_id' => $notification_box_design,
			        'animation_id' => $notification_box_animation,
					'animation_out_id' => $notification_box_animation_out,
					'delay' => $notification_box_delay,
					'show_time' => $notification_box_show_time,
			        'enabled' => $notification_box_enabled,
			        'user_types' => $notification_box_user_types,
					'device_class' => $notification_box_device_class
			));
		}

		$datebook_notice_post_limitations_datebook_notice_option = isset($_POST["limitations_datebook_notice_option"]) ? $_POST["limitations_datebook_notice_option"] : '';
		update_post_meta($post_id, "limitations_datebook_notice_option", sanitize_text_field($datebook_notice_post_limitations_datebook_notice_option));
		$datebook_notice_post_times_custom_limitations_datebook_notice_option = isset($_POST["times_custom_limitations_datebook_notice_option"]) ? $_POST["times_custom_limitations_datebook_notice_option"] : '';
		update_post_meta($post_id, "times_custom_limitations_datebook_notice_option", sanitize_text_field($datebook_notice_post_times_custom_limitations_datebook_notice_option));
		$datebook_notice_post_days_custom_limitations_datebook_notice_option = isset($_POST["days_custom_limitations_datebook_notice_option"]) ? $_POST["days_custom_limitations_datebook_notice_option"] : '';
		update_post_meta($post_id, "days_custom_limitations_datebook_notice_option", sanitize_text_field($datebook_notice_post_days_custom_limitations_datebook_notice_option));
		$datebook_notice_post_click_on_close_button_datebook_notice_option = isset($_POST["click_on_close_button_datebook_notice_option"]) ? $_POST["click_on_close_button_datebook_notice_option"] : '';
		update_post_meta($post_id, "click_on_close_button_datebook_notice_option", sanitize_text_field($datebook_notice_post_click_on_close_button_datebook_notice_option));
		$datebook_notice_post_days_click_on_close_button_datebook_notice_option = isset($_POST["days_click_on_close_button_datebook_notice_option"]) ? $_POST["days_click_on_close_button_datebook_notice_option"] : '';
		update_post_meta($post_id, "days_click_on_close_button_datebook_notice_option", sanitize_text_field($datebook_notice_post_days_click_on_close_button_datebook_notice_option));

		Options_Framework_Notifications::create_datebook_notice_css_stylesheet();
	}
}

function delete_post_row($delete_row){

    if( get_post_type() == 'datebook_notice' ) {

	global $wpdb;
	$post = get_post();
	$table_name = strtolower($wpdb->prefix) . 'datebook_notifications';

	$delete_row = "DELETE FROM $table_name WHERE post_ID= $post->ID";
	$wpdb->query($delete_row);
    }
}

public function datebook_notice_admin_menu() {
    // add_menu_page( esc_html__( 'Notification', 'datebook' ), esc_html__( 'Notification', 'datebook' ), 'edit_datebook_notices', 'edit.php?post_type=datebook_notice', '', 'dashicons-welcome-add-page' );
    do_action ( 'datebook_notice_admin_menu' );
	// add_submenu_page( 'edit.php?post_type=datebook_notice', esc_html__( 'Add ons', 'datebook' ), esc_html__( 'Add ons', 'datebook' ), 'edit_datebook_notices', 'edit.php?post_type=datebook_notice_add_ons' );
}


function datebook_notice_columns($columns) {
	unset(
		$columns['date'],
		$columns['comments']
	);
	$new_columns = array(
		'enabled' => esc_html__('Enabled', 'datebook'),
		'display_in' => esc_html__('Published in', 'datebook'),
		'devices' => esc_html__('Devices', 'datebook'),
		'location' => esc_html__('Location', 'datebook'),
		'delay' => esc_html__('Delay', 'datebook'),
		'show_time' => esc_html__('Show Time', 'datebook'),
	);
    return array_merge($columns, $new_columns);
}

function datebook_notice_custom_columns( $column, $post_id ) {

    global $wpdb;

	$table_name = strtolower($wpdb->prefix) . 'datebook_notifications';
	$notification_box = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table_name WHERE post_ID = %d", $post_id) );

    switch ( $column ) {

    case 'enabled' :
		$notification_notice_enabled = $notification_box->enabled;
        echo esc_attr($notification_notice_enabled);
        break;

    case 'display_in' :
		$notification_notice_display_in = $notification_box->display_in;
        echo esc_attr($notification_notice_display_in);
        break;

    case 'devices' :
		$notification_notice_devices = $notification_box->device_class;
        echo esc_attr($notification_notice_devices);
        break;

    case 'location' :
		$notification_notice_location = $notification_box->location_id;
		if ($notification_notice_location == '' || $notification_notice_location == null) {
			$notification_notice_location_print = '';
		} else {
			$notification_notice_location_print = get_the_title($notification_notice_location);
		}
        echo esc_attr($notification_notice_location_print);
        break;

	case 'delay' :
		$notification_notice_delay = $notification_box->delay;
        echo esc_attr($notification_notice_delay);
        break;

	case 'show_time' :
		$notification_notice_show_time = $notification_box->show_time;
        echo esc_attr($notification_notice_show_time);
        break;
	}
}

function datebook_notice_update_messages( $messages ) {

		global $post, $post_ID;

		$messages['datebook_notice' ] = array(
			0 => '', // Unused. Messages start at index 1.
			1 => esc_html__( 'Notification updated', 'datebook' ),
			2 => esc_html__( 'Notification updated', 'datebook' ),
			3 => esc_html__( 'Notification deleted', 'datebook' ),
			4 => esc_html__( 'Notification updated', 'datebook' ),
			/* translators: %s: date and time of the revision */
			5 => isset($_GET['revision']) ? sprintf( esc_html__( 'Notification restored to revision from %s', 'datebook' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
			6 => esc_html__( 'Notification published', 'datebook' ),
			7 => esc_html__( 'Notification saved', 'datebook' ),
			8 => esc_html__( 'Notification submitted', 'datebook' ),
			9 => esc_html__( 'Notification scheduled for', 'datebook' ),
			10 => esc_html__( 'Notification draft updated', 'datebook' ),
		);

		return $messages;

}


function individual_control_meta_box() {

	global $wpdb;

	$screen = get_current_screen();
	$get_page_id = get_the_ID();
	$disable_all_notifications_page = 'disable_all_notifications_page_' . $get_page_id;
	$get_disable_all_notifications_page = get_post_meta($get_page_id, $disable_all_notifications_page, true);


	$table_name = strtolower($wpdb->prefix) . 'datebook_notifications';
	$check_notifications = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_name));

	if($check_notifications == $table_name) {

		$result = $wpdb->get_results( "SELECT * FROM $table_name");

		?>

<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
	<tbody>
		<tr class="form-field">
			<td>
				<input type="hidden" name="prevent_delete_meta_movetotrash" id="prevent-delete-meta-movetotrash" value="<?php echo wp_create_nonce(DATEBOOK_URL.$get_page_id); ?>" />
				<input name="<?php echo esc_attr($disable_all_notifications_page); ?>" type="checkbox" value="<?php echo esc_attr($get_page_id); ?>" <?php if($get_disable_all_notifications_page == $get_page_id ) { echo 'checked="checked"'; } ?> >
				<label for="disable_all_notifications_page"><?php echo esc_html__( 'Turn off notifications', 'datebook' ) ?></label>
			</td>
		</tr>
		
				<?php
				
				$count_notification = 0;
				$notification_layout = '';

				foreach ($result as $notification_notice_values) {

					$count_notification++;

					$notification_id = $notification_notice_values->id;
					$notification_title = $notification_notice_values->title;
					$notification_display = 'display_notification_' . $notification_id . '_page_' . $get_page_id;
					$get_notification_display = get_post_meta($get_page_id, $notification_display, true);

					if($get_notification_display == $notification_id ) { $notification_checked = 'checked="checked"'; } else { $notification_checked = ''; }
					
					$notification_layout .= '<input name="display_notification_' . esc_attr($notification_id) . '_page_' . esc_attr($get_page_id) . '" type="checkbox" value="' . esc_attr($notification_id) . '" ' . $notification_checked . ' /><label for="hide_menu_checkbox">' . esc_attr($notification_title) . '</label></br>';
					
				}

				if($count_notification > 0){
					
					global $allowedtags;
					
					 ?>

					<tr class="form-field"><td><?php echo esc_html__( 'Display these notifications', 'datebook' ) ?></td></tr>
					<tr class="form-field"><td><?php echo wp_kses( $notification_layout, $allowedtags ); ?></td></tr>

				<?php } ?>

		</tbody>
	</table>

<?php

	}
}

function add_individual_control_meta_box() {

	global $wp_post_types;

	$cpt_name = get_post_type(get_the_ID());

	$is_cpt_public = isset($wp_post_types[$cpt_name]->public) ? $wp_post_types[$cpt_name]->public : '';

    if( $is_cpt_public ) {

		add_meta_box("individual_control_meta_box_id", esc_html__( 'Notifications', 'datebook' ), array($this, 'individual_control_meta_box'), 'page', "side", "low", null);

	}

}

function save_individual_control_meta_box($post_id, $post, $update) {

	global $wpdb;

	$table_name = strtolower($wpdb->prefix) . 'datebook_notifications'; // do not forget about tables prefix
	$check_notifications = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_name));

	if($check_notifications == $table_name) {

		$result = $wpdb->get_results( "SELECT * FROM $table_name");
	
		$get_page_id = get_the_ID();
		$disable_all_notifications_page = 'disable_all_notifications_page_' . $get_page_id;
		$get_disable_all_notifications_page = get_post_meta($get_page_id, $disable_all_notifications_page, true);

		$create_nonce = (isset($_POST['prevent_delete_meta_movetotrash']) ? $_POST['prevent_delete_meta_movetotrash'] : null);
		if (!wp_verify_nonce($create_nonce, DATEBOOK_URL.$get_page_id)) { return $get_page_id; }

		if(isset($_POST[$disable_all_notifications_page]) != '') {
			update_post_meta( $get_page_id, sanitize_text_field($disable_all_notifications_page), sanitize_text_field($_POST[$disable_all_notifications_page]) );
		} else {
			if ($get_disable_all_notifications_page != '') {
				update_post_meta( $get_page_id, sanitize_text_field($disable_all_notifications_page), '' );
			}
		}

		foreach ($result as $notification_notice_values) {
			$notification_id = $notification_notice_values->id;
			$notification_title = $notification_notice_values->title;
			$notification_display = 'display_notification_' . $notification_id . '_page_' . $get_page_id;
			$get_notification_display = get_post_meta($get_page_id, $notification_display, true);

			if(isset($_POST[$notification_display]) != '') {
				update_post_meta( $get_page_id, sanitize_text_field($notification_display), sanitize_text_field($notification_id) );
			} else {
				if ($get_notification_display != '') {
					update_post_meta( $get_page_id, sanitize_text_field($notification_display), '' );
				}
			}
		}
	}
}

function datebook_notice_remove_post_meta_boxes( $hidden, $screen, $use_defaults ) {

	global $wp_meta_boxes;

	$cpt = 'datebook_notice'; // Modify this to your needs!

	if( $cpt === $screen->id && isset( $wp_meta_boxes[$cpt] ) ) {
		$tmp = array();
		foreach( (array) $wp_meta_boxes[$cpt] as $context_key => $context_item ) {
			foreach( $context_item as $priority_key => $priority_item ) {
				foreach( $priority_item as $metabox_key => $metabox_item ) {
					if ( $metabox_key != 'submitdiv' && $metabox_key != 'datebook-notifications-item-meta-box' ) {
						$tmp[] = $metabox_key;
					}
				}
			}
		}
		$hidden = $tmp;  // Override the current user option here.
	}

	return $hidden;

}




}

$Class_DateBook_Notification_Admin = new Class_DateBook_Notification_Admin;
