<?php
/**
 * Create Shortcodes list
 *
 * @class DateBook_Shortcodes_List
 * @author Pagick Themes
 * @since 3.4
 */
	 

/**
 * DateBook_Register_Plans_Table class that will display our custom table
 * records in nice table
 */
class DateBook_Shortcodes_List extends WP_List_Table {

	/**
	 * [REQUIRED] You must declare constructor and give some basic params
	 */
	function __construct() {

		global $status, $page;

		parent::__construct(array(
			'singular' => 'field',
			'plural' => 'fields',
		));
	}


	/**
	 * [REQUIRED] this is a default column renderer
	 *
	 * @param $item - row (key, value array)
	 * @param $column_name - string (key)
	 * @return HTML
	 */
	function column_default($item, $column_name) {
		
		return esc_attr($item[$column_name]);
			
	}


	/**
	 * [OPTIONAL] this is example, how to render column with actions,
	 * when you hover row "Edit | Delete" links showed
	 *
	 * @param $item - row (key, value array)
	 * @return HTML
	 */
	function column_name($item) {
		
		// if foreign language do not exist, then show title in English
		$item['name'] = isset($item['name_' . DATEBOOK_WPLANG]) && !empty($item['name_' . DATEBOOK_WPLANG]) ? $item['name_' . DATEBOOK_WPLANG] : $item['name_en_US'];

		$item_out = '<span class="datebook-dot" style="background-color: ' . esc_attr($item['color']) . '"></span> ' . sprintf('%s', esc_attr($item['name']));

		return $item_out;
	}


	/**
	 * [REQUIRED] This method return columns to display in table
	 * you can skip columns that you do not want to show
	 * like content, or description
	 *
	 * @return array
	 */
	function get_columns() {

		$columns = array(
			'name' => esc_html__('Name', 'datebook'),
			'options' => esc_html__('Options', 'datebook'),
			'shortcode' => esc_html__('shortcode', 'datebook')
		);

		return $columns;

	}


	/**
	 * [REQUIRED] This is the most important method
	 *
	 * It will get rows from database and prepare them to be showed in table
	 */
	function prepare_items() {

		$per_page = 300; // constant, how much records will be shown per page

		$columns = $this->get_columns();
		$hidden = array();
		$sortable = $this->get_sortable_columns();

		// here we configure table headers, defined in our methods
		$this->_column_headers = array($columns, $hidden, $sortable);

		$datebook_shortcodes_array = array(
			'datebook_profile_matching' => array('01', esc_html__('Match Making panel on Single Profile page', 'datebook'), '#ae75f9', ''),
			'datebook_administrator_panel' => array('01', esc_html__('Administrator panel on Single Profile page', 'datebook'), '#ff4444', ''),
			'datebook_moderator_panel' => array('02', esc_html__('Moderator panel in the header', 'datebook'), '#ff4444', ''),			
			'datebook_login_form' => array('03', esc_html__('Login form', 'datebook'), '#8e24aa', ''),
			'datebook_registration_form' => array('04', esc_html__('Registration form', 'datebook'), '#5ab9fd', ''),
			'datebook_login_register_links' => array('05', esc_html__('Login and Register links', 'datebook'), '#4db6ac', ''),
			'datebook_countries' => array('06', esc_html__('Countries', 'datebook'), '#8d6e63', ''),
			'datebook_contact_form' => array('07', esc_html__('Contact form', 'datebook'), '#fd912d', ''),
			'datebook_languages_dropdown' => array('08', esc_html__('Language dropdown menu', 'datebook'), '#3F729B', 'style="dropdown or list"; color=”#FFFFFF”'),
			'datebook_quantity_registered_users' => array('09', esc_html__('Number of registered profiles', 'datebook'), '#05e0d6', ''), // shortcode="1", style="light,dark", size="0,14"
			'datebook_posts' => array('10', esc_html__('Blog: all posts', 'datebook'), '#2EBF64', ''),
			'datebook_single_post' => array('10', esc_html__('Blog: single post', 'datebook'), '#2EBF64', ''),
			'datebook_post_category' => array('10', esc_html__('Blog: post category', 'datebook'), '#2EBF64', ''),
			'datebook_post_tag' => array('10', esc_html__('Blog: post tag', 'datebook'), '#2EBF64', ''),

			'datebook_search_form' => array('11', esc_html__('Search: search form', 'datebook'), '#d828fd', 'color="#fff"; background="#000"; showtitle="0 or 1"; layout="1 or 2"; show_empty_countries="0 or 1"; show_advanced_fields="0 or 1";'),
			'datebook_top_offer_panel' => array('11', esc_html__('Search: Top offer panel', 'datebook'), '#d828fd', ''),
			'datebook_all_profiles' => array('11', esc_html__('Search: List of profiles', 'datebook'), '#d828fd', 'quantity="18"; show_no_found_message="0 or 1"; display_only_profiles_with_images="0 or 1"; border_width="0 or 1"; border_style="0 or 1"; border_color="0 or random or #FF6600"; color_gamma="0 or random or #FF6600"'),
			'datebook_profiles_line' => array('12', esc_html__('Profiles: line of normal profiles', 'datebook'), '#43a047', 'quantity=”8”; round=”0 or 1 or 2”; border_width=”0 or 1 or 2”; border_color=”random or #ff6600”; border_style=”solid or dashed or dotted”'), // quantity="6,12", direction="horizontal"
			'datebook_featured_profiles' => array('12', esc_html__('Profiles: Featured profiles', 'datebook'), '#43a047', ''), // quantity="12" (6, 12); round="1" (0, 1, 2); with_images="1" (1, 0); border_width="0" (0, 1); border_color="0" (0, random, #FF6600); border_style="0" (0, 1); shadow="0" (0, 1, 2, 3); space="0" (0, 1); comments="1" (0, 1); moreimages="1" (0, 1); direction="horizontal" (horizontal, vertical); slide="0" (0, 1)
			'datebook_top_profiles' => array('12', esc_html__('Profiles: Top profiles', 'datebook'), '#43a047', ''),
			'datebook_mosaic_normal_profiles' => array('12', esc_html__('Profiles: Mosaic of normal profiles', 'datebook'),'#43a047', ''),
			'datebook_user_menu' => array('12', esc_html__('Profiles: User menu in the header', 'datebook'), '#43a047', ''),

			'datebook_profile_image' => array('13', esc_html__('Single profile: image', 'datebook'), '#e91e63', ''),
			'datebook_profile_title' => array('13', esc_html__('Single profile: title', 'datebook'), '#e91e63', ''),
			'datebook_verification' => array('13', esc_html__('Single profile: verification', 'datebook'), '#e91e63', ''),
			'datebook_online_status' => array('13', esc_html__('Single profile: online status', 'datebook'), '#e91e63', ''),
			'datebook_age' => array('13', esc_html__('Single profile: age', 'datebook'), '#e91e63', ''),
			'datebook_gender' => array('13', esc_html__('Single profile: gender', 'datebook'), '#e91e63', ''),
			'datebook_sexual_orientation' => array('13', esc_html__('Single profile: sexual orientation', 'datebook'), '#e91e63', ''),
			'datebook_zodiac_sign' => array('13', esc_html__('Single profile: zodiac sign', 'datebook'), '#e91e63', ''),
			'datebook_location' => array('13', esc_html__('Single profile: location', 'datebook'), '#e91e63', ''),
			'datebook_phone' => array('13', esc_html__('Single profile: phone', 'datebook'), '#e91e63', ''),
			'datebook_website' => array('13', esc_html__('Single profile: website', 'datebook'), '#e91e63', ''),
			'datebook_message_button' => array('13', esc_html__('Single profile: send message button', 'datebook'), '#e91e63', ''),
			'datebook_favorite_button' => array('13', esc_html__('Single profile: favorite button', 'datebook'), '#e91e63', ''),
			'datebook_like_button' => array('13', esc_html__('Single profile: like button', 'datebook'), '#e91e63', ''),
			'datebook_friend_button' => array('13', esc_html__('Single profile: friend button', 'datebook'), '#e91e63', ''),
			'datebook_about_you' => array('13', esc_html__('Single profile: about you text', 'datebook'), '#e91e63', ''),
			'datebook_profile_menu' => array('13', esc_html__('Single profile: horisontal menu', 'datebook'), '#e91e63', ''),
			'datebook_profile_body' => array('13', esc_html__('Single profile: body, custom fields', 'datebook'), '#e91e63', ''),
			'datebook_profile_statistics' => array('13', esc_html__('Single profile: statistics', 'datebook'), '#e91e63', ''),

			'datebook_profile_notifications' => array('14', esc_html__('Account page: notifications', 'datebook'), '#33b5e5', ''),
			'datebook_profile_messages' => array('14', esc_html__('Account page: messages', 'datebook'), '#33b5e5', ''),
			'datebook_profile_edit' => array('14', esc_html__('Account page: edit', 'datebook'), '#33b5e5', ''),
			'datebook_profile_photos' => array('14', esc_html__('Account page: photos', 'datebook'), '#33b5e5', ''),
			'datebook_profile_verification' => array('14', esc_html__('Account page: verification', 'datebook'), '#33b5e5', ''),
			'datebook_profile_friends' => array('14', esc_html__('Account page: friends', 'datebook'), '#33b5e5', ''),
			'datebook_profile_favorites' => array('14', esc_html__('Account page: favorites', 'datebook'), '#33b5e5', ''),
			'datebook_profile_blacklist' => array('14', esc_html__('Account page: blacklist', 'datebook'), '#33b5e5', ''),
			'datebook_profile_comments' => array('14', esc_html__('Account page: comments', 'datebook'), '#33b5e5', ''),
			'datebook_profile_classifieds' => array('14', esc_html__('Account page: classifieds', 'datebook'), '#33b5e5', ''),
			'datebook_profile_tours' => array('14', esc_html__('Account page: tours', 'datebook'), '#33b5e5', ''),
			'datebook_profile_who_viewed_me' => array('14', esc_html__('Account page: who viewed me', 'datebook'), '#33b5e5', ''),
			'datebook_profile_settings' => array('14', esc_html__('Account page: settings', 'datebook'), '#33b5e5', ''),
			'datebook_profile_privacy' => array('14', esc_html__('Account page: privacy', 'datebook'), '#33b5e5', ''),
			'datebook_profile_subscriptions' => array('14', esc_html__('Account page: subscriptions', 'datebook'), '#33b5e5', ''),
			'datebook_profile_cart' => array('14', esc_html__('Account page: cart', 'datebook'), '#33b5e5', ''),
			'datebook_profile_checkout' => array('14', esc_html__('Account page: checkout', 'datebook'), '#33b5e5', ''),

			'datebook_all_classifieds' => array('15', esc_html__('Classifieds: list', 'datebook'), '#ffd600', ''),

			'datebook_classified_title' => array('16', esc_html__('Single classified: title', 'datebook'), '#ffc400 ', ''),
			'datebook_classified_content' => array('16', esc_html__('Single classified: content', 'datebook'), '#ffc400 ', ''),
			'datebook_classified_meta' => array('16', esc_html__('Single classified: meta data', 'datebook'), '#ffc400 ', ''),
			'datebook_classified_profile' => array('16', esc_html__('Single classified: author profile', 'datebook'), '#ffc400 ', ''),

			'datebook_search_form_tours' => array('17', esc_html__('Tours: search form', 'datebook'), '#ba68c8', ''),
			'datebook_add_tour_action_panel' => array('17', esc_html__('Tours: add tour action panel', 'datebook'), '#ba68c8', ''),
			'datebook_all_tours' => array('17', esc_html__('Tours: list', 'datebook'), '#ba68c8', ''),

		);

		$get_subscription_plans = array();

		global $shortcode_tags;

		foreach($shortcode_tags as $code => $function){
			if (strpos($code, 'datebook') !== false) {
			//if(array_key_exists($code, $datebook_shortcodes_array)){
				if(isset($datebook_shortcodes_array[$code])){
					$get_subscription_plans[] = array('name_en_US' => $datebook_shortcodes_array[$code][1], 'color' => $datebook_shortcodes_array[$code][2], 'options' => $datebook_shortcodes_array[$code][3], 'shortcode' => '[' . $code . ']');
				} else {
					$get_subscription_plans[] = array('name_en_US' => '', 'color' => '', 'options' => '', 'shortcode' => '[' . $code . ']');
				}
			}
		}

		asort($get_subscription_plans);

		if(is_array($get_subscription_plans) && !empty($get_subscription_plans)){

			// will be used in pagination settings
			$total_items = count($get_subscription_plans);

			// prepare query params, as usual current page, order by and order direction
			$paged = isset($_REQUEST['paged']) ? ($per_page * max(0, intval($_REQUEST['paged']) - 1)) : 0;

			// Define $items array
			// notice that last argument is ARRAY_A, so we will retrieve array
			$this->items = $get_subscription_plans;

			// configure pagination
			$this->set_pagination_args(array(
				'total_items' => $total_items, // total items defined above
				'per_page' => $per_page, // per page constant defined at top of method
				'total_pages' => ceil($total_items / $per_page) // calculate pages count
			));
		}
	}
}


class Options_Framework_Shortcodes_List {

	/**
	 * List page handler
	 *
	 * This function renders our custom table
	 * Notice how we display message about successfull deletion
	 * Actualy this is very easy, and you can add as many features
	 * as you want.
	 *
	 * Look into /wp-admin/includes/class-wp-*-list-table.php for examples
	 */
	static function datebook_register_shortcodes_handler() {

		$table = new DateBook_Shortcodes_List();
		$table->prepare_items();

		?>

		<div class="wrap">

			<h1 class="wp-heading-inline"><?php esc_html_e('Shortcodes', 'datebook'); ?></h1>

			<hr class="wp-header-end">

			<div id="message" class="bg-white">
				<p><?php esc_html_e('You can use the shortcodes below when creating pages using Page Builders', 'datebook'); ?></p>
			</div>

			<?php $table->display(); ?>

		</div>

        <?php
    

	}


}