<?php

function datebook_parse_hex($hex) {
		$hex = strtolower(substr($hex, 1));
		if (strlen($hex) == 3) $hex = ($hex[0].$hex[0].$hex[1].$hex[1].$hex[2].$hex[2]);
		$red   = hexdec(substr($hex, 0, 2));
		$green = hexdec(substr($hex, 2, 2));
		$blue  = hexdec(substr($hex, 4, 2));
		return (object)array( 'red'=>$red, 'green'=>$green, 'blue'=>$blue, 'alpha'=>1 );
}
function datebook_parse_rgb($rgb) {
		$rgb = substr($rgb, strpos($rgb, '(')+1, -1);
		$rgb_array = explode(',', $rgb);
		if ( ! isset($rgb_array[3])) $rgb_array[3] = 1;
		return (object)array(
			'red'   => (int)max(0, min(255, $rgb_array[0])),
			'green' => (int)max(0, min(255, $rgb_array[1])),
			'blue'  => (int)max(0, min(255, $rgb_array[2])),
			'alpha' => (float)max(0, min(1, $rgb_array[3]))
		);
}
function datebook_hsl_helper($m1, $m2, $h) {
		$h = ($h % 360) / 360;
		if ($h * 6 < 1) $c = ($m1 + ($m2 - $m1) * $h * 6);
		else if ($h * 2 < 1) $c = $m2;
		else if ($h * 3 < 2) $c = ($m1 + ($m2 - $m1) * ( 2 / 3 - $h) * 6);
		else $c = $m1;
		return (int)max(0, min(255, round($c * 255)));
	}
function datebook_parse_hsl($hsl) {
		$hsl = str_replace('%', '', $hsl); // remove %
		$hsl = substr($hsl, strpos($hsl, '(')+1, -1);
		list( $h, $s, $l, $a ) = explode(',', $hsl);
		$s = max(0, min(1, $s / 100));
		$l = max(0, min(1, $l / 100));
		$m2 = ($l <= .5) ? $l * ($s + 1) : $l + $s - $l * $s;
		$m1 = $l * 2 - $m2;
		if ( ! isset($a)) $a = 1;
		return (object)array(
			'red'   => datebook_hsl_helper($m1, $m2, $h + 120),
			'green' => datebook_hsl_helper($m1, $m2, $h),
			'blue'  => datebook_hsl_helper($m1, $m2, $h - 120),
			'alpha' => (float)max(0, min(1, $a))
		);
}
function datebook_parse_color($color) {
$datebook_named_colors = array(
		'transparent' => 'rgba(0,0,0,0)',
		'aliceblue' => '#F0F8FF',
		'antiquewhite' => '#FAEBD7',
		'aqua' => '#00FFFF',
		'aquamarine' => '#7FFFD4',
		'azure' => '#F0FFFF',
		'beige' => '#F5F5DC',
		'bisque' => '#FFE4C4',
		'black' => '#000000',
		'blanchedalmond' => '#FFEBCD',
		'blue' => '#0000FF',
		'blueviolet' => '#8A2BE2',
		'brown' => '#A52A2A',
		'burlywood' => '#DEB887',
		'cadetblue' => '#5F9EA0',
		'chartreuse' => '#7FFF00',
		'chocolate' => '#D2691E',
		'coral' => '#FF7F50',
		'cornflowerblue' => '#6495ED',
		'cornsilk' => '#FFF8DC',
		'crimson' => '#DC143C',
		'cyan' => '#00FFFF',
		'darkblue' => '#00008B',
		'darkcyan' => '#008B8B',
		'darkgoldenrod' => '#B8860B',
		'darkgray' => '#A9A9A9',
		'darkgreen' => '#006400',
		'darkgrey' => '#A9A9A9',
		'darkkhaki' => '#BDB76B',
		'darkmagenta' => '#8B008B',
		'darkolivegreen' => '#556B2F',
		'darkorange' => '#FF8C00',
		'darkorchid' => '#9932CC',
		'darkred' => '#8B0000',
		'darksalmon' => '#E9967A',
		'darkseagreen' => '#8FBC8F',
		'darkslateblue' => '#483D8B',
		'darkslategray' => '#2F4F4F',
		'darkslategrey' => '#2F4F4F',
		'darkturquoise' => '#00CED1',
		'darkviolet' => '#9400D3',
		'deeppink' => '#FF1493',
		'deepskyblue' => '#00BFFF',
		'dimgray' => '#696969',
		'dimgrey' => '#696969',
		'dodgerblue' => '#1E90FF',
		'firebrick' => '#B22222',
		'floralwhite' => '#FFFAF0',
		'forestgreen' => '#228B22',
		'fuchsia' => '#FF00FF',
		'gainsboro' => '#DCDCDC',
		'ghostwhite' => '#F8F8FF',
		'gold' => '#FFD700',
		'goldenrod' => '#DAA520',
		'gray' => '#808080',
		'green' => '#008000',
		'greenyellow' => '#ADFF2F',
		'grey' => '#808080',
		'honeydew' => '#F0FFF0',
		'hotpink' => '#FF69B4',
		'indianred' => '#CD5C5C',
		'indigo' => '#4B0082',
		'ivory' => '#FFFFF0',
		'khaki' => '#F0E68C',
		'lavender' => '#E6E6FA',
		'lavenderblush' => '#FFF0F5',
		'lawngreen' => '#7CFC00',
		'lemonchiffon' => '#FFFACD',
		'lightblue' => '#ADD8E6',
		'lightcoral' => '#F08080',
		'lightcyan' => '#E0FFFF',
		'lightgoldenrodyellow' => '#FAFAD2',
		'lightgray' => '#D3D3D3',
		'lightgreen' => '#90EE90',
		'lightgrey' => '#D3D3D3',
		'lightpink' => '#FFB6C1',
		'lightsalmon' => '#FFA07A',
		'lightseagreen' => '#20B2AA',
		'lightskyblue' => '#87CEFA',
		'lightslategray' => '#778899',
		'lightslategrey' => '#778899',
		'lightsteelblue' => '#B0C4DE',
		'lightyellow' => '#FFFFE0',
		'lime' => '#00FF00',
		'limegreen' => '#32CD32',
		'linen' => '#FAF0E6',
		'magenta' => '#FF00FF',
		'maroon' => '#800000',
		'mediumaquamarine' => '#66CDAA',
		'mediumblue' => '#0000CD',
		'mediumorchid' => '#BA55D3',
		'mediumpurple' => '#9370DB',
		'mediumseagreen' => '#3CB371',
		'mediumslateblue' => '#7B68EE',
		'mediumspringgreen' => '#00FA9A',
		'mediumturquoise' => '#48D1CC',
		'mediumvioletred' => '#C71585',
		'midnightblue' => '#191970',
		'mintcream' => '#F5FFFA',
		'mistyrose' => '#FFE4E1',
		'moccasin' => '#FFE4B5',
		'navajowhite' => '#FFDEAD',
		'navy' => '#000080',
		'oldlace' => '#FDF5E6',
		'olive' => '#808000',
		'olivedrab' => '#6B8E23',
		'orange' => '#FFA500',
		'orangered' => '#FF4500',
		'orchid' => '#DA70D6',
		'palegoldenrod' => '#EEE8AA',
		'palegreen' => '#98FB98',
		'paleturquoise' => '#AFEEEE',
		'palevioletred' => '#DB7093',
		'papayawhip' => '#FFEFD5',
		'peachpuff' => '#FFDAB9',
		'peru' => '#CD853F',
		'pink' => '#FFC0CB',
		'plum' => '#DDA0DD',
		'powderblue' => '#B0E0E6',
		'purple' => '#800080',
		'red' => '#FF0000',
		'rosybrown' => '#BC8F8F',
		'royalblue' => '#4169E1',
		'saddlebrown' => '#8B4513',
		'salmon' => '#FA8072',
		'sandybrown' => '#F4A460',
		'seagreen' => '#2E8B57',
		'seashell' => '#FFF5EE',
		'sienna' => '#A0522D',
		'silver' => '#C0C0C0',
		'skyblue' => '#87CEEB',
		'slateblue' => '#6A5ACD',
		'slategray' => '#708090',
		'slategrey' => '#708090',
		'snow' => '#FFFAFA',
		'springgreen' => '#00FF7F',
		'steelblue' => '#4682B4',
		'tan' => '#D2B48C',
		'teal' => '#008080',
		'thistle' => '#D8BFD8',
		'tomato' => '#FF6347',
		'turquoise' => '#40E0D0',
		'violet' => '#EE82EE',
		'wheat' => '#F5DEB3',
		'white' => '#FFFFFF',
		'whitesmoke' => '#F5F5F5',
		'yellow' => '#FFFF00',
		'yellowgreen' => '#9ACD32'
	);

		if (isset($datebook_named_colors[$color])){
			$color = $datebook_named_colors[$color];
		}
		if ($color[0] === '#'){
			return datebook_parse_hex($color);
		}
		if (stripos($color, 'rgb') === 0){
			return datebook_parse_rgb($color);
		}
		if (stripos($color, 'hsl') === 0){
			return datebook_parse_hsl($color);
		}
		return false;
	}
function datebook_parse_length($length) {
	
	$abs_units = array( 'px'=>1, 'in'=>96, 'mm'=>3.77952756, 'cm'=>37.7952756, 'pt'=>1.3333333, 'pc'=>16 );
	
		$pos = null;
		if (is_numeric($length)) {
			$pos = (object)array( 'value'=>($length * 100), 'unit'=>'%' );
		} else if (isset($length)) {
			preg_match('/^([0-9.]+)([%a-z]+)$/i', $length, $matches);
			if ($matches) {
				if (isset($abs_units[$matches[2]])) {
					$pos = (object)array( 'value'=>(float)$matches[1], 'unit'=>$matches[2] );
				} else if ($matches[2] === '%') {
					$pos = (object)array( 'value'=>(float)$matches[1], 'unit'=>'%' );
				}
			}
		}
		return $pos;
	}
function datebook_parse_stop($stop) {
		$stop = explode(' ', $stop);
		$color = datebook_parse_color($stop[0]);
		$pos = datebook_parse_length(isset($stop[1]) ? $stop[1] : null);
		return (object)array( 'color'=>$color, 'position'=>$pos );
	}
	
function datebook_parse_gradient($linear_gradient) {

		$stops = $stops_angle = array();
		
		$linear_gradient = trim($linear_gradient);
		if (isset($linear_gradient)){
			if (substr($linear_gradient, 0, strlen('linear-gradient(')) != 'linear-gradient('){
				return 'linear-gradient(to right, rgba(0, 0, 0, 0) 0%, rgba(0, 0, 0, 0) 100%)';
			} else {
				$params = substr($linear_gradient, strlen('linear-gradient('), -1);
				$params = preg_replace('/\s+/', ' ', trim($params)); // normalize white-space
				// remove unneeded spaces
				$params = str_replace(array( ' ( ', ' (', '( ' ), '(', $params);
				$params = str_replace(array( ' , ', ' ,', ', ' ), ',', $params);
				$params = str_replace(' )', ')', $params);
				// swap commas to tilde inside rgb() syntax so we can explode
				$params = preg_replace('/\(([^,)]+),([^,)]+),([^,)]+),?/', '($1~$2~$3~', $params);
				$params = str_replace('~)', ')', $params);
				$stops = explode(',', $params);
				$stops_angle = $stops[0];
				foreach ($stops as $i => $stop) { $stops[$i] = str_replace('~', ',', trim($stop)); } // unswap comma and tilde
				if ( ! datebook_parse_color($stops[0])) {
					$stops = array_slice($stops, 1);
				}
				foreach ($stops as $i => $stop){
					$stops[$i] = datebook_parse_stop($stop);
				}
				$stops['3'] = (object)array( 'angle'=>$stops_angle );
			}
		} else {
			return 'linear-gradient(to right, rgba(0, 0, 0, 0) 0%, rgba(0, 0, 0, 0) 100%)';
		}
		return $stops;
}