<?php
/**
 * DateBook Copyright
 * Control copyright
 *
 * @class DateBook_Copyright
 * @author Pagick Themes
 * @since 4.6.0
 */

class DateBook_Copyright {


	/**
	 * Hook actions and filters.
	 * 
	 * @since 4.6.0
	 * @access public
	 */
	public static function init() {

		add_action( 'wp_ajax_datebook_activating_ajax', array( __CLASS__, 'save_data' ) );
		add_action( 'wp_ajax_datebook_insert_code', array( __CLASS__, 'save_data' ) );

	}

	// Process activating and saving in database
	public static function save_data() {

		if(isset($_POST['action']) && $_POST['action'] == 'datebook_activating_ajax' && isset($_POST['activation_code'])){

			//$encrypt_code = crypt($_POST['activation_code'], 'db');

			// Add a user to the copyrighted users list
			update_option('datebook_activation_code', $_POST['activation_code']);

			$response = array(
				'status' => 200
			);
			
			echo wp_send_json($response);

			die();

		}
	}


	/**
	 * The user interface
	 *
	 * @access public
	 */
	public static function datebook_interface() {

		?>

		<div class="wrap">

			<h1><?php echo esc_html__('DateBook Activation', 'datebook'); ?></h1>

			<p><?php echo esc_html__('Please, register &amp; activate your copy of the theme in order to enable all main functions.', 'datebook'); ?>.</p>
			<p><?php echo esc_html__('If you had previously registered your purchase with Pagick Themes, you will have not to re-register your product.', 'datebook'); ?>.</p>
			
			<hr class="wp-header-end">
			
			<?php
					//Get entire array
					$item = get_option('datebook_activation_code');

					if (!$item) {

					?>

						<div class="datebook-theme-not-activated" style="margin: 5px 0 15px; padding: 10px 23px; border: 2px solid #fb0707; background-color: #fff0f0; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
							<h2><?php echo esc_html__( 'Theme is NOT activated yet!', 'datebook' ); ?></h2>
						</div>
						
						<div class="datebook-theme-activated" style="display:none; margin: 5px 0 15px; padding: 10px 23px; border: 2px solid #00d210; background-color: #f4fff0; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
							<h2><?php echo esc_html__( 'Theme is activated!', 'datebook' ); ?></h2>
						</div>

					<?php } else { ?>

						<div style="margin: 5px 0 15px; padding: 10px 23px; border: 2px solid #00d210; background-color: #f4fff0; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
							<h2><?php echo esc_html__( 'Theme is activated!', 'datebook' ); ?></h2>
						</div>

					<?php } ?>

            <div class="welcome-panel datebook-dummy-notify-box">
				<div class="welcome-panel-content">

					<h2><?php echo esc_html__('DateBook Activation', 'datebook'); ?></h2>

					<p><?php echo esc_html__('Enter your purchase code received from ThemeForest, Envato.', 'datebook');

					$line_to_purchase_code_themeforest_help = sprintf('<a target="_blank" href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-">%s</a>', esc_html__('where you can find your purchase code', 'datebook'));

					echo ' '. sprintf( esc_html__( 'Read here %s.' ), $line_to_purchase_code_themeforest_help );

					?></p>
					
					<?php

					// If the button was clicked
					if ( ! empty( $_POST['datebook_copyright_start'] ) || ! empty( $_POST['activation_code'] ) ) {

						// Form nonce check
						check_admin_referer( 'datebook_copyright_start' );
						
					?>

					<?php } else { ?>
					
					<h3><?php echo esc_html__( 'Enter your purchase code', 'datebook' ); ?></h3>

						<form method="post" action="">

							<?php wp_nonce_field('datebook_copyright_start') ?>

							<p><input type="text" class="datebook-activate-input datebook-purchase-code" name="activation_code" value="" /></p>

							<div class="datebook-notice datebook-info datebook-activation-in-process">
								<p><?php echo esc_html__('Getting an activation code. Please, wait...', 'datebook'); ?></p>
							</div>
							<div class="datebook-notice datebook-updated datebook-notice-success datebook-activation-received">
								<p><?php echo esc_html__('Activation code has been successfully received.', 'datebook'); ?></p>
							</div>
							<div class="datebook-notice datebook-updated datebook-activation-success">
								<p><?php echo esc_html__('Theme has been successfully activated. Thank you!', 'datebook'); ?></p>
							</div>
							<div class="datebook-notice datebook-error datebook-activation-failure" style="padding-top: 14px;">
								
							</div>

							<p><input type="submit" id="datebook-activation-submit" class="button button-primary button-hero hide-if-no-js" name="datebook_copyright_start" value="<?php echo esc_html__( 'Submit', 'datebook' ) ?>" /></p>

						</form>
								
					<?php } ?>

				</div>
			</div>
			
			
			
			<div class="welcome-panel datebook-dummy-notify-box">
				<div class="welcome-panel-content">

					<h2><?php echo esc_html__('I already have an activation code', 'datebook'); ?></h2>

					<p><?php

					echo esc_html__('If you have already received your activation code from Pagick Themes then enter it here.', 'datebook');

					$line_to_purchase_code_themeforest_help = sprintf('<a target="_blank" href="https://www.pagickthemes.com/activation">%s</a>', esc_html__('here', 'datebook'));

					echo ' '. sprintf( esc_html__( 'Get your code %s.' ), $line_to_purchase_code_themeforest_help );

					?></p>

					<?php

					// If the button was clicked
					if ( ! empty( $_POST['datebook_code_start'] ) || ! empty( $_POST['activation_code'] ) ) {

						// Form nonce check
						check_admin_referer( 'datebook_code_start' );
						
					?>

					<?php } else { ?>
					
					<h3><?php echo esc_html__( 'Enter your activation code', 'datebook' ); ?></h3>

						<form method="post" action="">

							<?php wp_nonce_field('datebook_code_start') ?>

							<p><input type="text" class="datebook-activate-input datebook-activation-code" name="activation_code" value="" /></p>

							<div class="datebook-notice datebook-info datebook-code-in-process">
								<p><?php echo esc_html__('Activating the theme. Please, wait...', 'datebook'); ?></p>
							</div>
							<div class="datebook-notice datebook-updated datebook-code-success">
								<p><?php echo esc_html__('Theme has been successfully activated. Thank you!', 'datebook'); ?></p>
							</div>
							<div class="datebook-notice datebook-error datebook-code-failure">
								<p><?php echo esc_html__('Activation code could not been saved. Theme could not be activated.', 'datebook'); ?></p>
							</div>

							<p><input type="submit" id="datebook-code-submit" class="button button-primary button-hero hide-if-no-js" name="datebook_code_start" value="<?php echo esc_html__( 'Submit', 'datebook' ) ?>" /></p>

						</form>
								
					<?php } ?>

				</div>
			</div>
            


            <div class="welcome-panel datebook-dummy-notify-box">
				<div class="welcome-panel-content" style="display:block">

					<h2>Where can I find my Purchase Code?</h2>
					<p>To download your Purchase Code simply follow these steps or check this <a href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-" target="_blank" rel="noopener">video</a>:</p>
					<ol>
						<li>Access your <a href="https://themeforest.net/downloads" target="_blank" rel="noopener">ThemeForest downloads</a> with the account that was used to purchase DateBook.</li>
						<li>Look for DateBook in your list of purchases, click the <strong>Download</strong> button and select '<strong>License Certificate &amp; Purchase Code</strong>'.</li>
						<li>Copy the '<strong>Item Purchase Code</strong>' into the field '<strong>Envato Purchase Code</strong>' of the Registration page.</li>
					</ol>
					
					<hr />

					<h2 id="approval">Registration approval</h2>
					<p><strong>Each license entitles one person for a single project.</strong> <strong>Submiting your purchase code</strong> means connecting to our API server and validating your Purchase Code for the installation. This way you confirm you are compliant with the <a href="https://themeforest.net/licenses/standard" target="_blank" rel="noopener">Envato License</a> and <a href="https://themeforest.net/licenses/terms/regular" target="_blank" rel="noopener">Envato License Terms</a>.</p>
					
					<h2 id="local">Localhost Product Registration</h2>
					<p>If you are creating a local installation to test out the theme or to create your new site faster (with XAMPP, MAMP, Local or DesktopServer), please note that the installation is considered local if the URL ends with <strong>.local</strong>, <strong>.test</strong>, <strong>.home</strong>, <strong>.mamp</strong>&nbsp;and<span>&nbsp;if the 'domain' is one word or without a dot, for example '<strong>localhost</strong>' or '<strong>localhost:8888</strong>'.</span></p>

					<h2 id="problems">Possible Problems with Product Registration</h2>
					<p>If you encounter an error with the Purchase Code or Product Registration please follow:</p>
					<ul>
						<li><a href="">Product Registration not working</a></li>
						<li><a href="">You have exceeded the maximum number of activations</a></li>
					</ul>

				</div>
			</div>
			
			
			<div class="welcome-panel datebook-dummy-notify-box">
				<div class="welcome-panel-content" style="display:block">

					<h2 id="copyright-terms">Copyright</h2>
					<ul>
						<li>The billing, licensing terms and process is purely handled by <a href="https://envato.com/" target="_blank" rel="noopener">Envato</a> (the company who owns ThemeForest), and we have no control over these aspects. Currently ThemeForest offers a single license and an extended license. The single license means that you need to purchase <strong>one single license for every site that use DateBook</strong>. <strong>Running multiple websites on a single license is a copyright violation. In other words it is a serious legal offence and is strictly prohibited.</strong> So if you are building 3 websites with DateBook, then you are required to purchase 3 single licenses. Even the extended license operates this way but you can re-sell this as an end product.</li>
					</ul>

					<h2>Terms of Use</h2>
					<ul>
						<li>Activation is the process by which a user confirms a regular use of the product according to Envato terms. Validating your purchase helps us to know that you have purchased a license to use for one website (i.e. one domain) and that you are compliant with the <a href="https://themeforest.net/licenses/standard" target="_blank" rel="noopener">Envato license</a> and <a href="https://themeforest.net/licenses/terms/regular" target="_blank" rel="noopener">Envato license terms</a>. <strong>Submiting your purchase code</strong> means connecting to our API server and validating your Purchase Code associated with the URL of the installation to verify that you’re not using the same purchase code on other installations. No sensible information will be fetched from your Envato account.</li>
					</ul>
					
				</div>
			</div>
			
		</div>
		
		<div class="clear"></div>
		
	<?php

	}

}

DateBook_Copyright::init();