<?php
/**
 * Theme Installer
 * Notify if pages are not created yet.
 * Install required pages, countries, menus, database tables, demo profiles.
 *
 * @class DateBook_Install_Theme_Data
 * @author Pagick Themes
 * @since 1.0
 */

class DateBook_Install_Theme_Data {


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		self::datebook_redirect();

		add_action( 'admin_menu', array( __CLASS__, 'datebook_install_style' ) );
		add_action( 'admin_init', array( __CLASS__, 'datebook_deactivate_wordpress_importer_plugin' ) );
		add_action( 'init', array( __CLASS__, 'datebook_check_if_data_installed_completely' ) );
		add_action( 'admin_notices', array( __CLASS__, 'datebook_required_notification' ) );
		
		if( get_option( 'datebook_activation_code' ) != true ) {
			add_action( 'admin_notices', array( __CLASS__, 'datebook_enter_purchase_code' ) );
		}

		add_action( 'wp_ajax_datebook_custom_fields_dismiss_notice', array( __CLASS__, 'custom_fields_notice_update' ) );

	}


	/**
	 * Insert inline CSS style for Install and Notify Box
	 *
	 * @access public
	 */
	public static function datebook_enter_purchase_code() {
		
		if(isset($_GET['page']) && $_GET['page'] != 'datebook-options-install' && $_GET['page'] != 'datebook-countries-installer') {

    	?>

		<div class='notice notice-info'>
			<p><?php $link_to_purchase_code_form = sprintf('<a href="' . admin_url( 'admin.php?page=datebook-options-copyright' ) . '">%s</a>', esc_html__('here', 'datebook'));
		echo ' ' . sprintf( esc_html__( 'Enter your purchase code %s to activate DateBook.' ), $link_to_purchase_code_form ); ?></p>
		</div>

		<?php
		
		}

	}


	/**
	 * Insert inline CSS style for Install and Notify Box
	 *
	 * @access public
	 */
	public static function custom_fields_notice_update() {
		update_option( 'custom_fields_dismiss_notice', true );
	}


	/**
	 * Insert inline CSS style for Install and Notify Box
	 *
	 * @access public
	 */
	public static function datebook_install_style() {

		wp_enqueue_style( 'datebook-plugin-install', OPTIONS_FRAMEWORK_DIRECTORY . 'css/datebook-plugin-install.css', array(), '1.0' );
		
		// Delay 5 seconds before each pages/demo importing while installing theme data
		wp_enqueue_script( 'datebook-refresh-js', OPTIONS_FRAMEWORK_DIRECTORY . 'js/refresh.js', array(), '1.0' );

	}
	
	
	/**
	 * Redirect again to the same page
	 *
	 * @access public
	 */
	public static function datebook_redirect() {

		if (isset($_POST['datebook']) && is_array($_POST['datebook']) || isset($_GET['required-data-install']) && $_GET['required-data-install'] == 'yes' || isset($_GET['demo-data-install']) && $_GET['demo-data-install'] == 'yes') {
			if (isset($_GET['required-data-install']) && $_GET['required-data-install'] == 'yes') {
				$alldatafields = 'alldata';
			} else if (isset($_GET['demo-data-install']) && $_GET['demo-data-install'] == 'yes') {
				$alldatafields = 'alldemoprofiles';
			}

			$demo_data_url = admin_url('/admin.php?page=datebook-options-install');

			// Redirect Required Data
			if (isset($alldatafields) && $alldatafields == 'alldata') {

				$totalstep = isset($_GET['total']) && $_GET['total'] > 0 ? $_GET['total'] : 0;

				if (isset($_GET['step']) && $_GET['step'] < $totalstep) {

					if (isset($_GET['whattodo']) && strlen($_GET['whattodo']) > 0) {
						$nextstep = 1000;
						$whattodo = $_GET['whattodo'];
					} else {
						$nextstep = absint($_GET['step']) + 1;
						$whattodo = '';
					}

					if (!headers_sent()) {
						header('Refresh:5;url=' . esc_attr($demo_data_url) . '&required-data-install=yes&step=' . esc_attr($nextstep) . '&total=' . absint($totalstep) . '&whattodo=' . esc_attr($whattodo));
					}
					
				}
				
			// Required Demo
			} else if (isset($alldatafields) && $alldatafields == 'alldemoprofiles') {

				$totalstep = absint($_GET['total']);

				if (isset($_GET['step']) && $_GET['step'] == '1' ) {

					if (isset($_GET['demo-profiles-step']) && $_GET['demo-profiles-step'] <= 6) {
					$demoprofilesstep = absint($_GET['demo-profiles-step']) + 1;
					
						if ($demoprofilesstep < '7') {
							$global_step = '1';
						} else {
							$global_step = '2';
						}

						if (!headers_sent()) {
							header('Refresh:5;url=' . esc_attr($demo_data_url) . '&demo-data-install=yes&demo-profiles-step=' . esc_attr($demoprofilesstep) . '&step=' . esc_attr($global_step) . '&total=' . absint($totalstep));
						}

					}
					
					
				} else {
					
					if (isset($_GET['step']) && $_GET['step'] < $totalstep) {
						$nextstep = absint($_GET['step']) + 1;
						if (!headers_sent()) {
							header('Refresh:5;url=' . esc_attr($demo_data_url) . '&demo-data-install=yes&step='.esc_attr($nextstep) . '&total=' . absint($totalstep));
						}
					}
					
				}
			}
		}
	}


	/**
	 * Defines pages variables
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_pages_variables() {

		global $datebook_pages_variables;

		// Main page order, Subpage order, Permalink, Page content, Page title, Page slug, Template file
		$datebook_pages_variables = array(
			array(0, 0, 'home_page', 'Home page', 'Homepage', 'home', 'page-datebook.php'),
			array(1, 0, 'contact_page', 'Contact Us page', 'Contact Us', 'contact', 'page-datebook.php'),
			array(2, 0, 'terms_page', 'Terms and Conditions page', 'Terms and Conditions', 'terms', 'default'),
			array(3, 0, 'login_page', '', 'Login', 'login', 'page-datebook.php'),
			array(4, 3, 'forgot_password_page', 'Forgot password page', 'Forgot password', 'lostpassword', 'page-datebook.php'),
			array(5, 0, 'registration_page', 'Registration page', 'Registration', 'registration', 'page-datebook.php'),
			array(6, 0, 'all_tours_page', 'Tours page', 'Tours', 'tours', 'page-datebook.php'),
			array(7, 0, 'all_classifieds_page', 'Classifieds page', 'Classifieds', 'classifieds', 'page-datebook.php'),
			array(8, 0, 'search_results_page', 'Search page', 'Searching', 'searching', 'page-datebook.php'),
			array(9, 0, 'blog_page_url', 'Blog page. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum sit amet tincidunt arcu, non iaculis dolor. Donec sit amet aliquam velit. Aliquam non aliquet libero, sed consequat erat. Donec ornare nec nulla eget ornare. In placerat placerat justo, vel feugiat dui vulputate at. Aenean vel euismod eros. Quisque malesuada tellus magna, eu sollicitudin metus scelerisque et.', 'Blog', 'blog', 'page-blog.php'),
			array(10, 0, 'my_edit_profile_page', 'Here you can edit your personal data', 'Profile &#8211; Edit', 'mypage', 'page-datebook.php'),
			array(11, 10, 'my_messages_page', 'Here you can read messages you received from other users.', 'Profile &#8211; Messages', 'messages', 'page-datebook.php'),
			array(12, 10, 'my_upgrade_page', 'Here you can upgrade your profile and move it to Top position or make it Featured.', 'Profile &#8211; Subscription', 'upgrade', 'page-datebook.php'),
			array(13, 10, 'my_cart_page', 'Here you can see the subscription plan selected before checkout.', 'Profile &#8211; Cart', 'cart', 'page-datebook.php'),
			array(14, 10, 'my_checkout_page', 'Here you can upgrade your profile and move it to Top Profiles or make it Featured.', 'Profile &#8211; Checkout', 'checkout', 'page-datebook.php'),
			array(15, 10, 'my_photos_page', 'Here you can upload photos for your profile.', 'Profile &#8211; Photos', 'photos', 'page-datebook.php'),
			array(16, 10, 'my_comments_page', 'Here you can see all your comments you left on other profiles.', 'Profile &#8211; Comments', 'comments', 'page-datebook.php'),
			array(17, 10, 'my_tours_page', 'Here you can tell users where you would like to go on travels and invite them to join you.', 'Profile &#8211; Tours', 'tours', 'page-datebook.php'),
			array(18, 10, 'my_verification_page', 'Here you can upload photo that verify you. After that you get Verified Status.', 'Profile &#8211; Verification', 'verification', 'page-datebook.php'),
			array(19, 10, 'my_friends_page', 'Here you can change settings of your friend relations.', 'Profile &#8211; Friends', 'friends', 'page-datebook.php'),
			array(20, 10, 'my_blacklist_page', 'Here you can see profiles you placed (ignored) in blacklist.', 'Profile &#8211; Blacklist', 'blacklist', 'page-datebook.php'),
			array(21, 10, 'my_favorites_page', 'Here you can see all your favorite profiles.', 'Profile &#8211; Favorites', 'favorites', 'page-datebook.php'),
			array(22, 10, 'my_classifieds_page', 'Here you can add your advert offers.', 'Profile &#8211; Classifieds', 'classifieds', 'page-datebook.php'),
			array(23, 10, 'my_views_page', 'Here you can see who viewed your profile.', 'Profile &#8211; Who viewed me', 'views', 'page-datebook.php'),
			array(24, 10, 'my_settings_page', 'Here you can change settings of your profile.', 'Profile &#8211; Settings', 'settings', 'page-datebook.php'),
			array(25, 10, 'my_privacy_page', 'Here you can change privacy of your profile.', 'Profile &#8211; Privacy', 'privacy', 'page-datebook.php'),
			array(26, 10, 'my_notification_page', 'Here you can see all personal notifications', 'Profile &#8211; Notifications', 'notifications', 'page-datebook.php')
		);
		
	}


	/**
	 * Check if the plugin data installed abd saved completely
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_check_if_data_installed_completely() {

		global $datebook_pages_variables;

		self::datebook_pages_variables();

		$page_id = get_the_ID();
		
		foreach ($datebook_pages_variables as $key => $page) {

			if ($page_id == get_option($page[2])) { 

				$option_name = preg_replace( "/\W/", '_', strtolower( get_option( 'stylesheet' ) ) );
				$themename = get_option( $option_name );
				if (!of_get_option('default_language') || $themename == '') {

					if (!is_front_page() && !is_home()) {
						wp_redirect(home_url());
						exit;
					}

				}
			}
		}
	}


	// Insert and delete dummy data
	public static function datebook_required_notification() {

		global $wpdb;
		
		$theme_option_name = '';
		$theme_design_name = '';

		if ( isset($_GET['datebook-hide-data-notify']) && $_GET['datebook-hide-data-notify'] == 1) {
			update_option('datebook-hide-data-notify', 'yes');
		}
		
		$data_installation_required = (get_option('datebook-hide-data-notify') == 'yes' || isset($_GET['page']) && $_GET['page'] == 'datebook-options-install' || isset($_GET['page']) && $_GET['page'] == 'datebook-countries-installer' || strstr($_SERVER['REQUEST_URI'], 'index.php')) ? 1 : 0;

		if ($data_installation_required == 0) {

			$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';
			$check_countries_table = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_countries));

			$table_private_messages = strtolower($wpdb->prefix) . 'datebook_private_messages';
			$check_private_messages = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_private_messages));

			$table_profile_views = strtolower($wpdb->prefix) . 'datebook_profile_views';
			$check_profile_views = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_profile_views));

			$table_sessions = strtolower($wpdb->prefix) . 'datebook_sessions';
			$check_sessions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_sessions));

			if (
			get_option('datebook_all_pages_created') != 'yes' || 
			get_option('datebook_all_menus_installed') != 'yes' || 
			$check_countries_table != $table_countries || 
			$check_private_messages != $table_private_messages || 
			$check_profile_views != $table_profile_views || 
			$check_sessions != $table_sessions) {

				echo '<div class="clear"></div><div class="datebook-wrap"><div class="welcome-panel datebook-dummy-notify-box"><div class="welcome-panel-content">
				<h2>'.esc_html__( 'Data Installation Required!', 'datebook' ).'</h2>
				<p>'.esc_html__( 'This theme requires some pages, countries, menus, widgets, database tables to be installed.', 'datebook' ).'<br />
				'.esc_html__( 'Otherwise, it cannot function properly.', 'datebook' ).'</p>
				<p><a href="' . admin_url('/admin.php?page=datebook-options-install&required-data-install=yes&step=1&total=10') . '" class="button button-primary load-customize">'.esc_html__( 'Start Installation!', 'datebook' ).'</a> <a href="' . admin_url('/admin.php?page=datebook-options-install&datebook-hide-data-notify=1') . '" class="button button-secondary load-customize">'.esc_html__( 'Do not show me this notice again', 'datebook' ).'</a>
				</p>
			
				</div>
				</div>
				</div>';

			} else {

				$save_theme_options = (get_option('datebook-hide-data-notify') == 'yes' || isset($_GET['page']) && $_GET['page'] == 'datebook-options-framework' || isset($_GET['page']) && $_GET['page'] == 'datebook-options-design' || isset($_GET['page']) && $_GET['page'] == 'datebook-countries-installer' || strstr($_SERVER['REQUEST_URI'], 'index.php')) ? 1 : 0;
				
				// Insert and delete dummy data
				if ($save_theme_options == 0) {

					$option_name = preg_replace( "/\W/", '_', strtolower( get_option( 'stylesheet' ) ) );
					$theme_option_name = get_option( $option_name );
					if (!of_get_option('default_language') || $theme_option_name == '') {

						echo '<div class="clear"></div><div class="datebook-wrap"><div class="welcome-panel datebook-dummy-notify-box"><div class="welcome-panel-content">
						<h2>'.esc_html__( 'Save Theme Options!', 'datebook' ).'</h2>
						<p>'.esc_html__( 'We have detected you never saved theme options. It is required to function properly. Go to Theme Options page and click on the "Save" button at the bottom of the page.', 'datebook' ).'</p>
						<p><a href="' . admin_url('/admin.php?page=datebook-options-framework') . '" class="button button-primary load-customize">'.esc_html__( 'Go to Theme Options!', 'datebook' ).'</a></p>

						</div>
						</div>
						</div>';

					}

					/*$option_name = preg_replace( "/\W/", '_', strtolower( get_option( 'stylesheet' ) . '_design' ) );
					$theme_design_name = get_option( $option_name );
					if (!of_get_option('default_language') || $theme_design_name == '') {

						echo '<div class="clear"></div><div class="datebook-wrap"><div class="welcome-panel datebook-dummy-notify-box"><div class="welcome-panel-content">
						<h2>'.esc_html__( 'Save Design Options!', 'datebook' ).'</h2>
						<p>'.esc_html__( 'We have detected you never saved Design and Style options. It is required to function properly. Go to Design and Style page and click on the "Save" button at the bottom of the page.', 'datebook' ).'</p>
						<p><a href="' . admin_url('/admin.php?page=datebook-options-design') . '" class="button button-primary load-customize">'.esc_html__( 'Go to Design and Style!', 'datebook' ).'</a></p>

						</div>
						</div>
						</div>';

					}*/
    			}
			}
    	}


		if (of_get_option('default_language') || $theme_option_name != '') {
			if (get_option('datebook_upgrade_1') != 'yes' || get_option('datebook_upgrade_2') != 'yes' || get_option('datebook_upgrade_3') != 'yes' || get_option('datebook_upgrade_4') != 'yes' || get_option('datebook_upgrade_5') != 'yes' || get_option('datebook_upgrade_6') != 'yes' || get_option('datebook_upgrade_8') != 'yes' || get_option('datebook_upgrade_9') != 'yes' || get_option('datebook_upgrade_10') != 'yes' || get_option('datebook_upgrade_12') != 'yes' || get_option('datebook_upgrade_13') != 'yes') {

				echo '<div class="clear"></div><div class="datebook-wrap"><div class="welcome-panel datebook-dummy-notify-box"><div class="welcome-panel-content">
				<h2>'.esc_html__( 'Data Upgrade Required', 'datebook' ).'</h2>
				<p>'.esc_html__( 'This version of the theme includes some changes to the database and files. Click "Start Upgrade!" to make the necessary changes.', 'datebook' ).'</p>
				<p><a href="' . admin_url('/admin.php?page=datebook-options-install&upgrade-theme=yes') . '" class="button button-primary load-customize">'.esc_html__( 'Start Upgrade!', 'datebook' ).'</a></p>

				</div>
				</div>
				</div>';

			}

			if (get_option('datebook_upgrade_6') == 'yes' && (get_option('datebook_upgrade_7') != 'yes' || get_option('datebook_upgrade_11') != 'yes')) {
				if(empty($_POST['datebook-install-countries'])){
					
					echo '<div class="clear"></div><div class="datebook-wrap"><div class="welcome-panel datebook-dummy-notify-box"><div class="welcome-panel-content">';
					echo '<h2>'.esc_html__( 'Countries translated into different languages', 'datebook' ).'!</h2>';
					echo '<p>' . esc_html__( 'All countries and cities have been translated into several languages. You should re-install all countries. The installation process is painless, nothing will be lost.', 'datebook' ) . '</p>';

					echo '<form method="post" action="' . admin_url('/admin.php?page=datebook-countries-installer') . '">';

					wp_nonce_field('datebook-install-countries');

					echo '<p><input id="datebook" type="submit" class="button button-primary button-hero hide-if-no-js" name="datebook-install-countries" value="' . esc_html__( 'Start', 'datebook' ) . '" /></p>';

					echo '</form>';
					
					echo '</div></div></div>';

				}
			}
		}
	}
	
	
	// Make changes to MySQL database
	private static function datebook_makechanges_database() {

		global $wpdb;
		
		$collate = '';
		$charset = '';
		$collate_only = '';

		if ( $wpdb->has_cap( 'collation' ) ) {
			if ( ! empty($wpdb->charset ) ) {
				$collate .= "DEFAULT CHARACTER SET $wpdb->charset";
				$charset .= "CHARACTER SET $wpdb->charset";
			}
			if ( ! empty($wpdb->collate ) ) {
				$collate .= " COLLATE $wpdb->collate";
				$collate_only .= " COLLATE $wpdb->collate";
			}
		}

		// If you want to set special charset of database then place the name of your database instead of "datebook"
		//$wpdb->query("ALTER DATABASE datebook " . $charset);


		$table_private_messages = strtolower($wpdb->prefix) . 'datebook_private_messages';
		$check_private_messages = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_private_messages));

		if (get_option('datebook_upgrade_1') != 'yes') {

			if($check_private_messages == $table_private_messages) {

				$wpdb->query("ALTER TABLE " . $table_private_messages . " ADD fromdelete TINYINT(2) NOT NULL AFTER tosee");
				$wpdb->query("ALTER TABLE " . $table_private_messages . " ADD todelete TINYINT(2) NOT NULL AFTER fromdelete");
				
				$wpdb->query( "UPDATE " . $table_private_messages . " SET tosee = 1" );

				if ( !get_option('my_privacy_page') ) {
					
					// Main page order, Subpage order, Permalink, Page content, Page title, Page slug, Template file
					$datebook_pages_variables = array(
						array(24, 10, 'my_privacy_page', 'Here you can change privacy of your profile.', 'Profile &#8211; Privacy', 'privacy', 'page-datebook.php')
					);

					foreach ($datebook_pages_variables as $key => $page) {

						if ( !get_option($page[2]) ) {

							$post_parent_id = get_option('my_edit_profile_page');
			
							$new_page = array(
								'post_author' => '1',
								'post_content' => $page[3],
								'post_title' => $page[4],
								'post_status' => 'publish',
								'comment_status' => 'closed',
								'ping_status' => 'closed',
								'post_name' => $page[5],
								'post_parent' => $post_parent_id,
								'post_type' => 'page'
							);

							$new_page_id = wp_insert_post( $new_page );
			
							if ($new_page_id && $new_page_id != "0") {
								update_option($page[2], $new_page_id);
								$wpdb->insert( $wpdb->postmeta, array( 'post_id' => $new_page_id, 'meta_key' => '_wp_page_template', 'meta_value' => $page[6] ), array( '%d', '%s', '%s' ) );
							}
						}
					}
				}


				// Upgrade (Set) special pages to DateBook templates
				$pages_upgrade = array(get_option('page_on_front'), of_get_option('all_tours_page'), of_get_option('all_classifieds_page'), of_get_option('contact_page'), of_get_option('terms_page'), of_get_option('search_results_page'), of_get_option('login_page'), of_get_option('forgot_password_page'), of_get_option('registration_page'), of_get_option('my_edit_profile_page'), of_get_option('my_messages_page'), of_get_option('my_upgrade_page'), of_get_option('my_cart_page'), of_get_option('my_checkout_page'), of_get_option('my_photos_page'), of_get_option('my_comments_page'), of_get_option('my_tours_page'), of_get_option('my_verification_page'), of_get_option('my_blacklist_page'), of_get_option('my_favorites_page'), of_get_option('my_classifieds_page'), of_get_option('my_views_page'), of_get_option('my_settings_page'), of_get_option('my_privacy_page'), of_get_option('my_notification_page'));

				foreach ($pages_upgrade as $page_id){

					$wpdb->update( $wpdb->postmeta, array( 'meta_value' => 'page-datebook.php' ), array( 'post_id' => $page_id ));

				}

			}

			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_1', 'yes');

		}


		if (get_option('datebook_upgrade_2') != 'yes') {

			if($check_private_messages == $table_private_messages) {

				$wpdb->query("ALTER TABLE " . $table_private_messages . " " . $collate);
				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `sender` `sender` VARCHAR(30) " . $charset . " " . $collate_only . " NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `recipient` `recipient` VARCHAR(30) " . $charset . " " . $collate_only . " NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `subject` `subject` VARCHAR(255) " . $charset . " " . $collate_only . " NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `ip` `ip` VARCHAR(15) " . $charset . " " . $collate_only . " NULL DEFAULT NULL");

			}

			$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';
			$check_countries = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_countries));

			if($check_countries == $table_countries) {

				$wpdb->query("ALTER TABLE " . $table_countries . " " . $collate);
				//$wpdb->query("ALTER TABLE " . $table_countries . " CHANGE `name` `name` TINYTEXT " . $charset . " " . $collate_only . " NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_countries . " CHANGE `slug` `slug` VARCHAR( 200 ) " . $charset . " " . $collate_only . " NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_countries . " CHANGE `translation` `translation` LONGTEXT " . $charset . " " . $collate_only . " NULL DEFAULT NULL");

			}

			$table_profile_views = strtolower($wpdb->prefix) . 'datebook_profile_views';
			$check_profile_views = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_profile_views));

			if($check_profile_views == $table_profile_views) {
				$wpdb->query("ALTER TABLE " . $table_profile_views . " " . $collate);
			}


			$table_sessions = strtolower($wpdb->prefix) . 'datebook_sessions';
			$check_sessions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_sessions));

			if($check_sessions == $table_sessions) {

				$wpdb->query("ALTER TABLE " . $table_sessions . " " . $collate);
				$wpdb->query("ALTER TABLE " . $table_sessions . " CHANGE `id` `id` VARCHAR(191) " . $charset . " " . $collate_only . " NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_sessions . " CHANGE `data` `data` MEDIUMTEXT " . $charset . " " . $collate_only . " NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_sessions . " CHANGE `chatters` `chatters` LONGTEXT " . $charset . " " . $collate_only . " NULL DEFAULT NULL");
				$wpdb->query("ALTER TABLE " . $table_sessions . " CHANGE `hash` `hash` MEDIUMTEXT " . $charset . " " . $collate_only . " NOT NULL");

			}
			
			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_2', 'yes');
			
		}


		if (get_option('datebook_upgrade_3') != 'yes') {

			$table_member_subscriptions = strtolower($wpdb->prefix) . 'datebook_member_subscriptions';
			$check_member_subscriptions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_member_subscriptions));

			if($check_member_subscriptions == $table_member_subscriptions) {

				$wpdb->query("ALTER TABLE " . $table_member_subscriptions . " ADD plan_price_period TINYINT(2) NOT NULL AFTER subscription_plan_id");

			}

			$table_payments = strtolower($wpdb->prefix) . 'datebook_payments';
			$check_payments = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_payments));

			if($check_payments == $table_payments) {

				$wpdb->query("ALTER TABLE " . $table_payments . " ADD plan_price_period TINYINT(2) NOT NULL AFTER subscription_plan_id");

			}

			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_3', 'yes');

		}


		if (get_option('datebook_upgrade_4') != 'yes') {

			$table_payments = strtolower($wpdb->prefix) . 'datebook_payments';
			$check_payments = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_payments));

			if($check_payments == $table_payments) {

				$wpdb->query("ALTER TABLE " . $table_payments . " ADD start_date datetime DEFAULT NULL AFTER date");
				$wpdb->query("ALTER TABLE " . $table_payments . " ADD expiration_date datetime DEFAULT NULL AFTER start_date");

			}

			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_4', 'yes');

		}


		if (get_option('datebook_upgrade_5') != 'yes') {

			if (!get_option('my_notification_page') || !get_option('my_verification_page')) {

				// Main page order, Subpage order, Permalink, Page content, Page title, Page slug, Template file
				$datebook_pages_variables = array(
					array(18, 10, 'my_verification_page', 'Here you can upload photo that verify you. After that you get Verified Status.', 'Profile &#8211; Verification', 'verification', 'page-datebook.php'),
					array(26, 10, 'my_notification_page', 'Here you can see all personal notifications', 'Profile &#8211; Notification', 'notification', 'page-datebook.php')
				);

				foreach ($datebook_pages_variables as $key => $page) {

					if ( !get_option($page[2]) ) {

						$post_parent_id = get_option('my_edit_profile_page');

						$new_page = array(
							'post_author' => '1',
							'post_content' => $page[3],
							'post_title' => $page[4],
							'post_status' => 'publish',
							'comment_status' => 'closed',
							'ping_status' => 'closed',
							'post_name' => $page[5],
							'post_parent' => $post_parent_id,
							'post_type' => 'page'
						);

						$new_page_id = wp_insert_post( $new_page );

						if ($new_page_id && $new_page_id != "0") {
							update_option($page[2], $new_page_id);
							$wpdb->insert( $wpdb->postmeta, array( 'post_id' => $new_page_id, 'meta_key' => '_wp_page_template', 'meta_value' => $page[6] ), array( '%d', '%s', '%s' ) );
						}
					}
				}
			}

			// Upgrade (Set) special pages to DateBook templates
			$pages_upgrade = array(of_get_option('my_verification_page'), of_get_option('my_notification_page'));

			foreach ($pages_upgrade as $page_id){

				$wpdb->update( $wpdb->postmeta, array( 'meta_value' => 'page-datebook.php' ), array( 'post_id' => $page_id ));

			}

			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_5', 'yes');

		}


		if (get_option('datebook_upgrade_6') != 'yes') {

			$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';
			$check_countries = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_countries));

			if($check_countries == $table_countries) {

				$wpdb->query("ALTER TABLE " . $table_countries . " CHANGE `name` `name` LONGTEXT " . $charset . " " . $collate_only . " NULL DEFAULT NULL");

			}

			$table_private_messages = strtolower($wpdb->prefix) . 'datebook_private_messages';
			$check_private_messages = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_private_messages));

			if($check_private_messages == $table_private_messages) {

				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `message` `message` LONGTEXT " . $charset . " " . $collate_only . " NULL DEFAULT NULL");

			}

			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_6', 'yes');

		}


		if (get_option('datebook_upgrade_8') != 'yes') {

			$table_private_messages = strtolower($wpdb->prefix) . 'datebook_private_messages';
			$check_private_messages = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_private_messages));

			if($check_private_messages == $table_private_messages) {

				$wpdb->query("ALTER TABLE " . $table_private_messages . " ADD notified TINYINT(2) DEFAULT '0' NOT NULL AFTER status");

			}

			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_8', 'yes');

		}


		if (get_option('datebook_upgrade_9') != 'yes') {

			$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';
			$check_countries_table = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_countries));

			if ($check_countries_table == $table_countries) {

				$wpdb->query("ALTER TABLE " . $table_countries . " ADD class_counter INT(11) NOT NULL AFTER counter");
				$wpdb->query("ALTER TABLE " . $table_countries . " ADD tour_counter INT(11) NOT NULL AFTER class_counter");

			}

			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_9', 'yes');

		}


		if (get_option('datebook_upgrade_10') != 'yes') {

			$table_private_messages = strtolower($wpdb->prefix) . 'datebook_private_messages';
			$check_private_messages = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_private_messages));

			if($check_private_messages == $table_private_messages) {

				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `fromsee` `fromsee` TINYINT(2) DEFAULT '0' NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `tosee` `tosee` TINYINT(2) DEFAULT '0' NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `fromdelete` `fromdelete` TINYINT(2) DEFAULT '0' NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `todelete` `todelete` TINYINT(2) DEFAULT '0' NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `status` `status` TINYINT(2) DEFAULT '0' NOT NULL");
				$wpdb->query("ALTER TABLE " . $table_private_messages . " CHANGE `notified` `notified` TINYINT(2) DEFAULT '0' NOT NULL");

			}

			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_10', 'yes');

		}


		if (get_option('datebook_upgrade_12') != 'yes') {

			// Get Dashboard options
			// Gets option name as defined in the plugin
			if (function_exists('optionsframework_option_name')){
				$option_name = optionsframework_option_name();
			}
			
			// Fallback option name
			if ($option_name == ''){
				$option_name = get_option('stylesheet');
				$option_name = preg_replace("/\W/", "_", strtolower($option_name));
			}

			// Get option settings from database
			$options = get_option($option_name);

			// Get Design and Style options
			// Gets option name as defined in the plugin
			/*if ( function_exists( 'optionsframework_design_name' ) ) {
				$design_name = optionsframework_design_name();
			}

			// Fallback option name
			if ( $design_name == '' ) {
				$design_name = get_option( 'stylesheet' ) . '_design';
				$design_name = preg_replace( "/\W/", '_', strtolower( $design_name ) );
			}

			// Get option settings from database
			$designs = get_option($design_name);

			$new_options = array_merge($options, $designs);*/

			$new_options = $options;
			update_option($option_name, $new_options);


			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_12', 'yes');

		}


		if (get_option('datebook_upgrade_13') != 'yes') {

			$get_profile_form = get_option('datebook_profile_form');

			//read the json file contents
			$file = DATEBOOK_DIR . 'framework/sample/all_forms.json';

			$jsondata = wp_remote_get($file);

			if(isset($jsondata->errors['http_request_failed'][0]) && !empty($jsondata->errors['http_request_failed'][0])){

				if(in_array('curl', get_loaded_extensions()) || function_exists('curl_init') !== false) {

					$ch = curl_init();
					curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
					curl_setopt($ch, CURLOPT_HEADER, 0);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_URL, $file);
					curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
					$jsondata = curl_exec($ch);
					curl_close($ch);

				}

				$allow_url_curl = (is_array($jsondata) && !empty($jsondata['body'])) ? 1 : 0;

				if($allow_url_curl == 0){
					include $file . '.php';
					$jsondata = array('body' => $content);
				}

			}

			if (!empty($jsondata['body'])) {

				//convert json object to php associative array and add other forms to database
				$get_other_forms = json_decode($jsondata['body'],true);

				$get_profile_form['registration_form'] = $get_other_forms['registration_form'];
				$get_profile_form['settings_form'] = $get_other_forms['settings_form'];

				update_option('datebook_profile_form', $get_profile_form);

				unset($get_profile_form); //release memory

			}

			// Database is updated so we don't need to run this again
			update_option('datebook_upgrade_13', 'yes');

		}
	}


	// Set permalinks to Post name (/%postname%/)
	public static function datebook_reset_permalinks() {

	    global $wp_rewrite;
    	$wp_rewrite->set_permalink_structure('/%postname%/');
	    $wp_rewrite->flush_rules();

	}
	
	
	public static function datebook_custom_permalink() {
		
		add_action( 'all_admin_notices', array( __CLASS__, 'datebook_reset_permalinks' ) );
		
	}
	
	
	// Check the membership box to enable WordPress registration
	public static function datebook_users_can_register() {
		
		if (get_option('users_can_register') == 0) {
			
			update_option('users_can_register', 1);
			
		}
		
	}
	
	
	// Pages needed for theme
	public static function datebook_create_theme_pages() {

		global $wpdb, $datebook_pages_variables;
		
		self::datebook_pages_variables();

		foreach ($datebook_pages_variables as $key => $page) {

			if (isset($_GET['whattodo']) && $_GET['whattodo'] == 'recreate-pages' && isset($_GET['step']) && $_GET['step'] < 1000) {
				delete_option($page[2]);
			}

			if ( !get_option($page[2]) ) {
				if ( $page[1] > 0 ) {
					$parent_page = $page[1];
					$parent_id = $datebook_pages_variables[$parent_page][2];
					$post_parent_id = get_option($parent_id);
				} else {
					$post_parent_id = '0';
				}

				$new_page = array(
					'post_author' => '1',
					'post_content' => $page[3],
					'post_title' => $page[4],
					'post_status' => 'publish',
					'comment_status' => 'closed',
					'ping_status' => 'closed',
					'post_name' => $page[5],
					'post_parent' => $post_parent_id,
					'post_type' => 'page'
				);

				$new_page_id = wp_insert_post( $new_page );

				if ($new_page_id && $new_page_id != '0') {
					update_option($page[2], $new_page_id);
					$wpdb->insert( $wpdb->postmeta, array( 'post_id' => $new_page_id, 'meta_key' => '_wp_page_template', 'meta_value' => $page[6] ), array( '%d', '%s', '%s' ) );
				}
			}
		}
		
		// all pages are now created so we don't need to run this again
		update_option('datebook_all_pages_created', 'yes');
	
	}
	
	
	// Add all countries and cities
	public static function datebook_create_countries_table() {

		global $wpdb;

		// Create needed database table

		// $datebook_countries_table_version - holds current database version and used on plugin update to sync database tables
		$datebook_countries_table_version = '2.0';

		$table_name = strtolower($wpdb->prefix) . 'datebook_countries'; // do not forget about tables prefix

		$collate = '';

		if ( $wpdb->has_cap( 'collation' ) ) {
			if ( ! empty($wpdb->charset ) ) {
				$collate .= "DEFAULT CHARACTER SET $wpdb->charset";
			}
			if ( ! empty($wpdb->collate ) ) {
				$collate .= " COLLATE $wpdb->collate";
			}
		}

		// sql to create your table
		// NOTICE that:
		// 1. each field MUST be in separate line
		// 2. There must be two spaces between PRIMARY KEY and its name
		// Like this: PRIMARY KEY[space][space](id)
		// otherwise dbDelta will not work
		$sql = "CREATE TABLE " . $table_name . " (
			id int(11) NOT NULL AUTO_INCREMENT,
			name LONGTEXT NULL,
			slug VARCHAR(190) NOT NULL,
			translation LONGTEXT NULL,
			parent_id int(11) NOT NULL,
			level int(11) NOT NULL,
			counter int(11) NOT NULL,
			class_counter int(11) NOT NULL,
			tour_counter int(11) NOT NULL,
			active int(11) NOT NULL,
			INDEX (slug),
			PRIMARY KEY  (id)
		) " .  $collate . ";";

		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql);

		// notice that we are updating option, rather than adding it
		update_option('datebook_countries_table_version', $datebook_countries_table_version);


		// Insert countries and cities data
		include(DATEBOOK_DIR . 'framework/sample/countries/all_countries.php');

		if(isset($content) && !empty($content)){

			$jsondata = unserialize(urldecode($content));

			if (is_array($jsondata) && !empty($jsondata)) {

				foreach($jsondata as $country_key => $country_value){

					// insert items for DateBook Taxonomy method
					$wpdb->insert($table_name, array(
						'name' => $country_value['name'],
						'slug' => $country_value['slug'],
						'parent_id' => 0,
						'level' => 0,
						'counter' => 0,
						'active' => 1
					));
				}
			}
		}
	}


	// Create all menus
	public static function datebook_create_menus() {

		$pages = array(
			array(array('datebook-footer-menu'), 'Terms and Conditions', 'terms'),
			array(array('datebook-top-menu-left'), 'Blog', 'blog'),
			array(array('datebook-top-menu-right', 'datebook-footer-menu'), 'Contact Us', 'contact'),
			array(array('datebook-primary-menu'), 'Homepage', 'home'),
			array(array('datebook-primary-menu'), 'Searching', 'searching'),
			array(array('datebook-primary-menu'), 'Classifieds', 'classifieds'),
			array(array('datebook-primary-menu'), 'Tours', 'tours'),
			
		);

		$menus = array(
			'datebook-top-menu-left' => esc_html__( 'Top Left', 'datebook' ),
			'datebook-top-menu-right' => esc_html__( 'Top Right', 'datebook' ),
			'datebook-primary-menu' => esc_html__( 'Primary', 'datebook' ),
			'datebook-footer-menu' => esc_html__( 'Footer', 'datebook' )
		);

		foreach ($menus as $key => $menu_name) {

			if (!term_exists( $menu_name, "nav_menu")) {

				$menu_exists = wp_get_nav_menu_object($menu_name);

				if (!$menu_exists) {

					$menu_id = wp_create_nav_menu($menu_name);
					$menu = get_term_by( 'name', $menu_name, 'nav_menu' );

					foreach ($pages as $key2 => $page) {

						if (in_array($key, $page[0])) {

							$myPage = get_page_by_title($page[1]);

							wp_update_nav_menu_item($menu->term_id, 0, array(
								'menu-item-object-id' => $myPage->ID,
								'menu-item-title' => $myPage->post_title,
								'menu-item-status' => 'publish',
								'menu-item-object' => 'page',
								'menu-item-type' => 'post_type'
							));

						}
					}
				}
			}
		}
	
		// all menus are now created so we don't need to run this again
		update_option('datebook_all_menus_installed', 'yes');

	}
	

	/**
	 * Deactivate WordPress Importer plugin
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_deactivate_wordpress_importer_plugin() {

		if (get_option('datebook_all_widgets_installed') != 'yes') {

			if ( is_plugin_active( 'wordpress-importer/wordpress-importer.php' ) ) {

				deactivate_plugins( 'wordpress-importer/wordpress-importer.php' );

			}
		}
	}

	public static function datebook_class_importer() {

		require_once( DATEBOOK_DIR . 'framework/installer/class-importer.php');

	}
	
	// Install Widgets
	public static function datebook_create_widgets() {

		self::datebook_class_importer();

		// Doing import
   		$importer = new DateBook_WidgetsImporter();

		// Widgets are now created so we don't need to run this again
		update_option('datebook_all_widgets_installed', 'yes');

	}


	// Create Private Messages Table
	public static function datebook_create_Private_Messages_table() {

		global $wpdb;

		$table_name = strtolower($wpdb->prefix) . 'datebook_private_messages';
		$check_private_messages = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_name));

		if($check_private_messages != $table_name) {

			$collate = '';

			if ( $wpdb->has_cap( 'collation' ) ) {
				if ( ! empty($wpdb->charset ) ) {
					$collate .= "DEFAULT CHARACTER SET $wpdb->charset";
				}
				if ( ! empty($wpdb->collate ) ) {
					$collate .= " COLLATE $wpdb->collate";
				}
			}

			$sql = "CREATE TABLE " . $table_name . " (
				id bigint(20) NOT NULL AUTO_INCREMENT,
				senderid bigint(20) DEFAULT '0' NOT NULL,
				rcpid bigint(20) DEFAULT '0' NOT NULL,
				sender VARCHAR(30) NOT NULL,
				recipient VARCHAR(30) NOT NULL,
				subject VARCHAR(255) NOT NULL,
				message LONGTEXT NULL,
				fromsee TINYINT(2) DEFAULT '0' NOT NULL,
				tosee TINYINT(2) DEFAULT '0' NOT NULL,
				fromdelete TINYINT(2) DEFAULT '0' NOT NULL,
				todelete TINYINT(2) DEFAULT '0' NOT NULL,
				chat_mode TINYINT(2) DEFAULT '1',
				date TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
				status TINYINT(2) DEFAULT '0' NOT NULL,
				notified TINYINT(2) DEFAULT '0' NOT NULL,
				ip VARCHAR(15),
				PRIMARY KEY id (id)
			) " .  $collate . ";";

			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql);

			// Private Message database table is now created so we don't need to run this again
			update_option('datebook_mysql_messages_installed', 'yes');

		}
	}


	// Create Who Viewed Me (Profile Views) Table
	public static function datebook_create_Who_Viewed_Me_table() {

		global $wpdb;

		$table_name = strtolower($wpdb->prefix) . 'datebook_profile_views';
		$check_profile_views = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_name));

		if($check_profile_views != $table_name) {

			$collate = '';

			if ( $wpdb->has_cap( 'collation' ) ) {
				if ( ! empty($wpdb->charset ) ) {
					$collate .= "DEFAULT CHARACTER SET $wpdb->charset";
				}
				if ( ! empty($wpdb->collate ) ) {
					$collate .= " COLLATE $wpdb->collate";
				}
			}

			$sql = "CREATE TABLE " . $table_name . " (
				id bigint(20) NOT NULL AUTO_INCREMENT,
				profile_id bigint(20) DEFAULT '0' NOT NULL,
				visitor_id bigint(20) DEFAULT '0' NOT NULL,
				status TINYINT(2),
				viewdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
				PRIMARY KEY id (id)
			) " .  $collate . ";";

			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql);

			// Who Viewed Me database table is now created so we don't need to run this again
			update_option('datebook_mysql_who_viewed_me_installed', 'yes');

		}
	}


	// Create Sessions (for Private Message) Table
	public static function datebook_create_sessions_table() {

		global $wpdb;

		$table_sessions = strtolower($wpdb->prefix) . 'datebook_sessions';
		$check_sessions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_sessions));

		if($check_sessions != $table_sessions) {

			$collate = '';

			if ( $wpdb->has_cap( 'collation' ) ) {
				if ( ! empty($wpdb->charset ) ) {
					$collate .= "DEFAULT CHARACTER SET $wpdb->charset";
				}
				if ( ! empty($wpdb->collate ) ) {
					$collate .= " COLLATE $wpdb->collate";
				}
			}

			$sql = "CREATE TABLE " . $table_sessions . " (
				id VARCHAR(191) NOT NULL,
				data longtext NULL,
				chatters longtext NULL,
				hash longtext NULL,
				timestamp int(11) NOT NULL,
				PRIMARY KEY  (id)
			) " .  $collate . ";";

			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql);
			
			// Who Viewed Me database table is now created so we don't need to run this again
			update_option('datebook_sessions_installed', 'yes');

		}

	}


	// Create Who Viewed Me (Profile Views) Table
	public static function datebook_create_members_table() {

		global $wpdb;

		$table_name_member_subscriptions = strtolower($wpdb->prefix) . 'datebook_member_subscriptions';
		$table_name_member_subscriptionmeta = strtolower($wpdb->prefix) . 'datebook_member_subscriptionmeta';

		$check_member_subscriptions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_name_member_subscriptions));

		if($check_member_subscriptions != $table_name_member_subscriptions) {

			$collate = '';

			if ( $wpdb->has_cap( 'collation' ) ) {
				if ( ! empty($wpdb->charset ) ) {
					$collate .= "DEFAULT CHARACTER SET $wpdb->charset";
				}
				if ( ! empty($wpdb->collate ) ) {
					$collate .= " COLLATE $wpdb->collate";
				}
			}

			$sql = "CREATE TABLE " . $table_name_member_subscriptions . " (
				id bigint(20) AUTO_INCREMENT NOT NULL PRIMARY KEY,
				user_id bigint(20) NOT NULL,
				subscription_plan_id bigint(20) NOT NULL,
				plan_price_period TINYINT(2) NOT NULL,
				start_date datetime DEFAULT NULL,
				expiration_date datetime DEFAULT NULL,
				status varchar(32) NOT NULL,
				payment_profile_id varchar(32) NOT NULL,
				payment_gateway varchar(32) NOT NULL,
				billing_amount float(10) NOT NULL,
				billing_duration int(10) NOT NULL,
				billing_duration_unit varchar(32) NOT NULL,
				billing_cycles int(10) NOT NULL,
				billing_next_payment datetime DEFAULT NULL,
				billing_last_payment datetime DEFAULT NULL,
				trial_end datetime DEFAULT NULL,
				KEY user_id (user_id),
				KEY subscription_plan_id (subscription_plan_id)
				) " .  $collate . ";
			CREATE TABLE " . $table_name_member_subscriptionmeta . " (
				meta_id bigint(20) AUTO_INCREMENT NOT NULL,
				member_subscription_id bigint(20) NOT NULL DEFAULT '0',
				meta_key varchar(255),
				meta_value longtext,
				PRIMARY KEY  (meta_id),
				KEY member_subscription_id (member_subscription_id),
				KEY meta_key (meta_key)
				) " .  $collate . ";";

			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql);

			// Who Viewed Me database table is now created so we don't need to run this again
			update_option('datebook_mysql_member_subscriptions_installed', 'yes');

		}
	}


	// Create Payments Table
	public static function datebook_create_payments_table() {

		global $wpdb;

		$table_name_payments = strtolower($wpdb->prefix) . 'datebook_payments';
		$table_name_paymentmeta = strtolower($wpdb->prefix) . 'datebook_paymentmeta';

		$check_payments = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_name_payments));

		if($check_payments != $table_name_payments) {

			$collate = '';

			if ( $wpdb->has_cap( 'collation' ) ) {
				if ( ! empty($wpdb->charset ) ) {
					$collate .= "DEFAULT CHARACTER SET $wpdb->charset";
				}
				if ( ! empty($wpdb->collate ) ) {
					$collate .= " COLLATE $wpdb->collate";
				}
			}

			$sql = "CREATE TABLE " . $table_name_payments . " (
				id bigint(20) NOT NULL AUTO_INCREMENT,
				user_id bigint(20) NOT NULL,
				subscription_plan_id bigint(20) NOT NULL,
				plan_price_period TINYINT(2) NOT NULL,
				status varchar(32) NOT NULL,
				date datetime DEFAULT NULL,
				start_date datetime DEFAULT NULL,
				expiration_date datetime DEFAULT NULL,
				payment_gateway varchar(32) NOT NULL,
				amount float(10) NOT NULL,
				currency varchar(32) NOT NULL,
				type varchar(64) NOT NULL,
				transaction_id varchar(32) NOT NULL,
				profile_id varchar(32) NOT NULL,
				logs longtext NOT NULL,
				ip_address varchar(64) NOT NULL,
				UNIQUE KEY id (id),
				KEY user_id (user_id)
				) " .  $collate . ";
			CREATE TABLE " . $table_name_paymentmeta . " (
				meta_id bigint(20) AUTO_INCREMENT NOT NULL,
				payment_id bigint(20) NOT NULL DEFAULT '0',
				meta_key varchar(255),
				meta_value longtext,
				PRIMARY KEY  (meta_id),
				KEY payment_id (payment_id),
				KEY meta_key (meta_key)
				) " .  $collate . ";";

			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql);

			// Who Viewed Me database table is now created so we don't need to run this again
			update_option('datebook_mysql_payments_installed', 'yes');

		}
	}


	// Create Notifications Table
	public static function datebook_create_notifications_table() {

		global $wpdb;

		$table_notifications = strtolower($wpdb->prefix) . 'datebook_notifications';

		$check_notifications = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_notifications));

		if($check_notifications != $table_notifications) {

			$collate = '';

			if ( $wpdb->has_cap( 'collation' ) ) {
				if ( ! empty($wpdb->charset ) ) {
					$collate .= "DEFAULT CHARACTER SET $wpdb->charset";
				}
				if ( ! empty($wpdb->collate ) ) {
					$collate .= " COLLATE $wpdb->collate";
				}
			}

			$sql = "CREATE TABLE " . $table_notifications . " (
				id int(11) NOT NULL AUTO_INCREMENT,
				post_ID int(11) NOT NULL,
				title TEXT NULL,
				display_in TEXT NULL,
				location_id VARCHAR(100) NULL,
				design_id VARCHAR(100) NULL,
				animation_id VARCHAR(100) NULL,
				animation_out_id VARCHAR(100) NULL,
				delay int(11) DEFAULT '2000',
				show_time int(11) DEFAULT '8000',
				enabled VARCHAR(100) NULL,
				user_types VARCHAR(100) NULL,
				device_class VARCHAR(100) NULL,
				PRIMARY KEY  (id)
			) " .  $collate . ";";

			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql);

			// Who Viewed Me database table is now created so we don't need to run this again
			update_option('datebook_notifications_installed', 'yes');

		}
	}


	// Create Demo Profiles
	public static function datebook_create_demo_profiles() {
		
		global $wpdb;
		
		$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';

		$men_names = array('Aaron', 'Abel', 'Abner', 'Abraham', 'Adam', 'Adrian', 'Alan', 'Albert', 'Alexander', 'Alfred', 'Algernon', 'Alister', 'Alonso', 'Alphonso', 'Alvin', 'Ambrose', 'Amos', 'Andrew', 'Angus', 'Anthony', 'Archibald', 'Arnold', 'Arthur', 'Augustus', 'Augustine', 'Austin', 'Avery', 'Baldwin', 'Barry', 'Barty', 'Basil', 'Benedict', 'Bennie', 'Bennet', 'Berney', 'Bert', 'Bertram', 'Bertrand', 'Blake', 'Bradford', 'Brad', 'Brandon', 'Brenton', 'Bryan', 'Broderick', 'Bruce', 'Bruno', 'Byron', 'Calvin', 'Cameron', 'Carey', 'Carl', 'Casey', 'Caspar', 'Cedric', 'Charles', 'Chester', 'Christian', 'Christopher', 'Clarence', 'Clark', 'Claude', 'Clayton', 'Clifford', 'Clive', 'Colin', 'Cornelius', 'Craig', 'Curtis', 'Cyrus', 'Dale', 'Daniel', 'Darrell', 'David', 'Dean', 'Dennis', 'Derek', 'Desmond', 'Dexter', 'Dominic', 'Don', 'Donald', 'Donovan', 'Dorian', 'Douglas', 'Drew', 'Dwayne', 'Duke', 'Dunny', 'Dustin', 'Dylan', 'Edgar', 'Edward', 'Edwin', 'Elliot', 'Elton', 'Elvis', 'Emery', 'Emil', 'Emmanuel', 'Eric', 'Ernest', 'Irvin', 'Ethan', 'Eugene', 'Eustace', 'Evan', 'Everard', 'Everett', 'Fabian', 'Felix', 'Ferdinand', 'Fergus', 'Floyd', 'Ford', 'Francis', 'Franklin', 'Frederick', 'Ricky', 'Fred', 'Gabriel', 'Garrett', 'Geoffrey', 'George', 'Gerald', 'Gilbert', 'Glenn', 'Graham', 'Grant', 'Gregory', 'Griffith', 'Harold', 'Harris', 'Harvey', 'Henry', 'Herbert', 'Herman', 'Horace', 'Howard', 'Hugh', 'Hugo', 'Humphrey', 'Ian', 'Ignatius', 'Irvin', 'Isaac', 'Ivor', 'Jack', 'Jacob', 'James', 'Jason', 'Jasper', 'Jefferson', 'Jeffrey', 'Jeremy', 'Jerome', 'Jesse', 'John', 'Jonathan', 'Joseph', 'Joshua', 'Julian', 'Justin', 'Karl', 'Keith', 'Kelly', 'Kelvin', 'Kendall', 'Kendrick', 'Kenneth', 'Kent', 'Kevin', 'Kristopher', 'Kurt', 'Kyle', 'Lambert', 'Lamont', 'Lancelot', 'Laurence', 'Lee', 'Leo', 'Leonard', 'Leopold', 'Leroy', 'Leslie', 'Lester', 'Lewis', 'Lincoln', 'Lindon', 'Lindsay', 'Linus', 'Lionel', 'Lloyd', 'Logan', 'Lonnie', 'Louis', 'Lowell', 'Lucian', 'Luke', 'Luther', 'Lyle', 'Lynn', 'Malcolm', 'Manuel', 'Marion', 'Mark', 'Marshall', 'Martin', 'Marvin', 'Matthew', 'Matthias', 'Maurice', 'Maximilian', 'Maxwell', 'Maynard', 'Melvin', 'Merlin', 'Merrill', 'Michael', 'Miles', 'Milton', 'Mitchell', 'Monroe', 'Montague', 'Montgomery', 'Morgan', 'Mortimer', 'Morton', 'Moses', 'Murray', 'Nathan', 'Neal', 'Nelson', 'Nevill', 'Newton', 'Nicholas', 'Nigel', 'Noah', 'Noel', 'Norbert', 'Norris', 'Norman', 'Norton', 'Oliver', 'Orson', 'Orville', 'Oscar', 'Oswald', 'Owen', 'Patrick', 'Paul', 'Percival', 'Perry', 'Peter', 'Philip', 'Quentin', 'Quincy', 'Ralph', 'Randall', 'Randolph', 'Raphael', 'Raymond', 'Reginald', 'Rene', 'Reuben', 'Reynold', 'Richard', 'Rick', 'Robert', 'Roderic', 'Rodney', 'Roger', 'Roland', 'Rolph', 'Ronald', 'Ron', 'Roscoe', 'Ross', 'Roy', 'Rudolph', 'Russell', 'Ryan', 'Samson', 'Samuel', 'Sanford', 'Saul', 'Scott', 'Sean', 'Sebastian', 'Seth', 'Seymour', 'Shannon', 'Sheldon', 'Shelley', 'Sidney', 'Silas', 'Silvester', 'Simeon', 'Simon', 'Solomon', 'Stacy', 'Stanley', 'Stephen', 'Stuart,Terence', 'Thaddeus', 'Theodore', 'Timothy', 'Thomas', 'Tobias', 'Todd', 'Tracy', 'Travis', 'Tristram', 'Troy', 'Tyler', 'Ulysses', 'Uriah', 'Valentine', 'Valerian', 'Vernon', 'Victor', 'Vincent', 'Virgil', 'Wallace', 'Walter', 'Warren', 'Wayne', 'Wesley', 'Wilbur', 'Wiley', 'Wilfred', 'Willard', 'William', 'Willis', 'Wilson', 'Winfred', 'Winston', 'Woodrow', 'Xavier', 'Zacky');


		$women_names = array('Abigail', 'Ada', 'Adelaide', 'Adele', 'Adeline', 'Adriana', 'Agatha', 'Agnes', 'Aileen', 'Alberta', 'Alexandra', 'Alexis', 'Alfreda', 'Alice', 'Alison', 'Althea', 'Amabel', 'Amanda', 'Amber', 'Amelia', 'Amy', 'Anastasia', 'Andrea', 'Angela', 'Anita', 'Anna', 'Annabel', 'Annette', 'Antoinette', 'Antonia', 'April', 'Arabella', 'Arlene', 'Ashley', 'Audrey', 'Augusta', 'Augustina', 'Aurora', 'Barbara', 'Beatrice', 'Belinda', 'Belle', 'Berenice', 'Bertha', 'Betty', 'Beverly', 'Blanche', 'Bonnie', 'Brenda', 'Brett', 'Bridget', 'Brittany', 'Camille', 'Candace', 'Caren', 'Carla', 'Carlotta', 'Carmen', 'Carol', 'Caroline', 'Cassandra', 'Catherine', 'Cecilia', 'Celeste', 'Celestine', 'Celia', 'Celine', 'Charity', 'Charlotte', 'Cheryl', 'Christine', 'Clara', 'Clarice', 'Claudia', 'Clemency', 'Clementine', 'Colleen', 'Constance', 'Cora', 'Cordelia', 'Corinna', 'Cornelia', 'Courtney', 'Crystal', 'Cynthia', 'Daisy', 'Danielle', 'Daphne', 'Darlene', 'Deborah', 'Delia', 'Della', 'Denise', 'Diana', 'Dina', 'Dolores', 'Dominique', 'Donna', 'Dora', 'Doreen', 'Doris', 'Dorothy', 'Edith', 'Edna', 'Elaine', 'Eleanor', 'Elisa', 'Elizabeth', 'Ella', 'Ellen', 'Eloise', 'Elsie', 'Elvira', 'Emily', 'Emma', 'Erica', 'Erin', 'Ernestine', 'Estelle', 'Esther', 'Ethel', 'Etta', 'Eugenia', 'Eulalia', 'Eunice', 'Euphemia', 'Eustacia', 'Eva', 'Eveline', 'Evangeline', 'Faith', 'Felicia', 'Florence', 'Frances', 'Francesca', 'Francine', 'Frederica', 'Gabrielle', 'Genevieve', 'Georgina', 'Geraldine', 'Gertrude', 'Gillian', 'Gina', 'Gladys', 'Glenda', 'Gloria', 'Grace', 'Gwendolen', 'Hannah', 'Harriet', 'Hazel', 'Heather', 'Helen', 'Henrietta', 'Hester', 'Hillary', 'Hilda', 'Holly', 'Hope', 'Ida', 'Imogen', 'Irene', 'Iris', 'Irma', 'Isabel', 'Jacqueline', 'Jane', 'Janet', 'Janice', 'Jean', 'Jeannette', 'Jemima', 'Jennifer', 'Jenny', 'Jessica', 'Jill', 'Joanna', 'Joceline', 'Josephine', 'Joyce', 'Judith', 'Julia', 'Julianne', 'Juliet', 'June', 'Justina', 'Karen', 'Katherine', 'Kathleen', 'Kelly', 'Kimberly', 'Kristina', 'Laura', 'Laureen', 'Laurel', 'Laverne', 'Lavinia', 'Leah', 'Leila', 'Lena', 'Leona', 'Leonora', 'Leslie', 'Leticia', 'Lillian', 'Lily', 'Linda', 'Lindsay', 'Lisa', 'Lois', 'Lona', 'Lora', 'Lorena', 'Lorna', 'Loretta', 'Lorinda', 'Lorraine', 'Lottie', 'Louise', 'Lucille', 'Lucinda', 'Lucy', 'Lydia', 'Lynn', 'Mabel', 'Madeline', 'Magdaline', 'Marcia', 'Margaret', 'Marianne', 'Marilyn', 'Maribel', 'Marietta', 'Marina', 'Marion', 'Marjorie', 'Martha', 'Mary', 'Mary', 'Matilda', 'Maud', 'Maureen', 'Maxine', 'Megan', 'Melanie', 'Melinda', 'Melissa', 'Mercedes', 'Meredith', 'Michelle', 'Mildred', 'Millicent', 'Minnie', 'Miranda', 'Miriam', 'Molly', 'Mona', 'Monica', 'Morgan', 'Muriel', 'Myra', 'Nadine', 'Natalie', 'Nancy', 'Nell', 'Nettie', 'Nicki', 'Nicole', 'Nina', 'Noel', 'Nora', 'Noreen', 'Norma', 'Octavia', 'Olivia', 'Ophelia', 'Pamela', 'Pansy', 'Patricia', 'Paula', 'Pearl', 'Peggy', 'Penelope', 'Phoebe', 'Phyllis', 'Polly', 'Priscilla', 'Prudence', 'Rachel', 'Raquel', 'Rebecca', 'Regina', 'Renata', 'Renee', 'Rhoda', 'Rhonda', 'Roberta', 'Rose', 'Rosabel', 'Rosalie', 'Rosaline', 'Rosalinda', 'Rosanna', 'Rosemary', 'Rowena', 'Roxanna', 'Ruby', 'Ruth', 'Sabrina', 'Samantha', 'Sarah', 'Selina', 'Selma', 'Shannon', 'Sharon', 'Shauna', 'Sheila', 'Shelley', 'Shirley', 'Sibyl', 'Sidney', 'Sonia', 'Sophia', 'Stacy', 'Stephanie', 'Stella', 'Susan', 'Sylvia', 'Tabitha', 'Tamara', 'Tanya', 'Teresa', 'Theodora', 'Thelma', 'Tiffany', 'Tina', 'Tracy', 'Ulrica', 'Una', 'Ursula', 'Valentina', 'Valerie', 'Vanessa', 'Vera', 'Verna', 'Veronica', 'Victoria', 'Vida', 'Viola', 'Violetta', 'Virginia', 'Vivian', 'Wanda', 'Wendy', 'Wilhelmina', 'Winifred', 'Yolanda', 'Yvonne', 'Yvette', 'Zoey');


		$countries = array( 'germany', 'australia', 'france', 'sweden', 'spain' );
		$regions = array( 'germany' => 'berlin', 'australia' => 'sydney', 'france' => 'paris', 'sweden' => 'stockholm', 'spain' => 'madrid' );
		$cities = array( 'germany' => 'berlin', 'australia' => 'sydney', 'france' => 'paris', 'sweden' => 'stockholm', 'spain' => 'madrid' );

		for ($i = 0; $i <= 4; $i++) {

			$country_slug = $countries[$i];

			$city_slug = DateBook_Utilities::datebook_makeslug($cities[$country_slug]);
			$term_data = DateBook_Utilities::datebook_get_term_by( 'slug', $city_slug );

			$country_id = isset($term_data->country_id) ? $term_data->country_id : '';
			$region_id = isset($term_data->region_id) ? $term_data->region_id : '';
			$city_id = isset($term_data->city_id) ? $term_data->city_id : '';


			$gender = rand(1, 2);
			if ($gender == 1) {
				$profile_name = $women_names[array_rand($women_names)];
			} else {
				$profile_name = $men_names[array_rand($men_names)];
			}

			$pre_emailaddress = strtolower($profile_name).time();
			
			$emailaddress = $pre_emailaddress . '@website.com';

			if ( email_exists($emailaddress) == false ) {
			
				$userdata = array(
					'user_login'	=> $pre_emailaddress,
					'user_email'	=> $emailaddress,
					'user_pass'	 => $pre_emailaddress,
					'display_name'  => $profile_name
				);
			
				$current_user_id = wp_insert_user($userdata);

				$aboutyou = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed ultrices dui eu lectus fringilla non pellentesque magna egestas. Suspendisse potenti. Vivamus at magna libero. Donec et purus nunc, eu aliquam diam. Nesciunt tofu stumptown aliqua, retro synth master cleanse. Mustache cliche tempor, williamsburg carles vegan helvetica.';

				// Create post object
				$post_profile = array(
					'post_author' => $current_user_id,
					'post_title' => $profile_name,
					'post_content' => $aboutyou,
					'post_name' => $i.time(),
					'post_status' => 'publish',
					'post_type' => DATEBOOK_POST_TYPE,
					'ping_status' => 'closed'
				);
				// Insert the post into the database
				$profile_id = wp_insert_post( $post_profile );

				$dateyear = rand(1980, 1998);
				$datemonth = rand(01, 12);
				$dateday = rand(01, 28);
				$sexualorientation = rand(0, 3);

				update_post_meta($profile_id, 'country', absint($country_id));
				update_post_meta($profile_id, 'region', absint($region_id));
				update_post_meta($profile_id, 'city', absint($city_id));
				update_post_meta($profile_id, 'birthday', sanitize_text_field($dateyear . '-' . $datemonth . '-' . $dateday));
				update_post_meta($profile_id, 'gender', absint($gender));
				update_post_meta($profile_id, 'sexualorientation', absint($sexualorientation));
				update_post_meta($profile_id, 'family_status', 'single');
				update_post_meta($profile_id, 'topad', '0');
				update_post_meta($profile_id, 'featured', '0');

				$online_status =  mktime(0, 0, 0, date("m"), date("d")-rand(1, 20), date("Y"));
				update_user_meta( $current_user_id, 'online_status', sanitize_text_field($online_status) );
				update_user_meta( $current_user_id, 'profile_type', DATEBOOK_POST_TYPE );
				update_user_meta( $current_user_id, 'profile_postid', absint($profile_id) );

				$datebook_get_data = $profile_field_data = array();
				$datebook_get_data['country'] = $country_id;
				$datebook_get_data['region'] = $region_id;
				$datebook_get_data['city'] = $city_id;
				$datebook_get_data['birthday'] = $dateyear . '-' . $datemonth . '-' . $dateday;
				$datebook_get_data['dateyear'] = $dateyear;
				$datebook_get_data['datemonth'] = $datemonth;
				$datebook_get_data['dateday'] = $dateday;
				$datebook_get_data['gender'] = $gender;
				$datebook_get_data['sexualorientation'] = $sexualorientation;
				$datebook_get_data['topad'] = 0;
				$datebook_get_data['featured'] = 0;
				$datebook_get_data['family_status'] = "single";
				$datebook_get_data['upload_folder'] = $i . time() . rand(1,999);
				$datebook_get_data['profile_type'] = DATEBOOK_POST_TYPE;
				$datebook_get_data['profile_postid'] = $profile_id;
				$datebook_get_data['online_status'] = $online_status;
				$datebook_get_data['phone'] = "+" . rand(1234567890, 9234567890);
				$datebook_get_data['wishtravel'] = rand(0, 1);
				$datebook_get_data['wishtraveltext'] = 'Donec consectetur libero ut tortor condimentum eu egestas est viverra. Sed eget turpis dui, sed auctor nisi. Fusce suscipit risus sed tortor mattis sollicitudin. Vivamus dictum, nisl sed aliquet sodales, nisi ipsum interdum metus.';
				$datebook_get_data['ip'] = '';
				$datebook_get_data['hostname'] = '';


				// get demo profile fields

				$get_random_profile_fields = rand(1, 2);

				// Insert countries and cities data
				$file = DATEBOOK_DIR . 'framework/sample/profile_edit_' . $gender . '_' . $get_random_profile_fields . '.json';
				
				//read the json file contents
				$jsondata = wp_remote_get($file);

				if(isset($jsondata->errors['http_request_failed'][0]) && !empty($jsondata->errors['http_request_failed'][0])){

					if(in_array('curl', get_loaded_extensions()) || function_exists('curl_init') !== false) {

						$ch = curl_init();
						curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
						curl_setopt($ch, CURLOPT_HEADER, 0);
						curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
						curl_setopt($ch, CURLOPT_URL, $file);
						curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
						$jsondata = curl_exec($ch);
						curl_close($ch);

					}

					$allow_url_curl = (is_array($jsondata) && !empty($jsondata['body'])) ? 1 : 0;

					if($allow_url_curl == 0){
						include $file . '.php';
						$jsondata = array('body' => $content);
					}

				}

				if (is_array($jsondata) && !empty($jsondata['body'])) {

					//convert json object to php associative array
					$datebook_get_filled_custom_fields = json_decode($jsondata['body'],true);

					foreach($datebook_get_data as $key => $value) {

						// sanitize data in array
						if (is_array($value)) {
							$value = array_map( 'sanitize_text_field', $value );
						} else {
							$value = sanitize_text_field( $value );
						}

						//Alter the options array appropriately
						$profile_field_data[sanitize_key($key)] = $value;

					}

					// Insert member filled custom fields
					foreach($datebook_get_filled_custom_fields as $key => $value) {

						if (is_array($value)) {
							$value = array_map( 'sanitize_text_field', $value );
						} else {
							$value = sanitize_text_field( $value );
						}

						$profile_field_data['edit_form'][sanitize_key($key)] = $value;

					}

					// Update the post meta
					update_post_meta($profile_id, 'profile_personal_data', $profile_field_data);
					
					$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET counter = counter + 1 WHERE id = %d", $country_id) );
					$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET counter = counter + 1 WHERE id = %d", $region_id) );
					$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET counter = counter + 1 WHERE id = %d", $city_id) );
				}
			}

			if (isset($_GET['demo-profiles-step']) && $_GET['demo-profiles-step'] == '6') {
				// all demo profiles are now created so we don't need to run this again
				update_option('datebook_all_demo_profiles_created', 'yes');
			}
		}
	}


	// Create Demo Tours
	public static function datebook_create_demo_tours() {
		
		global $wpdb;
		
		$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';

		$countries = array( 'germany', 'australia', 'france', 'sweden', 'spain' );
		$cities = array( 'germany' => 'Berlin', 'australia' => 'Sydney', 'france' => 'Paris', 'sweden' => 'Stockholm', 'spain' => 'Madrid' );

		$i = 0;
		
		$profileusers = get_users( 'role=subscriber' );
		
		foreach ( $profileusers as $user ) {
			
			$current_user_id = $user->ID;

			$addto_post_id = get_user_meta( $current_user_id, 'profile_postid', true );
			
			if ($addto_post_id == '') continue;

			$i++; if ($i == 5) $i=0;

			$country_slug = $countries[$i];

			$term_data = DateBook_Utilities::datebook_get_term_by( 'slug', $cities[$country_slug] );

			$country_id = isset($term_data->country_id) ? $term_data->country_id : '';
			$region_id = isset($term_data->region_id) ? $term_data->region_id : '';
			$city_id = isset($term_data->city_id) ? $term_data->city_id : '';

			$tourtitle = 'This is title for Tour';

			$tourdescription = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed ultrices dui eu lectus fringilla non pellentesque magna egestas. Suspendisse potenti. Vivamus at magna libero. Donec et purus nunc, eu aliquam diam. Nesciunt tofu stumptown aliqua, retro synth master cleanse. Mustache cliche tempor, williamsburg carles vegan helvetica.';

			// Insert tour
			$tour_profile = array(
				'post_title' => $tourtitle,
				'post_content' => $tourdescription,
				'post_status' => 'publish',
				'post_author' => $current_user_id,
				'post_type' => DATEBOOK_TOUR_TYPE,
				'ping_status' => 'closed'
			);
			$tour_profile_id = wp_insert_post( $tour_profile );

			$start_day = rand(30, 50);
			$start =  mktime(0, 0, 0, date("m"), date("d")+$start_day, date("Y"));
		
			$end_day = rand(60, 80);
			$end =  mktime(0, 0, 0, date("m"), date("d")+$end_day, date("Y"));

			update_post_meta($tour_profile_id, 'tour_paid', '1');
			update_post_meta($tour_profile_id, 'country', $country_id);
			update_post_meta($tour_profile_id, 'city', $city_id);
			update_post_meta($tour_profile_id, 'start', $start);
			update_post_meta($tour_profile_id, 'end', $end);
			$addto_post_id = get_user_meta( $current_user_id, 'profile_postid', true );
			update_post_meta($tour_profile_id, 'profile_tour_id', $addto_post_id);


			$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET tour_counter = tour_counter + 1 WHERE id = %d", $country_id) );
			$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET tour_counter = tour_counter + 1 WHERE id = %d", $region_id) );
			$wpdb->query( $wpdb->prepare("UPDATE " . $table_countries . " SET tour_counter = tour_counter + 1 WHERE id = %d", $city_id) );

		}

		// all demo tours are now created so we don't need to run this again
		update_option('datebook_all_demo_tours_created', 'yes');

	}


	// Create Demo Classifieds
	public static function datebook_create_demo_classifieds() {

		$profileusers = get_users( 'role=subscriber' );

		foreach ( $profileusers as $user ) {

			$current_user_id = $user->ID;

			$addto_post_id = get_user_meta( $current_user_id, 'profile_postid', true );

			if ($addto_post_id == '') continue;

			$title = "Lorem ipsum dolor sit amet, consectetur adipiscing elit";
			$description = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed ultrices dui eu lectus fringilla non pellentesque magna egestas. Suspendisse potenti. Vivamus at magna libero. Donec et purus nunc, eu aliquam diam. Nesciunt tofu stumptown aliqua, retro synth master cleanse. Mustache cliche tempor, williamsburg carles vegan helvetica.";

			$classifieds_offer = array('offering', 'looking');
			$classifieds_offer_direction = $classifieds_offer[array_rand($classifieds_offer)];

			// Create post object
			$post_classifieds = array(
				'post_title' => $title,
				'post_content' => $description,
				'post_status' => 'publish',
				'post_author' => $current_user_id,
				'post_type' => DATEBOOK_CLASSIFIEDS_TYPE,
				'ping_status' => 'closed'
			);
			// Insert the post into the database
			$post_classifieds_id = wp_insert_post( $post_classifieds );

			update_post_meta($post_classifieds_id, "classifieds_offer_direction", $classifieds_offer_direction);
		
			$addto_post_id = get_user_meta( $current_user_id, 'profile_postid', true );
			update_post_meta($post_classifieds_id, "profile_classifieds_id", $addto_post_id);

		}

		// all demo tours are now created so we don't need to run this again
		update_option('datebook_all_demo_classifieds_created', 'yes');

	}


	// Create Demo Subscription plans
	public static function datebook_create_demo_subscription_plans() {

		//Get entire array
		$get_subscription_plans = get_option('datebook_subscription_plans');

		if ($get_subscription_plans == '' || count($get_subscription_plans) == 0) {

			//read the json file contents
			$file = DATEBOOK_DIR . 'framework/sample/subscription_plans.json';
			
			$jsondata = wp_remote_get($file);
			
			if(isset($jsondata->errors['http_request_failed'][0]) && !empty($jsondata->errors['http_request_failed'][0])){

				if(in_array('curl', get_loaded_extensions()) || function_exists('curl_init') !== false) {

					$ch = curl_init();
					curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
					curl_setopt($ch, CURLOPT_HEADER, 0);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_URL, $file);
					curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
					$jsondata = curl_exec($ch);
					curl_close($ch);

				}

				$allow_url_curl = (is_array($jsondata) && !empty($jsondata['body'])) ? 1 : 0;

				if($allow_url_curl == 0){
					include $file . '.php';
					$jsondata = array('body' => $content);
				}

			}

			if (is_array($jsondata) && !empty($jsondata['body'])) {

				//convert json object to php associative array
				$get_subscription_plans = json_decode($jsondata['body'],true);

				update_option('datebook_subscription_plans', $get_subscription_plans);

				unset($get_subscription_plans); //release memory

			}
		}
	}


	// Create Demo Custom Fields
	public static function datebook_create_demo_custom_fields() {

		//Get entire array
		$get_profile_custom_fields = get_option('datebook_profile_custom_fields');

		if ($get_profile_custom_fields == '' || count($get_profile_custom_fields) == 0) {
			
			//read the json file contents
			$file = DATEBOOK_DIR . 'framework/sample/profile_custom_fields.json';
			
			$jsondata = wp_remote_get($file);

			if(isset($jsondata->errors['http_request_failed'][0]) && !empty($jsondata->errors['http_request_failed'][0])){

				if(in_array('curl', get_loaded_extensions()) || function_exists('curl_init') !== false) {

					$ch = curl_init();
					curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
					curl_setopt($ch, CURLOPT_HEADER, 0);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_URL, $file);
					curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
					$jsondata = curl_exec($ch);
					curl_close($ch);

				}

				$allow_url_curl = (is_array($jsondata) && !empty($jsondata['body'])) ? 1 : 0;

				if($allow_url_curl == 0){
					include $file . '.php';
					$jsondata = array('body' => $content);
				}

			}

			if (is_array($jsondata) && !empty($jsondata['body'])) {

				//convert json object to php associative array
				$get_profile_custom_fields = json_decode($jsondata['body'],true);

				update_option('datebook_profile_custom_fields', $get_profile_custom_fields);
			
				unset($get_profile_custom_fields); //release memory

			}
		}
	}


	// Create Demo Custom Fields
	private static function datebook_create_demo_profile_form() {

		//Get entire array
		$get_profile_form = get_option('datebook_profile_form') ? get_option('datebook_profile_form') : array();

		if (is_array($get_profile_form) && empty($get_profile_form) && ($get_profile_form == '' || count($get_profile_form) == 0)) {

			//read the json file contents
			$file = DATEBOOK_DIR . 'framework/sample/all_forms.json';

			$jsondata = wp_remote_get($file);

			if(isset($jsondata->errors['http_request_failed'][0]) && !empty($jsondata->errors['http_request_failed'][0])){

				if(in_array('curl', get_loaded_extensions()) || function_exists('curl_init') !== false) {

					$ch = curl_init();
					curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
					curl_setopt($ch, CURLOPT_HEADER, 0);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_URL, $file);
					curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
					$jsondata = curl_exec($ch);
					curl_close($ch);

				}

				$allow_url_curl = (is_array($jsondata) && !empty($jsondata['body'])) ? 1 : 0;

				if($allow_url_curl == 0){
					include $file . '.php';
					$jsondata = array('body' => $content);
				}

			}

			if (!empty($jsondata['body'])) {

				//convert json object to php associative array
				$get_profile_form = json_decode($jsondata['body'],true);

				update_option('datebook_profile_form', $get_profile_form);

				unset($get_profile_form); //release memory

			}
		}
	}


	/**
	 * Start Installation process
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function datebook_start_theme_installation($alldatafields) {

		global $wpdb;

		$message_out = '<div class="updated notice is-dismissible" id="message" style="margin: 0 0 20px 0">';

		$all_demo_created = '';
	
		if ($alldatafields == 'alldata') {

			// set permalink structure
			self::datebook_custom_permalink();

			// allow user registration
			self::datebook_users_can_register();

			if (isset($_GET['step']) && $_GET['step'] == '1' || isset($_GET['whattodo']) && $_GET['whattodo'] == 'recreate-pages') {

				if (isset($_GET['whattodo']) && $_GET['whattodo'] == 'recreate-pages') {
					delete_option('datebook_all_pages_created');
				}

				if (get_option('datebook_all_pages_created') != 'yes') {
					self::datebook_create_theme_pages();
				}
				$all_demo_created .= esc_html__( 'Pages have been created', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '2') {

				if (get_option('datebook_all_menus_installed') != 'yes') {
					self::datebook_create_menus();
				}
				$all_demo_created .= esc_html__( 'Menus have been created', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '3') {		

				if (get_option('datebook_all_widgets_installed') != 'yes') {
					self::datebook_create_widgets();
				}
				$all_demo_created .= esc_html__( 'Widgets have been created', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '4') {

				$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';
				$check_countries_table = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_countries));

				if ($check_countries_table != $table_countries) {
					self::datebook_create_countries_table();
				}
				$all_demo_created .= esc_html__( 'Countries table has been created', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '5') {

				$table_private_messages = strtolower($wpdb->prefix) . 'datebook_private_messages';
				$check_private_messages = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_private_messages));

				if ($check_private_messages != $table_private_messages) {
					self::datebook_create_Private_Messages_table();
				}
				$all_demo_created .= esc_html__( 'Private Messages table has been created', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '6') {

				$table_profile_views = strtolower($wpdb->prefix) . 'datebook_profile_views';
				$check_profile_views = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_profile_views));

				if($check_profile_views != $table_profile_views) {
					self::datebook_create_Who_Viewed_Me_table();
				}
				$all_demo_created .= esc_html__( 'Who Viewed Me table has been created', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '7') {

				$table_sessions = strtolower($wpdb->prefix) . 'datebook_sessions';
				$check_sessions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_sessions));

				if($check_sessions != $table_sessions) {
					self::datebook_create_sessions_table();
				}
				$all_demo_created .= esc_html__( 'Chat Sessions table has been created', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '8') {

				$table_member_subscriptions = strtolower($wpdb->prefix) . "datebook_member_subscriptions";
				$check_member_subscriptions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_member_subscriptions));

				if($check_member_subscriptions != $table_member_subscriptions) {
					self::datebook_create_members_table();

				}
				$all_demo_created .= esc_html__( 'Members table has been created', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '9') {

				$table_payments = strtolower($wpdb->prefix) . "datebook_payments";
				$check_payments = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_payments));

				if($check_payments != $table_payments) {
					self::datebook_create_payments_table();
				}
				$all_demo_created .= esc_html__( 'Notifications table has been created', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '10') {

				$table_notifications = strtolower($wpdb->prefix) . "datebook_notifications";
				$check_notifications = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_notifications));

				if($check_notifications != $table_notifications) {
					self::datebook_create_notifications_table();
				}
				$all_demo_created .= esc_html__( 'Notifications table has been created', 'datebook' );

			}
				

			// Keep the variable into a session
			$datebook_data_total_steps = isset($_GET['total']) ? $_GET['total'] : 11;

			if (isset($_GET['step']) && $_GET['step'] < $datebook_data_total_steps) {

				$message_out .= '<p>'.esc_html__( 'Importing... please, wait!', 'datebook' ).' <span id="counter">5</span></p>';
				$message_out .= '<p class="installed">&#8212; '.$all_demo_created.'</p>';

			} else if (isset($_GET['step']) && (isset($_GET['whattodo']) || $_GET['step'] == $datebook_data_total_steps)) {

				$message_out .= '<h3 class="notice-title">'.esc_html__( 'All the necessary data have been successfully installed!', 'datebook' ).'</h3>';

			}

		} else if ($alldatafields == 'alldemoprofiles') {

			if (isset($_GET['step']) && $_GET['step'] == '1') {

				delete_option('datebook_all_demo_profiles_created');

				if (get_option('datebook_all_demo_profiles_created') != 'yes') {
					self::datebook_create_demo_profiles();
				}

				if (isset($_GET['demo-profiles-step']) && $_GET['demo-profiles-step'] < 6) {

					$all_demo_created .= esc_html__( 'Demo Profiles are being created', 'datebook' );

					$all_demo_created .= esc_html__( ' ... step ', 'datebook' ) . $_GET['demo-profiles-step'] . esc_html__( ' of 5', 'datebook' );

				} else {

					$all_demo_created .= esc_html__( 'Demo Profiles have been created', 'datebook' );

				}

			} else if (isset($_GET['step']) && $_GET['step'] == '2') {
				
				if (get_option('datebook_all_demo_tours_created') != 'yes') {
					self::datebook_create_demo_tours();
				}
				$all_demo_created .= esc_html__( 'Demo Tours have been installed', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '3') {
				
				if (get_option('datebook_all_demo_classifieds_created') != 'yes') {
					self::datebook_create_demo_classifieds();
				}
				$all_demo_created .= esc_html__( 'Demo Classifieds have been installed', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '4') {

				$get_subscription_plans = get_option('datebook_subscription_plans');

				if ($get_subscription_plans == '' || count($get_subscription_plans) == 0) {
					self::datebook_create_demo_subscription_plans();
				}
				$all_demo_created .= esc_html__( 'Demo Subscription plans have been installed', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '5') {

				$get_profile_custom_fields = get_option('datebook_profile_custom_fields');

				if ($get_profile_custom_fields == '' || count($get_profile_custom_fields) == 0) {
					self::datebook_create_demo_custom_fields();
				}
				$all_demo_created .= esc_html__( 'Demo Custom Fields have been installed', 'datebook' );

			} else if (isset($_GET['step']) && $_GET['step'] == '6') {

				$get_profile_form = get_option('datebook_profile_form') ? get_option('datebook_profile_form') : array();
				if (is_array($get_profile_form) && empty($get_profile_form) && ($get_profile_form == '' || count($get_profile_form) == 0)) {
					self::datebook_create_demo_profile_form();
				}
				$all_demo_created .= esc_html__( 'Demo Profile Form has been installed', 'datebook' );

			}


			// Keep the variable into a session
			$datebook_demo_total_steps = 7;


			if (isset($_GET['step']) && $_GET['step'] < $datebook_demo_total_steps) {

				$message_out .= '<p>'.esc_html__( 'Importing... please, wait!', 'datebook' ).' <span id="counter">5</span></p>';
				$message_out .= '<p class="installed">&#8212; '.$all_demo_created.'</p>';

			} else if (isset($_GET['step']) && $_GET['step'] == $datebook_demo_total_steps) {

				$message_out .= '<h3 class="notice-title">'.esc_html__( 'All the Demo Content have been successfully created!', 'datebook' ).'</h3>';

			}


		} else if ($alldatafields == 'upgrade_1') {
		
			if (isset($_GET['upgrade-theme']) && $_GET['upgrade-theme'] == 'yes') {

				$message_add = '';

				if (get_option('datebook_upgrade_1') != 'yes' || get_option('datebook_upgrade_2') != 'yes' || get_option('datebook_upgrade_3') != 'yes' || get_option('datebook_upgrade_4') != 'yes' || get_option('datebook_upgrade_5') != 'yes' || get_option('datebook_upgrade_6') != 'yes' || get_option('datebook_upgrade_8') != 'yes' || get_option('datebook_upgrade_9') != 'yes' || get_option('datebook_upgrade_10') != 'yes' || get_option('datebook_upgrade_12') != 'yes' || get_option('datebook_upgrade_13') != 'yes') {

					if (get_option('datebook_upgrade_5') != 'yes') {

						$message_add .= '<h4>'.esc_html__( 'Verification and Notification pages have been created', 'datebook' ).'.</h3>';
						$message_add .= '<h4>'.esc_html__( 'Now, resave the pages here: WordPress -> DateBook -> Dashboard -> Pages', 'datebook' ).'</h3>';

					}

					self::datebook_makechanges_database();

				}

				$message_out .= '<h3 class="notice-title">'.esc_html__( 'Data has been upgraded', 'datebook' ).'!</h3>';

				$message_out .= $message_add;

			}
		}

		$message_out .= '<button class="notice-dismiss" type="button"><span class="screen-reader-text">'.esc_html__( 'Dismiss this notice.', 'datebook' ).'</span></button>';

		$message_out .= "</div>";

		echo $message_out;


		update_option('datebook_upgrade_1', 'yes');
		update_option('datebook_upgrade_2', 'yes');
		update_option('datebook_upgrade_3', 'yes');
		update_option('datebook_upgrade_4', 'yes');
		update_option('datebook_upgrade_5', 'yes');
		update_option('datebook_upgrade_6', 'yes');
		update_option('datebook_upgrade_8', 'yes');
		update_option('datebook_upgrade_9', 'yes');
		update_option('datebook_upgrade_10', 'yes');
		update_option('datebook_upgrade_12', 'yes');
		update_option('datebook_upgrade_13', 'yes');

	}


	/**
	 * Show Theme Installer Interface
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function datebook_theme_installer_interface() {

		global $wpdb;
		
		$datebook_data_total_steps = 10;
		$datebook_demo_total_steps = 7;
	
		$data_installed_text = '';
		$demo_installed_text = '';

		?>

<div class="wrap">
	
	<h1><?php esc_html_e( 'Theme Installer', 'datebook' ); ?></h1>

	<hr class="wp-header-end">

	<div class="welcome-panel datebook-dummy-notify-box">
		<div class="welcome-panel-content">

			<h2><?php esc_html_e( 'Theme Data Installation', 'datebook' ); ?></h2>

			<?php 

			if (isset($_POST['datebook']) && is_array($_POST['datebook']) || 
			isset($_GET['required-data-install']) && $_GET['required-data-install'] == 'yes' || 
			isset($_GET['demo-data-install']) && $_GET['demo-data-install'] == 'yes' || 
			isset($_GET['upgrade-theme']) && $_GET['upgrade-theme'] == 'yes') {

				if (isset($_GET['required-data-install']) && $_GET['required-data-install'] == 'yes') {
					$alldatafields = "alldata";
				} else if (isset($_GET['demo-data-install']) && $_GET['demo-data-install'] == 'yes') {
					$alldatafields = "alldemoprofiles";
				} else if (isset($_GET['upgrade-theme']) && $_GET['upgrade-theme'] == 'yes') {
					$alldatafields = "upgrade_1";
				}
				
				self::datebook_start_theme_installation($alldatafields);

			}


			?>
			<p><?php esc_html_e( 'This theme requires some pages, countries, menus, widgets, database tables to be installed.', 'datebook' );?> <?php esc_html_e( 'Otherwise, it cannot function properly.', 'datebook' );?></p>

			<p><?php esc_html_e( 'This theme installer can automatically install all pages, countries, cities, menus, widgets, tables and demo data.', 'datebook' );?></p>

			<div id="dashboard-widgets" class="metabox-holder">

				<div id="postbox-container-1" class="postbox-container">
					<div id="normal-sortables" class="meta-box-sortables ui-sortable">
						<div class="postbox ">

							<h2 class="hndle"><?php esc_html_e( 'First: Required Data', 'datebook' ); ?></h2>

							<div class="inside">
								<div class="main">

									<h3><?php esc_html_e( 'They are required', 'datebook' ); ?>:</h3>
									
									<ul>

									<?php 
					
									if (get_option('datebook_all_pages_created') != 'yes') {
										echo '<li>&#8212; ' . esc_html__( 'Pages are not created yet', 'datebook' ) . '</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Pages are created', 'datebook' ).'</span> <a href="' . admin_url('/admin.php?page=datebook-options-install&required-data-install=yes&whattodo=recreate-pages&step=1&total=2') . '" class="alignright" title="' . esc_html__( 'Do not worry! No pages will be deleted. All the pages will be created again.', 'datebook' ) . '">' . esc_html__( 're-create', 'datebook' ) . '</a></li>';
									}
					
									if (get_option('datebook_all_menus_installed') != 'yes') {
										echo '<li>&#8212; '. esc_html__( 'Menus are not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Menus are created', 'datebook' ).'</span></li>';
									}
					
									if (get_option('datebook_all_widgets_installed') != 'yes') {
										echo '<li>&#8212; '. esc_html__( 'Widgets are not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Widgets are created', 'datebook' ).'</span></li>';
									}

									$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';
									$check_countries_table = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_countries));

									if ( $check_countries_table != $table_countries ) {
										echo '<li>&#8212; '. esc_html__( 'Countries (MySQL) table is not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Countries (MySQL) table is created', 'datebook' ).'</span></li>';
									}

									$table_private_messages = strtolower($wpdb->prefix) . "datebook_private_messages";
									$check_private_messages = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_private_messages));
									if ($check_private_messages != $table_private_messages) {
										echo '<li>&#8212; '. esc_html__( 'Private Messages (MySQL) table is not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Private Messages (MySQL) table is created', 'datebook' ).'</span></li>';
									}

									$table_profile_views = strtolower($wpdb->prefix) . "datebook_profile_views";
									$check_profile_views = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_profile_views));
									if ($check_profile_views != $table_profile_views) {
										echo '<li>&#8212; '. esc_html__( 'Who Viewed Me (MySQL) table is not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Who Viewed Me (MySQL) table is created', 'datebook' ).'</span></li>';
									}

									$table_sessions = strtolower($wpdb->prefix) . "datebook_sessions";
									$check_sessions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_sessions));
									if ($check_sessions != $table_sessions) {
										echo '<li>&#8212; '. esc_html__( 'Chat Sessions (MySQL) table is not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Chat Sessions (MySQL) table is created', 'datebook' ).'</span></li>';
									}

									$table_member_subscriptions = strtolower($wpdb->prefix) . "datebook_member_subscriptions";
									$check_member_subscriptions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_member_subscriptions));
									if ($check_member_subscriptions != $table_member_subscriptions) {
										echo '<li>&#8212; '. esc_html__( 'Members (MySQL) table is not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Members (MySQL) table is created', 'datebook' ).'</span></li>';
									}

									$table_payments = strtolower($wpdb->prefix) . "datebook_payments";
									$check_payments = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_payments));
									if ($check_payments != $table_payments) {
										echo '<li>&#8212; '. esc_html__( 'Payments (MySQL) table is not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Payments (MySQL) table is created', 'datebook' ).'</span></li>';
									}

									$table_notifications = strtolower($wpdb->prefix) . "datebook_notifications";
									$check_notifications = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_notifications));
									if ($check_notifications != $table_notifications) {
										echo '<li>&#8212; '. esc_html__( 'Notifications (MySQL) table is not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Notifications (MySQL) table is created', 'datebook' ).'</span></li>';
									}

									?>

									</ul>

									<a href="<?php echo admin_url('/admin.php?page=datebook-options-install&required-data-install=yes&step=1&total=' . $datebook_data_total_steps);?>" class="button button-primary button-hero load-customize"><?php esc_html_e( '1. Install', 'datebook' ); ?></a>

								</div>
							</div>
						</div>
					</div>
				</div>

				<div id="postbox-container-2" class="postbox-container">
					<div id="normal-sortables" class="meta-box-sortables ui-sortable">
						<div class="postbox ">

							<h2 class="hndle"><?php esc_html_e( 'Second: Countries and Cities', 'datebook' ); ?></h2>

							<div class="inside">
								<div class="main">

									<h3><?php esc_html_e( 'They are required', 'datebook' ); ?>:</h3>

									<ul>

									<?php 

									if (get_option('datebook_countries_installed') != 'yes') {
										echo '<li>&#8212; '. esc_html__( 'Countries, regions, cities are not installed yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Countries, regions, cities are installed', 'datebook' ).'</span></li>';
									}

									?>

									</ul>

									<p><?php esc_html_e( '244 countries and 22 951 cities will be inserted into a new table of database. Total: 25853 records', 'datebook' ); ?></p>
									
									<p><?php esc_html_e( 'Click on the button to open page where you can install countries.', 'datebook' ); ?></p>

									<a href="<?php echo admin_url('/admin.php?page=datebook-countries-installer');?>" class="button button-primary button-hero load-customize"><?php esc_html_e( '2. Install', 'datebook' ); ?></a>

								</div>
							</div>
						</div>

					</div>
				</div>

				<div class="clear"></div>

				<div id="postbox-container-1" class="postbox-container">
					<div id="normal-sortables" class="meta-box-sortables ui-sortable">

						<div class="postbox ">

							<h2 class="hndle"><?php esc_html_e( 'Third: Demo Content', 'datebook' ); ?></h2>

							<div class="inside">
								<div class="main">

									<h3><?php esc_html_e( 'They are optional', 'datebook' ); ?>:</h3>
									
									<ul>

									<?php 

									if (get_option('datebook_all_demo_profiles_created') != 'yes') {
										echo '<li>&#8212; '. esc_html__( 'Demo Profiles are not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Demo Profiles are created', 'datebook' ).'</span></li>';
									}
					
									if (get_option('datebook_all_demo_tours_created') != 'yes') {
										echo '<li>&#8212; '. esc_html__( 'Demo Tours are not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Demo Tours are created', 'datebook' ).'</span></li>';
									}
					
									if (get_option('datebook_all_demo_classifieds_created') != 'yes') {
										echo '<li>&#8212; '. esc_html__( 'Demo Classifieds are not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Demo Classifieds are created', 'datebook' ).'</span></li>';
									}

									$get_subscription_plans = get_option('datebook_subscription_plans');
									if ($get_subscription_plans == '' || count($get_subscription_plans) == 0) {
										echo '<li>&#8212; '. esc_html__( 'Demo Subscription plans are not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Demo Subscription plans are created', 'datebook' ).'</span></li>';
									}

									$get_profile_custom_fields = get_option('datebook_profile_custom_fields');
									if ($get_profile_custom_fields == '' || count($get_profile_custom_fields) == 0) {
										echo '<li>&#8212; '. esc_html__( 'Demo Custom Fields are not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Demo Custom Fields are created', 'datebook' ).'</span></li>';
									}

									$get_profile_form = get_option('datebook_profile_form') ? get_option('datebook_profile_form') : array();
									if (is_array($get_profile_form) && empty($get_profile_form) && ($get_profile_form == '' || count($get_profile_form) == 0)) {
										echo '<li>&#8212; '. esc_html__( 'Demo Profile Form is not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Demo Profile Form is created', 'datebook' ).'</span></li>';
									}

									?>
									
									</ul>

									<?php

									$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';
									$check_countries_table = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_countries));

									$table_private_messages = strtolower($wpdb->prefix) . "datebook_private_messages";
									$check_private_messages = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_private_messages));

									$table_profile_views = strtolower($wpdb->prefix) . "datebook_profile_views";
									$check_profile_views = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_profile_views));
									
									$table_sessions = strtolower($wpdb->prefix) . "datebook_sessions";
									$check_sessions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_sessions));

									if (get_option('datebook_all_pages_created') == 'yes' && 
									get_option('datebook_all_menus_installed') == 'yes' && 
									get_option('datebook_all_widgets_installed') == 'yes' && 
									get_option('datebook_countries_installed') == 'yes' && 
									$check_countries_table == $table_countries && 
									$check_private_messages == $table_private_messages && 
									$check_profile_views == $table_profile_views && 
									$check_sessions == $table_sessions) {

									?>

									<a href="<?php echo admin_url('/admin.php?page=datebook-options-install&demo-data-install=yes&demo-profiles-step=1&step=1&total=' . $datebook_demo_total_steps);?>" class="button button-primary button-hero load-customize"><?php esc_html_e( '3. Install', 'datebook' ); ?></a>

									<?php } else { ?>

									<span class="button button-primary button-hero load-customize disabled"><?php esc_html_e( 'First, install Required Data and Countries!', 'datebook' ); ?></span>

									<?php } ?>

								</div>
							</div>
						</div>

					</div>
				</div>

				<div id="postbox-container-2" class="postbox-container" style="display:none">
					<div id="normal-sortables" class="meta-box-sortables ui-sortable">

						<div class="postbox ">

							<h2 class="hndle"><?php esc_html_e( 'Fourth: Demo Profiles', 'datebook' ); ?></h2>

							<div class="inside">
								<div class="main">

									<h3><?php esc_html_e( 'They are optional', 'datebook' ); ?>:</h3>
									
									<ul>

									<?php 

									if (get_option('datebook_all_demo_profiles_created') != 'yes') {
										echo '<li>&#8212; '. esc_html__( 'Demo Profiles are not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Demo Profiles are created', 'datebook' ).'</span></li>';
									}
					
									if (get_option('datebook_all_demo_tours_created') != 'yes') {
										echo '<li>&#8212; '. esc_html__( 'Demo Tours are not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Demo Tours are created', 'datebook' ).'</span></li>';
									}
					
									if (get_option('datebook_all_demo_classifieds_created') != 'yes') {
										echo '<li>&#8212; '. esc_html__( 'Demo Classifieds are not created yet', 'datebook' ).'</li>';
									} else {
										echo '<li><span class="installed">&#8212; '. esc_html__( 'Demo Classifieds are created', 'datebook' ).'</span></li>';
									}

									?>
									
									</ul>

									<p><?php esc_html_e( 'You can fill in the website with 30 demo profiles, tours and classifieds.', 'datebook' ); ?></p>

									<?php

									$table_countries = strtolower($wpdb->prefix) . 'datebook_countries';
									$check_countries_table = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_countries));

									$table_private_messages = strtolower($wpdb->prefix) . "datebook_private_messages";
									$check_private_messages = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_private_messages));

									$table_profile_views = strtolower($wpdb->prefix) . "datebook_profile_views";
									$check_profile_views = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_profile_views));
									
									$table_sessions = strtolower($wpdb->prefix) . "datebook_sessions";
									$check_sessions = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_sessions));

									if (get_option('datebook_all_pages_created') == 'yes' && 
									get_option('datebook_all_menus_installed') == 'yes' && 
									get_option('datebook_all_widgets_installed') == 'yes' && 
									get_option('datebook_countries_installed') == 'yes' && 
									$check_countries_table == $table_countries && 
									$check_private_messages == $table_private_messages && 
									$check_profile_views == $table_profile_views && 
									$check_sessions == $table_sessions) {

									?>

									<a href="<?php echo admin_url('/admin.php?page=datebook-options-install&demo-data-install=yes&demo-profiles-step=1&step=1&total=' . $datebook_demo_total_steps);?>" class="button button-primary button-hero load-customize"><?php esc_html_e( '4. Install', 'datebook' ); ?></a>

									<?php } else { ?>

									<span class="button button-primary button-hero load-customize disabled"><?php esc_html_e( 'First, install Demo Content!', 'datebook' ); ?></span>

									<?php } ?>

								</div>
							</div>
						</div>

					</div>
				</div>

			</div>

			<div class="clear"></div>
			
			<div class="main">

				<h3><?php esc_html_e( 'Switch any notice off', 'datebook' ); ?>:</h3>

				<p><?php esc_html_e( 'You can hide the notice about the installation of required data if you have manually created all the required pages, countries and etc.', 'datebook' ); ?> <a href="<?php echo admin_url('/admin.php?page=datebook-options-install&datebook-hide-data-notify=1');?>" class="button button-secondary load-customize"><?php esc_html_e( 'Do not show me again', 'datebook' ); ?></a></p>

			</div>
			
			<div class="clear"></div>

			<p><small><?php esc_html_e( 'Instruction: First, install the Required Data! Second, install countries, region and cities. Third, if you want demo profiles to be created then install the Demo Content. If you don\'t need any data to be installed then click on the Do not show me again button to hide a notice box.', 'datebook' ); ?></small></p>

		</div>
	</div>
</div>

<?php

	}

}

DateBook_Install_Theme_Data::init();