/**
 * Color picker with gradient support
 */

function $(selector, context) {
	"use strict";
	return (context || document).querySelector(selector);
}

function datebook_angle_buttons(e){
	"use strict";
    e = e || window.event;
	if(e.target.nodeName !== "LABEL") { return; }
	var box_id = e.target.closest(".datebook-gradient-box").getAttribute("data-id");

	var datebook_angle_gradient = e.srcElement.getAttribute("databook-angle-word");
	var shared1 = document.getElementById("datebook-color-picker-1-" + box_id).style.backgroundColor;
	var shared2 = document.getElementById("datebook-color-picker-2-" + box_id).style.backgroundColor;
	var output = "linear-gradient(" + datebook_angle_gradient + ", " + shared1 + " 0%, " + shared2 + " 100%)";
	document.getElementById("datebook-gradient-box-" + box_id).style.backgroundImage = output;
	document.getElementById(box_id).value = output;
}

///////////////////////////////////////////////////////////////////////////////////
var popupBasic;
popupBasic = new Picker({
	editorFormat: "rgb",
	onChange: function(color) {
		"use strict";

		var box_id = localStorage.getItem("datebook_gradient_id_var");

		this.settings.parent.style.backgroundColor = color.rgbaString;

		var output = document.getElementById("datebook-color-picker-" + box_id).style.backgroundColor;
		document.getElementById("datebook-gradient-box-" + box_id).style.backgroundImage = output;
		document.getElementById(box_id).value = output;

	}
});

var datebook_colorpicker_basic = document.querySelectorAll('[id^="datebook-color-basic-"]');
function datebook_colorpicker_basic_listener(e) {

	"use strict";
    e = e || window.event;
	if(e.target.nodeName !== "LI") { return; }
	
	var box_id = e.target.closest(".datebook-transparent-box").getAttribute("data-id");
	
	localStorage.setItem("datebook_gradient_id_var", box_id);

	var parent = e.target;

	popupBasic.movePopup({
		parent: parent,
		color: parent.style.backgroundColor,
	}, true);
		
}
for (var i = 0 ; i < datebook_colorpicker_basic.length; i++) {
	datebook_colorpicker_basic[i].addEventListener("click" , datebook_colorpicker_basic_listener , false );
}
//////////////////////////////////////////////////////


var popupShared;
popupShared = new Picker({
	editorFormat: "rgb",
	onChange: function(color) {
		"use strict";

		var box_id = localStorage.getItem("datebook_gradient_id_var");

		this.settings.parent.style.backgroundColor = color.rgbaString;

		var datebook_angle_gradient = document.querySelector("input[name='datebook_angle_gradient_[" + box_id + "]']:checked").value;
		var shared1 = document.getElementById("datebook-color-picker-1-" + box_id).style.backgroundColor;
		var shared2 = document.getElementById("datebook-color-picker-2-" + box_id).style.backgroundColor;
		var output = "linear-gradient(" + datebook_angle_gradient + ", " + shared1 + " 0%, " + shared2 + " 100%)";
		document.getElementById("datebook-gradient-box-" + box_id).style.backgroundImage = output;
		document.getElementById(box_id).value = output;

	}
});

var datebook_colorpicker_buttons = document.querySelectorAll('[id^="datebook-color-shared-"]');
function datebook_colorpicker_buttons_listener(e) {

	"use strict";
    e = e || window.event;
	if(e.target.nodeName !== "LI") { return; }
	
	var box_id = e.target.closest(".datebook-gradient-box").getAttribute("data-id");
	
	localStorage.setItem("datebook_gradient_id_var", box_id);
	
	var parent = e.target;
	if (e.target.matches("#datebook-color-picker-1-" + box_id)){
		var popupdirection = "right";
	} else if (e.target.matches("#datebook-color-picker-2-" + box_id)){
		var popupdirection = "left";
	}

	popupShared.movePopup({
		parent: parent,
		popup: popupdirection,
		color: parent.style.backgroundColor,
	}, true);
		
}
for (var i = 0 ; i < datebook_colorpicker_buttons.length; i++) {
	datebook_colorpicker_buttons[i].addEventListener("click" , datebook_colorpicker_buttons_listener , false );
}