jQuery(document).ready(function($){
	function getCookie(cname) {
	    var name = cname + "=";
	    var decodedCookie = decodeURIComponent(document.cookie);
	    var ca = decodedCookie.split(';');
	    for(var i = 0; i <ca.length; i++) {
	        var c = ca[i];
	        while (c.charAt(0) == ' ') {
	            c = c.substring(1);
	        }
	        if (c.indexOf(name) == 0) {
	            return c.substring(name.length, c.length);
	        }
	    }
	    return "";
	}

	$('[data-datebook-notice-id]').each(function (index, value){
		var datebook_id = $(this).data("datebook-notice-id");
		var datebook_show = true;

		var datebook_close_cookie_name = "datebook-notice-close-" + datebook_id;
		var datebook_close_cookie = getCookie(datebook_close_cookie_name);
		var datebook_close_days = $(this).children().data("datebook-notice-close-button");

		if (datebook_close_days == 0) {
			if (datebook_close_cookie) {
				document.cookie = datebook_close_cookie_name + "=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
			}
		} else {
			if (datebook_close_cookie) {
				$(this).parent().remove();
				var datebook_show = false;
			}
		}

		var datebook_limitation_name = "datebook-notice-limitation-" + datebook_id;
		var datebook_limitation_cookie = getCookie(datebook_limitation_name);
		var datebook_limitations_times = $(this).data("datebook-notice-limitations-times");
		var datebook_limitations_days = $(this).data("datebook-notice-limitations-days");
		if (datebook_limitations_times == 0) {
			if (datebook_limitation_cookie) {
				document.cookie = datebook_limitation_name + "=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
			}
		} else {
			if (datebook_limitation_cookie) {
				if (datebook_limitation_cookie > 1) {
					var datebook_current_limitation_times = datebook_limitation_cookie -1;
					var d = new Date();
					var n = d.setTime(d.getTime() + (datebook_limitations_days*24*60*60*1000));
					document.cookie = datebook_limitation_name + "=" + datebook_current_limitation_times + "; expires=" + d.toUTCString();
				} else {
					$(this).parent().remove();
					var datebook_show = false;
				}

			} else {
				var d = new Date();
				var n = d.setTime(d.getTime() + (datebook_limitations_days*24*60*60*1000));
				document.cookie = datebook_limitation_name + "=" + datebook_limitations_times + "; expires=" + d.toUTCString();
			}
		}

		if (datebook_show) {
			var datebook_delay = $(this).data("datebook-notice-delay");
			if (datebook_delay > 0) {
				setTimeout(function(){
					$('#datebook-notice-id-'+datebook_id).removeClass('delay');
				}, datebook_delay*1000);
			}
			var datebook_show_time = ($(this).data("datebook-notice-show-time") + datebook_delay)*1000;
			if (datebook_show_time > 0) {
				var datebook_animation_out_class = $(this).data("datebook-notice-animation-out-class");
				var datebook_animation_out_speed = $(this).data("datebook-notice-animation-out-speed")*1000;
				setTimeout(function(){
					$('#datebook-notice-id-'+datebook_id).addClass(datebook_animation_out_class);
					setTimeout(function(){
						$('#datebook-notice-id-'+datebook_id).parent().fadeOut( 400, function() {
							$(this).remove();
						});
					}, datebook_animation_out_speed);
				}, datebook_show_time);
			}
		}

	});

	$('body').on("click", "[data-datebook-notice-close-button]", function(e){
		var datebook_id = $(this).parent().data("datebook-notice-id");
		var datebook_close_days = $(this).data("datebook-notice-close-button");
		if (datebook_close_days > 0) {
			var datebook_close_status = true;
			var d = new Date();
			var n = d.setTime(d.getTime() + (datebook_close_days*24*60*60*1000));
			document.cookie = "datebook-notice-close-" + datebook_id + "=" + datebook_close_status + "; expires=" + d.toUTCString() ;
		}

		var datebook_animation_out_class = $(this).parent().data("datebook-notice-animation-out-class");
		var datebook_animation_out_speed = $(this).parent().data("datebook-notice-animation-out-speed")*1000;
		$(this).parent().addClass(datebook_animation_out_class);
		setTimeout(function(){
			$('#datebook-notice-id-'+datebook_id).parent().fadeOut( 400, function() {
				$(this).remove();
			});
		}, datebook_animation_out_speed);
	});

	$(".datebook-notice-close").click(function(e){
		e.preventDefault();
		$(this).parent().children("[data-datebook-notice-close-button]").trigger('click');
	});

});
