<?php
/**
 * Options Framework
 *
 * @package   Options Framework
 * @author    Devin Price <devin@wptheming.com>
 * @license   GPL-2.0+
 * @link      http://wptheming.com
 * @copyright 2010-2014 WP Theming
 *
 * @wordpress-plugin
 * Plugin Name: Options Framework
 * Plugin URI:  http://wptheming.com
 * Description: A framework for building plugin options.
 * Version:     1.9.1
 * Author:      Devin Price
 * Author URI:  http://wptheming.com
 * License:     GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: optionsframework
 * Domain Path: /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


/**
 * Get Returns a select list of Google fonts
 *
 * @return   array
 */
function options_typography_get_google_fonts() {

	// Google Font Defaults
	$google_faces = array(
		'ABeeZee, sans-serif' => 'ABeeZee',
		'Abel, sans-serif' => 'Abel',
		'Abhaya Libre, serif' => 'Abhaya Libre',
		'Abril Fatface, display' => 'Abril Fatface',
		'Aclonica, sans-serif' => 'Aclonica',
		'Acme, sans-serif' => 'Acme',
		'Actor, sans-serif' => 'Actor',
		'Adamina, serif' => 'Adamina',
		'Advent Pro, sans-serif' => 'Advent Pro',
		'Aguafina Script, handwriting' => 'Aguafina Script',
		'Akronim, display' => 'Akronim',
		'Aladin, handwriting' => 'Aladin',
		'Alata, sans-serif' => 'Alata',
		'Alatsi, sans-serif' => 'Alatsi',
		'Aldrich, sans-serif' => 'Aldrich',
		'Alef, sans-serif' => 'Alef',
		'Alegreya, serif' => 'Alegreya',
		'Alegreya Sans, sans-serif' => 'Alegreya Sans',
		'Alegreya Sans SC, sans-serif' => 'Alegreya Sans SC',
		'Alegreya SC, serif' => 'Alegreya SC',
		'Aleo, serif' => 'Aleo',
		'Alex Brush, handwriting' => 'Alex Brush',
		'Alfa Slab One, display' => 'Alfa Slab One',
		'Alice, serif' => 'Alice',
		'Alike, serif' => 'Alike',
		'Alike Angular, serif' => 'Alike Angular',
		'Allan, display' => 'Allan',
		'Allerta, sans-serif' => 'Allerta',
		'Allerta Stencil, sans-serif' => 'Allerta Stencil',
		'Allura, handwriting' => 'Allura',
		'Almarai, sans-serif' => 'Almarai',
		'Almendra, serif' => 'Almendra',
		'Almendra Display, display' => 'Almendra Display',
		'Almendra SC, serif' => 'Almendra SC',
		'Amarante, display' => 'Amarante',
		'Amaranth, sans-serif' => 'Amaranth',
		'Amatic SC, handwriting' => 'Amatic SC',
		'Amethysta, serif' => 'Amethysta',
		'Amiko, sans-serif' => 'Amiko',
		'Amiri, serif' => 'Amiri',
		'Amita, handwriting' => 'Amita',
		'Anaheim, sans-serif' => 'Anaheim',
		'Andada, serif' => 'Andada',
		'Andika, sans-serif' => 'Andika',
		'Angkor, display' => 'Angkor',
		'Annie Use Your Telescope, handwriting' => 'Annie Use Your Telescope',
		'Anonymous Pro, monospace' => 'Anonymous Pro',
		'Antic, sans-serif' => 'Antic',
		'Antic Didone, serif' => 'Antic Didone',
		'Antic Slab, serif' => 'Antic Slab',
		'Anton, sans-serif' => 'Anton',
		'Arapey, serif' => 'Arapey',
		'Arbutus, display' => 'Arbutus',
		'Arbutus Slab, serif' => 'Arbutus Slab',
		'Architects Daughter, handwriting' => 'Architects Daughter',
		'Archivo, sans-serif' => 'Archivo',
		'Archivo Black, sans-serif' => 'Archivo Black',
		'Archivo Narrow, sans-serif' => 'Archivo Narrow',
		'Aref Ruqaa, serif' => 'Aref Ruqaa',
		'Arima Madurai, display' => 'Arima Madurai',
		'Arimo, sans-serif' => 'Arimo',
		'Arizonia, handwriting' => 'Arizonia',
		'Armata, sans-serif' => 'Armata',
		'Arsenal, sans-serif' => 'Arsenal',
		'Artifika, serif' => 'Artifika',
		'Arvo, serif' => 'Arvo',
		'Arya, sans-serif' => 'Arya',
		'Asap, sans-serif' => 'Asap',
		'Asap Condensed, sans-serif' => 'Asap Condensed',
		'Asar, serif' => 'Asar',
		'Asset, display' => 'Asset',
		'Assistant, sans-serif' => 'Assistant',
		'Astloch, display' => 'Astloch',
		'Asul, sans-serif' => 'Asul',
		'Athiti, sans-serif' => 'Athiti',
		'Atma, display' => 'Atma',
		'Atomic Age, display' => 'Atomic Age',
		'Aubrey, display' => 'Aubrey',
		'Audiowide, display' => 'Audiowide',
		'Autour One, display' => 'Autour One',
		'Average, serif' => 'Average',
		'Average Sans, sans-serif' => 'Average Sans',
		'Averia Gruesa Libre, display' => 'Averia Gruesa Libre',
		'Averia Libre, display' => 'Averia Libre',
		'Averia Sans Libre, display' => 'Averia Sans Libre',
		'Averia Serif Libre, display' => 'Averia Serif Libre',
		'B612, sans-serif' => 'B612',
		'B612 Mono, monospace' => 'B612 Mono',
		'Bad Script, handwriting' => 'Bad Script',
		'Bahiana, display' => 'Bahiana',
		'Bahianita, display' => 'Bahianita',
		'Bai Jamjuree, sans-serif' => 'Bai Jamjuree',
		'Baloo 2, display' => 'Baloo 2',
		'Baloo Bhai 2, display' => 'Baloo Bhai 2',
		'Baloo Bhaina 2, display' => 'Baloo Bhaina 2',
		'Baloo Chettan 2, display' => 'Baloo Chettan 2',
		'Baloo Da 2, display' => 'Baloo Da 2',
		'Baloo Paaji 2, display' => 'Baloo Paaji 2',
		'Baloo Tamma 2, display' => 'Baloo Tamma 2',
		'Baloo Tammudu 2, display' => 'Baloo Tammudu 2',
		'Baloo Thambi 2, display' => 'Baloo Thambi 2',
		'Balsamiq Sans, display' => 'Balsamiq Sans',
		'Balthazar, serif' => 'Balthazar',
		'Bangers, display' => 'Bangers',
		'Barlow, sans-serif' => 'Barlow',
		'Barlow Condensed, sans-serif' => 'Barlow Condensed',
		'Barlow Semi Condensed, sans-serif' => 'Barlow Semi Condensed',
		'Barriecito, display' => 'Barriecito',
		'Barrio, display' => 'Barrio',
		'Basic, sans-serif' => 'Basic',
		'Baskervville, serif' => 'Baskervville',
		'Battambang, display' => 'Battambang',
		'Baumans, display' => 'Baumans',
		'Bayon, display' => 'Bayon',
		'Be Vietnam, sans-serif' => 'Be Vietnam',
		'Bebas Neue, display' => 'Bebas Neue',
		'Belgrano, serif' => 'Belgrano',
		'Bellefair, serif' => 'Bellefair',
		'Belleza, sans-serif' => 'Belleza',
		'Bellota, display' => 'Bellota',
		'Bellota Text, display' => 'Bellota Text',
		'BenchNine, sans-serif' => 'BenchNine',
		'Bentham, serif' => 'Bentham',
		'Berkshire Swash, handwriting' => 'Berkshire Swash',
		'Beth Ellen, handwriting' => 'Beth Ellen',
		'Bevan, display' => 'Bevan',
		'Big Shoulders Display, display' => 'Big Shoulders Display',
		'Big Shoulders Inline Display, display' => 'Big Shoulders Inline Display',
		'Big Shoulders Inline Text, display' => 'Big Shoulders Inline Text',
		'Big Shoulders Stencil Display, display' => 'Big Shoulders Stencil Display',
		'Big Shoulders Stencil Text, display' => 'Big Shoulders Stencil Text',
		'Big Shoulders Text, display' => 'Big Shoulders Text',
		'Bigelow Rules, display' => 'Bigelow Rules',
		'Bigshot One, display' => 'Bigshot One',
		'Bilbo, handwriting' => 'Bilbo',
		'Bilbo Swash Caps, handwriting' => 'Bilbo Swash Caps',
		'BioRhyme, serif' => 'BioRhyme',
		'BioRhyme Expanded, serif' => 'BioRhyme Expanded',
		'Biryani, sans-serif' => 'Biryani',
		'Bitter, serif' => 'Bitter',
		'Black And White Picture, sans-serif' => 'Black And White Picture',
		'Black Han Sans, sans-serif' => 'Black Han Sans',
		'Black Ops One, display' => 'Black Ops One',
		'Blinker, sans-serif' => 'Blinker',
		'Bokor, display' => 'Bokor',
		'Bonbon, handwriting' => 'Bonbon',
		'Boogaloo, display' => 'Boogaloo',
		'Bowlby One, display' => 'Bowlby One',
		'Bowlby One SC, display' => 'Bowlby One SC',
		'Brawler, serif' => 'Brawler',
		'Bree Serif, serif' => 'Bree Serif',
		'Bubblegum Sans, display' => 'Bubblegum Sans',
		'Bubbler One, sans-serif' => 'Bubbler One',
		'Buda, display' => 'Buda',
		'Buenard, serif' => 'Buenard',
		'Bungee, display' => 'Bungee',
		'Bungee Hairline, display' => 'Bungee Hairline',
		'Bungee Inline, display' => 'Bungee Inline',
		'Bungee Outline, display' => 'Bungee Outline',
		'Bungee Shade, display' => 'Bungee Shade',
		'Butcherman, display' => 'Butcherman',
		'Butterfly Kids, handwriting' => 'Butterfly Kids',
		'Cabin, sans-serif' => 'Cabin',
		'Cabin Condensed, sans-serif' => 'Cabin Condensed',
		'Cabin Sketch, display' => 'Cabin Sketch',
		'Caesar Dressing, display' => 'Caesar Dressing',
		'Cagliostro, sans-serif' => 'Cagliostro',
		'Cairo, sans-serif' => 'Cairo',
		'Caladea, serif' => 'Caladea',
		'Calistoga, display' => 'Calistoga',
		'Calligraffitti, handwriting' => 'Calligraffitti',
		'Cambay, sans-serif' => 'Cambay',
		'Cambo, serif' => 'Cambo',
		'Candal, sans-serif' => 'Candal',
		'Cantarell, sans-serif' => 'Cantarell',
		'Cantata One, serif' => 'Cantata One',
		'Cantora One, sans-serif' => 'Cantora One',
		'Capriola, sans-serif' => 'Capriola',
		'Cardo, serif' => 'Cardo',
		'Carme, sans-serif' => 'Carme',
		'Carrois Gothic, sans-serif' => 'Carrois Gothic',
		'Carrois Gothic SC, sans-serif' => 'Carrois Gothic SC',
		'Carter One, display' => 'Carter One',
		'Catamaran, sans-serif' => 'Catamaran',
		'Caudex, serif' => 'Caudex',
		'Caveat, handwriting' => 'Caveat',
		'Caveat Brush, handwriting' => 'Caveat Brush',
		'Cedarville Cursive, handwriting' => 'Cedarville Cursive',
		'Ceviche One, display' => 'Ceviche One',
		'Chakra Petch, sans-serif' => 'Chakra Petch',
		'Changa, sans-serif' => 'Changa',
		'Changa One, display' => 'Changa One',
		'Chango, display' => 'Chango',
		'Charm, handwriting' => 'Charm',
		'Charmonman, handwriting' => 'Charmonman',
		'Chathura, sans-serif' => 'Chathura',
		'Chau Philomene One, sans-serif' => 'Chau Philomene One',
		'Chela One, display' => 'Chela One',
		'Chelsea Market, display' => 'Chelsea Market',
		'Chenla, display' => 'Chenla',
		'Cherry Cream Soda, display' => 'Cherry Cream Soda',
		'Cherry Swash, display' => 'Cherry Swash',
		'Chewy, display' => 'Chewy',
		'Chicle, display' => 'Chicle',
		'Chilanka, handwriting' => 'Chilanka',
		'chivo?subsets=latin"' => 'chivo?subsets=latin" ',
		'Chivo, sans-serif' => 'Chivo',
		'chonburi?subsets=latin"' => 'chonburi?subsets=latin" ',
		'Chonburi, display' => 'Chonburi',
		'Cinzel, serif' => 'Cinzel',
		'Cinzel Decorative, display' => 'Cinzel Decorative',
		'Clicker Script, handwriting' => 'Clicker Script',
		'Coda, display' => 'Coda',
		'Coda Caption, sans-serif' => 'Coda Caption',
		'Codystar, display' => 'Codystar',
		'Coiny, display' => 'Coiny',
		'Combo, display' => 'Combo',
		'Comfortaa, display' => 'Comfortaa',
		'Comic Neue, handwriting' => 'Comic Neue',
		'Coming Soon, handwriting' => 'Coming Soon',
		'Commissioner, sans-serif' => 'Commissioner',
		'Concert One, display' => 'Concert One',
		'Condiment, handwriting' => 'Condiment',
		'Content, display' => 'Content',
		'Contrail One, display' => 'Contrail One',
		'Convergence, sans-serif' => 'Convergence',
		'Cookie, handwriting' => 'Cookie',
		'Copse, serif' => 'Copse',
		'Corben, display' => 'Corben',
		'Cormorant, serif' => 'Cormorant',
		'Cormorant Garamond, serif' => 'Cormorant Garamond',
		'Cormorant Infant, serif' => 'Cormorant Infant',
		'Cormorant SC, serif' => 'Cormorant SC',
		'Cormorant Unicase, serif' => 'Cormorant Unicase',
		'Cormorant Upright, serif' => 'Cormorant Upright',
		'Courgette, handwriting' => 'Courgette',
		'Courier Prime, monospace' => 'Courier Prime',
		'Cousine, monospace' => 'Cousine',
		'Coustard, serif' => 'Coustard',
		'Covered By Your Grace, handwriting' => 'Covered By Your Grace',
		'Crafty Girls, handwriting' => 'Crafty Girls',
		'Creepster, display' => 'Creepster',
		'Crete Round, serif' => 'Crete Round',
		'Crimson Pro, serif' => 'Crimson Pro',
		'Crimson Text, serif' => 'Crimson Text',
		'Croissant One, display' => 'Croissant One',
		'Crushed, display' => 'Crushed',
		'Cuprum, sans-serif' => 'Cuprum',
		'Cute Font, display' => 'Cute Font',
		'Cutive, serif' => 'Cutive',
		'Cutive Mono, monospace' => 'Cutive Mono',
		'Damion, handwriting' => 'Damion',
		'Dancing Script, handwriting' => 'Dancing Script',
		'Dangrek, display' => 'Dangrek',
		'Darker Grotesque, sans-serif' => 'Darker Grotesque',
		'David Libre, serif' => 'David Libre',
		'Dawning of a New Day, handwriting' => 'Dawning of a New Day',
		'Days One, sans-serif' => 'Days One',
		'Dekko, handwriting' => 'Dekko',
		'Delius, handwriting' => 'Delius',
		'Delius Swash Caps, handwriting' => 'Delius Swash Caps',
		'Delius Unicase, handwriting' => 'Delius Unicase',
		'Della Respira, serif' => 'Della Respira',
		'Denk One, sans-serif' => 'Denk One',
		'Devonshire, handwriting' => 'Devonshire',
		'Dhurjati, sans-serif' => 'Dhurjati',
		'Didact Gothic, sans-serif' => 'Didact Gothic',
		'Diplomata, display' => 'Diplomata',
		'Diplomata SC, display' => 'Diplomata SC',
		'DM Mono, monospace' => 'DM Mono',
		'DM Sans, sans-serif' => 'DM Sans',
		'DM Serif Display, serif' => 'DM Serif Display',
		'DM Serif Text, serif' => 'DM Serif Text',
		'Do Hyeon, sans-serif' => 'Do Hyeon',
		'Dokdo, handwriting' => 'Dokdo',
		'Domine, serif' => 'Domine',
		'Donegal One, serif' => 'Donegal One',
		'Doppio One, sans-serif' => 'Doppio One',
		'Dorsa, sans-serif' => 'Dorsa',
		'Dosis, sans-serif' => 'Dosis',
		'Dr Sugiyama, handwriting' => 'Dr Sugiyama',
		'Duru Sans, sans-serif' => 'Duru Sans',
		'Dynalight, display' => 'Dynalight',
		'Eagle Lake, handwriting' => 'Eagle Lake',
		'East Sea Dokdo, handwriting' => 'East Sea Dokdo',
		'Eater, display' => 'Eater',
		'EB Garamond, serif' => 'EB Garamond',
		'Economica, sans-serif' => 'Economica',
		'Eczar, serif' => 'Eczar',
		'El Messiri, sans-serif' => 'El Messiri',
		'Electrolize, sans-serif' => 'Electrolize',
		'Elsie, display' => 'Elsie',
		'Elsie Swash Caps, display' => 'Elsie Swash Caps',
		'Emblema One, display' => 'Emblema One',
		'Emilys Candy, display' => 'Emilys Candy',
		'Encode Sans, sans-serif' => 'Encode Sans',
		'Encode Sans Condensed, sans-serif' => 'Encode Sans Condensed',
		'Encode Sans Expanded, sans-serif' => 'Encode Sans Expanded',
		'Encode Sans Semi Condensed, sans-serif' => 'Encode Sans Semi Condensed',
		'Encode Sans Semi Expanded, sans-serif' => 'Encode Sans Semi Expanded',
		'Englebert, sans-serif' => 'Englebert',
		'Enriqueta, serif' => 'Enriqueta',
		'Epilogue, sans-serif' => 'Epilogue',
		'Erica One, display' => 'Erica One',
		'Esteban, serif' => 'Esteban',
		'Euphoria Script, handwriting' => 'Euphoria Script',
		'Ewert, display' => 'Ewert',
		'Exo, sans-serif' => 'Exo',
		'Exo 2, sans-serif' => 'Exo 2',
		'Expletus Sans, display' => 'Expletus Sans',
		'Fahkwang, sans-serif' => 'Fahkwang',
		'Fanwood Text, serif' => 'Fanwood Text',
		'Farro, sans-serif' => 'Farro',
		'Farsan, display' => 'Farsan',
		'Fascinate, display' => 'Fascinate',
		'Fascinate Inline, display' => 'Fascinate Inline',
		'Faster One, display' => 'Faster One',
		'Fasthand, serif' => 'Fasthand',
		'Fauna One, serif' => 'Fauna One',
		'Faustina, serif' => 'Faustina',
		'Federant, display' => 'Federant',
		'Federo, sans-serif' => 'Federo',
		'Felipa, handwriting' => 'Felipa',
		'Fenix, serif' => 'Fenix',
		'Finger Paint, display' => 'Finger Paint',
		'Fira Code, monospace' => 'Fira Code',
		'Fira Mono, monospace' => 'Fira Mono',
		'Fira Sans, sans-serif' => 'Fira Sans',
		'Fira Sans Condensed, sans-serif' => 'Fira Sans Condensed',
		'Fira Sans Extra Condensed, sans-serif' => 'Fira Sans Extra Condensed',
		'Fjalla One, sans-serif' => 'Fjalla One',
		'Fjord One, serif' => 'Fjord One',
		'Flamenco, display' => 'Flamenco',
		'Flavors, display' => 'Flavors',
		'Fondamento, handwriting' => 'Fondamento',
		'Fontdiner Swanky, display' => 'Fontdiner Swanky',
		'Forum, display' => 'Forum',
		'Francois One, sans-serif' => 'Francois One',
		'Frank Ruhl Libre, serif' => 'Frank Ruhl Libre',
		'Freckle Face, display' => 'Freckle Face',
		'Fredericka the Great, display' => 'Fredericka the Great',
		'Fredoka One, display' => 'Fredoka One',
		'Freehand, display' => 'Freehand',
		'Fresca, sans-serif' => 'Fresca',
		'Frijole, display' => 'Frijole',
		'Fruktur, display' => 'Fruktur',
		'Fugaz One, display' => 'Fugaz One',
		'Gabriela, serif' => 'Gabriela',
		'Gaegu, handwriting' => 'Gaegu',
		'Gafata, sans-serif' => 'Gafata',
		'Galada, display' => 'Galada',
		'Galdeano, sans-serif' => 'Galdeano',
		'Galindo, display' => 'Galindo',
		'Gamja Flower, handwriting' => 'Gamja Flower',
		'Gayathri, sans-serif' => 'Gayathri',
		'Gelasio, serif' => 'Gelasio',
		'Gentium Basic, serif' => 'Gentium Basic',
		'Gentium Book Basic, serif' => 'Gentium Book Basic',
		'Geo, sans-serif' => 'Geo',
		'Geostar, display' => 'Geostar',
		'Geostar Fill, display' => 'Geostar Fill',
		'Germania One, display' => 'Germania One',
		'GFS Didot, serif' => 'GFS Didot',
		'GFS Neohellenic, sans-serif' => 'GFS Neohellenic',
		'Gidugu, sans-serif' => 'Gidugu',
		'Gilda Display, serif' => 'Gilda Display',
		'Girassol, display' => 'Girassol',
		'Give You Glory, handwriting' => 'Give You Glory',
		'Glass Antiqua, display' => 'Glass Antiqua',
		'Glegoo, serif' => 'Glegoo',
		'Gloria Hallelujah, handwriting' => 'Gloria Hallelujah',
		'Goblin One, display' => 'Goblin One',
		'Gochi Hand, handwriting' => 'Gochi Hand',
		'Goldman, display' => 'Goldman',
		'Gorditas, display' => 'Gorditas',
		'Gothic A1, sans-serif' => 'Gothic A1',
		'Gotu, sans-serif' => 'Gotu',
		'Goudy Bookletter 1911, serif' => 'Goudy Bookletter 1911',
		'Graduate, display' => 'Graduate',
		'Grand Hotel, handwriting' => 'Grand Hotel',
		'Grandstander, display' => 'Grandstander',
		'Gravitas One, display' => 'Gravitas One',
		'Great Vibes, handwriting' => 'Great Vibes',
		'Grenze, serif' => 'Grenze',
		'Grenze Gotisch, display' => 'Grenze Gotisch',
		'Griffy, display' => 'Griffy',
		'Gruppo, display' => 'Gruppo',
		'Gudea, sans-serif' => 'Gudea',
		'Gugi, display' => 'Gugi',
		'Gupter, serif' => 'Gupter',
		'Gurajada, serif' => 'Gurajada',
		'Habibi, serif' => 'Habibi',
		'Halant, serif' => 'Halant',
		'Hammersmith One, sans-serif' => 'Hammersmith One',
		'Hanalei, display' => 'Hanalei',
		'Hanalei Fill, display' => 'Hanalei Fill',
		'Handlee, handwriting' => 'Handlee',
		'Hanuman, serif' => 'Hanuman',
		'Happy Monkey, display' => 'Happy Monkey',
		'Harmattan, sans-serif' => 'Harmattan',
		'Headland One, serif' => 'Headland One',
		'Heebo, sans-serif' => 'Heebo',
		'Henny Penny, display' => 'Henny Penny',
		'Hepta Slab, serif' => 'Hepta Slab',
		'Herr Von Muellerhoff, handwriting' => 'Herr Von Muellerhoff',
		'Hi Melody, handwriting' => 'Hi Melody',
		'Hind, sans-serif' => 'Hind',
		'Hind Guntur, sans-serif' => 'Hind Guntur',
		'Hind Madurai, sans-serif' => 'Hind Madurai',
		'Hind Siliguri, sans-serif' => 'Hind Siliguri',
		'Hind Vadodara, sans-serif' => 'Hind Vadodara',
		'Holtwood One SC, serif' => 'Holtwood One SC',
		'Homemade Apple, handwriting' => 'Homemade Apple',
		'Homenaje, sans-serif' => 'Homenaje',
		'Ibarra Real Nova, serif' => 'Ibarra Real Nova',
		'IBM Plex Mono, monospace' => 'IBM Plex Mono',
		'IBM Plex Sans, sans-serif' => 'IBM Plex Sans',
		'IBM Plex Sans Condensed, sans-serif' => 'IBM Plex Sans Condensed',
		'IBM Plex Serif, serif' => 'IBM Plex Serif',
		'Iceberg, display' => 'Iceberg',
		'Iceland, display' => 'Iceland',
		'IM Fell Double Pica, serif' => 'IM Fell Double Pica',
		'IM Fell Double Pica SC, serif' => 'IM Fell Double Pica SC',
		'IM Fell DW Pica, serif' => 'IM Fell DW Pica',
		'IM Fell DW Pica SC, serif' => 'IM Fell DW Pica SC',
		'IM Fell English, serif' => 'IM Fell English',
		'IM Fell English SC, serif' => 'IM Fell English SC',
		'IM Fell French Canon, serif' => 'IM Fell French Canon',
		'IM Fell French Canon SC, serif' => 'IM Fell French Canon SC',
		'IM Fell Great Primer, serif' => 'IM Fell Great Primer',
		'IM Fell Great Primer SC, serif' => 'IM Fell Great Primer SC',
		'Imprima, sans-serif' => 'Imprima',
		'Inconsolata, monospace' => 'Inconsolata',
		'Inder, sans-serif' => 'Inder',
		'Indie Flower, handwriting' => 'Indie Flower',
		'Inika, serif' => 'Inika',
		'Inknut Antiqua, serif' => 'Inknut Antiqua',
		'Inria Sans, sans-serif' => 'Inria Sans',
		'Inria Serif, serif' => 'Inria Serif',
		'Inter, sans-serif' => 'Inter',
		'Irish Grover, display' => 'Irish Grover',
		'Istok Web, sans-serif' => 'Istok Web',
		'Italiana, serif' => 'Italiana',
		'Italianno, handwriting' => 'Italianno',
		'Itim, handwriting' => 'Itim',
		'Jacques Francois, serif' => 'Jacques Francois',
		'Jacques Francois Shadow, display' => 'Jacques Francois Shadow',
		'Jaldi, sans-serif' => 'Jaldi',
		'Jim Nightshade, handwriting' => 'Jim Nightshade',
		'Jockey One, sans-serif' => 'Jockey One',
		'Jolly Lodger, display' => 'Jolly Lodger',
		'Jomhuria, display' => 'Jomhuria',
		'Jomolhari, serif' => 'Jomolhari',
		'Josefin Sans, sans-serif' => 'Josefin Sans',
		'Josefin Slab, serif' => 'Josefin Slab',
		'Jost, sans-serif' => 'Jost',
		'Joti One, display' => 'Joti One',
		'Jua, sans-serif' => 'Jua',
		'Judson, serif' => 'Judson',
		'Julee, handwriting' => 'Julee',
		'Julius Sans One, sans-serif' => 'Julius Sans One',
		'Junge, serif' => 'Junge',
		'Jura, sans-serif' => 'Jura',
		'Just Another Hand, handwriting' => 'Just Another Hand',
		'Just Me Again Down Here, handwriting' => 'Just Me Again Down Here',
		'K2D, sans-serif' => 'K2D',
		'Kadwa, serif' => 'Kadwa',
		'Kalam, handwriting' => 'Kalam',
		'Kameron, serif' => 'Kameron',
		'Kanit, sans-serif' => 'Kanit',
		'Kantumruy, sans-serif' => 'Kantumruy',
		'Karla, sans-serif' => 'Karla',
		'Karma, serif' => 'Karma',
		'Katibeh, display' => 'Katibeh',
		'Kaushan Script, handwriting' => 'Kaushan Script',
		'Kavivanar, handwriting' => 'Kavivanar',
		'Kavoon, display' => 'Kavoon',
		'Kdam Thmor, display' => 'Kdam Thmor',
		'Keania One, display' => 'Keania One',
		'Kelly Slab, display' => 'Kelly Slab',
		'Kenia, display' => 'Kenia',
		'Khand, sans-serif' => 'Khand',
		'Khmer, display' => 'Khmer',
		'Khula, sans-serif' => 'Khula',
		'Kirang Haerang, display' => 'Kirang Haerang',
		'Kite One, sans-serif' => 'Kite One',
		'Knewave, display' => 'Knewave',
		'Kodchasan, sans-serif' => 'Kodchasan',
		'KoHo, sans-serif' => 'KoHo',
		'Kosugi, sans-serif' => 'Kosugi',
		'Kosugi Maru, sans-serif' => 'Kosugi Maru',
		'Kotta One, serif' => 'Kotta One',
		'Koulen, display' => 'Koulen',
		'Kranky, display' => 'Kranky',
		'Kreon, serif' => 'Kreon',
		'Kristi, handwriting' => 'Kristi',
		'Krona One, sans-serif' => 'Krona One',
		'Krub, sans-serif' => 'Krub',
		'Kufam, display' => 'Kufam',
		'Kulim Park, sans-serif' => 'Kulim Park',
		'Kumar One, display' => 'Kumar One',
		'Kumar One Outline, display' => 'Kumar One Outline',
		'Kumbh Sans, sans-serif' => 'Kumbh Sans',
		'Kurale, serif' => 'Kurale',
		'La Belle Aurore, handwriting' => 'La Belle Aurore',
		'Lacquer, display' => 'Lacquer',
		'Laila, serif' => 'Laila',
		'Lakki Reddy, handwriting' => 'Lakki Reddy',
		'Lalezar, display' => 'Lalezar',
		'Lancelot, display' => 'Lancelot',
		'Lateef, handwriting' => 'Lateef',
		'Lato, sans-serif' => 'Lato',
		'League Script, handwriting' => 'League Script',
		'Leckerli One, handwriting' => 'Leckerli One',
		'Ledger, serif' => 'Ledger',
		'Lekton, sans-serif' => 'Lekton',
		'Lemon, display' => 'Lemon',
		'Lemonada, display' => 'Lemonada',
		'Lexend Deca, sans-serif' => 'Lexend Deca',
		'Lexend Exa, sans-serif' => 'Lexend Exa',
		'Lexend Giga, sans-serif' => 'Lexend Giga',
		'Lexend Mega, sans-serif' => 'Lexend Mega',
		'Lexend Peta, sans-serif' => 'Lexend Peta',
		'Lexend Tera, sans-serif' => 'Lexend Tera',
		'Lexend Zetta, sans-serif' => 'Lexend Zetta',
		'Libre Barcode 128, display' => 'Libre Barcode 128',
		'Libre Barcode 128 Text, display' => 'Libre Barcode 128 Text',
		'Libre Barcode 39, display' => 'Libre Barcode 39',
		'Libre Barcode 39 Extended, display' => 'Libre Barcode 39 Extended',
		'Libre Barcode 39 Extended Text, display' => 'Libre Barcode 39 Extended Text',
		'Libre Barcode 39 Text, display' => 'Libre Barcode 39 Text',
		'Libre Barcode EAN13 Text, display' => 'Libre Barcode EAN13 Text',
		'Libre Baskerville, serif' => 'Libre Baskerville',
		'Libre Caslon Display, serif' => 'Libre Caslon Display',
		'Libre Caslon Text, serif' => 'Libre Caslon Text',
		'Libre Franklin, sans-serif' => 'Libre Franklin',
		'Life Savers, display' => 'Life Savers',
		'Lilita One, display' => 'Lilita One',
		'Lily Script One, display' => 'Lily Script One',
		'Limelight, display' => 'Limelight',
		'Linden Hill, serif' => 'Linden Hill',
		'Literata, serif' => 'Literata',
		'Liu Jian Mao Cao, handwriting' => 'Liu Jian Mao Cao',
		'Livvic, sans-serif' => 'Livvic',
		'Lobster, display' => 'Lobster',
		'Lobster Two, display' => 'Lobster Two',
		'Londrina Outline, display' => 'Londrina Outline',
		'Londrina Shadow, display' => 'Londrina Shadow',
		'Londrina Sketch, display' => 'Londrina Sketch',
		'Londrina Solid, display' => 'Londrina Solid',
		'Long Cang, handwriting' => 'Long Cang',
		'Lora, serif' => 'Lora',
		'Love Ya Like A Sister, display' => 'Love Ya Like A Sister',
		'Loved by the King, handwriting' => 'Loved by the King',
		'Lovers Quarrel, handwriting' => 'Lovers Quarrel',
		'Luckiest Guy, display' => 'Luckiest Guy',
		'Lusitana, serif' => 'Lusitana',
		'Lustria, serif' => 'Lustria',
		'M PLUS 1p, sans-serif' => 'M PLUS 1p',
		'M PLUS Rounded 1c, sans-serif' => 'M PLUS Rounded 1c',
		'Ma Shan Zheng, handwriting' => 'Ma Shan Zheng',
		'Macondo, display' => 'Macondo',
		'Macondo Swash Caps, display' => 'Macondo Swash Caps',
		'Mada, sans-serif' => 'Mada',
		'Magra, sans-serif' => 'Magra',
		'Maiden Orange, display' => 'Maiden Orange',
		'Maitree, serif' => 'Maitree',
		'Major Mono Display, monospace' => 'Major Mono Display',
		'Mako, sans-serif' => 'Mako',
		'Mali, handwriting' => 'Mali',
		'Mallanna, sans-serif' => 'Mallanna',
		'Mandali, sans-serif' => 'Mandali',
		'Manjari, sans-serif' => 'Manjari',
		'Manrope, sans-serif' => 'Manrope',
		'Mansalva, handwriting' => 'Mansalva',
		'Manuale, serif' => 'Manuale',
		'Marcellus, serif' => 'Marcellus',
		'Marcellus SC, serif' => 'Marcellus SC',
		'Marck Script, handwriting' => 'Marck Script',
		'Margarine, display' => 'Margarine',
		'Markazi Text, serif' => 'Markazi Text',
		'Marko One, serif' => 'Marko One',
		'Marmelad, sans-serif' => 'Marmelad',
		'Martel, serif' => 'Martel',
		'Martel Sans, sans-serif' => 'Martel Sans',
		'Marvel, sans-serif' => 'Marvel',
		'Mate, serif' => 'Mate',
		'Mate SC, serif' => 'Mate SC',
		'Maven Pro, sans-serif' => 'Maven Pro',
		'McLaren, display' => 'McLaren',
		'Meddon, handwriting' => 'Meddon',
		'MedievalSharp, display' => 'MedievalSharp',
		'Medula One, display' => 'Medula One',
		'Meera Inimai, sans-serif' => 'Meera Inimai',
		'Megrim, display' => 'Megrim',
		'Meie Script, handwriting' => 'Meie Script',
		'Merienda, handwriting' => 'Merienda',
		'Merienda One, handwriting' => 'Merienda One',
		'Merriweather, serif' => 'Merriweather',
		'Merriweather Sans, sans-serif' => 'Merriweather Sans',
		'Metal, display' => 'Metal',
		'Metal Mania, display' => 'Metal Mania',
		'Metamorphous, display' => 'Metamorphous',
		'Metrophobic, sans-serif' => 'Metrophobic',
		'Michroma, sans-serif' => 'Michroma',
		'Milonga, display' => 'Milonga',
		'Miltonian, display' => 'Miltonian',
		'Miltonian Tattoo, display' => 'Miltonian Tattoo',
		'Mina, sans-serif' => 'Mina',
		'Miniver, display' => 'Miniver',
		'Miriam Libre, sans-serif' => 'Miriam Libre',
		'Mirza, display' => 'Mirza',
		'Miss Fajardose, handwriting' => 'Miss Fajardose',
		'Mitr, sans-serif' => 'Mitr',
		'Modak, display' => 'Modak',
		'Modern Antiqua, display' => 'Modern Antiqua',
		'Mogra, display' => 'Mogra',
		'Molengo, sans-serif' => 'Molengo',
		'Molle, handwriting' => 'Molle',
		'Monda, sans-serif' => 'Monda',
		'Monofett, display' => 'Monofett',
		'Monoton, display' => 'Monoton',
		'Monsieur La Doulaise, handwriting' => 'Monsieur La Doulaise',
		'Montaga, serif' => 'Montaga',
		'Montez, handwriting' => 'Montez',
		'Montserrat, sans-serif' => 'Montserrat',
		'Montserrat Alternates, sans-serif' => 'Montserrat Alternates',
		'Montserrat Subrayada, sans-serif' => 'Montserrat Subrayada',
		'Moul, display' => 'Moul',
		'Moulpali, display' => 'Moulpali',
		'Mountains of Christmas, display' => 'Mountains of Christmas',
		'Mouse Memoirs, sans-serif' => 'Mouse Memoirs',
		'Mr Bedfort, handwriting' => 'Mr Bedfort',
		'Mr Dafoe, handwriting' => 'Mr Dafoe',
		'Mr De Haviland, handwriting' => 'Mr De Haviland',
		'Mrs Saint Delafield, handwriting' => 'Mrs Saint Delafield',
		'Mrs Sheppards, handwriting' => 'Mrs Sheppards',
		'Mukta, sans-serif' => 'Mukta',
		'Mukta Mahee, sans-serif' => 'Mukta Mahee',
		'Mukta Malar, sans-serif' => 'Mukta Malar',
		'Mukta Vaani, sans-serif' => 'Mukta Vaani',
		'Mulish, sans-serif' => 'Mulish',
		'MuseoModerno, display' => 'MuseoModerno',
		'Mystery Quest, display' => 'Mystery Quest',
		'Nanum Brush Script, handwriting' => 'Nanum Brush Script',
		'Nanum Gothic, sans-serif' => 'Nanum Gothic',
		'Nanum Gothic Coding, monospace' => 'Nanum Gothic Coding',
		'Nanum Myeongjo, serif' => 'Nanum Myeongjo',
		'Nanum Pen Script, handwriting' => 'Nanum Pen Script',
		'Neucha, handwriting' => 'Neucha',
		'Neuton, serif' => 'Neuton',
		'New Rocker, display' => 'New Rocker',
		'News Cycle, sans-serif' => 'News Cycle',
		'Niconne, handwriting' => 'Niconne',
		'Niramit, sans-serif' => 'Niramit',
		'Nixie One, display' => 'Nixie One',
		'Nobile, sans-serif' => 'Nobile',
		'Nokora, serif' => 'Nokora',
		'Norican, handwriting' => 'Norican',
		'Nosifer, display' => 'Nosifer',
		'Notable, sans-serif' => 'Notable',
		'Nothing You Could Do, handwriting' => 'Nothing You Could Do',
		'Noticia Text, serif' => 'Noticia Text',
		'Noto Sans, sans-serif' => 'Noto Sans',
		'Noto Sans HK, sans-serif' => 'Noto Sans HK',
		'Noto Sans JP, sans-serif' => 'Noto Sans JP',
		'Noto Sans KR, sans-serif' => 'Noto Sans KR',
		'Noto Sans SC, sans-serif' => 'Noto Sans SC',
		'Noto Sans TC, sans-serif' => 'Noto Sans TC',
		'Noto Serif, serif' => 'Noto Serif',
		'Noto Serif JP, serif' => 'Noto Serif JP',
		'Noto Serif KR, serif' => 'Noto Serif KR',
		'Noto Serif SC, serif' => 'Noto Serif SC',
		'Noto Serif TC, serif' => 'Noto Serif TC',
		'Nova Cut, display' => 'Nova Cut',
		'Nova Flat, display' => 'Nova Flat',
		'Nova Mono, monospace' => 'Nova Mono',
		'Nova Oval, display' => 'Nova Oval',
		'Nova Round, display' => 'Nova Round',
		'Nova Script, display' => 'Nova Script',
		'Nova Slim, display' => 'Nova Slim',
		'Nova Square, display' => 'Nova Square',
		'NTR, sans-serif' => 'NTR',
		'Numans, sans-serif' => 'Numans',
		'Nunito, sans-serif' => 'Nunito',
		'Nunito Sans, sans-serif' => 'Nunito Sans',
		'Odibee Sans, display' => 'Odibee Sans',
		'Odor Mean Chey, display' => 'Odor Mean Chey',
		'Offside, display' => 'Offside',
		'Old Standard TT, serif' => 'Old Standard TT',
		'Oldenburg, display' => 'Oldenburg',
		'Oleo Script, display' => 'Oleo Script',
		'Oleo Script Swash Caps, display' => 'Oleo Script Swash Caps',
		'Open Sans, sans-serif' => 'Open Sans',
		'Open Sans Condensed, sans-serif' => 'Open Sans Condensed',
		'Oranienbaum, serif' => 'Oranienbaum',
		'Orbitron, sans-serif' => 'Orbitron',
		'Oregano, display' => 'Oregano',
		'Orienta, sans-serif' => 'Orienta',
		'Original Surfer, display' => 'Original Surfer',
		'Oswald, sans-serif' => 'Oswald',
		'Over the Rainbow, handwriting' => 'Over the Rainbow',
		'Overlock, display' => 'Overlock',
		'Overlock SC, display' => 'Overlock SC',
		'Overpass, sans-serif' => 'Overpass',
		'Overpass Mono, monospace' => 'Overpass Mono',
		'Ovo, serif' => 'Ovo',
		'Oxanium, display' => 'Oxanium',
		'Oxygen, sans-serif' => 'Oxygen',
		'Oxygen Mono, monospace' => 'Oxygen Mono',
		'Pacifico, handwriting' => 'Pacifico',
		'Padauk, sans-serif' => 'Padauk',
		'Palanquin, sans-serif' => 'Palanquin',
		'Palanquin Dark, sans-serif' => 'Palanquin Dark',
		'Pangolin, handwriting' => 'Pangolin',
		'Paprika, display' => 'Paprika',
		'Parisienne, handwriting' => 'Parisienne',
		'Passero One, display' => 'Passero One',
		'Passion One, display' => 'Passion One',
		'Pathway Gothic One, sans-serif' => 'Pathway Gothic One',
		'Patrick Hand, handwriting' => 'Patrick Hand',
		'Patrick Hand SC, handwriting' => 'Patrick Hand SC',
		'Pattaya, sans-serif' => 'Pattaya',
		'Patua One, display' => 'Patua One',
		'Pavanam, sans-serif' => 'Pavanam',
		'Paytone One, sans-serif' => 'Paytone One',
		'Peddana, serif' => 'Peddana',
		'Peralta, display' => 'Peralta',
		'Permanent Marker, handwriting' => 'Permanent Marker',
		'Petit Formal Script, handwriting' => 'Petit Formal Script',
		'Petrona, serif' => 'Petrona',
		'Philosopher, sans-serif' => 'Philosopher',
		'Piazzolla, serif' => 'Piazzolla',
		'Piedra, display' => 'Piedra',
		'Pinyon Script, handwriting' => 'Pinyon Script',
		'Pirata One, display' => 'Pirata One',
		'Plaster, display' => 'Plaster',
		'Play, sans-serif' => 'Play',
		'Playball, display' => 'Playball',
		'Playfair Display, serif' => 'Playfair Display',
		'Playfair Display SC, serif' => 'Playfair Display SC',
		'Podkova, serif' => 'Podkova',
		'Poiret One, display' => 'Poiret One',
		'Poller One, display' => 'Poller One',
		'Poly, serif' => 'Poly',
		'Pompiere, display' => 'Pompiere',
		'Pontano Sans, sans-serif' => 'Pontano Sans',
		'Poor Story, display' => 'Poor Story',
		'Poppins, sans-serif' => 'Poppins',
		'Port Lligat Sans, sans-serif' => 'Port Lligat Sans',
		'Port Lligat Slab, serif' => 'Port Lligat Slab',
		'Pragati Narrow, sans-serif' => 'Pragati Narrow',
		'Prata, serif' => 'Prata',
		'Preahvihear, display' => 'Preahvihear',
		'Press Start 2P, display' => 'Press Start 2P',
		'Pridi, serif' => 'Pridi',
		'Princess Sofia, handwriting' => 'Princess Sofia',
		'Prociono, serif' => 'Prociono',
		'Prompt, sans-serif' => 'Prompt',
		'Prosto One, display' => 'Prosto One',
		'Proza Libre, sans-serif' => 'Proza Libre',
		'PT Mono, monospace' => 'PT Mono',
		'PT Sans, sans-serif' => 'PT Sans',
		'PT Sans Caption, sans-serif' => 'PT Sans Caption',
		'PT Sans Narrow, sans-serif' => 'PT Sans Narrow',
		'PT Serif, serif' => 'PT Serif',
		'PT Serif Caption, serif' => 'PT Serif Caption',
		'Public Sans, sans-serif' => 'Public Sans',
		'Puritan, sans-serif' => 'Puritan',
		'Purple Purse, display' => 'Purple Purse',
		'Quando, serif' => 'Quando',
		'Quantico, sans-serif' => 'Quantico',
		'Quattrocento, serif' => 'Quattrocento',
		'Quattrocento Sans, sans-serif' => 'Quattrocento Sans',
		'Questrial, sans-serif' => 'Questrial',
		'Quicksand, sans-serif' => 'Quicksand',
		'Quintessential, handwriting' => 'Quintessential',
		'Qwigley, handwriting' => 'Qwigley',
		'Racing Sans One, display' => 'Racing Sans One',
		'Radley, serif' => 'Radley',
		'Rajdhani, sans-serif' => 'Rajdhani',
		'Rakkas, display' => 'Rakkas',
		'Raleway, sans-serif' => 'Raleway',
		'Raleway Dots, display' => 'Raleway Dots',
		'Ramabhadra, sans-serif' => 'Ramabhadra',
		'Ramaraja, serif' => 'Ramaraja',
		'Rambla, sans-serif' => 'Rambla',
		'Rammetto One, display' => 'Rammetto One',
		'Ranchers, display' => 'Ranchers',
		'Rancho, handwriting' => 'Rancho',
		'Ranga, display' => 'Ranga',
		'Rasa, serif' => 'Rasa',
		'Rationale, sans-serif' => 'Rationale',
		'Ravi Prakash, display' => 'Ravi Prakash',
		'Recursive, sans-serif' => 'Recursive',
		'Red Hat Display, sans-serif' => 'Red Hat Display',
		'Red Hat Text, sans-serif' => 'Red Hat Text',
		'Red Rose, display' => 'Red Rose',
		'Redressed, handwriting' => 'Redressed',
		'Reem Kufi, sans-serif' => 'Reem Kufi',
		'Reenie Beanie, handwriting' => 'Reenie Beanie',
		'Revalia, display' => 'Revalia',
		'Rhodium Libre, serif' => 'Rhodium Libre',
		'Ribeye, display' => 'Ribeye',
		'Ribeye Marrow, display' => 'Ribeye Marrow',
		'Righteous, display' => 'Righteous',
		'Risque, display' => 'Risque',
		'Roboto, sans-serif' => 'Roboto',
		'Roboto Condensed, sans-serif' => 'Roboto Condensed',
		'Roboto Mono, monospace' => 'Roboto Mono',
		'Roboto Slab, serif' => 'Roboto Slab',
		'Rochester, handwriting' => 'Rochester',
		'Rock Salt, handwriting' => 'Rock Salt',
		'Rokkitt, serif' => 'Rokkitt',
		'Romanesco, handwriting' => 'Romanesco',
		'Ropa Sans, sans-serif' => 'Ropa Sans',
		'Rosario, sans-serif' => 'Rosario',
		'Rosarivo, serif' => 'Rosarivo',
		'Rouge Script, handwriting' => 'Rouge Script',
		'Rowdies, display' => 'Rowdies',
		'Rozha One, serif' => 'Rozha One',
		'Rubik, sans-serif' => 'Rubik',
		'Rubik Mono One, sans-serif' => 'Rubik Mono One',
		'Ruda, sans-serif' => 'Ruda',
		'Rufina, serif' => 'Rufina',
		'Ruge Boogie, handwriting' => 'Ruge Boogie',
		'Ruluko, sans-serif' => 'Ruluko',
		'Rum Raisin, sans-serif' => 'Rum Raisin',
		'Ruslan Display, display' => 'Ruslan Display',
		'Russo One, sans-serif' => 'Russo One',
		'Ruthie, handwriting' => 'Ruthie',
		'Rye, display' => 'Rye',
		'Sacramento, handwriting' => 'Sacramento',
		'Sahitya, serif' => 'Sahitya',
		'Sail, display' => 'Sail',
		'Saira, sans-serif' => 'Saira',
		'Saira Condensed, sans-serif' => 'Saira Condensed',
		'Saira Extra Condensed, sans-serif' => 'Saira Extra Condensed',
		'Saira Semi Condensed, sans-serif' => 'Saira Semi Condensed',
		'Saira Stencil One, display' => 'Saira Stencil One',
		'Salsa, display' => 'Salsa',
		'Sanchez, serif' => 'Sanchez',
		'Sancreek, display' => 'Sancreek',
		'Sansita, sans-serif' => 'Sansita',
		'Sansita Swashed, display' => 'Sansita Swashed',
		'Sarabun, sans-serif' => 'Sarabun',
		'Sarala, sans-serif' => 'Sarala',
		'Sarina, display' => 'Sarina',
		'Sarpanch, sans-serif' => 'Sarpanch',
		'Satisfy, handwriting' => 'Satisfy',
		'Sawarabi Gothic, sans-serif' => 'Sawarabi Gothic',
		'Sawarabi Mincho, sans-serif' => 'Sawarabi Mincho',
		'Scada, sans-serif' => 'Scada',
		'Scheherazade, serif' => 'Scheherazade',
		'Schoolbell, handwriting' => 'Schoolbell',
		'Scope One, serif' => 'Scope One',
		'Seaweed Script, display' => 'Seaweed Script',
		'Secular One, sans-serif' => 'Secular One',
		'Sedgwick Ave, handwriting' => 'Sedgwick Ave',
		'Sedgwick Ave Display, handwriting' => 'Sedgwick Ave Display',
		'Sen, sans-serif' => 'Sen',
		'Sevillana, display' => 'Sevillana',
		'Seymour One, sans-serif' => 'Seymour One',
		'Shadows Into Light, handwriting' => 'Shadows Into Light',
		'Shadows Into Light Two, handwriting' => 'Shadows Into Light Two',
		'Shanti, sans-serif' => 'Shanti',
		'Share, display' => 'Share',
		'Share Tech, sans-serif' => 'Share Tech',
		'Share Tech Mono, monospace' => 'Share Tech Mono',
		'Shojumaru, display' => 'Shojumaru',
		'Short Stack, handwriting' => 'Short Stack',
		'Shrikhand, display' => 'Shrikhand',
		'Siemreap, display' => 'Siemreap',
		'Sigmar One, display' => 'Sigmar One',
		'Signika, sans-serif' => 'Signika',
		'Signika Negative, sans-serif' => 'Signika Negative',
		'Simonetta, display' => 'Simonetta',
		'Single Day, display' => 'Single Day',
		'Sintony, sans-serif' => 'Sintony',
		'Sirin Stencil, display' => 'Sirin Stencil',
		'Six Caps, sans-serif' => 'Six Caps',
		'Skranji, display' => 'Skranji',
		'Slabo 13px, serif' => 'Slabo 13px',
		'Slabo 27px, serif' => 'Slabo 27px',
		'Slackey, display' => 'Slackey',
		'Smokum, display' => 'Smokum',
		'Smythe, display' => 'Smythe',
		'Sniglet, display' => 'Sniglet',
		'Snippet, sans-serif' => 'Snippet',
		'Snowburst One, display' => 'Snowburst One',
		'Sofadi One, display' => 'Sofadi One',
		'Sofia, handwriting' => 'Sofia',
		'Solway, serif' => 'Solway',
		'Song Myung, serif' => 'Song Myung',
		'Sonsie One, display' => 'Sonsie One',
		'Sora, sans-serif' => 'Sora',
		'Sorts Mill Goudy, serif' => 'Sorts Mill Goudy',
		'Source Code Pro, monospace' => 'Source Code Pro',
		'Source Sans Pro, sans-serif' => 'Source Sans Pro',
		'Source Serif Pro, serif' => 'Source Serif Pro',
		'Space Grotesk, sans-serif' => 'Space Grotesk',
		'Space Mono, monospace' => 'Space Mono',
		'Spartan, sans-serif' => 'Spartan',
		'Special Elite, display' => 'Special Elite',
		'Spectral, serif' => 'Spectral',
		'Spectral SC, serif' => 'Spectral SC',
		'Spicy Rice, display' => 'Spicy Rice',
		'Spinnaker, sans-serif' => 'Spinnaker',
		'Spirax, display' => 'Spirax',
		'Squada One, display' => 'Squada One',
		'Sree Krushnadevaraya, serif' => 'Sree Krushnadevaraya',
		'Sriracha, handwriting' => 'Sriracha',
		'Srisakdi, display' => 'Srisakdi',
		'Staatliches, display' => 'Staatliches',
		'Stalemate, handwriting' => 'Stalemate',
		'Stalinist One, display' => 'Stalinist One',
		'Stardos Stencil, display' => 'Stardos Stencil',
		'Stint Ultra Condensed, display' => 'Stint Ultra Condensed',
		'Stint Ultra Expanded, display' => 'Stint Ultra Expanded',
		'Stoke, serif' => 'Stoke',
		'Strait, sans-serif' => 'Strait',
		'Stylish, sans-serif' => 'Stylish',
		'Sue Ellen Francisco, handwriting' => 'Sue Ellen Francisco',
		'Suez One, serif' => 'Suez One',
		'Sulphur Point, sans-serif' => 'Sulphur Point',
		'Sumana, serif' => 'Sumana',
		'Sunflower, sans-serif' => 'Sunflower',
		'Sunshiney, handwriting' => 'Sunshiney',
		'Supermercado One, display' => 'Supermercado One',
		'Sura, serif' => 'Sura',
		'Suranna, serif' => 'Suranna',
		'Suravaram, serif' => 'Suravaram',
		'Suwannaphum, display' => 'Suwannaphum',
		'Swanky and Moo Moo, handwriting' => 'Swanky and Moo Moo',
		'Syncopate, sans-serif' => 'Syncopate',
		'Syne, sans-serif' => 'Syne',
		'Syne Mono, monospace' => 'Syne Mono',
		'Syne Tactile, display' => 'Syne Tactile',
		'Tajawal, sans-serif' => 'Tajawal',
		'Tangerine, handwriting' => 'Tangerine',
		'Taprom, display' => 'Taprom',
		'Tauri, sans-serif' => 'Tauri',
		'Taviraj, serif' => 'Taviraj',
		'Teko, sans-serif' => 'Teko',
		'Telex, sans-serif' => 'Telex',
		'Tenali Ramakrishna, sans-serif' => 'Tenali Ramakrishna',
		'Tenor Sans, sans-serif' => 'Tenor Sans',
		'Text Me One, sans-serif' => 'Text Me One',
		'Thasadith, sans-serif' => 'Thasadith',
		'The Girl Next Door, handwriting' => 'The Girl Next Door',
		'Tienne, serif' => 'Tienne',
		'Tillana, handwriting' => 'Tillana',
		'Timmana, sans-serif' => 'Timmana',
		'Tinos, serif' => 'Tinos',
		'Titan One, display' => 'Titan One',
		'Titillium Web, sans-serif' => 'Titillium Web',
		'Tomorrow, sans-serif' => 'Tomorrow',
		'Trade Winds, display' => 'Trade Winds',
		'Trirong, serif' => 'Trirong',
		'Trispace, sans-serif' => 'Trispace',
		'Trocchi, serif' => 'Trocchi',
		'Trochut, display' => 'Trochut',
		'Trykker, serif' => 'Trykker',
		'Tulpen One, display' => 'Tulpen One',
		'Turret Road, display' => 'Turret Road',
		'Ubuntu, sans-serif' => 'Ubuntu',
		'Ubuntu Condensed, sans-serif' => 'Ubuntu Condensed',
		'Ubuntu Mono, monospace' => 'Ubuntu Mono',
		'Ultra, serif' => 'Ultra',
		'Uncial Antiqua, display' => 'Uncial Antiqua',
		'Underdog, display' => 'Underdog',
		'Unica One, display' => 'Unica One',
		'UnifrakturCook, display' => 'UnifrakturCook',
		'UnifrakturMaguntia, display' => 'UnifrakturMaguntia',
		'Unkempt, display' => 'Unkempt',
		'Unlock, display' => 'Unlock',
		'Unna, serif' => 'Unna',
		'Vampiro One, display' => 'Vampiro One',
		'Varela, sans-serif' => 'Varela',
		'Varela Round, sans-serif' => 'Varela Round',
		'Varta, sans-serif' => 'Varta',
		'Vast Shadow, display' => 'Vast Shadow',
		'Vesper Libre, serif' => 'Vesper Libre',
		'Viaoda Libre, display' => 'Viaoda Libre',
		'Vibes, display' => 'Vibes',
		'Vibur, handwriting' => 'Vibur',
		'Vidaloka, serif' => 'Vidaloka',
		'Viga, sans-serif' => 'Viga',
		'Voces, display' => 'Voces',
		'Volkhov, serif' => 'Volkhov',
		'Vollkorn, serif' => 'Vollkorn',
		'Vollkorn SC, serif' => 'Vollkorn SC',
		'Voltaire, sans-serif' => 'Voltaire',
		'VT323, monospace' => 'VT323',
		'Waiting for the Sunrise, handwriting' => 'Waiting for the Sunrise',
		'Wallpoet, display' => 'Wallpoet',
		'Walter Turncoat, handwriting' => 'Walter Turncoat',
		'Warnes, display' => 'Warnes',
		'Wellfleet, display' => 'Wellfleet',
		'Wendy One, sans-serif' => 'Wendy One',
		'Wire One, sans-serif' => 'Wire One',
		'Work Sans, sans-serif' => 'Work Sans',
		'Xanh Mono, monospace' => 'Xanh Mono',
		'Yanone Kaffeesatz, sans-serif' => 'Yanone Kaffeesatz',
		'Yantramanav, sans-serif' => 'Yantramanav',
		'Yatra One, display' => 'Yatra One',
		'Yellowtail, handwriting' => 'Yellowtail',
		'Yeon Sung, display' => 'Yeon Sung',
		'Yeseva One, display' => 'Yeseva One',
		'Yesteryear, handwriting' => 'Yesteryear',
		'Yrsa, serif' => 'Yrsa',
		'ZCOOL KuaiLe, display' => 'ZCOOL KuaiLe',
		'ZCOOL QingKe HuangYou, display' => 'ZCOOL QingKe HuangYou',
		'ZCOOL XiaoWei, serif' => 'ZCOOL XiaoWei',
		'Zeyada, handwriting' => 'Zeyada',
		'Zhi Mang Xing, handwriting' => 'Zhi Mang Xing',
		'Zilla Slab, serif' => 'Zilla Slab',
		'Zilla Slab Highlight, display' => 'Zilla Slab Highlight',
	);

	return $google_faces;

}


if ( ! function_exists( 'allowed_html_tags' ) ) {

  /**
   * Allowed html tags for wp_kses() function
   *
   * @return array Array of allowed html tags.
   */
	function allowed_html_tags() {
		
		return array(
			'a' => array(
				'href' => array(),
				'title' => array(),
				'class' => array(),
				'data' => array(),
				'rel'   => array(),
			),
			'br' => array(),
			'em' => array(),
			'ul' => array(
				'class' => array(),
			),
			'ol' => array(
				'class' => array(),
			),
			'li' => array(
				'class' => array(),
			),
			'strong' => array(),
			'div' => array(
				'class' => array(),
				'data' => array(),
				'style' => array(),
			),
			'span' => array(
				'class' => array(),
				'style' => array(),
			),
			'img' => array(
				'alt'    => array(),
				'class'  => array(),
				'height' => array(),
				'src'    => array(),
				'width'  => array(),
			),
			'select' => array(
				'id'   => array(),
				'class' => array(),
				'name' => array(),
			),
			'option' => array(
				'value' => array(),
				'selected' => array(),
			)
		);
	}
}


// Don't load if optionsframework_init is already defined
if (is_admin() && ! function_exists( 'optionsframework_init' ) ) :

function optionsframework_init() {

	//  If user can't edit plugin options, exit
	if ( ! current_user_can( 'edit_theme_options' ) ) {
		return;
	}

	// Loads the required Options Framework classes.
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-framework.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-countries.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-subscriptions.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-members.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-payments.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-custom-fields.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-profile-form.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-matching.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-notifications.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-reviews.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-cookies.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-shortcodes.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-gateways.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-referrers.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-framework-admin.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-interface.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-media-uploader.php';
	require plugin_dir_path( __FILE__ ) . 'includes/class-options-sanitization.php';

	// Load library
	require plugin_dir_path( __FILE__ ) . 'includes/lib/parse-gradient.php';

	// Load plugin pages, countries, menus, demo data install
	require plugin_dir_path( __FILE__ ) . 'installer/class-installer.php';
	require plugin_dir_path( __FILE__ ) . 'installer/class-countries.php';

	// Install realistice demo profiles
	require plugin_dir_path( __FILE__ ) . 'installer/class-demo-content.php';

	// Migrate profiles from other themes using BuddyPress
	require plugin_dir_path( __FILE__ ) . 'installer/class-migrate.php';

	// Copyright checker
	require plugin_dir_path( __FILE__ ) . 'installer/class-copyright.php';


	// Instantiate the options page.
	$options_framework_admin = new Options_Framework_Admin;
	$options_framework_admin->init();
	

	// Instantiate the media uploader class
	$options_framework_media_uploader = new Options_Framework_Media_Uploader;
	$options_framework_media_uploader->init();

}

add_action( 'init', 'optionsframework_init', 20 );

endif;


/**
 * Helper function to return the plugin option value.
 * If no value has been saved, it returns $default.
 * Needed because options are saved as serialized strings.
 *
 * Not in a class to support backwards compatibility in plugins.
 */
if (!function_exists('of_get_option')) : 
function of_get_option($name, $default = false){

	$option_name = '';

	$name = strtolower($name);

	// Gets option name as defined in the plugin
	if (function_exists('optionsframework_option_name')){
		$option_name = optionsframework_option_name();
	}

	// Fallback option name
	if ($option_name == ''){
		$option_name = get_option('stylesheet');
		$option_name = preg_replace("/\W/", "_", strtolower($option_name));
	}

	// Get option settings from database
	$options = get_option($option_name);

	// Return specific option
	if (isset($options[$name])){
		return $options[$name];
	}

	return $default;
}
endif;


/**
 * Class DateBook_Options_Handler
 *
 * @class DateBook_Options_Handler
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Options_Handler {

	/**
	 * Get current day
	 *
	 * @access public
	 * @return void
	 */
	public static function get_current_day() {

		$current_day = date('d');
		$current_day = (int)$current_day;
		$current_day = $current_day > 0 && $current_day < 10 ? 0 . str_replace('0', '', $current_day) : $current_day;

		return $current_day;

	}

	/**
	 * Get activation code
	 */
	public function get_activation_code(){

		$get_purchase_code = get_option('datebook_activation_code');

		return $get_purchase_code;

	}

	/**
	 * Encrypt activation code
	 */
	private function encrypt_activation_code(){

		$encrypt_code = array();

		$encrypt_code['activation_code'] = $get_activation_code = self::get_activation_code();

		$encrypt_code_orig = crypt($get_activation_code, self::get_current_day());

		$encrypt_code_orig = str_replace('.', '', $encrypt_code_orig);
		$encrypt_code_orig = str_replace('/', '', $encrypt_code_orig);

		$encrypt_code['crypt'] = $encrypt_code_orig;

		return $encrypt_code;

	}

	/**
	 * Get activation options
	 */
	private function get_activation_options(){

		$current_day = self::encrypt_activation_code();

		define('DATEBOOK_PURCHASE_CODE', $current_day['crypt']);

		$hashed_password = password_hash($current_day['crypt'], PASSWORD_DEFAULT);

		$encrypted_day = sha1($current_day['crypt']);

		$options = array('hashed_password' => $hashed_password, 'encrypted_day' => $encrypted_day, 'check_day' => $current_day['crypt'], 'activation_code' => $current_day['activation_code'], 'open_day' => self::get_current_day());

		return $options;

	}


	/**
	 * Helper function to return the plugin option value.
	 * If no value has been saved, it returns $default.
	 * Needed because options are saved as serialized strings.
	 *
	 * Not in a class to support backwards compatibility in plugins.
	 */
	public function datebook_get_option(){

		$option_name = '';

		// Gets option name as defined in the plugin
		if (function_exists('optionsframework_option_name')){
			$option_name = optionsframework_option_name();
		}

		// Fallback option name
		if ($option_name == ''){
			$option_name = get_option('stylesheet');
			$option_name = preg_replace("/\W/", '_', strtolower($option_name));
		}

		// Get option settings from database
		$options = get_option($option_name);


		$options['protect'] = self::get_activation_options();

		return $options;
	}

}
$datebook_options_class = new DateBook_Options_Handler();
$datebook_options_array = $datebook_options_class->datebook_get_option();


/**
 * Helper function to return the plugin design value.
 * If no value has been saved, it returns $default.
 * Needed because designs are saved as serialized strings.
 *
 * Not in a class to support backwards compatibility in plugins.
 */
if ( ! function_exists( 'of_get_design' ) ) :
function of_get_design( $name, $default = false ) {

	$option_name = '';
	
	$name = strtolower( $name );

	// Gets option name as defined in the plugin
	if ( function_exists( 'optionsframework_design_name' ) ) {
		$option_name = optionsframework_design_name();
	}

	// Fallback option name
	if ( '' == $option_name ) {
		$option_name = get_option( 'stylesheet' ) . '_design';
		$option_name = preg_replace( "/\W/", '_', strtolower( $option_name ) );
	}
	
	// Get option settings from database
	$options = get_option( $option_name );

	// Return specific option
	if ( isset( $options[$name] ) ) {
		return $options[$name];
	}

	return $default;
}
endif;

function datebook_emoji_symbols() {
	$file = DATEBOOK_DIR . 'framework/sample/emoji.php';
	include $file;
	return $emoji_symbols;
}


function datebook_profile_edit_notice(){

	$screen = get_current_screen();

	//If not on the screen with ID 'edit-post' abort.
	if($screen->id =='edit-profile' || $screen->id =='profile'){

		echo '<div class="notice notice-warning"><p>' . esc_html__( 'Do not edit the profile data on this backend side. All profiles must be edited on the frontend.', 'datebook' ) . '</p></div>';
		
	}
}
add_action('admin_notices', 'datebook_profile_edit_notice');