<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the plugin.
 */
function optionsframework_option_name() {

	// This gets the plugin name from the stylesheet
	$pluginname = get_option( 'stylesheet' );
	$pluginname = preg_replace("/\W/", "_", strtolower($pluginname) );

	$datebook_settings = get_option( 'optionsframework' );
	$datebook_settings['id'] = $pluginname;
	update_option( 'optionsframework', $datebook_settings );

}


/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your plugin translatable, you should replace 'plugin-textdomain'
 * with the actual text domain for your plugin.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_plugin_textdomain
 */

function optionsframework_options() {

	global $wp_locale_all, $datebook_field_titles, $paid_features_subscriptions, $datebook_hourly_period, $datebook_minutely_period;

	set_query_var( 'datebook_field_titles', $datebook_field_titles );
	
	$datebook_field_titles = get_query_var( 'datebook_field_titles' );
	if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }


	// get languages
	$languages_active_array = $languages_translated_array = array();

	$languages_active_array['en_US'] = esc_html__( 'English', 'datebook' );

	$languages = DateBook_Localization::datebook_all_available_language_files();

	foreach($languages as $language) {

		switch($language['percent']) {
			case '100' : $css_complete = '#00c100'; break;
			case '0' : $css_complete = '#b2b6b7'; break;
			default: $css_complete = 'orange'; break;
		}

		$language_title = esc_html__( $wp_locale_all[$language['locale']], 'datebook' );

		$languages_translated_array[$language['locale']] = $language_title . ' (' . $language['locale'] . ') <span style="color:#fff; margin-left:10px; padding: 1px 8px; border-radius: 4px; background-color:' . $css_complete . '">'.esc_html__( 'Translated', 'datebook' ) . ': ' . $language['percent'] . '%</span>';

		if($language['checked'] == 1){
			$languages_active_array[$language['locale']] = $language_title;
		}

	}

	asort($languages_translated_array);

	// get colors
	$colors = datebook_get_color_schemes_plugin();
	$colors_array = array();
	foreach ( $colors as $color ) {
		$colors_array[$color] = ucfirst($color);
	}

	// get User menu items
	$user_menu_items_array = array();
	foreach ( $datebook_user_menu_items as $key => $value ) {
		$user_menu_items_array[$key] = esc_html__( $value['title'], 'datebook' );
	}

	$emoji_symbols = datebook_emoji_symbols();


	// get genders
	$sex_titles_array = array();
	foreach ( $datebook_gender_options as $key => $value ) {
		$sex_titles_array[$key] = esc_html__( $value, 'datebook' );
	}

	$sex_titles_added_array = array();
	foreach ( $datebook_gender_titles as $key => $value ) {
		$sex_titles_added_array[$key] = esc_html__( $value, 'datebook' );
	}


	// get sexual orientations
	$sexualorientation_titles_array = array();
	foreach ( $datebook_sexualorientation_options as $key => $value ) {
		$sexualorientation_titles_array[$key] = esc_html__( $value, 'datebook' );
	}


	// get currencies
	$currency_array = array();
	foreach ( $datebook_currency_titles as $key => $currency ) {
		$currency_array[strtolower($key)] = esc_html__( $currency[0], 'datebook' ) . " (" . esc_html__( $currency[1], 'datebook' ). ")";
	}

	// get who can see ptivacy
	$datebook_who_can_see_titles_array = array();
	foreach ( $datebook_who_can_see_array as $key => $value ) {
		$datebook_who_can_see_titles_array[$key] = esc_html__( $value, 'datebook' );
	}


	// enable and show with images and to logged in users only
	$show_profile_options = array(
		'show' => esc_html__('Yes', 'datebook' ),
		'with_images_only' => esc_html__('Show with images only', 'datebook' ),
		'show_to_loggedin_users' => esc_html__('Show to logged in users only', 'datebook' )
	);


	// registration field options
	$registration_defaults = array(
		'1' => esc_html__('Enable', 'datebook' ),
		'2' => esc_html__('Mandatory', 'datebook' ),
		'3' => esc_html__('Use in the search form', 'datebook' ),
		'4' => esc_html__('Visible to administrator only', 'datebook' )
	);


	$profile_details_args = array(
		'comments' => esc_html__( 'Quantity of comments', 'datebook' ),
		'images' => esc_html__( 'Quantity of images', 'datebook' ),
		'travel' => esc_html__( 'Ready to Travel icon', 'datebook' ),
		'age' => esc_html__( 'Age', 'datebook' ),
		'gender' => esc_html__( 'Gender', 'datebook' ),
		'sexorientation' => esc_html__( 'Sexual orientation', 'datebook' ),
		'city' => esc_html__( 'City', 'datebook' ),
		'country' => esc_html__( 'Country', 'datebook' )
	);


	// get pages
	$pages = get_pages(); 
	$pages_array = array();
	$pages_array[0] = esc_html__('Select page', 'datebook' );
	foreach ( $pages as $page ) {
		$pages_array[$page->ID] = $page->post_title;
	}


	// Typography Defaults
	$typography_defaults = array(
		'face' => '',
		'style' => 'normal' );

	$header_menu_args = array(
		'size' => '0.8125',
		'color' => '#ffffff' );

	$margin_defaults = array(
		'margin_top' => '',
		'margin_right' => '',
		'margin_bottom' => '',
		'margin_left' => '' );

	$margin_args = array(
		'margin_top' => '',
		'margin_right' => '',
		'margin_bottom' => '',
		'margin_left' => '' );

	$padding_args = array(
		'padding_top' => '',
		'padding_right' => '',
		'padding_bottom' => '',
		'padding_left' => '' );

	$shadow_args = array(
		'1' => esc_html__('None', 'datebook' ),
		'2' => esc_html__('Small', 'datebook' ) . ' 1',
		'3' => esc_html__('Small', 'datebook' ) . ' 2',
		'4' => esc_html__('Small', 'datebook' ) . ' 3',
		'5' => esc_html__('Small', 'datebook' ) . ' 4',
		'6' => esc_html__('Small', 'datebook' ) . ' 5',
		'7' => esc_html__('Normal', 'datebook' ) . ' 1',
		'8' => esc_html__('Normal', 'datebook' ) . ' 2',
		'9' => esc_html__('Normal', 'datebook' ) . ' 3',
		'10' => esc_html__('Normal', 'datebook' ) . ' 4',
		'11' => esc_html__('Normal', 'datebook' ) . ' 5',
		'12' => esc_html__('Large', 'datebook' ) . ' 1',
		'13' => esc_html__('Large', 'datebook' ) . ' 2',
		'14' => esc_html__('Large', 'datebook' ) . ' 3'
	);

	$profile_details_args = array(
		'comments' => esc_html__( 'Quantity of comments', 'datebook' ),
		'images' => esc_html__( 'Quantity of images', 'datebook' ),
		'travel' => esc_html__( 'Ready to Travel icon', 'datebook' ),
		'age' => esc_html__( 'Age', 'datebook' ),
		'sexorientation' => esc_html__( 'Sexual orientation', 'datebook' ),
		'gender' => esc_html__( 'Gender', 'datebook' ),
		'city' => esc_html__( 'City', 'datebook' ),
		'country' => esc_html__( 'Country', 'datebook' )
	);

	$wp_editor_settings = array(
		'wpautop' => true, // Default
		'textarea_rows' => 10,
		'tinymce' => array( 'plugins' => 'wordpress,wplink' )
	);

	// required pages
	$homepage = get_option('home_page');
	$loginpage = get_option('login_page');
	$forgotpasswordpage = get_option('forgot_password_page');
	$registerpage = get_option('registration_page');
	$contactpage = get_option('contact_page');
	$termspage = get_option('terms_page');
	$alltourspage = get_option('all_tours_page');
	$allclassifiedspage = get_option('all_classifieds_page');
	$searchpage = get_option('search_results_page');
	$profileeditpage = get_option('my_edit_profile_page');
	$profilemessagespage = get_option('my_messages_page');
	$profilephotospage = get_option('my_photos_page');
	$profilecommentspage = get_option('my_comments_page');
	$profiletourspage = get_option('my_tours_page');
	$profileverificationpage = get_option('my_verification_page');
	$profilefriendspage = get_option('my_friends_page');
	$profileblacklistpage = get_option('my_blacklist_page');
	$profilefavoritespage = get_option('my_favorites_page');
	$profileclassifiedspage = get_option('my_classifieds_page');
	$profileviewspage = get_option('my_views_page');
	$profilesettingspage = get_option('my_settings_page');
	$profileprivacypage = get_option('my_privacy_page');
	$profileupgradepage = get_option('my_upgrade_page');
	$profilecartepage = get_option('my_cart_page');
	$profilecheckoutpage = get_option('my_checkout_page');
	$profilenotificationpage = get_option('my_notification_page');


	// Stores all the controls that will be added
	$options = array();

	$options[] = array(
		'name' => esc_html__('Common', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Select color scheme', 'datebook' ),
		'desc' => esc_html__('Select form, buttons and some elements color scheme (Not the whole website color).', 'datebook' ),
		'id' => 'color_scheme_select',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $colors_array);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Show quantity of registered members', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Quantity of registered members will be displayed in the header.', 'datebook' ),
		'id' => 'quantity_registered_members',
		'std' => '1',
		'type' => 'checkbox',
		//'tooltip' => DATEBOOK_URL . 'framework/images/user-menu-position-front-5.jpg'
	);

	$options[] = array(
		'name' => esc_html__('Enable Cookies Bar', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_cookies',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Hide Administrator Top Bar', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'hide_administrator_bar',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Restrict Users to Administrator area', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('(Some third-party plugins may need access to files from administrator area. If so, you may disable this option but it is recommended you protect Administrator area by different way.)', 'datebook' ),
		'id' => 'enable_restricted_pages',
		'std' => '1',
		'type' => 'checkbox');

	$protocols = array('https://', 'https://www.', 'http://', 'http://www.', 'www.');
	$get_site_url = str_replace($protocols, '', get_site_url());

	foreach ( $languages_active_array as $language_key => $language_name ) {

		switch($language_key) {
			case 'en_US' : $language_std = '<p style="text-align: center;">&copy; ' . $get_site_url . ' '.date("Y").'. All rights reserved.</p>'; break;
			case 'de_DE' : $language_std = '<p style="text-align: center;">&copy; ' . $get_site_url . ' '.date("Y").'. Alle Rechte vorbehalten.</p>'; break;
			case 'es_ES' : $language_std = '<p style="text-align: center;">&copy; ' . $get_site_url . ' '.date("Y").'. Reservados todos los derechos.</p>'; break;
			case 'fr_FR' : $language_std = '<p style="text-align: center;">&copy; ' . $get_site_url . ' '.date("Y").'. Tous les droits sont réservés.</p>'; break;
			case 'it_IT' : $language_std = '<p style="text-align: center;">&copy; ' . $get_site_url . ' '.date("Y").'. Tutti i diritti riservati.</p>'; break;
			case 'nl' : $language_std = '<p style="text-align: center;">&copy; ' . $get_site_url . ' '.date("Y").'. Alle rechten voorbehouden.</p>'; break;
			case 'ru_RU' : $language_std = '<p style="text-align: center;">&copy; ' . $get_site_url . ' '.date("Y").'. Все права защищены.</p>'; break;
			case 'tr_TR' : $language_std = '<p style="text-align: center;">&copy; ' . $get_site_url . ' '.date("Y").'. Her hakkı saklıdır.</p>'; break;
			default: $language_std = '<p style="text-align: center;">&copy; ' . $get_site_url . ' '.date("Y").'. All rights reserved.</p>'; break;
		}

		$options[] = array(
			'name' => sprintf( esc_html__( 'Footer copyright notice (%1$s)', 'datebook' ), $language_name ),
			'desc' => esc_html__('Copyright notice in footer', 'datebook' ),
			'id' => 'copyright_footer_' . $language_key,
			'std' => $language_std,
			'class' => 'small', //mini, tiny, small
			'type' => 'customcode'
		);
	}

/////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Header', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	// Gradient color of header
	$options[] = array(
		'name' => esc_html__( 'Overlay color of Header on Home page', 'datebook' ),
		'id' => 'header_gradientcolor_front',
		'std' => 'linear-gradient(to top, transparent 0%, #2a5a8eb5 100%)',
		'type' => 'gradientcolor'
	);

	// Background image in Header
	$background_defaults = array(
		'color' => '#ffffff',
		'image' => DATEBOOK_URL . 'assets/images/welcome-four-people.jpg',
		'repeat' => 'no-repeat',
		'position' => 'top center',
		'attachment' => 'scroll' );

	$options[] = array(
		'name' => esc_html__('Background image in Header on Home page', 'datebook'),
		'desc' => esc_html__('Upload an image that will be placed as background in the header.', 'datebook'),
		'id' => 'header_bg_image_front',
		'std' => $background_defaults,
		'type' => 'background'
	);

	// Background image in Header
	$welcome_background_defaults = array(
		'color' => 'transparent',
		'image' => '',
		'repeat' => 'no-repeat',
		'position' => 'bottom left',
		'attachment' => 'scroll' );

	$options[] = array(
		'name' => esc_html__('Welcome image', 'datebook' ),
		'desc' => esc_html__('Upload an image that will be placed on the Home page.', 'datebook' ),
		'id' => 'welcome_bg_image',
		'std' => $welcome_background_defaults,
		'type' => 'background'
	);

	// Welcome title on Front page
	$options[] = array(
		'name' => esc_html__('Welcome text', 'datebook' ),
		'type' => 'info'
	);

	foreach ( $languages_active_array as $language_key => $language_name ) {

		switch($language_key) {
			case 'en_US' : $language_std = 'Dating For Mature Singles'; break;
			case 'de_DE' : $language_std = 'Dating für reife Singles'; break;
			case 'es_ES' : $language_std = 'Citas para solteros maduros'; break;
			case 'fr_FR' : $language_std = 'Rencontres pour célibataires d\'âge mûr'; break;
			case 'it_IT' : $language_std = 'Incontri per single maturi'; break;
			case 'nl' : $language_std = 'Dating voor volwassen singles'; break;
			case 'ru_RU' : $language_std = 'Знакомства для зрелых'; break;
			case 'tr_TR' : $language_std = 'Olgun Bekarlar İçin Arkadaş'; break;
			default: $language_std = 'Dating For Mature Singles'; break;
		}

		$options[] = array(
			'name' => sprintf( esc_html__( 'Welcome Slogan (%1$s)', 'datebook' ), $language_name ),
			'id' => 'welcome_slogan_' . $language_key,
			'std' => $language_std,
			'class' => 'tiny',
			'type' => 'text');
	}

	$typography_slogan_font = array(
		'size' => '4',
		'color' => '#ffffff',
		'face' => 'Fredoka One, display' );

	$options[] = array(
		'name' => esc_html__( 'Welcome Slogan: font', 'datebook' ),
		'id' => 'welcome_slogan_font',
		'std' => array_merge($typography_defaults, $typography_slogan_font),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('Welcome Slogan: align', 'datebook' ),
		'id' => 'welcome_slogan_align',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Welcome Slogan: margin', 'datebook' ),
		'id' => 'welcome_slogan_margin',
		'std' => array_merge($margin_defaults, array('margin_top' => '','margin_right' => '','margin_bottom' => '60px','margin_left' => '' )),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Welcome Slogan: padding', 'datebook' ),
		'id' => 'welcome_slogan_padding',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);

	$site_title = get_bloginfo( 'name' );

	foreach ( $languages_active_array as $language_key => $language_name ) {

		switch($language_key) {
			case 'en_US' : $language_std = '<h1 style="text-align: center;">Welcome to ' . $site_title . '!</h1><p style="text-align: center;">We are the number one destination for online dating with more dates, more relationships, &amp; more marriages than any other dating or personals site. We can help you find your perfect partner. We offer a bespoke, highly personal service and one of the largest databases of professional singles.</p>'; break;
			case 'de_DE' : $language_std = '<h1 style="text-align: center;">Willkommen bei ' . $site_title . '!</h1><p style="text-align: center;">Wir sind das Ziel Nummer eins für Online-Dating mit mehr Daten, mehr Beziehungen und mehr Ehen als jede andere Dating- oder Kontaktanzeigen-Website. Wir können Ihnen helfen, Ihren perfekten Partner zu finden. Wir bieten einen maßgeschneiderten, sehr persönlichen Service und eine der größten Datenbanken für professionelle Singles.</p>'; break;
			case 'es_ES' : $language_std = '<h1 style="text-align: center;">¡Bienvenido a ' . $site_title . '!</h1><p style="text-align: center;">Somos el destino número uno para las citas en línea con más citas, más relaciones y más matrimonios que cualquier otro sitio de citas o personales. Podemos ayudarte a encontrar tu pareja perfecta. Ofrecemos un servicio personalizado y altamente personalizado y una de las mayores bases de datos de solteros profesionales.</p>'; break;
			case 'fr_FR' : $language_std = '<h1 style="text-align: center;">Bienvenue dans ' . $site_title . '!</h1><p style="text-align: center;">Nous sommes la destination numéro un pour les rencontres en ligne avec plus de dates, plus de relations et plus de mariages que tout autre site de rencontres ou de rencontres. Nous pouvons vous aider à trouver votre partenaire idéal. Nous offrons un service sur mesure et hautement personnalisé et l\'une des plus grandes bases de données de célibataires professionnels.</p>'; break;
			case 'it_IT' : $language_std = '<h1 style="text-align: center;">Benvenuto in ' . $site_title . '!</h1><p style="text-align: center;">Siamo la destinazione numero uno per gli appuntamenti online con più date, più relazioni e più matrimoni di qualsiasi altro sito di incontri o annunci personali. Possiamo aiutarti a trovare il tuo partner perfetto. Offriamo un servizio personalizzato e altamente personalizzato e uno dei più grandi database di single professionisti.</p>'; break;
			case 'nl' : $language_std = '<h1 style="text-align: center;">Welkom bij ' . $site_title . '!</h1><p style="text-align: center;">Wij zijn de nummer één bestemming voor online dating met meer dates, meer relaties en meer huwelijken dan welke andere dating- of contactadvertentiesite dan ook. Wij kunnen u helpen bij het vinden van uw perfecte partner. We bieden een op maat gemaakte, zeer persoonlijke service en een van de grootste databases met professionele singles.</p>'; break;
			case 'ru_RU' : $language_std = '<h1 style="text-align: center;">Добро пожаловать в ' . $site_title . '!</h1><p style="text-align: center;">Мы - место номер один для онлайн-знакомств с большим количеством свиданий, больше отношений и браков, чем любой другой сайт знакомств или личных контактов. Мы поможем вам найти идеального партнера. Мы предлагаем индивидуальное обслуживание с индивидуальным подходом и одну из самых больших баз данных.</p>'; break;
			case 'tr_TR' : $language_std = '<h1 style="text-align: center;">Welcome to ' . $site_title . '!</h1><p style="text-align: center;">Diğer tüm flört veya kişisel sitelerden daha fazla tarih, daha fazla ilişki ve daha fazla evlilikle çevrimiçi buluşmanın bir numaralı hedefiyiz. Mükemmel partnerinizi bulmanıza yardımcı olabiliriz. Ismarlama, son derece kişisel bir hizmet ve profesyonel bekarların en büyük veri tabanlarından birini sunuyoruz.</p>'; break;
			default: $language_std = '<h1 style="text-align: center;">' . $site_title . '\'a hoş geldiniz!</h1><p style="text-align: center;">We are the number one destination for online dating with more dates, more relationships, &amp; more marriages than any other dating or personals site. We can help you find your perfect partner. We offer a bespoke, highly personal service and one of the largest databases of professional singles.</p>'; break;
		}

		$options[] = array(
			'name' => sprintf( esc_html__( 'Welcome message (%1$s)', 'datebook' ), $language_name ),
			'desc' => esc_html__('Write welcome text. It will be shown on the front page. (Example: We are the number one destination for online dating with more dates, more relationships, & more marriages than any other dating or personals site. We can help you find your perfect partner. We offer a bespoke, highly personal service and one of the largest databases of professional singles.)', 'datebook' ),
			'id' => 'welcome_text_' . $language_key,
			'std' => $language_std,
			'type' => 'editor',
			'settings' => $wp_editor_settings
		);

	}

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__( 'Overlay color of Header', 'datebook' ),
		'id' => 'header_gradientcolor_other',
		'std' => 'linear-gradient(to top, rgba(0, 93, 255, 0.31) 0%, rgb(0, 116, 249) 100%)',
		'type' => 'gradientcolor'
	);

	$options[] = array(
		'name' => esc_html__('Background image in Header', 'datebook'),
		'desc' => esc_html__('Upload an image that will be placed as background in the header.', 'datebook'),
		'id' => 'header_bg_image_other',
		'std' => $background_defaults,
		'type' => 'background'
	);


/////////////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Languages', 'datebook' ),
		'type' => 'heading'
	);

	$options[] = array(
		'name' => esc_html__('Enable the language functionality', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('You can disable this option if you are using other translation plugins like Polylang, TranslatePress, etc. The DateBook theme will still be translatable.', 'datebook' ),
		'id' => 'enable_language',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Show language menu?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'show_language_menu',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Display menu as', 'datebook' ),
		'id' => 'language_menu_style',
		'std' => 'list',
		'type' => 'select',
		'options' => array(
			'list' => esc_html__('List', 'datebook' ),
			'dropdown' => esc_html__('Dropdown', 'datebook' ),
			//'dropup' => esc_html__('Dropup', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Select default language', 'datebook' ),
		'desc' => esc_html__('The website will be loaded in this language when a user visits the website for the first time.', 'datebook' ),
		'id' => 'default_language',
		'std' => 'english',
		'type' => 'select',
		'options' => $languages_active_array
	);

	$options[] = array(
		'name' => esc_html__('Activate languages', 'datebook' ),
		'desc' => sprintf( esc_html__('Attention! Not all languages have translation! They were created so that you can easily open them in some language editor and enter your own translation. You can use the Loco Translate plugin to edit your language.', 'datebook' ) . ' %1$s', 
		'<a href="' . admin_url('/admin.php?page=datebook-options-framework&update=percentage-translated-languages') . '" class="button button-primary load-customize">' . esc_html__( 'Update the percentage of translated languages', 'datebook' ) . '</a>'),
		'id' => 'active_languages',
		'std' => 'en_US,de_DE,es_ES,fr_FR,it_IT,nl,ru_RU,tr_TR',
		'class' => 'small',
		'type' => 'multicheck',
		'options' => $languages_translated_array);


/////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Front Page', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Replace the home page for logged in users', 'datebook' ),
		'desc' => esc_html__('Select the page to display on the home page for logged in users instead of the default home page.', 'datebook' ),
		'id' => 'replace_front_page_by_this_page',
		'std' => '',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Show Countries on the front page?', 'datebook' ),
		'id' => 'countries_on_front',
		'std' => 'show_countries,profiles_quantity,with_flags,genders',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => array(
			'show_countries' => esc_html__('Yes', 'datebook' ),
			'show_empty_countries' => esc_html__('Show all countries (even if they have no profiles)', 'datebook' ),
			'show_to_loggedin_users' => esc_html__('Show to logged in users only', 'datebook' ),
			'profiles_quantity' => esc_html__( 'Show Quantity of profiles', 'datebook' ),
			'cities' => esc_html__( 'Show Cities', 'datebook' ),
			'with_flags' => esc_html__( 'Show Flags', 'datebook' ),
			'genders' => esc_html__( 'Show Genders', 'datebook' ),
			'sexorientations' => esc_html__( 'Show Sexual orientations', 'datebook' ),
	));


	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Mosaic of profiles', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Show the Search form on the front page?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'show_searchpanel',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Normal profiles: show on the front page?', 'datebook' ),
		'id' => 'normal_on_front',
		'std' => 'show',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $show_profile_options);

	$options[] = array(
		'name' => esc_html__('Normal profiles: quantity to show', 'datebook' ),
		'id' => 'normal_quantity_front',
		'std' => '30',
		'type' => 'select',
		'options' => array(
			'15' => '15 ' . esc_html__('profiles', 'datebook' ),
			'30' => '30 ' . esc_html__('profiles', 'datebook' ),
			'45' => '45 ' . esc_html__('profiles', 'datebook' ),
			'60' => '60 ' . esc_html__('profiles', 'datebook' ),
			'75' => '75 ' . esc_html__('profiles', 'datebook' ),
			'90' => '90 ' . esc_html__('profiles', 'datebook' ),
			'105' => '105 ' . esc_html__('profiles', 'datebook' ),
			'120' => '120 ' . esc_html__('profiles', 'datebook' ),
		));

	$options[] = array('type' => 'container_in');

	$options[] = array(
		'name' => esc_html__('Enable custom styling of profile mosaic?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_custom_profiles',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Mosaic of normal profiles: roundness of images', 'datebook' ),
		'id' => 'normal_round_front',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('No round', 'datebook' ),
			'2' => esc_html__('Rounded corners', 'datebook' ),
			'3' => esc_html__('Rounded circle', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Mosaic of normal profiles: images padding', 'datebook' ),
		'id' => 'normal_padding_front',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('0 rem', 'datebook' ),
			'2' => esc_html__('0.25 rem', 'datebook' ),
			'3' => esc_html__('0.5 rem', 'datebook' ),
			'4' => esc_html__('1 rem', 'datebook' ),
			'5' => esc_html__('1.5 rem', 'datebook' ),
			'6' => esc_html__('3 rem', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Mosaic of normal profiles: shadow of images', 'datebook' ),
		'id' => 'normal_shadow_front',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__('Mosaic of normal profiles: width of image border', 'datebook' ),
		'desc' => esc_html__('Width of image border can be 3 options: 1. enter random numbers separated by a comma. Example: 1,12 = borders will be random width from 1 to 12 pixels. 2. enter one number. Example: 5 = border for all images will be 5px. 3. enter 0 = no borders', 'datebook' ),
		'id' => 'normal_border_front',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__( 'Mosaic of normal profiles: color of border', 'datebook' ),
		'id' => 'normal_border_color',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Mosaic of normal profiles: gamma of colors', 'datebook' ),
		'desc' => esc_html__('Remove Color of border (above) to enable this option', 'datebook' ),
		'id' => 'normal_color_gamma',
		'std' => 'light',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('None', 'datebook' ),
			'random' => esc_html__('Random', 'datebook' ),
			'light' => esc_html__('Random Light', 'datebook' ),
			'dark' => esc_html__('Random Dark', 'datebook' )
		));

	$options[] = array('type' => 'container_out');


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Profile', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Profile Image layout', 'datebook' ),
		'desc' => esc_html__('Default profile image can be shown on the left or right side on Single profile page.', 'datebook' ),
		'id' => 'profile_image_side',
		'std' => 'left',
		'type' => 'images',
		"options" => array(
			"left" => DATEBOOK_URL . "framework/images/2cl-profile-image.png",
			"right" => DATEBOOK_URL . "framework/images/2cr-profile-image.png")
		);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Manually activate new profile?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('If you choose "yes" you will have to activate each profile manually', 'datebook' ) . '. ' . esc_html__('Note: profile can be published only when user verifies his email', 'datebook' ),
		'id' => 'activate_manual_new_profile',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Receive an email notification when someone registers?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'email_when_register',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Receive an email notification when a profile becomes active?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'email_when_activate_profile',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Suspend a profile after a user edited it', 'datebook' ),
		'desc' => esc_html__('If suspended, an email notification will be sent to administrator', 'datebook' ),
		'id' => 'suspend_profile_after_edit',
		'std' => '2',
		'type' => 'radio',
		'options' => array(
		'0' => esc_html__( 'Do not suspend', 'datebook' ),
		'1' => esc_html__( 'Suspend a profile completely', 'datebook' ),
		'2' => esc_html__( 'Suspend only a new content submitted by a user for review. Profile is still active and old content is still visible.', 'datebook' ),
	));

	$options[] = array(
		'name' => esc_html__('Receive an email notification when a profile is edited?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Send an email to administrator each time user edits his profile. Notice: the notification is sent only if user makes changes to text fields. Fields with selection options are ignored and the notification is not sent. Also, be careful, your server may get overloaded while sending multiple emails.', 'datebook' ),
		'id' => 'receive_email_on_profile_update',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('User must verify his email after registration', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'user_must_validate_email',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Force redirect a user to an email verification page', 'datebook' ),
		'desc' => esc_html__( 'Yes', 'datebook' ),
		'id' => 'force_redirect_to_validate_email',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Redirect after email confirmed', 'datebook' ),
		'desc' => esc_html__('User will be redirected to this page after he confirmed his email. Notice: user will not be redirected to this page if Force redirect to Photos page, Force redirect to Profile edit page, and Force redirect to Subscription page are enabled.', 'datebook' ),
		'id' => 'redirect_to_after_email_confirmation',
		'std' => '',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Check for Profiles who did not verify their email every', 'datebook' ),
		'desc' => esc_html__('day. If 0 (zero) is set then emails will be checked every 1 day by default.', 'datebook' ),
		'id' => 'check_notvalidate_email_days',
		'std' => '1',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Send a notification again to a user about unverified email address', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('If the user has not verified his email address, a notification will be sent to him that he should verify his emaill address.', 'datebook' ),
		'id' => 'enable_notification_verify_email_again',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Send notification again after the registration in', 'datebook' ),
		'desc' => esc_html__('day(s)', 'datebook' ),
		'id' => 'send_notification_again_days',
		'std' => '1',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Delete Profiles who did not verify their email within', 'datebook' ),
		'desc' => esc_html__('days. After this number of days accounts will be automatically deleted (0 = do not delete)', 'datebook' ),
		'id' => 'validate_email_days',
		'std' => '90',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable Verification?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Users can upload some document verifying their identity. After it, administrator can set a profile as Verified.', 'datebook' ),
		'id' => 'enable_verification',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Receive an email notification when someone uploads image for Verification?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'email_when_verification',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable Blacklisted profiles?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_blacklisted_profiles',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Profile name type', 'datebook' ),
		'desc' => esc_html__('Profile name field can be suggested as', 'datebook' ),
		'id' => 'profile_name_type',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
		'1' => esc_html__( 'Profile name', 'datebook' ),
		'2' => esc_html__( 'Title', 'datebook' ),
		'3' => esc_html__( 'Username', 'datebook' ),
	));

	$options[] = array(
		'name' => esc_html__('Prohibit change of Profile name', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'prohibit_name_change',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Profile name length limit', 'datebook' ),
		'desc' => esc_html__('Max. quantity of characters allowed in Profile name (0 = unlimited)', 'datebook' ),
		'id' => 'characters_limit_profilename',
		'std' => '40',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('What characters allowed in Profile name?', 'datebook' ),
		'id' => 'what_characters_profilename',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
		'1' => esc_html__( 'Any characters', 'datebook' ),
		'2' => esc_html__( 'Letters only', 'datebook' ),
		'3' => esc_html__( 'Letters and numbers only', 'datebook' ),
	));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Users must upload a photo before using the website', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'user_must_upload_photo',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Force redirect user to Photo page', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('If a user did not upload a photo, force redirect him to the Photos page', 'datebook' ),
		'id' => 'force_redirect_user_to_upload_photo',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Prohibit deleting of Profile images', 'datebook' ),
		'id' => 'prohibit_images_delete',
		'std' => '',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => array(
			'1' => esc_html__( 'Yes', 'datebook' ),
			'2' => esc_html__( 'Show deleted images only to owners', 'datebook' ),
			'3' => esc_html__( 'Hide the Delete button', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many images are allowed for profile?', 'datebook' ),
		'desc' => esc_html__('Max. quantity of photos allowed to upload in Profile (0 = unlimited)', 'datebook' ) . ' ' . esc_html__('Note: this feature has no effect if subscription is enabled', 'datebook' ),
		'id' => 'quantity_images_per_profile',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Allowed max. image size to upload', 'datebook' ),
		'desc' => esc_html__('Enter size of image in bytes. Numbers only (1 mb = 1048576, 2 mb = 2097152, 3 mb = 3145728, 4 mb = 4194304, 5 mb = 5242880, 6 mb = 6291456, 10 mb = 10485760, 15 mb = 15728640, 20 mb = 20971520)', 'datebook' ),
		'id' => 'allowed_max_image_size',
		'std' => '10485760',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Dimensions of a large profile image shown in the Lightbox', 'datebook' ),
		'desc' => esc_html__('Enter width and height of image (numbers only) separated by comma', 'datebook' ) . '. (' . esc_html__('Example', 'datebook' ) . ': 1000,800)',
		'id' => 'profile_big_image_size',
		'std' => '800,600',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Minimum image sizes allowed to upload', 'datebook' ),
		'desc' => esc_html__('Enter width and height of image (numbers only) separated by comma', 'datebook' ) . '. (' . esc_html__('Example', 'datebook' ) . ': 400,500). ' . esc_html__('Note: do not enter less than these minimum sizes specified by the theme (width 339px - height 362px)', 'datebook' ),
		'id' => 'minimal_image_dimensions',
		'std' => '339,362',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('How many images to display under the main profile image?', 'datebook' ),
		'desc' => esc_html__('Max. quantity of small photos displayed under the main photo of profile on Single Profile page (0 = no photos)', 'datebook' ),
		'id' => 'quantity_images_under_profile',
		'std' => '3',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Allowed file extensions to upload', 'datebook' ),
		'desc' => esc_html__('Enter image file extensions that users can upload to their profile separated by comma. (Example: jpg, png, gif, bmp)', 'datebook' ),
		'id' => 'allowed_file_extensions',
		'std' => 'jpg, png, gif, bmp',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Display all images in Lightbox (pop-up window)', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'display_all_imagesin_lightbox',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('User must complete his profile before using the website', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'user_must_complete_profile',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Force redirect user to Profile edit page', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('If a user did not complete all required fields, force redirect him to the Profile edit page', 'datebook' ),
		'id' => 'force_redirect_user_to_complete_profile',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Visitors will be displayed on Who Viewed Me page within', 'datebook' ),
		'desc' => esc_html__('days. After this number of days old visitors will be automatically deleted (if not set then 365 days by default)', 'datebook' ),
		'id' => 'period_delete_old_visitors',
		'std' => '90',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Show the following details on Who Viewed Me page', 'datebook' ),
		'id' => 'show_profile_details_on_who_viewed_me',
		'std' => 'name,comments,images,travel,age,sexorientation,gender,city,country',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => array(
			'name' => esc_html__( 'Name', 'datebook' ),
			'age' => esc_html__( 'Age', 'datebook' ),
			'gender' => esc_html__( 'Gender', 'datebook' ),
			'city' => esc_html__( 'City', 'datebook' ),
			'country' => esc_html__( 'Country', 'datebook' )
		)
	);

	$options[] = array('type' => 'hr');

	/*$options[] = array(
		'name' => esc_html__('Change the words "Was here xx minutes ago" in places', 'datebook' ),
		'desc' => esc_html__('Select the languages where to change. In some foreign languages the word "ago" goes before time period. (Example in Spanish: Hace (ago) cinco (five) meses (months) = five months ago)', 'datebook' ),
		'id' => 'change_online_words_places',
		'std' => '',
		'type' => 'multicheck',
		'options' => $languages_active_array);

	$options[] = array('type' => 'hr');*/

	$options[] = array(
		'name' => esc_html__('Date of Birth format', 'datebook' ),
		'id' => 'birthdate_format',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
			'1' => '29 ' . esc_html__( 'years old', 'datebook' ),
			'2' => '10 ' . esc_html__( 'March', 'datebook' ) . ' 1990',
			'3' => esc_html__( 'March', 'datebook' ) . ' 10, 1990',
			'4' => '10 ' . esc_html__( 'March', 'datebook' ),
			'5' => esc_html__( 'March', 'datebook' ) . ' 10',
			'6' => esc_html__( 'March', 'datebook' ) . ' 1990',
			'7' => '1990',
	));

	$options[] = array(
		'name' => esc_html__('Allow edit Date of Birth after registration', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'allow_edit_birthdate',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Enable Zodiac sign in profile', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_hide_zodiac',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Allow hide Zodiac sign in profile', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'allow_hide_zodiac',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Zodiac sign look', 'datebook' ),
		'id' => 'zodiac_look',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
		'1' => esc_html__( 'Sign', 'datebook' ) . ' (&#9809;)',
		'2' => esc_html__( 'Title', 'datebook' ) . ' (' . esc_html__( 'Capricorn', 'datebook' ) . ')',
		'3' => esc_html__( 'Sign and Title', 'datebook' ) . ' (&#9809; ' . esc_html__( 'Capricorn', 'datebook' ) . ')',
		'4' => esc_html__( 'Title and Sign', 'datebook' ) . ' (' . esc_html__( 'Capricorn', 'datebook' ) . ' &#9809;)',
	));

	$options[] = array(
		'name' => esc_html__('Allow edit Gender after registration', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'allow_edit_gender',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Wish to travel', 'datebook' ),
		'id' => 'wishtravel',
		'std' => '',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $registration_defaults);

	$options[] = array(
		'name' => esc_html__('Enable Online indicator on profile', 'datebook' ),
		'desc' => esc_html__('Displays "Online" / "Last login" indicator on the Profile page.', 'datebook' ) . ' ' . esc_html__('Note: these settings affect the My messages page too', 'datebook' ),
		'id' => 'online_indicator_profile',
		'std' => '3',
		'type' => 'radio',
		'options' => array(
			'1' => esc_html__( 'Online only (no text)', 'datebook' ),
			'2' => esc_html__( 'Online only (with text)', 'datebook' ),
			'3' => esc_html__( 'Online and Last login (full text)', 'datebook' ),
			'4' => esc_html__( 'Online and Last login (date only)', 'datebook' ),
			'5' => esc_html__( 'No indicator', 'datebook' )
		)
	);

	$options[] = array(
		'name' => esc_html__('Show statistics and additional info on Profile page', 'datebook' ),
		'desc' => esc_html__('Additional info will be shown at the bottom of Profile', 'datebook' ),
		'id' => 'show_profile_statistic',
		'std' => '1,1,1,1,1',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => array(
			'2' => esc_html__( 'Joined day', 'datebook' ),
			'3' => esc_html__( 'ID of profile', 'datebook' ),
			'4' => esc_html__( 'Social buttons', 'datebook' )
		)
	);

	$options[] = array(
		'name' => esc_html__('Show statistics of profile views for', 'datebook' ),
		'id' => 'statistics_kind_on_profile',
		'std' => '9',
		'type' => 'radio',
		'options' => array(
			'0' => esc_html__( 'none', 'datebook'),
			'1' => esc_html__( 'yesterday', 'datebook'),
			'2' => esc_html__( 'today', 'datebook'),
			'3' => esc_html__( 'last 24 hours', 'datebook'),
			'4' => esc_html__( 'last week', 'datebook'),
			'5' => esc_html__( 'last 7 days', 'datebook'),
			'6' => esc_html__( 'last 10 days', 'datebook'),
			'7' => esc_html__( 'last 14 days', 'datebook'),
			'8' => esc_html__( 'last 20 days', 'datebook'),
			'9' => esc_html__( 'last 30 days', 'datebook'),
			'10' => esc_html__( 'last month', 'datebook'),
			'11' => esc_html__( 'last year', 'datebook'),
			'12' => esc_html__( 'this year', 'datebook'),
		)
	);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Related profiles by country at the bottom of Profile: show', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'relatedprofilesbycountry',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Related profiles by country at the bottom of Profile: quantity', 'datebook' ),
		'desc' => esc_html__('Quantity of profiles per one row', 'datebook' ),
		'id' => 'quantity_profilesbycountry',
		'std' => '6',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'2' => '2 ' . esc_html__('profiles', 'datebook' ),
			'3' => '3 ' . esc_html__('profiles', 'datebook' ),
			'4' => '4 ' . esc_html__('profiles', 'datebook' ),
			'6' => '6 ' . esc_html__('profiles', 'datebook' ),
			'12' => '12 ' . esc_html__('profiles', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Related profiles by country at the bottom of Profile: rows', 'datebook' ),
		'desc' => esc_html__('Quantity of rows', 'datebook' ),
		'id' => 'quantity_of_rows_profilesbycountry',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => '1 ' . esc_html__('row', 'datebook' ),
			'2' => '2 ' . esc_html__('rows', 'datebook' ),
			'3' => '3 ' . esc_html__('rows', 'datebook' ),
			'4' => '4 ' . esc_html__('rows', 'datebook' ),
			'5' => '5 ' . esc_html__('rows', 'datebook' ),
			'6' => '6 ' . esc_html__('rows', 'datebook' ),
			'7' => '7 ' . esc_html__('rows', 'datebook' ),
			'8' => '8 ' . esc_html__('rows', 'datebook' ),
			'9' => '9 ' . esc_html__('rows', 'datebook' ),
			'10' => '10 ' . esc_html__('rows', 'datebook' ),
			'11' => '11 ' . esc_html__('rows', 'datebook' ),
			'12' => '12 ' . esc_html__('rows', 'datebook' ),
			'13' => '13 ' . esc_html__('rows', 'datebook' ),
			'14' => '14 ' . esc_html__('rows', 'datebook' ),
			'15' => '15 ' . esc_html__('rows', 'datebook' ),
			'16' => '16 ' . esc_html__('rows', 'datebook' ),
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Profile permalink slug', 'datebook' ),
		'desc' => sprintf( esc_html__( 'The permalink slug used for location archives and single locations (by default it is set to "profile"). %1$s Please make sure you flush your rewrite rules after changing this setting. You can do so by navigating to %2$s and clicking "Save Changes".', 'datebook' ), 
		'<strong>Note:</strong>', 
		'<a href="' . get_admin_url(get_current_blog_id(), 'options-permalink.php') . '">Settings->Permalinks</a>'
		 ),
		'id' => 'profile_permalink_slug',
		'std' => 'profile',
		'class' => 'small',
		'type' => 'text');
		
	$options[] = array(
		'name' => esc_html__('Disable default WordPress notifications about password changes', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('WordPress itself sends an email notification when a user changes his/her password. You can disable such notifications. (Recommended)', 'datebook' ),
		'id' => 'stop_password_change_notification',
		'std' => '1',
		'type' => 'checkbox');


/////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Featured', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable Featured status?', 'datebook' ),
		'id' => 'featured_enabled',
		'std' => 'show',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $show_profile_options);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Show Featured profiles on the Front page?', 'datebook' ),
		'id' => 'featured_on_front',
		'std' => 'show',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $show_profile_options);

	$options[] = array(
		'name' => esc_html__('Featured profiles: quantity', 'datebook' ),
		'desc' => esc_html__('profiles', 'datebook' ),
		'id' => 'featured_quantity_front',
		'std' => '12',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Smartphones: iPhones, Galaxy Phones, Google Pixel, HTC Phones, Windows Phone)', 'datebook' ),
		'desc' => esc_html__('Too small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the Home page.', 'datebook' ),
		'id' => 'how_many_columns_featured_mobile_front',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '1 ' . esc_html__( 'column', 'datebook' ),
			'2' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '6 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Tablets: iPads, Galaxy Tablets, Nexus Tablets, Kindle Fire)', 'datebook' ),
		'desc' => esc_html__('Small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the Home page.', 'datebook' ),
		'id' => 'how_many_columns_featured_tablet_front',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Normal screens (Desktops)', 'datebook' ),
		'desc' => esc_html__('Normal screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the Home page.', 'datebook' ),
		'id' => 'how_many_columns_featured_normal_front',
		'std' => '4',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Large screens (Widescreen desktop and Laptops)', 'datebook' ),
		'desc' => esc_html__('Large screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the Home page.', 'datebook' ),
		'id' => 'how_many_columns_featured_large_front',
		'std' => '5',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Profile page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Show the Featured on the Profile page?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'featured_on_profiles',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Featured profiles: quantity', 'datebook' ),
		'desc' => esc_html__('profiles', 'datebook' ),
		'id' => 'featured_quantity_on_profile',
		'std' => '12',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Smartphones: iPhones, Galaxy Phones, Google Pixel, HTC Phones, Windows Phone)', 'datebook' ),
		'desc' => esc_html__('Too small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_mobile_on_profile',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '1 ' . esc_html__( 'column', 'datebook' ),
			'2' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '6 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Tablets: iPads, Galaxy Tablets, Nexus Tablets, Kindle Fire)', 'datebook' ),
		'desc' => esc_html__('Small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_tablet_on_profile',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Normal screens (Desktops)', 'datebook' ),
		'desc' => esc_html__('Normal screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_normal_on_profile',
		'std' => '4',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Large screens (Widescreen desktop and Laptops)', 'datebook' ),
		'desc' => esc_html__('Large screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_large_on_profile',
		'std' => '5',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Search page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Show the Featured on the Search page?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'featured_on_search',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Featured profiles: quantity', 'datebook' ),
		'desc' => esc_html__('profiles', 'datebook' ),
		'id' => 'featured_quantity_on_search',
		'std' => '12',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Smartphones: iPhones, Galaxy Phones, Google Pixel, HTC Phones, Windows Phone)', 'datebook' ),
		'desc' => esc_html__('Too small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_mobile_on_search',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '1 ' . esc_html__( 'column', 'datebook' ),
			'2' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '6 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Tablets: iPads, Galaxy Tablets, Nexus Tablets, Kindle Fire)', 'datebook' ),
		'desc' => esc_html__('Small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_tablet_on_search',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Normal screens (Desktops)', 'datebook' ),
		'desc' => esc_html__('Normal screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_normal_on_search',
		'std' => '4',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Large screens (Widescreen desktop and Laptops)', 'datebook' ),
		'desc' => esc_html__('Large screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_large_on_search',
		'std' => '5',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Classifieds page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Show the Featured on the Classifieds page?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'featured_on_classifieds',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Featured profiles: quantity', 'datebook' ),
		'desc' => esc_html__('profiles', 'datebook' ),
		'id' => 'featured_quantity_on_classifieds',
		'std' => '12',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Smartphones: iPhones, Galaxy Phones, Google Pixel, HTC Phones, Windows Phone)', 'datebook' ),
		'desc' => esc_html__('Too small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_mobile_on_classifieds',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '1 ' . esc_html__( 'column', 'datebook' ),
			'2' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '6 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Tablets: iPads, Galaxy Tablets, Nexus Tablets, Kindle Fire)', 'datebook' ),
		'desc' => esc_html__('Small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_tablet_on_classifieds',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Normal screens (Desktops)', 'datebook' ),
		'desc' => esc_html__('Normal screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_normal_on_classifieds',
		'std' => '4',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Large screens (Widescreen desktop and Laptops)', 'datebook' ),
		'desc' => esc_html__('Large screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_large_on_classifieds',
		'std' => '5',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Tours page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Show the Featured on the Tours page?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'featured_on_tours',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Featured profiles: quantity', 'datebook' ),
		'desc' => esc_html__('profiles', 'datebook' ),
		'id' => 'featured_quantity_on_tours',
		'std' => '12',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Smartphones: iPhones, Galaxy Phones, Google Pixel, HTC Phones, Windows Phone)', 'datebook' ),
		'desc' => esc_html__('Too small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_mobile_on_tours',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '1 ' . esc_html__( 'column', 'datebook' ),
			'2' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '6 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Tablets: iPads, Galaxy Tablets, Nexus Tablets, Kindle Fire)', 'datebook' ),
		'desc' => esc_html__('Small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_tablet_on_tours',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Normal screens (Desktops)', 'datebook' ),
		'desc' => esc_html__('Normal screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_normal_on_tours',
		'std' => '4',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Large screens (Widescreen desktop and Laptops)', 'datebook' ),
		'desc' => esc_html__('Large screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_large_on_tours',
		'std' => '5',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Category page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Show the Featured on the Category page?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'featured_on_cats',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Featured profiles: quantity', 'datebook' ),
		'desc' => esc_html__('profiles', 'datebook' ),
		'id' => 'featured_quantity_on_cats',
		'std' => '12',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Smartphones: iPhones, Galaxy Phones, Google Pixel, HTC Phones, Windows Phone)', 'datebook' ),
		'desc' => esc_html__('Too small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_mobile_on_cats',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '1 ' . esc_html__( 'column', 'datebook' ),
			'2' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '6 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Tablets: iPads, Galaxy Tablets, Nexus Tablets, Kindle Fire)', 'datebook' ),
		'desc' => esc_html__('Small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_tablet_on_cats',
		'std' => '2',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Normal screens (Desktops)', 'datebook' ),
		'desc' => esc_html__('Normal screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_normal_on_cats',
		'std' => '4',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Large screens (Widescreen desktop and Laptops)', 'datebook' ),
		'desc' => esc_html__('Large screen', 'datebook' ) . '. ' . esc_html__('Quantity of Featured profiles shown in a row on the other page.', 'datebook' ),
		'id' => 'how_many_columns_featured_large_on_cats',
		'std' => '5',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array('type' => 'container_in');

	$options[] = array(
		'name' => esc_html__('Featured panel: width', 'datebook' ),
		'id' => 'featured_panel_width',
		'std' => 'full',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'full' => esc_html__('Full', 'datebook' ),
			'boxed' => esc_html__('Boxed', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Featured panel: background color', 'datebook' ),
		'id' => 'featured_panel_color',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Featured panel: top and bottom margin', 'datebook' ),
		'id' => 'featured_panel_topmargin',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'0' => '0 rem',
			'1' => '.25 rem',
			'2' => '.5 rem',
			'3' => '1 rem',
			'4' => '1.5 rem',
			'5' => '3 rem',
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Style of profile', 'datebook' ),
		'desc' => esc_html__('Profile can be displayed in different styles', 'datebook' ),
		'id' => 'featured_profiles_style_front',
		'std' => '4',
		'type' => 'radio',
		'options' => array(
			'1' => '1. ' . esc_html__( 'Full content', 'datebook' ),
			'2' => '2. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'3' => '3. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'4' => '4. ' . esc_html__( 'Image displayed, content in popover', 'datebook' )
	));

	$options[] = array(
		'name' => esc_html__('Show the following details', 'datebook' ),
		'id' => 'featured_info_front',
		'std' => 'comments,images,travel,age,gender,sexorientation,city,country',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $profile_details_args
	);

	$options[] = array(
		'name' => esc_html__('Align of text', 'datebook' ),
		'id' => 'featured_text_align_front',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('Default', 'datebook' ),
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' ),
			'justify' => esc_html__('Justify', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Text color of name', 'datebook' ),
		'id' => 'featured_header_text_color_front',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Text color of other info', 'datebook' ),
		'id' => 'featured_body_text_color_front',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color', 'datebook' ),
		'id' => 'featured_background_color_front',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Border: width', 'datebook' ),
		'desc' => esc_html__('Width of image border can be 3 options: 1. enter random numbers separated by a comma. Example: 1,12 = borders will be random width from 1 to 12 pixels. 2. enter one number. Example: 5 = border for all images will be 5px. 3. enter 0 = no borders', 'datebook' ),
		'id' => 'featured_border_width_front',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Border: style', 'datebook' ),
		'id' => 'featured_border_style_front',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__( 'Border: color', 'datebook' ),
		'id' => 'featured_border_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Border: roundness', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_round_front',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Gamma of colors', 'datebook' ),
		'desc' => esc_html__('Remove Border: color (above) to enable this option', 'datebook' ),
		'id' => 'featured_color_gamma_front',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('None', 'datebook' ),
			'random' => esc_html__('Random', 'datebook' ),
			'light' => esc_html__('Random Light', 'datebook' ),
			'dark' => esc_html__('Random Dark', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'featured_shadow_front',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__('Margin', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_margin_front',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Padding', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_padding_front',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Style of profile', 'datebook' ),
		'desc' => esc_html__('Profile can be displayed in different styles', 'datebook' ),
		'id' => 'featured_profiles_style_other',
		'std' => '4',
		'type' => 'radio',
		'options' => array(
			'1' => '1. ' . esc_html__( 'Full content', 'datebook' ),
			'2' => '2. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'3' => '3. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'4' => '4. ' . esc_html__( 'Image displayed, content in popover', 'datebook' )
	));

	$options[] = array(
		'name' => esc_html__('Show details', 'datebook' ),
		'id' => 'featured_info_other',
		'std' => 'comments,images,travel,age,gender,sexorientation,city,country',
		'method' => 'multinumber',
		'type' => 'multicheck',
		"options" => $profile_details_args
	);

	$options[] = array(
		'name' => esc_html__('Align of text', 'datebook' ),
		'id' => 'featured_text_align_other',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('Default', 'datebook' ),
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' ),
			'justify' => esc_html__('Justify', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Text color of name', 'datebook' ),
		'id' => 'featured_header_text_color_other',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Text color of other info', 'datebook' ),
		'id' => 'featured_body_text_color_other',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color', 'datebook' ),
		'id' => 'featured_background_color_other',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Border: width', 'datebook' ),
		'desc' => esc_html__('Width of image border can be 3 options: 1. enter random numbers separated by a comma. Example: 1,12 = borders will be random width from 1 to 12 pixels. 2. enter one number. Example: 5 = border for all images will be 5px. 3. enter 0 = no borders', 'datebook' ),
		'id' => 'featured_border_width_other',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Border: style', 'datebook' ),
		'id' => 'featured_border_style_other',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__( 'Border: color', 'datebook' ),
		'id' => 'featured_border_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Border: roundness', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_round_other',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Gamma of colors', 'datebook' ),
		'desc' => esc_html__('Remove Border: color (above) to enable this option', 'datebook' ),
		'id' => 'featured_color_gamma_other',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('None', 'datebook' ),
			'random' => esc_html__('Random', 'datebook' ),
			'light' => esc_html__('Random Light', 'datebook' ),
			'dark' => esc_html__('Random Dark', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'featured_shadow_other',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__('Margin', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_margin_other',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Padding', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_padding_other',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Background image in Featured images panel on Profile page', 'datebook'),
		'desc' => esc_html__('Upload an image that will be placed as background in the panel suggesting Featured images on the Profile page.', 'datebook'),
		'id' => 'bg_featured_images_panel',
		'std' => DATEBOOK_URL . 'assets/images/bg-featured-images-panel.jpg',
		'type' => 'upload');

	$options[] = array(
		'name' => esc_html__('Enable default background images for Featured profiles', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_default_images_for_featured_profiles',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Featured background images', 'datebook'),
		'desc' => esc_html__('Upload your patterns for background of Featured profiles. Notice: first, you should upload images then reload this and select uploaded images.', 'datebook'),
		'id' => 'featured_background_images',
		'std' => '',
		'type' => 'multiupload');

	$options[] = array('type' => 'container_out');


//////////////////////////////////////////////////////////////////

	$options[] = array(
		'name' => esc_html__('Top', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable Top status?', 'datebook' ),
		'id' => 'top_enabled',
		'std' => 'show',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $show_profile_options);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Show Top Profiles on the Front page?', 'datebook' ),
		'id' => 'topad_on_front',
		'std' => 'show',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $show_profile_options);

	$options[] = array(
		'name' => esc_html__('Quantity of Top Profiles', 'datebook' ),
		'desc' => esc_html__('Enter numbers only', 'datebook' ),
		'id' => 'topad_quantity',
		'std' => '6',
		'class' => 'mini', //mini, tiny, small
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Smartphones: iPhones, Galaxy Phones, Google Pixel, HTC Phones, Windows Phone)', 'datebook' ),
		'desc' => esc_html__('Too small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Top profiles shown in a row on the Home page.', 'datebook' ),
		'id' => 'how_many_columns_top_mobile',
		'std' => '2',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '1 ' . esc_html__( 'column', 'datebook' ),
			'2' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '6 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Tablets: iPads, Galaxy Tablets, Nexus Tablets, Kindle Fire)', 'datebook' ),
		'desc' => esc_html__('Small screen', 'datebook' ) . '. ' . esc_html__('Quantity of Top profiles shown in a row on the Home page.', 'datebook' ),
		'id' => 'how_many_columns_top_tablet',
		'std' => '2',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Normal screens (Desktops)', 'datebook' ),
		'desc' => esc_html__('Normal screen', 'datebook' ) . '. ' . esc_html__('Quantity of Top profiles shown in a row on the Home page.', 'datebook' ),
		'id' => 'how_many_columns_top_normal',
		'std' => '4',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Large screens (Widescreen desktop and Laptops)', 'datebook' ),
		'desc' => esc_html__('Large screen', 'datebook' ) . '. ' . esc_html__('Quantity of Top profiles shown in a row on the Home page.', 'datebook' ),
		'id' => 'how_many_columns_top_large',
		'std' => '4',
		'type' => 'select',
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			//'5' => esc_html__( 'Twelve columns', 'datebook' )
		));

	$options[] = array('type' => 'container_in');

	$options[] = array(
		'name' => esc_html__('Style of profile', 'datebook' ),
		'desc' => esc_html__('Profile can be displayed in different styles', 'datebook' ),
		'id' => 'top_profiles_style',
		'std' => '2',
		'type' => 'radio',
		'options' => array(
			'1' => '1. ' . esc_html__( 'Full content', 'datebook' ),
			'2' => '2. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'3' => '3. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'4' => '4. ' . esc_html__( 'Image displayed, content in popover', 'datebook' )
	));

	$options[] = array(
		'name' => esc_html__('Show the following details', 'datebook' ),
		'id' => 'show_top_profile_details',
		'std' => 'comments,images,travel,age,gender,sexorientation,city,country',
		'method' => 'multinumber',
		'type' => 'multicheck',
		"options" => $profile_details_args
	);

	$options[] = array(
		'name' => esc_html__('Roundness of images', 'datebook' ),
		'id' => 'top_round',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('No round', 'datebook' ),
			'2' => esc_html__('Rounded corners', 'datebook' ),
			'3' => esc_html__('Rounded circle', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Width of image border', 'datebook' ),
		'desc' => esc_html__('Width of image border can be 3 options: 1. enter random numbers separated by a comma. Example: 1,12 = borders will be random width from 1 to 12 pixels. 2. enter one number. Example: 5 = border for all images will be 5px. 3. enter 0 = no borders', 'datebook' ),
		'id' => 'top_border_width',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Border style', 'datebook' ),
		'id' => 'top_border_style',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__( 'Color of border', 'datebook' ),
		'id' => 'top_border_color',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Gamma of colors', 'datebook' ),
		'desc' => esc_html__('Remove Color of border (above) to enable this option', 'datebook' ),
		'id' => 'top_color_gamma',
		'std' => 'light',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('None', 'datebook' ),
			'random' => esc_html__('Random', 'datebook' ),
			'light' => esc_html__('Random Light', 'datebook' ),
			'dark' => esc_html__('Random Dark', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'top_shadow',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__('Margin', 'datebook' ),
		'desc' => 'rem',
		'id' => 'top_margin',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Padding', 'datebook' ),
		'desc' => 'rem',
		'id' => 'top_padding',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array('type' => 'container_out');

//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Favorites and Likes', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable Favorite profiles?', 'datebook' ),
		'id' => 'enable_favorite_profiles',
		'std' => '1,1,1',
		'method' => 'multinumber',
		'type' => 'multicheck',
		"options" => array(
			'1' => esc_html__( 'Yes', 'datebook' ),
			'2' => esc_html__( 'Show quantity of users who favorited Profile', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Favorites: style', 'datebook' ),
		'id' => 'favorites_style',
		'std' => '1',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => '1 ' . esc_html__('style', 'datebook' ),
			'2' => '2 ' . esc_html__('style', 'datebook' ),
			'3' => '3 ' . esc_html__('style', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Favorites: normal icon color', 'datebook' ),
		'id' => 'favorite_normal_icon_color',
		'std' => 'rgb(0, 152, 255)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Favorites: added icon color', 'datebook' ),
		'id' => 'favorite_added_icon_color',
		'std' => 'rgb(0, 228, 54)',
		'type' => 'transparentcolor'
	);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable Likes?', 'datebook' ),
		'id' => 'enable_like_profiles',
		'std' => '1,1,1',
		'method' => 'multinumber',
		'type' => 'multicheck',
		"options" => array(
			'1' => esc_html__( 'Yes', 'datebook' ),
			'2' => esc_html__( 'Show quantity of users who liked Profile', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Likes: style', 'datebook' ),
		'id' => 'like_style',
		'std' => '1',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => '1 ' . esc_html__('style', 'datebook' ),
			'2' => '2 ' . esc_html__('style', 'datebook' ),
			'3' => '3 ' . esc_html__('style', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Likes: normal icon color', 'datebook' ),
		'id' => 'like_normal_icon_color',
		'std' => 'rgb(0, 152, 255)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Likes: added icon color', 'datebook' ),
		'id' => 'like_added_icon_color',
		'std' => 'rgb(0, 228, 54)',
		'type' => 'transparentcolor'
	);


/////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Classifieds', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable Classifieds?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_classifieds',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Approve new classifieds automatically?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'approve_new_classifieds',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Approve edited classifieds automatically?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'approve_edited_classifieds',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Receive an email notification when a classified ad was added or edited?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Send an email to administrator each time user updates his/her Classified info. Notice: be careful, your server may get overloaded while sending emails.', 'datebook' ),
		'id' => 'receive_email_on_classified_update',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Classifieds permalink slug', 'datebook' ),
		'desc' => sprintf( esc_html__( 'The permalink slug used for single advertisement (by default it is set to "%1$s"). %2$s Please make sure you flush your rewrite rules after changing this setting. You can do so by navigating to %3$s and clicking "Save Changes".', 'datebook' ), 
		'classified',
		'<strong>Note:</strong>', 
		'<a href="' . get_admin_url(get_current_blog_id(), 'options-permalink.php') . '">Settings->Permalinks</a>'
		 ),
		'id' => 'classifieds_permalink_slug',
		'std' => 'classified',
		'class' => 'small',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Classified category permalink slug', 'datebook' ),
		'desc' => sprintf( esc_html__( 'The permalink slug used for classifieds categories (by default it is set to "%1$s"). %2$s Please make sure you flush your rewrite rules after changing this setting. You can do so by navigating to %3$s and clicking "Save Changes".', 'datebook' ), 
		DATEBOOK_CLASSIFIEDS_TAX,
		'<strong>Note:</strong>', 
		'<a href="' . get_admin_url(get_current_blog_id(), 'options-permalink.php') . '">Settings->Permalinks</a>'
		 ),
		'id' => 'classifieds_tax_permalink_slug',
		'std' => DATEBOOK_CLASSIFIEDS_TAX,
		'class' => 'small',
		'type' => 'text');
		
	$options[] = array(
		'name' => esc_html__('Classifieds per page', 'datebook' ),
		'desc' => esc_html__('Quantity of Classifieds to display on Classifieds page', 'datebook' ),
		'id' => 'classifieds_per_page',
		'std' => '40',
		'class' => 'mini',
		'type' => 'text');


/////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Tours', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable Tours?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_profile_tours',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Approve new tours automatically?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'approve_new_tours',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Approve edited tours automatically?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'approve_edited_tours',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Receive an email notification when a tour was added or edited?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Send an email to administrator each time user updates his/her Tour info. Notice: be careful, your server may get overloaded while sending emails.', 'datebook' ),
		'id' => 'receive_email_on_tour_update',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Tours permalink slug', 'datebook' ),
		'desc' => sprintf( esc_html__( 'The permalink slug used for single tour (by default it is set to "tour"). %1$s Please make sure you flush your rewrite rules after changing this setting. You can do so by navigating to %2$s and clicking "Save Changes".', 'datebook' ), 
		'<strong>Note:</strong>', 
		'<a href="' . get_admin_url(get_current_blog_id(), 'options-permalink.php') . '">Settings->Permalinks</a>'
		 ),
		'id' => 'tour_permalink_slug',
		'std' => 'tour',
		'class' => 'small',
		'type' => 'text');
		
	$options[] = array(
		'name' => esc_html__('Tours per page', 'datebook' ),
		'desc' => esc_html__('Quantity of tours to display on Tours page', 'datebook' ),
		'id' => 'tours_per_page',
		'std' => '40',
		'class' => 'mini',
		'type' => 'text');


/////////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Chat and Messages', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'How should users contact each other?', 'datebook' ),
		'desc' => esc_html__( 'Users can write messages directly to each other by the contact form or by chat form.', 'datebook' ),
		'id' => 'contact_method',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
		'1' => esc_html__( 'DateBook Chat form. All messages are saved on the website. Users have their correspondences on the website. Only notifications about new messages go to users\' emails. Therefore, they do not see email addresses of each other.', 'datebook' ),
		'2' => esc_html__( 'DateBook Direct contact form. No messages are saved on the website. All messages go directly to users\' emails. Therefore, they see email addresses of each other. And later they can have correspondences via their own emails.', 'datebook' ),
		'3' => esc_html__( 'Third party Chat. Messages are fully controlled by third party chat plugin. DateBook does not save and control messages.', 'datebook' )
	));

	$options[] = array(
		'name' => esc_html__('Chat placement', 'datebook' ),
		'id' => 'chat_placement',
		'std' => '1',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('Inside popup chat window', 'datebook' ),
			'2' => esc_html__('On profile page', 'datebook' ),
	));

	$options[] = array(
		'name' => esc_html__('Max. quantity of users to chat', 'datebook' ),
		'desc' => esc_html__('User can send messages (chat) to this quantity of other users at one period?', 'datebook' ) . ' (' . esc_html__('0 = unlimited', 'datebook' ) . ') ' . esc_html__('Note: this feature is used only if no subscription plan is set', 'datebook' ),
		'id' => 'simultaneous_chatters',
		'std' => '20',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Period of time for limited chat', 'datebook' ),
		'desc' => esc_html__('After this period of time user can send messages again to other quantity of users.', 'datebook' ) . ' ' . esc_html__('Note: this feature is used only if no subscription plan is set', 'datebook' ),
		'id' => 'period_for_chatters',
		'std' => '24',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $datebook_hourly_period);

	$options[] = array(
		'name' => esc_html__('Enable Emojis in the private chat window', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_emoji_in_private_chat',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Allow users upload images in the private chat', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_image_upload_in_private_chat',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Open a message in a new window', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('On Messages page, message will open in a new window when clicked on', 'datebook' ),
		'id' => 'open_message_new_window',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Open a profile in a new tab', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('On Messages page, profile will open in a new tab when clicked on', 'datebook' ),
		'id' => 'open_profile_new_tab',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Allow Administrator write messages in chat window', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Text field will be displayed in the chat window where administrator can write and send messages on behalf of users', 'datebook' ),
		'id' => 'allow_admin_write_inchat',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Update chat: check for new messages every', 'datebook' ),
		'desc' => esc_html__('seconds', 'datebook' ),
		'id' => 'chat_update_period',
		'std' => '5',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Check for new messages every', 'datebook' ),
		'desc' => esc_html__('Cron checks for new messages and sends a notification to a user by email. Note: notification is sent only once.', 'datebook' ),
		'id' => 'notification_about_new_message',
		'std' => '10',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $datebook_minutely_period);

	$options[] = array(
		'name' => esc_html__('Repeat notifications about new messages every', 'datebook' ),
		'desc' => esc_html__('day(s)', 'datebook' ) . ' ' . esc_html__('The notification will be sent again to the user if the user has not yet read the message.', 'datebook' ),
		'id' => 'repeat_notification_about_new_message',
		'std' => '1',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Add additional time after user logged out before sending notification', 'datebook' ),
		'desc' => esc_html__('second(s)', 'datebook' ) . ' ' . esc_html__('Sometimes users return to the site after a short time. In this case, the notification may be skipped.', 'datebook' ),
		'id' => 'add_time_before_notification',
		'std' => '600',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Show the name and message text of the sender in the notification', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'show_name_text_in_notification',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('How long to display a notification about a new message', 'datebook' ),
		'desc' => esc_html__('seconds', 'datebook' ) . '. ' . esc_html__('When a new message arrives a small popup will be displayed in the corner of window.', 'datebook' ) . ' ' . esc_html__('(0 = unlimited)', 'datebook' ),
		'id' => 'display_new_message_popup',
		'std' => '300',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Sound of popup notification', 'datebook' ),
		'id' => 'chat_ready_sound',
		'std' => '1',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'chat-01' => '1 sound',
			'chat-02' => '2 sound',
			'chat-03' => '3 sound',
			'chat-04' => '4 sound',	
	));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Show the following details in chat window and messages page', 'datebook' ),
		'id' => 'show_profile_details_on_messages',
		'std' => 'name,comments,images,travel,age,sexorientation,gender,city,country',
		'type' => 'multicheck',
		'options' => array(
			'name' => esc_html__( 'Name', 'datebook' ),
			'age' => esc_html__( 'Age', 'datebook' ),
			'gender' => esc_html__( 'Gender', 'datebook' ),
			'city' => esc_html__( 'City', 'datebook' ),
			'country' => esc_html__( 'Country', 'datebook' )
		)
	);

	$options[] = array(
		'name' => esc_html__( 'Show the following details in sidebar of chat window', 'datebook' ),
		'id' => 'show_profile_details_on_chat_sidebar',
		'std' => 'name,age,city',
		'type' => 'multicheck',
		'options' => array(
			'name' => esc_html__( 'Name', 'datebook' ),
			'age' => esc_html__( 'Age', 'datebook' ),
			'gender' => esc_html__( 'Gender', 'datebook' ),
			'city' => esc_html__( 'City', 'datebook' ),
			'country' => esc_html__( 'Country', 'datebook' )
		)
	);

	$options[] = array(
		'name' => esc_html__('Do not display the buttons on profile: Write a message, Favorite, Like, Add Friend', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('These buttons will not be visiable to owner of profile when he visits his profile.', 'datebook' ),
		'id' => 'hide_buttons_to_owner',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Third party chat', 'datebook' ),
		'desc' => esc_html__( 'How to control third party chat', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__( 'PHP/HTML/Shortcode code for chat', 'datebook' ),
		'desc' => esc_html__('If you select other chat than DateBook then you must paste shortcode of your chat.', 'datebook' ),
		'id' => 'chat_shortcode',
		'std' => '',
		'class' => 'small', //mini, tiny, small
		'type' => 'customcode');

	$options[] = array('type' => 'container_in');

	// Chat windows width
	$options[] = array(
		'name' => esc_html__('Chat window: width', 'datebook' ),
		'desc' => esc_html__('Enter width of chat window (numbers only)', 'datebook' ),
		'id' => 'chat_width',
		'std' => '780',
		'class' => 'mini',
		'type' => 'text');

	// Chat windows height
	$options[] = array(
		'name' => esc_html__('Chat window: height', 'datebook' ),
		'desc' => esc_html__('Enter height of chat window (numbers only)', 'datebook' ),
		'id' => 'chat_height',
		'std' => '520',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Mobile: list of users', 'datebook' ),
		'desc' => esc_html__('Select the layout how to display users', 'datebook' ),
		'id' => 'chat_sidebar_layout_mobile',
		'std' => 'top',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/logo-position-2.jpg",
			"sidebar" => DATEBOOK_URL . "framework/images/logo-position-1.jpg"

			)
		);

	$options[] = array(
		'name' => esc_html__( 'Chat sidebar: background color', 'datebook' ),
		'id' => 'chat_sidebar_bg_color',
		'std' => 'rgba(0,115,225,1)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'Chat sidebar: font', 'datebook' ),
		'id' => 'chat_sidebar_font',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	// Chat windows height
	$options[] = array(
		'name' => esc_html__('Chat text field: maximum width', 'datebook' ),
		'desc' => '%',
		'id' => 'chat_text_field_width',
		'std' => '80',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Chat text field: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'chat_text_border_round',
		'std' => '0.8',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__( 'Emoji icons', 'datebook' ),
		'desc' => $emoji_symbols,
		'type' => 'info'
	);

	$emoji_encoded_icons = base64_encode(json_encode($emoji_symbols));

	$options[] = array(
		'name' => esc_html__( 'Emoji icons', 'datebook' ),
		'desc' => esc_html__('Copy and paste any of emoji above here', 'datebook' ) . '. ' . esc_html__('You may paste your emoji from other sources', 'datebook' ) . '.',
		'id' => 'emoji_icons',
		'std' => $emoji_encoded_icons,
		'class' => 'small', //mini, tiny, small
		'type' => 'textarea_emoji');

	// Gradient color of popup new message
	$options[] = array(
		'name' => esc_html__( 'Popup notification: background color', 'datebook' ),
		'id' => 'popup_notification_bg_color',
		'std' => 'linear-gradient(to right bottom, rgb(23, 255, 61) 0%, rgb(255, 246, 18) 100%)',
		'type' => 'gradientcolor'
	);

	$options[] = array('type' => 'container_out');


/////////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Searching', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Allow searching for profiles?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('If No, then the search form will be hidden on the whole site.', 'datebook' ),
		'id' => 'search_allowed',
		'std' => '1',
		'type' => 'checkbox');	

	$options[] = array(
		'name' => esc_html__('Show all countries (even if they have no profiles)', 'datebook' ),
		'id' => 'search_show_empty_countries',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Number of profiles on the search page', 'datebook' ),
		'id' => 'profiles_per_page',
		'std' => '18',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Display the number of found profiles on the search page', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'display_number_of_profiles',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Display the following result if search result is empty', 'datebook' ),
		'desc' => esc_html__('Message text: No profiles found ', 'datebook' ),
		'id' => 'if_search_results_empty',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
		'1' => esc_html__( 'Message and other profiles', 'datebook' ),
		'2' => esc_html__( 'Message and no profiles', 'datebook' ),
		'3' => esc_html__( 'No message but other profiles', 'datebook' ),
		'4' => esc_html__( 'No message and no profiles', 'datebook' ),
	));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Smartphones: iPhones, Galaxy Phones, Google Pixel, HTC Phones, Windows Phone)', 'datebook' ),
		'desc' => esc_html__('Too small screen', 'datebook' ) . '. ' . esc_html__('Quantity of profiles shown in a row on Profiles Search page.', 'datebook' ),
		'id' => 'how_many_columns_on_search_mobile',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '1 ' . esc_html__( 'column', 'datebook' ),
			'2' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '6 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Mobile devices (Tablets: iPads, Galaxy Tablets, Nexus Tablets, Kindle Fire)', 'datebook' ),
		'desc' => esc_html__('Small screen', 'datebook' ) . '. ' . esc_html__('Quantity of profiles shown in a row on Profiles Search page.', 'datebook' ),
		'id' => 'how_many_columns_on_search_tablet',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			'5' => '12 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Normal screens (Desktops)', 'datebook' ),
		'desc' => esc_html__('Normal screen', 'datebook' ) . '. ' . esc_html__('Quantity of profiles shown in a row on Profiles Search page.', 'datebook' ),
		'id' => 'how_many_columns_on_search_normal',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('How many columns to show on Large screens (Widescreen desktop and Laptops)', 'datebook' ),
		'desc' => esc_html__('Large screen', 'datebook' ) . '. ' . esc_html__('Quantity of profiles shown in a row on Profiles Search page.', 'datebook' ),
		'id' => 'how_many_columns_on_search_large',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		"options" => array(
			'0' => esc_html__( 'do not display', 'datebook' ),
			'1' => '2 ' . esc_html__( 'columns', 'datebook' ),
			'2' => '3 ' . esc_html__( 'columns', 'datebook' ),
			'3' => '4 ' . esc_html__( 'columns', 'datebook' ),
			'4' => '6 ' . esc_html__( 'columns', 'datebook' ),
			//'5' => esc_html__( 'Twelve columns', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('New Profile label', 'datebook' ),
		'desc' => esc_html__('days', 'datebook' ) . '. ' . esc_html__('Quantity of days to display the NEW label over profile on the search page.', 'datebook' ),
		'id' => 'new_label_days',
		'std' => '7',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Enable Online indicator on profile', 'datebook' ),
		'desc' => esc_html__('Displays "Online" / "Last login" indicator on the search page.', 'datebook' ),
		'id' => 'online_indicator_search',
		'std' => '2',
		'type' => 'radio',
		'options' => array(
		'1' => esc_html__( 'Online only (no text)', 'datebook' ),
		'2' => esc_html__( 'Online only (with text)', 'datebook' ),
		'3' => esc_html__( 'Online and Last login (full text)', 'datebook' ),
		'4' => esc_html__( 'Online and Last login (date only)', 'datebook' ),
		'5' => esc_html__( 'No indicator', 'datebook' ),
	));

	$options[] = array(
		'name' => esc_html__('Kind of Online indicator', 'datebook' ),
		'desc' => esc_html__('Select how an indicator should look on the search page.', 'datebook' ),
		'id' => 'online_indicator_look',
		'std' => '4',
		'type' => 'radio',
		'options' => array(
		'1' => esc_html__( 'Round on top', 'datebook' ),
		'2' => esc_html__( 'Round at bottom', 'datebook' ),
		'3' => esc_html__( 'Square on top', 'datebook' ),
		'4' => esc_html__( 'Square at bottom', 'datebook' ),
	));

	$options[] = array(
		'name' => esc_html__('Disable looking for default image of profile in database', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Usually, default image of profile is set by user or the theme. But if it is not set then the theme searches for any image of profile and set it as default. You can disable this option and save some queries to database on every page.', 'datebook' ),
		'id' => 'search_default_thumbnail',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array('type' => 'container_in');

	$options[] = array(
		'name' => esc_html__('Search form', 'datebook' ),
		'type' => 'info');

	$options[] = array(
		'name' => esc_html__( 'Age range: layout', 'datebook' ),
		'desc' => esc_html__( 'For Ion.RangeSlider', 'datebook' ),
		'id' => 'age_range_layout',
		'std' => 'round',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'flat' => esc_html__('Flat', 'datebook'),
			'big' => esc_html__('Big', 'datebook'),
			'modern' => esc_html__('Modern', 'datebook'),
			'round' => esc_html__('Round', 'datebook'),
			'sharp' => esc_html__('Sharp', 'datebook'),
			'square' => esc_html__('Square', 'datebook')
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Layout', 'datebook' ),
		'id' => 'searchform_layout_front',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('Horizontal', 'datebook' ),
			'2' => esc_html__('Vertical', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Display advanced fields', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'show_advanced_search_fields_front',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'Display advanced fields as', 'datebook' ),
		'id' => 'advanced_search_popup_type_front',
		'std' => 'modal',
		'type' => 'radio',
		"options" => array(
			'modal' => esc_html__( 'Modal window', 'datebook' ),
			'collapse' => esc_html__( 'Collapse', 'datebook' )
			)
		);

	$options[] = array(
		'name' => esc_html__('Display header', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'display_header_search_form_front',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'Age range', 'datebook' ),
		'id' => 'age_range_front',
		'std' => 'ionrangeslider',
		'type' => 'radio',
		"options" => array(
			'ionrangeslider' => esc_html__( 'Ion.RangeSlider', 'datebook' ),
			'selector' => esc_html__( 'Dropdown selector', 'datebook' )
			)
		);

	$options[] = array(
		'name' => esc_html__('Max width', 'datebook' ),
		'desc' => 'enter number with px or %. Example: 50% or 700px',
		'id' => 'searchform_max_width',
		'std' => '350px',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Align', 'datebook' ),
		'id' => 'search_align_front',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('left', 'datebook' ),
			'center' => esc_html__('center', 'datebook' ),
			'right' => esc_html__('right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Background color', 'datebook' ),
		'id' => 'gradientcolor_searchform_front',
		'std' => 'linear-gradient(to top, rgba(1, 40, 119, 0.28) 0%, rgba(0, 43, 123, 0.28) 100%)',
		'type' => 'gradientcolor'
	);

	$options[] = array(
		'name' => esc_html__('Gender button: text color', 'datebook' ),
		'id' => 'searchform_gender_color_front',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Gender button: background color', 'datebook' ),
		'id' => 'searchform_gender_bgcolor_front',
		'std' => '#00c851',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Submit button: text color', 'datebook' ),
		'id' => 'searchform_submit_color_front',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Submit button: background color', 'datebook' ),
		'id' => 'searchform_submit_bgcolor_front',
		'std' => 'rgb(0, 152, 255)',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Width of borders', 'datebook' ),
		'desc' => 'px',
		'id' => 'searchform_border_width_front',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Style of borders', 'datebook' ),
		'id' => 'searchform_border_style_front',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__('Color of borders', 'datebook' ),
		'id' => 'searchform_border_color_front',
		'std' => '#9e9e9e',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'searchform_border_round_front',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Color of header text', 'datebook' ),
		'id' => 'searchform_header_text_color_front',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color of header', 'datebook' ),
		'id' => 'searchform_header_bg_color_front',
		'std' => '#f5f5f5',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Color of body text', 'datebook' ),
		'id' => 'searchform_text_color_front',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color of body', 'datebook' ),
		'id' => 'searchform_background_color_front',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'searchform_border_shadow_front',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__( 'Margin', 'datebook' ),
		'id' => 'searchform_margin_front',
		'std' => array_merge($margin_defaults, array('margin_top' => '','margin_right' => '','margin_bottom' => '40px','margin_left' => '' )),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Padding', 'datebook' ),
		'id' => 'searchform_padding_front',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Search page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Search page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Display advanced fields', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'show_advanced_search_fields_other',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'Display advanced fields as', 'datebook' ),
		'id' => 'advanced_search_popup_type_other',
		'std' => 'modal',
		'type' => 'radio',
		"options" => array(
			'modal' => esc_html__( 'Modal window', 'datebook' ),
			'collapse' => esc_html__( 'Collapse', 'datebook' )
			)
		);

	$options[] = array(
		'name' => esc_html__('Display header', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'display_header_search_form_other',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'Age range', 'datebook' ),
		'id' => 'age_range_other',
		'std' => 'ionrangeslider',
		'type' => 'radio',
		"options" => array(
			'ionrangeslider' => esc_html__( 'Ion.RangeSlider', 'datebook' ),
			'selector' => esc_html__( 'Dropdown selector', 'datebook' )
			)
		);

	$options[] = array(
		'name' => esc_html__('Gender button: text color', 'datebook' ),
		'id' => 'searchform_gender_color_other',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Gender button: background color', 'datebook' ),
		'id' => 'searchform_gender_bgcolor_other',
		'std' => '#33b5e5',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Submit button: text color', 'datebook' ),
		'id' => 'searchform_submit_color_other',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Submit button: background color', 'datebook' ),
		'id' => 'searchform_submit_bgcolor_other',
		'std' => '#0458db',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Width of borders', 'datebook' ),
		'desc' => 'px',
		'id' => 'searchform_border_width_other',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Style of borders', 'datebook' ),
		'id' => 'searchform_border_style_other',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__('Color of borders', 'datebook' ),
		'id' => 'searchform_border_color_other',
		'std' => '#9e9e9e',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'searchform_border_round_other',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Color of header text', 'datebook' ),
		'id' => 'searchform_header_text_color_other',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color of header', 'datebook' ),
		'id' => 'searchform_header_bg_color_other',
		'std' => '#f5f5f5',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Color of body text', 'datebook' ),
		'id' => 'searchform_text_color_other',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color of body', 'datebook' ),
		'id' => 'searchform_background_color_other',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'searchform_border_shadow_other',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__( 'Margin', 'datebook' ),
		'id' => 'searchform_margin_other',
		'std' => array_merge($margin_defaults, array('margin_top' => '','margin_right' => '','margin_bottom' => '15px','margin_left' => '' )),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Padding', 'datebook' ),
		'id' => 'searchform_padding_other',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);

	$options[] = array('type' => 'container_out');


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Profiles on Search', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Style of profile', 'datebook' ),
		'desc' => esc_html__('Profiles can be displayed in different styles.', 'datebook' ),
		'id' => 'style_profile_on_search',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
			'1' => esc_html__( 'Style 1 - full content', 'datebook' ),
			'2' => esc_html__( 'Style 2 - image displayed, content hidden', 'datebook' ),
			'3' => esc_html__( 'Style 3 - image displayed, content hidden', 'datebook' )
	));

	$options[] = array(
		'name' => esc_html__('Show the following details', 'datebook' ),
		'id' => 'show_profile_details_on_search',
		'std' => 'comments,images,travel,age,gender,sexorientation,city,country',
		'method' => 'multinumber',
		'type' => 'multicheck',
		"options" => $profile_details_args
	);

	$options[] = array(
		'name' => esc_html__('Display only profiles with images', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Notice: Top profiles without images will be displayed anyway. They specially got Top status to be displayed on top position.', 'datebook' ),
		'id' => 'display_only_profiles_with_images_on_search',
		'std' => '0',
		'type' => 'checkbox');


	$options[] = array('type' => 'container_in');

	$options[] = array(
		'name' => esc_html__('Enable custom styling of profiles on Search page?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_profiles_on_search',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Profile: width of borders', 'datebook' ),
		'desc' => 'px',
		'id' => 'profiles_on_search_border_width',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Profile: style of borders', 'datebook' ),
		'id' => 'profiles_on_search_border_style',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__('Profile: color of borders', 'datebook' ),
		'id' => 'profiles_on_search_border_color',
		'std' => '#9e9e9e',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Profile: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'profiles_on_search_border_round',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Profile: align of text', 'datebook' ),
		'id' => 'profiles_on_search_text_align',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('Default', 'datebook' ),
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' ),
			'justify' => esc_html__('Justify', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Profile: text color of name', 'datebook' ),
		'id' => 'profiles_on_search_header_text_color',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Profile: text color of other info', 'datebook' ),
		'id' => 'profiles_on_search_text_color',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Profile: background color of body', 'datebook' ),
		'id' => 'profiles_on_search_background_color',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Profile: shadow', 'datebook' ),
		'id' => 'profiles_on_search_border_shadow',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__( 'Profile: margin', 'datebook' ),
		'id' => 'profiles_on_search_margin',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Profile: padding', 'datebook' ),
		'id' => 'profiles_on_search_padding',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);

	$options[] = array('type' => 'container_out');


//////////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Images', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable Watermark', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Watermark will be added to user\'s profile images', 'datebook' ),
		'id' => 'enable_watermark',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Watermark image', 'datebook'),
		'desc' => esc_html__('Enter the ID of an image that will be applied to profile images. You can find the ID on the Media page.', 'datebook'),
		'id' => 'watermark_image_upload',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__( 'Watermark alignment', 'datebook' ),
		'id' => 'watermark_alignment',
		'std' => 'bottom_left',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		"options" => array(
			'top_left' => esc_html__( 'Top Left', 'datebook' ),
			'top_center' => esc_html__( 'Top Center', 'datebook' ),
			'top_right' => esc_html__( 'Top Right', 'datebook' ),
			'middle_left' => esc_html__( 'Middle Left', 'datebook' ),
			'middle_center' => esc_html__( 'Middle Center', 'datebook' ),
			'middle_right' => esc_html__( 'Middle Right', 'datebook' ),
			'bottom_left' => esc_html__( 'Bottom Left', 'datebook' ),
			'bottom_center' => esc_html__( 'Bottom Center', 'datebook' ),
			'bottom_right' => esc_html__( 'Bottom Right', 'datebook' ),
			)
		);

	$options[] = array(
		'name' => esc_html__('Watermark offset: horizontal', 'datebook' ),
		'desc' => esc_html__('margin from left / right side of image', 'datebook' ),
		'id' => 'watermark_offset_x',
		'std' => '10',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Watermark offset: vertical', 'datebook' ),
		'desc' => esc_html__('margin from top / bottom side of image', 'datebook' ),
		'id' => 'watermark_offset_y',
		'std' => '10',
		'class' => 'mini',
		'type' => 'text');


	$options[] = array(
		'name' => esc_html__( 'Offset unit', 'datebook' ),
		'id' => 'watermark_offset_unit',
		'std' => 'pixels',
		'type' => 'radio',
		"options" => array(
			'pixels' => esc_html__( 'pixels', 'datebook' ),
			'percentages' => esc_html__( 'percentages', 'datebook' )
			)
		);

	$options[] = array(
		'name' => esc_html__('Watermark scale', 'datebook' ),
		'desc' => esc_html__('percent', 'datebook' ) . '. ' . esc_html__('Enter a number ranging from 0 to 100. 100 makes width of watermark image equal to width of the image it is applied to', 'datebook' ),
		'id' => 'watermark_scale',
		'std' => '50',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__( 'What kind of Lightbox to use for Profile images', 'datebook' ),
		'id' => 'kind_of_lightbox',
		'std' => 'blueimp',
		'type' => 'radio',
		"options" => array(
			'blueimp' => esc_html__( 'blueimp Gallery', 'datebook' ),
			'lightbox' => esc_html__( 'Simple Lightbox', 'datebook' )
			)
		);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Blur: add blur effect to Profile images', 'datebook' ),
		'desc' => esc_html__('Blur effect added only if user restricts access to his images on the Privacy page of his account', 'datebook' ),
		'id' => 'blur_variant',
		'std' => '2',
		'type' => 'radio',
		"options" => array(
			'0' => esc_html__('No blur (Avatar)', 'datebook'),
			'1' => esc_html__('Blur (ImageMagick)', 'datebook'),
			'2' => esc_html__('Blur (GD)', 'datebook'),
			'3' => esc_html__('Pixelate (GD)', 'datebook')
			)
		);

	$options[] = array(
		'name' => esc_html__('Blur: level', 'datebook' ),
		'desc' => esc_html__('The more level the stronger blur. From 1 to 50', 'datebook' ),
		'id' => 'blur_level',
		'std' => '20',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable Retina images?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Retina is an image that has a double size. If Retina is enabled, users will be forced to upload images with double minimum sizes. (For example: If the minimum image size is width 339px and height 362px. Retina minimum dimensions will be width 678px and height 724px)', 'datebook' ),
		'id' => 'enable_retina_images',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Profile image sizes', 'datebook' ),
		'desc' => esc_html__('Enter width and height of image (numbers only) separated by comma', 'datebook' ) . ' (' . esc_html__('Example', 'datebook' ) . ': 120,80 ' . esc_html__('means', 'datebook' ) . ': ' . esc_html__('width', 'datebook' ) . ': 120 pixels; ' . esc_html__('height', 'datebook' ) . ': 80 pixels;)',
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Enable custom image dimensions?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_custom_images',
		'std' => '0',
		'type' => 'checkbox');

	// Image windows width and height
	$options[] = array(
		'name' => esc_html__('Single Profile', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 258,348',
		'id' => 'image_profile',
		'std' => '258,348',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Profile big', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 800,600',
		'id' => 'image_big',
		'std' => '800,600',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Photos in gallery', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 112,112',
		'id' => 'image_gallery',
		'std' => '112,112',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Profile: user menu', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 44,44',
		'id' => 'image_profile_user_menu',
		'std' => '44,44',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Notifications page', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 44,44',
		'id' => 'image_notifications',
		'std' => '44,44',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Photos upload page', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 138,138',
		'id' => 'image_photos_upload_form',
		'std' => '138,138',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Chat: profile in main window', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 44,44',
		'id' => 'image_profile_chat_main',
		'std' => '44,44',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Chat: profiles in sidebar', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 44,44',
		'id' => 'image_profile_chat_sidebar',
		'std' => '44,44',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Pop up notification about new message', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 44,44',
		'id' => 'image_popup_notification',
		'std' => '44,44',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Avatar', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 57,57',
		'id' => 'image_avatar',
		'std' => '57,57',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Featured: front page', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 85,85',
		'id' => 'image_feature_front',
		'std' => '85,85',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Featured: other pages', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 85,85',
		'id' => 'image_feature_other',
		'std' => '85,85',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Featured: sidebar', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 321,265',
		'id' => 'image_feature_single_sidebar',
		'std' => '312,265',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Top: front page', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 178,140',
		'id' => 'image_top_front',
		'std' => '178,140',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Normal small: front page', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 85,85',
		'id' => 'image_front_small',
		'std' => '85,85',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Normal medium: front page', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 178,178',
		'id' => 'image_front_medium',
		'std' => '178,178',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Normal in search results', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 264,193',
		'id' => 'image_search',
		'std' => '264,193',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Related profiles by city: sidebar', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 60,60',
		'id' => 'image_related_profiles_by_city_sidebar',
		'std' => '60,60',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Related profiles by country: sidebar', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 138,138',
		'id' => 'image_related_profiles_by_country_sidebar',
		'std' => '138,138',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Latest profiles: sidebar', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 57,57',
		'id' => 'image_latest_profiles_sidebar',
		'std' => '57,57',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Latest profiles (images only): sidebar', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 78,78',
		'id' => 'image_latest_profiles_images_sidebar',
		'std' => '78,78',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Classifieds: classifieds page', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 57,57',
		'id' => 'image_classifieds_other_page',
		'std' => '57,57',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Classifieds: sidebar', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 57,57',
		'id' => 'image_classifieds_sidebar',
		'std' => '57,57',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Tours: sidebar', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 44,44',
		'id' => 'image_tours_sidebar',
		'std' => '44,44',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Comments: sidebar', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 44,44',
		'id' => 'image_comments_sidebar',
		'std' => '44,44',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Friends: profile page', 'datebook' ),
		'desc' => esc_html__('Default', 'datebook' ) . ': 173,173',
		'id' => 'image_friend_request',
		'std' => '173,173',
		'class' => 'mini',
		'type' => 'text');


//////////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Gender and Sex', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Genders', 'datebook' ),
		'desc' => esc_html__( 'Select genders which will be available for registration and the whole website.', 'datebook' ),
		'id' => 'gender_allowed',
		'std' => '1,1,1',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $sex_titles_array);

	foreach ( $languages_active_array as $language_key => $language_name ) {

		$options[] = array(
			'name' => sprintf( esc_html__( 'Other types of genders (%1$s)', 'datebook' ), $language_name ),
			'desc' => esc_html__('Enter items as many as you wish. After each item press ENTER.', 'datebook' ),
			'id' => 'gender_allowed_other_' . $language_key,
			'std' => '',
			'class' => 'small', //mini, tiny, small
			'type' => 'textarea');

	}

	$options[] = array(
		'name' => esc_html__('Sexual orientations', 'datebook' ),
		'desc' => esc_html__( 'Select orientations which will be available for registration and the whole website. Note: some titles (like Transexual, Transgender, Transvestite, Ladyboy, Shemale, Tranny) can be considered as both gender and sexual orientation. To avoid confusion, they have been placed in Genders and Sexual orientations. It is up to you, where you select them!', 'datebook' ),
		'id' => 'sexual_orientation_allowed',
		'std' => '1,1,1,1',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $sexualorientation_titles_array);

	foreach ( $languages_active_array as $language_key => $language_name ) {

		$options[] = array(
			'name' => sprintf( esc_html__( 'Other types of sexual orientations (%1$s)', 'datebook' ), $language_name ),
			'desc' => esc_html__('Enter items as many as you wish. After each item press ENTER.', 'datebook' ),
			'id' => 'sexual_orientation_allowed_other_' . $language_key,
			'std' => '',
			'class' => 'small', //mini, tiny, small
			'type' => 'textarea');

	}

//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Privacy', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Allow users to choose who can see their profiles', 'datebook' ),
		'desc' => esc_html__( 'Select the options that will be available for selection on the Privacy page of his account.', 'datebook' ),
		'id' => 'allow_choose_who_can_see_profile',
		'std' => 'everyone,noone,friends,loggedinusers,subscribedusers',
		'type' => 'multicheck',
		'options' => $datebook_who_can_see_titles_array);

	$options[] = array(
		'name' => esc_html__('Allow users to choose who can see their images', 'datebook' ),
		'desc' => esc_html__( 'Select the options that will be available for selection on the Privacy page of his account.', 'datebook' ),
		'id' => 'allow_choose_who_can_see_images',
		'std' => 'everyone,noone,friends,loggedinusers,subscribedusers',
		'type' => 'multicheck',
		'options' => $datebook_who_can_see_titles_array);

	$options[] = array(
		'name' => esc_html__('Allow users to deactivate their profiles', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'allow_deactivate_account',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Receive an email notification when someone deactivates his profile', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'email_when_profile_deactivated_by_user',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Allow users to delete their accounts', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'allow_delete_account',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Receive an email notification when someone deletes his profile', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'email_when_profile_deleted_by_user',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Days before the final deletion of profile', 'datebook' ),
		'desc' => esc_html__('day(s)', 'datebook' ) . '. ' . esc_html__('The profile will be deleted permanently after this number of days. (0 = immediately)', 'datebook' ),
		'id' => 'delete_profile_days',
		'std' => '90',
		'class' => 'mini',
		'type' => 'text');


//////////////////////////////////////////////////////////////////

	$options[] = array(
		'name' => esc_html__('Login and Register', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable Registration?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_profile_registration',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'User must register with', 'datebook' ),
		'desc' => esc_html__('The following fields will be shown in the registration form.', 'datebook' ),
		'id' => 'registration_method',
		'std' => '1',
		'type' => 'radio',
		"options" => array(
			'1' => esc_html__( 'Email and Username', 'datebook' ),
			'2' => esc_html__( 'Email only', 'datebook' ))
		);
	
	$options[] = array(
		'name' => esc_html__('Allow user login with', 'datebook' ),
		'desc' => esc_html__('This option depends on option above &#8220;User must register with&#8221;. If Username is not set in section above then user will login with email only.', 'datebook' ),
		'id' => 'login_method',
		'std' => '1',
		'type' => 'radio',
		"options" => array(
			'1' => esc_html__( 'Email or Username', 'datebook' ),
			'2' => esc_html__( 'Email only', 'datebook' ),
			'3' => esc_html__( 'Username only', 'datebook' ))
		);

	$options[] = array(
		'name' => esc_html__('Users specify password', 'datebook' ),
		'desc' => esc_html__('Let users specify their password when registering. Otherwise, password will be generated automatically and sent to user by email.', 'datebook' ),
		'id' => 'let_users_set_pass',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'Profile types', 'datebook' ),
		'desc' => esc_html__('If profile types have been created, then they can be displayed as separate fields before the registration form or directly in the registration form.', 'datebook' ),
		'id' => 'profiletype_order_in_registration',
		'std' => 'profiletype_before_registration',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		"options" => array(
			'profiletype_before_registration' => esc_html__( 'displayed before the registration form', 'datebook' ),
			'profiletype_in_registration' => esc_html__( 'displayed in the registration form', 'datebook' ),
			)
		);

	$options[] = array(
		'name' => esc_html__('Registration age: minimum', 'datebook' ),
		'desc' => esc_html__('years old. The minimum age for registration, displayed on the registration page. (18 = by default if not set)', 'datebook' ),
		'id' => 'register_age_min',
		'std' => '18',
		'type' => 'text',
		'class' => 'mini'); //mini, tiny, small

	$options[] = array(
		'name' => esc_html__('Registration age: maximum', 'datebook' ),
		'desc' => esc_html__('years old. The maximum age for registration, displayed on the registration page. (80 = by default if not set)', 'datebook' ),
		'id' => 'register_age_max',
		'std' => '80',
		'type' => 'text',
		'class' => 'mini'); //mini, tiny, small

	$options[] = array(
		'name' => esc_html__('Username: minimum', 'datebook' ),
		'desc' => esc_html__('characters. The minimum characters must be used for username. (4 = by default if not set)', 'datebook' ),
		'id' => 'min_characters_username',
		'std' => '8',
		'type' => 'text',
		'class' => 'mini'); //mini, tiny, small

	$options[] = array(
		'name' => esc_html__('Username: maximum', 'datebook' ),
		'desc' => esc_html__('characters. The maximum characters must be used for username. (30 = by default if not set)', 'datebook' ),
		'id' => 'max_characters_username',
		'std' => '30',
		'type' => 'text',
		'class' => 'mini'); //mini, tiny, small

	$options[] = array(
		'name' => esc_html__('Password: minimum', 'datebook' ),
		'desc' => esc_html__('characters. The minimum characters must be used for password. (4 = by default if not set)', 'datebook' ),
		'id' => 'min_characters_password',
		'std' => '8',
		'type' => 'text',
		'class' => 'mini'); //mini, tiny, small

	$options[] = array(
		'name' => esc_html__('Password: maximum', 'datebook' ),
		'desc' => esc_html__('characters. The maximum characters must be used for password. (50 = by default if not set)', 'datebook' ),
		'id' => 'max_characters_password',
		'std' => '50',
		'type' => 'text',
		'class' => 'mini'); //mini, tiny, small

	$options[] = array(
		'name' => esc_html__('Login timeout', 'datebook' ),
		'desc' => esc_html__('Days. Set how many days user stays logged in on the website. (By default, the cookie without remembering is kept for two days. When Remember me is set, the cookies will be kept for 14 days or two weeks.)', 'datebook' ),
		'id' => 'login_timeout',
		'std' => '90',
		'type' => 'text',
		'class' => 'mini'); //mini, tiny, small

	$options[] = array(
		'name' => esc_html__('Period of Online status', 'datebook' ),
		'desc' => esc_html__('How many seconds of idle time are allowed before Online indicator switches off?', 'datebook' ),
		'id' => 'check_online_status',
		'std' => '120',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Idle time of user inactivity', 'datebook' ),
		'desc' => esc_html__('minutes. Log user out after some time of inactivity (0 = unlimited)', 'datebook' ),
		'id' => 'logout_idle_user',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Non-registered users may not', 'datebook' ),
		'desc' => esc_html__('You can set some limitations for users who are not registered', 'datebook' ),
		'id' => 'allow_notregistered_users',
		'std' => '',
		'type' => 'multicheck',
		'options' => array(
			'1' => esc_html__( 'search for profiles', 'datebook' ),
			'2' => esc_html__( 'view profile pages', 'datebook' ),
			//'3' => esc_html__( 'contact other users', 'datebook' ),
			//'4' => esc_html__( 'chat with other users', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Show Register and Login links', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Register and Login links will be displayed in the header and footer.', 'datebook' ),
		'id' => 'enable_register_login',
		'std' => '1',
		'type' => 'checkbox');


	if( ini_get('allow_url_fopen') ) {
		$datebook_allow_url_fopen = '';
	} else if(in_array ('curl', get_loaded_extensions()) || function_exists('curl_init') !== false) {
		$datebook_allow_url_fopen = '';
	} else {
		$datebook_allow_url_fopen = '!!! ' . esc_html__( 'ALLOW_URL_FOPEN IS DISABLED ON YOUR SERVER. GOOGLE RECAPTCHA MAY NOT WORK', 'datebook' ) . '!!! ';
	}

	$options[] = array(
		'name' => esc_html__('Enable Google reCaptcha in', 'datebook' ),
		'desc' => $datebook_allow_url_fopen . esc_html__('You need to go to Google reCAPTCHA panel (https://www.google.com/recaptcha). Click on the plus "Create" button on the top. Fill in all the fields. Select the type of reCAPTCHA you want to use. reCAPTCHA v2 has proven to be more successful and accepted by the developer community.', 'datebook' ),
		'id' => 'google_recaptcha',
		'std' => '',
		'type' => 'multicheck',
		'options' => array(
			'1' => esc_html__( 'Login form', 'datebook' ),
			'2' => esc_html__( 'Registration form', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Site key of Google reCaptcha', 'datebook' ),
		'desc' => esc_html__('This site key is used in the HTML code of the login and registration forms', 'datebook' ),
		'id' => 'google_recaptcha_sitekey',
		'std' => '',
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Secret key of Google reCaptcha', 'datebook' ),
		'desc' => esc_html__('This secret key for communication between your site and reCAPTCHA', 'datebook' ),
		'id' => 'google_recaptcha_secretkey',
		'std' => '',
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Hide the WordPress Admin Login Page', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Access to http://www.yourwebsite.com/wp-admin and http://www.yourwebsite.com/wp-login.php will be forbidden. User will be redirected to custom Login page.', 'datebook' ),
		'id' => 'override_wp_login',
		'std' => '1',
		'type' => 'checkbox');


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Payment', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Default payment gateway', 'datebook' ),
		'desc' => esc_html__('Default gateway will be open on the Subscription page', 'datebook' ),
		'id' => 'default_gateway',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('Select', 'datebook' ),
			'paypal_standard' => esc_html__('PayPal', 'datebook' ),
			'paystack' => esc_html__('Paystack', 'datebook' ),
			'bank' => esc_html__('Bank', 'datebook' )
	));

	$options[] = array(
		'name' => esc_html__('Default currency', 'datebook' ),
		'desc' => esc_html__('Select website default currency.', 'datebook' ),
		'id' => 'default_currency',
		'std' => '1',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $currency_array);

	$options[] = array(
		'name' => esc_html__('Price Format', 'datebook' ),
		'desc' => esc_html__('Number of decimal places to show for prices', 'datebook' ),
		'id' => 'price_format',
		'std' => '0',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'0' => esc_html__('$2 000 (Space)', 'datebook' ),
			'1' => esc_html__('$2 000.0 (Space)', 'datebook' ),
			'2' => esc_html__('$2 000.00 (Space)', 'datebook' ),
			'3' => esc_html__('$2 000.000 (Space)', 'datebook' ),
			'4' => esc_html__('$2,000 (Comma)', 'datebook' ),
			'5' => esc_html__('$2,000.0 (Comma)', 'datebook' ),
			'6' => esc_html__('$2,000.00 (Comma)', 'datebook' ),
			'7' => esc_html__('$2,000.000 (Comma)', 'datebook' ),
			'8' => esc_html__('$2.000 (Dot)', 'datebook' ),
			'9' => esc_html__('$2.000.0 (Dot)', 'datebook' ),
			'10' => esc_html__('$2.000.00 (Dot)', 'datebook' ),
			'11' => esc_html__('$2.000.000 (Dot)', 'datebook' ),
	));

	$options[] = array(
		'name' => esc_html__('Currency symbol, code and title places', 'datebook' ),
		'desc' => esc_html__('If currency sign do not exists for some country then it will not be shown', 'datebook' ),
		'id' => 'currency_sign_places',
		'std' => '1',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'0' => esc_html__('$200', 'datebook' ),
			'1' => esc_html__('$200 USD', 'datebook' ),
			'2' => esc_html__('$200 dollars', 'datebook' ),
			'3' => esc_html__('$ 200', 'datebook' ),
			'4' => esc_html__('$ 200 USD', 'datebook' ),
			'5' => esc_html__('$ 200 dollars', 'datebook' ),
			'6' => esc_html__('200$', 'datebook' ),
			'7' => esc_html__('200$ USD', 'datebook' ),
			'8' => esc_html__('200$ dollars', 'datebook' ),
			'9' => esc_html__('200 $', 'datebook' ),
			'10' => esc_html__('200 $ USD', 'datebook' ),
			'11' => esc_html__('200 $ dollars', 'datebook' ),
			'12' => esc_html__('200 USD', 'datebook' ),
			'13' => esc_html__('200 dollars', 'datebook' ),
			'14' => esc_html__('USD 200', 'datebook' ),
			'15' => esc_html__('USD $200', 'datebook' ),
			'16' => esc_html__('USD $ 200', 'datebook' ),
			'17' => esc_html__('USD 200$', 'datebook' ),
			'18' => esc_html__('USD 200 $', 'datebook' ),
			'19' => esc_html__('Dollars 200', 'datebook' ),
			'20' => esc_html__('Dollars $200', 'datebook' ),
			'21' => esc_html__('Dollars $ 200', 'datebook' ),
			'22' => esc_html__('Dollars 200$', 'datebook' ),
			'23' => esc_html__('Dollars 200 $', 'datebook' ),
	));

	$options[] = array(
		'name' => esc_html__('Show a tooltip with the name of the currency', 'datebook' ),
		'desc' => esc_html__('Tooltip next to the price will be displayed with a description of the currency used (Example: $200 (tooltip: United States dollar))', 'datebook' ),
		'id' => 'tooltip_currency_title',
		'std' => '0',
		'type' => 'checkbox'
	);
		

//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Subscription', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'How Subscription works', 'datebook' ),
		'desc' => esc_html__( 'When users register on the website: 1. they must select a subscription plan only if it is created and at least one payment gateway is activated. Only after this the user\'s profile will be published. 2. User\'s profile will be published if no subscription plan is created and none of payment gateways is activated.', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__( 'Registration and Subscription order', 'datebook' ),
		'id' => 'register_subscribe_order',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
		'1' => esc_html__( 'Registration + Subscription. Users must first register, and then after logging into their account, they must select a subscription plan.', 'datebook' ),
		'2' => esc_html__( 'Subscription + Registration. Users must first select a subscription plan and then register', 'datebook' ))
	);

	$options[] = array(
		'name' => esc_html__( 'What kind of Subscription to use?', 'datebook' ),
		'id' => 'activate_woocommerce_subscription',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
		'1' => 'DateBook. '. esc_html__( 'DateBook will use its own pages and functions to display subscription plans, checkout, orders, and process to payment gateways.', 'datebook' ),
		'2' => 'WooCommerce. '. esc_html__( 'WooCommerce pages and functions will be used to display subscription plans, checkout, orders, and process to payment gateways.', 'datebook' )
		)
	);

	$options[] = array(
		'name' => esc_html__( 'Force redirect to Subscription page', 'datebook' ),
		'desc' => esc_html__( 'Yes', 'datebook' ) . '. ' . esc_html__( 'If a user did not select a subscription plan, force redirect him to the Subscription page.', 'datebook' ),
		'id' => 'force_redirect_to_subscription_page',
		'std' => '0',
		'type' => 'checkbox'
	);

	$options[] = array(
		'name' => esc_html__('Non-subscribed users may not', 'datebook' ),
		'desc' => esc_html__('You can set some limitations for users who have not selected some subscription plan. Note: this option works if at least one payment gateway and subscription plan are enabled', 'datebook' ),
		'id' => 'allow_notsubscribed_users',
		'std' => '',
		'type' => 'multicheck',
		'options' => array(
			'1' => esc_html__( 'search for profiles', 'datebook' ),
			'2' => esc_html__( 'view profile pages', 'datebook' ),
			'3' => esc_html__( 'chat with other users', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Subscription is free for the following genders', 'datebook' ),
		'desc' => esc_html__( 'Select genders who must not pay for a subscription. Thus, absolutely all features will be available for free and all subscription plans become invisible for the selected genders.', 'datebook' ),
		'id' => 'free_for_genders',
		'std' => '',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $sex_titles_added_array);

	$options[] = array(
		'name' => esc_html__( 'Allow users to switch to a different subscription plan', 'datebook' ),
		'desc' => esc_html__( 'Yes', 'datebook' ) . ' ' . esc_html__( 'After selecting a subscription plan, user may select another plan again. But his current plan becomes canceled.', 'datebook' ),
		'id' => 'allow_change_subscription',
		'std' => '0',
		'type' => 'checkbox'
	);

	$options[] = array(
		'name' => esc_html__('After subscribing to a different plan keep period of existing', 'datebook' ),
		'desc' => esc_html__('When a user changes a subscription plan the period of existing Top/Featured statuses can be kept. For example: if a profile has the Top status of 3 days then after changing to another subscription plan the Top status (4 days) of another plan will be added to the current status. Total: 3 days of current plan + 4 days of another plan = 7 days', 'datebook' ),
		'id' => 'keep_top_featured_periods',
		'std' => '',
		'type' => 'multicheck',
		'options' => array(
			'1' => esc_html__( 'Top status', 'datebook' ),
			'2' => esc_html__( 'Featured status', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Receive an email notification when someone makes a payment?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'email_when_payment',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'Deactivate a profile after a subscription expires', 'datebook' ),
		'desc' => esc_html__( 'Yes', 'datebook' ) . '. ' . esc_html__( 'Profile will be unpublished (inactive) after its subscription expires and will not be displayed on the website', 'datebook' ),
		'id' => 'deactivate_profile_after_subscription_expires',
		'std' => '0',
		'type' => 'checkbox'
	);

	$options[] = array(
		'name' => esc_html__('How many days is a notification of a new unpaid order displayed', 'datebook' ),
		'desc' => esc_html__('day(s)', 'datebook' ) . '. ' . esc_html__('When a user selects a subscription plan but does not pay for it, a notification of an unpaid order is displayed in the subscription panel.', 'datebook' ),
		'id' => 'days_notification_of_unpaid_order',
		'std' => '3',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Check for expired subscriptions, Top and Featured statuses every', 'datebook' ),
		'desc' => esc_html__( 'If a subscription has expired, its status becomes pending. User with a pending subscription becomes suspended and therefore must select a subscription plan again.', 'datebook' ),
		'id' => 'cron_subscriptions_check',
		'std' => '720',
		'type' => 'select',
		'options' => array(
			'0' => esc_html__('No checking', 'datebook' ),
			'5' => '5 ' . esc_html__('minutes', 'datebook' ),
			'10' => '10 ' . esc_html__('minutes', 'datebook' ),
			'15' => '15 ' . esc_html__('minutes', 'datebook' ),
			'25' => '25 ' . esc_html__('minutes', 'datebook' ),
			'30' => '30 ' . esc_html__('minutes', 'datebook' ),
			'35' => '35 ' . esc_html__('minutes', 'datebook' ),
			'40' => '40 ' . esc_html__('minutes', 'datebook' ),
			'45' => '45 ' . esc_html__('minutes', 'datebook' ),
			'50' => '50 ' . esc_html__('minutes', 'datebook' ),
			'55' => '55 ' . esc_html__('minutes', 'datebook' ),
			'60' => '1 ' . esc_html__('hour', 'datebook' ),
			'180' => '3 ' . esc_html__('hours', 'datebook' ),
			'360' => '6 ' . esc_html__('hours', 'datebook' ),
			'540' => '9 ' . esc_html__('hours', 'datebook' ),
			'720' => '12 ' . esc_html__('hours', 'datebook' ),
			'1080' => '18 ' . esc_html__('hours', 'datebook' ),
			'1440' => '24 ' . esc_html__('hours', 'datebook' ),
			'2880' => '48 ' . esc_html__('hours', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Send notification of the expiration of the Top and Featured statuses', 'datebook' ),
		'desc' => esc_html__('day(s)', 'datebook' ) . ' '. esc_html__('in advance', 'datebook' ) . '. '. esc_html__('Users will receive an email with a notification that the Top or Featured status of their profile will soon expire', 'datebook' ) . '. (' . esc_html__('0 = do not send', 'datebook' ) . ')',
		'id' => 'send_expire_notification',
		'std' => '2',
		'class' => 'mini',
		'type' => 'text');
		
	$options[] = array(
		'name' => esc_html__('Background image in Top position panel under search form', 'datebook'),
		'desc' => esc_html__('Upload an image that will be placed as background in the panel suggesting Top position on the Search page.', 'datebook'),
		'id' => 'bg_topsuggest_image',
		'std' => DATEBOOK_URL . 'assets/images/search-top-offer.jpg',
		'type' => 'upload');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'WooCommerce', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__( 'Billing fields shown on the Checkout page', 'datebook' ),
		'desc' => esc_html__( 'Select any field to show on the Checkout page. In most cases, your members do not need to enter their billing information, such as: address, name, country, code, company, phone. Therefore, it is recommended to disable them. But at any time, you or other third-party plugins need billing information, you can enable these fields.', 'datebook' ),
		'id' => 'woocommerce_billing_fields',
		'std' => '',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => array(
			'billing_first_name' => esc_html__('First name', 'datebook' ),
			'billing_last_name' => esc_html__('Last name', 'datebook' ),
			'billing_city' => esc_html__('City', 'datebook' ),
			'billing_country' => esc_html__('Country', 'datebook' ),
			'billing_company' => esc_html__('Company', 'datebook' ),
			'billing_address' => esc_html__('Address', 'datebook' ),
			'billing_state' => esc_html__('State', 'datebook' ),
			'billing_postcode' => esc_html__('Post code', 'datebook' ),
			'billing_email' => esc_html__('Email', 'datebook' ),
			'billing_phone' => esc_html__('Phone', 'datebook' ),
		));


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Matching', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable profiles matching?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_profile_matching',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'Where to display the matching panel', 'datebook' ),
		'id' => 'display_matching_place',
		'std' => '3',
		'type' => 'radio',
		'options' => array(
		'1' => esc_html__( 'Above a profile', 'datebook' ),
		'2' => esc_html__( 'Inside a profile', 'datebook' ),
		'3' => esc_html__( 'Under a profile', 'datebook' )
	));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Split the matching progress bar on levels', 'datebook' ),
		'id' => 'split_progress_on_levels',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
		'0' => esc_html__( 'None', 'datebook' ),
		'1' => esc_html__( 'Percentage', 'datebook' ),
		'2' => esc_html__( 'Poor, Fair, Good, Very good, Excellent', 'datebook' )
	));

	$options[] = array(
		'name' => esc_html__('Level: fair', 'datebook' ),
		'desc' => esc_html__('percent', 'datebook' ) . '. ' . esc_html__('Percentage where the Fair level of matching starts', 'datebook' ),
		'id' => 'matching_level_fair',
		'std' => '50',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Level: good', 'datebook' ),
		'desc' => esc_html__('percent', 'datebook' ) . '. ' . esc_html__('Percentage where the Good level of matching starts', 'datebook' ),
		'id' => 'matching_level_good',
		'std' => '60',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Level: very good', 'datebook' ),
		'desc' => esc_html__('percent', 'datebook' ) . '. ' . esc_html__('Percentage where the Very good level of matching starts', 'datebook' ),
		'id' => 'matching_level_very_good',
		'std' => '70',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Level: excellent', 'datebook' ),
		'desc' => esc_html__('percent', 'datebook' ) . '. ' . esc_html__('Percentage where the Excellent level of matching starts', 'datebook' ),
		'id' => 'matching_level_excellent',
		'std' => '90',
		'class' => 'mini',
		'type' => 'text');

//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Points', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Points Management System', 'datebook' ),
		'desc' => esc_html__('Empower your users by rewarding them with points for some online activity. Allow users purchase points with real money and spend them to get Top and Featured statuses, send messages, buy online products or other online activities.', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__( 'Points system', 'datebook' ),
		'id' => 'points_system',
		'std' => '0',
		'type' => 'radio',
		'options' => array(
			'0' => esc_html__( 'None', 'datebook' ),
			'1' => esc_html__( 'myCred - points management system.', 'datebook' ) . ' ' . esc_html__( 'Download', 'datebook' ) . ' https://wordpress.org/plugins/mycred'
		)
	);

	$options[] = array(
		'name' => esc_html__('Allow users to read messages in private chat even if the subscription or points are over', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'allow_read_messages_if_points_over',
		'std' => '1',
		'type' => 'checkbox');



//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Comments &amp; Reviews', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable comments on Profiles', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_profile_comments',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Manually activate comments on profiles', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('If you choose "yes" you will be notified by email each time someone adds a new comment. The email will have a link to the comment.', 'datebook' ),
		'id' => 'activate_manual_comments',
		'std' => '0',
		'type' => 'checkbox');
		
	$options[] = array(
		'name' => esc_html__('How many characters in comments', 'datebook' ),
		'desc' => esc_html__('Maximum quantity of characters allowed in comment form on profile', 'datebook' ),
		'id' => 'comment_max_chars',
		'std' => '400',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Receive an email notification when a new comment is submitted', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'email_when_comment',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable Reviews on Profiles', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_reviews',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Manually activate reviews on profiles', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('If you choose "yes" you will be notified by email each time someone adds a new review. The email will have a link to the review.', 'datebook' ),
		'id' => 'activate_manual_reviews',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('How many characters in reviews', 'datebook' ),
		'desc' => esc_html__('Maximum quantity of characters allowed in review form on profile', 'datebook' ),
		'id' => 'review_max_chars',
		'std' => '400',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Users can reply on Reviews', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_reply_reviews',
		'std' => '1',
		'type' => 'checkbox');


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Friends', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable Friendship System', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_friendship',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Allow users to disable the Friendship system', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'user_can_disable_friendship',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Show quantity of friends on the profile page', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'show_amount_of_friends',
		'std' => '1',
		'type' => 'checkbox');


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Pages', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Registration page', 'datebook' ),
		'desc' => esc_html__('Registration page where users register and create their profiles', 'datebook' ),
		'id' => 'registration_page',
		'std' => $registerpage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Login page', 'datebook' ),
		'desc' => esc_html__('Login page where users enter their account', 'datebook' ),
		'id' => 'login_page',
		'std' => $loginpage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Forgot password page', 'datebook' ),
		'desc' => esc_html__('Forgot and Reset password page where users can restore their password', 'datebook' ),
		'id' => 'forgot_password_page',
		'std' => $forgotpasswordpage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Redirect after login to', 'datebook' ),
		'desc' => esc_html__('User will be redirected to this page after login', 'datebook' ),
		'id' => 'redirect_to_after_login',
		'std' => $profilemessagespage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Redirect after logout to', 'datebook' ),
		'desc' => esc_html__('User will be redirected to this page after logout', 'datebook' ),
		'id' => 'redirect_to_after_logout',
		'std' => $homepage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Classifieds page', 'datebook' ),
		'desc' => esc_html__('Page that displays list of Classifieds from all users', 'datebook' ),
		'id' => 'all_classifieds_page',
		'std' => $allclassifiedspage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Tours page', 'datebook' ),
		'desc' => esc_html__('Page that displays list of Tours from all users', 'datebook' ),
		'id' => 'all_tours_page',
		'std' => $alltourspage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Search Profiles page', 'datebook' ),
		'desc' => esc_html__('Page to redirect to for custom search results', 'datebook' ),
		'id' => 'search_results_page',
		'std' => $searchpage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Contact Us page', 'datebook' ),
		'desc' => esc_html__('Page where visitors can send email to Administrator', 'datebook' ),
		'id' => 'contact_page',
		'std' => $contactpage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Terms and Conditions page', 'datebook' ),
		'desc' => esc_html__('Page where users can read Terms and Conditions of the website', 'datebook' ),
		'id' => 'terms_and_conditions_url',
		'std' => $termspage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Messages page', 'datebook' ),
		'desc' => esc_html__('Page that displays list of messages', 'datebook' ),
		'id' => 'my_messages_page',
		'std' => $profilemessagespage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Edit Profile page', 'datebook' ),
		'desc' => esc_html__('Page that displays profile edit form', 'datebook' ),
		'id' => 'my_edit_profile_page',
		'std' => $profileeditpage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Photos page', 'datebook' ),
		'desc' => esc_html__('Page that displays image upload form', 'datebook' ),
		'id' => 'my_photos_page',
		'std' => $profilephotospage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Verification page', 'datebook' ),
		'desc' => esc_html__('Page that displays image upload form for Verification', 'datebook' ),
		'id' => 'my_verification_page',
		'std' => $profileverificationpage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Friends page', 'datebook' ),
		'desc' => esc_html__('Page that displays friends settings', 'datebook' ),
		'id' => 'my_friends_page',
		'std' => $profilefriendspage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Favorites page', 'datebook' ),
		'desc' => esc_html__('Page that displays list of profiles that user favorited', 'datebook' ),
		'id' => 'my_favorites_page',
		'std' => $profilefavoritespage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Blacklist page', 'datebook' ),
		'desc' => esc_html__('Page that displays list of profiles that user blocked', 'datebook' ),
		'id' => 'my_blacklist_page',
		'std' => $profileblacklistpage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Comments page', 'datebook' ),
		'desc' => esc_html__('Page that displays all comments that user left on other profiles', 'datebook' ),
		'id' => 'my_comments_page',
		'std' => $profilecommentspage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Classifieds page', 'datebook' ),
		'desc' => esc_html__('Page that displays list of Classifieds that user placed on the site', 'datebook' ),
		'id' => 'my_classifieds_page',
		'std' => $profileclassifiedspage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Tours page', 'datebook' ),
		'desc' => esc_html__('Page that displays tour form', 'datebook' ),
		'id' => 'my_tours_page',
		'std' => $profiletourspage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Who viewed me page', 'datebook' ),
		'desc' => esc_html__('Page that displays statistics of views of your profile by other users', 'datebook' ),
		'id' => 'my_views_page',
		'std' => $profileviewspage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Settings page', 'datebook' ),
		'desc' => esc_html__('Page that displays settings of user\'s account', 'datebook' ),
		'id' => 'my_settings_page',
		'std' => $profilesettingspage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Privacy page', 'datebook' ),
		'desc' => esc_html__('Page that displays privacy of user\'s account', 'datebook' ),
		'id' => 'my_privacy_page',
		'std' => $profileprivacypage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Notification page', 'datebook' ),
		'desc' => esc_html__('Page that displays personal notifications', 'datebook' ),
		'id' => 'my_notification_page',
		'std' => $profilenotificationpage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Subscription page', 'datebook' ),
		'desc' => esc_html__('Page that displays Subscription plans with payment options to upgrade profile', 'datebook' ),
		'id' => 'my_upgrade_page',
		'std' => $profileupgradepage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Cart page', 'datebook' ),
		'desc' => esc_html__('Page that displays Cart', 'datebook' ),
		'id' => 'my_cart_page',
		'std' => $profilecartepage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Profile: Checkout page', 'datebook' ),
		'desc' => esc_html__('Page that displays Checkout with billing address and payment options', 'datebook' ),
		'id' => 'my_checkout_page',
		'std' => $profilecheckoutpage,
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);


/////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Page Builder', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Profile page buider', 'datebook' ),
		'desc' => esc_html__('Single profile page can be hardcoded or created with Page Builder. If you select Page Builder then you must go to WordPress -> Pages, select the page Single Profile and edit it with your Page Builder.', 'datebook' ),
		'id' => 'what_pagebuilder_for_profile',
		'std' => '1',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => array(
			'1' => 'DateBook',
			'2' => 'Third party Page Builder'
		));

	$options[] = array(
		'name' => esc_html__('Profile page created with Page Builder', 'datebook' ),
		'desc' => esc_html__('Select the page you created for Profile with Page Builder. If you do not use Page Builder then do not select any page.', 'datebook' ),
		'id' => 'page_created_for_profile',
		'std' => '',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Classified ad page builder', 'datebook' ),
		'desc' => esc_html__('Single classified ad page can be hardcoded or created with Page Builder. If you select Page Builder then you must go to WordPress -> Pages, select the page Single Classified ad and edit it with your Page Builder.', 'datebook' ),
		'id' => 'what_pagebuilder_for_classified',
		'std' => '1',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => array(
			'1' => 'DateBook',
			'2' => 'Third party Page Builder'
		));

	$options[] = array(
		'name' => esc_html__('Classified ad page created with Page Builder', 'datebook' ),
		'desc' => esc_html__('Select the page you created for Classified ad with Page Builder. If you do not use Page Builder then do not select any page.', 'datebook' ),
		'id' => 'page_created_for_classified',
		'std' => '',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);

	$options[] = array(
		'name' => esc_html__('Tour page builder', 'datebook' ),
		'desc' => esc_html__('Single Tour page can be hardcoded or created with Page Builder. If you select Page Builder then you must go to WordPress -> Pages, select the page Single Classified ad and edit it with your Page Builder.', 'datebook' ),
		'id' => 'what_pagebuilder_for_tour',
		'std' => '1',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => array(
			'1' => 'DateBook',
			'2' => 'Third party Page Builder'
		));

	$options[] = array(
		'name' => esc_html__('Tour page created with Page Builder', 'datebook' ),
		'desc' => esc_html__('Select the page you created for Tour with Page Builder. If you did not use Page Builder then do not select any page.', 'datebook' ),
		'id' => 'page_created_for_tour',
		'std' => '',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => $pages_array);


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('IP Location', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Local time provider', 'datebook' ),
		'desc' => esc_html__('Select a method for detecting a user\'s local time', 'datebook' ),
		'id' => 'localtime_providers',
		'std' => '',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => array(
			'' => 'None',
			'ipinfo' => 'IPinfo (https://ipinfo.io)',
			'iplocate' => 'IPLocate (https://www.iplocate.io)',
			'geoplugin' => 'geoPlugin (http://www.geoplugin.net)',
			'ipinfodb' => 'IPInfoDB (http://api.ipinfodb.com)'
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable detection of user location by IP', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_iplocation',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Location provider', 'datebook' ),
		'desc' => esc_html__('Compare the real location data of the user with the location saved in the profile. This information is displayed on the profile frontend.', 'datebook' ),
		'id' => 'location_providers',
		'std' => '',
		'type' => 'select',
		'class' => 'small', //mini, tiny, small
		'options' => array(
			'1' => 'IPLocate (https://www.iplocate.io)',
			'2' => 'GEOLOCATION DB (https://geolocation-db.com)',
			'3' => 'IPInfoDB (https://ipinfodb.com)'
		));

	$options[] = array(
		'name' => esc_html__('IPInfoDB key', 'datebook' ),
		'desc' => esc_html__('If you select IPInfoDB (https://ipinfodb.com), you must enter the API key. Register here https://ipinfodb.com/register to get the API key.', 'datebook' ),
		'id' => 'location_apikey_ipinfodb',
		'std' => '',
		'class' => 'tiny',
		'type' => 'text');


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Simulation', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Warning', 'datebook' ),
		'desc' => esc_html__( 'The simulation creates the illusion that the demo profiles are real profiles. The simulation function should be used for demonstration purposes. Do not use it on a live site to avoid misleading real visitors.', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Redirect all emails for demo profiles to admin', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('All email notifications for demo profiles will be sent to administrator email', 'datebook' ),
		'id' => 'redirect_demo_emails_to_admin',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable Simulation of online presence', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Online indicator on demo profiles will be switched on and displaying the current or updated time as if users are logged in.', 'datebook' ),
		'id' => 'enable_simulation_online',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Update online status every', 'datebook' ),
		'desc' => esc_html__('minutes', 'datebook' ),
		'id' => 'simulation_online_update',
		'std' => '6',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Period: min time to be logged in', 'datebook' ),
		'desc' => esc_html__('minutes', 'datebook' ),
		'id' => 'simulation_online_min_time',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Period: max time to be logged in', 'datebook' ),
		'desc' => esc_html__('minutes', 'datebook' ),
		'id' => 'simulation_online_max_time',
		'std' => '5',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable simulation of profile views', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('The number of profile views will be increasing periodically as if profile was viewed by visitors.', 'datebook' ),
		'id' => 'enable_simulation_views',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Update Views of profile every', 'datebook' ),
		'desc' => esc_html__('minutes', 'datebook' ),
		'id' => 'simulation_views_update',
		'std' => '11',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Quantity of views: min ', 'datebook' ),
		'desc' => esc_html__('views', 'datebook' ),
		'id' => 'simulation_views_min',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Quantity of views: max', 'datebook' ),
		'desc' => esc_html__('views', 'datebook' ),
		'id' => 'simulation_views_max',
		'std' => '5',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable simulation of chat', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ) . '. ' . esc_html__('Demo profiles will be sending messages to real users when they logged in.', 'datebook' ),
		'id' => 'enable_simulation_chat',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Send a message after: min', 'datebook' ),
		'desc' => esc_html__('minutes', 'datebook' ) . '. ' . esc_html__('Messages will begin to be sent after this period of time, as soon as user logs in.', 'datebook' ),
		'id' => 'simulation_chat_min',
		'std' => '2',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Send a message after: max', 'datebook' ),
		'desc' => esc_html__('minutes', 'datebook' ) . '. ' . esc_html__('Messages will begin to be sent between this period of time, as soon as user logs in.', 'datebook' ),
		'id' => 'simulation_chat_max',
		'std' => '8',
		'class' => 'mini',
		'type' => 'text');

	foreach ( $languages_active_array as $language_key => $language_name ) {
	
		$options[] = array(
			'name' => sprintf( esc_html__( 'Messages (%1$s)', 'datebook' ), $language_name ),
			'desc' => esc_html__('Separate all phrases with the sign "|" (Example: Hi|Hello|Good day|How are you|Hey). Start each list of messages on a new line', 'datebook' ),
			'id' => 'simulation_chat_messages_' . $language_key,
			'std' => 'Hi|Hello|Good day|How are you|Hey
Where are you from|Would you like to talk|What are you looking for?|I liked your profile',
			'class' => 'tiny', //mini, tiny, small
			'type' => 'textarea');

		}


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Word Filter', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable Word Filter', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_prohibited_words',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Prohibited words', 'datebook' ),
		'desc' => esc_html__('Enter the words seperated by comma "," that must be prohibited in all text content submitted by users and replaced by the * sign', 'datebook' ),
		'id' => 'prohibited_words',
		'std' => 'badword, anotherbadword, onemorebadword',
		'class' => 'tiny',
		'type' => 'textarea');


///////////////////////////////////////////////////////////////////////////

	$options[] = array(
		'name' => esc_html__('Logo', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Website logo', 'datebook'),
		'desc' => esc_html__('Upload your website logo to go in place of default theme logo.', 'datebook'),
		'id' => 'website_logo_front',
		'std' => DATEBOOK_URL . 'assets/images/logo-front.png',
		'type' => 'upload');

	$options[] = array(
		'name' => esc_html__('Logo position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Logo will be placed', 'datebook' ),
		'id' => 'logo_position_front',
		'std' => 'insidemenu',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/logo-position-1.jpg",
			"inheader" => DATEBOOK_URL . "framework/images/logo-position-2.jpg",
			"insidemenu" => DATEBOOK_URL . "framework/images/logo-position-3.jpg",
			),
		);

	$options[] = array(
		'name' => esc_html__( 'Logo: background color', 'datebook' ),
		'id' => 'logo_bg_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Logo: align', 'datebook' ),
		'id' => 'logo_align_front',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Website logo', 'datebook'),
		'desc' => esc_html__('Upload your website logo to go in place of default theme logo.', 'datebook'),
		'id' => 'website_logo_other',
		'std' => DATEBOOK_URL . 'assets/images/logo.png',
		'type' => 'upload');

	$options[] = array(
		'name' => esc_html__('Logo position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Logo will be placed', 'datebook' ),
		'id' => 'logo_position_other',
		'std' => 'insidemenu',
		'type' => 'images',
		"options" => array(
			'top' => DATEBOOK_URL . 'framework/images/logo-position-1.jpg',
			'inheader' => DATEBOOK_URL . 'framework/images/logo-position-2.jpg',
			'insidemenu' => DATEBOOK_URL . 'framework/images/logo-position-3.jpg',
			)
		);

	$options[] = array(
		'name' => esc_html__( 'Logo: background color', 'datebook' ),
		'id' => 'logo_bg_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Logo: align', 'datebook' ),
		'id' => 'logo_align_other',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));


//////////////////////////////////////////////////////////////////


	// Top menu
	$options[] = array(
		'name' => esc_html__('Top menu', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Display Top menu?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'top_menu_enabled_front',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Top menu: position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Top menu will be placed', 'datebook' ),
		'id' => 'top_menu_position_front',
		'std' => 'inside',
		'type' => 'images',
		'options' => array(
			'top' => DATEBOOK_URL . 'framework/images/top-menu-position-front-1.jpg',
			'inside' => DATEBOOK_URL . 'framework/images/top-menu-position-front-2.jpg')
		);

	$options[] = array(
		'name' => esc_html__('Top menu: align', 'datebook' ),
		'id' => 'top_menu_align_front',
		'std' => 'leftright',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'leftright' => esc_html__('Left and Right', 'datebook' ),
			'centeronside' => esc_html__('Center on Left and Right', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Top menu: font', 'datebook' ),
		'id' => 'top_menu_font_front',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('Top menu: background color', 'datebook' ),
		'id' => 'top_menu_bg_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Top menu toggle: background color', 'datebook' ),
		'id' => 'top_menu_toggler_bg_color_front',
		'std' => '#2f7cbf',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'Top menu: margin', 'datebook' ),
		'id' => 'top_menu_margin_front',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Top menu: padding', 'datebook' ),
		'id' => 'top_menu_padding_front',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Display Top menu?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'top_menu_enabled_other',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Top menu: position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Top menu will be placed', 'datebook' ),
		'id' => 'top_menu_position_other',
		'std' => 'inside',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/top-menu-position-other-1.jpg",
			"inside" => DATEBOOK_URL . "framework/images/top-menu-position-other-2.jpg")
		);

	$options[] = array(
		'name' => esc_html__('Top menu: align', 'datebook' ),
		'id' => 'top_menu_align_other',
		'std' => 'left',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'leftright' => esc_html__('Left and Right', 'datebook' ),
			'centeronside' => esc_html__('Center on Left and Right', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Top menu: font', 'datebook' ),
		'id' => 'top_menu_font_other',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('Top menu: background color', 'datebook' ),
		'id' => 'top_menu_bg_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Top menu toggle: background color', 'datebook' ),
		'id' => 'top_menu_toggler_bg_color_other',
		'std' => '#2f7cbf',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'Top menu: margin', 'datebook' ),
		'id' => 'top_menu_margin_other',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Top menu: padding', 'datebook' ),
		'id' => 'top_menu_padding_other',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


//////////////////////////////////////////////////////////////////


	// Primary menu
	$options[] = array(
		'name' => esc_html__('Primary menu', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Primary menu: position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Primary menu will be placed', 'datebook' ),
		'id' => 'primary_menu_position_front',
		'std' => 'inside',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/primary-menu-position-1.jpg",
			"inside" => DATEBOOK_URL . "framework/images/primary-menu-position-2.jpg")
		);

	$options[] = array(
		'name' => esc_html__('Primary menu: width', 'datebook' ),
		'id' => 'primary_menu_width_front',
		'std' => 'boxed',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'full' => esc_html__('Full width', 'datebook' ),
			'boxed' => esc_html__('Boxed', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Primary menu: align', 'datebook' ),
		'id' => 'primary_menu_align_front',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Primary menu: font', 'datebook' ),
		'id' => 'primary_menu_font_front',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('Menu container: background color', 'datebook' ),
		'id' => 'primary_menu_bg_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu container: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_container_border_round_front',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Menu subcontainer: background color', 'datebook' ),
		'id' => 'primary_menu_subcontainer_bg_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu subcontainer: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_subcontainer_border_round_front',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Menu: background color', 'datebook' ),
		'id' => 'primary_menu_class_bg_color_front',
		'std' => 'rgb(0, 152, 255)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_class_border_round_front',
		'std' => '2.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Primary menu toggle: background color', 'datebook' ),
		'id' => 'primary_menu_toggler_bg_color_front',
		'std' => '#2f7cbf',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'Primary menu: margin', 'datebook' ),
		'id' => 'primary_menu_margin_front',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Primary menu: padding', 'datebook' ),
		'id' => 'primary_menu_padding_front',
		'std' => array_merge($typography_defaults, array(
		'padding_top' => '5px',
		'padding_right' => '10px',
		'padding_bottom' => '5px',
		'padding_left' => '10px' )),
		'type' => 'padding'
	);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Primary menu: position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Primary menu will be placed', 'datebook' ),
		'id' => 'primary_menu_position_other',
		'std' => 'inside',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/primary-menu-position-1.jpg",
			"inside" => DATEBOOK_URL . "framework/images/primary-menu-position-2.jpg")
		);

	$options[] = array(
		'name' => esc_html__('Primary menu: width', 'datebook' ),
		'id' => 'primary_menu_width_other',
		'std' => 'full',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'full' => esc_html__('Full width', 'datebook' ),
			'boxed' => esc_html__('Boxed', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Primary menu: align', 'datebook' ),
		'id' => 'primary_menu_align_other',
		'std' => 'left',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Primary menu: font', 'datebook' ),
		'id' => 'primary_menu_font_other',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('Menu container: background color', 'datebook' ),
		'id' => 'primary_menu_bg_color_other',
		'std' => 'rgba(16, 85, 204, 0.52)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu container: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_container_border_round_other',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Menu subcontainer: background color', 'datebook' ),
		'id' => 'primary_menu_subcontainer_bg_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu subcontainer: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_subcontainer_border_round_other',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Menu: background color', 'datebook' ),
		'id' => 'primary_menu_class_bg_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_class_border_round_other',
		'std' => '2.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Primary menu toggle: background color', 'datebook' ),
		'id' => 'primary_menu_toggler_bg_color_other',
		'std' => '#2f7cbf',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'Primary menu: margin', 'datebook' ),
		'id' => 'primary_menu_margin_other',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Primary menu: padding', 'datebook' ),
		'id' => 'primary_menu_padding_other',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


//////////////////////////////////////////////////////////////////


	// User menu
	$options[] = array(
		'name' => esc_html__('User menu', 'datebook' ),
		'type' => 'heading');
	
	$options[] = array(
		'name' => esc_html__('User menu: titles and icons', 'datebook' ),
		'id' => 'display_title_icon_usermenu',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('Titles and icons', 'datebook' ),
			'2' => esc_html__('Titles only', 'datebook' ),
			'3' => esc_html__('Icons only', 'datebook' )
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__( 'Display menu items in Header', 'datebook' ),
		'desc' => esc_html__( 'Select the items that will be placed in the user menu as separate items. All unchecked items will be placed in the submenu.', 'datebook' ),
		'id' => 'user_menu_items_in_header_front',
		'std' => 'my_messages_page,my_photos_page,my_views_page,my_upgrade_page',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $user_menu_items_array);

	$options[] = array(
		'name' => esc_html__('User menu position', 'datebook' ),
		'desc' => esc_html__('Select the position where the User menu will be placed', 'datebook' ),
		'id' => 'user_menu_position_front',
		'std' => 'underprimarymenu',
		'type' => 'images',
		"options" => array(
			'top' => DATEBOOK_URL . 'framework/images/user-menu-position-front-1.jpg',
			'underlogo' => DATEBOOK_URL . 'framework/images/user-menu-position-front-2.jpg',
			'inprimarymenu' => DATEBOOK_URL . 'framework/images/user-menu-position-front-3.jpg',
			'underprimarymenu' => DATEBOOK_URL . 'framework/images/user-menu-position-front-4.jpg',
			'underlast' => DATEBOOK_URL . 'framework/images/user-menu-position-front-5.jpg')
		);

	$options[] = array(
		'name' => esc_html__('User menu: align', 'datebook' ),
		'id' => 'user_menu_align_front',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'User menu: font', 'datebook' ),
		'id' => 'user_menu_font_front',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('User menu: background color', 'datebook' ),
		'id' => 'user_menu_bg_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('User menu submenu: background color', 'datebook' ),
		'id' => 'user_menu_toggler_bg_color_front',
		'std' => 'rgba(16, 85, 204, 0.85)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'User menu: margin', 'datebook' ),
		'id' => 'user_menu_margin_front',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'User menu: padding', 'datebook' ),
		'id' => 'user_menu_padding_front',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__( 'Display menu items in Header', 'datebook' ),
		'desc' => esc_html__( 'Select the items that will be placed in the user menu as separate items. All unchecked items will be placed in the submenu.', 'datebook' ),
		'id' => 'user_menu_items_in_header_other',
		'std' => 'my_messages_page,my_photos_page,my_views_page,my_upgrade_page',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $user_menu_items_array);

	$options[] = array(
		'name' => esc_html__('User menu position', 'datebook' ),
		'desc' => esc_html__('Select the position where the User menu will be placed', 'datebook' ),
		'id' => 'user_menu_position_other',
		'std' => 'inprimarymenu',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/user-menu-position-other-1.jpg",
			"underlogo" => DATEBOOK_URL . "framework/images/user-menu-position-other-2.jpg",
			"inprimarymenu" => DATEBOOK_URL . "framework/images/user-menu-position-other-3.jpg",
			"underprimarymenu" => DATEBOOK_URL . "framework/images/user-menu-position-other-4.jpg",
			"underlast" => DATEBOOK_URL . "framework/images/user-menu-position-other-5.jpg")
		);

	$options[] = array(
		'name' => esc_html__('User menu: align', 'datebook' ),
		'id' => 'user_menu_align_other',
		'std' => 'right',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'User menu: font', 'datebook' ),
		'id' => 'user_menu_font_other',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('User menu: background color', 'datebook' ),
		'id' => 'user_menu_bg_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('User menu submenu: background color', 'datebook' ),
		'id' => 'user_menu_toggler_bg_color_other',
		'std' => 'rgba(16, 85, 204, 0.85)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'User menu: margin', 'datebook' ),
		'id' => 'user_menu_margin_other',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'User menu: padding', 'datebook' ),
		'id' => 'user_menu_padding_other',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


/////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Countries', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Style of countries', 'datebook' ),
		'desc' => esc_html__('Countries can be displayed in different styles', 'datebook' ),
		'id' => 'countries_style',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
			'1' => '1. ' . esc_html__( 'Columns', 'datebook' ),
			'2' => '2. ' . esc_html__( 'List', 'datebook' ),
	));

	$options[] = array('type' => 'container_in');

	$options[] = array(
		'name' => esc_html__('Enable custom styling of Countries panel?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_countries_style',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Roundness of panel', 'datebook' ),
		'id' => 'countries_round',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('No round', 'datebook' ),
			'2' => esc_html__('Rounded corners', 'datebook' ),
			'3' => esc_html__('Rounded circle', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Panel padding', 'datebook' ),
		'id' => 'countries_padding',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('0 rem', 'datebook' ),
			'2' => esc_html__('0.25 rem', 'datebook' ),
			'3' => esc_html__('0.5 rem', 'datebook' ),
			'4' => esc_html__('1 rem', 'datebook' ),
			'5' => esc_html__('1.5 rem', 'datebook' ),
			'6' => esc_html__('3 rem', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Width of panel border', 'datebook' ),
		'desc' => esc_html__('Width of image border can be 3 options: 1. enter random numbers separated by a comma. Example: 1,12 = borders will be random width from 1 to 12 pixels. 2. enter one number. Example: 5 = border for all images will be 5px. 3. enter 0 = no borders', 'datebook' ),
		'id' => 'countries_border_width',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Border style', 'datebook' ),
		'id' => 'countries_border_style',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__( 'Color of border', 'datebook' ),
		'id' => 'countries_border_color',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Gamma of colors', 'datebook' ),
		'desc' => esc_html__('Remove Color of border (above) to enable this option', 'datebook' ),
		'id' => 'countries_color_gamma',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('None', 'datebook' ),
			'random' => esc_html__('Random', 'datebook' ),
			'light' => esc_html__('Random Light', 'datebook' ),
			'dark' => esc_html__('Random Dark', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'countries_shadow',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array('type' => 'container_out');


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('SEO', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Enable shortcodes in meta tags', 'datebook' ),
		'desc' => esc_html__( 'You can use the DateBook shortcodes in the following SEO plugins. Some SEO plugins do not support shortcodes by default. Here you can enable it.', 'datebook' ),
		'id' => 'enable_shortcodes_in_meta_tags',
		'std' => '',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => array(
			'rank_math_seo_title' => esc_html__('Title in Rank Math', 'datebook' ),
			'rank_math_seo_description' => esc_html__('Description in Rank Math', 'datebook' ),
			'rank_math_seo_schema' => esc_html__('Schema in Rank Math', 'datebook' ),
			'rank_math_seo_opengraph_facebook_title' => esc_html__('Title Facebook OpenGraph in Rank Math', 'datebook' ),
			'rank_math_seo_opengraph_facebook_description' => esc_html__('Description Facebook OpenGraph in Rank Math', 'datebook' ),
			'rank_math_seo_opengraph_twitter_title' => esc_html__('Title Twitter OpenGraph in Rank Math', 'datebook' ),
			'rank_math_seo_opengraph_twitter_description' => esc_html__('Description Twitter OpenGraph in Rank Math', 'datebook' ),
			'wp_title' => esc_html__('Title', 'datebook' ),
			'the_content' => esc_html__('Description', 'datebook' ),
			'nav_menu' => esc_html__('Navigation Menu', 'datebook' ),
			'widget' => esc_html__('Widget', 'datebook' )
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable meta title on these pages', 'datebook' ),
		'id' => 'enable_meta_title',
		'std' => '',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => array(
			'single_profile' => esc_html__('Single Profile', 'datebook' ),
			'search_page' => esc_html__('Search page', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Profile page: meta title', 'datebook' ),
		'desc' => esc_html__('Title of profile page displayed in the browser title. Use the following shortcodes', 'datebook' ) . ': [datebook_profile_name], [datebook_profile_age], [datebook_profile_city], [datebook_profile_country], [datebook_profile_description]',
		'id' => 'meta_title_profile',
		'std' => '[datebook_profile_name] [datebook_profile_age] [datebook_profile_city] [datebook_profile_country]',
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Enable meta description on these pages', 'datebook' ),
		'id' => 'enable_meta_description',
		'std' => '',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => array(
			'single_profile' => esc_html__('Single Profile', 'datebook' ),
			'search_page' => esc_html__('Search page', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Profile page: meta description', 'datebook' ),
		'desc' => esc_html__('Description of profile page displayed in the meta description. Use the following shortcodes', 'datebook' ) . ': [datebook_profile_name], [datebook_profile_age], [datebook_profile_city], [datebook_profile_country], [datebook_profile_description]',
		'id' => 'meta_description_profile',
		'std' => '[datebook_profile_description]',
		'class' => 'small', //mini, tiny, small
		'type' => 'textarea'
	);


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Typography', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable custom typography?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_custom_typography',
		'std' => '0',
		'type' => 'checkbox');


	// Body text
	// body {color: #757575; font-family: "Open Sans", Arial, Helvetica, sans-serif; font-size: 13px;	background-color: #eee;}
	$typography_body_text = array(
		'size' => '1',
		'color' => '#757575' );

	$options[] = array( 'name' => esc_html__( 'Main (body) text', 'datebook' ),
		'id' => "typography_body",
		'std' => array_merge($typography_defaults, $typography_body_text),
		'type' => 'typography'
	);

	// Link colors
	// a, .btn-link {color: #455A64; text-decoration: none}
	$options[] = array(
		'name' => esc_html__( 'Link: color', 'datebook' ),
		'id' => 'link_color',
		'std' => '',
		'type' => 'transparentcolor'
	);

	// H1
	// h1, .h1 {font-size: 38px; line-height: 1.28;}
	$typography_h1 = array(
		'size' => '2.375' );

	$options[] = array( 'name' => esc_html__( 'H1 title', 'datebook' ),
		'id' => "typography_h1",
		'std' => array_merge($typography_defaults, $typography_h1),
		'type' => 'typography'
	);

	// H2
	// h2, .h2 {font-size: 30px; line-height: 1.16;}
	$typography_h2 = array(
		'size' => '1.875' );

	$options[] = array( 'name' => esc_html__( 'H2 title', 'datebook' ),
		'id' => "typography_h2",
		'std' => array_merge($typography_defaults, $typography_h2),
		'type' => 'typography'
	);

	// H3
	// h3, .h3 {font-size: 23px; line-height: 1.36;}
	$typography_h3 = array(
		'size' => '1.5' );

	$options[] = array( 'name' => esc_html__( 'H3 title', 'datebook' ),
		'id' => "typography_h3",
		'std' => array_merge($typography_defaults, $typography_h3),
		'type' => 'typography'
	);

	// H4
	// h4, .h4 {font-size: 20px; line-height: 1.16;}
	$typography_h4 = array(
		'size' => '1.25' );

	$options[] = array( 'name' => esc_html__( 'H4 title', 'datebook' ),
		'id' => "typography_h4",
		'std' => array_merge($typography_defaults, $typography_h4),
		'type' => 'typography'
	);

	// H5
	// h5, .h5 {font-size: 16px; line-height: 1.25;}
	$typography_h5 = array(
		'size' => '1' );

	$options[] = array( 'name' => esc_html__( 'H5 title', 'datebook' ),
		'id' => "typography_h5",
		'std' => array_merge($typography_defaults, $typography_h5),
		'type' => 'typography'
	);

	// H6
	// h6, .h6 {font-size: 14px; line-height: 1.16;}
	$typography_h6 = array(
		'size' => '0.875' );

	$options[] = array( 'name' => esc_html__( 'H6 title', 'datebook' ),
		'id' => "typography_h6",
		'std' => array_merge($typography_defaults, $typography_h6),
		'type' => 'typography'
	);
	
	// Lead text
	// .lead {font-size: 16px;}
	$typography_lead = array(
		'size' => '1' );

	$options[] = array( 'name' => esc_html__( 'Lead text', 'datebook' ),
		'id' => "typography_lead",
		'std' => array_merge($typography_defaults, $typography_lead),
		'type' => 'typography'
	);

	// Blockquote
	// blockquote {font-size: 120%;	background-color: #f5f5f5}
	$typography_blockquote = array(
		'size' => '1' );

	$options[] = array( 'name' => esc_html__( 'Blockquote text', 'datebook' ),
		'id' => "typography_blockquote",
		'std' => array_merge($typography_defaults, $typography_blockquote),
		'type' => 'typography'
	);

	// Special colors for text
	// .text-grey {color: #ABABAB;}
	$options[] = array(
		'name' => esc_html__( 'Text: grey', 'datebook' ),
		'id' => 'text_grey',
		'std' => '#ABABAB',
		'type' => 'transparentcolor'
	);

	// .text-green {color: #4caf50;}
	$options[] = array(
		'name' => esc_html__( 'Text: green', 'datebook' ),
		'id' => 'text_green',
		'std' => '#4caf50',
		'type' => 'transparentcolor'
	);

	// .text-brown {color: #9d5106;}
	$options[] = array(
		'name' => esc_html__( 'Text: brown', 'datebook' ),
		'id' => 'text_brown',
		'std' => '#9d5106',
		'type' => 'transparentcolor'
	);

	// .amber-text {color: #FFC107;}
	$options[] = array(
		'name' => esc_html__( 'Text: yellow', 'datebook' ),
		'id' => 'text_yellow',
		'std' => '#FFC107',
		'type' => 'transparentcolor'
	);

	// .text-orange {color: #F57C00;}
	$options[] = array(
		'name' => esc_html__( 'Text: orange', 'datebook' ),
		'id' => 'text_orange',
		'std' => '#F57C00',
		'type' => 'transparentcolor'
	);


//////////////////////////////////////////////////////////////////

	$options[] = array(
		'name' => esc_html__('Styling', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable custom styling?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_custom_styling',
		'std' => '0',
		'type' => 'checkbox');

	// Background Defaults
	// body { background-color: #eee;}
	$background_defaults = array(
		'color' => '#eee',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top center',
		'attachment' => 'scroll' );

	$options[] = array(
		'name' =>  esc_html__( 'Background color', 'datebook' ),
		'desc' => esc_html__( 'Change the background color of website', 'datebook' ),
		'id' => 'background_color',
		'std' => $background_defaults,
		'type' => 'background'
	);

	// Default button
	// .btn-secondary, .label-default, .badge-default {background-color: #EBEEF1; color: #707A81;}
	$options[] = array(
		'name' => esc_html__( 'Button: Default', 'datebook' ),
		'id' => 'btn_default',
		'std' => '#EBEEF1',
		'type' => 'transparentcolor'
	);

	// Primary button
	// .btn-message {font-size: 16px; padding-left: 20px; padding-right: 20px;}
	$options[] = array(
		'name' => esc_html__( 'Button: Primary', 'datebook' ),
		'id' => 'btn_primary',
		'std' => '#2196f3',
		'type' => 'transparentcolor'
	);

	// Message button
	// .btn-message {font-size: 16px; padding-left: 20px; padding-right: 20px;}
	$options[] = array(
		'name' => esc_html__( 'Button: Message', 'datebook' ),
		'id' => 'btn_message',
		'std' => '#2196f3',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Button: shadow', 'datebook' ),
		'id' => 'btn_shadow',
		'std' => '1',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);


	// Color of female icon
	// i.fa-venus, .datebook-countries .datebook-subcountry .fa-venus {color:#E91E63}
	$options[] = array(
		'name' => esc_html__( 'Icon: female', 'datebook' ),
		'id' => 'fa_venus',
		'std' => '#E91E63',
		'type' => 'transparentcolor'
	);

	// Color of male icon
	// i.fa-mars, .datebook-countries .datebook-subcountry .fa-mars {color:#2196F3}
	$options[] = array(
		'name' => esc_html__( 'Icon: male', 'datebook' ),
		'id' => 'fa_mars',
		'std' => '#2196F3',
		'type' => 'transparentcolor'
	);

	// Color of icon in Popover
	// .popover i.fa-venus, .popover i.fa-mars {color:#ffffff}
	$options[] = array(
		'name' => esc_html__( 'Icon: popover', 'datebook' ),
		'id' => 'popover_fa',
		'std' => '#ffffff',
		'type' => 'transparentcolor'
	);

	// Column padding
	// .datebook-padding-less {padding-left: 8px; padding-right: 8px;}
	$options[] = array(
		'name' => esc_html__( 'Column: padding', 'datebook' ),
		'id' => 'column_padding',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Panels', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable custom panel styling?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_custom_panels',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Borders: width', 'datebook' ),
		'desc' => 'px',
		'id' => 'panel_border_width',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Borders: style', 'datebook' ),
		'id' => 'panel_border_style',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__('Borders: color', 'datebook' ),
		'id' => 'panel_border_color',
		'std' => '#d1d1d1',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Borders: roundness', 'datebook' ),
		'desc' => 'rem',
		'id' => 'panel_border_round',
		'std' => '0.2',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Header: text color', 'datebook' ),
		'id' => 'panel_header_text_color',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Header: background color', 'datebook' ),
		'id' => 'panel_header_bg_color',
		'std' => '#f5f5f5',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Body: text color', 'datebook' ),
		'id' => 'panel_text_color',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Body: background color', 'datebook' ),
		'id' => 'panel_background_color',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'panel_border_shadow',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	// .card {margin-bottom: 16px;} .card-body {padding: 15px;}
	$options[] = array(
		'name' => esc_html__( 'Margin', 'datebook' ),
		'id' => 'panel_container_margin',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Padding', 'datebook' ),
		'id' => 'panel_container_padding',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


//////////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Contacts', 'datebook' ),
		'type' => 'heading');


	foreach ( $languages_active_array as $language_key => $language_name ) {
	
	$options[] = array(
		'name' => sprintf( esc_html__( 'Company: Title (%1$s)', 'datebook' ), $language_name ),
		'desc' => esc_html__('Title of Company displayed on the site.', 'datebook' ),
		'id' => 'company_title_' . $language_key,
		'std' => 'Your Company ltd.',
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array(
		'name' => sprintf( esc_html__( 'Company: Address (%1$s)', 'datebook' ), $language_name ),
		'desc' => esc_html__('Contact address street displayed on the contact us page.', 'datebook' ),
		'id' => 'contact_address_street_' . $language_key,
		'std' => '3812 Opera Ave',
		'class' => 'tiny',
		'type' => 'text');
		
	$options[] = array(
		'name' => sprintf( esc_html__( 'Company: City (%1$s)', 'datebook' ), $language_name ),
		'desc' => esc_html__('Contact address city displayed on the contact us page.', 'datebook' ),
		'id' => 'contact_address_city_' . $language_key,
		'std' => 'Sydney',
		'class' => 'tiny',
		'type' => 'text');
		
	$options[] = array(
		'name' => sprintf( esc_html__( 'Company: Country (%1$s)', 'datebook' ), $language_name ),
		'desc' => esc_html__('Contact address country displayed on the contact us page.', 'datebook' ),
		'id' => 'contact_address_country_' . $language_key,
		'std' => 'Australia',
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array('type' => 'hr');
		
	}

	$options[] = array(
		'name' => esc_html__('Company: Phone number', 'datebook'),
		'desc' => esc_html__('Contact phone number displayed on the site.', 'datebook'),
		'id' => 'contact_phone_number',
		'std' => '1-234-567-890',
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Company: Email', 'datebook' ),
		'desc' => esc_html__('Contact email displayed on the contact us page.', 'datebook'),
		'id' => 'contact_email',
		'std' => 'info@yoursite.com',
		'class' => 'tiny',
		'type' => 'text');


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Email', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Email address', 'datebook' ),
		'desc' => esc_html__('Your email where to receive email notifications.', 'datebook' ),
		'id' => 'email_website',
		'std' => sanitize_email(get_bloginfo('admin_email')),
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Site users will receive emails with the following sender', 'datebook' ),
		'class' => 'full-header');

	$options[] = array(
		'name' => esc_html__('Name', 'datebook' ),
		'id' => 'email_sitename',
		'std' => 'Your Site title',
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Email', 'datebook' ),
		'id' => 'email_siteemail',
		'std' => sanitize_email(get_bloginfo('admin_email')),
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Email signature', 'datebook' ),
		'desc' => esc_html__('This will be at the end of all emails. HTML is allowed.', 'datebook' ),
		'id' => 'email_signature',
		'std' => 'YourSite.com',
		'class' => 'tiny',
		'type' => 'textarea');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Logo in email message', 'datebook'),
		'desc' => esc_html__('Upload your website logo to go in place of default theme logo.', 'datebook'),
		'id' => 'logo_email',
		'std' => DATEBOOK_URL . 'assets/images/logo-email.png',
		'type' => 'upload');


/////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Social', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable Facebook share button', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_share_facebook',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Enable Twitter share button', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_share_twitter',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Enable VKontakte share button', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_share_vkontakte',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Facebook', 'datebook' ),
		'desc' => esc_html__('Place the url to your Facebook page.', 'datebook' ),
		'id' => 'facebook_link',
		'std' => '',
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Twitter', 'datebook' ),
		'desc' => esc_html__('Place the url to your Twitter page.', 'datebook' ),
		'id' => 'twitter_link',
		'std' => '',
		'class' => 'tiny',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('VKontakte', 'datebook' ),
		'desc' => esc_html__('Place the url to your VKontakte page.', 'datebook' ),
		'id' => 'vkontakte_link',
		'std' => '',
		'class' => 'tiny',
		'type' => 'text');

		
/////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Custom code', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable custom code in Header', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_custom_code_header',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => sprintf( esc_html__( 'HTML code in Header', 'datebook' ), $language_name ),
		'desc' => esc_html__('Paste any code: Google Analytics, JavaScript or CSS. The code will be added right before the closing </head> tag on each page.', 'datebook' ),
		'id' => 'custom_code_html_header',
		'std' => '',
		'class' => 'small', //mini, tiny, small
		'type' => 'customcode');

	$options[] = array(
		'name' => esc_html__('Enable custom code in Footer', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_custom_code_footer',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => sprintf( esc_html__( 'HTML code in Footer', 'datebook' ), $language_name ),
		'desc' => esc_html__('Paste any code: Google Analytics, JavaScript or CSS. The code will be added right before the closing </body> tag on each page.', 'datebook' ),
		'id' => 'custom_code_html_footer',
		'std' => '',
		'class' => 'small', //mini, tiny, small
		'type' => 'customcode');




	return $options;

}


/**
 * A unique identifier is defined to store the options in the database and reference them from the plugin.
 */
function optionsframework_design_name() {

	// This gets the plugin name from the stylesheet
	$pluginname = get_option( 'stylesheet' ) . '_design';
	$pluginname = preg_replace("/\W/", "_", strtolower($pluginname) );

	$datebook_settings = get_option( 'optionsframework_designs' );
	$datebook_settings['id'] = $pluginname;
	update_option( 'optionsframework_designs', $datebook_settings );

}


/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your plugin translatable, you should replace 'plugin-textdomain'
 * with the actual text domain for your plugin.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_plugin_textdomain
 */
function optionsframework_designs() {

	global $wp_locale_all, $datebook_field_titles;

	set_query_var( 'datebook_field_titles', $datebook_field_titles );
	
	$datebook_field_titles = get_query_var( 'datebook_field_titles' );
	if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

	// get colors
	$colors = datebook_get_color_schemes_plugin();
	$colors_array = array();
	foreach ( $colors as $color ) {
		$colors_array[$color] = ucfirst($color);
	}

	// get User menu items
	$user_menu_items_array = array();
	foreach ( $datebook_user_menu_items as $key => $value ) {
		$user_menu_items_array[$key] = esc_html__( $value['title'], 'datebook' );
	}

	// get languages
	$languages_active_array = array();

	// Count translated strings. Get languages
	$languages_active_array = array();

	$languages_active_array['en_US'] = esc_html__( 'English', 'datebook' );

	$languages = DateBook_Localization::datebook_all_available_language_files();

	foreach($languages as $language) {

		$language_title = esc_html__( $wp_locale_all[$language['locale']], 'datebook' );

		if($language['checked'] == 1){
			$languages_active_array[$language['locale']] = $language_title;
		}

	}

	$emoji_symbols = datebook_emoji_symbols();

	// Stores all the controls that will be added
	$options = array();


	// Typography Defaults
	$typography_defaults = array(
		'face' => '',
		'style' => 'normal' );

	$header_menu_args = array(
		'size' => '0.8125',
		'color' => '#ffffff' );

	$margin_defaults = array(
		'margin_top' => '',
		'margin_right' => '',
		'margin_bottom' => '',
		'margin_left' => '' );

	$margin_args = array(
		'margin_top' => '',
		'margin_right' => '',
		'margin_bottom' => '',
		'margin_left' => '' );

	$padding_args = array(
		'padding_top' => '',
		'padding_right' => '',
		'padding_bottom' => '',
		'padding_left' => '' );

	$shadow_args = array(
		'1' => esc_html__('None', 'datebook' ),
		'2' => esc_html__('Small', 'datebook' ) . ' 1',
		'3' => esc_html__('Small', 'datebook' ) . ' 2',
		'4' => esc_html__('Small', 'datebook' ) . ' 3',
		'5' => esc_html__('Small', 'datebook' ) . ' 4',
		'6' => esc_html__('Small', 'datebook' ) . ' 5',
		'7' => esc_html__('Normal', 'datebook' ) . ' 1',
		'8' => esc_html__('Normal', 'datebook' ) . ' 2',
		'9' => esc_html__('Normal', 'datebook' ) . ' 3',
		'10' => esc_html__('Normal', 'datebook' ) . ' 4',
		'11' => esc_html__('Normal', 'datebook' ) . ' 5',
		'12' => esc_html__('Large', 'datebook' ) . ' 1',
		'13' => esc_html__('Large', 'datebook' ) . ' 2',
		'14' => esc_html__('Large', 'datebook' ) . ' 3'
	);

	$profile_details_args = array(
		'comments' => esc_html__( 'Quantity of comments', 'datebook' ),
		'images' => esc_html__( 'Quantity of images', 'datebook' ),
		'travel' => esc_html__( 'Ready to Travel icon', 'datebook' ),
		'age' => esc_html__( 'Age', 'datebook' ),
		'gender' => esc_html__( 'Gender', 'datebook' ),
		'sexorientation' => esc_html__( 'Sexual orientation', 'datebook' ),
		'city' => esc_html__( 'City', 'datebook' ),
		'country' => esc_html__( 'Country', 'datebook' )
	);


///////////////////////////////////////////////////////////////////////////

	$options[] = array(
		'name' => esc_html__('Header', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Select color scheme', 'datebook' ),
		'desc' => esc_html__('Select form, buttons and some elements color scheme (Not the whole website color).', 'datebook' ),
		'id' => 'color_scheme_select',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $colors_array);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	// Gradient color of header
	$options[] = array(
		'name' => esc_html__( 'Overlay color of Header on Home page', 'datebook' ),
		'id' => 'header_gradientcolor_front',
		'std' => 'linear-gradient(to top, transparent 0%, #2a5a8eb5 100%)',
		'type' => 'gradientcolor'
	);

	// Background image in Header
	$background_defaults = array(
		'color' => '#ffffff',
		'image' => DATEBOOK_URL . 'assets/images/welcome-four-people.jpg',
		'repeat' => 'no-repeat',
		'position' => 'top center',
		'attachment' => 'scroll' );

	$options[] = array(
		'name' => esc_html__('Background image in Header on Home page', 'datebook'),
		'desc' => esc_html__('Upload an image that will be placed as background in the header.', 'datebook'),
		'id' => 'header_bg_image_front',
		'std' => $background_defaults,
		'type' => 'background'
	);

	// Background image in Header
	$welcome_background_defaults = array(
		'color' => 'transparent',
		'image' => '',
		'repeat' => 'no-repeat',
		'position' => 'bottom left',
		'attachment' => 'scroll' );

	$options[] = array(
		'name' => esc_html__('Welcome image', 'datebook' ),
		'desc' => esc_html__('Upload an image that will be placed on the Home page.', 'datebook' ),
		'id' => 'welcome_bg_image',
		'std' => $welcome_background_defaults,
		'type' => 'background'
	);

	// Welcome title on Front page
	$options[] = array(
		'name' => esc_html__('Welcome text', 'datebook' ),
		'type' => 'info'
	);

	foreach ( $languages_active_array as $language_key => $language_name ) {

		$options[] = array(
			'name' => sprintf( esc_html__( 'Welcome Slogan (%1$s)', 'datebook' ), $language_name ),
			'id' => 'welcome_slogan_' . $language_key,
			'std' => 'Dating For Mature Singles',
			'class' => 'tiny',
			'type' => 'text');

	}

	$typography_slogan_font = array(
		'size' => '4',
		'color' => '#ffffff',
		'face' => 'engagement' );

	$options[] = array(
		'name' => esc_html__( 'Welcome Slogan: font', 'datebook' ),
		'id' => 'welcome_slogan_font',
		'std' => array_merge($typography_defaults, $typography_slogan_font),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('Welcome Slogan: align', 'datebook' ),
		'id' => 'welcome_slogan_align',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Welcome Slogan: margin', 'datebook' ),
		'id' => 'welcome_slogan_margin',
		'std' => array_merge($margin_defaults, array('margin_top' => '','margin_right' => '','margin_bottom' => '60px','margin_left' => '' )),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Welcome Slogan: padding', 'datebook' ),
		'id' => 'welcome_slogan_padding',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


	$wp_editor_settings = array(
		'wpautop' => true, // Default
		'textarea_rows' => 10,
		'tinymce' => array( 'plugins' => 'wordpress,wplink' )
	);

	foreach ( $languages_active_array as $language_key => $language_name ) {

		$options[] = array(
			'name' => sprintf( esc_html__( 'Welcome message (%1$s)', 'datebook' ), $language_name ),
			'desc' => esc_html__('Write welcome text. It will be shown on the front page. (Example: We are the number one destination for online dating with more dates, more relationships, & more marriages than any other dating or personals site. We can help you find your perfect partner. We offer a bespoke, highly personal service and one of the largest databases of professional singles.)', 'datebook' ),
			'id' => 'welcome_text_' . $language_key,
			'std' => '<h1 style="text-align: center;">Welcome to DateBook!</h1>
<p style="text-align: center;">We are the number one destination for online dating with more dates, more relationships, &amp; more marriages than any other dating or personals site. We can help you find your perfect partner. We offer a bespoke, highly personal service and one of the largest databases of professional singles.</p>',
			'type' => 'editor',
			'settings' => $wp_editor_settings
		);

	}


	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__( 'Overlay color of Header', 'datebook' ),
		'id' => 'header_gradientcolor_other',
		'std' => 'linear-gradient(to top, rgba(0, 93, 255, 0.31) 0%, rgb(0, 116, 249) 100%)',
		'type' => 'gradientcolor'
	);

	$options[] = array(
		'name' => esc_html__('Background image in Header', 'datebook'),
		'desc' => esc_html__('Upload an image that will be placed as background in the header.', 'datebook'),
		'id' => 'header_bg_image_other',
		'std' => $background_defaults,
		'type' => 'background'
	);


///////////////////////////////////////////////////////////////////////////

	$options[] = array(
		'name' => esc_html__('Logo', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Website logo', 'datebook'),
		'desc' => esc_html__('Upload your website logo to go in place of default theme logo.', 'datebook'),
		'id' => 'website_logo_front',
		'std' => DATEBOOK_URL . 'assets/images/logo-front.png',
		'type' => 'upload');

	$options[] = array(
		'name' => esc_html__('Logo position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Logo will be placed', 'datebook' ),
		'id' => 'logo_position_front',
		'std' => 'insidemenu',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/logo-position-1.jpg",
			"inheader" => DATEBOOK_URL . "framework/images/logo-position-2.jpg",
			"insidemenu" => DATEBOOK_URL . "framework/images/logo-position-3.jpg",
			),
		);

	$options[] = array(
		'name' => esc_html__( 'Logo: background color', 'datebook' ),
		'id' => 'logo_bg_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Logo: align', 'datebook' ),
		'id' => 'logo_align_front',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Website logo', 'datebook'),
		'desc' => esc_html__('Upload your website logo to go in place of default theme logo.', 'datebook'),
		'id' => 'website_logo_other',
		'std' => DATEBOOK_URL . 'assets/images/logo.png',
		'type' => 'upload');

	$options[] = array(
		'name' => esc_html__('Logo position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Logo will be placed', 'datebook' ),
		'id' => 'logo_position_other',
		'std' => 'insidemenu',
		'type' => 'images',
		"options" => array(
			'top' => DATEBOOK_URL . 'framework/images/logo-position-1.jpg',
			'inheader' => DATEBOOK_URL . 'framework/images/logo-position-2.jpg',
			'insidemenu' => DATEBOOK_URL . 'framework/images/logo-position-3.jpg',
			)
		);

	$options[] = array(
		'name' => esc_html__( 'Logo: background color', 'datebook' ),
		'id' => 'logo_bg_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Logo: align', 'datebook' ),
		'id' => 'logo_align_other',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Typography', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable custom typography?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_custom_typography',
		'std' => '0',
		'type' => 'checkbox');


	// Body text
	// body {color: #757575; font-family: "Open Sans", Arial, Helvetica, sans-serif; font-size: 13px;	background-color: #eee;}
	$typography_body_text = array(
		'size' => '1',
		'color' => '#757575' );

	$options[] = array( 'name' => esc_html__( 'Main (body) text', 'datebook' ),
		'id' => "typography_body",
		'std' => array_merge($typography_defaults, $typography_body_text),
		'type' => 'typography'
	);

	// Link colors
	// a, .btn-link {color: #455A64; text-decoration: none}
	$options[] = array(
		'name' => esc_html__( 'Link: color', 'datebook' ),
		'id' => 'link_color',
		'std' => '',
		'type' => 'transparentcolor'
	);

	// H1
	// h1, .h1 {font-size: 38px; line-height: 1.28;}
	$typography_h1 = array(
		'size' => '2.375' );

	$options[] = array( 'name' => esc_html__( 'H1 title', 'datebook' ),
		'id' => "typography_h1",
		'std' => array_merge($typography_defaults, $typography_h1),
		'type' => 'typography'
	);

	// H2
	// h2, .h2 {font-size: 30px; line-height: 1.16;}
	$typography_h2 = array(
		'size' => '1.875' );

	$options[] = array( 'name' => esc_html__( 'H2 title', 'datebook' ),
		'id' => "typography_h2",
		'std' => array_merge($typography_defaults, $typography_h2),
		'type' => 'typography'
	);

	// H3
	// h3, .h3 {font-size: 23px; line-height: 1.36;}
	$typography_h3 = array(
		'size' => '1.5' );

	$options[] = array( 'name' => esc_html__( 'H3 title', 'datebook' ),
		'id' => "typography_h3",
		'std' => array_merge($typography_defaults, $typography_h3),
		'type' => 'typography'
	);

	// H4
	// h4, .h4 {font-size: 20px; line-height: 1.16;}
	$typography_h4 = array(
		'size' => '1.25' );

	$options[] = array( 'name' => esc_html__( 'H4 title', 'datebook' ),
		'id' => "typography_h4",
		'std' => array_merge($typography_defaults, $typography_h4),
		'type' => 'typography'
	);

	// H5
	// h5, .h5 {font-size: 16px; line-height: 1.25;}
	$typography_h5 = array(
		'size' => '1' );

	$options[] = array( 'name' => esc_html__( 'H5 title', 'datebook' ),
		'id' => "typography_h5",
		'std' => array_merge($typography_defaults, $typography_h5),
		'type' => 'typography'
	);

	// H6
	// h6, .h6 {font-size: 14px; line-height: 1.16;}
	$typography_h6 = array(
		'size' => '0.875' );

	$options[] = array( 'name' => esc_html__( 'H6 title', 'datebook' ),
		'id' => "typography_h6",
		'std' => array_merge($typography_defaults, $typography_h6),
		'type' => 'typography'
	);
	
	// Lead text
	// .lead {font-size: 16px;}
	$typography_lead = array(
		'size' => '1' );

	$options[] = array( 'name' => esc_html__( 'Lead text', 'datebook' ),
		'id' => "typography_lead",
		'std' => array_merge($typography_defaults, $typography_lead),
		'type' => 'typography'
	);

	// Blockquote
	// blockquote {font-size: 120%;	background-color: #f5f5f5}
	$typography_blockquote = array(
		'size' => '1' );

	$options[] = array( 'name' => esc_html__( 'Blockquote text', 'datebook' ),
		'id' => "typography_blockquote",
		'std' => array_merge($typography_defaults, $typography_blockquote),
		'type' => 'typography'
	);

	// Special colors for text
	// .text-grey {color: #ABABAB;}
	$options[] = array(
		'name' => esc_html__( 'Text: grey', 'datebook' ),
		'id' => 'text_grey',
		'std' => '#ABABAB',
		'type' => 'transparentcolor'
	);

	// .text-green {color: #4caf50;}
	$options[] = array(
		'name' => esc_html__( 'Text: green', 'datebook' ),
		'id' => 'text_green',
		'std' => '#4caf50',
		'type' => 'transparentcolor'
	);

	// .text-brown {color: #9d5106;}
	$options[] = array(
		'name' => esc_html__( 'Text: brown', 'datebook' ),
		'id' => 'text_brown',
		'std' => '#9d5106',
		'type' => 'transparentcolor'
	);

	// .amber-text {color: #FFC107;}
	$options[] = array(
		'name' => esc_html__( 'Text: yellow', 'datebook' ),
		'id' => 'text_yellow',
		'std' => '#FFC107',
		'type' => 'transparentcolor'
	);

	// .text-orange {color: #F57C00;}
	$options[] = array(
		'name' => esc_html__( 'Text: orange', 'datebook' ),
		'id' => 'text_orange',
		'std' => '#F57C00',
		'type' => 'transparentcolor'
	);


//////////////////////////////////////////////////////////////////

	$options[] = array(
		'name' => esc_html__('Styling', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable custom styling?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_custom_styling',
		'std' => '0',
		'type' => 'checkbox');

	// Background Defaults
	// body { background-color: #eee;}
	$background_defaults = array(
		'color' => '#eee',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top center',
		'attachment' => 'scroll' );

	$options[] = array(
		'name' =>  esc_html__( 'Background color', 'datebook' ),
		'desc' => esc_html__( 'Change the background color of website', 'datebook' ),
		'id' => 'background_color',
		'std' => $background_defaults,
		'type' => 'background'
	);

	// Default button
	// .btn-secondary, .label-default, .badge-default {background-color: #EBEEF1; color: #707A81;}
	$options[] = array(
		'name' => esc_html__( 'Button: Default', 'datebook' ),
		'id' => 'btn_default',
		'std' => '#EBEEF1',
		'type' => 'transparentcolor'
	);

	// Primary button
	// .btn-message {font-size: 16px; padding-left: 20px; padding-right: 20px;}
	$options[] = array(
		'name' => esc_html__( 'Button: Primary', 'datebook' ),
		'id' => 'btn_primary',
		'std' => '#2196f3',
		'type' => 'transparentcolor'
	);

	// Message button
	// .btn-message {font-size: 16px; padding-left: 20px; padding-right: 20px;}
	$options[] = array(
		'name' => esc_html__( 'Button: Message', 'datebook' ),
		'id' => 'btn_message',
		'std' => '#2196f3',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Button: shadow', 'datebook' ),
		'id' => 'btn_shadow',
		'std' => '1',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);


	// Color of female icon
	// i.fa-venus, .datebook-countries .datebook-subcountry .fa-venus {color:#E91E63}
	$options[] = array(
		'name' => esc_html__( 'Icon: female', 'datebook' ),
		'id' => 'fa_venus',
		'std' => '#E91E63',
		'type' => 'transparentcolor'
	);

	// Color of male icon
	// i.fa-mars, .datebook-countries .datebook-subcountry .fa-mars {color:#2196F3}
	$options[] = array(
		'name' => esc_html__( 'Icon: male', 'datebook' ),
		'id' => 'fa_mars',
		'std' => '#2196F3',
		'type' => 'transparentcolor'
	);

	// Color of icon in Popover
	// .popover i.fa-venus, .popover i.fa-mars {color:#ffffff}
	$options[] = array(
		'name' => esc_html__( 'Icon: popover', 'datebook' ),
		'id' => 'popover_fa',
		'std' => '#ffffff',
		'type' => 'transparentcolor'
	);

	// Column padding
	// .datebook-padding-less {padding-left: 8px; padding-right: 8px;}
	$options[] = array(
		'name' => esc_html__( 'Column: padding', 'datebook' ),
		'id' => 'column_padding',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


//////////////////////////////////////////////////////////////////


	// Top menu
	$options[] = array(
		'name' => esc_html__('Top menu', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Display Top menu?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'top_menu_enabled_front',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Top menu: position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Top menu will be placed', 'datebook' ),
		'id' => 'top_menu_position_front',
		'std' => 'inside',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/top-menu-position-front-1.jpg",
			"inside" => DATEBOOK_URL . "framework/images/top-menu-position-front-2.jpg")
		);

	$options[] = array(
		'name' => esc_html__('Top menu: align', 'datebook' ),
		'id' => 'top_menu_align_front',
		'std' => 'leftright',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'leftright' => esc_html__('Left and Right', 'datebook' ),
			'centeronside' => esc_html__('Center on Left and Right', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Top menu: font', 'datebook' ),
		'id' => 'top_menu_font_front',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('Top menu: background color', 'datebook' ),
		'id' => 'top_menu_bg_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Top menu toggle: background color', 'datebook' ),
		'id' => 'top_menu_toggler_bg_color_front',
		'std' => '#2f7cbf',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'Top menu: margin', 'datebook' ),
		'id' => 'top_menu_margin_front',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Top menu: padding', 'datebook' ),
		'id' => 'top_menu_padding_front',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Display Top menu?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'top_menu_enabled_other',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Top menu: position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Top menu will be placed', 'datebook' ),
		'id' => 'top_menu_position_other',
		'std' => 'inside',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/top-menu-position-other-1.jpg",
			"inside" => DATEBOOK_URL . "framework/images/top-menu-position-other-2.jpg")
		);

	$options[] = array(
		'name' => esc_html__('Top menu: align', 'datebook' ),
		'id' => 'top_menu_align_other',
		'std' => 'left',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'leftright' => esc_html__('Left and Right', 'datebook' ),
			'centeronside' => esc_html__('Center on Left and Right', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Top menu: font', 'datebook' ),
		'id' => 'top_menu_font_other',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('Top menu: background color', 'datebook' ),
		'id' => 'top_menu_bg_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Top menu toggle: background color', 'datebook' ),
		'id' => 'top_menu_toggler_bg_color_other',
		'std' => '#2f7cbf',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'Top menu: margin', 'datebook' ),
		'id' => 'top_menu_margin_other',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Top menu: padding', 'datebook' ),
		'id' => 'top_menu_padding_other',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


//////////////////////////////////////////////////////////////////


	// Primary menu
	$options[] = array(
		'name' => esc_html__('Primary menu', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Primary menu: position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Primary menu will be placed', 'datebook' ),
		'id' => 'primary_menu_position_front',
		'std' => 'inside',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/primary-menu-position-1.jpg",
			"inside" => DATEBOOK_URL . "framework/images/primary-menu-position-2.jpg")
		);

	$options[] = array(
		'name' => esc_html__('Primary menu: width', 'datebook' ),
		'id' => 'primary_menu_width_front',
		'std' => 'boxed',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'full' => esc_html__('Full width', 'datebook' ),
			'boxed' => esc_html__('Boxed', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Primary menu: align', 'datebook' ),
		'id' => 'primary_menu_align_front',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Primary menu: font', 'datebook' ),
		'id' => 'primary_menu_font_front',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('Menu container: background color', 'datebook' ),
		'id' => 'primary_menu_bg_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu container: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_container_border_round_front',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Menu subcontainer: background color', 'datebook' ),
		'id' => 'primary_menu_subcontainer_bg_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu subcontainer: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_subcontainer_border_round_front',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Menu: background color', 'datebook' ),
		'id' => 'primary_menu_class_bg_color_front',
		'std' => 'rgb(0, 152, 255)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_class_border_round_front',
		'std' => '2.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Primary menu toggle: background color', 'datebook' ),
		'id' => 'primary_menu_toggler_bg_color_front',
		'std' => '#2f7cbf',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'Primary menu: margin', 'datebook' ),
		'id' => 'primary_menu_margin_front',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Primary menu: padding', 'datebook' ),
		'id' => 'primary_menu_padding_front',
		'std' => array_merge($typography_defaults, array(
		'padding_top' => '5px',
		'padding_right' => '10px',
		'padding_bottom' => '5px',
		'padding_left' => '10px' )),
		'type' => 'padding'
	);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Primary menu: position', 'datebook' ),
		'desc' => esc_html__('Select the position where the Primary menu will be placed', 'datebook' ),
		'id' => 'primary_menu_position_other',
		'std' => 'inside',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/primary-menu-position-1.jpg",
			"inside" => DATEBOOK_URL . "framework/images/primary-menu-position-2.jpg")
		);

	$options[] = array(
		'name' => esc_html__('Primary menu: width', 'datebook' ),
		'id' => 'primary_menu_width_other',
		'std' => 'full',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'full' => esc_html__('Full width', 'datebook' ),
			'boxed' => esc_html__('Boxed', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Primary menu: align', 'datebook' ),
		'id' => 'primary_menu_align_other',
		'std' => 'left',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Primary menu: font', 'datebook' ),
		'id' => 'primary_menu_font_other',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('Menu container: background color', 'datebook' ),
		'id' => 'primary_menu_bg_color_other',
		'std' => 'rgba(16, 85, 204, 0.52)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu container: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_container_border_round_other',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Menu subcontainer: background color', 'datebook' ),
		'id' => 'primary_menu_subcontainer_bg_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu subcontainer: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_subcontainer_border_round_other',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Menu: background color', 'datebook' ),
		'id' => 'primary_menu_class_bg_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Menu: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'primary_menu_class_border_round_other',
		'std' => '2.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Primary menu toggle: background color', 'datebook' ),
		'id' => 'primary_menu_toggler_bg_color_other',
		'std' => '#2f7cbf',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'Primary menu: margin', 'datebook' ),
		'id' => 'primary_menu_margin_other',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Primary menu: padding', 'datebook' ),
		'id' => 'primary_menu_padding_other',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


//////////////////////////////////////////////////////////////////


	// User menu
	$options[] = array(
		'name' => esc_html__('User menu', 'datebook' ),
		'type' => 'heading');
	
	$options[] = array(
		'name' => esc_html__('User menu: titles and icons', 'datebook' ),
		'id' => 'display_title_icon_usermenu',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('Titles and icons', 'datebook' ),
			'2' => esc_html__('Titles only', 'datebook' ),
			'3' => esc_html__('Icons only', 'datebook' )
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__( 'Display menu items in Header', 'datebook' ),
		'desc' => esc_html__( 'Select the items that will be placed in the user menu as separate items. All unchecked items will be placed in the submenu.', 'datebook' ),
		'id' => 'user_menu_items_in_header_front',
		'std' => '1,0,1,0,0,0,0,0,0,0,1',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $user_menu_items_array);

	$options[] = array(
		'name' => esc_html__('User menu position', 'datebook' ),
		'desc' => esc_html__('Select the position where the User menu will be placed', 'datebook' ),
		'id' => 'user_menu_position_front',
		'std' => 'underprimarymenu',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/user-menu-position-front-1.jpg",
			"underlogo" => DATEBOOK_URL . "framework/images/user-menu-position-front-2.jpg",
			"inprimarymenu" => DATEBOOK_URL . "framework/images/user-menu-position-front-3.jpg",
			"underprimarymenu" => DATEBOOK_URL . "framework/images/user-menu-position-front-4.jpg",
			"underlast" => DATEBOOK_URL . "framework/images/user-menu-position-front-5.jpg")
		);

	$options[] = array(
		'name' => esc_html__('User menu: align', 'datebook' ),
		'id' => 'user_menu_align_front',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'User menu: font', 'datebook' ),
		'id' => 'user_menu_font_front',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('User menu: background color', 'datebook' ),
		'id' => 'user_menu_bg_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('User menu submenu: background color', 'datebook' ),
		'id' => 'user_menu_toggler_bg_color_front',
		'std' => 'rgba(16, 85, 204, 0.52)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'User menu: margin', 'datebook' ),
		'id' => 'user_menu_margin_front',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'User menu: padding', 'datebook' ),
		'id' => 'user_menu_padding_front',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__( 'Display menu items in Header', 'datebook' ),
		'desc' => esc_html__( 'Select the items that will be placed in the user menu as separate items. All unchecked items will be placed in the submenu.', 'datebook' ),
		'id' => 'user_menu_items_in_header_other',
		'std' => '1,0,1,0,0,0,0,0,0,0,1',
		'method' => 'multinumber',
		'type' => 'multicheck',
		'options' => $user_menu_items_array);

	$options[] = array(
		'name' => esc_html__('User menu position', 'datebook' ),
		'desc' => esc_html__('Select the position where the User menu will be placed', 'datebook' ),
		'id' => 'user_menu_position_other',
		'std' => 'inprimarymenu',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/user-menu-position-other-1.jpg",
			"underlogo" => DATEBOOK_URL . "framework/images/user-menu-position-other-2.jpg",
			"inprimarymenu" => DATEBOOK_URL . "framework/images/user-menu-position-other-3.jpg",
			"underprimarymenu" => DATEBOOK_URL . "framework/images/user-menu-position-other-4.jpg",
			"underlast" => DATEBOOK_URL . "framework/images/user-menu-position-other-5.jpg")
		);

	$options[] = array(
		'name' => esc_html__('User menu: align', 'datebook' ),
		'id' => 'user_menu_align_other',
		'std' => 'right',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'User menu: font', 'datebook' ),
		'id' => 'user_menu_font_other',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	$options[] = array(
		'name' => esc_html__('User menu: background color', 'datebook' ),
		'id' => 'user_menu_bg_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('User menu submenu: background color', 'datebook' ),
		'id' => 'user_menu_toggler_bg_color_other',
		'std' => 'rgba(16, 85, 204, 0.52)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'User menu: margin', 'datebook' ),
		'id' => 'user_menu_margin_other',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'User menu: padding', 'datebook' ),
		'id' => 'user_menu_padding_other',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Panels', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable custom panel styling?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_custom_panels',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Borders: width', 'datebook' ),
		'desc' => 'px',
		'id' => 'panel_border_width',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Borders: style', 'datebook' ),
		'id' => 'panel_border_style',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__('Borders: color', 'datebook' ),
		'id' => 'panel_border_color',
		'std' => '#d1d1d1',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Borders: roundness', 'datebook' ),
		'desc' => 'rem',
		'id' => 'panel_border_round',
		'std' => '0.2',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Header: text color', 'datebook' ),
		'id' => 'panel_header_text_color',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Header: background color', 'datebook' ),
		'id' => 'panel_header_bg_color',
		'std' => '#f5f5f5',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Body: text color', 'datebook' ),
		'id' => 'panel_text_color',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Body: background color', 'datebook' ),
		'id' => 'panel_background_color',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'panel_border_shadow',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	// .card {margin-bottom: 16px;} .card-body {padding: 15px;}
	$options[] = array(
		'name' => esc_html__( 'Margin', 'datebook' ),
		'id' => 'panel_container_margin',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Padding', 'datebook' ),
		'id' => 'panel_container_padding',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Search form', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__( 'Age range: layout', 'datebook' ),
		'desc' => esc_html__( 'For Ion.RangeSlider', 'datebook' ),
		'id' => 'age_range_layout',
		'std' => 'round',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'flat' => esc_html__('Flat', 'datebook'),
			'big' => esc_html__('Big', 'datebook'),
			'modern' => esc_html__('Modern', 'datebook'),
			'round' => esc_html__('Round', 'datebook'),
			'sharp' => esc_html__('Sharp', 'datebook'),
			'square' => esc_html__('Square', 'datebook')
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Layout', 'datebook' ),
		'id' => 'searchform_layout_front',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('Horizontal', 'datebook' ),
			'2' => esc_html__('Vertical', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Display header', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'display_header_search_form_front',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'Age range', 'datebook' ),
		'id' => 'age_range_front',
		'std' => 'ionrangeslider',
		'type' => 'radio',
		"options" => array(
			'ionrangeslider' => esc_html__( 'Ion.RangeSlider', 'datebook' ),
			'selector' => esc_html__( 'Dropdown selector', 'datebook' )
			)
		);

	$options[] = array(
		'name' => esc_html__('Max width', 'datebook' ),
		'desc' => 'enter number with px or %. Example: 50% or 700px',
		'id' => 'searchform_max_width',
		'std' => '350px',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Align', 'datebook' ),
		'id' => 'search_align_front',
		'std' => 'center',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'left' => esc_html__('left', 'datebook' ),
			'center' => esc_html__('center', 'datebook' ),
			'right' => esc_html__('right', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Background color', 'datebook' ),
		'id' => 'gradientcolor_searchform_front',
		'std' => 'linear-gradient(to top, rgba(1, 40, 119, 0.28) 0%, rgba(0, 43, 123, 0.28) 100%)',
		'type' => 'gradientcolor'
	);

	$options[] = array(
		'name' => esc_html__('Gender button: text color', 'datebook' ),
		'id' => 'searchform_gender_color_front',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Gender button: background color', 'datebook' ),
		'id' => 'searchform_gender_bgcolor_front',
		'std' => '#00c851',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Submit button: text color', 'datebook' ),
		'id' => 'searchform_submit_color_front',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Submit button: background color', 'datebook' ),
		'id' => 'searchform_submit_bgcolor_front',
		'std' => 'rgb(0, 152, 255)',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Width of borders', 'datebook' ),
		'desc' => 'px',
		'id' => 'searchform_border_width_front',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Style of borders', 'datebook' ),
		'id' => 'searchform_border_style_front',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__('Color of borders', 'datebook' ),
		'id' => 'searchform_border_color_front',
		'std' => '#9e9e9e',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'searchform_border_round_front',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Color of header text', 'datebook' ),
		'id' => 'searchform_header_text_color_front',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color of header', 'datebook' ),
		'id' => 'searchform_header_bg_color_front',
		'std' => '#f5f5f5',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Color of body text', 'datebook' ),
		'id' => 'searchform_text_color_front',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color of body', 'datebook' ),
		'id' => 'searchform_background_color_front',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'searchform_border_shadow_front',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__( 'Margin', 'datebook' ),
		'id' => 'searchform_margin_front',
		'std' => array_merge($margin_defaults, array('margin_top' => '','margin_right' => '','margin_bottom' => '40px','margin_left' => '' )),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Padding', 'datebook' ),
		'id' => 'searchform_padding_front',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Search page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Search page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Display header', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'display_header_search_form_other',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__( 'Age range', 'datebook' ),
		'id' => 'age_range_other',
		'std' => 'ionrangeslider',
		'type' => 'radio',
		"options" => array(
			'ionrangeslider' => esc_html__( 'Ion.RangeSlider', 'datebook' ),
			'selector' => esc_html__( 'Dropdown selector', 'datebook' )
			)
		);

	$options[] = array(
		'name' => esc_html__('Gender button: text color', 'datebook' ),
		'id' => 'searchform_gender_color_other',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Gender button: background color', 'datebook' ),
		'id' => 'searchform_gender_bgcolor_other',
		'std' => '#33b5e5',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Submit button: text color', 'datebook' ),
		'id' => 'searchform_submit_color_other',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Submit button: background color', 'datebook' ),
		'id' => 'searchform_submit_bgcolor_other',
		'std' => '#0458db',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Width of borders', 'datebook' ),
		'desc' => 'px',
		'id' => 'searchform_border_width_other',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Style of borders', 'datebook' ),
		'id' => 'searchform_border_style_other',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__('Color of borders', 'datebook' ),
		'id' => 'searchform_border_color_other',
		'std' => '#9e9e9e',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'searchform_border_round_other',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Color of header text', 'datebook' ),
		'id' => 'searchform_header_text_color_other',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color of header', 'datebook' ),
		'id' => 'searchform_header_bg_color_other',
		'std' => '#f5f5f5',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Color of body text', 'datebook' ),
		'id' => 'searchform_text_color_other',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color of body', 'datebook' ),
		'id' => 'searchform_background_color_other',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'searchform_border_shadow_other',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__( 'Margin', 'datebook' ),
		'id' => 'searchform_margin_other',
		'std' => array_merge($margin_defaults, array('margin_top' => '','margin_right' => '','margin_bottom' => '15px','margin_left' => '' )),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Padding', 'datebook' ),
		'id' => 'searchform_padding_other',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Profiles on Search', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Style of profile', 'datebook' ),
		'desc' => esc_html__('Profiles can be displayed in different styles.', 'datebook' ),
		'id' => 'style_profile_on_search',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
			'1' => esc_html__( 'Style 1 - full content', 'datebook' ),
			'2' => esc_html__( 'Style 2 - image displayed, content hidden', 'datebook' ),
			'3' => esc_html__( 'Style 3 - image displayed, content hidden', 'datebook' )
	));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable custom styling of profiles on Search page?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_profiles_on_search',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Show the following details', 'datebook' ),
		'id' => 'show_profile_details_on_search',
		'std' => 'comments,images,travel,age,gender,sexorientation,city,country',
		'method' => 'multinumber',
		'type' => 'multicheck',
		"options" => $profile_details_args
	);

	$options[] = array(
		'name' => esc_html__('Profile: width of borders', 'datebook' ),
		'desc' => 'px',
		'id' => 'profiles_on_search_border_width',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Profile: style of borders', 'datebook' ),
		'id' => 'profiles_on_search_border_style',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__('Profile: color of borders', 'datebook' ),
		'id' => 'profiles_on_search_border_color',
		'std' => '#9e9e9e',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Profile: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'profiles_on_search_border_round',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Profile: align of text', 'datebook' ),
		'id' => 'profiles_on_search_text_align',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('Default', 'datebook' ),
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' ),
			'justify' => esc_html__('Justify', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Profile: text color of name', 'datebook' ),
		'id' => 'profiles_on_search_header_text_color',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Profile: text color of other info', 'datebook' ),
		'id' => 'profiles_on_search_text_color',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Profile: background color of body', 'datebook' ),
		'id' => 'profiles_on_search_background_color',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Profile: shadow', 'datebook' ),
		'id' => 'profiles_on_search_border_shadow',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__( 'Profile: margin', 'datebook' ),
		'id' => 'profiles_on_search_margin',
		'std' => array_merge($margin_defaults, $margin_args),
		'type' => 'margin'
	);

	$options[] = array(
		'name' => esc_html__( 'Profile: padding', 'datebook' ),
		'id' => 'profiles_on_search_padding',
		'std' => array_merge($typography_defaults, $padding_args),
		'type' => 'padding'
	);


/////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Featured profiles', 'datebook' ),
		'type' => 'heading');


	$options[] = array(
		'name' => esc_html__('Featured panel: width', 'datebook' ),
		'id' => 'featured_panel_width',
		'std' => 'full',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'full' => esc_html__('Full', 'datebook' ),
			'boxed' => esc_html__('Boxed', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__( 'Featured panel: background color', 'datebook' ),
		'id' => 'featured_panel_color',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Featured panel: top and bottom margin', 'datebook' ),
		'id' => 'featured_panel_topmargin',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'0' => '0 rem',
			'1' => '.25 rem',
			'2' => '.5 rem',
			'3' => '1 rem',
			'4' => '1.5 rem',
			'5' => '3 rem',
		));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Home page', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on Home page', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Style of profile', 'datebook' ),
		'desc' => esc_html__('Profile can be displayed in different styles', 'datebook' ),
		'id' => 'featured_profiles_style_front',
		'std' => '4',
		'type' => 'radio',
		'options' => array(
			'1' => '1. ' . esc_html__( 'Full content', 'datebook' ),
			'2' => '2. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'3' => '3. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'4' => '4. ' . esc_html__( 'Image displayed, content in popover', 'datebook' )
	));

	$options[] = array(
		'name' => esc_html__('Show the following details', 'datebook' ),
		'id' => 'featured_info_front',
		'std' => '1,1,1,1,1,1',
		'method' => 'multinumber',
		'type' => 'multicheck',
		"options" => $profile_details_args
	);

	$options[] = array(
		'name' => esc_html__('Align of text', 'datebook' ),
		'id' => 'featured_text_align_front',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('Default', 'datebook' ),
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' ),
			'justify' => esc_html__('Justify', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Text color of name', 'datebook' ),
		'id' => 'featured_header_text_color_front',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Text color of other info', 'datebook' ),
		'id' => 'featured_body_text_color_front',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color', 'datebook' ),
		'id' => 'featured_background_color_front',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Border: width', 'datebook' ),
		'desc' => esc_html__('Width of image border can be 3 options: 1. enter random numbers separated by a comma. Example: 1,12 = borders will be random width from 1 to 12 pixels. 2. enter one number. Example: 5 = border for all images will be 5px. 3. enter 0 = no borders', 'datebook' ),
		'id' => 'featured_border_width_front',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Border: style', 'datebook' ),
		'id' => 'featured_border_style_front',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__( 'Border: color', 'datebook' ),
		'id' => 'featured_border_color_front',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Border: roundness', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_round_front',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Gamma of colors', 'datebook' ),
		'desc' => esc_html__('Remove Border: color (above) to enable this option', 'datebook' ),
		'id' => 'featured_color_gamma_front',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('None', 'datebook' ),
			'random' => esc_html__('Random', 'datebook' ),
			'light' => esc_html__('Random Light', 'datebook' ),
			'dark' => esc_html__('Random Dark', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'featured_shadow_front',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__('Margin', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_margin_front',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Padding', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_padding_front',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__( 'Other pages', 'datebook' ),
		'desc' => esc_html__( 'Elements displayed on other pages', 'datebook' ),
		'type' => 'info'
	);

	$options[] = array(
		'name' => esc_html__('Style of profile', 'datebook' ),
		'desc' => esc_html__('Profile can be displayed in different styles', 'datebook' ),
		'id' => 'featured_profiles_style_other',
		'std' => '4',
		'type' => 'radio',
		'options' => array(
			'1' => '1. ' . esc_html__( 'Full content', 'datebook' ),
			'2' => '2. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'3' => '3. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'4' => '4. ' . esc_html__( 'Image displayed, content in popover', 'datebook' )
	));

	$options[] = array(
		'name' => esc_html__('Show details', 'datebook' ),
		'id' => 'featured_info_other',
		'std' => '1,1,1,1,1,1',
		'method' => 'multinumber',
		'type' => 'multicheck',
		"options" => $profile_details_args
	);

	$options[] = array(
		'name' => esc_html__('Align of text', 'datebook' ),
		'id' => 'featured_text_align_other',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('Default', 'datebook' ),
			'left' => esc_html__('Left', 'datebook' ),
			'center' => esc_html__('Center', 'datebook' ),
			'right' => esc_html__('Right', 'datebook' ),
			'justify' => esc_html__('Justify', 'datebook' ),
		));

	$options[] = array(
		'name' => esc_html__('Text color of name', 'datebook' ),
		'id' => 'featured_header_text_color_other',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Text color of other info', 'datebook' ),
		'id' => 'featured_body_text_color_other',
		'std' => '#000',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Background color', 'datebook' ),
		'id' => 'featured_background_color_other',
		'std' => '#ffffff',
		'type' => 'transparentcolor');

	$options[] = array(
		'name' => esc_html__('Border: width', 'datebook' ),
		'desc' => esc_html__('Width of image border can be 3 options: 1. enter random numbers separated by a comma. Example: 1,12 = borders will be random width from 1 to 12 pixels. 2. enter one number. Example: 5 = border for all images will be 5px. 3. enter 0 = no borders', 'datebook' ),
		'id' => 'featured_border_width_other',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Border: style', 'datebook' ),
		'id' => 'featured_border_style_other',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__( 'Border: color', 'datebook' ),
		'id' => 'featured_border_color_other',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Border: roundness', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_round_other',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Gamma of colors', 'datebook' ),
		'desc' => esc_html__('Remove Border: color (above) to enable this option', 'datebook' ),
		'id' => 'featured_color_gamma_other',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('None', 'datebook' ),
			'random' => esc_html__('Random', 'datebook' ),
			'light' => esc_html__('Random Light', 'datebook' ),
			'dark' => esc_html__('Random Dark', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'featured_shadow_other',
		'std' => '3',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__('Margin', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_margin_other',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Padding', 'datebook' ),
		'desc' => 'rem',
		'id' => 'featured_padding_other',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Background image in Featured images panel on Profile page', 'datebook'),
		'desc' => esc_html__('Upload an image that will be placed as background in the panel suggesting Featured images on the Profile page.', 'datebook'),
		'id' => 'bg_featured_images_panel',
		'std' => DATEBOOK_URL . 'assets/images/bg-featured-images-panel.jpg',
		'type' => 'upload');

	$options[] = array(
		'name' => esc_html__('Featured background images', 'datebook'),
		'desc' => esc_html__('Upload your patterns for background of Featured profiles. Notice: first, you should upload images then reload this and select uploaded images.', 'datebook'),
		'id' => 'featured_background_images',
		'std' => '',
		'type' => 'multiupload');


/////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Top profiles', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Style of profile', 'datebook' ),
		'desc' => esc_html__('Profile can be displayed in different styles', 'datebook' ),
		'id' => 'top_profiles_style',
		'std' => '2',
		'type' => 'radio',
		'options' => array(
			'1' => '1. ' . esc_html__( 'Full content', 'datebook' ),
			'2' => '2. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'3' => '3. ' . esc_html__( 'Image displayed, content hidden', 'datebook' ),
			'4' => '4. ' . esc_html__( 'Image displayed, content in popover', 'datebook' )
	));

	$options[] = array(
		'name' => esc_html__('Show the following details', 'datebook' ),
		'id' => 'show_top_profile_details',
		'std' => '1,1,1,1,1,1',
		'method' => 'multinumber',
		'type' => 'multicheck',
		"options" => $profile_details_args
	);

	$options[] = array(
		'name' => esc_html__('Roundness of images', 'datebook' ),
		'id' => 'top_round',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('No round', 'datebook' ),
			'2' => esc_html__('Rounded corners', 'datebook' ),
			'3' => esc_html__('Rounded circle', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Width of image border', 'datebook' ),
		'desc' => esc_html__('Width of image border can be 3 options: 1. enter random numbers separated by a comma. Example: 1,12 = borders will be random width from 1 to 12 pixels. 2. enter one number. Example: 5 = border for all images will be 5px. 3. enter 0 = no borders', 'datebook' ),
		'id' => 'top_border_width',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Border style', 'datebook' ),
		'id' => 'top_border_style',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__( 'Color of border', 'datebook' ),
		'id' => 'top_border_color',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Gamma of colors', 'datebook' ),
		'desc' => esc_html__('Remove Color of border (above) to enable this option', 'datebook' ),
		'id' => 'top_color_gamma',
		'std' => 'light',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('None', 'datebook' ),
			'random' => esc_html__('Random', 'datebook' ),
			'light' => esc_html__('Random Light', 'datebook' ),
			'dark' => esc_html__('Random Dark', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'top_shadow',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__('Margin', 'datebook' ),
		'desc' => 'rem',
		'id' => 'top_margin',
		'std' => '.25',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Padding', 'datebook' ),
		'desc' => 'rem',
		'id' => 'top_padding',
		'std' => '0',
		'class' => 'mini',
		'type' => 'text');


/////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Mosaic of profiles', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Enable custom styling of profile mosaic?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'datebook_custom_profiles',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Mosaic of normal profiles: roundness of images', 'datebook' ),
		'id' => 'normal_round_front',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('No round', 'datebook' ),
			'2' => esc_html__('Rounded corners', 'datebook' ),
			'3' => esc_html__('Rounded circle', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Mosaic of normal profiles: images padding', 'datebook' ),
		'id' => 'normal_padding_front',
		'std' => '2',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('0 rem', 'datebook' ),
			'2' => esc_html__('0.25 rem', 'datebook' ),
			'3' => esc_html__('0.5 rem', 'datebook' ),
			'4' => esc_html__('1 rem', 'datebook' ),
			'5' => esc_html__('1.5 rem', 'datebook' ),
			'6' => esc_html__('3 rem', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Mosaic of normal profiles: shadow of images', 'datebook' ),
		'id' => 'normal_shadow_front',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);

	$options[] = array(
		'name' => esc_html__('Mosaic of normal profiles: width of image border', 'datebook' ),
		'desc' => esc_html__('Width of image border can be 3 options: 1. enter random numbers separated by a comma. Example: 1,12 = borders will be random width from 1 to 12 pixels. 2. enter one number. Example: 5 = border for all images will be 5px. 3. enter 0 = no borders', 'datebook' ),
		'id' => 'normal_border_front',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__( 'Mosaic of normal profiles: color of border', 'datebook' ),
		'id' => 'normal_border_color',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Mosaic of normal profiles: gamma of colors', 'datebook' ),
		'desc' => esc_html__('Remove Color of border (above) to enable this option', 'datebook' ),
		'id' => 'normal_color_gamma',
		'std' => 'light',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('None', 'datebook' ),
			'random' => esc_html__('Random', 'datebook' ),
			'light' => esc_html__('Random Light', 'datebook' ),
			'dark' => esc_html__('Random Dark', 'datebook' )
		));


/////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Countries', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Style of countries', 'datebook' ),
		'desc' => esc_html__('Countries can be displayed in different styles', 'datebook' ),
		'id' => 'countries_style',
		'std' => '1',
		'type' => 'radio',
		'options' => array(
			'1' => '1. ' . esc_html__( 'Columns', 'datebook' ),
			'2' => '2. ' . esc_html__( 'List', 'datebook' ),
	));

	$options[] = array('type' => 'hr');

	$options[] = array(
		'name' => esc_html__('Enable custom styling of Countries panel?', 'datebook' ),
		'desc' => esc_html__('Yes', 'datebook' ),
		'id' => 'enable_countries_style',
		'std' => '0',
		'type' => 'checkbox');

	$options[] = array(
		'name' => esc_html__('Roundness of panel', 'datebook' ),
		'id' => 'countries_round',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('No round', 'datebook' ),
			'2' => esc_html__('Rounded corners', 'datebook' ),
			'3' => esc_html__('Rounded circle', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Panel padding', 'datebook' ),
		'id' => 'countries_padding',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'1' => esc_html__('0 rem', 'datebook' ),
			'2' => esc_html__('0.25 rem', 'datebook' ),
			'3' => esc_html__('0.5 rem', 'datebook' ),
			'4' => esc_html__('1 rem', 'datebook' ),
			'5' => esc_html__('1.5 rem', 'datebook' ),
			'6' => esc_html__('3 rem', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Width of panel border', 'datebook' ),
		'desc' => esc_html__('Width of image border can be 3 options: 1. enter random numbers separated by a comma. Example: 1,12 = borders will be random width from 1 to 12 pixels. 2. enter one number. Example: 5 = border for all images will be 5px. 3. enter 0 = no borders', 'datebook' ),
		'id' => 'countries_border_width',
		'std' => '',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Border style', 'datebook' ),
		'id' => 'countries_border_style',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'solid' => 'solid',
			'dashed' => 'dashed',
			'dotted' => 'dotted',
			'double' => 'double',
			'groove' => 'groove',
			'outset' => 'outset',
			'ridge' => 'ridge',
		));

	$options[] = array(
		'name' => esc_html__( 'Color of border', 'datebook' ),
		'id' => 'countries_border_color',
		'std' => '',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__('Gamma of colors', 'datebook' ),
		'desc' => esc_html__('Remove Color of border (above) to enable this option', 'datebook' ),
		'id' => 'countries_color_gamma',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => array(
			'' => esc_html__('None', 'datebook' ),
			'random' => esc_html__('Random', 'datebook' ),
			'light' => esc_html__('Random Light', 'datebook' ),
			'dark' => esc_html__('Random Dark', 'datebook' )
		));

	$options[] = array(
		'name' => esc_html__('Shadow', 'datebook' ),
		'id' => 'countries_shadow',
		'std' => '',
		'type' => 'select',
		'class' => 'mini', //mini, tiny, small
		'options' => $shadow_args
	);


//////////////////////////////////////////////////////////////////

	$options[] = array(
		'name' => esc_html__('Chat', 'datebook' ),
		'type' => 'heading');

	// Chat windows width
	$options[] = array(
		'name' => esc_html__('Chat window: width', 'datebook' ),
		'desc' => esc_html__('Enter width of chat window (numbers only)', 'datebook' ),
		'id' => 'chat_width',
		'std' => '780',
		'class' => 'mini',
		'type' => 'text');

	// Chat windows height
	$options[] = array(
		'name' => esc_html__('Chat window: height', 'datebook' ),
		'desc' => esc_html__('Enter height of chat window (numbers only)', 'datebook' ),
		'id' => 'chat_height',
		'std' => '520',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Mobile: list of users', 'datebook' ),
		'desc' => esc_html__('Select the layout how to display users', 'datebook' ),
		'id' => 'chat_sidebar_layout_mobile',
		'std' => 'top',
		'type' => 'images',
		"options" => array(
			"top" => DATEBOOK_URL . "framework/images/logo-position-2.jpg",
			"sidebar" => DATEBOOK_URL . "framework/images/logo-position-1.jpg"
			)
		);

	$options[] = array(
		'name' => esc_html__( 'Mobile: display the following details in sidebar', 'datebook' ),
		'desc' => esc_html__( 'Select the items that will be placed in the user menu as separate items. All unchecked items will be placed in the submenu.', 'datebook' ),
		'id' => 'chat_sidebar_details_mobile',
		'std' => '',
		'method' => 'multinumber',
		'type' => 'multicheck',
		"options" => array(
			"name" => esc_html__( 'Name', 'datebook' ),
			"age" => esc_html__( 'Age', 'datebook' ),
			"city" => esc_html__( 'City', 'datebook' ),
			"country" => esc_html__( 'Country', 'datebook' )
		)
	);

	$options[] = array(
		'name' => esc_html__( 'Chat sidebar: background color', 'datebook' ),
		'id' => 'chat_sidebar_bg_color',
		'std' => 'rgba(0,115,225,1)',
		'type' => 'transparentcolor'
	);

	$options[] = array(
		'name' => esc_html__( 'Chat sidebar: font', 'datebook' ),
		'id' => 'chat_sidebar_font',
		'std' => array_merge($typography_defaults, $header_menu_args),
		'type' => 'typography'
	);

	// Chat windows height
	$options[] = array(
		'name' => esc_html__('Chat text field: maximum width', 'datebook' ),
		'desc' => '%',
		'id' => 'chat_text_field_width',
		'std' => '80',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__('Chat text field: roundness of borders', 'datebook' ),
		'desc' => 'rem',
		'id' => 'chat_text_border_round',
		'std' => '0.8',
		'class' => 'mini',
		'type' => 'text');

	$options[] = array(
		'name' => esc_html__( 'Emoji icons', 'datebook' ),
		'desc' => $emoji_symbols,
		'type' => 'info'
	);

	$emoji_encoded_icons = base64_encode(json_encode($emoji_symbols));

	$options[] = array(
		'name' => esc_html__( 'Emoji icons', 'datebook' ),
		'desc' => esc_html__('Copy and paste any of emoji above here', 'datebook' ) . '. ' . esc_html__('You may paste your emoji from other sources', 'datebook' ) . '.',
		'id' => 'emoji_icons',
		'std' => $emoji_encoded_icons,
		'class' => 'small', //mini, tiny, small
		'type' => 'textarea_emoji');

	// Gradient color of popup new message
	$options[] = array(
		'name' => esc_html__( 'Popup notification: background color', 'datebook' ),
		'id' => 'popup_notification_bg_color',
		'std' => 'linear-gradient(to right bottom, rgb(23, 255, 61) 0%, rgb(255, 246, 18) 100%)',
		'type' => 'gradientcolor'
	);



//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('SEO', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Title on profile page', 'datebook' ),
		'desc' => esc_html__('Title of profile page displayed in the browser title. Enter shortcodes in order you want', 'datebook' ) . ': [datebook_profile_name], [datebook_profile_age], [datebook_profile_city], [datebook_profile_country]',
		'id' => 'title_profile_page',
		'std' => '[datebook_profile_name], [datebook_profile_age], [datebook_profile_city], [datebook_profile_country]',
		'class' => 'tiny',
		'type' => 'text');


//////////////////////////////////////////////////////////////////


	$options[] = array(
		'name' => esc_html__('Email', 'datebook' ),
		'type' => 'heading');

	$options[] = array(
		'name' => esc_html__('Logo in email message', 'datebook'),
		'desc' => esc_html__('Upload your website logo to go in place of default theme logo.', 'datebook'),
		'id' => 'logo_email',
		'std' => DATEBOOK_URL . 'assets/images/logo-email.png',
		'type' => 'upload');
		

	return $options;

}


/**
 * Get Color Schemes list
 *
 * @return array
 */
function datebook_get_color_schemes_plugin() {
	
	$datebook_color_array = array();
	$datebook_color_array[] = esc_html__('Default', 'datebook' );
	
	$files = glob( DATEBOOK_DIR . 'assets/css/colors/' . '/*.css' );

	foreach ( $files as $file ) {

		$fileParts = pathinfo( $file );

		$datebook_color_array[] = substr( $fileParts[ 'basename' ], 0, strpos( $fileParts[ 'basename' ], '.' ) );

	}

	sort( $datebook_color_array );
		
	return $datebook_color_array;

}
