<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Header_Class
 *
 * @class DateBook_Header_Class
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Header_Class {

	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 2.0
	 * @access public
	 */
	public static function init() {

		if(isset(self::$datebook_options['what_pagebuilder_for_profile']) && self::$datebook_options['what_pagebuilder_for_profile'] > 1 || is_admin()) {
			add_action( 'template_redirect', array( __CLASS__, 'process_before_get_header') );
		} else {
			add_action( 'get_header', array( __CLASS__, 'process_before_get_header') );
		}

	}


	/**
	 * Show profile on Single Profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_before_get_header() {

		// Detect ajax request
		$_SERVER_HTTP_X_REQUESTED_WITH = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && !empty($_SERVER['HTTP_X_REQUESTED_WITH']) ? strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) : '';

		// Detect page ID
		$page_id = DATEBOOK_PAGE_ID;

		$is_super_admin = is_super_admin() ? 1 : 0;

		if ($is_super_admin == 1) {

			do_action('datebook_administrator_header');

			$profile_id = DATEBOOK_PROFILE_ID;
			$user_id = DATEBOOK_USER_ID;
			$post_type = DATEBOOK_PROFILE_TYPE;

			if ($post_type == DATEBOOK_POST_TYPE){

				if (isset($_POST['action']) && $_POST['action'] == 'delete_profile') {

					// Delete profile account
					DateBook_Administrator_Panel::delete_profile($profile_id, $user_id);

				}

				$datebook_replace_user_by_admin = DateBook_Utilities::datebook_replace_user_by_admin($user_id, 0);

			}
		}


		if (isset($_GET['verifyemail']) || isset($_GET['verifynewemail'])) {
			do_action('datebook_check_validated_email');
		}


		if (!is_user_logged_in()) {

			// Check if not registered users may access the Search and Profile pages
			$allow_notregistered_users = isset(self::$datebook_options['allow_notregistered_users']) ? self::$datebook_options['allow_notregistered_users'] : of_get_option('allow_notregistered_users');

			$pages_of_get_option = array(
				self::$datebook_options['my_edit_profile_page'], 
				self::$datebook_options['my_messages_page'], 
				self::$datebook_options['my_photos_page'], 
				self::$datebook_options['my_comments_page'], 
				self::$datebook_options['my_tours_page'], 
				self::$datebook_options['my_verification_page'], 
				self::$datebook_options['my_friends_page'], 
				self::$datebook_options['my_blacklist_page'], 
				self::$datebook_options['my_favorites_page'], 
				self::$datebook_options['my_classifieds_page'], 
				self::$datebook_options['my_views_page'], 
				self::$datebook_options['my_settings_page'], 
				self::$datebook_options['my_privacy_page'], 
				self::$datebook_options['my_upgrade_page'], 
				self::$datebook_options['my_cart_page'], 
				self::$datebook_options['my_checkout_page'], 
				self::$datebook_options['my_notification_page']
			);

			$search_results_page = isset(self::$datebook_options['search_results_page']) ? self::$datebook_options['search_results_page'] : of_get_option('search_results_page');
			if (($page_id == $search_results_page && $allow_notregistered_users['1'] == 1) || 
			(get_post_type() == DATEBOOK_POST_TYPE && is_single() && $allow_notregistered_users['2'] == 1) || 
			($page_id != 0 && in_array($page_id, $pages_of_get_option))){

				do_action('datebook_currentuser_check_login', $page_id);

			}

		} else if (is_user_logged_in()) {

			// Check if not subscribed users may access the Search and Profile pages
			global $post;

			if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
				$current_user_id = DATEBOOK_CURRENT_USER_ID;
			} else {
				global $current_user;
				wp_get_current_user();
				$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
			}
			
			$my_messages_page = isset(self::$datebook_options['my_messages_page']) ? self::$datebook_options['my_messages_page'] : of_get_option('my_messages_page');
			$my_favorites_page = isset(self::$datebook_options['my_favorites_page']) ? self::$datebook_options['my_favorites_page'] : of_get_option('my_favorites_page');
			$my_blacklist_page = isset(self::$datebook_options['my_blacklist_page']) ? self::$datebook_options['my_blacklist_page'] : of_get_option('my_blacklist_page');

			if(($_SERVER_HTTP_X_REQUESTED_WITH == 'xmlhttprequest' && isset($_REQUEST['action']) && $_REQUEST['action'] == 'datebook_message_actions') || ($page_id == $my_messages_page || $page_id == $my_favorites_page || $page_id == $my_blacklist_page)){
				do_action('datebook_ajax_messages');
			}

			$my_photos_page = isset(self::$datebook_options['my_photos_page']) ? self::$datebook_options['my_photos_page'] : of_get_option('my_photos_page');
			if ($page_id == $my_photos_page) {
				do_action('datebook_ajax_photos');
			}

			$enable_verification = isset(self::$datebook_options['enable_verification']) ? (self::$datebook_options['enable_verification'] == 1 ? 1 : 0) : (of_get_option('enable_verification') ? 1 : 0);
			if ($enable_verification == '1') {
				$my_verification_page = isset(self::$datebook_options['my_verification_page']) ? self::$datebook_options['my_verification_page'] : of_get_option('my_verification_page');	
				if ($page_id == $my_verification_page) {
				
					do_action('datebook_ajax_verification');
				}
			}

			$enable_profile_tours = isset(self::$datebook_options['enable_profile_tours']) ? (self::$datebook_options['enable_profile_tours'] == 1 ? 1 : 0) : (of_get_option('enable_profile_tours') ? 1 : 0);
			if ($enable_profile_tours == 1) {
				$my_tours_page = isset(self::$datebook_options['my_tours_page']) ? self::$datebook_options['my_tours_page'] : of_get_option('my_tours_page');
				if ($page_id == $my_tours_page) {
					do_action('datebook_ajax_tour');
				}
			}

			$my_edit_profile_page = isset(self::$datebook_options['my_edit_profile_page']) ? self::$datebook_options['my_edit_profile_page'] : of_get_option('my_edit_profile_page');
			if ($page_id == $my_edit_profile_page) {
				do_action('datebook_profile_process');
			}

			$my_settings_page = isset(self::$datebook_options['my_settings_page']) ? self::$datebook_options['my_settings_page'] : of_get_option('my_settings_page');
			if ($page_id == $my_settings_page) {
				do_action('datebook_register_process');
			}

			$my_privacy_page = isset(self::$datebook_options['my_privacy_page']) ? self::$datebook_options['my_privacy_page'] : of_get_option('my_privacy_page');
			if ($page_id == $my_privacy_page) {
				do_action('datebook_privacy_process');
			}

			$enable_friendship = isset(self::$datebook_options['enable_friendship']) ? (self::$datebook_options['enable_friendship'] == 1 ? 1 : 0) : (of_get_option('enable_friendship') ? 1 : 0);
			if ($enable_friendship == '1') {
				$my_friends_page = isset(self::$datebook_options['my_friends_page']) ? self::$datebook_options['my_friends_page'] : of_get_option('my_friends_page');
				if ($page_id == $my_friends_page) {
					do_action('datebook_ajax_friends');
				}
			}


			// Check if Payment and Subscription are activated. If not then redirect to Subscription page
			if ($is_super_admin == 0) {
				DateBook_Utilities::check_profile_statuses_in_header($page_id, $current_user_id);
			}

		}

		// Process all Subscription insertions, checking, accepting payments
		if (isset($_POST['action']) && $_POST['action'] == 'payment_page' && $_POST['payment_page'] == '3' && (isset( $_REQUEST['datebooktkn'] ) && wp_verify_nonce( $_REQUEST['datebooktkn'], 'datebook_new_subscription_form_nonce'))){
			do_action('datebook_redirect_subscription_to_gateway');
		}
		

		$my_upgrade_page = isset(self::$datebook_options['my_upgrade_page']) ? self::$datebook_options['my_upgrade_page'] : of_get_option('my_upgrade_page');
		$search_results_page = isset(self::$datebook_options['search_results_page']) ? self::$datebook_options['search_results_page'] : of_get_option('search_results_page');

		$login_page = isset(self::$datebook_options['login_page']) ? self::$datebook_options['login_page'] : of_get_option('login_page');
		$forgot_password_page = isset(self::$datebook_options['forgot_password_page']) ? self::$datebook_options['forgot_password_page'] : of_get_option('forgot_password_page');
		$registration_page = isset(self::$datebook_options['registration_page']) ? self::$datebook_options['registration_page'] : of_get_option('registration_page');
		if (isset($_POST['whatisit']) && $_POST['whatisit'] == 'paystack_confirm_payment' && $page_id == $my_upgrade_page) {

			do_action('datebook_paystack_confirm_payment');

		} else if (isset($_GET['whatisit']) && $_GET['whatisit'] == 'activate-topfeatured' && ($page_id == $my_upgrade_page || $page_id == $search_results_page)) {

			do_action('datebook_ajax_activate_top');

		} else if ($page_id == $login_page || $page_id == $forgot_password_page) {

			do_action('datebook_login_out');
			do_action('datebook_auth_and_redirect_messages');

		} else if ($page_id == $registration_page) {

			do_action('datebook_register_process');
			do_action('datebook_auth_and_redirect_messages');

		}



		// Ajax requests
		if(is_singular(DATEBOOK_POST_TYPE) || $_SERVER_HTTP_X_REQUESTED_WITH == 'xmlhttprequest'){

			if (isset($_GET['action']) && $_GET['action'] == 'datebook_ajax_actions' && isset($_GET['whatisit']) && ($_GET['whatisit'] == 'cities' || $_GET['whatisit'] == 'countries')){

				do_action('datebook_ajax_search');

			} else if (isset($_GET['action']) && $_GET['action'] == 'datebook_ajax_actions' && isset($_GET['whatisit']) && ($_GET['whatisit'] == 'emailcheck' || $_GET['whatisit'] == 'logincheck')){

				// Check if email or username exists via ajax
				add_action('wp_loaded', DateBook_Profile_Settings::process_ajax_settings());

			} else if (isset($_GET['action']) && $_GET['action'] == 'datebook_ajax_buttons_profile'){

				// process Favorite via ajax
				add_action('wp_loaded', DateBook_Profile_Friends::ajax_set_buttons_on_profile());

			}
		}
	}


}

//DateBook_Header_Class::init();
$dateBook_header_class = new DateBook_Header_Class($datebook_options_array);