<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Menu
 *
 * @class DateBook_Menu
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Menu {

	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_header_menu', array( __CLASS__, 'echo_user_menu' ) );

		add_shortcode( 'datebook_quantity_registered_users', array( __CLASS__, 'pre_quantity_registered_users' ) );
		add_shortcode( 'datebook_user_menu', array( __CLASS__, 'pre_return_user_menu' ) );

	}



	/**
	 * Return quantity of registered users
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_quantity_registered_users($atts = array()) {

		if (of_get_option('quantity_registered_members') == '1') {

			$is_shortcode = (!empty($atts) && is_array($atts) ? 1 : isset($atts['shortcode']) && $atts['shortcode'] == 1) ? 0 : 1;

			$shortcode_style = isset($atts['style']) ? $atts['style'] : '';
			$shortcode_size = isset($atts['size']) ? $atts['size'] : 0;

			$options = array('shortcode' => $is_shortcode, 'style' => $shortcode_style, 'size' => $shortcode_size);

			// display the quantity of registered users
			return DateBook_Template_Loader::load( 'misc/quantity-registered-users', $options );

		}
	}


	/**
	 * Show quantity of registered users
	 *
	 * @access public
	 * @return void
	 */
	public static function quantity_registered_users() {
		
		$atts = array('shortcode' => 0);

		// display Top Ad profiles
		echo self::pre_quantity_registered_users($atts);

	}


	/**
	 * Return profile menu
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_return_user_menu($atts = array()) {

		$is_shortcode = !empty($atts) && is_array($atts) ? 1 : 0;
		$shortcode_used = isset($atts['shortcode']) && $atts['shortcode'] == 'no' ? 0 : 1; // 0, 1
		$shortcode_showtitle = of_get_option('display_title_icon_usermenu') == 1 || of_get_option('display_title_icon_usermenu') == 2 ? 1 : 0; // 0, 1
		$shortcode_showicon = of_get_option('display_title_icon_usermenu') == 1 || of_get_option('display_title_icon_usermenu') == 3 ? 1 : 0; // 0, 1
		$shortcode_color = isset($atts['color']) ? $atts['color'] : '';
		$shortcode_tooltip = isset($atts['tooltip']) ? $atts['tooltip'] : 1; // 0, 1
		$shortcode_style = isset($atts['style']) ? $atts['style'] : 1; // 1, 2, 3
		$shortcode_variant = isset($atts['variant']) ? $atts['variant'] : 1; // 1, 2
		$shortcode_space = isset($atts['space']) ? $atts['space'] : 1; // 0, 1, 2
		if(is_front_page() && of_get_option('user_menu_align_front')){
			$shortcode_align = of_get_option('user_menu_align_front');
		} else if(!is_front_page() && of_get_option('user_menu_align_other')){
			$shortcode_align = of_get_option('user_menu_align_other');
		} else {
			$shortcode_align = 'center';
		}
		$shortcode_direction = isset($atts['direction']) ? $atts['direction'] : 'horizontal'; // horizontal, vertical

		$options = array(
			'shortcode' => $is_shortcode, 
			'shortcode_used' => $shortcode_used, 
			'showtitle' => $shortcode_showtitle,
			'showicon' => $shortcode_showicon,
			'color' => $shortcode_color,
			'tooltip' => $shortcode_tooltip, 
			'style' => $shortcode_style, 
			'variant' => $shortcode_variant, 
			'space' => $shortcode_space, 
			'align' => $shortcode_align, 
			'direction' => $shortcode_direction
		);

	    // display the Edit Profile form
		return DateBook_Template_Loader::load( 'misc/profile-menu', $options );

	}


	/**
	 * Return profile menu
	 *
	 * @access public
	 * @return void
	 */
	public static function return_user_menu(){

		$atts = array('shortcode' => 0);

		// display User menu
		return self::pre_return_user_menu($atts);

	}


	/**
	 * Show profile menu
	 *
	 * @access public
	 * @return void
	 */
	public static function echo_user_menu(){

		// display User menu
		echo self::return_user_menu();

	}


	/**
	 * Return profile menu in Theme Header
	 *
	 * @access public
	 * @return void
	 */
	public static function process_profile_bar() {
		
	    // display the Edit Profile form
		return DateBook_Template_Loader::load( 'misc/profile-bar' );

	}


	/**
	 * Show profile menu in Theme Header
	 *
	 * @access public
	 * @return void
	 */
	public static function process_header_menu() {
		
	    // display the Edit Profile form
		echo self::process_profile_bar();

	}


}

//DateBook_Menu::init();
$dateBook_menu_class = new DateBook_Menu($datebook_options_array);