<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Page_Tours
 *
 * @class DateBook_Page_Tours
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Page_Tours {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_show_tours', array( __CLASS__, 'datebook_show_tours_page' ) );
		add_action( 'datebook_single_tour', array( __CLASS__, 'datebook_show_single_tour' ) );
		add_action( 'datebook_welcome_message_tour', array( __CLASS__, 'datebook_show_welcome_message' ) );

		add_action( 'datebook_search_tours_form', array( __CLASS__, 'datebook_show_search_tours' ) );
		add_shortcode( 'datebook_search_form_tours', array( __CLASS__, 'return_search_tours' ) );

		add_action( 'datebook_all_tours', array( __CLASS__, 'datebook_show_all_tours' ) );
		add_shortcode( 'datebook_all_tours', array( __CLASS__, 'datebook_return_all_tours' ) );

		add_shortcode( 'datebook_add_tour_action_panel', array( __CLASS__, 'return_add_tour' ) );

		add_action( 'datebook_add_tour_panel', array( __CLASS__, 'datebook_show_add_tour' ) );

	}


	/**
	 * Send message to user
	 *
	 * @access private
	 * @return void
	 */
	private static function datebook_send_message_to_profile() {

		if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
			exit();
		}

		if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
			$current_user_id = DATEBOOK_CURRENT_USER_ID;
		} else {
			global $current_user;
			wp_get_current_user();
			$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
		}

		$currentauth = get_userdata($current_user_id);

		// Someone sends a message to another user
		if (isset($_POST['action']) && $_POST['action'] == 'contacting' && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {
			
			if ($_POST['emails']) { $datebook_alert_error += 1; }
			
			if (is_user_logged_in()) {
				$contacting_name = $currentauth->display_name;
				$contacting_email = $currentauth->user_email;
			} else {
				$contacting_name = sanitize_text_field(wp_strip_all_tags($_POST['contacting_name']));
				if (!$contacting_name) {
					$datebook_alert_error += 1;
					$datebook_alert_error_text .= esc_html__( 'Your name is missing', 'datebook' );
				}
				
				$contacting_email = sanitize_email($_POST['contacting_email']);
				if ($contacting_email) {
					if ( !is_email($contacting_email) ) {
						$datebook_alert_error += 1;
						$datebook_alert_error_text .= esc_html__( 'Your email address seems to be wrong', 'datebook' );
					}
				} else {
					$datebook_alert_error += 1;
					$datebook_alert_error_text .= esc_html__( 'Your email is missing', 'datebook' );
				}
				
			}
			
			$contacting_text = wp_strip_all_tags($_POST['contacting_text']);
			if (!$contacting_text) {
				$datebook_alert_error += 1;
				$datebook_alert_error_text .= esc_html__( 'You need to write a message', 'datebook' );
			}
			
			if (!isset($datebook_alert_error) && $datebook_alert_error <= 0) {
				
				$get_day_from_code = DATEBOOK_PURCHASE_CODE;
				$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

				if($get_day_from_code != DateBook_Utilities::get_current_day()){
					exit();
				}
				
				$select_email_template = 'reply_to_classifieds_to_profile';
				include DateBook_Template_Loader::locate( 'misc/email-templates' );
				
				$datebook_mail = DateBook_Utilities::datebook_email_send($contacting_name, $contacting_email, get_the_author_meta(user_email), esc_html__( 'Contact message from', 'datebook' ) . ' ' . of_get_option('email_sitename'), $body);

				unset($contacting_name, $contacting_email, $contacting_text, $body);
				
				$alert_success = 1;
				$alert_success_text = esc_html__( 'Your message has been sent', 'datebook' );
				
			}

		}
	}


	/**
	 * Show tour details on Single Tour page
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_show_single_tour() {
		
		// display the Edit Profile form
		echo DateBook_Template_Loader::load( 'tours/single-tour' );
		
	}


	/**
	 * Show welcome panel on Tours page
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_show_welcome_message() {
		
		// display the Edit Profile form
		echo DateBook_Template_Loader::load( 'tours/welcome-text' );
		
	}


	/**
	 * Return search form
	 *
	 * @access public
	 * @return void
	 */
	public static function return_search_tours() {

		global $datebook_field_titles;
		set_query_var( 'datebook_field_titles', $datebook_field_titles );

		return DateBook_Template_Loader::load( 'tours/search-form' );
		
	}


	/**
	 * Show search form
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_show_search_tours() {

		echo self::return_search_tours();
		
	}


	/**
	 * Return All Tours
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_return_all_tours() {
		
		// get All tours
		return DateBook_Template_Loader::load( 'tours/all-tours' );
		
	}


	/**
	 * Show All Tours on Tours page
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_show_all_tours() {
		
		// display All tours
		echo self::datebook_return_all_tours();
		
	}


	/**
	 * Return Add Tour action panel
	 *
	 * @access public
	 * @return void
	 */
	public static function return_add_tour() {

		return DateBook_Template_Loader::load( 'tours/add-tour-panel' );

	}


	/**
	 * Show Add Tour on Tours page
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_show_add_tour() {

		echo self::return_add_tour();

	}


	/**
	 * Show tours on Tours page
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_show_tours_page() {

		if (isset($_POST['action']) && $_POST['action'] == 'contacting') {

			self::datebook_send_message_to_profile();

		}

		// display tours
		echo DateBook_Template_Loader::load( 'tours/page-tours' );

	}

}

//DateBook_Page_Tours::init();
$dateBook_page_tours_class = new DateBook_Page_Tours($datebook_options_array);