<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Pages
 *
 * @class DateBook_Pages
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Pages {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 2.0
	 * @access public
	 */
	public static function init() {
		
		add_action( 'datebook_single_profile_page', array( __CLASS__, 'process_single_profile' ) );
		add_action( 'datebook_single_classifieds_page', array( __CLASS__, 'process_single_classifieds' ) );
		add_action( 'datebook_single_tour_page', array( __CLASS__, 'process_single_tour' ) );
		add_action( 'datebook_all_pages', array( __CLASS__, 'process_all_pages' ) );
		add_action( 'datebook_classified_category', array( __CLASS__, 'process_classified_category_page' ) );

		add_action( 'datebook_profile_type', array( __CLASS__, 'process_profile_type_page' ) );

		add_shortcode( 'datebook_profile_messages', array( __CLASS__, 'return_profile_messages' ) );
		add_shortcode( 'datebook_profile_edit', array( __CLASS__, 'return_profile_edit' ) );
		add_shortcode( 'datebook_profile_photos', array( __CLASS__, 'return_profile_photos' ) );
		add_shortcode( 'datebook_profile_verification', array( __CLASS__, 'return_profile_verification' ) );
		add_shortcode( 'datebook_profile_friends', array( __CLASS__, 'return_profile_friends' ) );
		add_shortcode( 'datebook_profile_favorites', array( __CLASS__, 'return_profile_favorites' ) );
		add_shortcode( 'datebook_profile_blacklist', array( __CLASS__, 'return_profile_blacklist' ) );
		add_shortcode( 'datebook_profile_comments', array( __CLASS__, 'return_profile_comments' ) );
		add_shortcode( 'datebook_profile_classifieds', array( __CLASS__, 'return_profile_classifieds' ) );
		add_shortcode( 'datebook_profile_tours', array( __CLASS__, 'return_profile_tours' ) );
		add_shortcode( 'datebook_profile_who_viewed_me', array( __CLASS__, 'return_profile_who_viewed_me' ) );
		add_shortcode( 'datebook_profile_settings', array( __CLASS__, 'return_profile_settings' ) );
		add_shortcode( 'datebook_profile_privacy', array( __CLASS__, 'return_profile_privacy' ) );
		add_shortcode( 'datebook_profile_subscriptions', array( __CLASS__, 'return_profile_subscriptions' ) );
		add_shortcode( 'datebook_profile_cart', array( __CLASS__, 'return_profile_cart' ) );
		add_shortcode( 'datebook_profile_checkout', array( __CLASS__, 'return_profile_checkout' ) );
		add_shortcode( 'datebook_profile_notifications', array( __CLASS__, 'return_profile_notifications' ) );

	}


	/**
	 * Show profile on Single Profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_single_profile() {

		echo DateBook_Template_Loader::load( 'pages/page-single-profile' );

	}


	/**
	 * Show profile on Single Profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_single_classifieds() {

		echo DateBook_Template_Loader::load( 'pages/page-single-classifieds' );

	}


	/**
	 * Show profile on Single Profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_single_tour() {

		echo DateBook_Template_Loader::load( 'pages/page-single-tour' );

	}


	/**
	 * Return all profile inside pages
	 *
	 * @access public
	 * @return void
	 */
	public static function return_all_profile_pages($inside_page){

		if (is_user_logged_in()) {

			$options = array('inside_page' => $inside_page);

			return DateBook_Template_Loader::load( 'pages/page-profile-edit', $options );

		}
	}
	
	
	/**
	 * Return profile inside page: messages
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_messages($atts = array()) {

		if (is_user_logged_in()) {

			$is_shortcode = !empty($atts) && is_array($atts) ? 1 : 0;
			$shortcode_border_width = isset($atts['border_width']) ? $atts['border_width'] : 0; // 0, 1
			$shortcode_border_color = isset($atts['border_color']) ? $atts['border_color'] : 0; // 0, random, #FF6600
			$shortcode_border_style = isset($atts['border_style']) ? $atts['border_style'] : 0; // 0, 1
			$shortcode_shadow = isset($atts['shadow']) ? $atts['shadow'] : 0; // 0, 1, 2, 3
			$shortcode_space = isset($atts['space']) ? $atts['space'] : 0; // 0, 1

			$options = array(
				'shortcode' => $is_shortcode, 
				'border_width' => $shortcode_border_width, 
				'border_color' => $shortcode_border_color, 
				'border_style' => $shortcode_border_style, 
				'shadow' => $shortcode_shadow
			);

			return self::return_all_profile_pages('messages', $options);

		}
	}


	/**
	 * Return profile inside page: edit profile
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_edit() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('edit_profile');

		}
	}


	/**
	 * Return profile inside page: photos
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_photos() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('photos');

		}
	}


	/**
	 * Return profile inside page: verification
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_verification() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('verification');

		}
	}


	/**
	 * Return profile inside page: friends
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_friends() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('friends');

		}
	}


	/**
	 * Return profile inside page: favorites
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_favorites() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('favorites');

		}
	}


	/**
	 * Return profile inside page: blacklist
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_blacklist($atts = array()) {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('blacklist');

		}
	}


	/**
	 * Return profile inside page: comments
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_comments() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('comments');

		}
	}


	/**
	 * Return profile inside page: classifieds
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_classifieds() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('classifieds');

		}
	}


	/**
	 * Return profile inside page: tours
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_tours() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('tours');

		}
	}


	/**
	 * Return profile inside page: who viewed me
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_who_viewed_me() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('who_viewed_me');

		}
	}


	/**
	 * Return profile inside page: settings
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_settings() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('settings');

		}
	}


	/**
	 * Return profile inside page: privacy
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_privacy() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('privacy');

		}
	}


	/**
	 * Return profile inside page: subscriptions
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_subscriptions() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('subscriptions');

		}
	}


	/**
	 * Return profile inside page: cart
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_cart() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('cart');

		}
	}


	/**
	 * Return profile inside page: checkout
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_checkout() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('checkout');

		}
	}


	/**
	 * Return profile inside page: notifications
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_notifications() {

		if (is_user_logged_in()) {

			return self::return_all_profile_pages('notifications');

		}
	}


	/**
	 * Determine which page is being requested, and select a special master template
	 *
	 * @access public
	 * @return void
	 */
	public static function process_all_pages() {
		
		$page_id = get_the_ID();
		
		$options = array('page_id' => $page_id);

		get_header();

		if (is_front_page()) {

			//$replace_front_page = of_get_option('replace_front_page_by_this_page') > 0 ? of_get_option('replace_front_page_by_this_page') : 0;

			//$replace_front_page = $replace_front_page > 0 ? (is_front_page() && is_user_logged_in() ? 1 : 0) : 0;

			//if ($replace_front_page == 1) {

				//echo DateBook_Template_Loader::load( 'pages/page-single-profile', $options );

			//} else {
				
				echo DateBook_Template_Loader::load( 'pages/page-home', $options );
				
			//}

		} else if ($page_id == of_get_option('login_page') || $page_id == of_get_option('forgot_password_page') || $page_id == of_get_option('registration_page')) {

			echo DateBook_Template_Loader::load( 'pages/page-login-register', $options );

		} else if (is_user_logged_in() && (
			$page_id == of_get_option('my_edit_profile_page') || 
			$page_id == of_get_option('my_messages_page') || 
			$page_id == of_get_option('my_photos_page') || 
			$page_id == of_get_option('my_comments_page') || 
			$page_id == of_get_option('my_tours_page') || 
			$page_id == of_get_option('my_verification_page') || 
			$page_id == of_get_option('my_friends_page') || 
			$page_id == of_get_option('my_blacklist_page') || 
			$page_id == of_get_option('my_favorites_page') || 
			$page_id == of_get_option('my_classifieds_page') || 
			$page_id == of_get_option('my_views_page') || 
			$page_id == of_get_option('my_settings_page') || 
			$page_id == of_get_option('my_privacy_page') ||
			$page_id == of_get_option('my_upgrade_page') || 
			$page_id == of_get_option('my_cart_page') || 
			$page_id == of_get_option('my_checkout_page') ||
			$page_id == of_get_option('my_notification_page')
			)) {

			echo self::return_all_profile_pages('all');

		} else {
			
			echo DateBook_Template_Loader::load( 'pages/page-pages', $options );

		}

		get_footer();

	}


	/**
	 * Show Profiles by type (taxonomy)
	 *
	 * @access public
	 * @return void
	 */
	public static function process_profile_type_page() {

		echo DateBook_Template_Loader::load( 'pages/page-profiles-type' );

	}


	/**
	 * Show Classifieds by category (taxonomy)
	 *
	 * @access public
	 * @return void
	 */
	public static function process_classified_category_page() {

		echo DateBook_Template_Loader::load( 'pages/page-classifieds-category' );

	}


}

//DateBook_Pages::init();
$dateBook_pages_class = new DateBook_Pages($datebook_options_array);