<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Profile_Comments
 *
 * @class DateBook_Profile_Comments
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Profile_Comments {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_comment_form', array( __CLASS__, 'datebook_process_profile_comment' ) );
		add_action( 'datebook_profile_comments', array( __CLASS__, 'datebook_show_profile_comments' ) );

	}


	/**
	 * Delete submitted comment
	 *
	 * @access private
	 */
	private static function datebook_delete_comment() {

		if ( !isset($_GET['action']) && $_GET['action'] != 'deletecomment' && !isset($_GET['sid']) && absint($_GET['sid']) <= 0) {
				return;
		}

		if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
			exit();
		}

		// Get current user ID
		if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
			$current_user_id = DATEBOOK_CURRENT_USER_ID;
		} else {
			global $current_user;
			wp_get_current_user();
			$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
		}

		$user_role = get_user_meta( $current_user_id, 'profile_type', true );
		
		$layout = '';

		// Someone submits comment to profile. If field is left empty, add the error message to the error object
		if ($user_role == DATEBOOK_POST_TYPE && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {
			
			$get_comment_id = absint($_GET['sid']);
			$comment_data = get_comment( $get_comment_id );
			$author_id = isset($comment_data) && $comment_data->user_id > 0 ? $comment_data->user_id : 0;

			if ($author_id == $current_user_id || is_super_admin()) {

				$comment_ID = isset($comment_data) && $comment_data->comment_ID > 0 ? $comment_data->comment_ID : 0;

				if ($comment_ID > 1){

					$confirm_delete_comment = wp_delete_comment($comment_data->comment_ID, true);

					if (!$confirm_delete_comment) {

						$layout .= '<div class="alert alert-danger">' . esc_html__( 'Oops! Comment has not been deleted or does not exist', 'datebook' ) . '</div>';

					} else {

						$layout .= '<div class="alert alert-success">' . esc_html__( 'Comment has been deleted successfully!', 'datebook' ) . '</div>';

					}

				} else {

					$layout .= '<div class="alert alert-danger">' . esc_html__( 'Oops! Comment has not been deleted or does not exist', 'datebook' ) . '</div>';

				}

			} else {

				$layout .= '<div class="alert alert-danger">' . esc_html__( 'You have no permission to delete this comment', 'datebook' ) . '</div>';

			}
		}

		return $layout;

	}
	
	
	/**
	 * Validate submitted comment
	 *
	 * @access private
	 */
	private static function datebook_validate_form() {
	
		if ( !isset($_POST['action']) && $_POST['action'] != 'submit_comment') {
				return;
		}

		// Make global    
		global $datebook_form_error;

		if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
			$current_user_id = DATEBOOK_CURRENT_USER_ID;
		} else {
			global $current_user;
			wp_get_current_user();
			$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
		}

		$user_role = get_user_meta( $current_user_id, 'profile_type', true );
		
		$update_data = array();

		// Someone submits comment to profile. If field is left empty, add the error message to the error object
		if ($user_role == DATEBOOK_POST_TYPE && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			// instantiate the class
			$datebook_form_error = new WP_Error;

			$update_data['comment_description'] = wp_trim_words(sanitize_text_field(wp_strip_all_tags($_POST['comment_description'])), 1000, '');
			if (!$update_data['comment_description']) {
				$datebook_form_error->add( 'comment_description', esc_html__( 'You didn\'t write a comment', 'datebook' ), 'has-error' );
			}

		}

		return $update_data;

	}


	/**
	 * Update all data
	 *
	 * @access private
	 * @return void
	 */
	private static function datebook_update_data() {

		// validate the comment form input
		$datebook_get_data = self::datebook_validate_form();

		global $current_user, $datebook_form_error;

		// Ensure WP_Error object ($datebook_form_error) contains no error
		if ( 1 > count( $datebook_form_error->get_error_messages() ) && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE) ) {

			wp_get_current_user();

			if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
				$current_user_id = DATEBOOK_CURRENT_USER_ID;
			} else {
				global $current_user;
				wp_get_current_user();
				$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
			}


			if (of_get_option('activate_manual_comments') == '1') {
				$review_status = '0';
			} else {
				$review_status = '1';
			}

			$commenter_agent = $_SERVER['HTTP_USER_AGENT'];
			$commenter_remote_IP = $_SERVER['REMOTE_ADDR'];

			$profile_id = get_the_ID();
			
			$datebook_get_data['comment_description'] = DateBook_Utilities::datebook_word_filter($datebook_get_data['comment_description']);

			$data = array(
					'comment_post_ID' => $profile_id,
					'comment_author' => $current_user->display_name,
					'comment_author_email' => $current_user->user_email,
					'comment_author_IP' => $commenter_remote_IP,
					'comment_content' => $datebook_get_data['comment_description'],
					'comment_approved' => $review_status,
					'comment_agent' => $commenter_agent,
					'user_id' => $current_user_id,
			);

			$review_submit_id = wp_insert_comment($data);

			// Add comment meta
			add_comment_meta( $review_submit_id, 'comment_type', DATEBOOK_COMMENT_TYPE );

			if (of_get_option('email_when_comment') == '1' || of_get_option('activate_reviews_manually') == '1'){

				$review_edit_url_for_admin = admin_url('comment.php?action=editcomment&c=' . $review_submit_id);
				
				$read_comment_link = add_query_arg( array(
					'show' => 'comments'
				), get_permalink($profile_id) );


				$body = esc_html__( 'Hello admin', 'datebook' ).',<br />';
				$body .= esc_html__( 'Someone wrote a profile comment on', 'datebook' ) . ' ' . of_get_option('email_sitename').':<br /><br />';

				$body .= $datebook_get_data['comment_description'] . '<br /><br />';
				
				$body .= esc_html__( 'Data who submitted a comment', 'datebook' ) . ':<br />';
				$body .= 'User ID: ' . $current_user_id . '<br />';
				$body .= 'Name: ' . $current_user->display_name . '<br />';
				$body .= 'Email: ' . $current_user->user_email . '<br />';
				$body .= 'IP address: ' . $commenter_remote_IP . '<br />';
				$body .= 'Browser: ' . $commenter_agent . '<br />';

				$body .= esc_html__( 'Read/Edit the comment here', 'datebook' ).':<br />';
				$body .= '<a href="' . esc_url($review_edit_url_for_admin) . '">' . esc_url($review_edit_url_for_admin) . '</a><br />';
				$body .= esc_html__( 'Profile', 'datebook' ).':<br />';
				$body .= '<a href="' . esc_url($read_comment_link) . '&#comment-' . $review_submit_id . '">' . esc_url($read_comment_link) . '&#comment-' . $review_submit_id . '</a>';


				$from_name = of_get_option('email_sitename') ? of_get_option('email_sitename') : get_bloginfo('name');
				
				$to_email = of_get_option('email_website') ? of_get_option('email_website') : get_bloginfo('admin_email');

				$subject_in_email = esc_html__( 'New comment pending approval', 'datebook' );

				$datebook_mail = DateBook_Utilities::datebook_email_send($from_name, NULL, $to_email, $subject_in_email, $body);

			}

			return '<div class="alert alert-success">' . esc_html__( 'Your comment has been submitted', 'datebook' ) . '</div>';

		} else {

			return '<div class="alert alert-danger">' . esc_html__( 'Oops! Your comment has not been submitted', 'datebook' ) . '</div>';

		}

	}


	/**
	 * Return all comments data
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_comments() {

		$current_user_id = DATEBOOK_CURRENT_USER_ID;

		$user_role = get_user_meta( $current_user_id, 'profile_type', true );
		
		$layout = '';

		// Someone submits comment to profile
		if ($user_role == DATEBOOK_POST_TYPE && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {
			
			if (isset($_POST['action']) && $_POST['action'] == 'submit_comment') {
				
				// update all the input data
				$layout .= self::datebook_update_data();
				
			}
			
			if (isset($_GET['action']) && $_GET['action'] == 'deletecomment' && isset($_GET['sid']) && absint($_GET['sid']) > 0) {
				
				// update all the input data
				$layout .= self::datebook_delete_comment();
					
			}
			
		}
		
		$layout .= DateBook_Template_Loader::load( 'comments/comment-form' );
		
	    // display the comment form
		return $layout;

	}


	/**
	 * Process all data
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_process_profile_comment() {
		
		// display the comment form
		echo self::return_profile_comments();

	}


	/**
	 * Show comments on Single Profile
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_show_profile_comments() {
		
	    // display comments
		echo DateBook_Template_Loader::load( 'profile/profile-comments' );

	}


}

//DateBook_Profile_Comments::init();
$dateBook_profile_comments_class = new DateBook_Profile_Comments($datebook_options_array);