<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Profile_Edit
 *
 * @class DateBook_Profile_Edit
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Profile_Edit {

	private static $datebook_options = null;

	private static $profile_data = null;
	private static $datebook_get_data = null;


    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_profile_process', array( __CLASS__, 'update_data_header' ) );
		add_action( 'datebook_edit_profile', array( __CLASS__, 'datebook_process_edit_profile' ) );
		add_action( 'datebook_single_profile_inside', array( __CLASS__, 'process_single_profile_inside' ) );

		self::$profile_data = DateBook_Utilities::detect_post_slug(DATEBOOK_POST_TYPE);
		$profile = self::$profile_data;
		$profile_id = isset($profile->ID) ? $profile->ID : 0;

		if ($profile_id > 1) {
			// Get Profile personal data
			$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);

			self::$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();
		}

		add_shortcode( 'datebook_profile_image', array( __CLASS__, 'return_profile_image' ) );
		add_shortcode( 'datebook_profile_title', array( __CLASS__, 'return_profile_title' ) );
		add_shortcode( 'datebook_verification', array( __CLASS__, 'return_verification' ) );
		add_shortcode( 'datebook_online_status', array( __CLASS__, 'return_online_status' ) );
		add_shortcode( 'datebook_age', array( __CLASS__, 'return_age' ) );
		add_shortcode( 'datebook_zodiac_sign', array( __CLASS__, 'return_zodiac_sign' ) );
		add_shortcode( 'datebook_sexual_orientation', array( __CLASS__, 'return_sexual_orientation' ) );
		add_shortcode( 'datebook_gender', array( __CLASS__, 'return_gender' ) );
		add_shortcode( 'datebook_location', array( __CLASS__, 'return_location' ) );
		add_shortcode( 'datebook_phone', array( __CLASS__, 'return_phone' ) );
		add_shortcode( 'datebook_website', array( __CLASS__, 'return_website' ) );
		add_shortcode( 'datebook_message_button', array( __CLASS__, 'return_message_button' ) );
		add_shortcode( 'datebook_favorite_button', array( __CLASS__, 'return_favorite_button' ) );
		add_shortcode( 'datebook_like_button', array( __CLASS__, 'return_like_button' ) );
		add_shortcode( 'datebook_friend_button', array( __CLASS__, 'return_friend_button' ) );
		add_shortcode( 'datebook_about_you', array( __CLASS__, 'return_about_you' ) );
		add_shortcode( 'datebook_profile_menu', array( __CLASS__, 'pre_profile_menu' ) );
		add_shortcode( 'datebook_profile_body', array( __CLASS__, 'return_profile_custom_fields' ) );
		add_shortcode( 'datebook_profile_statistics', array( __CLASS__, 'return_profile_statistics' ) );

	}



	/**
	 * Contact profile process
	 *
	 * @access private
	 * @return void
	 */
	private static function send_message_to_profile() {

		if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
			exit();
		}

		// Someone sends a message to another user
		if (isset($_POST['action']) && $_POST['action'] == 'contacting' && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			$alert_success = $datebook_alert_error = '';

			if ($_POST['emails']) { $datebook_alert_error .= '.'; }

			if (is_user_logged_in()) {

				global $current_user;
				wp_get_current_user();

				if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
					$current_user_id = DATEBOOK_CURRENT_USER_ID;
				} else {
					global $current_user;
					wp_get_current_user();
					$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
				}

				$from_contacting_name = $current_user->display_name;
				$from_contacting_email = $current_user->user_email;

			} else {

				$from_contacting_name = sanitize_text_field($_POST['contacting_name']);

				if (!$from_contacting_name) {

					$datebook_alert_error .= esc_html__( 'Your name is missing', 'datebook' ) . '<br />';

				}
				
				$from_contacting_email = sanitize_email($_POST['contacting_email']);

				if ($from_contacting_email){

					if(!is_email($from_contacting_email) ) {

							$datebook_alert_error .= esc_html__( 'Your email address seems to be wrong', 'datebook' ) . '<br />';

					}

				} else {

					$datebook_alert_error .= esc_html__( 'Your email is missing', 'datebook' ) . '<br />';

				}
			}
			
			$from_contacting_text = sanitize_text_field(wp_strip_all_tags($_POST['contacting_text']));

			if (!$from_contacting_text) {

				$datebook_alert_error .= esc_html__( 'You need to write a message', 'datebook' ) . '<br />';

			}
			
			if (!$datebook_alert_error) {
				
				global $post, $alert_success;
				
				$get_day_from_code = DATEBOOK_PURCHASE_CODE;
				$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

				if($get_day_from_code != DateBook_Utilities::get_current_day()){
					exit();
				}

				$profile_id = get_the_ID();

				$profile_name = $post->post_title;

				$profile_get_permalink = get_permalink($profile_id);
				
				$to_email = get_the_author_meta('user_email');

				$select_email_template = 'new_message_to_profile';

				include DateBook_Template_Loader::locate( 'misc/email-templates' );
				
				$subject_in_email = esc_html__( 'Contact message from', 'datebook' ) . ' ' . self::$datebook_options['email_sitename'];

				$datebook_mail = DateBook_Utilities::datebook_email_send($from_contacting_name, $from_contacting_email, $to_email, $subject_in_email, $body);

				unset($from_contacting_name, $from_contacting_email, $from_contacting_text, $body);

				$alert_success = esc_html__( 'Your message has been sent', 'datebook' );

			}
		}
	}


	/**
	 * Update all data
	 *
	 * @access public
	 * @return void
	 */
	public static function update_data_header() {

    	if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
			exit();
		}

		if ( isset( $_POST['change_profile_form'] ) && isset($_POST['action']) && $_POST['action'] == 'change') {

			// update all the input data
			//self::datebook_update_data();
			DateBook_Forms::update_data('profile_form');

    	}
	}


	/**
	 * Show edit form and process all data
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_process_edit_profile() {

		if (isset($_GET['message']) && $_GET['message'] == 'verifyemailsent') {
			
			echo DateBook_Template_Loader::load( 'misc/notification-email-verify' );
		
		} else if (isset($_GET['message']) && ($_GET['message'] == 'mustverifyemail' || $_GET['message'] == 'verifyemailsent' || $_GET['message'] == 'verifyemailnotsent')) {
			
			//echo DateBook_Template_Loader::load( 'misc/notification-email-verify' );
		
		} else {

			// display the Edit Profile form
			echo DateBook_Template_Loader::load( 'profile/profile-edit-form' );

		}

	}


	/**
	 * Return profile image - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_image() {

		$profile = self::$profile_data;

		$layout = '';

		$profile_id = isset($profile->ID) ? $profile->ID : 0;

		if($profile_id > 1){

			global $datebook_alert_error, $datebook_image_sizes;

			if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
				$current_user_id = DATEBOOK_CURRENT_USER_ID;
			} else {
				global $current_user;
				wp_get_current_user();
				$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
			}

			$profile_name = isset($profile->post_title) ? $profile->post_title : esc_html__( 'Profile Title', 'datebook' );
			$user_id = $profile->post_author;
			$currentauth = get_userdata($user_id);

			// Get Profile personal data
			$datebook_get_data = self::$datebook_get_data;
			
			$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) : ((isset($datebook_get_data['dateyear']) && $datebook_get_data['dateyear'] > 0 && isset($datebook_get_data['datemonth']) && $datebook_get_data['datemonth'] > 0 && isset($datebook_get_data['dateday']) && $datebook_get_data['dateday'] > 0) ? floor((time() - strtotime($datebook_get_data['dateyear'] . '-' . $datebook_get_data['datemonth'] . '-' . $datebook_get_data['dateday']))/31556926) : '');
			
			$upload_folder = isset($datebook_get_data['upload_folder']) ? $datebook_get_data['upload_folder'] : '';
			
			$country = $region = $city = '';
			if(isset($datebook_get_data['city'])){
				$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
				$country = isset($term_data->country) ? $term_data->country : '';
				$region = isset($term_data->region) ? $term_data->region : '';
				$city = isset($term_data->city) ? $term_data->city : '';
			}
			
			$title_for_alt = $profile_name . ', ';
			if (isset($age) && $age < 1) {
				$title_for_alt .= $age . ' ' . esc_html__( 'years old', 'datebook' );
				$title_for_alt .= ', ';
			}
			if (isset($city)) {
				$title_for_alt .= $city;
			}
			if (!empty($city) && !empty($country)) {
				$title_for_alt .= ', ';
			}
			if (isset($country)) {
				$title_for_alt .= $country;
			}

			// Show default profile image
			$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_profile', $datebook_get_data['gender'], true);

			if ($thumbnail_url['image_exists'] == 'no') {

				$layout .= '<img class="img-thumbnail" src="'.esc_url( $thumbnail_url['img_full_url'] ).'" alt="' . esc_attr($title_for_alt) . '" width="' . esc_attr( $thumbnail_url['width'] ) . '" height="' . esc_attr( $thumbnail_url['height'] ) . '" />';

				if (is_user_logged_in() && isset($currentauth->ID) && $currentauth->ID > 0 && $currentauth->ID == $current_user_id) {

					$layout .= '<div class="datebook-addphoto-on-profile"><a class="btn btn-outline-secondary" href="' . esc_url(get_permalink(self::$datebook_options['my_photos_page'])).'">' . esc_html__( 'Add photo', 'datebook' ) . '</a></div>';

				}

			} else {
				
				// Check if Retina enabled in Theme Options
				$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

				$image_urlbig = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_big', $datebook_get_data['gender'], false);
				
				$layout .= '<figure id="blueimp-gallery-links" class="text-center">';

				$layout .= '<a class="datebook-frontphoto" href="'.esc_url( $image_urlbig['img_full_url'] ).'" data-lightbox="example-1"><img class="img-fluid rounded w-100 shadow" src="'.esc_url( $thumbnail_url['img_full_url'] ).'" alt="' . esc_attr($title_for_alt) . '" width="' . esc_attr( $thumbnail_url['width'] ) . '" height="' . esc_attr( $thumbnail_url['height'] ) . '"';
					
				if($enable_retina_images == 1) {
					$layout .= ' data-rjs="2"';
				}

				$layout .= '/></a>';

				$layout .= '</figure>';

				$layout .= '<div id="blueimp-gallery" class="blueimp-gallery blueimp-gallery-controls" style="display:none">
                        	<div class="slides"></div>
                            <h3 class="title"></h3>
                            <a class="prev">‹</a>
                            <a class="next">›</a>
                            <a class="close">×</a>
                            <a class="play-pause"></a>
                            <ol class="indicator"></ol>
						</div>';

			}

			$profile_active = '';
			$photos_active = '';
			$comments_active = '';

			$show_tab = isset($_GET['show']) ? esc_attr($_GET['show']) : '';

			switch ($show_tab) {
				case 'profile' : $profile_active = ' active'; break;
				case 'photos'  : $photos_active = ' active'; break;
				case 'comments' : $comments_active = ' active'; break;
				default: $profile_active = ' active'; break;
			}

			$all_photos_args = array(
				'post_parent' => $profile_id, 
				'post_status' => 'inherit', 
				'post_type' => 'attachment', 
				'post_mime_type' => 'image',
				'orderby' => 'rand',
				'posts_per_page' => -1,
				'meta_query' => array(
					array('key' => DATEBOOK_IMAGE_TYPE, 'value' => DATEBOOK_PROFILE_IMAGE_TYPE, 'compare' => '=' )
				)
			);

			$all_photos = new WP_Query( $all_photos_args );

			$all_count_photos = $all_photos->found_posts;

			if (isset($_GET['show']) && $_GET['show'] == 'photos' || isset($_GET['show']) && $_GET['show'] == 'friends' || isset($_GET['show']) && $_GET['show'] == 'comments' || isset($_GET['show']) && $_GET['show'] == 'reviews') {} else {

				if ($all_count_photos > 1) {

					$layout .= '<div class="datebook-thumbs">';

					if (!is_user_logged_in() && isset($get_subscription_plans['access_profile_images']) && $get_subscription_plans['access_profile_images'] == 1) {

						$nrofphotos = $all_count_photos - 1;

						$layout .= '<div class="alert alert-warning">';
						$layout .= esc_html__( 'This profile has', 'datebook' ).' <strong>'.absint($nrofphotos).'</strong> '.esc_html__( 'more photos', 'datebook' ).'.<br />';
						$layout .= esc_html__( 'You need to', 'datebook' ).' <a class="alert-link" href="'.esc_url(get_permalink(self::$datebook_options['registration_page'])).'">'.esc_html__( 'register', 'datebook' ).'</a> '.esc_html__( 'or', 'datebook' ).' <a class="alert-link" href="'.esc_url(get_permalink(self::$datebook_options['login_page'])).'">'.esc_html__( 'login', 'datebook' ).'</a> '.esc_html__( 'to be able to view the other photos', 'datebook' );
						$layout .= '</div>';

					} else {}

						$layout .= '</div>';

					}
				}

		} else {

			$layout .= '<figure id="blueimp-gallery-links" class="text-center">

						<img class="img-thumbnail" src="' . esc_url(DATEBOOK_URL . 'assets/images/no-image-profile-m.png') . '" alt="Add photo" width="268" height="362"><div class="datebook-addphoto-on-profile"><a class="btn btn-outline-secondary waves-effect waves-light" href="">Add photo</a></div>                        
						</figure>';

		}

		return $layout;

	}


	/**
	 * Return profile title - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_title() {

		$profile = self::$profile_data;

		$profile_name = isset($profile->post_title) ? $profile->post_title : esc_html__( 'Profile Title', 'datebook' );

		return '<span class="datebook-title-single-profile">' . $profile_name . '</span>';

	}


	/**
	 * Return profile verification - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_verification() {

		$profile = self::$profile_data;
		
		$verification_block = '<sup><i class="fas fa-check-square fa-xs text-green" title="' . esc_html__( 'Verification', 'datebook' ) . '" data-toggle="tooltip" data-placement="top" data-original-title="' . esc_html__( 'Verification', 'datebook' ) . '"></i></sup>';

		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		if($profile_id > 1){

			// Get Profile personal data
			$datebook_get_data = self::$datebook_get_data;

			if (isset($datebook_get_data['verified']) && $datebook_get_data['verified'] == "1") {

				$layout = $verification_block;

			} else {

				$layout = '';

			}

		} else {

			$layout = $verification_block;			

		}

		return $layout;

	}


	/**
	 * Return profile online status - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_online_status() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$current_user_id = isset($profile->post_author) ? $profile->post_author : 0;
		
		if($current_user_id > 1){

			$gender = get_post_meta($profile_id, 'gender', true);
			$layout = DateBook_Utilities::return_online_status( $current_user_id, $gender, 1, 'full' );

		} else {

			$layout = '<span class="mr-2 datebook-online-caption datebook-online-bottom"><span class="badge badge-light font-weight-light shadow-none datebook-badge-online" data-toggle="tooltip" data-placement="top" data-original-title="">' . esc_html__( 'Online status', 'datebook' ) . '</span></span>';
			
		}

		return $layout;

	}


	/**
	 * Return profile age - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_age() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = '';
		
		if($profile_id > 1){

			// Get Profile personal data
			$datebook_get_data = self::$datebook_get_data;

			if (DateBook_Utilities::datebook_show_field('birthdate', 1)) {
				
				$get_day_from_code = DATEBOOK_PURCHASE_CODE;
				$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

				if($get_day_from_code != DateBook_Utilities::get_current_day()){
					exit();
				}

				$age_number = isset($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) : ((isset($datebook_get_data['dateyear']) && $datebook_get_data['dateyear'] > 0 && isset($datebook_get_data['datemonth']) && $datebook_get_data['datemonth'] > 0 && isset($datebook_get_data['dateday']) && $datebook_get_data['dateday'] > 0) ? floor((time() - strtotime($datebook_get_data['dateyear'] . '-' . $datebook_get_data['datemonth'] . '-' . $datebook_get_data['dateday']))/31556926) : '');
				
				if (isset($age_number) && $age_number > 0) {

					$age_format = isset($datebook_get_data['birthday']) ? $datebook_get_data['birthday'] : ((isset($datebook_get_data['dateyear']) && isset($datebook_get_data['datemonth']) && isset($datebook_get_data['dateday'])) ? $datebook_get_data['dateyear'] . '-' . $datebook_get_data['datemonth'] . '-' . $datebook_get_data['dateday'] : '');

					$age = !empty($age_format) ? self::datebirth_i18n($age_format) : '';

					$layout .= esc_attr($age);
				}

			}

		} else {

			$layout .= 'XX ' . esc_html__( 'years old', 'datebook' );

		}

		return $layout;

	}


	/**
	 * Return profile zodiac sign - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_zodiac_sign() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout_out = $layout = '';
		
		if($profile_id > 1){

			// Get Profile personal data
			$datebook_get_data = self::$datebook_get_data;

			if (DateBook_Utilities::datebook_show_field('birthdate', 1)) {

				if (isset($datebook_get_data['hidezodiac']) && $datebook_get_data['hidezodiac'] == 0) {

					if(isset($datebook_get_data['datemonth']) && isset($datebook_get_data['dateday'])){
						$datemonth = $datebook_get_data['datemonth'];
						$dateday = $datebook_get_data['dateday'];

						$layout .= DateBook_Profile_Settings::datebook_zodiac($dateday, $datemonth) . '</span>';

					}
				}
			}

		} else {

			$layout .= esc_html__( 'Zodiac sign', 'datebook' );

		}
		
		$layout_out = wp_specialchars_decode(esc_html($layout), ENT_QUOTES );

		return $layout_out;

	}


	/**
	 * Return profile sexual orientation - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_sexual_orientation() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = '';
		
		if($profile_id > 1){

			if (DateBook_Utilities::datebook_show_field('sexualorientation', 1) && (self::$datebook_options['sexual_orientation_allowed'] != "" || self::$datebook_options['sexual_orientation_allowed_other_' . DATEBOOK_WPLANG] != '')) {
				
				global $datebook_field_titles;

				// Get Profile personal data
				$datebook_get_data = self::$datebook_get_data;

				set_query_var( 'datebook_field_titles', $datebook_field_titles );
		
				$datebook_field_titles = get_query_var( 'datebook_field_titles' );
				if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }
				
				$get_day_from_code = DATEBOOK_PURCHASE_CODE;
				$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

				if($get_day_from_code != DateBook_Utilities::get_current_day()){
					exit();
				}
				
				$sexualorientation = isset($datebook_get_data['sexualorientation']) ? $datebook_get_data['sexualorientation'] : '';
				
				$sexualorientation = $sexualorientation == 2 && isset($datebook_get_data['gender']) && $datebook_get_data['gender'] > 0 ? $datebook_get_data['gender'].$sexualorientation . '00' : $sexualorientation;

				if (isset($datebook_sexualorientation_titles[$sexualorientation])) {

					$layout .= esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' ); 

				}
			}

		} else {

			$layout .= esc_html__( 'Sexual orientation', 'datebook' );

		}

		return $layout;

	}


	/**
	 * Return profile gender - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_gender() {

		$profile = self::$profile_data;

		$profile_id = isset($profile->ID) ? $profile->ID : 0;

		$layout_out = $layout = '';

		if($profile_id > 1){
			
			// Get Profile personal data
			$datebook_get_data = self::$datebook_get_data;

			if (DateBook_Utilities::datebook_show_field('gender', 1) && isset($datebook_get_data['gender']) && $datebook_get_data['gender'] > 0) {

				global $datebook_field_titles;

				set_query_var( 'datebook_field_titles', $datebook_field_titles );
		
				$datebook_field_titles = get_query_var( 'datebook_field_titles' );
				if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

				$gender_title = (isset($datebook_gender_titles[$datebook_get_data['gender']])) ? esc_html__($datebook_gender_titles[$datebook_get_data['gender']], 'datebook' ) : '';

				if ($datebook_get_data['gender'] == 1) {
					$gender_icon = 'fa fa-venus fa-lg';
					$gender_img = 1;
				} else if ($datebook_get_data['gender'] == 2) {
					$gender_icon = 'fa fa-mars fa-lg';
					$gender_img = 1;
				} else {
					$gender_img = 0;
				}

				if ($gender_img == 0) {
					$layout .= '<span>' . $gender_title . '</span>';
				} else {
					$layout .= '<span title="' . $gender_title . '" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-original-title="' . $gender_title . '"><i class="' . $gender_icon . '"></i></span>';
				}
				
			}

		} else {

			$gender_icon = 'fa fa-user fa-lg';

			$layout .= '<span><i class="' . $gender_icon . '"></i></span>';

		}

		$layout_out = wp_specialchars_decode(esc_html($layout), ENT_QUOTES );

		return $layout_out;

	}


	/**
	 * Return profile location - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_location() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = '';
		
		if($profile_id > 1){

			// Get Profile personal data
			$datebook_get_data = self::$datebook_get_data;

			$country = $region = $city = '';
			if(isset($datebook_get_data['city'])){
				$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
				$country = isset($term_data->country) ? $term_data->country : '';
				$region = isset($term_data->region) ? $term_data->region : '';
				$city = isset($term_data->city) ? $term_data->city : '';
			}

			if (DateBook_Utilities::datebook_show_field('countrycity', 1) && isset($city) && strlen($city) > 0 && isset($region) && strlen($region) > 0 && isset($country) && strlen($country) > 0) {
				$layout .= esc_attr($city . ', ' . $region . ', ' . $country);
			}

		} else {

			$layout .= esc_html__( 'City, Coutry', 'datebook' );

		}

		return $layout;

	}


	/**
	 * Return profile phone - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_phone() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = '';
		
		if($profile_id > 1){

			// Get Profile personal data
			$datebook_get_data = self::$datebook_get_data;

			if (DateBook_Utilities::datebook_show_field('phone', 1) && isset($datebook_get_data['phone'])){

				$layout .= '<span><i class="fas fa-mobile-alt"></i> ' . esc_attr($datebook_get_data['phone']) . '</span>';

			}

		} else {

			$layout .= '<span><i class="fas fa-mobile-alt"></i> 123456789</span>';
			
		}

		return $layout;

	}


	/**
	 * Return profile website - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_website() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = '';
		
		if($profile_id > 1){

			// Get Profile personal data
			$datebook_get_data = self::$datebook_get_data;

			if (DateBook_Utilities::datebook_show_field('website', 1) && isset($datebook_get_data['website'])){

				$layout .= '<span><i class="fas fa-link"></i> <a href="' . esc_url($datebook_get_data['website']) . '" target="_blank">' .  esc_html__( 'Website', 'datebook' ) . '</a></span>';

			}

		} else {

			$layout .= '<span><i class="fas fa-link"></i> <a href="#" target="_blank">' .  esc_html__( 'Website', 'datebook' ) . '</a></span>';
			
		}

		return $layout;

	}


	/**
	 * Return profile message button - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_message_button() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = $layout_in = '';
		
		if($profile_id > 1){
			
			//$layout .= '<div id="datebook-login" class="datebook-contact-block">';

			if (self::$datebook_options['contact_method'] == '1') {
				
				global $datebook_alert_error;

				if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
					$current_user_id = DATEBOOK_CURRENT_USER_ID;
				} else {
					global $current_user;
					wp_get_current_user();
					$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
				}
				
				$user_id = $profile->post_author;
				$currentauth = get_userdata($user_id);
			
				if (is_user_logged_in() && isset($currentauth->ID) && $currentauth->ID > 0 && isset($current_user_id) && $current_user_id > 0) {
					$open_message_new_window = self::$datebook_options['open_message_new_window'] ? (DateBook_Utilities::mobile_detect() == 'mobile' ? 0 : 1) : 0;

					if ($open_message_new_window == 1) {

						$layout_in .= 'id="datebook-chatpopup" onclick="return false;" ';

					}

					$open_message_popup = add_query_arg( array(
						'action' => 'read',
						'sid' => absint($currentauth->ID),
						'rid' => absint($current_user_id),
					), get_permalink(self::$datebook_options['my_messages_page']) );

					$layout_in .= 'href="' . esc_url($open_message_popup) . '"';

				} else {

					$layout_in .= 'target="_blank" data-toggle="tooltip" data-placement="top" data-original-title="' .  esc_html__( 'Login to write a message', 'datebook' ) . '" href="' . esc_url(get_permalink(self::$datebook_options['login_page'])) . '"';

				}

				$layout .= '<a ' . $layout_in . ' class="btn btn-primary btn-message m-0 mr-1 pl-4 pr-4"><i class="fas fa-envelope fa-lg mr-1"></i> <span>' . esc_html__( 'Write a message', 'datebook' ) . '</span></a>';

			} else {

				$layout .= '<div id="datebook-emailpopup" class="btn-group" role="group">
						<div class="btn-group" role="group">
							<button id="DateBookContactBtnGroupDrop" type="button" class="btn btn-lg btn-primary dropdown-toggle btn-message" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-envelope mr-2"></i> ' . esc_html__( 'Write a message', 'datebook' ) . '</button>
							<div class="dropdown-menu datebook-dropdown-menu" aria-labelledby="DateBookContactBtnGroupDrop" ' . (isset($datebook_alert_error) && $_POST['action'] == "contacting") ? ' style="display: block;"' : '' . '>';

				$layout .= include DateBook_Template_Loader::locate( 'profile/profile-contact-form' );

				$layout .= '</div>
						</div>
					</div>';

				}

			//$layout .= '</div>';

		} else {

			$layout .= '<a id="datebook-chatpopup" onclick="return false;" href="" class="btn btn-primary btn-message m-0 mr-1 pl-4 pr-4"><i class="fas fa-envelope fa-lg mr-1"></i> ' . esc_html__( 'Contact button', 'datebook' ) . '</a>';

		}

		return $layout;

	}


	/**
	 * Show profile favorite button
	 *
	 * @access public
	 * @return void
	 */
	public static function process_favorite_button($get_options){

		$layout = '';
		
		$enable_options = self::$datebook_options['enable_favorite_profiles'];

		if (isset($enable_options['1']) && $enable_options['1'] == '1'){

			$feature_class = 'mr-2';
			$feature_icon = 'fas fa-heart fa-lg';
			$feature_style = 'color:' . $get_options['normal_icon_color'];

			if (is_user_logged_in() || is_super_admin()) {

				if (isset($get_options['currentauth_ID']) && $get_options['currentauth_ID'] > 0 && $get_options['currentauth_ID'] != $get_options['current_user_id']) {

					// Favorites
					$favorites = get_user_meta( $get_options['current_user_id'], 'favorites', true);

					if ($favorites) {
						$favorites = array_unique(explode(',', $favorites));
					} else {
						$favorites = array();
					}

					if (in_array($get_options['profile_id'], $favorites)) {
						if($get_options['style'] == 1 || $get_options['what_page'] == 1){
							$feature_class = 'mr-2';
							$feature_icon = 'fas fa-heart fa-lg';
							$feature_style = 'color:' . $get_options['added_icon_color'];
						} else if($get_options['style'] == 2){
							$feature_class = 'pt-1 pr-2 pl-2 rounded-circle text-white';
							$feature_icon = 'fas fa-heart fa-sm';
							$feature_style = 'padding-bottom:2px;background-color:' . $get_options['added_icon_color'];
						} else if($get_options['style'] == 3){
							$feature_class = 'mr-2';
							$feature_icon = 'fas fa-heart fa-lg';
							$feature_style = 'color:' . $get_options['added_icon_color'];
						}
						$feature_title = esc_html__('Added to Favorites', 'datebook');
					} else {
						if($get_options['style'] == 1 || $get_options['what_page'] == 1){
							$feature_class = 'mr-2';
							$feature_icon = 'fas fa-heart fa-lg';
							$feature_style = 'color:' . $get_options['normal_icon_color'];
						} else if($get_options['style'] == 2){
							$feature_class = 'pt-1 pr-2 pl-2 rounded-circle text-white';
							$feature_icon = 'fas fa-heart fa-sm';
							$feature_style = 'padding-bottom:2px;background-color:' . $get_options['normal_icon_color'];
						} else if($get_options['style'] == 3){
							$feature_class = 'mr-2';
							$feature_icon = 'far fa-heart fa-lg';
							$feature_style = 'color:' . $get_options['normal_icon_color'];
						}
						$feature_title = esc_html__('Add to Favorites', 'datebook');
					}

				} else {

					if($get_options['style'] == 1 || $get_options['what_page'] == 1){
						$feature_class = 'mr-2';
						$feature_icon = 'fas fa-heart fa-lg';
						$feature_style = 'color:' . $get_options['normal_icon_color'];
					} else if($get_options['style'] == 2){
						$feature_class = 'pt-1 pr-2 pl-2 rounded-circle text-white';
						$feature_icon = 'fas fa-heart fa-sm';
						$feature_style = 'padding-bottom:2px;background-color:' . $get_options['normal_icon_color'];
					} else if($get_options['style'] == 3){
						$feature_class = 'mr-2';
						$feature_icon = 'far fa-heart fa-lg';
						$feature_style = 'color:' . $get_options['normal_icon_color'];
					}
					$feature_title = esc_html__('Add to Favorites', 'datebook');

				}

			} else {

				if($get_options['style'] == 1 || $get_options['what_page'] == 1){
					$feature_class = 'mr-2';
					$feature_icon = 'fas fa-heart fa-lg';
					$feature_style = 'color:' . $get_options['normal_icon_color'];
				} else if($get_options['style'] == 2){
					$feature_class = 'pt-1 pr-2 pl-2 rounded-circle text-white';
					$feature_icon = 'fas fa-heart fa-sm';
					$feature_style = 'background-color:' . $get_options['normal_icon_color'];
				} else if($get_options['style'] == 3){
					$feature_class = 'mr-2';
					$feature_icon = 'far fa-heart fa-lg';
					$feature_style = 'color:' . $get_options['normal_icon_color'];
				}
				$feature_title = esc_html__('Login to add Favorite', 'datebook');

			}

			// Colors to attribute
			$normal_icon_color = 'color:' . $get_options['normal_icon_color'];
			$added_icon_color = 'color:' . $get_options['added_icon_color'];

			$feature_normal_icon = 'fas fa-heart fa-lg';
			$feature_added_icon = 'fas fa-heart fa-lg';

			if($get_options['what_page'] == 1){

				$normal_icon_color = 'color:' . $get_options['normal_icon_color'];
				$added_icon_color = 'color:' . $get_options['added_icon_color'];

				$feature_normal_icon = 'fas fa-heart fa-lg';
				$feature_added_icon = 'fas fa-heart fa-lg';

			} else if($get_options['style'] == 1 || $get_options['style'] == 3){

				$normal_icon_color = 'color:' . $get_options['normal_icon_color'];
				$added_icon_color = 'color:' . $get_options['added_icon_color'];

				$feature_normal_icon = 'far fa-heart fa-lg';
				$feature_added_icon = 'fas fa-heart fa-lg';

			} else if($get_options['style'] == 2){

				$normal_icon_color = 'padding-bottom:2px;background-color:' . $get_options['normal_icon_color'];
				$added_icon_color = 'padding-bottom:2px;background-color:' . $get_options['added_icon_color'];

				$feature_normal_icon = 'fas fa-heart fa-sm';
				$feature_added_icon = 'fas fa-heart fa-sm';

			}

			if($get_options['what_page'] == 1){
				$what_page = 'profile';
			} else {
				$what_page = 'search';
			}

			$layout .= '<a class="' . $feature_class . ' mr-2 datebook-favorited-actions datebook-favorited-' . $get_options['profile_id'] . '" id="' . $get_options['profile_id'] . '" data-normal-icon="' . $feature_normal_icon . '" data-added-icon="' . $feature_added_icon . '" data-profile-id="' . $get_options['profile_id'] . '" data-what-page="' . $what_page . '" title="' . $feature_title . '" data-toggle="tooltip" data-placement="top" data-original-title="' . $feature_title . '" onClick="return false;" href="javascript:void(0)" data-normal-color=" ' . $normal_icon_color . '" data-added-color=" ' . $added_icon_color . '" style="' . $feature_style . '">';

			$layout .= '<i class="' . $feature_icon . '"';
			if($get_options['style'] == 3){
				$layout .= ' style="text-shadow: 0 3px 16px rgba(0,0,0,.8);"';
			}
			$layout .= '></i>';

			if ($get_options['show_count'] == 1){
				$layout .= '<span class="ml-2 small datebook-count">' . $get_options['profile_favorites'] . '</span>';
			}

			$layout .= '</a>';

			return $layout;

		} else {

			return $layout;

		}
	}


	/**
	 * Return profile favorite button - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_favorite_button() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = $layout_in = '';
		
		if($profile_id > 1){

			$enable_options = self::$datebook_options['enable_favorite_profiles'];

			if (isset($enable_options['1']) && $enable_options['1'] == '1'){

				if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
					$current_user_id = DATEBOOK_CURRENT_USER_ID;
				} else {
					global $current_user;
					wp_get_current_user();
					$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
				}

				$user_id = $profile->post_author;
				$currentauth = get_userdata($user_id);

				$get_featured_pattern = self::$datebook_get_data;

				$count = isset($get_featured_pattern['favorites']['count']) && $get_featured_pattern['favorites']['count'] > 0 ? $get_featured_pattern['favorites']['count'] : 0;

				$style = self::$datebook_options['favorites_style'];
				$normal_icon_color = self::$datebook_options['favorite_normal_icon_color'] ? self::$datebook_options['favorite_normal_icon_color'] : 'rgb(0, 152, 255)';
				$added_icon_color = self::$datebook_options['favorite_added_icon_color'] ? self::$datebook_options['favorite_added_icon_color'] : 'rgb(0, 228, 54)';
				$show_count = isset($enable_options['2']) && $enable_options['2'] == '1' ? 1 : 0;				

				$get_options = array(
					'profile_id' => $profile_id, 
					'currentauth_ID' => $currentauth->ID, 
					'current_user_id' => $current_user_id, 
					'profile_favorites' => $count, 
					'show_count' => $show_count, 
					'style' => $style, 
					'normal_icon_color' => $normal_icon_color, 
					'added_icon_color' => $added_icon_color, 
					'what_page' => 0
				);

				$layout .= self::process_favorite_button($get_options);

			} else {

				$layout .= '';

			}

		} else {

			$layout .= '<span class="btn btn-outline-primary mr-2 p-1 pl-2 pr-2 datebook-favorited-actions" title="' . esc_html__( 'Add to Favorites', 'datebook' ) . '"><i class="fas fa-heart fa-lg"></i></span>';

		}

		return $layout;

	}


	/**
	 * Return profile like button
	 *
	 * @access public
	 * @return void
	 */
	public static function process_like_button($get_options){

		$layout = '';

		$enable_options = self::$datebook_options['enable_like_profiles'];

		if (isset($enable_options['1']) && $enable_options['1'] == '1') {

			$feature_class = 'mr-2';
			$feature_icon = 'fas fa-thumbs-up fa-lg';
			$feature_style = 'color:' . $get_options['normal_icon_color'];

			if (is_user_logged_in() || is_super_admin()) {

				if (isset($get_options['currentauth_ID']) && $get_options['currentauth_ID'] > 0 && $get_options['currentauth_ID'] != $get_options['current_user_id']) {

					// Likes
					$likes = get_user_meta( $get_options['current_user_id'], 'likes', true);

					if ($likes) {
						$likes = array_unique(explode(',', $likes));
					} else {
						$likes = array();
					}

					if (in_array($get_options['profile_id'], $likes)) {
						if($get_options['style'] == 1 || $get_options['what_page'] == 1){
							$feature_class = 'mr-2';
							$feature_icon = 'fas fa-thumbs-up fa-lg';
							$feature_style = 'color:' . $get_options['added_icon_color'];
						} else if($get_options['style'] == 2){
							$feature_class = 'pt-1 pr-2 pl-2 rounded-circle text-white';
							$feature_icon = 'fas fa-thumbs-up fa-sm';
							$feature_style = 'padding-bottom:2px;background-color:' . $get_options['added_icon_color'];
						} else if($get_options['style'] == 3){
							$feature_class = 'mr-2';
							$feature_icon = 'fas fa-thumbs-up fa-lg';
							$feature_style = 'color:' . $get_options['added_icon_color'];
						}
						$feature_title = esc_html__('You like it', 'datebook');
					} else {
						if($get_options['style'] == 1 || $get_options['what_page'] == 1){
							$feature_class = 'mr-2';
							$feature_icon = 'fas fa-thumbs-up fa-lg';
							$feature_style = 'color:' . $get_options['normal_icon_color'];
						} else if($get_options['style'] == 2){
							$feature_class = 'pt-1 pr-2 pl-2 rounded-circle text-white';
							$feature_icon = 'fas fa-thumbs-up fa-sm';
							$feature_style = 'padding-bottom:2px;background-color:' . $get_options['normal_icon_color'];
						} else if($get_options['style'] == 3){
							$feature_class = 'mr-2';
							$feature_icon = 'far fa-thumbs-up fa-lg';
							$feature_style = 'color:' . $get_options['normal_icon_color'];
						}
						$feature_title = esc_html__('Like it', 'datebook');
					}

				} else {

					if($get_options['style'] == 1 || $get_options['what_page'] == 1){
						$feature_class = 'mr-2';
						$feature_icon = 'fas fa-thumbs-up fa-lg';
						$feature_style = 'color:' . $get_options['normal_icon_color'];
					} else if($get_options['style'] == 2){
						$feature_class = 'pt-1 pr-2 pl-2 rounded-circle text-white';
						$feature_icon = 'fas fa-thumbs-up fa-sm';
						$feature_style = 'padding-bottom:2px;background-color:' . $get_options['normal_icon_color'];
					} else if($get_options['style'] == 3){
						$feature_class = 'mr-2';
						$feature_icon = 'far fa-thumbs-up fa-lg';
						$feature_style = 'color:' . $get_options['normal_icon_color'];
					}
					$feature_title = esc_html__('Like it', 'datebook');

				}

			} else {

				if($get_options['style'] == 1 || $get_options['what_page'] == 1){
					$feature_class = 'mr-2';
					$feature_icon = 'fas fa-thumbs-up fa-lg';
					$feature_style = 'color:' . $get_options['normal_icon_color'];
				} else if($get_options['style'] == 2){
					$feature_class = 'pt-1 pr-2 pl-2 rounded-circle text-white';
					$feature_icon = 'fas fa-thumbs-up fa-sm';
					$feature_style = 'background-color:' . $get_options['normal_icon_color'];
				} else if($get_options['style'] == 3){
					$feature_class = 'mr-2';
					$feature_icon = 'far fa-thumbs-up fa-lg';
					$feature_style = 'color:' . $get_options['normal_icon_color'];
				}
				$feature_title = esc_html__('Login to like it', 'datebook');

			}

			// Colors to attribute
			$normal_icon_color = 'color:' . $get_options['normal_icon_color'];
			$added_icon_color = 'color:' . $get_options['added_icon_color'];

			$feature_normal_icon = 'fas fa-thumbs-up fa-lg';
			$feature_added_icon = 'fas fa-thumbs-up fa-lg';

			if($get_options['what_page'] == 1){

				$normal_icon_color = 'color:' . $get_options['normal_icon_color'];
				$added_icon_color = 'color:' . $get_options['added_icon_color'];

				$feature_normal_icon = 'fas fa-thumbs-up fa-lg';
				$feature_added_icon = 'fas fa-thumbs-up fa-lg';

			} else if($get_options['style'] == 1 || $get_options['style'] == 3){

				$normal_icon_color = 'color:' . $get_options['normal_icon_color'];
				$added_icon_color = 'color:' . $get_options['added_icon_color'];

				$feature_normal_icon = 'far fa-thumbs-up fa-lg';
				$feature_added_icon = 'fas fa-thumbs-up fa-lg';

			} else if($get_options['style'] == 2){

				$normal_icon_color = 'padding-bottom:2px;background-color:' . $get_options['normal_icon_color'];
				$added_icon_color = 'padding-bottom:2px;background-color:' . $get_options['added_icon_color'];

				$feature_normal_icon = 'fas fa-thumbs-up fa-sm';
				$feature_added_icon = 'fas fa-thumbs-up fa-sm';

			}

			if($get_options['what_page'] == 1){
				$what_page = 'profile';
			} else {
				$what_page = 'search';
			}

			$layout .= '<a class="' . $feature_class . ' mr-2 datebook-like-actions datebook-like-' . $get_options['profile_id'] . '" id="' . $get_options['profile_id'] . '" data-normal-icon="' . $feature_normal_icon . '" data-added-icon="' . $feature_added_icon . '" data-profile-id="' . $get_options['profile_id'] . '" data-what-page="' . $what_page . '" title="' . $feature_title . '" data-toggle="tooltip" data-placement="top" data-original-title="' . $feature_title . '" onClick="return false;" href="javascript:void(0)" data-normal-color=" ' . $normal_icon_color . '" data-added-color=" ' . $added_icon_color . '" style="' . $feature_style . '">';

			$layout .= '<i class="' . $feature_icon . '"';
			if($get_options['style'] == 3){
				$layout .= ' style="text-shadow: 0 3px 16px rgba(0,0,0,.8);"';
			}
			$layout .= '></i>';

			if ($get_options['show_count'] == 1){
				$layout .= '<span class="ml-2 small datebook-count">' . $get_options['profile_likes'] . '</span>';
			}

			$layout .= '</a>';

			return $layout;

		} else {

			return $layout;

		}
	}


	/**
	 * Return profile like button - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_like_button() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = $layout_in = '';
		
		if($profile_id > 1){

			$enable_options = self::$datebook_options['enable_like_profiles'];

			if (isset($enable_options['1']) && $enable_options['1'] == '1') {
			
				if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
					$current_user_id = DATEBOOK_CURRENT_USER_ID;
				} else {
					global $current_user;
					wp_get_current_user();
					$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
				}

				$user_id = $profile->post_author;
				$currentauth = get_userdata($user_id);

				$get_featured_pattern = self::$datebook_get_data;

				$count = isset($get_featured_pattern['likes']['count']) && $get_featured_pattern['likes']['count'] > 0 ? $get_featured_pattern['likes']['count'] : 0;
				
				$style = self::$datebook_options['like_style'] ? self::$datebook_options['like_style'] : 1;
				$normal_icon_color = self::$datebook_options['like_normal_icon_color'] ? self::$datebook_options['like_normal_icon_color'] : 'rgb(0, 152, 255)';
				$added_icon_color = self::$datebook_options['like_added_icon_color'] ? self::$datebook_options['like_added_icon_color'] : 'rgb(0, 228, 54)';
				$show_count = isset($enable_options['2']) && $enable_options['2'] == '1' ? 1 : 0;

				$like_options = array(
					'profile_id' => $profile_id,
					'currentauth_ID' => $currentauth->ID,
					'current_user_id' => $current_user_id,
					'profile_likes' => $count,
					'style' => $style,
					'normal_icon_color' => $normal_icon_color,
					'added_icon_color' => $added_icon_color,
					'show_count' => $show_count,
					'what_page' => 1
				);
				
				$layout .= self::process_like_button($like_options);
				
			} else {

				$layout .= '';

			}

		} else {

			$layout .= '<span class="btn btn-outline-primary mr-2 p-1 pl-2 pr-2 datebook-like" title="' . esc_html__( 'Like it', 'datebook' ) . '"><i class="fas fa-thumbs-up fa-lg"></i></span>';

		}

		return $layout;

	}


	/**
	 * Return profile friend button - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_friend_button() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = $layout_in = '';
		
		if($profile_id > 1){

			if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
				$current_user_id = DATEBOOK_CURRENT_USER_ID;
			} else {
				global $current_user;
				wp_get_current_user();
				$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
			}

			$user_id = $profile->post_author;
			$currentauth = get_userdata($user_id);
			
			$get_featured_pattern = self::$datebook_get_data;

			$profile_friends = isset($get_featured_pattern['friends']) && $get_featured_pattern['friends'] > 0 ? $get_featured_pattern['friends'] : 0;

			$layout .= DateBook_Profile_Friends::process_friend_button($profile_id, $currentauth->ID, $current_user_id, $profile_friends);

		} else {

			$layout .= '<span class="btn btn-outline-primary datebook-friend-actions" title="' . esc_html__( 'Add to Friends', 'datebook' ) . '">' . esc_html__( 'Add to Friends', 'datebook' ) . '</span>';

		}

		return $layout;

	}


	/**
	 * Return profile about you description - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_about_you() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = '';
		
		if($profile_id > 1){

			if (DateBook_Utilities::datebook_show_field('aboutyou', 1)) {

				$aboutyou = isset($profile->post_content) ? $profile->post_content : '';

				if (strlen($aboutyou) > 220) {
					$datebook_description_long = 1;
					$datebook_description_class = 'datebook-reveal-closed';
				} else {
					$datebook_description_long = 0;
					$datebook_description_class = '';
				}

				$layout .= '<div id="datebook-mainaboutme" class="card card-body mb-3 shadow bg-white rounded datebook-aboutme datebook-more datebook-main-reveal">';
				$layout .= '<div class="font-italic ' . sanitize_html_class($datebook_description_class) . '">';
				
				$layout .= wpautop(esc_textarea($aboutyou));
				
				$layout .= '</div>';

				if ($datebook_description_long == 1) {

					$layout .= '<div class="datebook-openabout"><span class="btn btn-sm btn-light shadow-none datebook-aboutme-more">' . esc_html__( 'open', 'datebook' ) . '</span></div>';
					$layout .= '<div class="datebook-closeabout"><span class="btn btn-sm btn-light shadow-none datebook-aboutme-more">' . esc_html__( 'close', 'datebook' ) . '</span></div>';

				}

				$layout .= '</div>';

			}

		} else {

			$layout .= '<div id="datebook-mainaboutme" class="card card-body mb-3 shadow bg-white rounded datebook-aboutme datebook-more datebook-main-reveal">';
			$layout .= '<div class="font-italic">' . esc_html__( 'About you', 'datebook' ) . '. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed ultrices dui eu lectus fringilla non pellentesque magna egestas. Suspendisse potenti. Vivamus at magna libero. Donec et purus nunc, eu aliquam diam. Nesciunt tofu stumptown aliqua, retro synth master cleanse. Mustache cliche tempor, williamsburg carles vegan helvetica. </div>';
			$layout .= '</div>';

		}

		return $layout;

	}


	/**
	 * Return profile menu - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_profile_menu($atts = array()) {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		$profile_post_author = isset($profile->post_author) && $profile->post_author > 0 ? $profile->post_author : 0;

		$layout = '';
		
		$is_shortcode = !empty($atts) && is_array($atts) ? 1 : (isset($atts['shortcode']) && $atts['shortcode'] == 1 ? 0 : 1);
		$shortcode_justify = isset($atts['justify']) && $atts['justify'] > 0 ? 'nav-justified' : '';

		if($profile_id > 1){

			$profile_page_url = get_permalink($profile_id);

			$profile_active = '';
			$photos_active = '';
			$friends_active = '';
			$comments_active = '';
			$reviews_active = '';

			$show_tab = isset($_GET['show']) ? esc_attr($_GET['show']) : '';

			switch ($show_tab) {
				case 'profile' : $profile_active = ' active'; break;
				case 'photos'  : $photos_active = ' active'; break;
				case 'friends'  : $friends_active = ' active'; break;
				case 'comments' : $comments_active = ' active'; break;
				case 'reviews' : $reviews_active = ' active'; break;
				default: $profile_active = ' active'; break;
			}

			$all_photos_args = array(
				'post_parent' => $profile_id, 
				'post_status' => 'inherit', 
				'post_type' => 'attachment', 
				'post_mime_type' => 'image', 
				'orderby' => 'rand',
				'posts_per_page' => -1,
				'meta_query' => array(
					array('key' => DATEBOOK_IMAGE_TYPE, 'value' => DATEBOOK_PROFILE_IMAGE_TYPE, 'compare' => '=' )
				)
			);

			$all_photos = new WP_Query( $all_photos_args );

			$all_count_photos = $all_photos->found_posts;

			$layout .= '<ul class="nav nav-pills pills-primary pills-primary mt-4 mb-3 ' . $shortcode_justify . ' datebook-standard-tabs datebook-profile-tabs">';
			$layout .= '<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap ' . esc_attr(sanitize_html_class($profile_active)) . '" href="' . $profile_page_url . '"><small>' . esc_html__( 'Profile', 'datebook' ) . '</small></a></li>';

			$profile_photos_url = add_query_arg( array(
				'show' => 'photos'
			), $profile_page_url );

			$layout .= '<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap ' . esc_attr(sanitize_html_class($photos_active)) . '" href="' . $profile_photos_url . '"><small>' . esc_html__( 'Photos', 'datebook' ).'</small><span class="badge badge-pill badge-light datebook-badge-info shadow-none">' . absint($all_count_photos) . '</span></a></li>';

			if (self::$datebook_options['enable_friendship'] == '1') {

				$show_amount_of_friends = self::$datebook_options['show_amount_of_friends'] ? 1 : 0;

				$profile_friends = isset($datebook_get_data['friends_count']) && $datebook_get_data['friends_count'] > 0 ? $datebook_get_data['friends_count'] : 0;
				
				$profile_friends_url = add_query_arg( array(
					'show' => 'friends'
				), $profile_page_url );

				$layout .= '<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap ' . esc_attr(sanitize_html_class($friends_active)) . '" href="' . $profile_friends_url . '"><small>' . esc_html__( 'Friends', 'datebook' ) . '</small>';

				if ($show_amount_of_friends == 1){
					
					$get_profile_friends = DateBook_Profile_Friends::get_profile_friends($profile_post_author);
					
					$layout .= '<span class="badge badge-pill badge-light shadow-none datebook-badge-info datebook-friends-counter">' . absint($get_profile_friends['count_friends']) . '</span>';
				}

				$layout .= '</a></li>';

			}

			if (self::$datebook_options['enable_profile_comments'] == '1') {

				$profile_comments_url = add_query_arg( array(
					'show' => 'comments'
				), $profile_page_url );

				$layout .= '<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap ' . esc_attr(sanitize_html_class($comments_active)) . '" href="' . $profile_comments_url . '"><small>' . esc_html__( 'Comments', 'datebook' ) . '</small><span class="badge badge-pill badge-light datebook-badge-info shadow-none">' . absint(DateBook_Utilities::datebook_count_profile_comments($profile_id)) . '</span></a></li>';

			}

			if (self::$datebook_options['enable_reviews'] == '1') {
				
				$profile_reviews_url = add_query_arg( array(
					'show' => 'reviews'
				), $profile_page_url );

				$layout .= '<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap ' . esc_attr(sanitize_html_class($reviews_active)) . '" href="' . $profile_reviews_url . '"><small>' . esc_html__( 'Reviews', 'datebook' ) . '</small><span class="badge badge-pill badge-light datebook-badge-info shadow-none">' . absint(DateBook_Utilities::datebook_count_profile_reviews($profile_id)) . '</span></a></li>';

			}

			$layout .= '</ul>';

		} else {

			$layout .= '<ul class="nav nav-pills pills-primary pills-primary mt-4 mb-3 small ' . $shortcode_justify . ' datebook-standard-tabs datebook-profile-tabs">
							<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap active" href="./">' . esc_html__( 'Profile', 'datebook' ) . '</a></li>
							<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap" href="?show=photos">' . esc_html__( 'Photos', 'datebook' ) . ' <span class="badge badge-pill badge-light datebook-badge-info shadow-none">0</span></a></li>
							<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap" href="?show=friends">' . esc_html__( 'Friends', 'datebook' ) . ' <span class="badge badge-pill badge-light datebook-badge-info shadow-none">0</span></a></li>
							<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap" href="?show=comments">' . esc_html__( 'Comments', 'datebook' ) . '<span class="badge badge-pill badge-light datebook-badge-info shadow-none">0</span></a></li>
							<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap" href="?show=reviews">' . esc_html__( 'Reviews', 'datebook' ) . '<span class="badge badge-pill badge-light datebook-badge-info shadow-none">0</span></a></li>
						</ul>';

		}

		return $layout;

	}


	/**
	 * Return profile menu - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_menu() {

		$atts = array('shortcode' => 0);

		echo self::pre_profile_menu($atts);

	}


	/**
	 * Return profile custom fields, images, comments - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_custom_fields() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = '';
		
		if($profile_id > 1){

			global $datebook_alert_error;

			if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
				$current_user_id = DATEBOOK_CURRENT_USER_ID;
			} else {
				global $current_user;
				wp_get_current_user();
				$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
			}

			$profile_name = isset($profile->post_title) ? $profile->post_title : esc_html__( 'Profile Title', 'datebook' );
			$user_id = $profile->post_author;
			$currentauth = get_userdata($user_id);
			
			// Get Profile personal data
			$datebook_get_data = self::$datebook_get_data;
			
			$age = isset($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) : ((isset($datebook_get_data['dateyear']) && $datebook_get_data['dateyear'] > 0 && isset($datebook_get_data['datemonth']) && $datebook_get_data['datemonth'] > 0 && isset($datebook_get_data['dateday']) && $datebook_get_data['dateday'] > 0) ? floor((time() - strtotime($datebook_get_data['dateyear'] . '-' . $datebook_get_data['datemonth'] . '-' . $datebook_get_data['dateday']))/31556926) : '');
			
			$country = $region = $city = '';
			if(isset($datebook_get_data['city'])){
				$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
				$country = isset($term_data->country) ? $term_data->country : '';
				$region = isset($term_data->region) ? $term_data->region : '';
				$city = isset($term_data->city) ? $term_data->city : '';
			}
			
			$title_for_alt = $profile_name . ', ';
			if (isset($age) && $age < 1) {
				$title_for_alt .= $age . ' ' . esc_html__( 'years old', 'datebook' );
				$title_for_alt .= ', ';
			}
			if (isset($city)) {
				$title_for_alt .= $city;
			}
			if (!empty($city) && !empty($country)) {
				$title_for_alt .= ', ';
			}
			if (isset($country)) {
				$title_for_alt .= $country;
			}

			if (isset($_GET['show']) && $_GET['show'] == 'photos') {
				
				global $datebook_image_sizes;
				
				// Who can see my images
				$can_see_images_array = DateBook_Utilities::who_can_see_my_images($current_user_id, $currentauth, $profile_id, $datebook_get_data);

				$can_see_images = $can_see_images_array['allow'];
				$can_see_images_text = $can_see_images_array['text'];

				$upload_folder = isset($datebook_get_data['upload_folder']) ? $datebook_get_data['upload_folder'] : '';

				if($upload_folder == ''){
	
					$datebook_get_data['upload_folder'] = $upload_folder;
	
					update_post_meta($profile_id, 'profile_personal_data', $datebook_get_data);
	
				}
				$upload_dir = wp_upload_dir();
				$targetPath = $upload_dir['basedir'] . '/' . $upload_folder;
				
				if ($datebook_get_data['gender'] == 1) {

					$gender_icon = 'fa fa-venus fa-lg';
	
					$gender_img = '-f';
	
				} else if ($datebook_get_data['gender'] == 2) {

					$gender_icon = 'fa fa-mars fa-lg';

					$gender_img = '';

				} else {

					$gender_icon = 'fa fa-user fa-lg';

					$gender_img = '';

				}
				
				$all_photos_args = array(
					'post_parent' => $profile_id, 
					'post_status' => 'inherit', 
					'post_type' => 'attachment', 
					'post_mime_type' => 'image', 
					'orderby' => 'rand',
					'posts_per_page' => -1,
					'meta_query' => array(
						array('key' => DATEBOOK_IMAGE_TYPE, 'value' => DATEBOOK_PROFILE_IMAGE_TYPE, 'compare' => '=' )
					)
				);

				$all_photos = new WP_Query( $all_photos_args );

				$layout .= '<div class="col-lg-12 col-md-12 col-sm-12">';

				$layout .= '<h2 class="mb-4">' . esc_html__( 'My photos', 'datebook' );

				if (is_user_logged_in() && isset($currentauth->ID) && $currentauth->ID > 0 && $currentauth->ID == $current_user_id ) {
					$layout .= '<a class="btn btn-sm btn-default float-right" href="' . esc_url(get_permalink(self::$datebook_options['my_photos_page'])) . '"><i class="fa fa-image mr-1"></i> ' . esc_html__( 'Add photo', 'datebook' ) . '</a>';
				}
									
				$layout .= '</h2>';
				
				$layout .= '<figure id="blueimp-gallery-links">';

				$layout .= '<ul class="list-inline">';

				$count_all_photos = 0;

				while ( $all_photos->have_posts() ) : $all_photos->the_post();

					$count_all_photos++;

					$photo_url = explode('.', get_the_title());

					$thumbnail_file = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_gallery']['width'].'x' . $datebook_image_sizes['image_gallery']['height']) . '.' . strtolower($photo_url[1]);
					$thumbnail_file_blur = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_gallery']['width'].'x' . $datebook_image_sizes['image_gallery']['height'] . '-blur') . '.' . strtolower($photo_url[1]);
								

					if (!file_exists($targetPath . '/' . $thumbnail_file)) {

						if (!file_exists( $targetPath . '/' . get_the_title() )) {

							$thumb_noimage_name = str_replace('_','-', 'image_gallery');

							$thumbnail_url = DATEBOOK_URL . 'assets/images/no-' . $thumb_noimage_name . '' . $gender_img . '.png';

						} else {

							$image = wp_get_image_editor( $targetPath . '/' . get_the_title() );
							if ( ! is_wp_error( $image ) ) {
								$image->resize( $datebook_image_sizes['image_gallery']['width'], $datebook_image_sizes['image_gallery']['height'], true );
								$image->save($targetPath . '/' . $thumbnail_file);
								
								// Create and blur a new image
								$image->save($targetPath . '/' . $thumbnail_file_blur);
								$image->add_blur($targetPath . '/' . $thumbnail_file_blur);
							}
						}

						$thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_file;
						$thumbnail_url_blur = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_file_blur;

					} else {

						$thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_file;
						$thumbnail_url_blur = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_file_blur;

					}
					
					$thumbnail_url = ($can_see_images == 1 ? $thumbnail_url : $thumbnail_url_blur);
					
					if (file_exists($targetPath . '/' . $thumbnail_file)) {

						$big_thumbnail_url = $photo_url[0].'-'.$datebook_image_sizes['image_big']['width'].'x'.$datebook_image_sizes['image_big']['height'].'.'.strtolower($photo_url[1]);
						$big_thumbnail_url_blur = $photo_url[0].'-'.$datebook_image_sizes['image_big']['width'].'x'.$datebook_image_sizes['image_big']['height'].'-blur.'.strtolower($photo_url[1]);

						if (!file_exists($targetPath . '/' . $big_thumbnail_url)) {

							if (!file_exists( $targetPath . '/' . get_the_title() )) {

								$thumb_noimage_name = str_replace('_','-', 'image_avatar');

								$big_thumbnail_url = DATEBOOK_URL . 'assets/images/no-' . $thumb_noimage_name . '' . $gender_img . '.png';

							} else {

								$image = wp_get_image_editor( $targetPath . '/' . get_the_title() );
								if ( ! is_wp_error( $image ) ) {
									$image->resize( $datebook_image_sizes['image_big']['width'], $datebook_image_sizes['image_big']['height'], true );
									$image->save($targetPath . '/' . $big_thumbnail_url);

									// Create and blur a new image
									$image->save($targetPath . '/' . $big_thumbnail_url_blur);
									$image->add_blur($targetPath . '/' . $big_thumbnail_url_blur);
								}
							}

						} else {

							$big_thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $big_thumbnail_url;

						}

						$layout .= '<li class="list-inline-item"><a class="img-thumbnail d-block" href="' . esc_url($big_thumbnail_url) . '" data-lightbox="example-1"><img class="img-fluid" src="' . esc_url($thumbnail_url) . '" alt="' . esc_attr($title_for_alt) . '" width="' . $datebook_image_sizes['image_gallery']['width'] . '" height="' . $datebook_image_sizes['image_gallery']['height'] . '" /></a></li>';

					}

				endwhile;

				$layout .= '</ul>';
				
				$layout .= '</figure>';
				
				$layout .= '<div id="blueimp-gallery" class="blueimp-gallery blueimp-gallery-controls" style="display:none">
                        	<div class="slides"></div>
                            <h3 class="title"></h3>
                            <a class="prev">‹</a>
                            <a class="next">›</a>
                            <a class="close">×</a>
                            <a class="play-pause"></a>
                            <ol class="indicator"></ol>
						</div>';

				if ($count_all_photos == 0) {

					$layout .= '<div class="card border-0">';
					$layout .= '<div class="card-body text-center">';
					$layout .= '<h4>' . esc_html__( 'No photos', 'datebook' ) . '</h4>';
					$layout .= '<p><img src="' . esc_url(DATEBOOK_URL . 'assets/images/icon-profile-no-photos.png') . '" alt="' . esc_html__( 'No photos', 'datebook' ) . '" /></p>';
					$layout .= '</div>';
					$layout .= '</div>';
					
				}

				$layout .= '</div>';

			} else if (isset($_GET['show']) && $_GET['show'] == 'friends') {

				// Display comments and comment form
				if (self::$datebook_options['enable_friendship'] == '1') {

					$friends_data_array = get_user_meta($current_user_id, 'friends', true);
					
					if ($friends_data_array) {
						$get_approved_friends_ids = array_unique(explode(',', $friends_data_array));
					} else {
						$get_approved_friends_ids = array();
					}

					$options = array(
						'current_user_id' => $current_user_id,
						'profile_id' => $profile_id,
						'datebook_get_data' => $datebook_get_data,
						'get_approved_friends_ids' => $get_approved_friends_ids
					);

					$layout .= DateBook_Profile_Friends::pre_process_friends_list($options);

				}
				
			} else if (isset($_GET['show']) && $_GET['show'] == 'comments') {

				// Display comments and comment form
				if (self::$datebook_options['enable_profile_comments'] == '1') {

					$layout .= DateBook_Profile_Comments::return_profile_comments();

				}

			} else if (isset($_GET['show']) && $_GET['show'] == 'reviews') {

				// Display comments and comment form
				if (self::$datebook_options['enable_reviews'] == '1') {

					$layout .= DateBook_Class_Reviews::return_reviews();

				}

			} else {

				if (isset($currentauth->ID) && $currentauth->ID > 0) {

					global $allowedposttags;
					
					//Get custom fields member already filled in his profile
					$profile_edit_form_data = isset($datebook_get_data['edit_form']) ? $datebook_get_data['edit_form'] : array();

					// Escape all fields but keep HTML tags
					$layout .= wp_kses(stripslashes_deep(DateBook_Forms::show_filled_fields('profile_form', $profile_edit_form_data, $currentauth->ID, $current_user_id)), $allowedposttags );

				}

			} 

			wp_reset_postdata();
								

		} else {

			$layout .= '<div class="card-body">
							<div class="col-lg-12 col-md-12 col-sm-12">' . esc_html__( 'Profile custom fields, images, and comments', 'datebook' ) . '</div>
						</div>';

		}

		return $layout;

	}


	/**
	 * Return profile statistics - Shortcode
	 *
	 * @access public
	 * @return void
	 */
	public static function return_profile_statistics() {

		$profile = self::$profile_data;
		
		$profile_id = isset($profile->ID) ? $profile->ID : 0;
		
		$layout = '';
		
		if($profile_id > 1){

			// Get Profile personal data
			$datebook_get_data = self::$datebook_get_data;

			// Set and Get quantity of views
			$profile_views_enabled = 0;
			$profile_views = DateBook_Profile_Views::datebook_get_post_views($profile_id, $datebook_get_data);
			if ($profile_views != '') {
				$profile_views_enabled = 1;
			}

			$additional_profile_info = self::$datebook_options['show_profile_statistic'];
				
			if ($profile_views_enabled == 1 || $additional_profile_info['2'] == 1 || $additional_profile_info['3'] == 1 || $additional_profile_info['4'] == 1) {

				$added_date = isset($profile->post_date) ? DateBook_Utilities::datebook_date_i18n(1, $profile->post_date) : esc_html__( 'unknown', 'datebook' );
				$profile_post_name = isset($profile->post_name) ? $profile->post_name : '';

				$layout .= '<div class="small datebook-profile-otherdetails">';

				$layout .= $profile_views;

				if ($profile_views_enabled == 1 && $additional_profile_info['2'] == 1) {
					$layout .= ' | ';
				}	
				if ($additional_profile_info['2'] == 1) {
					$layout .= esc_html__( 'Joined on', 'datebook' ) . ': ' . esc_attr($added_date);
				}
				if ($additional_profile_info['3'] == 1) {
					$layout .= '<span class="float-right">';
					$layout .= esc_html__( 'ID', 'datebook' ) . ': ' . esc_attr($profile_post_name) . ' ';
					$layout .= '</span>';
				}
				if ($additional_profile_info['4'] == 1) {
					// Display Social buttons
					//$layout .= DateBook_Template_Loader::locate( 'profile/profile-social-buttons' );
				}

				$layout .= '</div>';

			}

		} else {

			$layout .= '<div class="card-footer border-0 datebook-profile-otherdetails">' . esc_html__( 'Profile statistics', 'datebook' ) . '</div>';

		}

		return $layout;

	}



	/**
	 * Translate month and weekday
	 * Borrowed from WordPress function date_i18n
	 *
	 * @access public
	 */
	public static function datebirth_i18n($unixtimestamp = false){

		global $wp_locale;

		$dateformat_select = of_get_option('birthdate_format') ? of_get_option('birthdate_format') : 1;
		
		switch ( $dateformat_select ) {

			case 1 : $dateformatstring = 'age'; break;
			case 2 : $dateformatstring = 'j F Y'; break;
			case 3 : $dateformatstring = 'F j, Y'; break;
			case 4 : $dateformatstring = 'j F'; break;
			case 5 : $dateformatstring = 'F j'; break;
			case 6 : $dateformatstring = 'F Y'; break;
			case 7 : $dateformatstring = 'Y'; break;
			default: $dateformatstring = 'age';

		}

		if($dateformatstring == 'age') {

			$age_number = isset($unixtimestamp) ? floor((time() - strtotime($unixtimestamp))/31556926) : '';

			$j = $age_number . ' ' . esc_html__( 'years old', 'datebook' );

		} else {

			$i = strtotime($unixtimestamp);

			/*
			 * Store original value for language with untypical grammars.
			 * See https://core.trac.wordpress.org/ticket/9396
			 */
			$req_format = $dateformatstring;

			if ( ( !empty( $wp_locale->month ) ) && ( !empty( $wp_locale->weekday ) ) ) {
				$datemonth = esc_html__( $wp_locale->get_month( date( 'm', $i ) ), 'datebook' );
				$datemonth_abbrev = $wp_locale->get_month_abbrev( $wp_locale->get_month( date( 'm', $i ) ) );
				$dateweekday = esc_html__( $wp_locale->get_weekday( date( 'w', $i ) ), 'datebook' );
				$dateweekday_abbrev = $wp_locale->get_weekday_abbrev( $wp_locale->get_weekday( date( 'w', $i ) ) );
				$datemeridiem = $wp_locale->get_meridiem( date( 'a', $i ) );
				$datemeridiem_capital = $wp_locale->get_meridiem( date( 'A', $i ) );
				$dateformatstring = ' '.$dateformatstring;
				$dateformatstring = preg_replace( "/([^\\\])D/", "\\1" . backslashit( $dateweekday_abbrev ), $dateformatstring );
				$dateformatstring = preg_replace( "/([^\\\])F/", "\\1" . backslashit( $datemonth ), $dateformatstring );
				$dateformatstring = preg_replace( "/([^\\\])l/", "\\1" . backslashit( $dateweekday ), $dateformatstring );
				$dateformatstring = preg_replace( "/([^\\\])M/", "\\1" . backslashit( $datemonth_abbrev ), $dateformatstring );
				$dateformatstring = preg_replace( "/([^\\\])a/", "\\1" . backslashit( $datemeridiem ), $dateformatstring );
				$dateformatstring = preg_replace( "/([^\\\])A/", "\\1" . backslashit( $datemeridiem_capital ), $dateformatstring );

				$dateformatstring = substr( $dateformatstring, 1, strlen( $dateformatstring ) -1 );
			}
			$timezone_formats = array( 'P', 'I', 'O', 'T', 'Z', 'e' );
			$timezone_formats_re = implode( '|', $timezone_formats );
			if ( preg_match( "/$timezone_formats_re/", $dateformatstring ) ) {
				$timezone_string = get_option( 'timezone_string' );
				if ( $timezone_string ) {
					$timezone_object = timezone_open( $timezone_string );
					$date_object = date_create( null, $timezone_object );
					foreach ( $timezone_formats as $timezone_format ) {
						if ( false !== strpos( $dateformatstring, $timezone_format ) ) {
							$formatted = date_format( $date_object, $timezone_format );
							$dateformatstring = ' '.$dateformatstring;
							$dateformatstring = preg_replace( "/([^\\\])$timezone_format/", "\\1" . backslashit( $formatted ), $dateformatstring );
							$dateformatstring = substr( $dateformatstring, 1, strlen( $dateformatstring ) -1 );
						}
					}
				}
			}
			$j = @date( $dateformatstring, $i );
			
		}

		return $j;
	}




	/**
	 * Show profile on Single Profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_single_profile_inside() {

		if (isset($_POST['action']) && $_POST['action'] == 'contacting') {

			// Someone sends a message to another user
			self::send_message_to_profile();

		}

		global $post, $datebook_field_titles, $datebook_image_sizes, $alert_success, $datebook_alert_error;

		if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
			$current_user_id = DATEBOOK_CURRENT_USER_ID;
		} else {
			global $current_user;
			wp_get_current_user();
			$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
		}

		set_query_var( 'datebook_field_titles', $datebook_field_titles );

		$datebook_field_titles = get_query_var( 'datebook_field_titles' );
		if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

		$profile_id = isset($post->ID) && $post->ID > 0 ? $post->ID : 0;

		if (is_super_admin()) {

			// If profile ID is not set in post_meta table then let's insert it
			$profile_id_of_current_user = get_user_meta( $current_user_id, 'profile_postid', true );

			if (!isset($profile_id_of_current_user)) {
				update_user_meta( $current_user_id, 'profile_postid', absint($profile_id) );
			}
		}

		// Get Profile personal data
		$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
		$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

		// Send signal to update missing profile meta data
		$update_get_data = 0;

		$datebook_get_data['profile_id'] = $profile_id;

		$datebook_get_data['profile_name'] = $profile_name = isset($post->post_title) ? $post->post_title : '';
		$profile_post_name = isset($post->post_name) ? $post->post_name : '';
		$profile_content = isset($post->post_content) ? $post->post_content : '';

		// Get profile photo set as default
		$profile_photo_id = isset($datebook_get_data['profile_photo_id']) ? $datebook_get_data['profile_photo_id'] : '';
		// Check if default photo set
		if ($profile_photo_id == ''){
			$profile_photo_id = get_post_meta($profile_id, 'profile_photo_id', true);
			$datebook_get_data['profile_photo_id'] = $profile_photo_id;
			// Update the post meta
			$update_get_data += 1;
		}

		// Check if Birthday exists in personal data
		if(isset($datebook_get_data['upload_folder']) && !empty($datebook_get_data['upload_folder'])){

			$upload_folder = $datebook_get_data['upload_folder'];

		} else {

			$datebook_get_data['upload_folder'] = $upload_folder = get_post_meta($profile_id, 'upload_folder', true);
			// If upload folder is not saved in the profile data then save it
			if($upload_folder == ''){
				$datebook_get_data['upload_folder'] = $upload_folder = time().rand(1,999);
			}
			$update_get_data += 1;

		}


		$added_date = isset($post->post_date) ? DateBook_Utilities::datebook_date_i18n(1, $post->post_date) : esc_html__( 'unknown', 'datebook' );


		// Check if Birthday exists in personal data
		if(isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday'])){

			$datebook_get_birthday = $datebook_get_data['birthday'];

			$get_birthday_array = explode('-', $datebook_get_birthday);

			$datebook_get_data['dateyear'] = $datebook_get_dateyear = isset($get_birthday_array[0]) && $get_birthday_array[0] > 0 ? $get_birthday_array[0] : (isset($datebook_get_data['dateyear']) ? $datebook_get_data['dateyear'] : 0);
			$datebook_get_data['datemonth'] = $datebook_get_data_datemonth = isset($get_birthday_array[1]) && $get_birthday_array[1] > 0 ? $get_birthday_array[1] : (isset($datebook_get_data['datemonth']) ? $datebook_get_data['datemonth'] : 0);
			$datebook_get_data['dateday'] = $datebook_get_data_dateday = isset($get_birthday_array[2]) && $get_birthday_array[2] > 0 ? $get_birthday_array[2] : (isset($datebook_get_data['dateday']) ? $datebook_get_data['dateday'] : 0);

		} else {

			$get_birthday_arg = get_post_meta($profile_id, 'birthday', true);

			$get_birthday_array = explode('-', $get_birthday_arg);
			$datebook_get_data['dateyear'] = $datebook_get_dateyear = isset($get_birthday_array[0]) && $get_birthday_array[0] > 0 ? $get_birthday_array[0] : 0;
			$datebook_get_data['datemonth'] = $datebook_get_data_datemonth = isset($get_birthday_array[1]) && $get_birthday_array[1] > 0 ? $get_birthday_array[1] : 0;
			$datebook_get_data['dateday'] = $datebook_get_data_dateday = isset($get_birthday_array[2]) && $get_birthday_array[2] > 0 ? $get_birthday_array[2] : 0;

			$datebook_get_birthday = $get_birthday_arg;

			$datebook_get_data['birthday'] = $get_birthday_arg;

			$update_get_data += 1;

		}

		$age_format = isset($datebook_get_birthday) ? $datebook_get_birthday : ((isset($datebook_get_dateyear) && isset($datebook_get_data_datemonth) && isset($datebook_get_data_dateday)) ? $datebook_get_dateyear . '-' . $datebook_get_data_datemonth . '-' . $datebook_get_data_dateday : '');
		
		$age = !empty($age_format) ? self::datebirth_i18n($age_format) : '';

		$age_number = isset($datebook_get_birthday) && !empty($datebook_get_birthday) ? floor((time() - strtotime($datebook_get_birthday))/31556926) : ((isset($datebook_get_dateyear) && $datebook_get_dateyear > 0 && isset($datebook_get_data_datemonth) && $datebook_get_data_datemonth > 0 && isset($datebook_get_data_dateday) && $datebook_get_data_dateday > 0) ? floor((time() - strtotime($datebook_get_dateyear . '-' . $datebook_get_data_datemonth . '-' . $datebook_get_data_dateday))/31556926) : '');

		$datemonth = isset($datebook_get_data_datemonth) ? $datebook_get_data_datemonth : 0;
		$dateday = isset($datebook_get_data_dateday) ? $datebook_get_data_dateday : 0;

		// Check if Gender exists in personal data
		if(isset($datebook_get_data['gender']) && $datebook_get_data['gender'] > 0){

			$gender_id = $datebook_get_data['gender'];

		} else {

			$gender_id = get_post_meta($profile_id, 'gender', true);
			$datebook_get_data['gender'] = $gender_id;
			$update_get_data += 1;

		}

		$get_data_gender = isset($gender_id) ? $gender_id : 0;


		// Check if Sexual orientation exists in personal data
		if(isset($datebook_get_data['sexualorientation']) && $datebook_get_data['sexualorientation'] > 0){

			$sexualorientation = $datebook_get_data['sexualorientation'];

		} else {

			$sexualorientation = get_post_meta($profile_id, 'sexualorientation', true);
			$datebook_get_data['sexualorientation'] = $sexualorientation;
			$update_get_data += 1;

		}


		$get_data_hidezodiac = isset($datebook_get_data['hidezodiac']) ? $datebook_get_data['hidezodiac'] : 0;

		$country = $region = $city = '';

		// Check if City exists in personal data
		if(isset($datebook_get_data['city']) && $datebook_get_data['city'] > 0){

			$city_id = $datebook_get_data['city'];

			// Get city from meta data
			$city_meta_id = get_post_meta($profile_id, 'city', true);

			// Update post meta if city is wrong
			if($datebook_get_data['city'] != $city_meta_id){

				$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
				$country_id = isset($term_data->country_id) ? $term_data->country_id : '';
				$region_id = isset($term_data->region_id) ? $term_data->region_id : '';

				update_post_meta($profile_id, 'city', absint($datebook_get_data['city']));
				update_post_meta($profile_id, 'region', $region_id);
				update_post_meta($profile_id, 'country', $country_id);

				$datebook_get_data['region'] = $region_id;
				$datebook_get_data['country'] = $country_id;

				$update_get_data += 1;

			}

		} else {

			$city_id = get_post_meta($profile_id, 'city', true);

			$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
			$country_id = isset($term_data->country_id) ? $term_data->country_id : '';
			$region_id = isset($term_data->region_id) ? $term_data->region_id : '';

			update_post_meta($profile_id, 'city', $city_id);
			update_post_meta($profile_id, 'region', $region_id);
			update_post_meta($profile_id, 'country', $country_id);

			$datebook_get_data['city'] = $city_id;
			$datebook_get_data['region'] = $region_id;
			$datebook_get_data['country'] = $country_id;

			$update_get_data += 1;

		}

		if($city_id > 0){

			$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
			$country = isset($term_data->country) ? $term_data->country : '';
			$region = isset($term_data->region) ? $term_data->region : '';
			$city = isset($term_data->city) ? $term_data->city : '';

		}
		
		
		//Get custom fields member already filled in his profile
		$profile_edit_form_data = isset($datebook_get_data['edit_form']) ? $datebook_get_data['edit_form'] : array();
		// Check if default photo set
		if ($profile_edit_form_data == ''){
			$edit_form = get_post_meta($profile_id, 'edit_form', true);
			$datebook_get_data['edit_form'] = $edit_form;
			// Update the post meta
			$update_get_data += 1;
		}
		$profile_edit_form_data['aboutyou'] = $profile_content;
		
		$profile_edit_form_data['profilename'] = $profile_name;
		$profile_edit_form_data['countrycity'] = 1;
		$profile_edit_form_data['countrycity_title'] = $city . ', ' . $region . ', ' . $country;
		$profile_edit_form_data['birthdate'] = $age;
		

		if(isset($profile_edit_form_data['profiletypereserved']) && $profile_edit_form_data['profiletypereserved'] > 0){
			$profile_edit_form_data['profiletypereserved'] = $profile_edit_form_data['profiletypereserved'];
		} else if(isset($datebook_get_data['profiletypereserved']) && $datebook_get_data['profiletypereserved'] > 0){
			$profile_edit_form_data['profiletypereserved'] = $datebook_get_data['profiletypereserved'];
		} else {
			$term_list = wp_get_post_terms($profile_id, DATEBOOK_PROFILES_TAX, array('fields' => 'all'));
			$term_id = isset($term_list[0]->term_id) ? $term_list[0]->term_id : 0;
			$profile_edit_form_data['profiletypereserved'] = $term_id;
		}


		// Update the post meta
		if($update_get_data > 1){
			update_post_meta($profile_id, 'profile_personal_data', $datebook_get_data);
		}
		
		$user_id = $post->post_author;

		$currentauth = get_userdata($user_id);
		$currentauth_ID = isset($currentauth->ID) && $currentauth->ID > 0 ? $currentauth->ID : 0;

		/*if ((DateBook_Utilities::datebook_show_field('profile_name', 2) && !$profile_name) || 
		(DateBook_Utilities::datebook_show_field('birthdate', 2) && isset($datebook_get_birthday) && empty($datebook_get_birthday)) || 
		(DateBook_Utilities::datebook_show_field('gender', 2) && isset($get_data_gender) && $get_data_gender < 1) || 
		(DateBook_Utilities::datebook_show_field('countrycity', 2) && isset($city) && strlen($city) < 1 && isset($country) && strlen($country) < 1)) {

			include DateBook_Template_Loader::locate( 'profile/single-profile-notactive' );

		} else {*/

			$profile_edit_form_data['email'] = isset($currentauth->user_email) ? $currentauth->user_email : '';
			$profile_edit_form_data['user'] = isset($currentauth->user_login) ? $currentauth->user_login : '';

			if ($currentauth_ID > 0 && $currentauth_ID != $current_user_id && !is_super_admin()) {

				// Insert ID of member who visited this profile
				DateBook_Profile_Views::datebook_set_who_viewed_me($user_id, $current_user_id);

			}

			// Set and Get quantity of views
			$profile_views = DateBook_Profile_Views::datebook_get_post_views($profile_id, $datebook_get_data, 0, $currentauth_ID, $current_user_id);

			// Get Subscription plans
			$get_subscription_plans = get_option('datebook_subscription_plans');
			
			$wishtravel = DateBook_Utilities::datebook_show_field('wishtravel', 1) && isset($datebook_get_data['wishtravel']) ? $datebook_get_data['wishtravel'] : 0;
			$wishtraveltext = !empty($datebook_get_data['wishtraveltext']) ? $datebook_get_data['wishtraveltext'] : '';

			$profile_page_url = get_permalink($profile_id);

			$upload_dir = wp_upload_dir();
			$targetPath = $upload_dir['basedir'] . '/' . $upload_folder;


			$title_for_alt = $profile_name . ', ';
			if (isset($age)) {
				$title_for_alt .= $age;
				$title_for_alt .= ', ';
			}
			if (isset($city)) {
				$title_for_alt .= $city;
			}
			if (!empty($city) && !empty($country)) {
				$title_for_alt .= ', ';
			}
			if (isset($country)) {
				$title_for_alt .= $country;
			}


			if ($get_data_gender == 1) {

				$gender_icon = 'fa fa-venus fa-lg';

				$gender_img = '-f';

			} else if ($get_data_gender == 2) {

				$gender_icon = 'fa fa-mars fa-lg';

				$gender_img = '-m';

			} else {

				$gender_icon = 'fa fa-user fa-lg';

				$gender_img = '';

			}


			$featured = get_post_meta($profile_id, 'featured', true);
			if ($featured == '1') {

				$featured_class = ' datebook-featured-block';

				/*add_filter( 'post_class', function( $classes ) {
					return array_merge( $classes, array( 'datebook-featured-style' ) );
				} );*/

			} else {

				$featured_class = '';

			}

			//echo DateBook_Template_Loader::load( 'profile/single-profile' );
			include(DateBook_Template_Loader::locate('profile/single-profile'));

		//}
	}


}

//DateBook_Profile_Edit::init($datebook_options_array);
$dateBook_profile_edit = new DateBook_Profile_Edit($datebook_options_array);