<?php
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


/**
 * Cookie Notice class.
 */
class DateBook_Class_Reviews {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 3.7
	 * @access public
	 */
	public static function init() {

		add_action( 'average_rating', array( __CLASS__, 'datebook_reviews_stars' ));
		add_shortcode( 'average_rating', array( __CLASS__, 'datebook_reviews_stars' ));
		add_filter( 'comment_post_redirect', array( __CLASS__, 'datebook_reviews_comment_redirect' ));
		//add_filter( 'notify_moderator', array( __CLASS__, 'datebook_reviews_disable_default_moderation_message'), 10, 2 );
		//add_filter( 'notify_post_author', array( __CLASS__, 'datebook_reviews_disable_default_moderation_message'), 10, 2 );
		add_filter( 'comment_notification_recipients', array( __CLASS__, 'datebook_reviews_notification_recipients'), 10, 2 );
		add_filter( 'comment_moderation_recipients', array( __CLASS__, 'datebook_reviews_notification_recipients'), 10, 2 );
		add_filter( 'comment_notification_text', array( __CLASS__, 'datebook_reviews_notification_text'), 10, 2 );
		add_filter( 'comment_notification_subject', array( __CLASS__, 'datebook_reviews_notification_subject'), 10, 2 );
		add_filter( 'comment_moderation_text', array( __CLASS__, 'datebook_reviews_moderation_text'), 10, 2 );
		add_filter( 'comment_moderation_subject', array( __CLASS__, 'datebook_reviews_moderation_subject'), 10, 2 );
		add_filter( 'comments_open', array( __CLASS__, 'datebook_reviews_force_open'), 10, 2 );
		add_action( 'single_names_table', array( __CLASS__, 'datebook_reviews_labels_settings' ));
		add_action( 'datebook_reviews', array( __CLASS__, 'datebook_reviews_replace_default_comments_form'), 20 );

	}


	/**
	 * Returns active comment types array
	 */
	public static function datebook_reviews_get_active_comment_types() {
		$types = array( DATEBOOK_REVIEW_TYPE );
		$types[] = DATEBOOK_REVIEW_TYPE . '_' . DATEBOOK_POST_TYPE;
		return $types;
	}
	

	/**
	 * Delete submitted review
	 *
	 * @access private
	 */
	private static function datebook_delete_review() {
	
		if ( !isset($_GET['action']) && $_GET['action'] != 'deletereview' && !isset($_GET['sid']) && absint($_GET['sid']) <= 0) {
				return;
		}

		// Get current user ID
		if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
			$current_user_id = DATEBOOK_CURRENT_USER_ID;
		} else {
			global $current_user;
			wp_get_current_user();
			$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
		}
		
		$user_role = get_user_meta( $current_user_id, 'profile_type', true );
		
		$layout = '';

		// Someone submits comment to profile. If field is left empty, add the error message to the error object
		if ($user_role == DATEBOOK_POST_TYPE && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {
			
			if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
				exit();
			}

			$get_comment_id = absint($_GET['sid']);
			$comment_data = get_comment( $get_comment_id );
			$author_id = isset($comment_data) && $comment_data->user_id > 0 ? $comment_data->user_id : 0;

			if ($author_id == $current_user_id || is_super_admin()) {

				$comment_ID = isset($comment_data) && $comment_data->comment_ID > 0 ? $comment_data->comment_ID : 0;
				
				if ($comment_ID > 1){
				
					$confirm_delete_comment = wp_delete_comment($comment_data->comment_ID, true);

					if (!$confirm_delete_comment) {

						$layout .= '<div class="alert alert-danger">' . esc_html__( 'Oops! Review has not been deleted or does not exist', 'datebook' ) . '</div>';

					} else {

						$layout .= '<div class="alert alert-success">' . esc_html__( 'Review has been deleted successfully!', 'datebook' ) . '</div>';

					}

				} else {

					$layout .= '<div class="alert alert-danger">' . esc_html__( 'Oops! Review has not been deleted or does not exist', 'datebook' ) . '</div>';

				}

			} else {

				$layout .= '<div class="alert alert-danger">' . esc_html__( 'You have no permission to delete this review', 'datebook' ) . '</div>';

			}
		}

		return $layout;

	}


	/**
	 * Validate submitted comment
	 */
	public static function datebook_validate_review() {

		global $datebook_form_error;

		$update_data = array();

		// instantiate the class
		$datebook_form_error = new WP_Error;

		$update_data['review_description'] = wp_trim_words(sanitize_text_field(wp_strip_all_tags($_POST['review_description'])), 1000, '');
		if (!$update_data['review_description']) {
			$datebook_form_error->add( 'review_description', esc_html__( 'You didn\'t write a comment', 'datebook' ), 'has-error' );
		}

		return $update_data;

	}


	/**
	 * Update all data
	 *
	 * @access private
	 * @return void
	 */
	public static function datebook_save_review() {

		// validate the comment form input
		$datebook_get_data = self::datebook_validate_review();

		// Make global    
		global $current_user, $datebook_form_error;
		wp_get_current_user();

		if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
			$current_user_id = DATEBOOK_CURRENT_USER_ID;
		} else {
			global $current_user;
			wp_get_current_user();
			$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
		}

		// Ensure WP_Error object ($datebook_form_error) contains no error
		if ( 1 > count( $datebook_form_error->get_error_messages() ) && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {
			
			if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
				exit();
			}

			if (of_get_option('activate_manual_reviews') == '1') {
				$review_status = '0';
			} else {
				$review_status = '1';
			}

			$comment_post_ID = get_the_ID();

			$commenter_agent = $_SERVER['HTTP_USER_AGENT'];
			$commenter_remote_IP = $_SERVER['REMOTE_ADDR'];

			$datebook_get_data['review_description'] = DateBook_Utilities::datebook_word_filter($datebook_get_data['review_description']);

			$data = array(
				'comment_post_ID' => $comment_post_ID,
				'comment_author' => $current_user->display_name,
				'comment_author_email' => $current_user->user_email,
				'comment_author_IP' => $commenter_remote_IP,
				'comment_content' => $datebook_get_data['review_description'],
				'comment_approved' => $review_status,
				'comment_agent' => $commenter_agent,
				'user_id' => $current_user_id,
			);

			$review_submit_id = wp_insert_comment($data);

			// Add comment meta
			add_comment_meta( $review_submit_id, 'comment_type', DATEBOOK_REVIEW_TYPE );
			
			if ( isset( $_POST[ 'datebook_review_rating' ] ) ) {
				$rating = intval( $_POST[ 'datebook_review_rating' ] );
				if ( !empty( $rating ) ) {
					update_comment_meta( $review_submit_id, 'review_rating', $rating );
				}
			}
			if ( isset( $_POST[ 'datebook_review_title' ] ) ) {

				$title = DateBook_Utilities::datebook_word_filter(sanitize_text_field($_POST['datebook_review_title']));
				
				if ( !empty( $title ) ) {
					update_comment_meta( $review_submit_id, 'review_title', $title );
				}
			}


			if (of_get_option("email_when_comment") == "1" || of_get_option("activate_reviews_manually") == "1") {

				$review_edit_url_for_admin = admin_url('post.php?post='.$review_submit_id.'&action=edit');

				$body = esc_html__( 'Hello admin', 'datebook' ).',<br />';
				$body .= esc_html__( 'Someone wrote a profile review on', 'datebook' ) . ' ' . sanitize_email(of_get_option('email_sitename')) . ':<br /><br />';
				$body .= esc_html__( 'Read/Edit the review here', 'datebook' ) . ':<br />';
				$body .= '<a href="'.esc_url($review_edit_url_for_admin).'">' . esc_url($review_edit_url_for_admin) . '</a><br />';
				$body .= esc_html__( '(to activate the review simply click the button "Publish")', 'datebook' );
				
				$to_email = of_get_option('email_website') ? of_get_option('email_website') : get_bloginfo('admin_email');
				$subject_in_email = esc_html__( 'A new review is waiting for approval on', 'datebook' ) . ' ' . of_get_option('email_sitename');

				$datebook_mail = DateBook_Utilities::datebook_email_send(NULL, NULL, $to_email, $subject_in_email, $body);

			}

			return '<div class="alert alert-success">' . esc_html__( 'Thank you for review', 'datebook' ) . '</div>';

		} else {

			return '<div class="alert alert-danger">' . esc_html__( 'Oops! Your review has not been submitted', 'datebook' ) . '</div>';

		}

	}


	/**
	 * Saves review rating value
	 */
	public static function datebook_reviews_save_rating() {

		self::datebook_save_review();

	}


	/**
	 * Checks if commentis a review
	 */
	public static function datebook_reviews_if_comment_is_review( $comment_id ) {
		$comment_type	 = get_comment_type( $comment_id );
		$comment_types	 = self::datebook_reviews_get_active_comment_types();
		if ( in_array( $comment_type, $comment_types ) ) {
			return true;
		}
		return false;
	}


	/**
	 * Return product review value
	 */
	public static function datebook_reviews_get_rating( $review_id ) {
		$rating = empty( $review_id ) ? 0 : intval( get_comment_meta( $review_id, 'review_rating', true ) );
		return $rating;
	}


	/**
	 * Returns review rating totals
	 */
	public static function datebook_reviews_get_totals( $product_id ) {

		$args = array( 'meta_key' => 'comment_type', 'meta_value' => DATEBOOK_REVIEW_TYPE, 'post_id' => $product_id, 'status' => 'approve' );
		$reviews = get_comments( $args );

		$total = array( 0, 0, 0, 0, 0, 0, 'total' => 0 );

		foreach ( $reviews as $review ) {
			$rating = self::datebook_reviews_get_rating( $review->comment_ID );
			$total[$rating] += 1;
			if (!empty($rating)){
				$total['total'] += 1;
			}
		}
		return $total;
	}


	/**
	 * Returns average rating number
	 */
	public static function datebook_reviews_average( $product_id ) {
		$totals = self::datebook_reviews_get_totals( $product_id );
		$total_summary = $totals[ 'total' ];
		if ( !empty( $total_summary ) ) {
			unset( $totals[ 'total' ] );
			unset( $totals[ 0 ] );
			krsort( $totals );
			$total_achieved = 0;
			foreach ( $totals as $key => $total ) {
				$total_achieved += $key * $total;
			}
			$max = $total_summary * 5;
			$total_score = number_format( ($total_achieved / $max) * 5, 1 );
			return $total_score;
		}
		return 0;
	}


	/**
	 * Returns review rating HTML
	 */
	public static function datebook_reviews_show_rating( $profile_id, $review_id = 0, $editable = null, $label = null, $rating = null, $display_text = 0 ) {

		$reviews_settings = of_get_option('enable_reviews') ? 1 : 0;

		if ($reviews_settings == 0) {
			return;
		}
		if ( $rating === null ) {
			$rating = empty( $review_id ) ? 0 : self::datebook_reviews_get_rating( $review_id );
		}
		
		if ( !empty( $editable ) ) {
			$return = '<p class="mb-2 datebook-review-rating allow-edit"><input type="hidden" name="datebook_review_rating" value="' . $rating . '">';
		} else {
			$return = '<p class="mb-2 datebook-review-rating" data-current_rating="' . $rating . '">';
		}
		if ( $label == 1 ) {
			$label = esc_html__( 'Item Rating', 'datebook' );
		}
		if ( !empty( $label ) ) {
			$return .= '<label class="rating-label" for="datebook_review_rating">' . $label . '</label>';
		}
		for ( $i = 1; $i <= $rating; $i++ ) {
			$return .= '<span class="datebook-rate-star rating-on rate-' . $i . '" data-rating="' . $i . '"></span>';
		}
		$rounded_rating = round( $rating );
		if ( $rounded_rating !== $rating ) {
			if ( abs( $rounded_rating - $rating ) > 0.2 ) {
				$return .= '<span class="datebook-rate-star rating-off rate-half" data-rating="' . $i . '"></span>';
			} else {
				$rating = floor( $rating );
			}
		}
		$off_rating = 5 - $rating;
		for ( $i = 1; $i <= $off_rating; $i++ ) {
			$a		 = $i + $rating;
			$return	 .= '<span class="datebook-rate-star rating-off rate-' . $a . '" data-rating="' . $a . '"></span>';
		}

		if($display_text == 1){
			$return .= self::datebook_reviews_get_totals_html($profile_id);
		}

		$return .= '</p>';
		return $return;
	}


	/**
	 * Returns average star rating html
	 */
	public static function datebook_reviews_average_html( $display_text, $profile_id = null ) {
		if ( empty( $profile_id ) ) {
			$profile_id = get_the_ID();
		}
		$average = self::datebook_reviews_average( $profile_id );

		return self::datebook_reviews_show_rating( $profile_id, 0, false, null, $average, $display_text );

	}


	/**
	 * Shows average star rating for entry
	 */
	public static function datebook_reviews_stars($profile_id){

		$display_text = 1;

		//$args = shortcode_atts(array('id' => get_the_ID()), $atts);
		//$product_id = intval($args['id']);
		if (!empty($profile_id)){
			echo self::datebook_reviews_average_html($display_text, $profile_id);
		}
	}


	public static function datebook_reviews_show_rating_stars( $how_many ) {
		$return = '<p class="datebook-review-rating" data-current_rating="' . $how_many . '">';
		for ( $i = 1; $i <= $how_many; $i++ ) {
			$return .= '<span class="rating-on rate-' . $i . '" data-rating="' . $i . '"></span>';
		}
		$return .= '</p>';
		return $return;
	}


	public static function datebook_reviews_comment_redirect( $location ) {
		$location = str_replace( 'comment', 'review', $location );
		if ( !empty( $_POST[ 'datebook_reviews_redirect' ] ) ) {
			$new		 = explode( '#', $location );
			$new[ 0 ]	 = esc_url( $_POST[ 'datebook_reviews_redirect' ] );
			$location	 = $new[ 0 ] . '#' . $new[ 1 ];
		}
		return $location;
	}



	/**
	 * Disables default comment notification for reviews
	 */
	public static function datebook_reviews_disable_default_moderation_message( $notify, $comment_id ) {
		if ( $notify ) {
			if ( self::datebook_reviews_if_comment_is_review( $comment_id ) ) {
				return false;
			}
		}
		return $notify;
	}


	/**
	 * Defines review notification recipients
	 */
	public static function datebook_reviews_notification_recipients( $emails, $comment_id ) {
		if ( self::datebook_reviews_if_comment_is_review( $comment_id ) ) {
			return false;
		}
		return $emails;
	}


	/**
	 * Returns review product name
	 */
	public static function datebook_reviews_get_review_product_name( $review_id ) {
		$comment = get_comment( $review_id );
		$post	 = get_post( $comment->comment_post_ID );
		return $post->post_title;
	}


	/**
	 * Defines comment notification text
	 */
	public static function datebook_reviews_notification_text( $notify_message, $comment_id ) {
		if ( self::datebook_reviews_if_comment_is_review( $comment_id ) ) {
			$comment				 = get_comment( $comment_id );
			$product_name			 = self::datebook_reviews_get_review_product_name( $comment_id );
			$notify_message			 = sprintf( esc_html__( 'New review on %s' ), $product_name ) . "\r\n";
			/* translators: 1: comment author, 2: author IP, 3: author domain */
			$comment_author_domain	 = @gethostbyaddr( $comment->comment_author_IP );
			$notify_message			 .= sprintf( esc_html__( 'Author: %1$s (IP: %2$s, %3$s)' ), $comment->comment_author, $comment->comment_author_IP, $comment_author_domain ) . "\r\n";
			$notify_message			 .= sprintf( esc_html__( 'Email: %s' ), $comment->comment_author_email ) . "\r\n";
			//$notify_message .= sprintf( esc_html__( 'URL: %s' ), $comment->comment_author_url ) . "\r\n";
			$review_content			 = wp_specialchars_decode( $comment->comment_content );
			$notify_message			 .= sprintf( esc_html__( 'Review: %s' ), "\r\n" . $review_content ) . "\r\n\r\n";
			$post_type				 = get_post_type( $comment->comment_post_ID );
			$post_type_o			 = get_post_type_object( $post_type );
			$notify_message			 .= sprintf( esc_html__( 'You can see all reviews on this %s here:' ), $post_type_o->labels->singular_name ) . "\r\n";
			$notify_message			 .= get_permalink( $comment->comment_post_ID ) . "#reviews\r\n\r\n";
			$notify_message			 .= sprintf( esc_html__( 'Permalink: %s' ), get_comment_link( $comment ) ) . "\r\n";
			/*
			$post					 = get_post( $comment->comment_post_ID );
			if ( user_can( $post->post_author, 'edit_comment', $comment->comment_ID ) ) {
				if ( EMPTY_TRASH_DAYS ) {
					$notify_message .= sprintf( esc_html__( 'Trash it: %s' ), admin_url( "comment.php?action=trash&c={$comment->comment_ID}&trash_review={$comment_id}#wpbody-content" ) ) . "\r\n";
				} else {
					$notify_message .= sprintf( esc_html__( 'Delete it: %s' ), admin_url( "comment.php?action=delete&c={$comment->comment_ID}&delete_review={$comment_id}#wpbody-content" ) ) . "\r\n";
				}
				$notify_message .= sprintf( esc_html__( 'Spam it: %s' ), admin_url( "comment.php?action=spam&c={$comment->comment_ID}&spam_review={$comment_id}#wpbody-content" ) ) . "\r\n";
			}
			*/
		}
		return $notify_message;
	}



	/**
	 * Defines comment notification subject
	 */
	public static function datebook_reviews_notification_subject( $subject, $comment_id ) {
		if ( self::datebook_reviews_if_comment_is_review( $comment_id ) ) {
			$blogname	 = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
			$subject	 = sprintf( esc_html__( '[%1$s] Review: "%2$s"' ), $blogname, self::datebook_reviews_get_review_product_name( $comment_id ) );
		}
		return $subject;
	}



	/**
	 * Defines comment moderation text
	 */
	public static function datebook_reviews_moderation_text( $notify_message, $comment_id ) {
		if ( self::datebook_reviews_if_comment_is_review( $comment_id ) ) {
			$comment				 = get_comment( $comment_id );
			$product_name			 = self::datebook_reviews_get_review_product_name( $comment_id );
			$notify_message			 = sprintf( esc_html__( 'A new review on the %s is waiting for your approval' ), $product_name ) . "\r\n";
			$notify_message			 .= get_permalink( $comment->comment_post_ID ) . "\r\n\r\n";
			$comment_author_domain	 = @gethostbyaddr( $comment->comment_author_IP );
			$notify_message			 .= sprintf( esc_html__( 'Author: %1$s (IP: %2$s, %3$s)' ), $comment->comment_author, $comment->comment_author_IP, $comment_author_domain ) . "\r\n";
			$notify_message			 .= sprintf( esc_html__( 'Email: %s' ), $comment->comment_author_email ) . "\r\n";
			//$notify_message .= sprintf( esc_html__( 'URL: %s' ), $comment->comment_author_url ) . "\r\n";
			$review_content			 = wp_specialchars_decode( $comment->comment_content );
			$notify_message			 .= sprintf( esc_html__( 'Review: %s' ), "\r\n" . $review_content ) . "\r\n\r\n";
			/*
			 * NEEDS IMPROVEMENTS ON THE FUNCTIONALITY AFTER CLICKING ON IT
			  $notify_message .= sprintf( esc_html__( 'Approve it: %s' ), admin_url( "comment.php?action=approve&c={$comment_id}&approve_review={$comment_id}#wpbody-content" ) ) . "\r\n";
			  if ( EMPTY_TRASH_DAYS ) {
				  $notify_message .= sprintf( esc_html__( 'Trash it: %s' ), admin_url( "comment.php?action=trash&c={$comment_id}&trash_review={$comment_id}#wpbody-content" ) ) . "\r\n";
			  } else {
				  $notify_message .= sprintf( esc_html__( 'Delete it: %s' ), admin_url( "comment.php?action=delete&c={$comment_id}&delete_review={$comment_id}#wpbody-content" ) ) . "\r\n";
			  }
			  $notify_message .= sprintf( esc_html__( 'Spam it: %s' ), admin_url( "comment.php?action=spam&c={$comment_id}&spam_review={$comment_id}#wpbody-content" ) ) . "\r\n";
			 *
			 */
			global $wpdb;
			$comment_type			 = get_comment_type( $comment_id );
			$post_type				 = get_post_type( $comment->comment_post_ID );
			$reviews_waiting		 = $wpdb->get_var( "SELECT count(comment_ID) FROM $wpdb->comments WHERE comment_approved = '0' AND comment_type = '$comment_type'" );
			$notify_message			 .= sprintf( _n( 'Currently %s review is waiting for approval. Please visit the moderation panel:', 'Currently %s reviews are waiting for approval. Please visit the moderation panel:', $reviews_waiting ), number_format_i18n( $reviews_waiting ) ) . "\r\n";
			$notify_message			 .= admin_url( "edit.php?post_type=" . $post_type . "&page=datebook_reviews_" . $post_type . "&comment_type=" . $comment_type . "&comment_status=moderated#wpbody-content" ) . "\r\n";
		}
		return $notify_message;
	}



	/**
	 * Defines comment moderation subject
	 */
	public static function datebook_reviews_moderation_subject( $subject, $comment_id ) {
		if ( self::datebook_reviews_if_comment_is_review( $comment_id ) ) {
			$blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
			$subject = sprintf( esc_html__( '[%1$s] moderate review of %2$s' ), $blogname, self::datebook_reviews_get_review_product_name( $comment_id ) );
		}
		return $subject;
	}



	public static function datebook_reviews_force_open( $open, $post_id ) {
		$post_type	 = get_post_type( $post_id );
			return true;
		return $open;
	}


	public static function datebook_reviews_labels_settings( $single_names ) {
		?>
		<tr><td><?php esc_html_e( 'Reviews Header', 'datebook' ); ?></td><td><input type="text" name="single_names[reviews]" value="<?php echo esc_html( $single_names[ 'reviews' ] ); ?>" /></td></tr>
		<tr><td><?php esc_html_e( 'Rating Title', 'datebook' ); ?></td><td><input type="text" name="single_names[rating_tite]" value="<?php echo esc_html( $single_names[ 'rating_tite' ] ); ?>" /></td></tr>
		<tr><td><?php esc_html_e( 'Review title label', 'datebook' ); ?></td><td><input type="text" name="single_names[review_title]" value="<?php echo esc_html( $single_names[ 'review_title' ] ); ?>" /></td></tr>
		<tr><td><?php esc_html_e( 'Review text label', 'datebook' ); ?></td><td><input type="text" name="single_names[review_text]" value="<?php echo esc_html( $single_names[ 'review_text' ] ); ?>" /></td></tr>
		<tr><td><?php esc_html_e( 'Closed Reviews', 'datebook' ); ?></td><td><input type="text" name="single_names[reviews_closed]" value="<?php echo esc_html( $single_names[ 'reviews_closed' ] ); ?>" /></td></tr>
		<tr><td><?php esc_html_e( 'Review Reply Title', 'datebook' ); ?></td><td><input type="text" name="single_names[review_reply_title]" value="<?php echo esc_html( $single_names[ 'review_reply_title' ] ); ?>" /></td></tr>
		<tr><td><?php esc_html_e( 'Review Submit Label', 'datebook' ); ?></td><td><input type="text" name="single_names[review_submit_label]" value="<?php echo esc_html( $single_names[ 'review_submit_label' ] ); ?>" /></td></tr>
		<?php
	}



	public static function datebook_reviews_standard_labels( $single_names = array() ) {
		$single_names[ 'reviews' ]				 = esc_html__( 'Reviews', 'datebook' );
		$single_names[ 'rating_tite' ]			 = esc_html__( 'Your Rating', 'datebook' );
		$single_names[ 'review_title' ]			 = esc_html__( 'Your Review Title', 'datebook' );
		$single_names[ 'review_text' ]			 = esc_html__( 'Your Review', 'datebook' );
		$single_names[ 'reviews_closed' ]		 = esc_html__( 'Reviews are closed.', 'datebook' );
		$single_names[ 'review_reply_title' ]	 = sprintf( esc_html__( 'Review %s.', 'datebook' ), '[product_name]' );
		$single_names[ 'review_submit_label' ]	 = esc_html__( 'Submit Review', 'datebook' );

		return $single_names;
	}


	public static function datebook_reviews_get_reviews_labels() {
		$labels = self::datebook_reviews_standard_labels();

		return $labels;
	}


	public static function datebook_review_rating_html() {

		$labels = self::datebook_reviews_get_reviews_labels();
		return '<p class="datebook-review-rating allow-edit"><label class="rating-label" for="datebook_review_rating">' . $labels[ 'rating_tite' ] . ':</label><input type="hidden" name="datebook_review_rating"> <span class="datebook-rate-star rate-1" data-rating="1"></span><span class="datebook-rate-star rate-2" data-rating="2"></span><span class="datebook-rate-star rate-3" data-rating="3"></span><span class="datebook-rate-star rate-4" data-rating="4"></span><span class="datebook-rate-star rate-5" data-rating="5"></span></p>';

	}


	/**
	 * Defines stars labels
	 */
	public static function datebook_reviews_get_stars_label( $key ) {
		switch ( $key ) {
			case 1:
				$label = '1 ' . esc_html__( 'star', 'datebook' );
				break;
			case 2:
				$label = '2 ' . esc_html__( 'stars', 'datebook' );
				break;
			case 3:
				$label = '3 ' . esc_html__( 'stars', 'datebook' );
				break;
			case 4:
				$label = '4 ' . esc_html__( 'stars', 'datebook' );
				break;
			case 5:
				$label = '5 ' . esc_html__( 'stars', 'datebook' );
				break;
		}
		return $label;
	}


	public static function datebook_reviews_stars_qty_graph( $el_total, $total ) {
		$html		 = '';
		$percentage	 = 0;
		if ( !empty( $total ) ) {
			$percentage = number_format( ($el_total / $total) * 100 );
		}
		$html = '<div class="graph-container"><span class="datebook-grey-graph"><span class="datebook-orange-graph" style="width:' . $percentage . '%"></span></span></div>';
		return $html;
	}


	public static function datebook_reviews_get_totals_html($product_id) {
	
		$totals = self::datebook_reviews_get_totals( $product_id );
		$total_summary = $totals[ 'total' ];
		if ( empty( $total_summary ) ) {
			return;
		}

		$html = '';
		//$html .= '<span class="review-totals">';

		unset( $totals[ 'total' ] );
		unset( $totals[ 0 ] );
		krsort( $totals );

		$total_achieved	 = 0;
		//$reviews_break	 = '<span class="datebook-reviews-break">';

		foreach ( $totals as $key => $total ) {
			$stars_label = self::datebook_reviews_get_stars_label( $key );
			//$reviews_break .= '<div class="review-total-' . $key . ' datebook-review-total-row"><span class="stars-count">' . $stars_label . '</span> ' . self::datebook_reviews_stars_qty_graph( $total, $total_summary ) . ' <span class="row-total">' . $total . '</span></div>';
			$total_achieved	 += $key * $total;
		}

		//$reviews_break .= '</span>';
		$html .= '<span class="small text-grey ml-2 reviews-summary">';

		if ( !empty( $total_summary ) ) {
			$max = $total_summary * 5;
			$total_score = number_format( ($total_achieved / $max) * 5, 1 );
			$html .= sprintf( esc_html__( '%s average based on %s ratings', 'datebook' ), '<span itemprop="ratingValue">' . $total_score . '</span>', '<span itemprop="ratingCount">' . $total_summary . '</span>' );
		}

		$html .= '</span>';
		//$html .= $reviews_break;
		//$html .= '</span>';

		return $html;

	}


	public static function datebook_reviews_navigation( $where = 'above' ) {
		if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) {
			?>
			<nav id="review-nav-<?php echo $where ?>" class="review-navigation" role="navigation">
				<h1 class="screen-reader-text"><?php esc_html_e( 'Reviews navigation', 'datebook' ); ?></h1>
				<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Reviews', 'datebook' ) ); ?></div>
				<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Reviews &rarr;', 'datebook' ) ); ?></div>
			</nav><!-- #review-nav-above -->
			<?php
		}
	}


	public static function return_reviews_list() {

		$layout = '';

		if (isset($_POST['action']) && $_POST['action'] == 'submit_review') {

			$layout .= self::datebook_reviews_save_rating();

		}

		if (isset($_GET['action']) && $_GET['action'] == 'deletereview' && isset($_GET['sid']) && absint($_GET['sid']) > 0) {
			// update all the input data
			$layout .= self::datebook_delete_review();
		}

		$layout .= DateBook_Template_Loader::load( 'comments/reviews' );
		
		return $layout;

	}


	/**
	 * Override default comments template
	 */
	public static function return_reviews() {

		$layout = '';

		// Display ratings
		$layout .= self::datebook_reviews_navigation();
		// display the review form
		$layout .= self::return_reviews_list();
		$layout .= self::datebook_reviews_navigation( 'below' );
		
		return $layout;

	}


	/**
	 * Override default comments template
	 */
	public static function datebook_reviews_replace_default_comments_form() {

		// Display ratings
		echo self::return_reviews();

	}
	

}

//DateBook_Class_Reviews::init();
$dateBook_class_reviews_class = new DateBook_Class_Reviews($datebook_options_array);