<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Sidebars
 *
 * @class DateBook_Sidebars
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Sidebars {


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_sidebar_edit', array( __CLASS__, 'datebook_show_sidebar_edit' ) );

	}


	/**
	 * Show sidebar for logged in users on Profile Edit page
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_show_sidebar_edit() {

		// display the Edit Profile form
		echo DateBook_Template_Loader::load( 'misc/profile-sidebar' );

	}

}

DateBook_Sidebars::init();