<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Utilities
 *
 * @class DateBook_Utilities
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Social {


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {
		
		add_action( 'datebook_sociallinks', array( __CLASS__, 'sociallinks' ) );

	}


	/**
	 * Show microformats for social newtworks
	 *
	 * @access public
	 * @return void
	 */
	public static function microformats($options){

		// display the Edit Profile form
		echo DateBook_Template_Loader::load( 'misc/microformats', $options );

	}


	/**
	 * Show social links
	 *
	 * @access public
	 * @return void
	 */
	public static function sociallinks() {

		// display the Edit Profile form
		echo DateBook_Template_Loader::load( 'misc/social-links' );

	}

}

DateBook_Social::init();