<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Template_Loader
 *
 * @class DateBook_Template_Loader
 * @package DateBook/Classes
 * @author Pagick Themes
 */
class DateBook_Template_Loader {


	/**
	 * Initialize template loader
	 *
	 * @access public
	 * @return void
	 */
	public static function init() {

		add_filter( 'template_include', array( __CLASS__, 'datebook_templates' ) );

	}


	/**
	 * Default templates
	 *
	 * @access public
	 * @param $template
	 * @return string
	 * @throws Exception
	 */
	public static function datebook_templates( $template ) {
		$post_type = get_post_type();
		$custom_post_types = array( DATEBOOK_POST_TYPE, DATEBOOK_COMMENT_TYPE, DATEBOOK_TOUR_TYPE, DATEBOOK_CLASSIFIEDS_TYPE );


		if ( in_array( $post_type, $custom_post_types ) ) {
			if ( is_archive() ) {
				if ( is_tax() ) {
					return self::locate( 'taxonomy-' . get_query_var( 'taxonomy' ) );	
				}

				return self::locate( 'archive-' . $post_type );
			}

			if ( is_single() ) {
				return self::locate( 'single-' . $post_type );
			}
		}

		return $template;
	}


	/**
	 * Gets template path
	 *
	 * @access public
	 * @param $name
	 * @param $plugin_dir
	 * @return string
	 * @throws Exception
	 */
	public static function locate( $name, $plugin_dir = DATEBOOK_DIR ) {
		$template = '';

		// Current theme base dir
		if ( ! empty( $name ) ) {
			$template = locate_template( "{$name}.php" );
		}

		// Child theme
		if ( ! $template && ! empty( $name ) && file_exists( get_stylesheet_directory() . "/templates/{$name}.php" ) ) {
			$template = get_stylesheet_directory() . "/templates/{$name}.php";
		}

		// Original theme
		if ( ! $template && ! empty( $name ) && file_exists( get_template_directory() . "/templates/{$name}.php" ) ) {
			$template = get_template_directory() . "/templates/{$name}.php";
		}

		// Plugin
		if ( ! $template && ! empty( $name ) && file_exists( $plugin_dir . "/templates/{$name}.php" ) ) {
			$template = $plugin_dir . "templates/{$name}.php";
		}

		// Nothing found
		if ( empty( $template ) ) {
			throw new Exception( "Template /templates/{$name}.php in plugin dir {$plugin_dir} not found." );
		}

		return $template;
	}


	/**
	 * Loads template content
	 *
	 * @param string $name
	 * @param array  $args
	 * @param string $plugin_dir
	 * @return string
	 * @throws Exception
	 */
	public static function load( $name, $args = array(), $plugin_dir = DATEBOOK_DIR ) {
		if ( is_array( $args ) && count( $args ) > 0 ) {
			extract( $args, EXTR_SKIP );
		}
		
		$path = self::locate( $name, $plugin_dir );
		ob_start();
		include $path;
		$result = ob_get_contents();
		ob_end_clean();
		return $result;
	}

}

DateBook_Template_Loader::init();